/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.script.generator.dml.ColumnsOrderBy;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.PlainOrderBy;
import com.intellij.database.script.generator.dml.PlainWhereClause;
import com.intellij.database.script.generator.dml.PredicatesWhereClause;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DdlBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b\u001a^\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2&\u0010\u0012\u001a\"\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0013j\u0004\u0018\u0001`\u0017H\u0002\u001at\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000e2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2&\u0010\u0012\u001a\"\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0013j\u0004\u0018\u0001`\u0017H\u0002\u001a\u001e\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u000b\u001a \u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u000bH\u0002\u001a \u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020 2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u000bH\u0002\u001a3\u0010!\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u00112\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010%\u00a2\u0006\u0002\b&\u001a#\u0010'\u001a\u00020\u0001*\u00020\u00072\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010%\u00a2\u0006\u0002\b&\u001a\u0012\u0010(\u001a\u00020\u0001*\u00020\u00072\u0006\u0010)\u001a\u00020\u0011\u00a8\u0006*"}, d2={"generateWhere", "", "dbms", "Lcom/intellij/database/Dbms;", "whereClause", "Lcom/intellij/database/script/generator/dml/WhereClause;", "builder", "Lcom/intellij/database/util/DdlBuilder;", "task", "Lcom/intellij/database/script/generator/dml/DmlTask;", "printWhereKeyword", "", "insertNewLines", "predicates", "", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "op", "", "processor", "Lkotlin/Function3;", "Lcom/intellij/database/data/types/ColumnRef;", "Lcom/intellij/database/data/types/PredicateValue;", "Lcom/intellij/database/data/types/PredicateOperation;", "Lcom/intellij/database/script/generator/dml/ColumnValueConsumer;", "opInner", "opOuter", "newLineBeforeOuterOp", "generateOrderBy", "orderBy", "Lcom/intellij/database/script/generator/dml/OrderBy;", "printOrderByKeyword", "Lcom/intellij/database/script/generator/dml/ColumnsOrderBy;", "Lcom/intellij/database/script/generator/dml/PlainOrderBy;", "scope", "opening", "closing", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "braces", "singleQuoted", "name", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/database/dialects/base/generator/dml/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1869#2,2:89\n*S KotlinDebug\n*F\n+ 1 util.kt\ncom/intellij/database/dialects/base/generator/dml/UtilKt\n*L\n42#1:89,2\n*E\n"})
public final class UtilKt {
    public static final void generateWhere(@NotNull Dbms dbms, @Nullable WhereClause whereClause, @NotNull DdlBuilder builder, @NotNull DmlTask<?> task, boolean printWhereKeyword) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        WhereClause whereClause2 = whereClause;
        if (whereClause2 instanceof ValuesWhereClause) {
            List<List<PredicatesHelper.PredicateProducer>> predicates = ((ValuesWhereClause)whereClause).getPredicates(dbms, DmlTaskKt.getTableAlias(task), DmlTaskKt.getVersion(task), DmlTaskKt.inUpdate(task));
            UtilKt.generateWhere(builder, DmlTaskKt.insertNewLines(task), predicates, ((ValuesWhereClause)whereClause).getOpInner(), ((ValuesWhereClause)whereClause).getOpOuter(), ((ValuesWhereClause)whereClause).getNewLineBeforeOuterOp(), printWhereKeyword, ((ValuesWhereClause)whereClause).getProcessor());
        } else if (whereClause2 instanceof PredicatesWhereClause) {
            UtilKt.generateWhere(builder, DmlTaskKt.insertNewLines(task), ((PredicatesWhereClause)whereClause).getPredicates(), ((PredicatesWhereClause)whereClause).getOp(), printWhereKeyword, ((PredicatesWhereClause)whereClause).getProcessor());
        } else if (whereClause2 instanceof PlainWhereClause) {
            if (StringsKt.isBlank((CharSequence)((PlainWhereClause)whereClause).getFilter())) {
                return;
            }
            if (printWhereKeyword) {
                builder.keyword("WHERE");
            }
            DdlBuilder ddlBuilder = builder.space().plain(((PlainWhereClause)whereClause).getFilter());
            Intrinsics.checkNotNull((Object)ddlBuilder);
        }
    }

    private static final void generateWhere(DdlBuilder builder, boolean insertNewLines, List<PredicatesHelper.PredicateProducer> predicates, String op, boolean printWhereKeyword, Function3<? super ColumnRef, ? super PredicateValue, ? super PredicateOperation, Unit> processor) {
        UtilKt.generateWhere(builder, insertNewLines, CollectionsKt.listOf(predicates), op, "OR", false, printWhereKeyword, processor);
    }

    private static final void generateWhere(DdlBuilder builder, boolean insertNewLines, List<? extends List<PredicatesHelper.PredicateProducer>> predicates, String opInner, String opOuter, boolean newLineBeforeOuterOp, boolean printWhereKeyword, Function3<? super ColumnRef, ? super PredicateValue, ? super PredicateOperation, Unit> processor) {
        if (predicates.isEmpty()) {
            return;
        }
        if (printWhereKeyword) {
            builder.keyword("WHERE").space();
        }
        boolean firstOuter = true;
        for (List<PredicatesHelper.PredicateProducer> list : predicates) {
            if (firstOuter) {
                firstOuter = false;
                v0 = Unit.INSTANCE;
            } else {
                DdlBuilder ddlBuilder = DmlUtilKt.space(builder, insertNewLines || newLineBeforeOuterOp).keyword(opOuter).space();
                v0 = ddlBuilder;
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
            }
            boolean firstInner = true;
            for (PredicatesHelper.PredicateProducer predicate : list) {
                if (firstInner) {
                    firstInner = false;
                    v2 = Unit.INSTANCE;
                } else {
                    DdlBuilder ddlBuilder = DmlUtilKt.space(builder, insertNewLines).keyword(opInner).space();
                    v2 = ddlBuilder;
                    Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
                }
                if (processor != null) {
                    Iterable $this$forEach$iv = predicate.getColumnRefs();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ColumnRef it = (ColumnRef)element$iv;
                        boolean bl = false;
                        processor.invoke((Object)it, (Object)predicate.getValue(), (Object)predicate.getOperation());
                    }
                }
                predicate.getProduce().invoke((Object)builder);
            }
        }
    }

    public static final void generateOrderBy(@NotNull OrderBy orderBy, @NotNull DdlBuilder builder, boolean printOrderByKeyword) {
        Intrinsics.checkNotNullParameter((Object)orderBy, (String)"orderBy");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        OrderBy orderBy2 = orderBy;
        if (orderBy2 instanceof ColumnsOrderBy) {
            UtilKt.generateOrderBy((ColumnsOrderBy)orderBy, builder, printOrderByKeyword);
        } else if (orderBy2 instanceof PlainOrderBy) {
            UtilKt.generateOrderBy((PlainOrderBy)orderBy, builder, printOrderByKeyword);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void generateOrderBy(ColumnsOrderBy orderBy, DdlBuilder builder, boolean printOrderByKeyword) {
        boolean first2 = true;
        for (Pair<String, RowSortOrder.Type> pair : orderBy.getColumns()) {
            String name2 = (String)pair.component1();
            RowSortOrder.Type order = (RowSortOrder.Type)pair.component2();
            if (first2) {
                if (printOrderByKeyword) {
                    String[] stringArray = new String[]{"ORDER", "BY"};
                    builder.keywords(stringArray).space();
                }
                first2 = false;
                v0 = Unit.INSTANCE;
            } else {
                DdlBuilder ddlBuilder = builder.symbol(",").space();
                v0 = ddlBuilder;
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
            }
            builder.columnRef(name2);
            if (order == RowSortOrder.Type.ASC) continue;
            builder.space().keyword(order.toString());
        }
    }

    private static final void generateOrderBy(PlainOrderBy orderBy, DdlBuilder builder, boolean printOrderByKeyword) {
        if (StringsKt.isBlank((CharSequence)orderBy.getText())) {
            return;
        }
        if (printOrderByKeyword) {
            String[] stringArray = new String[]{"ORDER", "BY"};
            builder.keywords(stringArray).space();
        }
        builder.plain(orderBy.getText());
    }

    public static final void scope(@NotNull DdlBuilder $this$scope, @NotNull String opening, @NotNull String closing, @NotNull Function1<? super DdlBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$scope, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)opening, (String)"opening");
        Intrinsics.checkNotNullParameter((Object)closing, (String)"closing");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        $this$scope.plain(opening);
        block.invoke((Object)$this$scope);
        $this$scope.plain(closing);
    }

    public static final void braces(@NotNull DdlBuilder $this$braces, @NotNull Function1<? super DdlBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$braces, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        UtilKt.scope($this$braces, "{", "}", block);
    }

    public static final void singleQuoted(@NotNull DdlBuilder $this$singleQuoted, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$singleQuoted, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        UtilKt.scope($this$singleQuoted, "'", "'", (Function1<? super DdlBuilder, Unit>)((Function1)arg_0 -> UtilKt.singleQuoted$lambda$1(name2, arg_0)));
    }

    private static final Unit singleQuoted$lambda$1(String $name, DdlBuilder $this$scope) {
        Intrinsics.checkNotNullParameter((Object)$this$scope, (String)"$this$scope");
        $this$scope.plain(StringsKt.replace$default((String)$name, (String)"'", (String)"''", (boolean)false, (int)4, null));
        return Unit.INSTANCE;
    }
}

