/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramBuilderFactory;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramItemOrderingManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeBase;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationships;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.builder.edges.CollapsedEdge;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.NodeLayout;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.threading.GraphActionExecutor;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.uml.DiagramGraphBuilderDataModelAdapter;
import com.intellij.uml.DiagramGraphBuilderPresentationModelAdapter;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class DiagramGraphBuilderAdapter<N, E>
implements DiagramBuilder {
    @NotNull
    private final GraphBuilder<N, E> myDelegate;
    @NotNull
    private final DiagramDataModel<?> myDataModel;
    @NotNull
    private final DiagramPresentationModel myPresentationModel;
    @NotNull
    private final DiagramProvider<?> myProvider;
    @NotNull
    private final Function<N, DiagramNode<?>> myNodeAdapter;
    @NotNull
    private final Function<E, DiagramEdge<?>> myEdgeAdapter;
    @NotNull
    private final BidirectionalMap<N, DiagramNode<?>> myNodesMapping;
    @NotNull
    private final BidirectionalMap<E, DiagramEdge<?>> myEdgesMapping;
    private boolean myDoAllowEdgeCreation;
    private boolean myIsPopupMode;

    DiagramGraphBuilderAdapter(@NotNull GraphBuilder<N, E> delegate, @NotNull DiagramProvider<?> provider, @Nullable Function<N, DiagramNode<?>> nodeAdapter, @Nullable Function<E, DiagramEdge<?>> edgeAdapter, @Nullable DiagramVisibilityManager visibilityManager, @Nullable DiagramItemOrderingManager orderingManager, @Nullable DiagramScopeManager<?> scopeManager, @Nullable DiagramNodeContentManager nodeContentManager) {
        if (delegate == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(1);
        }
        this.myNodesMapping = new BidirectionalMap();
        this.myEdgesMapping = new BidirectionalMap();
        this.myDoAllowEdgeCreation = false;
        this.myIsPopupMode = false;
        this.myDelegate = delegate;
        this.myProvider = provider;
        this.myNodeAdapter = Objects.requireNonNullElseGet(nodeAdapter, this::createDefaultNodeAdapter);
        this.myEdgeAdapter = Objects.requireNonNullElseGet(edgeAdapter, this::createDefaultEdgeAdapter);
        this.myDataModel = new DiagramGraphBuilderDataModelAdapter(this, provider, visibilityManager, orderingManager, scopeManager, nodeContentManager);
        this.myDataModel.putUserData(DiagramDataKeys.GRAPH_BUILDER, this);
        this.myPresentationModel = new DiagramGraphBuilderPresentationModelAdapter(this, delegate.getGraph());
        this.myPresentationModel.setGraphBuilder(delegate);
    }

    @NotNull
    private Function<N, DiagramNode<?>> createDefaultNodeAdapter() {
        Function<Object, DiagramNode> function = x$0 -> new MyNodeAdapter(x$0);
        if (function == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(2);
        }
        return function;
    }

    @NotNull
    private Function<E, DiagramEdge<?>> createDefaultEdgeAdapter() {
        Function<Object, DiagramEdge> function = x$0 -> new MyEdgeAdapter(x$0);
        if (function == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(3);
        }
        return function;
    }

    @NotNull
    public GraphBuilder<N, E> getDelegate() {
        GraphBuilder<N, E> graphBuilder = this.myDelegate;
        if (graphBuilder == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(4);
        }
        return graphBuilder;
    }

    public void dispose() {
        Disposer.dispose(this.myDelegate);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(5);
        }
        return (T)this.myDelegate.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(6);
        }
        this.myDelegate.putUserData(key, value);
    }

    @Override
    @NotNull
    public GraphActionExecutor getActionExecutor() {
        GraphActionExecutor graphActionExecutor = this.myDelegate.getActionExecutor();
        if (graphActionExecutor == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(7);
        }
        return graphActionExecutor;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myDelegate.getProject();
        if (project == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(8);
        }
        return project;
    }

    @Override
    @NotNull
    public Graph2D getGraph() {
        Graph2D graph2D = this.myDelegate.getGraph();
        if (graph2D == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(9);
        }
        return graph2D;
    }

    @Override
    @NotNull
    public Graph2DView getView() {
        Graph2DView graph2DView = this.myDelegate.getView();
        if (graph2DView == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(10);
        }
        return graph2DView;
    }

    @Override
    public @Unmodifiable @NotNull Collection<DiagramNode<?>> getNodeObjects() {
        List list = ContainerUtil.map((Object[])this.myDelegate.getGraph().getNodeArray(), this::getNodeObject);
        if (list == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @Nullable
    public Node getNode(DiagramNode<?> node) {
        return Optional.ofNullable(this.myNodesMapping.getKeysByValue(node)).map(it -> this.myDelegate.getNode(it.get(0))).orElseGet(() -> this.getGraphBuilder().getNode((Object)node));
    }

    @Nullable
    public N getDelegateNode(DiagramNode<?> node) {
        return (N)Optional.ofNullable(this.myNodesMapping.getKeysByValue(node)).map(it -> it.get(0)).orElseGet(() -> this.myDelegate.getNodeObject(this.getGraphBuilder().getNode((Object)node)));
    }

    @Override
    @Nullable
    public DiagramNode<?> getNodeObject(Node node) {
        return (DiagramNode)this.myNodesMapping.computeIfAbsent(this.myDelegate.getNodeObject(node), this.myNodeAdapter);
    }

    @Override
    public @Unmodifiable @NotNull Collection<DiagramEdge<?>> getEdgeObjects() {
        List list = ContainerUtil.map((Object[])this.myDelegate.getGraph().getEdgeArray(), this::getEdgeObject);
        if (list == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @Nullable
    public Edge getEdge(DiagramEdge<?> edge) {
        return Optional.ofNullable(this.myEdgesMapping.getKeysByValue(edge)).map(it -> this.myDelegate.getEdge(it.get(0))).orElseGet(() -> this.getGraphBuilder().getEdge((Object)edge));
    }

    @Nullable
    public E getDelegateEdge(DiagramEdge<?> edge) {
        return (E)Optional.ofNullable(this.myEdgesMapping.getKeysByValue(edge)).map(it -> it.get(0)).orElseGet(() -> this.myDelegate.getEdgeObject(this.getGraphBuilder().getEdge((Object)edge)));
    }

    @Override
    @Nullable
    public DiagramEdge<?> getEdgeObject(Edge edge) {
        return (DiagramEdge)this.myEdgesMapping.computeIfAbsent(this.myDelegate.getEdgeObject(edge), this.myEdgeAdapter);
    }

    @Override
    @Nullable
    public Node getGroupNode(NodeGroupDescriptor groupDescriptor) {
        return this.myDelegate.getGroupNode(groupDescriptor);
    }

    @Override
    @Nullable
    public NodeGroupDescriptor getGroupNodeObject(Node node) {
        return this.myDelegate.getGroupNodeObject(node);
    }

    @Override
    @NotNull
    public Collection<NodeGroupDescriptor> getGroupNodeObjects() {
        Collection collection = this.myDelegate.getGroupNodeObjects();
        if (collection == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Override
    @Nullable
    public Edge getCollapsedEdge(CollapsedEdge collapsedEdge) {
        return this.myDelegate.getCollapsedEdge(collapsedEdge);
    }

    @Override
    @Nullable
    public CollapsedEdge getCollapsedEdgeObject(Edge edge) {
        return this.myDelegate.getCollapsedEdgeObject(edge);
    }

    @Override
    @NotNull
    public Collection<CollapsedEdge> getCollapsedEdgeObjects() {
        Collection collection = this.myDelegate.getCollapsedEdgeObjects();
        if (collection == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @Override
    public boolean doAllowEdgeCreation() {
        return this.myDoAllowEdgeCreation;
    }

    @Override
    public void setAllowEdgeCreation(boolean allow) {
        this.myDoAllowEdgeCreation = allow;
    }

    @Override
    @NotNull
    public DiagramState getPresentation() {
        DiagramState diagramState = DiagramState.empty(this.myProvider);
        if (diagramState == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(15);
        }
        return diagramState;
    }

    @Override
    @NotNull
    public DiagramPresentationModel getPresentationModel() {
        DiagramPresentationModel diagramPresentationModel = this.myPresentationModel;
        if (diagramPresentationModel == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(16);
        }
        return diagramPresentationModel;
    }

    @Override
    @NotNull
    public DiagramDataModel<?> getDataModel() {
        DiagramBuilder modelBuilder = DiagramBuilderFactory.getInstance().getModelBuilder(this);
        if (modelBuilder != this) {
            DiagramDataModel<?> diagramDataModel = modelBuilder.getDataModel();
            if (diagramDataModel == null) {
                DiagramGraphBuilderAdapter.$$$reportNull$$$0(17);
            }
            return diagramDataModel;
        }
        DiagramDataModel<?> diagramDataModel = this.myDataModel;
        if (diagramDataModel == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(18);
        }
        return diagramDataModel;
    }

    @Override
    @NotNull
    public DiagramProvider<?> getProvider() {
        DiagramProvider<?> diagramProvider = this.myProvider;
        if (diagramProvider == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(19);
        }
        return diagramProvider;
    }

    @Override
    @Nullable
    public DiagramFileEditor getEditor() {
        return this.getUserData(DiagramDataKeys.UML_FILE_EDITOR);
    }

    @Override
    public void setEditor(@NotNull DiagramFileEditor editor) {
        if (editor == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(20);
        }
        this.putUserData(DiagramDataKeys.UML_FILE_EDITOR, editor);
        editor.putUserData(DiagramDataKeys.GRAPH_BUILDER, this);
    }

    @Override
    @Nullable
    public DocumentReference getDocumentReference() {
        DiagramFileEditor editor = this.getEditor();
        return editor != null ? (DocumentReference)editor.getDocumentReferences().iterator().next() : null;
    }

    @Override
    @NotNull
    public DiagramBuilder.DiagramUpdateQueryParams queryUpdate() {
        return new GraphUpdateQueryParamsAdapter(this.myDelegate.queryGraphUpdate());
    }

    @Override
    public void update(boolean increaseModTrackerCounter, boolean updateLayout) {
        if (increaseModTrackerCounter) {
            this.getPresentationModel().update();
        }
        this.updateGraph();
        if (updateLayout) {
            JBPopup popup;
            this.relayout();
            if (this.isPopupMode() && (popup = this.getUserData(DiagramDataKeys.UML_POPUP)) != null && !popup.isDisposed()) {
                GraphCanvasLocationService.getInstance().setBestPopupSizeForGraph(popup, this.myDelegate);
            }
            this.getGraph().updateViews();
        }
    }

    @Override
    public boolean isPopupMode() {
        return this.myIsPopupMode;
    }

    void setPopupMode(boolean popupMode) {
        this.myIsPopupMode = popupMode;
    }

    @Override
    @Nullable
    public JBPopup getPopup() {
        return this.getUserData(DiagramDataKeys.UML_POPUP);
    }

    @Override
    public void setPopup(@NotNull JBPopup popup) {
        if (popup == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(21);
        }
        this.putUserData(DiagramDataKeys.UML_POPUP, popup);
        this.setPopupMode(true);
    }

    @Override
    public void relayout() {
        GraphLayoutService.getInstance().queryLayout(this.myDelegate).run();
    }

    @Override
    public void updateGraph() {
        this.myDelegate.updateGraph();
    }

    @Override
    public void initialize() {
        this.myDelegate.initialize();
    }

    @Override
    public void updateView() {
        this.myDelegate.updateView();
    }

    @Override
    public void createDraggedNode(@NotNull DiagramNode<?> node, @Nullable String nodeName, @NotNull Point point) {
        NodeLayout nodeLayout;
        if (node == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(22);
        }
        if (point == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(23);
        }
        Node nodeObj = NodeFactory.getInstance().createDraggedNode(this.myDelegate, this.myDelegate.getNodeObject(this.getNode(node)), node.getTooltip(), point);
        this.getDataModel().refreshDataModel();
        if (nodeObj != null && (nodeLayout = this.getGraph().getNodeLayout((Object)nodeObj)) != null) {
            nodeLayout.setLocation((double)point.x, (double)point.y);
        }
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.getView().getCanvasComponent(), true);
    }

    @Override
    public double getZoom() {
        return this.myDelegate.getZoom();
    }

    @Override
    public void setZoom(double scale) {
        this.myDelegate.setZoom(scale);
    }

    @Override
    public void notifyOtherBuilders() {
        DiagramBuilder modelBuilder = DiagramBuilderFactory.getInstance().getModelBuilder(this);
        if (modelBuilder != this) {
            modelBuilder.notifyOtherBuilders();
        }
    }

    @Override
    @NotNull
    public GraphBuilder<DiagramNode<?>, DiagramEdge<?>> getGraphBuilder() {
        GraphBuilder<N, E> graphBuilder = this.myDelegate;
        if (graphBuilder == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(24);
        }
        return graphBuilder;
    }

    @Override
    @NotNull
    public EditorColorsScheme getColorScheme() {
        if (GraphExportService.getInstance().isPrintMode()) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getDefaultScheme();
            if (editorColorsScheme == null) {
                DiagramGraphBuilderAdapter.$$$reportNull$$$0(25);
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            DiagramGraphBuilderAdapter.$$$reportNull$$$0(26);
        }
        return editorColorsScheme;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 24, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/DiagramGraphBuilderAdapter";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/DiagramGraphBuilderAdapter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultNodeAdapter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultEdgeAdapter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionExecutor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeObjects";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeObjects";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupNodeObjects";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollapsedEdgeObjects";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationModel";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphBuilder";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setPopup";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createDraggedNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 24, 25, 26 -> new IllegalStateException(string);
        };
    }

    private final class GraphUpdateQueryParamsAdapter
    implements DiagramBuilder.DiagramUpdateQueryParams {
        @NotNull
        private final GraphBuilder.GraphUpdateQueryParams myDelegate;
        private boolean myDoReloadData;
        private boolean myDoPresentationUpdate;
        @Nullable
        private Layouter myLayouter;
        @NotNull
        private final List<DiagramNode<?>> myNodesForSizeUpdate;

        private GraphUpdateQueryParamsAdapter(GraphBuilder.GraphUpdateQueryParams delegate) {
            if (delegate == null) {
                GraphUpdateQueryParamsAdapter.$$$reportNull$$$0(0);
            }
            this.myNodesForSizeUpdate = new ArrayList();
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public GraphUpdateQueryParamsAdapter withDataReload() {
            this.myDelegate.withDataReload();
            this.myDoReloadData = true;
            GraphUpdateQueryParamsAdapter graphUpdateQueryParamsAdapter = this;
            if (graphUpdateQueryParamsAdapter == null) {
                GraphUpdateQueryParamsAdapter.$$$reportNull$$$0(1);
            }
            return graphUpdateQueryParamsAdapter;
        }

        @Override
        @NotNull
        public GraphUpdateQueryParamsAdapter withRelayout() {
            this.myDelegate.withRelayout();
            this.myLayouter = DiagramGraphBuilderAdapter.this.getPresentationModel().getSettings().getCurrentLayouter();
            GraphUpdateQueryParamsAdapter graphUpdateQueryParamsAdapter = this;
            if (graphUpdateQueryParamsAdapter == null) {
                GraphUpdateQueryParamsAdapter.$$$reportNull$$$0(2);
            }
            return graphUpdateQueryParamsAdapter;
        }

        @Override
        @NotNull
        public GraphUpdateQueryParamsAdapter withRelayout(@NotNull Layouter layouter) {
            if (layouter == null) {
                GraphUpdateQueryParamsAdapter.$$$reportNull$$$0(3);
            }
            this.myDelegate.withRelayout(layouter);
            this.myLayouter = layouter;
            GraphUpdateQueryParamsAdapter graphUpdateQueryParamsAdapter = this;
            if (graphUpdateQueryParamsAdapter == null) {
                GraphUpdateQueryParamsAdapter.$$$reportNull$$$0(4);
            }
            return graphUpdateQueryParamsAdapter;
        }

        @Override
        @NotNull
        public GraphUpdateQueryParamsAdapter withPresentationUpdate() {
            this.myDoPresentationUpdate = true;
            GraphUpdateQueryParamsAdapter graphUpdateQueryParamsAdapter = this;
            if (graphUpdateQueryParamsAdapter == null) {
                GraphUpdateQueryParamsAdapter.$$$reportNull$$$0(5);
            }
            return graphUpdateQueryParamsAdapter;
        }

        @Override
        @NotNull
        public GraphUpdateQueryParamsAdapter withAllNodeSizeUpdate() {
            this.myDelegate.withAllNodeSizeUpdate();
            ContainerUtil.addAll(this.myNodesForSizeUpdate, (Iterable)((Iterable)ReadAction.compute(() -> DiagramGraphBuilderAdapter.this.getNodeObjects())));
            GraphUpdateQueryParamsAdapter graphUpdateQueryParamsAdapter = this;
            if (graphUpdateQueryParamsAdapter == null) {
                GraphUpdateQueryParamsAdapter.$$$reportNull$$$0(6);
            }
            return graphUpdateQueryParamsAdapter;
        }

        @Override
        @NotNull
        public DiagramBuilder.DiagramUpdateQueryParams withNodeSizeUpdate(DiagramNode<?> ... nodesForSizeUpdate) {
            if (nodesForSizeUpdate == null) {
                GraphUpdateQueryParamsAdapter.$$$reportNull$$$0(7);
            }
            this.myDelegate.withNodeSizeUpdate(new Object[]{ContainerUtil.map((Object[])nodesForSizeUpdate, DiagramGraphBuilderAdapter.this::getDelegateNode)});
            ContainerUtil.addAll(this.myNodesForSizeUpdate, (Object[])nodesForSizeUpdate);
            GraphUpdateQueryParamsAdapter graphUpdateQueryParamsAdapter = this;
            if (graphUpdateQueryParamsAdapter == null) {
                GraphUpdateQueryParamsAdapter.$$$reportNull$$$0(8);
            }
            return graphUpdateQueryParamsAdapter;
        }

        @Override
        public void run() {
            if (this.myDoPresentationUpdate) {
                DiagramGraphBuilderAdapter.this.getPresentationModel().update();
            }
            this.myDelegate.run();
        }

        @Override
        @NotNull
        public CompletableFuture<Void> runAsync() {
            if (this.myDoPresentationUpdate) {
                DiagramGraphBuilderAdapter.this.getPresentationModel().update();
            }
            CompletableFuture completableFuture = this.myDelegate.runAsync();
            if (completableFuture == null) {
                GraphUpdateQueryParamsAdapter.$$$reportNull$$$0(9);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public DiagramBuilder.DiagramUpdateQueryParams endQuery() {
            GraphUpdateQueryParamsAdapter graphUpdateQueryParamsAdapter = this;
            if (graphUpdateQueryParamsAdapter == null) {
                GraphUpdateQueryParamsAdapter.$$$reportNull$$$0(10);
            }
            return graphUpdateQueryParamsAdapter;
        }

        @Override
        public boolean doReloadData() {
            return this.myDoReloadData;
        }

        @Override
        public boolean doPresentationUpdate() {
            return this.myDoPresentationUpdate;
        }

        @Override
        @NotNull
        public Collection<DiagramNode<?>> getNodesForSizeUpdate() {
            List<DiagramNode<?>> list = this.myNodesForSizeUpdate;
            if (list == null) {
                GraphUpdateQueryParamsAdapter.$$$reportNull$$$0(11);
            }
            return list;
        }

        @Override
        @Nullable
        public Layouter getLayouter() {
            return this.myLayouter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 4, 5, 6, 8, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/DiagramGraphBuilderAdapter$GraphUpdateQueryParamsAdapter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layouter";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodesForSizeUpdate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/DiagramGraphBuilderAdapter$GraphUpdateQueryParamsAdapter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDataReload";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRelayout";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPresentationUpdate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAllNodeSizeUpdate";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withNodeSizeUpdate";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runAsync";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "endQuery";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodesForSizeUpdate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelayout";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "withNodeSizeUpdate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 4, 5, 6, 8, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }

    private final class MyEdgeAdapter
    extends DiagramEdgeBase<N> {
        MyEdgeAdapter(E edge) {
            if (edge == null) {
                MyEdgeAdapter.$$$reportNull$$$0(0);
            }
            super(new MyNodeAdapter(DiagramGraphBuilderAdapter.this.myDelegate.getGraphDataModel().getSourceNode(edge)), new MyNodeAdapter(DiagramGraphBuilderAdapter.this.myDelegate.getGraphDataModel().getTargetNode(edge)), DiagramRelationships.DEPENDENCY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/uml/DiagramGraphBuilderAdapter$MyEdgeAdapter", "<init>"));
        }
    }

    private final class MyNodeAdapter
    extends DiagramNodeBase<N> {
        @NotNull
        private final N myElement;

        private MyNodeAdapter(N element) {
            if (element == null) {
                MyNodeAdapter.$$$reportNull$$$0(0);
            }
            super(DiagramGraphBuilderAdapter.this.myProvider);
            this.myElement = element;
        }

        @Override
        @Nullable
        @Nls
        public String getTooltip() {
            return DiagramGraphBuilderAdapter.this.myDelegate.getGraphPresentationModel().getNodeTooltip(this.myElement);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return null;
        }

        @Override
        @NotNull
        public N getIdentifyingElement() {
            Object n = this.myElement;
            if (n == null) {
                MyNodeAdapter.$$$reportNull$$$0(1);
            }
            return n;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/DiagramGraphBuilderAdapter$MyNodeAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/DiagramGraphBuilderAdapter$MyNodeAdapter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIdentifyingElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

