/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0007J\u0006\u0010\u0010\u001a\u00020\u0007J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/javascript/service/JSTolerableTextChangeCandidate;", "", "offset", "", "fragment", "", "isInsert", "", "<init>", "(ILjava/lang/CharSequence;Z)V", "getOffset", "()I", "getFragment", "()Ljava/lang/CharSequence;", "()Z", "isEmpty", "isTolerable", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "intellij.javascript.impl"})
public final class JSTolerableTextChangeCandidate {
    private final int offset;
    @NotNull
    private final CharSequence fragment;
    private final boolean isInsert;

    public JSTolerableTextChangeCandidate(int offset, @NotNull CharSequence fragment, boolean isInsert) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.offset = offset;
        this.fragment = fragment;
        this.isInsert = isInsert;
    }

    public final int getOffset() {
        return this.offset;
    }

    @NotNull
    public final CharSequence getFragment() {
        return this.fragment;
    }

    public final boolean isInsert() {
        return this.isInsert;
    }

    public final boolean isEmpty() {
        return this.fragment.length() == 0;
    }

    public final boolean isTolerable() {
        char[] cArray = new char[]{' '};
        return StringsKt.trim((CharSequence)this.fragment, (char[])cArray).length() == 0 || BasicJavascriptNamesValidator.isIdentifierName(StringsKt.trim((CharSequence)this.fragment, (char[])(cArray = new char[]{' '})));
    }

    @NotNull
    public final TextRange getTextRange() {
        TextRange textRange = TextRange.from((int)this.offset, (int)this.fragment.length());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        return textRange;
    }

    public final int component1() {
        return this.offset;
    }

    @NotNull
    public final CharSequence component2() {
        return this.fragment;
    }

    public final boolean component3() {
        return this.isInsert;
    }

    @NotNull
    public final JSTolerableTextChangeCandidate copy(int offset, @NotNull CharSequence fragment, boolean isInsert) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        return new JSTolerableTextChangeCandidate(offset, fragment, isInsert);
    }

    public static /* synthetic */ JSTolerableTextChangeCandidate copy$default(JSTolerableTextChangeCandidate jSTolerableTextChangeCandidate, int n, CharSequence charSequence, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = jSTolerableTextChangeCandidate.offset;
        }
        if ((n2 & 2) != 0) {
            charSequence = jSTolerableTextChangeCandidate.fragment;
        }
        if ((n2 & 4) != 0) {
            bl = jSTolerableTextChangeCandidate.isInsert;
        }
        return jSTolerableTextChangeCandidate.copy(n, charSequence, bl);
    }

    @NotNull
    public String toString() {
        return "JSTolerableTextChangeCandidate(offset=" + this.offset + ", fragment=" + this.fragment + ", isInsert=" + this.isInsert + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.offset);
        result2 = result2 * 31 + this.fragment.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isInsert);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSTolerableTextChangeCandidate)) {
            return false;
        }
        JSTolerableTextChangeCandidate jSTolerableTextChangeCandidate = (JSTolerableTextChangeCandidate)other;
        if (this.offset != jSTolerableTextChangeCandidate.offset) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fragment, (Object)jSTolerableTextChangeCandidate.fragment)) {
            return false;
        }
        return this.isInsert == jSTolerableTextChangeCandidate.isInsert;
    }
}

