/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.javascript.macro.JSClassNameMacro;
import com.intellij.lang.javascript.macro.JSMacroUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSQualifiedClassNameMacro
extends Macro {
    @NonNls
    public String getName() {
        return "jsQualifiedClassName";
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context2) {
        String qName;
        if (params == null) {
            JSQualifiedClassNameMacro.$$$reportNull$$$0(0);
        }
        return (qName = JSQualifiedClassNameMacro.getQualifiedClassName(context2)) != null ? new TextResult(qName) : null;
    }

    @Nullable
    static String getQualifiedClassName(ExpressionContext context2) {
        PsiElement elementAtCaret = JSClassNameMacro.findElementAtCaret(context2);
        JSNamespace ns = JSContextResolver.resolveContext(elementAtCaret);
        String text = JSNamespace.getQualifiedName(ns);
        if (text == null) {
            JSFunction previousFunction = (JSFunction)PsiTreeUtil.getPrevSiblingOfType((PsiElement)elementAtCaret, JSFunction.class);
            if (previousFunction != null) {
                text = previousFunction.getName();
            } else {
                JSExpressionStatement expressionStatement = (JSExpressionStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)elementAtCaret, JSExpressionStatement.class);
                if (expressionStatement != null) {
                    JSExpression expression = expressionStatement.getExpression();
                    while (expression instanceof JSAssignmentExpression) {
                        expression = ((JSAssignmentExpression)expression).getLOperand();
                    }
                    if (expression instanceof JSDefinitionExpression) {
                        expression = ((JSDefinitionExpression)expression).getExpression();
                    }
                    if (expression instanceof JSReferenceExpression) {
                        expression = ((JSReferenceExpression)expression).getQualifier();
                    }
                    if (expression instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)expression).getReferencedName())) {
                        expression = ((JSReferenceExpression)expression).getQualifier();
                    }
                    if (expression instanceof JSReferenceExpression) {
                        return expression.getText();
                    }
                }
            }
        }
        return text;
    }

    public boolean isAcceptableInContext(TemplateContextType context2) {
        return JSMacroUtil.isJSLikeContext(context2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/lang/javascript/macro/JSQualifiedClassNameMacro", "calculateResult"));
    }
}

