/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u00044567B\"\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u0003J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\n\u0010 \u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J*\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00032\b\u0010%\u001a\u0004\u0018\u00010\u00122\u0006\u0010&\u001a\u00020\u0015H\u0002J\u0012\u0010'\u001a\u00020\u00032\b\u0010(\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010)\u001a\u00020#H\u0002J\u0010\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020\u0012H\u0002J\u0010\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020-H\u0002J\u001c\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020\u00032\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0002J\u0010\u00102\u001a\u00020#2\u0006\u0010/\u001a\u00020\u0003H\u0002J\u0010\u00103\u001a\u00020#2\u0006\u0010/\u001a\u00020\u0003H\u0002R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\f\u0012\b\u0012\u00060\u0018R\u00020\u00000\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/lang/javascript/library/JSBundledLibraryFolder;", "", "debugName", "", "Lorg/jetbrains/annotations/NonNls;", "folderSupplier", "Lkotlin/Function0;", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "folderLazy", "getFolderLazy", "()Ljava/nio/file/Path;", "folderLazy$delegate", "Lkotlin/Lazy;", "cachedFiles", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/util/Optional;", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshStatus", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/lang/javascript/library/JSBundledLibraryFolder$RefreshStatus;", "fileSets", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/lang/javascript/library/JSBundledLibraryFolder$FileSetImpl;", "registerFileSet", "Lcom/intellij/lang/javascript/library/JSBundledLibraryFolder$FileSet;", "relativePaths", "", "findFileByRelativePath", "relativePath", "doFindFileByRelativePath", "getFolderSafely", "sanitize", "logFailure", "", "filePath", "virtualFile", "beforeVfsAccessRefreshStatus", "virtualFileStatus", "file", "scheduleVfsRefresh", "vfsFolder", "rescanDependencies", "project", "Lcom/intellij/openapi/project/Project;", "logError", "message", "e", "", "logWarn", "logInfo", "RefreshStatus", "FileSet", "FileSetImpl", "JSApplicationScopeProvider", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nJSBundledLibraryFolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSBundledLibraryFolder.kt\ncom/intellij/lang/javascript/library/JSBundledLibraryFolder\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n106#2:165\n78#2,22:166\n40#3,3:188\n24#4:191\n24#4:192\n24#4:193\n1869#5,2:194\n*S KotlinDebug\n*F\n+ 1 JSBundledLibraryFolder.kt\ncom/intellij/lang/javascript/library/JSBundledLibraryFolder\n*L\n80#1:165\n80#1:166,22\n102#1:188,3\n137#1:191\n138#1:192\n139#1:193\n125#1:194,2\n*E\n"})
public final class JSBundledLibraryFolder {
    @NotNull
    private final String debugName;
    @NotNull
    private final Lazy folderLazy$delegate;
    @NotNull
    private final ConcurrentMap<String, Optional<VirtualFile>> cachedFiles;
    @NotNull
    private final AtomicReference<RefreshStatus> refreshStatus;
    @NotNull
    private final CopyOnWriteArrayList<FileSetImpl> fileSets;

    public JSBundledLibraryFolder(@NotNull String debugName, @NotNull Function0<? extends Path> folderSupplier) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        Intrinsics.checkNotNullParameter(folderSupplier, (String)"folderSupplier");
        this.debugName = debugName;
        this.folderLazy$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, folderSupplier);
        this.cachedFiles = new ConcurrentHashMap();
        this.refreshStatus = new AtomicReference<RefreshStatus>(RefreshStatus.BEFORE);
        this.fileSets = new CopyOnWriteArrayList();
    }

    private final Path getFolderLazy() {
        Lazy lazy = this.folderLazy$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    public final FileSet registerFileSet(@NotNull List<String> relativePaths) {
        FileSetImpl fileSetImpl;
        Intrinsics.checkNotNullParameter(relativePaths, (String)"relativePaths");
        FileSetImpl it = fileSetImpl = new FileSetImpl(relativePaths);
        boolean bl = false;
        this.fileSets.add(it);
        return fileSetImpl;
    }

    @Nullable
    public final VirtualFile findFileByRelativePath(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Ref.BooleanRef calculatedNow = new Ref.BooleanRef();
        Optional result2 = this.cachedFiles.computeIfAbsent(relativePath, arg_0 -> JSBundledLibraryFolder.findFileByRelativePath$lambda$2(arg_0 -> JSBundledLibraryFolder.findFileByRelativePath$lambda$1(calculatedNow, this, relativePath, arg_0), arg_0));
        VirtualFile file = result2.orElse(null);
        if (file != null && !file.isValid()) {
            if (!calculatedNow.element) {
                this.scheduleVfsRefresh();
            }
            return null;
        }
        return file;
    }

    private final VirtualFile doFindFileByRelativePath(String relativePath) {
        Path path2;
        Path path3 = this.getFolderSafely();
        if (path3 == null) {
            return null;
        }
        Path folder = path3;
        try {
            path2 = folder.resolve(this.sanitize(relativePath));
        }
        catch (Exception e) {
            this.logError("Cannot resolve relative path '" + relativePath + "'", e);
            return null;
        }
        Path fileOrDir = path2;
        RefreshStatus beforeVfsAccessRefreshStatus = this.refreshStatus.get();
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(fileOrDir);
        if (virtualFile == null || !virtualFile.isValid()) {
            Intrinsics.checkNotNull((Object)fileOrDir);
            Intrinsics.checkNotNull((Object)((Object)beforeVfsAccessRefreshStatus));
            this.logFailure(fileOrDir, relativePath, virtualFile, beforeVfsAccessRefreshStatus);
            this.scheduleVfsRefresh();
        }
        return virtualFile;
    }

    private final Path getFolderSafely() {
        Path path2;
        try {
            path2 = this.getFolderLazy();
        }
        catch (Exception e) {
            this.logError("Cannot find bundled folder, the installation is possibly broken", e);
            path2 = null;
        }
        return path2;
    }

    private final String sanitize(String relativePath) {
        String $this$trim$iv = relativePath;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = it == '/' || it == '\\';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    private final void logFailure(Path filePath, String relativePath, VirtualFile virtualFile, RefreshStatus beforeVfsAccessRefreshStatus) {
        if (!Files.exists(filePath, new LinkOption[0])) {
            JSBundledLibraryFolder.logError$default(this, "Cannot find bundled file by relative path '" + relativePath + "', the installation is possibly broken.", null, 2, null);
            return;
        }
        String message = "Cannot find '" + filePath + "' in VFS, file: " + this.virtualFileStatus(virtualFile) + ", refresh: " + beforeVfsAccessRefreshStatus;
        if (beforeVfsAccessRefreshStatus == RefreshStatus.AFTER) {
            JSBundledLibraryFolder.logError$default(this, message, null, 2, null);
        } else {
            this.logWarn(message);
        }
    }

    private final String virtualFileStatus(VirtualFile file) {
        VirtualFile virtualFile = file;
        return virtualFile != null ? "not-null, isValid:" + virtualFile.isValid() : "null";
    }

    private final void scheduleVfsRefresh() {
        if (this.refreshStatus.compareAndSet(RefreshStatus.BEFORE, RefreshStatus.IN_PROGRESS)) {
            boolean $i$f$service = false;
            Class<JSApplicationScopeProvider> serviceClass$iv = JSApplicationScopeProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            BuildersKt.launch$default((CoroutineScope)((JSApplicationScopeProvider)object).getCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ JSBundledLibraryFolder this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Path path2 = JSBundledLibraryFolder.access$getFolderSafely(this.this$0);
                            if (path2 == null) {
                                return Unit.INSTANCE;
                            }
                            Path folder = path2;
                            VirtualFile refreshedVfsFolder = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(folder);
                            if (refreshedVfsFolder != null && refreshedVfsFolder.isValid()) {
                                JSBundledLibraryFolder.access$scheduleVfsRefresh(this.this$0, refreshedVfsFolder);
                            } else {
                                JSBundledLibraryFolder.logError$default(this.this$0, "Failed to refresh '" + folder + "': refreshAndFindFileByNioFile returned " + JSBundledLibraryFolder.access$virtualFileStatus(this.this$0, refreshedVfsFolder), null, 2, null);
                                JSBundledLibraryFolder.access$getRefreshStatus$p(this.this$0).set(RefreshStatus.AFTER);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private final void scheduleVfsRefresh(VirtualFile vfsFolder) {
        this.logInfo("Refreshing recursively '" + vfsFolder + "'");
        VirtualFile[] virtualFileArray = new VirtualFile[]{vfsFolder};
        List list = VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"markDirty(...)");
        List filesToRefresh = list;
        if (filesToRefresh.isEmpty()) {
            this.logWarn("Nothing to refresh, folder=" + vfsFolder);
        }
        LocalFileSystem.getInstance().refreshFiles((Iterable)filesToRefresh, true, true, () -> JSBundledLibraryFolder.scheduleVfsRefresh$lambda$4(this));
    }

    private final void rescanDependencies(Project project) {
        JSLibraryManager.getInstance(project).commitChangesWithReason(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED, "[" + this.debugName + "] bundled library files refreshed in " + this.getFolderLazy());
    }

    private final void logError(String message, Throwable e) {
        JSBundledLibraryFolder $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JSBundledLibraryFolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("[" + this.debugName + "] " + message, e);
    }

    static /* synthetic */ void logError$default(JSBundledLibraryFolder jSBundledLibraryFolder, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        jSBundledLibraryFolder.logError(string, throwable);
    }

    private final void logWarn(String message) {
        JSBundledLibraryFolder $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JSBundledLibraryFolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("[" + this.debugName + "] " + message);
    }

    private final void logInfo(String message) {
        JSBundledLibraryFolder $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JSBundledLibraryFolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("[" + this.debugName + "] " + message);
    }

    private static final Optional findFileByRelativePath$lambda$1(Ref.BooleanRef $calculatedNow, JSBundledLibraryFolder this$0, String $relativePath, String it) {
        $calculatedNow.element = true;
        return Optional.ofNullable(this$0.doFindFileByRelativePath($relativePath));
    }

    private static final Optional findFileByRelativePath$lambda$2(Function1 $tmp0, Object p0) {
        return (Optional)$tmp0.invoke(p0);
    }

    private static final void scheduleVfsRefresh$lambda$4(JSBundledLibraryFolder this$0) {
        this$0.refreshStatus.set(RefreshStatus.AFTER);
        this$0.cachedFiles.clear();
        Iterable $this$forEach$iv = this$0.fileSets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileSetImpl p0 = (FileSetImpl)element$iv;
            boolean bl = false;
            p0.dropCache();
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            this$0.rescanDependencies(project2);
        }
    }

    public static final /* synthetic */ Path access$getFolderSafely(JSBundledLibraryFolder $this) {
        return $this.getFolderSafely();
    }

    public static final /* synthetic */ void access$scheduleVfsRefresh(JSBundledLibraryFolder $this, VirtualFile vfsFolder) {
        $this.scheduleVfsRefresh(vfsFolder);
    }

    public static final /* synthetic */ String access$virtualFileStatus(JSBundledLibraryFolder $this, VirtualFile file) {
        return $this.virtualFileStatus(file);
    }

    public static final /* synthetic */ AtomicReference access$getRefreshStatus$p(JSBundledLibraryFolder $this) {
        return $this.refreshStatus;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/intellij/lang/javascript/library/JSBundledLibraryFolder$FileSet;", "", "getFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.javascript.psi.impl"})
    public static interface FileSet {
        @NotNull
        public Set<VirtualFile> getFiles();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/lang/javascript/library/JSBundledLibraryFolder$FileSetImpl;", "Lcom/intellij/lang/javascript/library/JSBundledLibraryFolder$FileSet;", "relativePaths", "", "", "<init>", "(Lcom/intellij/lang/javascript/library/JSBundledLibraryFolder;Ljava/util/List;)V", "files", "Lcom/intellij/openapi/util/ClearableLazyValue;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFiles", "dropCache", "", "intellij.javascript.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nJSBundledLibraryFolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSBundledLibraryFolder.kt\ncom/intellij/lang/javascript/library/JSBundledLibraryFolder$FileSetImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1625#2:165\n1869#2:166\n1870#2:168\n1626#2:169\n1#3:167\n*S KotlinDebug\n*F\n+ 1 JSBundledLibraryFolder.kt\ncom/intellij/lang/javascript/library/JSBundledLibraryFolder$FileSetImpl\n*L\n149#1:165\n149#1:166\n149#1:168\n149#1:169\n149#1:167\n*E\n"})
    private final class FileSetImpl
    implements FileSet {
        @NotNull
        private final List<String> relativePaths;
        @NotNull
        private final ClearableLazyValue<Set<VirtualFile>> files;

        public FileSetImpl(List<String> relativePaths) {
            Intrinsics.checkNotNullParameter(relativePaths, (String)"relativePaths");
            this.relativePaths = relativePaths;
            ClearableLazyValue clearableLazyValue = ClearableLazyValue.createAtomic(() -> FileSetImpl.files$lambda$1(this, JSBundledLibraryFolder.this));
            Intrinsics.checkNotNullExpressionValue((Object)clearableLazyValue, (String)"createAtomic(...)");
            this.files = clearableLazyValue;
        }

        @Override
        @NotNull
        public Set<VirtualFile> getFiles() {
            Object object = this.files.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (Set)object;
        }

        public final void dropCache() {
            this.files.drop();
        }

        /*
         * WARNING - void declaration
         */
        private static final Set files$lambda$1(FileSetImpl this$0, JSBundledLibraryFolder this$1) {
            void var3_3;
            void $this$mapNotNullTo$iv;
            Iterable iterable = this$0.relativePaths;
            Collection destination$iv = new HashSet(this$0.relativePaths.size());
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv;
                boolean bl2 = false;
                if (this$1.findFileByRelativePath(it) == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            return Collections.unmodifiableSet((Set)var3_3);
        }
    }

    @Service(value={Service.Level.APP})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/library/JSBundledLibraryFolder$JSApplicationScopeProvider;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "intellij.javascript.psi.impl"})
    private static final class JSApplicationScopeProvider {
        @NotNull
        private final CoroutineScope coroutineScope;

        public JSApplicationScopeProvider(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/javascript/library/JSBundledLibraryFolder$RefreshStatus;", "", "<init>", "(Ljava/lang/String;I)V", "BEFORE", "IN_PROGRESS", "AFTER", "intellij.javascript.psi.impl"})
    private static final class RefreshStatus
    extends Enum<RefreshStatus> {
        public static final /* enum */ RefreshStatus BEFORE = new RefreshStatus();
        public static final /* enum */ RefreshStatus IN_PROGRESS = new RefreshStatus();
        public static final /* enum */ RefreshStatus AFTER = new RefreshStatus();
        private static final /* synthetic */ RefreshStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RefreshStatus[] values() {
            return (RefreshStatus[])$VALUES.clone();
        }

        public static RefreshStatus valueOf(String value) {
            return Enum.valueOf(RefreshStatus.class, value);
        }

        @NotNull
        public static EnumEntries<RefreshStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = refreshStatusArray = new RefreshStatus[]{RefreshStatus.BEFORE, RefreshStatus.IN_PROGRESS, RefreshStatus.AFTER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

