/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.TypeScriptExpressionWithTypeArguments;
import com.intellij.lang.javascript.psi.ecma6.FlowJSFunctionType;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSAsyncUtils;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSmartEnterProcessor
extends SmartEnterProcessorWithFixers {
    private static final Class[] statementLikeSourceElements = new Class[]{JSStatement.class, ES6ImportExportDeclaration.class, TypeScriptExportAssignment.class, TypeScriptTypeAlias.class, TypeScriptTypeMember.class};

    public JSSmartEnterProcessor() {
        this.addFixers(new SmartEnterProcessorWithFixers.Fixer[]{JSSmartEnterProcessor.fixer(JSSmartEnterProcessor::fixStringLiteral), JSSmartEnterProcessor.fixer(JSSmartEnterProcessor::fixParenthesized), JSSmartEnterProcessor.fixer(JSSmartEnterProcessor::fixCall), JSSmartEnterProcessor.fixer(JSSmartEnterProcessor::fixSemicolon), JSSmartEnterProcessor.fixer(JSSmartEnterProcessor::fixEnumMemberComma), JSSmartEnterProcessor.fixer(JSSmartEnterProcessor::fixControlStatementBody), JSSmartEnterProcessor.fixer(JSSmartEnterProcessor::fixIfStatementBody), JSSmartEnterProcessor.fixer(JSSmartEnterProcessor::fixControlStatementCondition), JSSmartEnterProcessor.fixer(JSSmartEnterProcessor::fixSwitchStatement), JSSmartEnterProcessor.fixer(JSSmartEnterProcessor::fixObjectProperty), JSSmartEnterProcessor.fixer(JSSmartEnterProcessor::fixFunction), JSSmartEnterProcessor.fixer(JSSmartEnterProcessor::fixCaseColon), JSSmartEnterProcessor.fixer(JSSmartEnterProcessor::fixClassLikeBraces)});
        this.addEnterProcessors(new SmartEnterProcessorWithFixers.FixEnterProcessor[]{new PlainEnterProcessor()});
    }

    public boolean doNotStepInto(PsiElement element2) {
        return element2 instanceof JSClass || element2 instanceof JSFunction || element2 instanceof TypeScriptTypeMember || element2 instanceof JSBlockStatement || element2 instanceof JSReferenceExpression || element2 instanceof JSSwitchStatement || element2 instanceof JSObjectLiteralExpression || element2 instanceof TypeScriptObjectType || element2 instanceof JSPackageStatement;
    }

    protected boolean collectChildrenRecursively(@NotNull PsiElement atCaret) {
        if (atCaret == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(0);
        }
        return !this.doNotStepInto(atCaret);
    }

    protected PsiElement restoreElementAtCaret(PsiFile file, PsiElement origElement, RangeMarker marker) {
        if (origElement.isValid()) {
            return origElement;
        }
        return PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)marker.getStartOffset(), (int)marker.getEndOffset(), origElement.getClass());
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        return JSSmartEnterProcessor.getContainingElement(super.getStatementAtCaret(editor, psiFile));
    }

    @Nullable
    private static PsiElement getContainingElement(@Nullable PsiElement atCaret) {
        JSElement parent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)atCaret, (Class[])new Class[]{JSStatement.class, JSSourceElement.class, JSCaseClause.class, JSProperty.class, TypeScriptTypeMember.class});
        if (parent instanceof JSBlockStatement && parent.getParent() instanceof JSFunction) {
            return (PsiElement)ObjectUtils.coalesce((Object)JSSmartEnterProcessor.getContainingElement((PsiElement)parent), (Object)parent);
        }
        if (parent instanceof JSExpression) {
            return (PsiElement)ObjectUtils.coalesce((Object)JSSmartEnterProcessor.getContainingElement((PsiElement)parent), (Object)parent);
        }
        return parent;
    }

    @Nullable
    private static ASTNode findErrorWithDescription(@NotNull PsiElement parent, String expected) {
        ASTNode errorNode;
        if (parent == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(1);
        }
        String errorDescription = (errorNode = parent.getNode().findChildByType(TokenType.ERROR_ELEMENT)) != null ? ((PsiErrorElement)errorNode.getPsi()).getErrorDescription() : null;
        return StringUtil.equals((CharSequence)errorDescription, (CharSequence)expected) ? errorNode : null;
    }

    public static void fixClassLikeBraces(@NotNull Editor editor, @NotNull PsiElement psiElement) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(2);
        }
        if (psiElement == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(3);
        }
        if (psiElement instanceof JSClass && !(psiElement instanceof TypeScriptTypeAlias) || psiElement instanceof TypeScriptModule) {
            boolean needBraces;
            boolean bl = psiElement instanceof TypeScriptInterface ? ((TypeScriptInterface)psiElement).getBody() == null : (needBraces = psiElement.getNode().findChildByType(JSTokenTypes.LBRACE) == null);
            if (needBraces) {
                int offset = JSSmartEnterProcessor.skipSameLineWSForward(editor, psiElement.getTextRange().getEndOffset());
                editor.getDocument().insertString(offset, (CharSequence)"{}");
            } else {
                PsiElement body;
                Object object = body = psiElement instanceof TypeScriptInterface ? ((TypeScriptInterface)psiElement).getBody() : psiElement;
                if (body.getNode().findChildByType(JSTokenTypes.RBRACE) == null) {
                    int offset = JSSmartEnterProcessor.skipSameLineWSForward(editor, psiElement.getTextRange().getEndOffset());
                    editor.getDocument().insertString(offset, (CharSequence)"}");
                }
            }
        }
    }

    private static void fixFunction(@NotNull Editor editor, @NotNull PsiElement psiElement) {
        String bodyTemplate;
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(4);
        }
        if (psiElement == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(5);
        }
        if (psiElement instanceof JSField && JSClassUtils.isES6ClassImplementation(psiElement) && StringUtil.equals((CharSequence)((JSField)psiElement).getName(), (CharSequence)"constructor")) {
            int offset = psiElement.getTextRange().getEndOffset();
            editor.getDocument().insertString(offset, (CharSequence)"() {}");
            return;
        }
        if (!(psiElement instanceof JSFunction)) {
            return;
        }
        JSFunction function = (JSFunction)psiElement;
        JSParameterList parameterList = function.getParameterList();
        boolean hasParameterList = parameterList != null && !parameterList.getTextRange().isEmpty();
        boolean isCompleteParameterList = hasParameterList && (JSPsiImplUtils.isArrowFunction(function) || parameterList.getNode().findChildByType(JSTokenTypes.RPAR) != null);
        String semicolon = JSCodeStyleSettings.getSemicolon(function);
        boolean needsBody = true;
        if (JSSmartEnterProcessor.isAbstractOrTypeMember(function)) {
            bodyTemplate = JSSmartEnterProcessor.hasNoSemicolonAtEnd(function) ? "" : semicolon;
            needsBody = false;
        } else if (TypeScriptPsiUtil.isAmbientDeclaration(function) || function instanceof TypeScriptFunction && ((TypeScriptFunction)function).isOverloadDeclaration()) {
            bodyTemplate = semicolon;
            needsBody = false;
        } else if (JSSmartEnterProcessor.isFunctionType(function)) {
            bodyTemplate = "";
            needsBody = false;
        } else {
            bodyTemplate = "{}";
        }
        if (!hasParameterList) {
            int offset = JSSmartEnterProcessor.skipNewlinesBackward(editor, function.getTextRange().getEndOffset());
            String tail = "()" + bodyTemplate;
            editor.getDocument().insertString(offset, (CharSequence)tail);
            return;
        }
        JSElement body = JSPsiImplUtils.getFunctionBody(function);
        if (!isCompleteParameterList) {
            int offset = JSSmartEnterProcessor.skipNewlinesBackward(editor, function.getTextRange().getEndOffset());
            Object tail = body != null ? ")" : ")" + bodyTemplate;
            editor.getDocument().insertString(offset, (CharSequence)tail);
            return;
        }
        if (needsBody && body == null) {
            int offset = JSSmartEnterProcessor.skipSameLineWSForward(editor, function.getTextRange().getEndOffset());
            editor.getDocument().insertString(offset, (CharSequence)bodyTemplate);
            return;
        }
        if (JSSmartEnterProcessor.isAbstractOrTypeMember(function) && JSSmartEnterProcessor.hasNoSemicolonAtEnd(function)) {
            JSSmartEnterProcessor.insertSemicolonAfter(editor, function);
        }
    }

    private static void fixSwitchStatement(@NotNull Editor editor, @NotNull JSSmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(7);
        }
        if (psiElement == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(8);
        }
        if (!(psiElement instanceof JSSwitchStatement)) {
            return;
        }
        if (JSSmartEnterProcessor.fixStatementCondition(editor, processor, psiElement, ((JSSwitchStatement)psiElement).getSwitchExpression())) {
            return;
        }
        ASTNode rParen = psiElement.getNode().findChildByType(JSTokenTypes.RPAR);
        if (rParen != null && psiElement.getNode().findChildByType(JSTokenTypes.LBRACE, rParen) == null) {
            int offset = JSSmartEnterProcessor.skipSameLineWSForward(editor, rParen.getTextRange().getEndOffset());
            editor.getDocument().insertString(offset, (CharSequence)"{}");
        }
    }

    private static void fixControlStatementCondition(@NotNull Editor editor, @NotNull JSSmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(10);
        }
        if (psiElement == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(11);
        }
        if (!(psiElement instanceof JSIfStatement) && !(psiElement instanceof JSLoopStatement)) {
            return;
        }
        JSExpression beforeParen = psiElement instanceof JSForInStatement ? ((JSForInStatement)psiElement).getCollectionExpression() : ((JSConditionOwner)psiElement).getCondition();
        JSSmartEnterProcessor.fixStatementCondition(editor, processor, psiElement, beforeParen);
    }

    private static void fixControlStatementBody(@NotNull Editor editor, @NotNull PsiElement psiElement) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(12);
        }
        if (psiElement == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(13);
        }
        if (!(psiElement instanceof JSLoopStatement)) {
            return;
        }
        JSStatement body = ((JSLoopStatement)psiElement).getBody();
        JSSmartEnterProcessor.insertBracesAfterCondition(editor, psiElement, body);
    }

    private static void insertBracesAfterCondition(@NotNull Editor editor, @NotNull PsiElement psiElement, @Nullable JSStatement body) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(14);
        }
        if (psiElement == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(15);
        }
        ASTNode rParen = psiElement.getNode().findChildByType(JSTokenTypes.RPAR);
        if (!(body instanceof JSBlockStatement) && rParen != null) {
            int offset = JSSmartEnterProcessor.skipSameLineWSForward(editor, rParen.getTextRange().getEndOffset());
            editor.getDocument().insertString(offset, (CharSequence)"{}");
        }
    }

    private static void fixIfStatementBody(@NotNull Editor editor, @NotNull PsiElement psiElement) {
        boolean isAfterElse;
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(16);
        }
        if (psiElement == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(17);
        }
        if (!(psiElement instanceof JSIfStatement)) {
            return;
        }
        JSIfStatement ifStatement = (JSIfStatement)psiElement;
        ASTNode elseKeyword = psiElement.getNode().findChildByType(JSTokenTypes.ELSE_KEYWORD);
        boolean bl = isAfterElse = elseKeyword != null && editor.getCaretModel().getOffset() >= elseKeyword.getTextRange().getStartOffset();
        if (isAfterElse) {
            JSStatement elseBlock = (JSStatement)ifStatement.getElseBranch();
            if (!(elseBlock instanceof JSBlockStatement) && !(elseBlock instanceof JSIfStatement)) {
                int offset = JSSmartEnterProcessor.skipSameLineWSForward(editor, elseKeyword.getTextRange().getEndOffset());
                editor.getDocument().insertString(offset, (CharSequence)"{}");
            }
        } else {
            JSStatement body = (JSStatement)((JSIfStatement)psiElement).getThenBranch();
            JSSmartEnterProcessor.insertBracesAfterCondition(editor, psiElement, body);
        }
    }

    private static boolean fixStatementCondition(@NotNull Editor editor, @NotNull JSSmartEnterProcessor processor, @NotNull PsiElement psiElement, @Nullable JSExpression condition) {
        ASTNode errorNode;
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(18);
        }
        if (processor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(19);
        }
        if (psiElement == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(20);
        }
        if ((errorNode = JSSmartEnterProcessor.findErrorWithDescription(psiElement, JavaScriptParserBundle.message((String)"javascript.parser.message.expected.lparen", (Object[])new Object[0]))) != null) {
            int offset = JSSmartEnterProcessor.skipSameLineWSForward(editor, errorNode.getTextRange().getEndOffset());
            String tail = "() {}";
            editor.getDocument().insertString(offset, (CharSequence)tail);
            return true;
        }
        ASTNode lParen = psiElement.getNode().findChildByType(JSTokenTypes.LPAR);
        if (lParen == null) {
            return false;
        }
        Document doc = editor.getDocument();
        ASTNode rParen = psiElement.getNode().findChildByType(JSTokenTypes.RPAR);
        if (condition == null) {
            if (rParen == null) {
                String replacement = "()";
                int offset = JSSmartEnterProcessor.skipSameLineWSForward(editor, psiElement.getTextRange().getEndOffset());
                doc.insertString(offset, (CharSequence)replacement);
                processor.registerUnresolvedError(offset + 1);
            } else {
                processor.registerUnresolvedError(lParen.getTextRange().getEndOffset());
            }
            return true;
        }
        if (rParen == null) {
            doc.insertString(condition.getTextRange().getEndOffset(), (CharSequence)")");
            return true;
        }
        return false;
    }

    private static void fixSemicolon(@NotNull Editor editor, @NotNull PsiElement element2) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(21);
        }
        if (element2 == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(22);
        }
        if (!ContainerUtil.or((Object[])statementLikeSourceElements, clazz -> clazz.isInstance(element2))) {
            return;
        }
        if (JSSmartEnterProcessor.requiresSemicolon(element2) && JSSmartEnterProcessor.hasNoSemicolonAtEnd(element2)) {
            JSSmartEnterProcessor.insertSemicolonAfter(editor, element2);
        }
    }

    private static void fixEnumMemberComma(@NotNull Editor editor, @NotNull PsiElement element2) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(23);
        }
        if (element2 == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(24);
        }
        if (element2 instanceof TypeScriptEnumField && !JSSmartEnterProcessor.isFollowedByTerminal(element2, JSTokenTypes.COMMA) && !(PsiTreeUtil.getDeepestLast((PsiElement)element2) instanceof PsiErrorElement)) {
            editor.getDocument().insertString(element2.getTextRange().getEndOffset(), (CharSequence)",");
        }
    }

    private static void fixCall(@NotNull Editor editor, @NotNull PsiElement element2) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(25);
        }
        if (element2 == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(26);
        }
        if (element2 instanceof TypeScriptExpressionWithTypeArguments) {
            editor.getDocument().insertString(element2.getTextRange().getEndOffset(), (CharSequence)"()");
            return;
        }
        if (element2 instanceof JSCallExpression) {
            PsiElement lastBeforeName;
            PsiElement lastLeaf;
            boolean hasLParen;
            if (PsiTreeUtil.getDeepestLast((PsiElement)element2).getNode().getElementType() == JSTokenTypes.RPAR) {
                return;
            }
            int endOffset = element2.getTextRange().getEndOffset();
            JSArgumentList argumentList = ((JSCallExpression)element2).getArgumentList();
            boolean bl = hasLParen = argumentList != null && PsiTreeUtil.getDeepestFirst((PsiElement)argumentList).getNode().getElementType() == JSTokenTypes.LPAR;
            if (!hasLParen) {
                editor.getDocument().insertString(endOffset, (CharSequence)"()");
                return;
            }
            if (JSSmartEnterProcessor.isFollowedByTerminal((PsiElement)argumentList, JSTokenTypes.COLON) && (lastLeaf = PsiTreeUtil.getDeepestVisibleLast((PsiElement)argumentList)) != null && JSKeywordSets.PROPERTY_NAMES.contains(lastLeaf.getNode().getElementType()) && (lastBeforeName = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastLeaf)) != null) {
                endOffset = lastBeforeName.getTextRange().getEndOffset();
            }
            editor.getDocument().insertString(endOffset, (CharSequence)")");
            return;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)element2, JSReferenceExpression.class);
        if (referenceExpression != null) {
            PsiElement parent = element2.getParent();
            if (parent instanceof JSExpressionStatement || parent instanceof JSVarStatement) {
                if (JSSmartEnterProcessor.findSuitableCallable(referenceExpression) == null) {
                    return;
                }
                PsiElement nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element2);
                int offset = nextElement instanceof TypeScriptTypeArgumentList ? nextElement.getTextRange().getEndOffset() : element2.getTextRange().getEndOffset();
                editor.getDocument().insertString(offset, (CharSequence)"()");
            } else {
                JSSmartEnterProcessor.handlePossibleGenericCall(editor, element2, parent);
            }
        }
    }

    private static void handlePossibleGenericCall(@NotNull Editor editor, @NotNull PsiElement element2, @Nullable PsiElement parent) {
        int argsLength;
        PsiElement callable;
        boolean isLtBinary;
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(27);
        }
        if (element2 == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(28);
        }
        if (parent == null || !DialectDetector.hasFeature(parent, JSLanguageFeature.GENERICS)) {
            return;
        }
        PsiElement grandParent = parent.getParent();
        boolean isLastGenericArg = parent instanceof TypeScriptType && grandParent instanceof TypeScriptTypeArgumentList && grandParent.getLastChild() == parent;
        boolean bl = isLtBinary = parent instanceof JSBinaryExpression && parent.getLastChild() == element2 && ((JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.LT;
        if (!isLastGenericArg && !isLtBinary) {
            return;
        }
        Object prevElement = isLtBinary ? ((JSBinaryExpression)parent).getLOperand() : PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
        PsiElement psiElement = callable = prevElement instanceof JSReferenceExpression ? JSSmartEnterProcessor.findSuitableCallable((JSReferenceExpression)prevElement) : null;
        if (!(callable instanceof TypeScriptTypeParameterListOwner)) {
            return;
        }
        int paramsLength = ((TypeScriptTypeParameterListOwner)callable).getTypeParameters().length;
        int n = argsLength = isLtBinary ? JSSmartEnterProcessor.getCommaDepth(grandParent) : ((TypeScriptTypeArgumentList)grandParent).getTypeArguments().length;
        if (paramsLength > 0 && paramsLength == argsLength) {
            while (isLtBinary && grandParent instanceof JSCommaExpression) {
                grandParent = grandParent.getParent();
            }
            editor.getDocument().insertString(grandParent.getTextRange().getEndOffset(), (CharSequence)">()");
        }
    }

    private static int getCommaDepth(PsiElement parent) {
        int depth = 1;
        while (parent instanceof JSCommaExpression) {
            parent = parent.getParent();
            ++depth;
        }
        return depth;
    }

    @Nullable
    private static PsiElement findSuitableCallable(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(29);
        }
        return (PsiElement)JSAsyncUtils.runWithTimeoutOrAsync(1000L, () -> JSSmartEnterProcessor.doFindSuitableCallable(referenceExpression));
    }

    @Nullable
    private static PsiElement doFindSuitableCallable(@NotNull JSReferenceExpression referenceExpression) {
        JSFunctionItem function;
        ResolveResult[] results;
        if (referenceExpression == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(30);
        }
        if ((results = referenceExpression.multiResolve(false)).length == 0) {
            return null;
        }
        PsiElement resolve2 = results[0].getElement();
        JSFunctionItem jSFunctionItem = function = resolve2 == null ? null : JSPsiImplUtils.calculatePossibleFunction(resolve2, (PsiElement)referenceExpression, true);
        if (function != null && !function.isGetProperty() && !function.isSetProperty()) {
            return function;
        }
        if (resolve2 instanceof JSClass && !JSResolveUtil.isExprInStrictTypeContext(referenceExpression)) {
            return resolve2;
        }
        return null;
    }

    private static void fixStringLiteral(@NotNull Editor editor, @NotNull PsiElement element2) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(31);
        }
        if (element2 == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(32);
        }
        if (JSTokenTypes.STRING_LITERALS.contains(element2.getNode().getElementType()) || element2 instanceof JSLiteralExpression && ((JSLiteralExpression)element2).isQuotedLiteral() && !(element2 instanceof JSStringTemplateExpression)) {
            String text = element2.getText();
            char startQuote = text.charAt(0);
            if (text.length() == 1 || text.charAt(element2.getTextLength() - 1) != startQuote) {
                editor.getDocument().insertString(element2.getTextRange().getEndOffset(), (CharSequence)String.valueOf(startQuote));
            }
        }
    }

    private static void fixParenthesized(@NotNull Editor editor, @NotNull PsiElement element2) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(33);
        }
        if (element2 == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(34);
        }
        if (element2 instanceof JSParenthesizedExpression && PsiTreeUtil.getDeepestLast((PsiElement)element2).getNode().getElementType() != JSTokenTypes.RPAR) {
            editor.getDocument().insertString(element2.getTextRange().getEndOffset(), (CharSequence)")");
        }
    }

    private static void fixCaseColon(@NotNull Editor editor, @NotNull PsiElement element2) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(35);
        }
        if (element2 == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(36);
        }
        if (!(element2 instanceof JSCaseClause)) {
            return;
        }
        if (((JSCaseClause)element2).getStatementListItems().length != 0) {
            return;
        }
        PsiElement lastChild = PsiTreeUtil.getDeepestLast((PsiElement)element2);
        if (lastChild.getNode().getElementType() != JSTokenTypes.COLON) {
            editor.getDocument().insertString(element2.getTextRange().getEndOffset(), (CharSequence)":");
        }
    }

    private static void fixObjectProperty(@NotNull Editor editor, @NotNull PsiElement psiElement) {
        boolean insertComma;
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(37);
        }
        if (psiElement == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(38);
        }
        if (!(psiElement instanceof JSProperty)) {
            return;
        }
        if (JSSmartEnterProcessor.isFollowedByTerminal(psiElement, JSTokenTypes.COLON)) {
            return;
        }
        if (JSSmartEnterProcessor.isFollowedByTerminal(psiElement, JSTokenTypes.COMMA)) {
            return;
        }
        boolean bl = insertComma = PsiTreeUtil.getNextSiblingOfType((PsiElement)psiElement, JSProperty.class) != null;
        if (!insertComma && psiElement.getNextSibling() instanceof PsiWhiteSpace && psiElement.getNextSibling().textContains('\n')) {
            boolean bl2 = insertComma = JSCodeStyleSettings.getSettings((PsiElement)psiElement).ENFORCE_TRAILING_COMMA == JSCodeStyleSettings.TrailingCommaOption.WhenMultiline;
            if (!insertComma) {
                Document document = editor.getDocument();
                boolean bl3 = insertComma = document.getLineNumber(editor.getCaretModel().getOffset()) == document.getLineNumber(psiElement.getTextRange().getEndOffset());
            }
        }
        if (insertComma) {
            editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)",");
        }
    }

    private static boolean isFollowedByTerminal(@NotNull PsiElement element2, IElementType type2) {
        PsiElement nextLeaf;
        if (element2 == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(39);
        }
        return (nextLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)element2)) != null && nextLeaf.getNode().getElementType() == type2;
    }

    private static int skipNewlinesBackward(@NotNull Editor editor, int offset) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(40);
        }
        String text = editor.getDocument().getText();
        return CharArrayUtil.shiftBackward((CharSequence)text, (int)(offset - 1), (String)"\n") + 1;
    }

    private static int skipSameLineWSForward(@NotNull Editor editor, int offset) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(41);
        }
        return CharArrayUtil.shiftForward((CharSequence)editor.getDocument().getText(), (int)offset, (String)" \t");
    }

    private static void insertSemicolonAfter(@NotNull Editor editor, @NotNull PsiElement element2) {
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(42);
        }
        if (element2 == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(43);
        }
        if (PsiTreeUtil.getDeepestLast((PsiElement)element2) instanceof PsiErrorElement) {
            return;
        }
        String semicolon = JSCodeStyleSettings.getSemicolon(element2);
        if (StringUtil.isEmpty((String)semicolon)) {
            return;
        }
        editor.getDocument().insertString(element2.getTextRange().getEndOffset(), (CharSequence)semicolon);
    }

    private static boolean hasNoSemicolonAtEnd(PsiElement element2) {
        if (element2 instanceof TypeScriptTypeMember) {
            return !JSSmartEnterProcessor.isFollowedByTerminal(element2, JSTokenTypes.COMMA) && !JSSmartEnterProcessor.isFollowedByTerminal(element2, JSTokenTypes.SEMICOLON);
        }
        return PsiTreeUtil.getDeepestLast((PsiElement)element2).getNode().getElementType() != JSTokenTypes.SEMICOLON;
    }

    private static boolean isAbstractOrTypeMember(@NotNull JSFunction function) {
        if (function == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(44);
        }
        if (function instanceof TypeScriptTypeMember) {
            return true;
        }
        JSClass jsClass = JSUtils.getMemberContainingClass(function);
        return jsClass != null && (jsClass.isInterface() || JSPsiImplUtils.hasModifier(function, JSAttributeList.ModifierType.ABSTRACT));
    }

    private static boolean isFunctionType(@NotNull JSFunction function) {
        if (function == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(45);
        }
        return function instanceof TypeScriptFunctionType || function instanceof FlowJSFunctionType;
    }

    private static boolean requiresSemicolon(PsiElement statement) {
        return !(statement instanceof JSStatement) || !JSUtils.statementNeverRequiresSemicolon((JSStatement)statement);
    }

    @Nullable
    private static JSBlockStatement getBlockBody(int caret, @Nullable PsiElement element2) {
        if (element2 instanceof JSFunction) {
            return ((JSFunction)element2).getBlock();
        }
        if (element2 instanceof JSIfStatement) {
            JSStatement body = (JSStatement)((JSIfStatement)element2).getThenBranch();
            if (body != null && caret > body.getTextRange().getEndOffset()) {
                body = (JSStatement)((JSIfStatement)element2).getElseBranch();
            }
            if (body instanceof JSBlockStatement) {
                return (JSBlockStatement)body;
            }
            return null;
        }
        if (element2 instanceof JSLoopStatement) {
            JSStatement body = ((JSLoopStatement)element2).getBody();
            if (body instanceof JSBlockStatement) {
                return (JSBlockStatement)body;
            }
            return null;
        }
        if (element2 instanceof JSBlockStatement) {
            return (JSBlockStatement)element2;
        }
        return null;
    }

    private static void moveCaretRight(@NotNull Editor editor, int offset) {
        int existing;
        if (editor == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(46);
        }
        if (offset > (existing = editor.getCaretModel().getOffset())) {
            editor.getCaretModel().moveToOffset(offset);
        }
    }

    @NotNull
    private static SmartEnterProcessorWithFixers.Fixer<JSSmartEnterProcessor> fixer(@NotNull BiConsumer<? super Editor, ? super PsiElement> fn) {
        if (fn == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(47);
        }
        return JSSmartEnterProcessor.fixer((Editor editor, JSSmartEnterProcessor processor, PsiElement element2) -> fn.accept(editor, element2));
    }

    @NotNull
    private static SmartEnterProcessorWithFixers.Fixer<JSSmartEnterProcessor> fixer(final @NotNull FixerFn fn) {
        if (fn == null) {
            JSSmartEnterProcessor.$$$reportNull$$$0(48);
        }
        return new SmartEnterProcessorWithFixers.Fixer<JSSmartEnterProcessor>(){

            public void apply(@NotNull Editor editor, @NotNull JSSmartEnterProcessor processor, @NotNull PsiElement element2) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                fn.apply(editor, processor, element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "processor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/editing/JSSmartEnterProcessor$1";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "atCaret";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 7: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fn";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/editing/JSSmartEnterProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectChildrenRecursively";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findErrorWithDescription";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fixClassLikeBraces";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fixFunction";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fixSwitchStatement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "fixControlStatementCondition";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "fixControlStatementBody";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "insertBracesAfterCondition";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "fixIfStatementBody";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "fixStatementCondition";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "fixSemicolon";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "fixEnumMemberComma";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "fixCall";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "handlePossibleGenericCall";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "findSuitableCallable";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "doFindSuitableCallable";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "fixStringLiteral";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "fixParenthesized";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "fixCaseColon";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "fixObjectProperty";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "isFollowedByTerminal";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "skipNewlinesBackward";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "skipSameLineWSForward";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "insertSemicolonAfter";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbstractOrTypeMember";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionType";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "moveCaretRight";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "fixer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    private static interface FixerFn {
        public void apply(@NotNull Editor var1, @NotNull JSSmartEnterProcessor var2, @NotNull PsiElement var3);
    }

    private static class PlainEnterProcessor
    extends SmartEnterProcessorWithFixers.FixEnterProcessor {
        private PlainEnterProcessor() {
        }

        public boolean doEnter(PsiElement atCaret, PsiFile file, @NotNull Editor editor, boolean modified) {
            PsiElement leaf;
            if (editor == null) {
                PlainEnterProcessor.$$$reportNull$$$0(0);
            }
            if (!modified) {
                return false;
            }
            int caretOffset = editor.getCaretModel().getOffset();
            if (atCaret instanceof TypeScriptTypeMember && (leaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)atCaret)) != null && leaf.getNode().getElementType() == JSTokenTypes.SEMICOLON) {
                return this.moveCaretAfter(editor, leaf.getNode(), true);
            }
            if (atCaret instanceof JSFunction) {
                return this.doEnterInFunction((JSFunction)atCaret, editor, caretOffset);
            }
            PsiElement leafAtCaret = file.findElementAt(caretOffset);
            JSFunction containingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)leafAtCaret, (Class[])new Class[]{JSFunctionExpression.class, JSFunctionProperty.class});
            if (containingFunction != null && PsiTreeUtil.isAncestor((PsiElement)atCaret, (PsiElement)containingFunction, (boolean)true)) {
                return this.doEnterInFunction(containingFunction, editor, caretOffset);
            }
            JSClassExpression containingClassExpression = (JSClassExpression)PsiTreeUtil.getParentOfType((PsiElement)leafAtCaret, JSClassExpression.class);
            if (containingClassExpression != null && PsiTreeUtil.isAncestor((PsiElement)atCaret, (PsiElement)containingClassExpression, (boolean)true)) {
                return this.moveCaretAfterBrace(containingClassExpression, editor);
            }
            PsiElement nextLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)atCaret);
            if (atCaret instanceof JSProperty && nextLeaf != null && nextLeaf.getNode().getElementType() == JSTokenTypes.COMMA) {
                PsiElement afterCommaNonWs = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)nextLeaf);
                return this.moveCaretAfter(editor, nextLeaf.getNode(), afterCommaNonWs instanceof JSProperty);
            }
            if (atCaret instanceof JSClass || atCaret instanceof JSPackageStatement || atCaret instanceof JSSwitchStatement) {
                TypeScriptObjectType body;
                if (atCaret instanceof TypeScriptInterface && (body = ((TypeScriptInterface)atCaret).getBody()) != null) {
                    return this.moveCaretAfterBrace((PsiElement)body, editor);
                }
                return this.moveCaretAfterBrace(atCaret, editor);
            }
            if (atCaret instanceof JSCaseClause) {
                return this.moveCaretAfter(editor, atCaret.getNode().findChildByType(JSTokenTypes.COLON), false);
            }
            JSBlockStatement block = JSSmartEnterProcessor.getBlockBody(caretOffset, atCaret);
            if (block != null) {
                return this.moveCaretAfterBrace(block, editor);
            }
            return false;
        }

        private boolean doEnterInFunction(@NotNull JSFunction atCaret, @NotNull Editor editor, int caretOffset) {
            JSParameterList parameterList;
            if (atCaret == null) {
                PlainEnterProcessor.$$$reportNull$$$0(1);
            }
            if (editor == null) {
                PlainEnterProcessor.$$$reportNull$$$0(2);
            }
            if ((parameterList = atCaret.getParameterList()) != null && parameterList.getParameters().length == 0 && caretOffset <= parameterList.getTextRange().getStartOffset()) {
                JSSmartEnterProcessor.moveCaretRight(editor, parameterList.getTextRange().getEndOffset() - ")".length());
                return true;
            }
            JSBlockStatement block = JSSmartEnterProcessor.getBlockBody(caretOffset, atCaret);
            if (block != null) {
                return this.moveCaretAfterBrace(block, editor);
            }
            return false;
        }

        private boolean moveCaretAfterBrace(@NotNull PsiElement atCaret, @NotNull Editor editor) {
            if (atCaret == null) {
                PlainEnterProcessor.$$$reportNull$$$0(3);
            }
            if (editor == null) {
                PlainEnterProcessor.$$$reportNull$$$0(4);
            }
            boolean keepOnOneLine = !atCaret.textContains('\n');
            return this.moveCaretAfter(editor, atCaret.getNode().findChildByType(JSTokenTypes.LBRACE), keepOnOneLine);
        }

        private boolean moveCaretAfter(@NotNull Editor editor, @Nullable ASTNode node, boolean keepOnOneLine) {
            if (editor == null) {
                PlainEnterProcessor.$$$reportNull$$$0(5);
            }
            if (node != null) {
                JSSmartEnterProcessor.moveCaretRight(editor, node.getTextRange().getEndOffset());
                if (!keepOnOneLine) {
                    this.plainEnter(editor);
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "atCaret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/editing/JSSmartEnterProcessor$PlainEnterProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doEnter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doEnterInFunction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveCaretAfterBrace";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveCaretAfter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

