/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.jsonPath;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.UsedColors;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.highlighting.HttpRequestSyntaxHighlighter;
import com.intellij.httpClient.http.request.psi.HttpFileVariable;
import com.intellij.httpClient.http.request.psi.HttpKeyValueElement;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.httpClient.jsonPath.JsonPathUtilKt;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J2\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/httpClient/jsonPath/HttpRequestRainbowVisitor;", "Lcom/intellij/codeInsight/daemon/RainbowVisitor;", "<init>", "()V", "suitableForFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "visit", "", "element", "Lcom/intellij/psi/PsiElement;", "clone", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "getInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "context", "rainbowElement", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "name", "", "colorKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.restClient"})
public final class HttpRequestRainbowVisitor
extends RainbowVisitor {
    public boolean suitableForFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return psiFile instanceof HttpRequestPsiFile;
    }

    public void visit(@NotNull PsiElement element) {
        Object resolved;
        Object identifier;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof HttpFileVariable) {
            identifier = ((HttpFileVariable)element).getNameIdentifier();
            if (((HttpFileVariable)element).getName() == null || identifier == null) {
                return;
            }
            PsiElement psiElement = (PsiElement)((HttpFileVariable)element).getContainingFile();
            String string = ((HttpFileVariable)element).getName();
            Intrinsics.checkNotNull((Object)string);
            this.addInfo(this.getInfo(psiElement, (PsiElement)identifier, string, HttpRequestSyntaxHighlighter.HTTP_REQUEST_FILE_VARIABLE_NAME));
        }
        if (element instanceof HttpVariable) {
            identifier = ((HttpVariable)element).getNameIdentifier();
            if (identifier == null) {
                return;
            }
            ResolveResult[] resolveResultArray = ((HttpVariable)element).multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
            ResolveResult[] elements = resolveResultArray;
            if (elements.length != 1) {
                return;
            }
            resolved = elements[0].getElement();
            if (!(resolved instanceof HttpFileVariable) || ((HttpFileVariable)resolved).getName() == null) {
                return;
            }
            PsiElement psiElement = (PsiElement)((HttpVariable)element).getContainingFile();
            String string = ((HttpFileVariable)resolved).getName();
            Intrinsics.checkNotNull((Object)string);
            this.addInfo(this.getInfo(psiElement, (PsiElement)identifier, string, HttpRequestSyntaxHighlighter.HTTP_REQUEST_FILE_VARIABLE_NAME));
        }
        if (element instanceof HttpMessageBody) {
            for (PsiPolyVariantReference variableReference : JsonPathUtilKt.findHttpVariableJsonPathReferencesInMessageBody((HttpMessageBody)element)) {
                String name;
                ResolveResult[] resolveResultArray = variableReference.multiResolve(false);
                Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
                ResolveResult resolveResult = (ResolveResult)ArraysKt.singleOrNull((Object[])resolveResultArray);
                resolved = resolveResult != null ? resolveResult.getElement() : null;
                if (!(resolved instanceof HttpFileVariable) || ((HttpFileVariable)resolved).getName() == null) continue;
                PsiFile psiFile = ((HttpMessageBody)element).getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                PsiElement psiElement = (PsiElement)psiFile;
                TextRange textRange = variableReference.getRangeInElement();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
                TextAttributesKey textAttributesKey = HttpRequestSyntaxHighlighter.HTTP_REQUEST_FILE_VARIABLE_NAME;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"HTTP_REQUEST_FILE_VARIABLE_NAME");
                this.addInfo(this.getInfo(psiElement, element, textRange, name, textAttributesKey));
            }
        }
        HttpKeyValueElement httpKeyValueElement = element instanceof HttpKeyValueElement ? (HttpKeyValueElement)element : null;
        if (httpKeyValueElement == null) {
            return;
        }
        HttpKeyValueElement keyValueElement = httpKeyValueElement;
        PsiElement context2 = ((HttpKeyValueElement)element).getParent();
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = HttpRequestVariableSubstitutor.empty();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestVariableSubstitutor, (String)"empty(...)");
        String key = keyValueElement.getKey(httpRequestVariableSubstitutor);
        PsiElement psiElement = keyValueElement.getKeyElement().getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
        Sequence elementsToHighlight = SequencesKt.filter((Sequence)PsiTreeUtilKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)3, null), HttpRequestRainbowVisitor::visit$lambda$0);
        for (PsiElement elementToHighlight : elementsToHighlight) {
            this.addInfo(this.getInfo(context2, elementToHighlight, key, HttpRequestSyntaxHighlighter.HTTP_REQUEST_PARAMETER_NAME));
        }
    }

    @NotNull
    public HighlightVisitor clone() {
        return (HighlightVisitor)new HttpRequestRainbowVisitor();
    }

    private final HighlightInfo getInfo(PsiElement context2, PsiElement rainbowElement, TextRange rangeInElement, String name, TextAttributesKey colorKey) {
        UserDataHolderEx userDataHolderEx = (UserDataHolderEx)context2;
        Intrinsics.checkNotNull((Object)userDataHolderEx);
        int colorIndex = UsedColors.getOrAddColorIndex((UserDataHolderEx)userDataHolderEx, (String)name, (int)this.getHighlighter().getColorsCount());
        TextRange textRange = rangeInElement.shiftRight(rainbowElement.getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
        TextRange rangeToHighlight = textRange;
        return this.getHighlighter().getInfo(colorIndex, rangeToHighlight.getStartOffset(), rangeToHighlight.getEndOffset(), colorKey);
    }

    private static final boolean visit$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof PsiWhiteSpace) && !Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)HttpRequestElementTypes.PERCENT_ESCAPED);
    }
}

