/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.template.lang.core.templateLanguages;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.template.lang.core.templateLanguages.PyTemplatesBundle;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.psi.WeakFileReference;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateFileReference
extends WeakFileReference {
    public TemplateFileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
        if (fileReferenceSet == null) {
            TemplateFileReference.$$$reportNull$$$0(0);
        }
        super(fileReferenceSet, range, index, text);
    }

    @Nullable
    public String getUnresolvedDescription() {
        return PyTemplatesBundle.message("template.file.not.found", this.getCanonicalText());
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        Collection contexts;
        VirtualFile curVFile;
        if (element == null) {
            TemplateFileReference.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiFileSystemItem)) {
            throw new IncorrectOperationException("Cannot bind to element, should be instanceof PsiFileSystemItem: " + String.valueOf(element));
        }
        PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)element;
        VirtualFile dstVFile = fileSystemItem.getVirtualFile();
        if (dstVFile == null) {
            throw new IncorrectOperationException("Cannot bind to non-physical element:" + String.valueOf(element));
        }
        PsiFile file = this.getElement().getContainingFile();
        PsiLanguageInjectionHost contextPsiFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file);
        if (contextPsiFile != null) {
            file = contextPsiFile.getContainingFile();
        }
        if ((curVFile = file.getVirtualFile()) == null) {
            throw new IncorrectOperationException("Cannot bind from non-physical element:" + String.valueOf(file));
        }
        PsiFileSystemItem curItem = null;
        PsiFileSystemItem dstItem = null;
        PsiFileSystemItem _dstItem = FileReferenceHelper.getPsiFileSystemItem((PsiManager)file.getManager(), (VirtualFile)dstVFile);
        PsiFileSystemItem _curItem = FileReferenceHelper.getPsiFileSystemItem((PsiManager)file.getManager(), (VirtualFile)curVFile);
        if (_dstItem != null && _curItem != null) {
            curItem = _curItem;
            dstItem = _dstItem;
        }
        if (!(contexts = this.getContexts()).isEmpty()) {
            for (PsiFileSystemItem context : contexts) {
                String path2;
                VirtualFile contextFile = context.getVirtualFile();
                assert (contextFile != null);
                if (!VfsUtilCore.isAncestor((VirtualFile)contextFile, (VirtualFile)dstVFile, (boolean)true) || (path2 = VfsUtilCore.getRelativePath((VirtualFile)dstVFile, (VirtualFile)contextFile, (char)'/')) == null) continue;
                return this.rename(path2.replace("/", this.getFileReferenceSet().getSeparatorString()));
            }
        }
        if (curItem == null) {
            throw new IncorrectOperationException("Cannot find path between files; src = " + curVFile.getPresentableUrl() + "; dst = " + dstVFile.getPresentableUrl() + "; Contexts: " + String.valueOf(contexts));
        }
        if (curItem.equals(dstItem)) {
            if (this.getCanonicalText().equals(dstItem.getName())) {
                return this.getElement();
            }
            return ElementManipulators.handleContentChange((PsiElement)this.getElement(), (TextRange)this.getRangeInElement(), (String)file.getName());
        }
        String newName = PsiFileSystemItemUtil.findRelativePath((PsiFileSystemItem)curItem, (PsiFileSystemItem)dstItem);
        if (newName == null) {
            return this.getElement();
        }
        return this.rename(newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/template/lang/core/templateLanguages/TemplateFileReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "bindToElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

