/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.participants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.ParticipantDescriptor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class ParticipantExtensionPoint {
    private final String fParticipantID;
    private List<ParticipantDescriptor> fParticipants;
    private final Class<?> fParticipantClass;
    private final String fPluginId;

    public ParticipantExtensionPoint(String pluginId, String participantId, Class<?> clazz) {
        Assert.isNotNull((Object)participantId);
        this.fParticipantID = participantId;
        this.fParticipantClass = clazz;
        this.fPluginId = pluginId;
    }

    public RefactoringParticipant[] getParticipants(RefactoringStatus status, RefactoringProcessor processor, Object element, RefactoringArguments arguments, IParticipantDescriptorFilter filter, String[] affectedNatures, SharableParticipants shared) {
        if (this.fParticipants == null) {
            this.init();
        }
        EvaluationContext evalContext = ParticipantExtensionPoint.createEvaluationContext(processor, element, affectedNatures);
        ArrayList<RefactoringParticipant> result = new ArrayList<RefactoringParticipant>();
        Iterator<ParticipantDescriptor> iter = this.fParticipants.iterator();
        while (iter.hasNext()) {
            ParticipantDescriptor descriptor = iter.next();
            if (!descriptor.isEnabled()) {
                iter.remove();
                continue;
            }
            try {
                RefactoringStatus filterStatus = new RefactoringStatus();
                if (descriptor.matches((IEvaluationContext)evalContext, filter, filterStatus)) {
                    RefactoringParticipant participant = shared.get(descriptor);
                    if (participant != null) {
                        ((ISharableParticipant)((Object)participant)).addElement(element, arguments);
                        continue;
                    }
                    participant = descriptor.createParticipant();
                    if (this.fParticipantClass.isInstance((Object)participant)) {
                        if (!participant.initialize(processor, element, arguments)) continue;
                        participant.setDescriptor(descriptor);
                        result.add(participant);
                        if (!(participant instanceof ISharableParticipant)) continue;
                        shared.put(descriptor, participant);
                        continue;
                    }
                    status.addError(Messages.format(RefactoringCoreMessages.ParticipantExtensionPoint_participant_removed, descriptor.getName()));
                    RefactoringCorePlugin.logErrorMessage(Messages.format(RefactoringCoreMessages.ParticipantExtensionPoint_wrong_type, new String[]{descriptor.getName(), this.fParticipantClass.getName()}));
                    iter.remove();
                    continue;
                }
                status.merge(filterStatus);
            }
            catch (RuntimeException | CoreException e) {
                this.logMalfunctioningParticipant(status, descriptor, e);
                iter.remove();
            }
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private void logMalfunctioningParticipant(RefactoringStatus status, ParticipantDescriptor descriptor, Throwable e) {
        status.addError(Messages.format(RefactoringCoreMessages.ParticipantExtensionPoint_participant_removed, descriptor.getName()));
        RefactoringCorePlugin.logRemovedParticipant(descriptor, e);
    }

    private void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor(this.fPluginId, this.fParticipantID);
        this.fParticipants = new ArrayList<ParticipantDescriptor>(ces.length);
        IConfigurationElement[] iConfigurationElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            ParticipantDescriptor descriptor = new ParticipantDescriptor(ce);
            IStatus status = descriptor.checkSyntax();
            switch (status.getSeverity()) {
                case 4: {
                    RefactoringCorePlugin.log(status);
                    break;
                }
                case 1: 
                case 2: {
                    RefactoringCorePlugin.log(status);
                    this.fParticipants.add(descriptor);
                    break;
                }
                default: {
                    this.fParticipants.add(descriptor);
                }
            }
            ++n2;
        }
    }

    private static EvaluationContext createEvaluationContext(RefactoringProcessor processor, Object element, String[] affectedNatures) {
        EvaluationContext result = new EvaluationContext(null, element);
        result.setAllowPluginActivation(true);
        result.addVariable("element", element);
        result.addVariable("affectedNatures", Arrays.asList(affectedNatures));
        result.addVariable("processorIdentifier", (Object)processor.getIdentifier());
        return result;
    }
}

