/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_bal_Latn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Arabi";
        final String metaValue_ru = "Rusi";
        final String metaValue_he = "Ebráni";
        final String metaValue_ja = "Jápáni";
        final String metaValue_km = "Khmér";
        final String metaValue_kn = "Kannadá";
        final String metaValue_ml = "Malyálam";
        final String metaValue_su = "Sudáni";
        final String metaValue_syr = "Siriek";
        final String metaValue_ta = "Támel";
        final String metaValue_th = "Tái";
        final String metaValue_vai = "Wái";
        final String metaValue_ssy = "Sahó";
        final Object[][] data = new Object[][] {
            { "001", "Donyá" },
            { "002", "Afriká" },
            { "003", "Shemáli Amriká" },
            { "005", "Zerbári Amriká" },
            { "009", "Ushiáná" },
            { "011", "Rónendi Apriká" },
            { "013", "Myáni Amriká" },
            { "014", "Ródarátki Apriká" },
            { "015", "Shemáli Apriká" },
            { "017", "Myáni Apriká" },
            { "018", "Jonubi Apriká" },
            { "019", "Amriká" },
            { "021", "Shemáli Amrika" },
            { "029", "Kerébian" },
            { "030", "Ródarátki Ásiá" },
            { "034", "Zerbári Ásiá" },
            { "035", "Zerbárródarátki Ásiá" },
            { "039", "Zerbári Yurop" },
            { "053", "Ástrálásiá" },
            { "054", "Melanésiá" },
            { "057", "Máekrónési Damag" },
            { "061", "Pólinisiá" },
            { "142", "Ásiá" },
            { "143", "Myáni Ásiá" },
            { "145", "Rónendi Ásiá" },
            { "150", "Yurop" },
            { "151", "Ródarátki Yurop" },
            { "154", "Shemáli Yurop" },
            { "155", "Rónendi Yurop" },
            { "202", "Sab-Sahári Apriká" },
            { "419", "Látini Amriká" },
            { "AC", "Asenshan Islánd" },
            { "AD", "Andorrá" },
            { "AE", "Emárát" },
            { "AF", "Awghánestán" },
            { "AG", "Antiga o Barbuda" },
            { "AI", "Angwila" },
            { "AL", "Albániá" },
            { "AM", "Árminiá" },
            { "AO", "Angólá" },
            { "AQ", "Antárktiká" },
            { "AR", "Arjentiná" },
            { "AS", "Amriki Samóá" },
            { "AT", "Ástriá" },
            { "AU", "Ásthréliá" },
            { "AW", "Aruba" },
            { "AX", "Áwlánd Islánd" },
            { "AZ", "Ázerbáiján" },
            { "BA", "Bósniá" },
            { "BB", "Barbadós" },
            { "BD", "Bangaladésh" },
            { "BE", "Béljiam" },
            { "BF", "Burkiná Pásó" },
            { "BG", "Balgáriá" },
            { "BH", "Bahren" },
            { "BI", "Borondi" },
            { "BJ", "Benin" },
            { "BL", "St. Bartélémi" },
            { "BM", "Barmudá" },
            { "BN", "Brunái" },
            { "BO", "Boliwiá" },
            { "BQ", "Kerébi Nedarlánd" },
            { "BR", "Brázil" },
            { "BS", "Bahamas" },
            { "BT", "Buthán" },
            { "BV", "Bówet Islánd" },
            { "BW", "Bostwáná" },
            { "BY", "Bélárus" },
            { "BZ", "Belize" },
            { "CA", "Kaynadhá" },
            { "CC", "Kukus Islánd (Kileng)" },
            { "CD", "Kángó-Kenshásá" },
            { "CF", "Myáni Apriki Eshtán" },
            { "CG", "Kángó-Brázáwille" },
            { "CH", "Swizarlánd" },
            { "CI", "Kóté diáwóri" },
            { "CK", "Kuk Islánd" },
            { "CL", "Chilay" },
            { "CM", "Kaymrun" },
            { "CN", "Chin" },
            { "CO", "Kólambiá" },
            { "CP", "Klipperton Islánd" },
            { "CQ", "Sárk" },
            { "CR", "Kóstá Riká" },
            { "CU", "Kyubá" },
            { "CV", "Kap Wardé" },
            { "CW", "Churácháó" },
            { "CX", "Kresmes Islánd" },
            { "CY", "Sáipras" },
            { "CZ", "Chéchiá" },
            { "DE", "Jarmani" },
            { "DG", "Diégó Gárshiá" },
            { "DJ", "Djebuti" },
            { "DK", "Denmárk" },
            { "DM", "Duminiká" },
            { "DO", "Duminiki Están" },
            { "DZ", "Aljiriá" },
            { "EA", "Siótó o Melilá" },
            { "EC", "Ekwádór" },
            { "EE", "Estóniá" },
            { "EG", "Mesr" },
            { "EH", "Róbarkati Sahárá" },
            { "ER", "Eritiriá" },
            { "ES", "Espin" },
            { "ET", "Etupiá" },
            { "EU", "Yuropi Yunian" },
            { "EZ", "Yurop-damag" },
            { "FI", "Fenlánd" },
            { "FJ", "Fiji" },
            { "FK", "Páklánd Islánd" },
            { "FM", "Mikrónéshiá" },
            { "FO", "Faróé Islánd" },
            { "FR", "Paráns" },
            { "GA", "Gabon" },
            { "GB", "Bartániá" },
            { "GD", "Gerená" },
            { "GE", "Járjiá" },
            { "GF", "Pránsi Gwiáná" },
            { "GG", "Gwernsay" },
            { "GH", "Gáná" },
            { "GI", "Gibráltar" },
            { "GL", "Grinlánd" },
            { "GM", "Gambiá" },
            { "GN", "Giniá" },
            { "GP", "Gwádelóp" },
            { "GQ", "Ekwáturi Giniá" },
            { "GR", "Yunán" },
            { "GS", "Zerbári Járjiá" },
            { "GT", "Gwátémálá" },
            { "GU", "Guám" },
            { "GW", "Giniá-Bissáu" },
            { "GY", "Goyáná" },
            { "HK", "Háng Káng o SAR Chin" },
            { "HM", "Hard o Mekdónald Islánd" },
            { "HN", "Honduras" },
            { "HR", "Króshiá" },
            { "HT", "Hayti" },
            { "HU", "Hangari" },
            { "IC", "Kanaray Islánd" },
            { "ID", "Endhonéshiá" },
            { "IE", "Áerlánd" },
            { "IL", "Esráil" },
            { "IM", "Áisale Mardom" },
            { "IN", "Hendostán" },
            { "IO", "Bartáni Hendi Zerdamag" },
            { "IQ", "Erák" },
            { "IR", "Érán" },
            { "IS", "Áeslánd" },
            { "IT", "Itáliá" },
            { "JE", "Jersé" },
            { "JM", "Jamáeká" },
            { "JO", "Ordon" },
            { "JP", "Jápán" },
            { "KE", "Kiniá" },
            { "KG", "Karghazestán" },
            { "KH", "Kambódhiá" },
            { "KI", "Kiribáti" },
            { "KM", "Komórós" },
            { "KN", "St. Kitts o Newis" },
            { "KP", "Shamáli Kóriá" },
            { "KR", "Zerbári Kóriá" },
            { "KW", "Kwayt" },
            { "KY", "Kaymi Islánd" },
            { "KZ", "Kázakhestán" },
            { "LA", "Láus" },
            { "LB", "Lebnán" },
            { "LC", "St. Lusiá" },
            { "LI", "Lichtenstén" },
            { "LK", "Sari Lanká" },
            { "LR", "Láibériá" },
            { "LS", "Lesótó" },
            { "LT", "Lituániá" },
            { "LU", "Loksembórg" },
            { "LV", "Latwiá" },
            { "LY", "Libyá" },
            { "MA", "Morókó" },
            { "MC", "Monákó" },
            { "MD", "Moldowá" },
            { "ME", "Montenegró" },
            { "MF", "St. Mártin" },
            { "MG", "Madagáskar" },
            { "MH", "Marshall Islánd" },
            { "MK", "Shemáli Makduniá" },
            { "ML", "Máli" },
            { "MM", "Myanmár (Barmá)" },
            { "MN", "Mangóliá" },
            { "MO", "Makaó SAR Chin" },
            { "MP", "Shemáli Máriáná Islánd" },
            { "MQ", "Mártinik" },
            { "MR", "Muritániá" },
            { "MS", "Montserrat" },
            { "MT", "Máltá" },
            { "MU", "Murishias" },
            { "MV", "Máldip" },
            { "MW", "Maláwi" },
            { "MX", "Meksikó" },
            { "MY", "Maléshiá" },
            { "MZ", "Mózambik" },
            { "NA", "Namibiá" },
            { "NC", "Niu Káledóniá" },
            { "NE", "Náiger" },
            { "NF", "Nórfolk Islánd" },
            { "NG", "Náijériá" },
            { "NI", "Nekárágóá" },
            { "NL", "Nedarlánd" },
            { "NO", "Nárway" },
            { "NP", "Népál" },
            { "NR", "Náuru" },
            { "NU", "Niué" },
            { "NZ", "Nyu Zilánd" },
            { "OM", "Omán" },
            { "PA", "Pánámá" },
            { "PE", "Péru" },
            { "PF", "Paránsi Pulinishiá" },
            { "PG", "Pápuá Niu Giniá" },
            { "PH", "Pelpin" },
            { "PK", "Pákestán" },
            { "PL", "Pólánd" },
            { "PM", "St. Péri o Mikwélin" },
            { "PN", "Pitkarén Islánd" },
            { "PR", "Piuró Rikó" },
            { "PS", "Palastinay Damag" },
            { "PT", "Portogál" },
            { "PW", "Paláu" },
            { "PY", "Parágóay" },
            { "QA", "Gatar" },
            { "QO", "Tálánén Zerbahrag" },
            { "RE", "Réyunian" },
            { "RO", "Rumániá" },
            { "RS", "Sarbiá" },
            { "RU", "Rus" },
            { "RW", "Rwándhá" },
            { "SA", "Saudi Arab" },
            { "SB", "Solomán Islánd" },
            { "SC", "Sécheles" },
            { "SD", "Sudán" },
            { "SE", "Swidhan" },
            { "SG", "Sengápur" },
            { "SH", "St. Heléná" },
            { "SI", "Slowiniá" },
            { "SJ", "Swalbard o Jan Mayén" },
            { "SK", "Slowákiá" },
            { "SL", "Sierrá Leóne" },
            { "SM", "San Mariánó" },
            { "SN", "Senigál" },
            { "SO", "Sómáliá" },
            { "SR", "Surinaym" },
            { "SS", "Zerbári Sudán" },
            { "ST", "Sáó Tóme o Prensip" },
            { "SV", "El Salwadór" },
            { "SX", "Sint Márten" },
            { "SY", "Suriá" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan dá Chonhá" },
            { "TC", "Tork o Káikói Islánd" },
            { "TD", "Chád" },
            { "TF", "Pránsi Zerbári Damag" },
            { "TG", "Tógó" },
            { "TH", "Táilánd" },
            { "TJ", "Tájekestán" },
            { "TK", "Tokéláu" },
            { "TL", "Témur-Leste" },
            { "TM", "Torkmenestán" },
            { "TN", "Tunishiá" },
            { "TO", "Tongá" },
            { "TR", "Turkiye" },
            { "TT", "Trinidad o Tobágó" },
            { "TV", "Tuwalu" },
            { "TW", "Táiwán" },
            { "TZ", "Tanzániá" },
            { "UA", "Yukrén" },
            { "UG", "Yugandhá" },
            { "UM", "U.S. Daráén Islánd" },
            { "UN", "Myánostománi Gal" },
            { "US", "Amrikáay Tepákén Están" },
            { "UY", "Yurógóay" },
            { "UZ", "Ozbekestán" },
            { "VA", "Wátikán Sethi" },
            { "VC", "St. Wensent o Grenádin" },
            { "VE", "Wenezwélá" },
            { "VG", "Bretáni Ajgén Islánd" },
            { "VI", "Amriki Ajgén Islánd" },
            { "VN", "Wietnám" },
            { "VU", "Wanuátu" },
            { "WF", "Wális o Futuná" },
            { "WS", "Samóá" },
            { "XA", "Kesási-Gálwár" },
            { "XB", "Kesási- Bidi" },
            { "XK", "Kósówó" },
            { "YE", "Yaman" },
            { "YT", "Mayotte" },
            { "ZA", "Zerbári Apriká" },
            { "ZM", "Zambiá" },
            { "ZW", "Zembábwé" },
            { "ZZ", "Nagisshetagén damag" },
            { "aa", "Apar" },
            { "ab", "Abkházi" },
            { "af", "Aprikái" },
            { "ak", "Akan" },
            { "am", "Amhari" },
            { "an", "Aragóni" },
            { "ar", metaValue_ar },
            { "as", "Asámi" },
            { "az", "Ázerbáijáni" },
            { "ba", "Bashkar" },
            { "be", "Bélárusi" },
            { "bg", "Bolgáriái" },
            { "bm", "Bambará" },
            { "bn", "Bangáli" },
            { "bo", "Tebbati" },
            { "br", "Brétón" },
            { "bs", "Busniái" },
            { "ca", "Katálan" },
            { "ce", "Chechen" },
            { "co", "Korsiki" },
            { "cs", "Chek" },
            { "cu", "Charch Sláwi" },
            { "cv", "Chuwash" },
            { "cy", "Wéli" },
            { "da", "Denmárki" },
            { "de", "Jarman" },
            { "dv", "Diwéhi" },
            { "dz", "Dzongká" },
            { "ee", "Ewe" },
            { "el", "Yunáni" },
            { "en", "Engrézi" },
            { "eo", "Esperántu" },
            { "es", "Espini" },
            { "et", "Estóniái" },
            { "eu", "Bask" },
            { "fa", "Pársi" },
            { "ff", "Pulá" },
            { "fi", "Fenlándi" },
            { "fo", "Paróese" },
            { "fr", "Paránsi" },
            { "fy", "Ferisi (Róbarkati)" },
            { "ga", "Áeri" },
            { "gd", "Eskáti Géli" },
            { "gl", "Galéki" },
            { "gn", "Guárián" },
            { "gu", "Gojráti" },
            { "gv", "Manks" },
            { "ha", "Hausá" },
            { "he", metaValue_he },
            { "hi", "Hendi" },
            { "hr", "Króshiái" },
            { "hu", "Hangári" },
            { "hy", "Arminiái" },
            { "ia", "Myánzobáni" },
            { "id", "Endónési" },
            { "ie", "Myánzobán" },
            { "ig", "Igbó" },
            { "ii", "Sichuái Yi" },
            { "io", "Idó" },
            { "is", "Islándi" },
            { "it", "Itáliái" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "Jáwáni" },
            { "ka", "Járjiái" },
            { "ki", "Kikuyu" },
            { "kk", "Kázák" },
            { "kl", "Kalállisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", "Kuriái" },
            { "ks", "Kashmiri" },
            { "ku", "Kordi" },
            { "kw", "Kornesh" },
            { "ky", "Kirgez" },
            { "la", "Látini" },
            { "lb", "Logzemborgi" },
            { "lg", "Gandá" },
            { "ln", "Lingálá" },
            { "lo", "Láó" },
            { "lt", "Litwániái" },
            { "lu", "Lubá-Katangá" },
            { "lv", "Latwiái" },
            { "mg", "Malagase" },
            { "mi", "Muri" },
            { "mk", "Makduni" },
            { "ml", metaValue_ml },
            { "mn", "Mangóli" },
            { "mr", "Maráthi" },
            { "ms", "Malai" },
            { "mt", "Maltiz" },
            { "my", "Barmái" },
            { "nb", "Nárwiji Bokmál" },
            { "nd", "Shemáli Nedébéle" },
            { "ne", "Népáli" },
            { "nl", "Dacch" },
            { "nn", "Nárwiji Nókén" },
            { "no", "Nárwiji" },
            { "nr", "Zerbári Nedebéli" },
            { "nv", "Nawájó" },
            { "ny", "Nyanjá" },
            { "oc", "Ositi" },
            { "om", "Oromó" },
            { "or", "Odi" },
            { "os", "Oséti" },
            { "pa", "Panjábi" },
            { "pl", "Pólayndi" },
            { "ps", "Pashtó" },
            { "pt", "Portagáli" },
            { "qu", "Kwichu" },
            { "rm", "Rumansh" },
            { "rn", "Róndi" },
            { "ro", "Rumániái" },
            { "ru", metaValue_ru },
            { "rw", "Kenyarwandá" },
            { "sa", "Sanskeret" },
            { "sc", "Sardéniái" },
            { "sd", "Sendi" },
            { "se", "Shemáli Sámi" },
            { "sg", "Sangó" },
            { "si", "Senhálá" },
            { "sk", "Solwák" },
            { "sl", "Solwiniái" },
            { "sn", "Shoná" },
            { "so", "Sómáli" },
            { "sq", "Albániái" },
            { "sr", "Sarbiái" },
            { "ss", "Swáti" },
            { "st", "Zerbári Sutó" },
            { "su", metaValue_su },
            { "sv", "Swidi" },
            { "sw", "Swáhéli" },
            { "ta", metaValue_ta },
            { "te", "Telgó" },
            { "tg", "Tájek" },
            { "th", metaValue_th },
            { "ti", "Tigriniá" },
            { "tk", "Trkm" },
            { "tn", "Tuswáná" },
            { "to", "Tongan" },
            { "tr", "Tork" },
            { "ts", "Tesungá" },
            { "tt", "Tátar" },
            { "ug", "Yughor" },
            { "uk", "Yukrini" },
            { "ur", "Urdu" },
            { "uz", "Ozbek" },
            { "ve", "Wendá" },
            { "vi", "Wietnámi" },
            { "vo", "Wolápuk" },
            { "wa", "Wallun" },
            { "wo", "Wolop" },
            { "xh", "Khushá" },
            { "yi", "Yeddi" },
            { "yo", "Yorobá" },
            { "za", "Zhuáng" },
            { "zh", "Chini" },
            { "zu", "Zulu" },
            { "agq", "Agem" },
            { "ann", "Obóló" },
            { "apc", "Latwiái Arabi" },
            { "arn", "Mapuche" },
            { "asa", "Asu" },
            { "ast", "Asturiái" },
            { "bal", "Balóchi" },
            { "bas", "Basá" },
            { "bem", "Bembá" },
            { "bew", "Betawi" },
            { "bez", "Bená" },
            { "bgc", "Haryánui" },
            { "bgn", "Balóchi (Róbarkati)" },
            { "bho", "Bójpuri" },
            { "blo", "Ani" },
            { "blt", "Tái Dam" },
            { "brx", "Bodó" },
            { "bss", "Akuse" },
            { "byn", "Blin" },
            { "cad", "Kaddó-kad" },
            { "cch", "Atsam" },
            { "ccp", "Chakmá" },
            { "ceb", "Chebuánó" },
            { "cgg", "Chigá" },
            { "cho", "Choktaw" },
            { "chr", "Cheruki" },
            { "cic", "Chekkásaw" },
            { "ckb", "Myáni Kordi" },
            { "csw", "Swampi Kri" },
            { "dav", "Táitá" },
            { "dje", "Zarmah" },
            { "doi", "Dogri" },
            { "dsb", "Láwar Sorbi" },
            { "dua", "Duálá" },
            { "dyo", "Jólá-Póni" },
            { "ebu", "Embó" },
            { "ewo", "Ewondó" },
            { "fil", "Pelpini" },
            { "frc", "Kájon Pránsi" },
            { "frr", "Shemáli Prési" },
            { "fur", "Priuli" },
            { "gaa", "Gaa" },
            { "gez", "Géz" },
            { "gsw", "Swiz Jarman" },
            { "guz", "Gusi" },
            { "haw", "Hawái" },
            { "hnj", "Hmang Njuá" },
            { "hsb", "Borzi Sorbiái" },
            { "jbo", "Lojban" },
            { "jgo", "Ngombá" },
            { "jmc", "Makami" },
            { "kaa", "Kara-Kalpak" },
            { "kab", "Kabáile" },
            { "kaj", "Jju" },
            { "kam", "Kambá" },
            { "kcg", "Tyáp" },
            { "kde", "Makonde" },
            { "kea", "Kubuwerdiánó" },
            { "ken", "Kinyang" },
            { "kgp", "Káingáng" },
            { "khq", "Koirá Chini" },
            { "kkj", "Kákó" },
            { "kln", "Kalenjin" },
            { "kok", "Konkani" },
            { "kpe", "Kpelle" },
            { "ksb", "Shambalá" },
            { "ksf", "Bapiá" },
            { "ksh", "Kologni" },
            { "kxv", "Kuwi" },
            { "lag", "Langi" },
            { "lij", "Liguri" },
            { "lkt", "Lakótá" },
            { "lld", "Ladin" },
            { "lmo", "Lombard" },
            { "lou", "Luisiáná Krióle" },
            { "lrc", "Shemáli Lori" },
            { "ltg", "Latgali" },
            { "luo", "Luó" },
            { "luy", "Luiá" },
            { "mai", "Maitéli" },
            { "mas", "Masai" },
            { "mdf", "Moksha" },
            { "mer", "Méru" },
            { "mfe", "Murisén" },
            { "mgh", "Makuá-Mitó" },
            { "mgo", "Métá" },
            { "mhn", "Móchénó" },
            { "mic", "Mikmaw" },
            { "mni", "Manipuri" },
            { "moh", "Mohawk" },
            { "mua", "Mundang" },
            { "mul", "Báz zobán" },
            { "mus", "Muskógi" },
            { "myv", "Erziá" },
            { "mzn", "Mázendaráni" },
            { "naq", "Nama" },
            { "nds", "Láw Jarman" },
            { "nmg", "Kwásiu" },
            { "nnh", "Ngembun" },
            { "nqo", "Nko" },
            { "nso", "Shemáli Sotó" },
            { "nus", "Nuér" },
            { "nyn", "Nyankóle" },
            { "osa", "Oságá" },
            { "pap", "Pápiámentó" },
            { "pcm", "Náijiri Pidgin" },
            { "pis", "Pijen" },
            { "prg", "Prushiái" },
            { "quc", "Kichi" },
            { "raj", "Rájestáni" },
            { "rhg", "Róhengiá" },
            { "rif", "Ripi" },
            { "rof", "Rombó" },
            { "rwk", "Rwa" },
            { "sah", "Yakut" },
            { "saq", "Samboró" },
            { "sat", "Santali" },
            { "sbp", "Sangu" },
            { "scn", "Sesiliái" },
            { "sdh", "Zerbári Kordi" },
            { "seh", "Sená" },
            { "ses", "Koryáburó Senni" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "sid", "Sidámó" },
            { "skr", "Saráeki" },
            { "sma", "Zerbári Sámi" },
            { "smj", "Lule Sámi" },
            { "smn", "Inári Sámi" },
            { "sms", "Eskált Sámi" },
            { "ssy", metaValue_ssy },
            { "syr", metaValue_syr },
            { "szl", "Selisi" },
            { "teo", "Tésó" },
            { "tig", "Tigré" },
            { "tok", "Tóki Póná" },
            { "tpi", "Tok Pisin" },
            { "trv", "Torokó" },
            { "trw", "Torwáli" },
            { "twq", "Tasawak" },
            { "tyv", "Tuwini" },
            { "tzm", "Tzm" },
            { "und", "Nagisshetagén zobán" },
            { "vai", metaValue_vai },
            { "vec", "Weneti" },
            { "vmw", "Makuwá" },
            { "vun", "Wunjó" },
            { "wae", "Welser" },
            { "wal", "Wolettá" },
            { "wbp", "Warlpiri" },
            { "xnr", "Kangri" },
            { "xog", "Sugá" },
            { "yav", "Yangben" },
            { "yrl", "Ningátu" },
            { "yue", "Kantóni" },
            { "zgh", "Gisshetqagén Moróki Tamázi" },
            { "zxx", "Hecch zobán" },
            { "Adlm", "Adlam" },
            { "Aghb", "Kákáshi Albáni" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastalik" },
            { "Armi", "Shahensháhi Aramái" },
            { "Armn", "Arman" },
            { "Avst", "Awestái" },
            { "Bali", "Báléni" },
            { "Bamu", "Bámum" },
            { "Bass", "Bassa Wah" },
            { "Batk", "Batak" },
            { "Beng", "Bang" },
            { "Bhks", "Baykduki" },
            { "Bopo", "Bópó" },
            { "Brah", "Brahmi" },
            { "Brai", "Brái" },
            { "Bugi", "Bugini" },
            { "Buhd", "Buhid" },
            { "Cakm", "Chakma" },
            { "Cans", "Kaynadhái Asligén Silábi" },
            { "Cari", "Charian" },
            { "Cher", "Cheoki" },
            { "Chrs", "Chorasmi" },
            { "Copt", "koptek" },
            { "Cpmn", "Sáepró-Minói" },
            { "Cprt", "Sáepriót" },
            { "Cyrl", metaValue_ru },
            { "Cyrs", "Ahdi Serelek" },
            { "Deva", "Déwá" },
            { "Diak", "Diwes Akuru" },
            { "Dogr", "Dogra" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Duplui Shárthand" },
            { "Egyp", "Mesri hirógleps" },
            { "Elba", "Elbási" },
            { "Elym", "Élimái" },
            { "Ethi", "Etyupi" },
            { "Gara", "Garay" },
            { "Geor", "Járj" },
            { "Glag", "Galgoliti" },
            { "Gong", "Gunjála Góndi" },
            { "Gonm", "Masáram Góndi" },
            { "Goth", "Góti" },
            { "Gran", "Grantá" },
            { "Grek", "Yun" },
            { "Gujr", "Gojr" },
            { "Gukh", "Gurong Khémá" },
            { "Guru", "Gurukuki" },
            { "Hanb", "Hán gón Bópómópóá" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hano", "Hanunu" },
            { "Hans", "Hán (sádah kortagén)" },
            { "Hant", "Hán (asligén)" },
            { "Hatr", "Hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "Hirágáná" },
            { "Hluw", "Anátólyái Hérógleps" },
            { "Hmng", "Pahaw Hmong" },
            { "Hmnp", "Niákeng Puáche Hamung" },
            { "Hrkt", "Jápáni Selibari" },
            { "Hung", "Ahdi Hangari" },
            { "Ital", "Ahdi Itáliái" },
            { "Jamo", "Jamó" },
            { "Java", "Jáwá" },
            { "Jpan", metaValue_ja },
            { "Kali", "Káyah Li" },
            { "Kana", "Katakaná" },
            { "Kawi", "Káwi" },
            { "Khar", "Karóshti" },
            { "Khmr", metaValue_km },
            { "Khoj", "Kójki" },
            { "Kits", "Kitan gwandhén syáhag" },
            { "Knda", metaValue_kn },
            { "Kore", "Kóriái" },
            { "Krai", "Kirat Rai" },
            { "Kthi", "Kaiti" },
            { "Lana", "Lanná" },
            { "Laoo", "Láu" },
            { "Latf", "Praktur Látin" },
            { "Latg", "Géli Látin" },
            { "Latn", "Látin Engrézi (Látin) Engrézi (Látin, Amrikáay Tepákén Están) syáhag: Látini" },
            { "Lepc", "Lepchá" },
            { "Limb", "Limbu" },
            { "Lina", "Layni A" },
            { "Linb", "Layni B" },
            { "Lisu", "Prásar" },
            { "Lyci", "Lisiái" },
            { "Lydi", "Lidiái" },
            { "Mahj", "Mahájani" },
            { "Maka", "Makasar" },
            { "Mand", "Mandáin" },
            { "Mani", "Manichái" },
            { "Marc", "Marchen" },
            { "Medf", "Medepáidrin" },
            { "Mend", "Mende" },
            { "Merc", "Meriuti Karsi" },
            { "Mero", "Meriuti" },
            { "Mlym", metaValue_ml },
            { "Modi", "Módi" },
            { "Mong", "Mongóli" },
            { "Mroo", "Mró" },
            { "Mtei", "Miyeti Máyek" },
            { "Mult", "Moltáni" },
            { "Mymr", "Myanmár" },
            { "Nagm", "Nag Mundari" },
            { "Nand", "Nandinagari" },
            { "Narb", "Ahdi Shemáli Arabi" },
            { "Nbat", "Nabatái" },
            { "Newa", "Newá" },
            { "Nkoo", "Nekó" },
            { "Nshu", "Nushu" },
            { "Ogam", "Oghám" },
            { "Olck", "Ol cheki" },
            { "Onao", "Ol Onal" },
            { "Orkh", "Orkhon" },
            { "Orya", "Ódiá" },
            { "Osge", "Oséj" },
            { "Osma", "Osmánia" },
            { "Ougr", "Ahdi Yógher" },
            { "Palm", "Palmrén" },
            { "Pauc", "Páu Chen Háu" },
            { "Perm", "Ahdi Permi" },
            { "Phag", "Pags-pa" },
            { "Phli", "Kondahi Pahlawi" },
            { "Phlp", "Psáltar Pahlawi" },
            { "Phnx", "Phónisi" },
            { "Plrd", "Pólli Tawári" },
            { "Prti", "Kondahi Párti" },
            { "Qaag", "Zawgi" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanipi" },
            { "Runr", "Runi" },
            { "Samr", "Samári" },
            { "Sarb", "Ahdi Zerbári Arabi" },
            { "Saur", "Sáuráshtri" },
            { "Sgnw", "Neshánnebisi" },
            { "Shaw", "Sháwi" },
            { "Shrd", "Sharadá" },
            { "Sidd", "Seddam" },
            { "Sind", "Kodáwadi" },
            { "Sinh", "Senhalá" },
            { "Sogd", "Sógdiái" },
            { "Sogo", "Ahdi Sógdiái" },
            { "Sora", "Surá Sompeng" },
            { "Soyo", "Soyombó" },
            { "Sund", metaValue_su },
            { "Sunu", "Sunuwar" },
            { "Sylo", "Siluti Nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "Estrangló Siriek" },
            { "Syrj", "Rónendi Siriek" },
            { "Syrn", "Ródarátki Siriek" },
            { "Tagb", "Tagbanwá" },
            { "Takr", "Takri" },
            { "Tale", "Tái Lé" },
            { "Talu", "Nókén Tái Lé" },
            { "Taml", metaValue_ta },
            { "Tang", "Tangut" },
            { "Tavt", "Tái Wiet" },
            { "Telu", "Telegó" },
            { "Tfng", "Tipinag" },
            { "Tglg", "Tagalog" },
            { "Thaa", "Tána" },
            { "Thai", metaValue_th },
            { "Tibt", "Tebati" },
            { "Tirh", "Tirhutá" },
            { "Tnsa", "Tangsá" },
            { "Todr", "Tódri" },
            { "Toto", "Tótó" },
            { "Tutg", "Tulu-Tigálari" },
            { "Ugar", "Yugariti" },
            { "Vaii", metaValue_vai },
            { "Vith", "Witkuki" },
            { "Wara", "Warang Kshiti" },
            { "Wcho", "Wanchó" },
            { "Xpeo", "Ahdi Pársi" },
            { "Xsux", "Sumer-Akádi Kyunipárm" },
            { "Yezi", "Yezidi" },
            { "Yiii", "Yi" },
            { "Zanb", "Zanabazar Eskwáer" },
            { "Zinh", "Enheri" },
            { "Zmth", "Hesábi Neshán" },
            { "Zsye", "Emóji" },
            { "Zsym", "Neshán" },
            { "Zxxx", "Nebeshtah nabutagén syáhag" },
            { "Zyyy", "Hórén" },
            { "Zzzz", "Kódh nakortagén syáhag" },
            { "en_CA", "Engrézi (Kaynadhá)" },
            { "es_MX", "Espini (Meksikó)" },
            { "fa_AF", "Pársi (AF)" },
            { "fr_CA", "Paránsi (Kaynadhá)" },
            { "nl_BE", "Dacch (Béljiam)" },
            { "ro_MD", "Rumániái (MD)" },
            { "sw_CD", "Swáhéli (CD)" },
            { "%%1901", "Rabyati Jarman nebeshtarahband" },
            { "%%1994", "Gisshetagén Réshian nebeshtarahband" },
            { "%%1996", "Jarman nebeshtarahband" },
            { "ar_001", "Arabi (Donyá)" },
            { "es_419", "Espini (Látini Amriká)" },
            { "key.ca", "Sáldar" },
            { "key.cf", "Zarr Káleb" },
            { "key.co", "Red o band" },
            { "key.cu", "Zarr" },
            { "key.hc", "Sáhatáni chahr (12 o 24)" },
            { "key.lb", "Red próshagay dáb" },
            { "key.ms", "Kayl kanagy rahband" },
            { "key.nu", "Nambar" },
            { "nds_NL", "Láw Jarman (NL)" },
            { "%%ALUKU", "Aluku gálwár" },
            { "%%BARLA", "Barlawentó gálwár granch, Kábuwerdiánu" },
            { "%%BCIAV", "BKIAW" },
            { "%%BISKE", "San Jiárjó/Bila gálwár" },
            { "%%BLASL", "BLÁSL" },
            { "%%BOONT", "Buntleng" },
            { "%%CORNU", "CÓRNU" },
            { "%%FODOM", "FODÓM" },
            { "%%GALLO", "GALLÓ" },
            { "%%GHERD", "GHÉRD" },
            { "%%JAUER", "JÁUÉR" },
            { "%%KKCOR", "Hawárén Nebeshtarahband" },
            { "%%KSCOR", "Gisshetagén Nebeshtarahband" },
            { "%%LIPAW", "Lipówázi gálwár, Réshi" },
            { "%%NEDIS", "Natisón gálwár" },
            { "%%NJIVA", "Gniwá/Njiwá gálwár" },
            { "%%NULIK", "Nókén Wolápuk" },
            { "%%OSOJS", "Osiákkó/Osójáné gálwár" },
            { "%%PEANO", "PEÁNÓ" },
            { "%%POSIX", "Kampyutar" },
            { "%%PUTER", "PUTÉR" },
            { "%%RIGIK", "Kalásiki Wólápuk" },
            { "%%ROZAJ", "Réshi" },
            { "%%RUMGR", "RÓMGR" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Stolwizá/Solbiká gálwár" },
            { "%%SOTAV", "Sotáwentó gálwár granch, Kabuwerdiánó" },
            { "%%TAILO", "TÁILÓ" },
            { "%%UCCOR", "Hamshawrén Nebeshtarahband" },
            { "hi_Latn", "Hendi (Látin Engrézi (Látin) Engrézi (Látin, Amrikáay Tepákén Están) syáhag: Látini)" },
            { "%%ANPEZO", "ANPÉZÓ" },
            { "%%AO1990", "Portogáli Zobánay Nebeshtarahbanday Mannánk 1990" },
            { "%%ARANES", "ARANÉS" },
            { "%%ASANTE", "ASANTÉ" },
            { "%%AUVERN", "AUWERN" },
            { "%%BCIZBL", "BKIZBL" },
            { "%%CISAUP", "CISÁUP" },
            { "%%CREISS", "CRÉISS" },
            { "%%DAJNKO", "Dajankó áb" },
            { "%%EKAVSK", "Sarbiái gón Ekwái gálwárá" },
            { "%%FASCIA", "FÁSCIÁ" },
            { "%%FONIPA", "IPA Tawári" },
            { "%%FONUPA", "UPA Tawári" },
            { "%%GASCON", "GASKÓN" },
            { "%%GRITAL", "GRITÁL" },
            { "%%NDYUKA", "Ndyuká gálwár" },
            { "%%NICARD", "NICÁRD" },
            { "%%PAMAKA", "Pamáká gálwár" },
            { "%%PINYIN", "Pinyin Látini" },
            { "%%SCOUSE", "Skáuz" },
            { "%%SIMPLE", "Sádah" },
            { "%%TARASK", "Taraskiwiká nebeshtarahband" },
            { "%%UCRCOR", "Hamshawrén Nókázén Nebeshtarahband" },
            { "%%ULSTER", "ULSTÉR" },
            { "%%UNIFON", "UNIFON-tawári áb" },
            { "bal_Latn", "Balóchi (Látin)" },
            { "%%ABL1943", "Nebeshtarahbnadi Gishwár 1943" },
            { "%%AKUAPEM", "AKUÁPÉM" },
            { "%%ALALC97", "ALA-LK Látini, 1997" },
            { "%%ARKAIKA", "ARKÁIKÁ" },
            { "%%BALANKA", "Balanká gálwár, Anii" },
            { "%%BAUDDHA", "BAUDDÁ" },
            { "%%BOHORIC", "Bohóri áb" },
            { "%%EMODENG", "Mahlahén Nókén Engrézi" },
            { "%%FONNAPA", "FONNÁPÁ" },
            { "%%GRCLASS", "GRKLÁSS" },
            { "%%GRMISTR", "GRMEST" },
            { "%%HEPBURN", "Hepburn Látini" },
            { "%%ITIHASA", "ITIHÁSÁ" },
            { "%%LAUKIKA", "LÁUKIKÁ" },
            { "%%LEMOSIN", "LÉMÓSIN" },
            { "%%LTG1929", "LTG-1929" },
            { "%%LTG2007", "LTG-2007" },
            { "%%METELKO", "Metelkó áb" },
            { "%%MONOTON", "Mónótáni" },
            { "%%PAHAWH2", "PAHAWH-2" },
            { "%%PAHAWH3", "PAHAWH-3" },
            { "%%PAHAWH4", "PAHAWH-4" },
            { "%%PEHOEJI", "PEHÓEJI" },
            { "%%POLYTON", "Pólituni" },
            { "%%PROVENC", "PROWENC" },
            { "%%REVISED", "Nókázén Nebeshtarahband" },
            { "%%SURSILV", "SURSILW" },
            { "%%SUTSILV", "SUTSILW" },
            { "%%VAIDIKA", "WAIDIKA" },
            { "%%1606NICT", "Randi Myáni Pránsi" },
            { "%%1694ACAD", "Mahlahén Nókén Pránsi" },
            { "%%1959ACAD", "Akádemi" },
            { "%%BAKU1926", "Hawárén Torki Látini Áb" },
            { "%%BASICENG", "BASIKENG" },
            { "%%BISCAYAN", "BISKAYAN" },
            { "%%BORNHOLM", "BÓRNHOLM" },
            { "%%COLB1945", "Portagézi-Brázili Nebeshtarahband Diwán 1945" },
            { "%%FONKIRSH", "FÓNKERSH" },
            { "%%FONXSAMP", "FONKSAMP" },
            { "%%HOGNORSK", "HÓGNÓRSK" },
            { "%%HSISTEMO", "HSISTEMÓ" },
            { "%%IJEKAVSK", "Sarbiái gón Ejekawái gálwárá" },
            { "%%IVANCHOV", "IWANCHÓW" },
            { "%%JYUTPING", "JYUTPÉNG" },
            { "%%KOCIEWIE", "KÓCIEWIÉ" },
            { "%%LENGADOC", "LENGÁDÓK" },
            { "%%LUNA1918", "LUNÁ-1918" },
            { "%%NEWFOUND", "NEWPOUND" },
            { "%%OXENDICT", "Ákspórd Engrézi Labzbaladay áp rahband" },
            { "%%PETR1708", "PÉTR-1708" },
            { "%%SCOTLAND", "Eskáti Gisshetagén Engrézi" },
            { "%%SPANGLIS", "SPÁNGLIS" },
            { "%%SURMIRAN", "SURMIRÁN" },
            { "%%SYNNEJYL", "SYNNÉJYL" },
            { "%%TONGYONG", "TONGYÓNG" },
            { "%%TUNUMIIT", "TUNUMIÉT" },
            { "%%VALBADIA", "WALBADIÁ" },
            { "%%VALENCIA", "Walensi" },
            { "%%VALLADER", "WALLADER" },
            { "%%VECDRUKA", "ÓECDRUKÁ" },
            { "%%VIVARAUP", "WIWARÁUP" },
            { "%%WADEGILE", "Wayd-Gili Látin" },
            { "%%XSISTEMO", "KSISTEMO" },
            { "type.ca.roc", "Mingu-Chini sáldar" },
            { "type.co.eor", "Yuropi Red o bandi Rahband" },
            { "type.hc.h11", "12 Sáhati (0–11)" },
            { "type.hc.h12", "12 Sáhati (1–12)" },
            { "type.hc.h23", "24 Sáhati (0–23)" },
            { "type.hc.h24", "14 Sáhati (1–24)" },
            { "type.nu.ahom", "Ahom Mórdán" },
            { "type.nu.arab", "Arabi-Hendi mórdán" },
            { "type.nu.armn", "Ármini Nambar" },
            { "type.nu.bali", "Báléni Mórdán" },
            { "type.nu.beng", "Bangla Mórdán" },
            { "type.nu.brah", "Brahmi Mórdán" },
            { "type.nu.cakm", "Chakma Mórdán" },
            { "type.nu.cham", "Cham Mórdán" },
            { "type.nu.cyrl", "Rusi mórdán" },
            { "type.nu.deva", "Dénágari mórdán" },
            { "type.nu.diak", "Diwi Akuru Mórdán" },
            { "type.nu.ethi", "Etupi Nambar" },
            { "type.nu.gara", "Garai Mórdán" },
            { "type.nu.geor", "Járjiái Nambar" },
            { "type.nu.gong", "Gunjála Góndi mórdán" },
            { "type.nu.gonm", "Masaram Góndi mórdán" },
            { "type.nu.grek", "Yunáni Nambar" },
            { "type.nu.gujr", "Gojráti Mórdán" },
            { "type.nu.gukh", "Gurong Khémá Mórdán" },
            { "type.nu.guru", "Gurmuki Mórdán" },
            { "type.nu.hans", "Sáda kortagén Chini Nambar" },
            { "type.nu.hant", "Chini Rabyati Nambar" },
            { "type.nu.hebr", "Ebráni Nambar" },
            { "type.nu.hmng", "Pahaw Hmong Mórdán" },
            { "type.nu.hmnp", "Nyákeng Páuchó Hmong Mórdán" },
            { "type.nu.java", "Jáwáni Mórdán" },
            { "type.nu.jpan", "Jápáni Nambar" },
            { "type.nu.kali", "Káyah Li Mórdán" },
            { "type.nu.kawi", "Kawi Mórdán" },
            { "type.nu.khmr", "Khmér Mórdán" },
            { "type.nu.knda", "Kannadái Mórdán" },
            { "type.nu.krai", "Kirat Rai Mórdán" },
            { "type.nu.lana", "Tai Tam Hórá Mórdán" },
            { "type.nu.laoo", "Láó Mórdán" },
            { "type.nu.latn", "Rónendi Mórdán" },
            { "type.nu.lepc", "Lepcha Mórdán" },
            { "type.nu.limb", "Limbu Mórdán" },
            { "type.nu.mlym", "Malyálam Mórdán" },
            { "type.nu.modi", "Módi Mórdán" },
            { "type.nu.mong", "Mongóli Mórdán" },
            { "type.nu.mroo", "Mró Mórdán" },
            { "type.nu.mtei", "Méti Mayék Mórdán" },
            { "type.nu.mymr", "Myánmár Mórdán" },
            { "type.nu.nagm", "Nag Mundari Mórdán" },
            { "type.nu.nkoo", "Nkó Mórdán" },
            { "type.nu.olck", "Ol Cheki Mórdán" },
            { "type.nu.onao", "Ol Onal Mórdán" },
            { "type.nu.orya", "Odi Mórdán" },
            { "type.nu.osma", "Osmániái Mórdán" },
            { "type.nu.rohg", "Hanipi Róhangiái Mórdán" },
            { "type.nu.saur", "Saurashtri Mórdán" },
            { "type.nu.shrd", "Sharadá Mórdán" },
            { "type.nu.sind", "Kodáwadi Mórdán" },
            { "type.nu.sinh", "Senhálá Lit Mórdán" },
            { "type.nu.sora", "Sórá Sompeng Mórdán" },
            { "type.nu.sund", "Sudáni Mórdán" },
            { "type.nu.sunu", "Sunuwar Mórdán" },
            { "type.nu.takr", "Takri Mórdán" },
            { "type.nu.talu", "Nókén Tai Lue Mórdán" },
            { "type.nu.taml", "Rabyati Támel Nambar" },
            { "type.nu.telu", "Telegó Mórdán" },
            { "type.nu.thai", "Tái Mórdán" },
            { "type.nu.tibt", "Tebbati Mórdán" },
            { "type.nu.tirh", "Tirutá Mórdán" },
            { "type.nu.tnsa", "Tangsá Mórdán" },
            { "type.nu.vaii", "Wái Mórdán" },
            { "type.nu.wara", "Warang Siti Mórdán" },
            { "type.nu.wcho", "Wanchó Mórdán" },
            { "type.ca.dangi", "Dángi sáldar" },
            { "type.co.ducet", "Aslén Yunikodi Red o band" },
            { "type.co.emoji", "Emóji Red o band" },
            { "type.lb.loose", "Red próshagay sholén dáb" },
            { "type.nu.roman", "Látini Nambar" },
            { "type.ca.coptic", "Kobti sáldar" },
            { "type.ca.hebrew", "Ebráni sáldar" },
            { "type.ca.indian", "Hendi Kawmi sáldar" },
            { "type.co.compat", "Pésari Red o band, pa hamdapiá" },
            { "type.co.pinyin", "Pinyi Red o band" },
            { "type.co.search", "Ám Kári Shóház" },
            { "type.co.stroke", "Strók Red o band" },
            { "type.co.unihan", "Trondén-stróki Red o band" },
            { "type.co.zhuyin", "Zhuin Red o band" },
            { "type.lb.normal", "Red próshagay ámigén dáb" },
            { "type.lb.strict", "Red próshagay trondén dáb" },
            { "type.ms.metric", "Mitari" },
            { "type.ca.chinese", "Chini sáldar" },
            { "type.ca.islamic", "Eslámi sáldar" },
            { "type.ca.iso8601", "ISO-8601 sáldar" },
            { "type.ca.persian", "Pársi sáldar" },
            { "type.cf.account", "Hesáb, Zarr Káleb" },
            { "type.nu.arabext", "Géshén Arabi-Hendi Mórdán" },
            { "type.nu.armnlow", "Árminiái Kasánén Nambar" },
            { "type.nu.greklow", "Yunáni Kasánén Nambar" },
            { "type.nu.hanidec", "Chini Dahi Nambar" },
            { "type.nu.hansfin", "Sáda kortagén Chini Hesábi Nambar" },
            { "type.nu.hantfin", "Chini Rabyati Hesáni Nambar" },
            { "type.nu.jpanfin", "Jápáni Hesábi Nambar" },
            { "type.nu.mathdbl", "Hesábi do-likki Mórdán" },
            { "type.nu.mymrpao", "Myánmár Pao Mórdán" },
            { "type.nu.tamldec", "Támel Mórdán" },
            { "type.ca.buddhist", "Buddái sáldar" },
            { "type.ca.ethiopic", "Etupiái sáldar" },
            { "type.ca.japanese", "Jápáni sáldar" },
            { "type.cf.standard", "Zarray anjárén káleb" },
            { "type.co.searchjl", "Hangul Awali Jwánábay sará shóház" },
            { "type.co.standard", "Anjári Red o band" },
            { "type.ms.uksystem", "Sháhensháhi Kayl Rahband" },
            { "type.ms.ussystem", "Amrikái Kayl Rahband" },
            { "type.nu.fullwide", "Srjam-Sháhegánén Mórdán" },
            { "type.nu.lanatham", "Tai Tam Tam Mórdán" },
            { "type.nu.mathbold", "Hesábi Dhalagén Mórdán" },
            { "type.nu.mathmono", "Hesábi Yakjáhén Mórdán" },
            { "type.nu.mathsanb", "Hesábi Sans-Serép Dhalagén Mórdán" },
            { "type.nu.mathsans", "Hesábi Sans-Serép Mórdán" },
            { "type.nu.mymrepka", "Myánmár Ródarátki Pwo Karen Mórdán" },
            { "type.nu.mymrshan", "Myánmár Shan Mórdán" },
            { "type.nu.mymrtlng", "Myánmár Tai Laing Mórdán" },
            { "type.nu.outlined", "Darlikki Mórdán" },
            { "type.nu.romanlow", "Látini Kasánén Nambar" },
            { "type.ca.gregorian", "Miládi sáldar" },
            { "type.co.phonebook", "Pawnbokki Red o band" },
            { "type.co.dictionary", "Labzbaladi Red o band" },
            { "type.co.traditional", "Rabyati Red o band" },
            { "type.ca.islamic-rgsa", "Eslámi Saudi-Arabi sáldar" },
            { "type.ca.islamic-tbla", "Eslámi Nojumi sáldar" },
            { "type.ca.islamic-civil", "Eslámi shahri sáldar" },
            { "type.ca.islamic-umalqura", "Eslámi Omm al-Korrahi sáldar" },
            { "type.ca.ethiopic-amete-alem", "Etupiái Ámet Álem sáldar" },
        };
        return data;
    }
}
