/*
 * Decompiled with CFR 0.152.
 */
package org.rogach.scallop;

import java.io.Serializable;
import org.rogach.scallop.CliOption;
import org.rogach.scallop.Formatter$;
import org.rogach.scallop.HelpInfo;
import org.rogach.scallop.Scallop;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractIterable;
import scala.collection.AbstractSeq;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class ScallopHelpFormatter {
    public String formatHelp(Scallop s, String subcommandPrefix) {
        String formattedHelp = new StringBuilder(0).append(this.getOptionsHelp(s)).append(this.getTrailingArgsHelp(s)).append(this.getSubcommandsHelp(s, subcommandPrefix)).toString();
        Object object = Predef$.MODULE$.refArrayOps(formattedHelp.split("\n"));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1<String, String> & Serializable)_$1 -> StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString((String)_$1))), (Function1<Object, Object>)(Function1<Object, boolean> & Serializable)x$0 -> ScallopHelpFormatter.formatHelp$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToChar(x$0))))), ClassTag$.MODULE$.apply(String.class))).mkString("\n");
    }

    public String getOptionsHelp(Scallop s) {
        return Formatter$.MODULE$.format((List<Either<String, HelpInfo>>)this.getOptionLines(s).flatMap((Function1<Either, IterableOnce> & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                String s = (String)((Left)either).value();
                return (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)package$.MODULE$.Left().apply(s)), Nil$.MODULE$));
            }
            if (either instanceof Right) {
                CliOption o = (CliOption)((Right)either).value();
                return o.helpInfo(s.getOptionShortNames(o)).map((Function1<HelpInfo, Right> & Serializable)_$2 -> package$.MODULE$.Right().apply(_$2));
            }
            throw new MatchError(either);
        }), s.helpWidth(), this.needToAppendDefaultToDescription(s));
    }

    public List<Either<String, CliOption>> getOptionLines(Scallop s) {
        return this.joinWithEmptyLineSeparator((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)this.getMainOptionLines(s)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.getOptionGroupsLines(s)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)((List)((IterableOps)this.getNormalOptionLines(s).$plus$plus(this.getHelpLine(s))).$plus$plus(this.getVersionLine(s)))), Nil$.MODULE$)))));
    }

    public List<Either<String, CliOption>> getMainOptionLines(Scallop s) {
        return s.mainOptions().map((Function1<CliOption, Right> & Serializable)_$3 -> package$.MODULE$.Right().apply(_$3));
    }

    public List<Either<String, CliOption>> getOptionGroupsLines(Scallop s) {
        return this.joinWithEmptyLineSeparator((List<List<Either<String, CliOption>>>)s.optionGroups().map((Function1<Tuple2, List> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String header = (String)tuple2._1();
                Seq options = (Seq)tuple2._2();
                return (List)((AbstractIterable)((List)((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)header), Nil$.MODULE$))).filter((Function1<String, boolean> & Serializable)_$4 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)_$4)))).map((Function1<String, Left> & Serializable)h -> package$.MODULE$.Left().apply(new StringBuilder(1).append(" ").append((String)h).toString()))).$plus$plus((IterableOnce)options.map((Function1<CliOption, Right> & Serializable)_$5 -> package$.MODULE$.Right().apply(_$5)));
            }
            throw new MatchError(tuple2);
        }));
    }

    public List<Either<String, CliOption>> getNormalOptionLines(Scallop s) {
        Set optionsInGroups = (Set)s.mainOptions().toSet().$plus$plus(s.optionGroups().flatMap((Function1<Tuple2, IterableOnce> & Serializable)_$6 -> (IterableOnce)_$6._2()));
        return ((List)((AbstractSeq)((List)((List)((List)s.opts().filter((Function1<CliOption, boolean> & Serializable)_$7 -> !_$7.isPositional())).filter((Function1<CliOption, boolean> & Serializable)_$8 -> !_$8.hidden())).filter((Function1<CliOption, boolean> & Serializable)o -> !optionsInGroups.contains(o))).filter((Function1<CliOption, boolean> & Serializable)o -> {
            String string2 = o.name();
            String string3 = "help";
            if (string2 == null) {
                if (string3 == null) return false;
            } else if (string2.equals(string3)) return false;
            String string4 = o.name();
            String string5 = "version";
            if (string4 == null) {
                if (string5 == null) return false;
                return true;
            } else if (string4.equals(string5)) return false;
            return true;
        })).sortBy((Function1<CliOption, String> & Serializable)_$9 -> _$9.name().toLowerCase(), (Ordering)Ordering$String$.MODULE$)).map((Function1<CliOption, Right> & Serializable)o -> package$.MODULE$.Right().apply(o));
    }

    public List<Either<String, CliOption>> getHelpLine(Scallop s) {
        CliOption helpOption = (CliOption)s.opts().find((Function1<CliOption, Object>)(Function1<CliOption, boolean> & Serializable)_$10 -> {
            String string2 = _$10.name();
            String string3 = "help";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }).getOrElse(() -> ScallopHelpFormatter.$anonfun$3(s));
        if (helpOption.hidden()) {
            return package$.MODULE$.Nil();
        }
        return (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)package$.MODULE$.Right().apply(helpOption)), Nil$.MODULE$));
    }

    public List<Either<String, CliOption>> getVersionLine(Scallop s) {
        Option versionOption = s.opts().find((Function1<CliOption, Object>)(Function1<CliOption, boolean> & Serializable)_$11 -> {
            String string2 = _$11.name();
            String string3 = "version";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }).orElse(() -> ScallopHelpFormatter.$anonfun$5(s)).filterNot((Function1<CliOption, boolean> & Serializable)_$13 -> _$13.hidden());
        Option option = versionOption;
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Nil();
        }
        if (option instanceof Some) {
            CliOption o = (CliOption)((Some)option).value();
            return (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)package$.MODULE$.Right().apply(o)), Nil$.MODULE$));
        }
        throw new MatchError(option);
    }

    public String getTrailingArgsHelp(Scallop s) {
        Object trailOpts = ((List)s.opts().filter((Function1<CliOption, boolean> & Serializable)_$14 -> _$14.isPositional())).filter((Function1<CliOption, boolean> & Serializable)_$15 -> !_$15.hidden());
        if (((List)trailOpts).isEmpty()) {
            return "";
        }
        String trailHelp = Formatter$.MODULE$.format((List<Either<String, HelpInfo>>)((List)((List)trailOpts).flatMap((Function1<CliOption, IterableOnce> & Serializable)_$16 -> _$16.helpInfo(package$.MODULE$.Nil()))).map((Function1<HelpInfo, Right> & Serializable)_$17 -> package$.MODULE$.Right().apply(_$17)), s.helpWidth(), this.needToAppendDefaultToDescription(s));
        return new StringBuilder(3).append("\n\n").append(this.getTrailingArgsSectionName()).append("\n").append(trailHelp).toString();
    }

    public String getTrailingArgsSectionName() {
        return " trailing arguments:";
    }

    public String getSubcommandsHelp(Scallop s, String subcommandPrefix) {
        if (s.subbuilders().isEmpty()) {
            return "";
        }
        if (s.shortSubcommandsHelp()) {
            return this.getShortSubcommandsHelp(s);
        }
        return this.getLongSubcommandsHelp(s, subcommandPrefix);
    }

    public String getShortSubcommandsHelp(Scallop s) {
        int maxCommandLength = BoxesRunTime.unboxToInt(((AbstractIterable)s.subbuilders().map((Function1<Tuple2, int> & Serializable)_$18 -> StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString((String)_$18._1())))).max(Ordering$Int$.MODULE$));
        return new StringBuilder(3).append("\n\n").append(this.getSubcommandsSectionName()).append("\n").append(((AbstractIterable)s.subbuilders().map((Function1<Tuple2, String> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Scallop option = (Scallop)tuple2._2();
                return new StringBuilder(5).append("  ").append(StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(name), maxCommandLength, ' ')).append("   ").append(option.descr()).toString();
            }
            throw new MatchError(tuple2);
        })).mkString("\n")).toString();
    }

    public String getSubcommandsSectionName() {
        return "Subcommands:";
    }

    public String getLongSubcommandsHelp(Scallop s, String subcommandPrefix) {
        return new StringBuilder(2).append("\n\n").append(((AbstractIterable)this.getSubcommandsWithNames(s).map((Function1<Tuple2, String> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Scallop sub = (Scallop)tuple2._1();
                List names = (List)tuple2._2();
                return this.getSubcommandHelp(sub, subcommandPrefix, names);
            }
            throw new MatchError(tuple2);
        })).mkString("\n\n")).toString();
    }

    public List<Tuple2<Scallop, List<String>>> getSubcommandsWithNames(Scallop s) {
        return (List)s.subbuilders().groupBy((Function1<Tuple2, Scallop> & Serializable)_$19 -> (Scallop)_$19._2()).map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Scallop subBuilder = (Scallop)tuple2._1();
                List names = (List)tuple2._2();
                return Tuple2$.MODULE$.apply(subBuilder, names.map((Function1<Tuple2, String> & Serializable)_$20 -> (String)_$20._1()));
            }
            throw new MatchError(tuple2);
        }).toList().sortBy((Function1<Tuple2, int> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Scallop subBuilder = (Scallop)tuple2._1();
                List names = (List)tuple2._2();
                return s.subbuilders().indexWhere((Function1<Tuple2<String, Scallop>, Object>)(Function1<Tuple2, boolean> & Serializable)_$21 -> {
                    Object T2 = _$21._2();
                    Scallop scallop = subBuilder;
                    return !(T2 != null ? !T2.equals(scallop) : scallop != null);
                });
            }
            throw new MatchError(tuple2);
        }, (Ordering)Ordering$Int$.MODULE$);
    }

    public String getSubcommandHelp(Scallop sub, String namePrefix, List<String> names) {
        return ((AbstractIterable)((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)this.getSubcommandHeader(sub, namePrefix, names)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)((String)sub.bann().getOrElse(ScallopHelpFormatter::getSubcommandHelp$$anonfun$1))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.getSubcommandOptionsHelp(sub, new StringBuilder(1).append(namePrefix).append(names.head()).append(" ").toString())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)((String)sub.foot().getOrElse(ScallopHelpFormatter::getSubcommandHelp$$anonfun$2))), Nil$.MODULE$)))))).filter((Function1<String, boolean> & Serializable)_$22 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)_$22)))).mkString("\n");
    }

    public String getSubcommandHeader(Scallop sub, String namePrefix, List<String> names) {
        String name = names.size() == 1 ? (String)names.head() : new StringBuilder(10).append((String)names.head()).append(" (alias: ").append(((IterableOnceOps)names.tail()).mkString(", ")).append(")").toString();
        String description = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(sub.descr())) ? new StringBuilder(3).append(" - ").append(sub.descr()).toString() : "";
        return new StringBuilder(0).append(this.getSubcommandHeaderPrefix()).append(namePrefix).append(name).append(description).toString();
    }

    public String getSubcommandHeaderPrefix() {
        return "Subcommand: ";
    }

    public String getSubcommandOptionsHelp(Scallop sub, String namePrefix) {
        Object object = Predef$.MODULE$.refArrayOps(this.formatHelp(sub, namePrefix).split("\n"));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1<String, boolean> & Serializable)_$23 -> !_$23.trim().startsWith("--version"))).mkString("\n");
    }

    public boolean needToAppendDefaultToDescription(Scallop s2) {
        return s2.appendDefaultToDescription() || s2.parent().exists((Function1<Scallop, Object>)(Function1<Scallop, boolean> & Serializable)s -> this.needToAppendDefaultToDescription((Scallop)s));
    }

    public String getChoiceHelpText(String description, Seq<String> choices) {
        return ((IterableOnceOps)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)description), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"Choices:"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)choices.mkString(", ")), Nil$.MODULE$)))).filter((Function1<String, boolean> & Serializable)_$24 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)_$24)))).mkString(" ");
    }

    private List<Either<String, CliOption>> joinWithEmptyLineSeparator(List<List<Either<String, CliOption>>> optionLists) {
        List<List<Either<String, CliOption>>> list2;
        while ((list2 = optionLists) instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list2;
            List list3 = $colon$colon.next$access$1();
            List first = (List)$colon$colon.head();
            if (!(list3 instanceof $colon$colon)) break;
            $colon$colon $colon$colon2 = ($colon$colon)list3;
            List list4 = $colon$colon2.next$access$1();
            List second = (List)$colon$colon2.head();
            List rest = list4;
            if (first.nonEmpty() && second.nonEmpty()) {
                List list5 = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)package$.MODULE$.Left().apply("")), Nil$.MODULE$));
                List list6 = second.$colon$colon$colon(list5).$colon$colon$colon(first);
                optionLists = rest.$colon$colon(list6);
                continue;
            }
            List list7 = second.$colon$colon$colon(first);
            optionLists = rest.$colon$colon(list7);
        }
        return (List)optionLists.flatten(Predef$.MODULE$.$conforms());
    }

    private static final /* synthetic */ boolean formatHelp$$anonfun$1$$anonfun$1(char x$0) {
        return Character.isWhitespace(x$0);
    }

    private static final CliOption $anonfun$3(Scallop s$2) {
        return s$2.getHelpOption();
    }

    private static final Option $anonfun$5(Scallop s$3) {
        return s$3.vers().flatMap((Function1<String, Option> & Serializable)_$12 -> s$3.getVersionOption());
    }

    private static final String getSubcommandHelp$$anonfun$1() {
        return "";
    }

    private static final String getSubcommandHelp$$anonfun$2() {
        return "";
    }
}

