/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnslabel;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.minidns.dnslabel.LdhLabel;
import org.minidns.dnslabel.NonLdhLabel;
import org.minidns.util.SafeCharSequence;

public abstract class DnsLabel
extends SafeCharSequence
implements Comparable<DnsLabel> {
    public static final int MAX_LABEL_LENGTH_IN_OCTETS = 63;
    public static final DnsLabel WILDCARD_LABEL = DnsLabel.from("*");
    public static boolean VALIDATE = true;
    public final String label;
    private transient String internationalizedRepresentation;
    private transient String safeToStringRepresentation;
    private transient DnsLabel lowercasedVariant;
    private transient byte[] byteCache;

    protected DnsLabel(String label) {
        this.label = label;
        if (!VALIDATE) {
            return;
        }
        this.setBytesIfRequired();
        if (this.byteCache.length > 63) {
            throw new LabelToLongException(label);
        }
    }

    public final String getInternationalizedRepresentation() {
        if (this.internationalizedRepresentation == null) {
            this.internationalizedRepresentation = this.getInternationalizedRepresentationInternal();
        }
        return this.internationalizedRepresentation;
    }

    protected String getInternationalizedRepresentationInternal() {
        return this.label;
    }

    public final String getLabelType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final String toString() {
        if (this.safeToStringRepresentation == null) {
            this.safeToStringRepresentation = DnsLabel.toSafeRepesentation(this.label);
        }
        return this.safeToStringRepresentation;
    }

    public final String getRawLabel() {
        return this.label;
    }

    public final boolean equals(Object other) {
        if (!(other instanceof DnsLabel)) {
            return false;
        }
        DnsLabel otherDnsLabel = (DnsLabel)other;
        return this.label.equals(otherDnsLabel.label);
    }

    public final int hashCode() {
        return this.label.hashCode();
    }

    public final DnsLabel asLowercaseVariant() {
        if (this.lowercasedVariant == null) {
            String lowercaseLabel = this.label.toLowerCase(Locale.US);
            this.lowercasedVariant = DnsLabel.from(lowercaseLabel);
        }
        return this.lowercasedVariant;
    }

    private void setBytesIfRequired() {
        if (this.byteCache == null) {
            this.byteCache = this.label.getBytes(StandardCharsets.US_ASCII);
        }
    }

    public final void writeToBoas(ByteArrayOutputStream byteArrayOutputStream) {
        this.setBytesIfRequired();
        byteArrayOutputStream.write(this.byteCache.length);
        byteArrayOutputStream.write(this.byteCache, 0, this.byteCache.length);
    }

    @Override
    public final int compareTo(DnsLabel other) {
        String myCanonical = this.asLowercaseVariant().label;
        String otherCanonical = other.asLowercaseVariant().label;
        return myCanonical.compareTo(otherCanonical);
    }

    public static DnsLabel from(String label) {
        if (label == null || label.isEmpty()) {
            throw new IllegalArgumentException("Label is null or empty");
        }
        if (LdhLabel.isLdhLabel(label)) {
            return LdhLabel.fromInternal(label);
        }
        return NonLdhLabel.fromInternal(label);
    }

    public static DnsLabel[] from(String[] labels) {
        DnsLabel[] res = new DnsLabel[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            res[i] = DnsLabel.from(labels[i]);
        }
        return res;
    }

    public static boolean isIdnAcePrefixed(String string2) {
        return string2.toLowerCase(Locale.US).startsWith("xn--");
    }

    public static String toSafeRepesentation(String dnsLabel) {
        if (DnsLabel.consistsOnlyOfLettersDigitsHypenAndUnderscore(dnsLabel)) {
            return dnsLabel;
        }
        StringBuilder sb = new StringBuilder(2 * dnsLabel.length());
        block6: for (int i = 0; i < dnsLabel.length(); ++i) {
            char c = dnsLabel.charAt(i);
            if (DnsLabel.isLdhOrMaybeUnderscore(c, true)) {
                sb.append(c);
                continue;
            }
            switch (c) {
                case '.': {
                    sb.append('\u25cf');
                    continue block6;
                }
                case '\\': {
                    sb.append('\u29f7');
                    continue block6;
                }
                case '\u007f': {
                    sb.append('\u2421');
                    continue block6;
                }
                case ' ': {
                    sb.append('\u2423');
                    continue block6;
                }
                default: {
                    if (c < ' ') {
                        int substituteAsInt = c + 9216;
                        assert (substituteAsInt <= 0x10FFFF);
                        char substitute = (char)substituteAsInt;
                        sb.append(substitute);
                        continue block6;
                    }
                    if (c < '\u007f') {
                        sb.append(c);
                        continue block6;
                    }
                    if (c > '\u00ff') {
                        throw new IllegalArgumentException("The string '" + dnsLabel + "' contains characters outside the 8-bit range: " + c + " at position " + i);
                    }
                    sb.append("\u301a");
                    String hex = String.format("%02X", c);
                    sb.append(hex);
                    sb.append("\u301b");
                }
            }
        }
        return sb.toString();
    }

    private static boolean isLdhOrMaybeUnderscore(char c, boolean underscore) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || underscore && c == '_';
    }

    private static boolean consistsOnlyOfLdhAndMaybeUnderscore(String string2, boolean underscore) {
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (DnsLabel.isLdhOrMaybeUnderscore(c, underscore)) continue;
            return false;
        }
        return true;
    }

    public static boolean consistsOnlyOfLettersDigitsAndHypen(String string2) {
        return DnsLabel.consistsOnlyOfLdhAndMaybeUnderscore(string2, false);
    }

    public static boolean consistsOnlyOfLettersDigitsHypenAndUnderscore(String string2) {
        return DnsLabel.consistsOnlyOfLdhAndMaybeUnderscore(string2, true);
    }

    public static class LabelToLongException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        public final String label;

        LabelToLongException(String label) {
            this.label = label;
        }
    }
}

