/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.workgroup.packet.SessionID;
import org.jivesoftware.smackx.workgroup.packet.UserID;
import org.jxmpp.JxmppContext;
import org.jxmpp.jid.Jid;

public class OfferRevokeProvider
extends IqProvider<IQ> {
    @Override
    public OfferRevokePacket parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        Jid userJID;
        Jid userID = userJID = ParserUtils.getJidAttribute(parser, jxmppContext);
        String reason = null;
        String sessionID = null;
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT && parser.getName().equals("reason")) {
                reason = parser.nextText();
                continue;
            }
            if (eventType == XmlPullParser.Event.START_ELEMENT && parser.getName().equals("session")) {
                sessionID = parser.getAttributeValue("", "id");
                continue;
            }
            if (eventType == XmlPullParser.Event.START_ELEMENT && parser.getName().equals("user")) {
                userID = ParserUtils.getJidAttribute(parser, "id", jxmppContext);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("offer-revoke")) continue;
            done = true;
        }
        return new OfferRevokePacket(userJID, userID, reason, sessionID);
    }

    public static class OfferRevokePacket
    extends IQ {
        public static final String ELEMENT = "offer-revoke";
        public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
        private final Jid userJID;
        private final Jid userID;
        private final String sessionID;
        private final String reason;

        public OfferRevokePacket(Jid userJID, Jid userID, String cause, String sessionID) {
            super(ELEMENT, NAMESPACE);
            this.userJID = userJID;
            this.userID = userID;
            this.reason = cause;
            this.sessionID = sessionID;
        }

        public Jid getUserJID() {
            return this.userJID;
        }

        public Jid getUserID() {
            return this.userID;
        }

        public String getReason() {
            return this.reason;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        @Override
        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
            buf.append(" jid=\"").append(this.userID).append("\">");
            if (this.reason != null) {
                buf.append("<reason>").append(this.reason).append("</reason>");
            }
            if (this.sessionID != null) {
                buf.append(new SessionID(this.sessionID).toXML());
            }
            if (this.userID != null) {
                buf.append(new UserID(this.userID).toXML());
            }
            return buf;
        }
    }
}

