/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jxmpp.jid.BareJid;

public class Affiliation
implements XmlElement {
    public static final String ELEMENT = "affiliation";
    private final BareJid jid;
    private final String node;
    private final Type affiliation;
    private final AffiliationNamespace namespace;

    public Affiliation(String node, Type affiliation) {
        this(node, affiliation, affiliation == null ? AffiliationNamespace.basic : AffiliationNamespace.owner);
    }

    public Affiliation(String node, Type affiliation, AffiliationNamespace namespace) {
        this.node = StringUtils.requireNotNullNorEmpty(node, "node must not be null nor empty");
        this.affiliation = affiliation;
        this.jid = null;
        this.namespace = Objects.requireNonNull(namespace);
    }

    public Affiliation(BareJid jid, Type affiliation) {
        this(jid, affiliation, AffiliationNamespace.owner);
    }

    public Affiliation(BareJid jid, Type affiliation, AffiliationNamespace namespace) {
        this.jid = jid;
        this.affiliation = affiliation;
        this.node = null;
        this.namespace = namespace;
    }

    @Deprecated
    public String getNodeId() {
        return this.getNode();
    }

    public String getNode() {
        return this.node;
    }

    @Deprecated
    public Type getType() {
        return this.getAffiliation();
    }

    public Type getAffiliation() {
        return this.affiliation;
    }

    public BareJid getJid() {
        return this.jid;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return this.getPubSubNamespace().getXmlns();
    }

    public PubSubNamespace getPubSubNamespace() {
        return this.namespace.type.getNamespace();
    }

    public boolean isAffiliationModification() {
        if (this.jid != null && this.affiliation != null) {
            assert (this.node == null && this.namespace == AffiliationNamespace.owner);
            return true;
        }
        return false;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder(this);
        xml.optAttribute("node", this.node);
        xml.optAttribute("jid", this.jid);
        xml.optAttribute(ELEMENT, this.affiliation);
        xml.closeEmptyElement();
        return xml;
    }

    public static enum AffiliationNamespace {
        basic(PubSubElementType.AFFILIATIONS),
        owner(PubSubElementType.AFFILIATIONS_OWNER);

        public final PubSubElementType type;

        private AffiliationNamespace(PubSubElementType type) {
            this.type = type;
        }

        public static AffiliationNamespace fromXmlns(String xmlns) {
            for (AffiliationNamespace affiliationsNamespace : AffiliationNamespace.values()) {
                if (!affiliationsNamespace.type.getNamespace().getXmlns().equals(xmlns)) continue;
                return affiliationsNamespace;
            }
            throw new IllegalArgumentException("Invalid affiliations namespace: " + xmlns);
        }
    }

    public static enum Type {
        member,
        none,
        outcast,
        owner,
        publisher;

    }
}

