/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.control.provider;

import java.io.IOException;
import java.util.ArrayList;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.iot.control.element.IoTSetRequest;
import org.jivesoftware.smackx.iot.control.element.SetBoolData;
import org.jivesoftware.smackx.iot.control.element.SetData;
import org.jivesoftware.smackx.iot.control.element.SetDoubleData;
import org.jivesoftware.smackx.iot.control.element.SetIntData;
import org.jivesoftware.smackx.iot.control.element.SetLongData;
import org.jxmpp.JxmppContext;

public class IoTSetRequestProvider
extends IqProvider<IoTSetRequest> {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IoTSetRequest parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        ArrayList<SetData> data = new ArrayList<SetData>(4);
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "bool": {
                            String valueName = parser.getAttributeValue(null, "name");
                            String valueString = parser.getAttributeValue(null, "value");
                            boolean value = Boolean.parseBoolean(valueString);
                            data.add(new SetBoolData(valueName, value));
                            break block0;
                        }
                        case "double": {
                            String valueName = parser.getAttributeValue(null, "name");
                            String valueString = parser.getAttributeValue(null, "value");
                            double value = Double.parseDouble(valueString);
                            data.add(new SetDoubleData(valueName, value));
                            break block0;
                        }
                        case "int": {
                            String valueName = parser.getAttributeValue(null, "name");
                            String valueString = parser.getAttributeValue(null, "value");
                            int value = Integer.parseInt(valueString);
                            data.add(new SetIntData(valueName, value));
                            break block0;
                        }
                        case "long": {
                            String valueName = parser.getAttributeValue(null, "name");
                            String valueString = parser.getAttributeValue(null, "value");
                            long value = Long.parseLong(valueString);
                            data.add(new SetLongData(valueName, value));
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new IoTSetRequest(data);
                }
            }
        }
    }
}

