# Environment variables

uv defines and respects the following environment variables:

### `UV_BREAK_SYSTEM_PACKAGES`
<small class="added-in">added in `0.1.32`</small>

Equivalent to the `--break-system-packages` command-line argument. If set to `true`,
uv will allow the installation of packages that conflict with system-installed packages.

WARNING: `UV_BREAK_SYSTEM_PACKAGES=true` is intended for use in continuous integration
(CI) or containerized environments and should be used with caution, as modifying the system
Python can lead to unexpected behavior.

### `UV_BUILD_CONSTRAINT`
<small class="added-in">added in `0.2.34`</small>

Equivalent to the `--build-constraints` command-line argument. If set, uv will use this file
as constraints for any source distribution builds. Uses space-separated list of files.

### `UV_CACHE_DIR`
<small class="added-in">added in `0.0.5`</small>

Equivalent to the `--cache-dir` command-line argument. If set, uv will use this
directory for caching instead of the default cache directory.

### `UV_COMPILE_BYTECODE`
<small class="added-in">added in `0.3.3`</small>

Equivalent to the `--compile-bytecode` command-line argument. If set, uv
will compile Python source files to bytecode after installation.

### `UV_COMPILE_BYTECODE_TIMEOUT`
<small class="added-in">added in `0.7.22`</small>

Timeout (in seconds) for bytecode compilation.

### `UV_CONCURRENT_BUILDS`
<small class="added-in">added in `0.1.43`</small>

Sets the maximum number of source distributions that uv will build
concurrently at any given time.

### `UV_CONCURRENT_DOWNLOADS`
<small class="added-in">added in `0.1.43`</small>

Sets the maximum number of in-flight concurrent downloads that uv will
perform at any given time.

### `UV_CONCURRENT_INSTALLS`
<small class="added-in">added in `0.1.45`</small>

Controls the number of threads used when installing and unzipping
packages.

### `UV_CONFIG_FILE`
<small class="added-in">added in `0.1.34`</small>

Equivalent to the `--config-file` command-line argument. Expects a path to a
local `uv.toml` file to use as the configuration file.

### `UV_CONSTRAINT`
<small class="added-in">added in `0.1.36`</small>

Equivalent to the `--constraints` command-line argument. If set, uv will use this
file as the constraints file. Uses space-separated list of files.

### `UV_CREDENTIALS_DIR`
<small class="added-in">added in `0.8.15`</small>

The directory for storage of credentials when using a plain text backend.

### `UV_CUSTOM_COMPILE_COMMAND`
<small class="added-in">added in `0.1.23`</small>

Equivalent to the `--custom-compile-command` command-line argument.

Used to override uv in the output header of the `requirements.txt` files generated by
`uv pip compile`. Intended for use-cases in which `uv pip compile` is called from within a wrapper
script, to include the name of the wrapper script in the output file.

### `UV_DEFAULT_INDEX`
<small class="added-in">added in `0.4.23`</small>

Equivalent to the `--default-index` command-line argument. If set, uv will use
this URL as the default index when searching for packages.

### `UV_DEV`
<small class="added-in">added in `0.8.7`</small>

Equivalent to the `--dev` command-line argument. If set, uv will include
development dependencies.

### `UV_DOWNLOAD_URL`
<small class="added-in">added in `0.8.4`</small>

The URL from which to download uv using the standalone installer. By default, installs from
uv's GitHub Releases. `INSTALLER_DOWNLOAD_URL` is also supported as an alias, for backwards
compatibility.

### `UV_ENV_FILE`
<small class="added-in">added in `0.4.30`</small>

`.env` files from which to load environment variables when executing `uv run` commands.

### `UV_EXCLUDE`
<small class="added-in">added in `0.9.8`</small>

Equivalent to the `--excludes` command-line argument. If set, uv will use this
as the excludes file. Uses space-separated list of files.

### `UV_EXCLUDE_NEWER`
<small class="added-in">added in `0.2.12`</small>

Equivalent to the `--exclude-newer` command-line argument. If set, uv will
exclude distributions published after the specified date.

### `UV_EXTRA_INDEX_URL`
<small class="added-in">added in `0.1.3`</small>

Equivalent to the `--extra-index-url` command-line argument. If set, uv will
use this space-separated list of URLs as additional indexes when searching for packages.
(Deprecated: use `UV_INDEX` instead.)

### `UV_FIND_LINKS`
<small class="added-in">added in `0.4.19`</small>

Equivalent to the `--find-links` command-line argument. If set, uv will use this
comma-separated list of additional locations to search for packages.

### `UV_FORK_STRATEGY`
<small class="added-in">added in `0.5.9`</small>

Equivalent to the `--fork-strategy` argument. Controls version selection during universal
resolution.

### `UV_FROZEN`
<small class="added-in">added in `0.4.25`</small>

Equivalent to the `--frozen` command-line argument. If set, uv will run without
updating the `uv.lock` file.

### `UV_GITHUB_TOKEN`
<small class="added-in">added in `0.4.10`</small>

Equivalent to the `--token` argument for self update. A GitHub token for authentication.

### `UV_GIT_LFS`
<small class="added-in">added in `0.5.19`</small>

Enables fetching files stored in Git LFS when installing a package from a Git repository.

### `UV_HTTP_RETRIES`
<small class="added-in">added in `0.7.21`</small>

The number of retries for HTTP requests. (default: 3)

### `UV_HTTP_TIMEOUT`
<small class="added-in">added in `0.1.7`</small>

Timeout (in seconds) for HTTP requests. (default: 30 s)

### `UV_INDEX`
<small class="added-in">added in `0.4.23`</small>

Equivalent to the `--index` command-line argument. If set, uv will use this
space-separated list of URLs as additional indexes when searching for packages.

### `UV_INDEX_STRATEGY`
<small class="added-in">added in `0.1.29`</small>

Equivalent to the `--index-strategy` command-line argument.

For example, if set to `unsafe-best-match`, uv will consider versions of a given package
available across all index URLs, rather than limiting its search to the first index URL
that contains the package.

### `UV_INDEX_URL`
<small class="added-in">added in `0.0.5`</small>

Equivalent to the `--index-url` command-line argument. If set, uv will use this
URL as the default index when searching for packages.
(Deprecated: use `UV_DEFAULT_INDEX` instead.)

### `UV_INDEX_{name}_PASSWORD`
<small class="added-in">added in `0.4.23`</small>

Provides the HTTP Basic authentication password for a named index.

The `name` parameter is the name of the index. For example, given an index named `foo`,
the environment variable key would be `UV_INDEX_FOO_PASSWORD`.

### `UV_INDEX_{name}_USERNAME`
<small class="added-in">added in `0.4.23`</small>

Provides the HTTP Basic authentication username for a named index.

The `name` parameter is the name of the index. For example, given an index named `foo`,
the environment variable key would be `UV_INDEX_FOO_USERNAME`.

### `UV_INIT_BUILD_BACKEND`
<small class="added-in">added in `0.8.2`</small>

Equivalent to the `--build-backend` argument for `uv init`. Determines the default backend
to use when creating a new project.

### `UV_INSECURE_HOST`
<small class="added-in">added in `0.3.5`</small>

Equivalent to the `--allow-insecure-host` argument.

### `UV_INSECURE_NO_ZIP_VALIDATION`
<small class="added-in">added in `0.8.6`</small>

Disable ZIP validation for streamed wheels and ZIP-based source distributions.

WARNING: Disabling ZIP validation can expose your system to security risks by bypassing
integrity checks and allowing uv to install potentially malicious ZIP files. If uv rejects
a ZIP file due to failing validation, it is likely that the file is malformed; consider
filing an issue with the package maintainer.

### `UV_INSTALLER_GHE_BASE_URL`
<small class="added-in">added in `0.5.0`</small>

The URL from which to download uv using the standalone installer and `self update` feature,
in lieu of the default GitHub Enterprise URL.

### `UV_INSTALLER_GITHUB_BASE_URL`
<small class="added-in">added in `0.5.0`</small>

The URL from which to download uv using the standalone installer and `self update` feature,
in lieu of the default GitHub URL.

### `UV_INSTALL_DIR`
<small class="added-in">added in `0.5.0`</small>

The directory in which to install uv using the standalone installer and `self update` feature.
Defaults to `~/.local/bin`.

### `UV_ISOLATED`
<small class="added-in">added in `0.8.14`</small>

Equivalent to the `--isolated` command-line argument. If set, uv will avoid discovering
a `pyproject.toml` or `uv.toml` file.

### `UV_KEYRING_PROVIDER`
<small class="added-in">added in `0.1.19`</small>

Equivalent to the `--keyring-provider` command-line argument. If set, uv
will use this value as the keyring provider.

### `UV_LIBC`
<small class="added-in">added in `0.7.22`</small>

Overrides the environment-determined libc on linux systems when filling in the current platform
within Python version requests. Options are: `gnu`, `gnueabi`, `gnueabihf`, `musl`, and `none`.

### `UV_LINK_MODE`
<small class="added-in">added in `0.1.40`</small>

Equivalent to the `--link-mode` command-line argument. If set, uv will use this as
a link mode.

### `UV_LOCKED`
<small class="added-in">added in `0.4.25`</small>

Equivalent to the `--locked` command-line argument. If set, uv will assert that the
`uv.lock` remains unchanged.

### `UV_LOG_CONTEXT`
<small class="added-in">added in `0.6.4`</small>

Add additional context and structure to log messages.

If logging is not enabled, e.g., with `RUST_LOG` or `-v`, this has no effect.

### `UV_MANAGED_PYTHON`
<small class="added-in">added in `0.6.8`</small>

Require use of uv-managed Python versions.

### `UV_NATIVE_TLS`
<small class="added-in">added in `0.1.19`</small>

Equivalent to the `--native-tls` command-line argument. If set to `true`, uv will
use the system's trust store instead of the bundled `webpki-roots` crate.

### `UV_NO_BINARY`
<small class="added-in">added in `0.5.30`</small>

Equivalent to the `--no-binary` command-line argument. If set, uv will install
all packages from source. The resolver will still use pre-built wheels to
extract package metadata, if available.

### `UV_NO_BINARY_PACKAGE`
<small class="added-in">added in `0.5.30`</small>

Equivalent to the `--no-binary-package` command line argument. If set, uv will
not use pre-built wheels for the given space-delimited list of packages.

### `UV_NO_BUILD`
<small class="added-in">added in `0.1.40`</small>

Equivalent to the `--no-build` command-line argument. If set, uv will not build
source distributions.

### `UV_NO_BUILD_ISOLATION`
<small class="added-in">added in `0.1.40`</small>

Equivalent to the `--no-build-isolation` command-line argument. If set, uv will
skip isolation when building source distributions.

### `UV_NO_BUILD_PACKAGE`
<small class="added-in">added in `0.6.5`</small>

Equivalent to the `--no-build-package` command line argument. If set, uv will
not build source distributions for the given space-delimited list of packages.

### `UV_NO_CACHE`
<small class="added-in">added in `0.1.2`</small>

Equivalent to the `--no-cache` command-line argument. If set, uv will not use the
cache for any operations.

### `UV_NO_CONFIG`
<small class="added-in">added in `0.2.30`</small>

Equivalent to the `--no-config` command-line argument. If set, uv will not read
any configuration files from the current directory, parent directories, or user configuration
directories.

### `UV_NO_DEFAULT_GROUPS`
<small class="added-in">added in `0.9.9`</small>

Equivalent to the `--no-default-groups` command-line argument. If set, uv will
not select the default dependency groups defined in `tool.uv.default-groups`.

### `UV_NO_DEV`
<small class="added-in">added in `0.8.7`</small>

Equivalent to the `--no-dev` command-line argument. If set, uv will exclude
development dependencies.

### `UV_NO_EDITABLE`
<small class="added-in">added in `0.6.15`</small>

Equivalent to the `--no-editable` command-line argument. If set, uv
installs or exports any editable dependencies, including the project and any workspace
members, as non-editable.

### `UV_NO_ENV_FILE`
<small class="added-in">added in `0.4.30`</small>

Ignore `.env` files when executing `uv run` commands.

### `UV_NO_GITHUB_FAST_PATH`
<small class="added-in">added in `0.7.13`</small>

Disable GitHub-specific requests that allow uv to skip `git fetch` in some circumstances.

### `UV_NO_GROUP`
<small class="added-in">added in `0.9.8`</small>

Equivalent to the `--no-group` command-line argument. If set, uv will disable
the specified dependency groups for the given space-delimited list of packages.

### `UV_NO_HF_TOKEN`
<small class="added-in">added in `0.8.1`</small>

Disable Hugging Face authentication, even if `HF_TOKEN` is set.

### `UV_NO_INSTALLER_METADATA`
<small class="added-in">added in `0.5.7`</small>

Skip writing `uv` installer metadata files (e.g., `INSTALLER`, `REQUESTED`, and `direct_url.json`) to site-packages `.dist-info` directories.

### `UV_NO_MANAGED_PYTHON`
<small class="added-in">added in `0.6.8`</small>

Disable use of uv-managed Python versions.

### `UV_NO_MODIFY_PATH`
<small class="added-in">added in `0.8.4`</small>

Avoid modifying the `PATH` environment variable when installing uv using the standalone
installer and `self update` feature. `INSTALLER_NO_MODIFY_PATH` is also supported as an
alias, for backwards compatibility.

### `UV_NO_PROGRESS`
<small class="added-in">added in `0.2.28`</small>

Equivalent to the `--no-progress` command-line argument. Disables all progress output. For
example, spinners and progress bars.

### `UV_NO_SOURCES`
<small class="added-in">added in `0.9.8`</small>

Equivalent to the `--no-sources` command-line argument. If set, uv will ignore
`[tool.uv.sources]` annotations when resolving dependencies.

### `UV_NO_SYNC`
<small class="added-in">added in `0.4.18`</small>

Equivalent to the `--no-sync` command-line argument. If set, uv will skip updating
the environment.

### `UV_NO_VERIFY_HASHES`
<small class="added-in">added in `0.5.3`</small>

Equivalent to the `--no-verify-hashes` argument. Disables hash verification for
`requirements.txt` files.

### `UV_NO_WRAP`
<small class="added-in">added in `0.0.5`</small>

Use to disable line wrapping for diagnostics.

### `UV_OFFLINE`
<small class="added-in">added in `0.5.9`</small>

Equivalent to the `--offline` command-line argument. If set, uv will disable network access.

### `UV_OVERRIDE`
<small class="added-in">added in `0.2.22`</small>

Equivalent to the `--overrides` command-line argument. If set, uv will use this file
as the overrides file. Uses space-separated list of files.

### `UV_PRERELEASE`
<small class="added-in">added in `0.1.16`</small>

Equivalent to the `--prerelease` command-line argument. For example, if set to
`allow`, uv will allow pre-release versions for all dependencies.

### `UV_PREVIEW`
<small class="added-in">added in `0.1.37`</small>

Equivalent to the `--preview` argument. Enables preview mode.

### `UV_PREVIEW_FEATURES`
<small class="added-in">added in `0.8.4`</small>

Equivalent to the `--preview-features` argument. Enables specific preview features.

### `UV_PROJECT`
<small class="added-in">added in `0.4.4`</small>

Equivalent to the `--project` command-line argument.

### `UV_PROJECT_ENVIRONMENT`
<small class="added-in">added in `0.4.4`</small>

Specifies the path to the directory to use for a project virtual environment.

See the [project documentation](../concepts/projects/config.md#project-environment-path)
for more details.

### `UV_PUBLISH_CHECK_URL`
<small class="added-in">added in `0.4.30`</small>

Don't upload a file if it already exists on the index. The value is the URL of the index.

### `UV_PUBLISH_INDEX`
<small class="added-in">added in `0.5.8`</small>

Equivalent to the `--index` command-line argument in `uv publish`. If
set, uv the index with this name in the configuration for publishing.

### `UV_PUBLISH_PASSWORD`
<small class="added-in">added in `0.4.16`</small>

Equivalent to the `--password` command-line argument in `uv publish`. If
set, uv will use this password for publishing.

### `UV_PUBLISH_TOKEN`
<small class="added-in">added in `0.4.16`</small>

Equivalent to the `--token` command-line argument in `uv publish`. If set, uv
will use this token (with the username `__token__`) for publishing.

### `UV_PUBLISH_URL`
<small class="added-in">added in `0.4.16`</small>

Equivalent to the `--publish-url` command-line argument. The URL of the upload
endpoint of the index to use with `uv publish`.

### `UV_PUBLISH_USERNAME`
<small class="added-in">added in `0.4.16`</small>

Equivalent to the `--username` command-line argument in `uv publish`. If
set, uv will use this username for publishing.

### `UV_PYPY_INSTALL_MIRROR`
<small class="added-in">added in `0.2.35`</small>

Managed PyPy installations are downloaded from [python.org](https://downloads.python.org/).

This variable can be set to a mirror URL to use a
different source for PyPy installations. The provided URL will replace
`https://downloads.python.org/pypy` in, e.g.,
`https://downloads.python.org/pypy/pypy3.8-v7.3.7-osx64.tar.bz2`.
Distributions can be read from a local directory by using the `file://` URL scheme.

### `UV_PYTHON`
<small class="added-in">added in `0.1.40`</small>

Equivalent to the `--python` command-line argument. If set to a path, uv will use
this Python interpreter for all operations.

### `UV_PYTHON_BIN_DIR`
<small class="added-in">added in `0.4.29`</small>

Specifies the directory to place links to installed, managed Python executables.

### `UV_PYTHON_CACHE_DIR`
<small class="added-in">added in `0.7.0`</small>

Specifies the directory for caching the archives of managed Python installations before
installation.

### `UV_PYTHON_CPYTHON_BUILD`
<small class="added-in">added in `0.8.14`</small>

Pin managed CPython versions to a specific build version.

For CPython, this should be the build date (e.g., "20250814").

### `UV_PYTHON_DOWNLOADS`
<small class="added-in">added in `0.3.2`</small>

Equivalent to the
[`python-downloads`](../reference/settings.md#python-downloads) setting and, when disabled, the
`--no-python-downloads` option. Whether uv should allow Python downloads.

### `UV_PYTHON_DOWNLOADS_JSON_URL`
<small class="added-in">added in `0.6.13`</small>

Managed Python installations information is hardcoded in the `uv` binary.

This variable can be set to a local path or URL pointing to
a JSON list of Python installations to override the hardcoded list.

This allows customizing the URLs for downloads or using slightly older or newer versions
of Python than the ones hardcoded into this build of `uv`.

### `UV_PYTHON_GRAALPY_BUILD`
<small class="added-in">added in `0.8.14`</small>

Pin managed GraalPy versions to a specific build version.

For GraalPy, this should be the GraalPy version (e.g., "24.2.2").

### `UV_PYTHON_INSTALL_BIN`
<small class="added-in">added in `0.8.0`</small>

Whether to install the Python executable into the `UV_PYTHON_BIN_DIR` directory.

### `UV_PYTHON_INSTALL_DIR`
<small class="added-in">added in `0.2.22`</small>

Specifies the directory for storing managed Python installations.

### `UV_PYTHON_INSTALL_MIRROR`
<small class="added-in">added in `0.2.35`</small>

Managed Python installations are downloaded from the Astral
[`python-build-standalone`](https://github.com/astral-sh/python-build-standalone) project.

This variable can be set to a mirror URL to use a different source for Python installations.
The provided URL will replace `https://github.com/astral-sh/python-build-standalone/releases/download` in, e.g.,
`https://github.com/astral-sh/python-build-standalone/releases/download/20240713/cpython-3.12.4%2B20240713-aarch64-apple-darwin-install_only.tar.gz`.
Distributions can be read from a local directory by using the `file://` URL scheme.

### `UV_PYTHON_INSTALL_REGISTRY`
<small class="added-in">added in `0.8.0`</small>

Whether to install the Python executable into the Windows registry.

### `UV_PYTHON_PREFERENCE`
<small class="added-in">added in `0.3.2`</small>

Whether uv should prefer system or managed Python versions.

### `UV_PYTHON_PYODIDE_BUILD`
<small class="added-in">added in `0.8.14`</small>

Pin managed Pyodide versions to a specific build version.

For Pyodide, this should be the Pyodide version (e.g., "0.28.1").

### `UV_PYTHON_PYPY_BUILD`
<small class="added-in">added in `0.8.14`</small>

Pin managed PyPy versions to a specific build version.

For PyPy, this should be the PyPy version (e.g., "7.3.20").

### `UV_REQUEST_TIMEOUT`
<small class="added-in">added in `0.1.6`</small>

Timeout (in seconds) for HTTP requests. Equivalent to `UV_HTTP_TIMEOUT`.

### `UV_REQUIRE_HASHES`
<small class="added-in">added in `0.1.34`</small>

Equivalent to the `--require-hashes` command-line argument. If set to `true`,
uv will require that all dependencies have a hash specified in the requirements file.

### `UV_RESOLUTION`
<small class="added-in">added in `0.1.27`</small>

Equivalent to the `--resolution` command-line argument. For example, if set to
`lowest-direct`, uv will install the lowest compatible versions of all direct dependencies.

### `UV_S3_ENDPOINT_URL`
<small class="added-in">added in `0.8.21`</small>

The URL to treat as an S3-compatible storage endpoint. Requests to this endpoint
will be signed using AWS Signature Version 4 based on the `AWS_ACCESS_KEY_ID`,
`AWS_SECRET_ACCESS_KEY`, `AWS_PROFILE`, and `AWS_CONFIG_FILE` environment variables.

### `UV_SKIP_WHEEL_FILENAME_CHECK`
<small class="added-in">added in `0.8.23`</small>

Avoid verifying that wheel filenames match their contents when installing wheels. This
is not recommended, as wheels with inconsistent filenames should be considered invalid and
corrected by the relevant package maintainers; however, this option can be used to work
around invalid artifacts in rare cases.

### `UV_STACK_SIZE`
<small class="added-in">added in `0.0.5`</small>

Use to set the stack size used by uv.

The value is in bytes, and if both `UV_STACK_SIZE` are `RUST_MIN_STACK` unset, uv uses a 4MB
(4194304) stack. `UV_STACK_SIZE` takes precedence over `RUST_MIN_STACK`.

Unlike the normal `RUST_MIN_STACK` semantics, this can affect main thread
stack size, because we actually spawn our own main2 thread to work around
the fact that Windows' real main thread is only 1MB. That thread has size
`max(UV_STACK_SIZE, 1MB)`.

### `UV_SYSTEM_PYTHON`
<small class="added-in">added in `0.1.18`</small>

Equivalent to the `--system` command-line argument. If set to `true`, uv will
use the first Python interpreter found in the system `PATH`.

WARNING: `UV_SYSTEM_PYTHON=true` is intended for use in continuous integration (CI)
or containerized environments and should be used with caution, as modifying the system
Python can lead to unexpected behavior.

### `UV_TEST_NO_HTTP_RETRY_DELAY`
<small class="added-in">added in `0.7.21`</small>

Used to disable delay for HTTP retries in tests.

### `UV_TOOL_BIN_DIR`
<small class="added-in">added in `0.3.0`</small>

Specifies the "bin" directory for installing tool executables.

### `UV_TOOL_DIR`
<small class="added-in">added in `0.2.16`</small>

Specifies the directory where uv stores managed tools.

### `UV_TORCH_BACKEND`
<small class="added-in">added in `0.6.9`</small>

Equivalent to the `--torch-backend` command-line argument (e.g., `cpu`, `cu126`, or `auto`).

### `UV_UNMANAGED_INSTALL`
<small class="added-in">added in `0.5.0`</small>

Used ephemeral environments like CI to install uv to a specific path while preventing
the installer from modifying shell profiles or environment variables.

### `UV_UPLOAD_HTTP_TIMEOUT`
<small class="added-in">added in `0.9.1`</small>

Timeout (in seconds) for only upload HTTP requests. (default: 900 s)

### `UV_VENV_CLEAR`
<small class="added-in">added in `0.8.0`</small>

Equivalent to the `--clear` command-line argument. If set, uv will remove any
existing files or directories at the target path.

### `UV_VENV_SEED`
<small class="added-in">added in `0.5.21`</small>

Install seed packages (one or more of: `pip`, `setuptools`, and `wheel`) into the virtual environment
created by `uv venv`.

Note that `setuptools` and `wheel` are not included in Python 3.12+ environments.

### `UV_WORKING_DIRECTORY`
<small class="added-in">added in `0.9.1`</small>

Equivalent to the `--directory` command-line argument.



## Externally defined variables

uv also reads the following externally defined environment variables:

### `ALL_PROXY`
<small class="added-in">added in `0.1.38`</small>

General proxy for all network requests.

### `ANDROID_API_LEVEL`
<small class="added-in">added in `0.8.16`</small>

Used with `--python-platform aarch64-linux-android` and related variants to set the
Android API level. (i.e., the minimum supported Android API level).

Defaults to `24`.

### `APPDATA`
<small class="added-in">added in `0.1.42`</small>

Path to user-level configuration directory on Windows systems.

### `AWS_ACCESS_KEY_ID`
<small class="added-in">added in `0.8.21`</small>

The AWS access key ID to use when signing S3 requests.

### `AWS_CONFIG_FILE`
<small class="added-in">added in `0.8.21`</small>

The AWS config file to use when signing S3 requests.

### `AWS_DEFAULT_REGION`
<small class="added-in">added in `0.8.21`</small>

The default AWS region to use when signing S3 requests, if `AWS_REGION` is not set.

### `AWS_PROFILE`
<small class="added-in">added in `0.8.21`</small>

The AWS profile to use when signing S3 requests.

### `AWS_REGION`
<small class="added-in">added in `0.8.21`</small>

The AWS region to use when signing S3 requests.

### `AWS_SECRET_ACCESS_KEY`
<small class="added-in">added in `0.8.21`</small>

The AWS secret access key to use when signing S3 requests.

### `AWS_SESSION_TOKEN`
<small class="added-in">added in `0.8.21`</small>

The AWS session token to use when signing S3 requests.

### `AWS_SHARED_CREDENTIALS_FILE`
<small class="added-in">added in `0.8.21`</small>

The AWS shared credentials file to use when signing S3 requests.

### `BASH_VERSION`
<small class="added-in">added in `0.1.28`</small>

Used to detect Bash shell usage.

### `CLICOLOR_FORCE`
<small class="added-in">added in `0.1.32`</small>

Use to control color via `anstyle`.

### `COLUMNS`
<small class="added-in">added in `0.6.2`</small>

Overrides terminal width used for wrapping. This variable is not read by uv directly.

This is a quasi-standard variable, described, e.g., in `ncurses(3x)`.

### `CONDA_DEFAULT_ENV`
<small class="added-in">added in `0.5.0`</small>

Used to determine the name of the active Conda environment.

### `CONDA_PREFIX`
<small class="added-in">added in `0.0.5`</small>

Used to detect the path of an active Conda environment.

### `FISH_VERSION`
<small class="added-in">added in `0.1.28`</small>

Used to detect Fish shell usage.

### `FORCE_COLOR`
<small class="added-in">added in `0.2.7`</small>

Forces colored output regardless of terminal support.

See [force-color.org](https://force-color.org).

### `GITHUB_ACTIONS`
<small class="added-in">added in `0.4.16`</small>

Indicates that the current process is running in GitHub Actions.

`uv publish` may attempt trusted publishing flows when set
to `true`.

### `GITLAB_CI`
<small class="added-in">added in `0.8.18`</small>

Indicates that the current process is running in GitLab CI.

`uv publish` may attempt trusted publishing flows when set
to `true`.

### `HF_TOKEN`
<small class="added-in">added in `0.8.1`</small>

Authentication token for Hugging Face requests. When set, uv will use this token
when making requests to `https://huggingface.co/` and any subdomains.

### `HOME`
<small class="added-in">added in `0.0.5`</small>

The standard `HOME` env var.

### `HTTPS_PROXY`
<small class="added-in">added in `0.1.38`</small>

Proxy for HTTPS requests.

### `HTTP_PROXY`
<small class="added-in">added in `0.1.38`</small>

Proxy for HTTP requests.

### `HTTP_TIMEOUT`
<small class="added-in">added in `0.1.7`</small>

Timeout (in seconds) for HTTP requests. Equivalent to `UV_HTTP_TIMEOUT`.

### `IPHONEOS_DEPLOYMENT_TARGET`
<small class="added-in">added in `0.8.16`</small>

Used with `--python-platform arm64-apple-ios` and related variants to set the
deployment target (i.e., the minimum supported iOS version).

Defaults to `13.0`.

### `JPY_SESSION_NAME`
<small class="added-in">added in `0.2.6`</small>

Used to detect when running inside a Jupyter notebook.

### `KSH_VERSION`
<small class="added-in">added in `0.2.33`</small>

Used to detect Ksh shell usage.

### `LOCALAPPDATA`
<small class="added-in">added in `0.3.3`</small>

Used to look for Microsoft Store Pythons installations.

### `MACOSX_DEPLOYMENT_TARGET`
<small class="added-in">added in `0.1.42`</small>

Used with `--python-platform macos` and related variants to set the
deployment target (i.e., the minimum supported macOS version).

Defaults to `13.0`, the least-recent non-EOL macOS version at time of writing.

### `NETRC`
<small class="added-in">added in `0.1.16`</small>

Use to set the .netrc file location.

### `NO_COLOR`
<small class="added-in">added in `0.2.7`</small>

Disables colored output (takes precedence over `FORCE_COLOR`).

See [no-color.org](https://no-color.org).

### `NO_PROXY`
<small class="added-in">added in `0.1.38`</small>

Comma-separated list of hostnames (e.g., `example.com`) and/or patterns (e.g., `192.168.1.0/24`) that should bypass the proxy.

### `NU_VERSION`
<small class="added-in">added in `0.1.16`</small>

Used to detect `NuShell` usage.

### `PAGER`
<small class="added-in">added in `0.4.18`</small>

The standard `PAGER` posix env var. Used by `uv` to configure the appropriate pager.

### `PATH`
<small class="added-in">added in `0.0.5`</small>

The standard `PATH` env var.

### `PROMPT`
<small class="added-in">added in `0.1.16`</small>

Used to detect the use of the Windows Command Prompt (as opposed to PowerShell).

### `PWD`
<small class="added-in">added in `0.0.5`</small>

The standard `PWD` posix env var.

### `PYC_INVALIDATION_MODE`
<small class="added-in">added in `0.1.7`</small>

The validation modes to use when run with `--compile`.

See [`PycInvalidationMode`](https://docs.python.org/3/library/py_compile.html#py_compile.PycInvalidationMode).

### `PYTHONPATH`
<small class="added-in">added in `0.1.22`</small>

Adds directories to Python module search path (e.g., `PYTHONPATH=/path/to/modules`).

### `PYX_API_KEY`
<small class="added-in">added in `0.8.15`</small>

The pyx API key (e.g., `sk-pyx-...`).

### `PYX_API_URL`
<small class="added-in">added in `0.8.15`</small>

The URL of the pyx Simple API server.

### `PYX_AUTH_TOKEN`
<small class="added-in">added in `0.8.15`</small>

The pyx authentication token (e.g., `eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9...`), as output by `uv auth token`.

### `PYX_CDN_DOMAIN`
<small class="added-in">added in `0.8.15`</small>

The domain of the pyx CDN.

### `PYX_CREDENTIALS_DIR`
<small class="added-in">added in `0.8.15`</small>

Specifies the directory where uv stores pyx credentials.

### `RUST_BACKTRACE`
<small class="added-in">added in `0.7.22`</small>

If set, it can be used to display more stack trace details when a panic occurs.
This is used by uv particularly on windows to show more details during a platform exception.

For example:

* `RUST_BACKTRACE=1` will print a short backtrace.
* `RUST_BACKTRACE=full` will print a full backtrace.

See the [Rust backtrace documentation](https://doc.rust-lang.org/std/backtrace/index.html)
for more.

### `RUST_LOG`
<small class="added-in">added in `0.0.5`</small>

If set, uv will use this value as the log level for its `--verbose` output. Accepts
any filter compatible with the `tracing_subscriber` crate.

For example:

* `RUST_LOG=uv=debug` is the equivalent of adding `--verbose` to the command line
* `RUST_LOG=trace` will enable trace-level logging.

See the [tracing documentation](https://docs.rs/tracing-subscriber/latest/tracing_subscriber/filter/struct.EnvFilter.html#example-syntax)
for more.

### `RUST_MIN_STACK`
<small class="added-in">added in `0.5.19`</small>

Use to set the stack size used by uv.

The value is in bytes, and if both `UV_STACK_SIZE` are `RUST_MIN_STACK` unset, uv uses a 4MB
(4194304) stack. `UV_STACK_SIZE` takes precedence over `RUST_MIN_STACK`.

Prefer setting `UV_STACK_SIZE`, since `RUST_MIN_STACK` also affects subprocesses, such as
build backends that use Rust code.

Unlike the normal `RUST_MIN_STACK` semantics, this can affect main thread
stack size, because we actually spawn our own main2 thread to work around
the fact that Windows' real main thread is only 1MB. That thread has size
`max(RUST_MIN_STACK, 1MB)`.

### `SHELL`
<small class="added-in">added in `0.1.16`</small>

The standard `SHELL` posix env var.

### `SSL_CERT_DIR`
<small class="added-in">added in `0.9.10`</small>

Custom path for certificate bundles for SSL connections.
Multiple entries are supported separated using a platform-specific
delimiter (`:` on Unix, `;` on Windows).

Takes precedence over `UV_NATIVE_TLS` when set.

### `SSL_CERT_FILE`
<small class="added-in">added in `0.1.14`</small>

Custom certificate bundle file path for SSL connections.

Takes precedence over `UV_NATIVE_TLS` when set.

### `SSL_CLIENT_CERT`
<small class="added-in">added in `0.2.11`</small>

If set, uv will use this file for mTLS authentication.
This should be a single file containing both the certificate and the private key in PEM format.

### `SYSTEMDRIVE`
<small class="added-in">added in `0.4.26`</small>

Path to system-level configuration directory on Windows systems.

### `TRACING_DURATIONS_FILE`
<small class="added-in">added in `0.0.5`</small>

Use to create the tracing durations file via the `tracing-durations-export` feature.

### `USERPROFILE`
<small class="added-in">added in `0.0.5`</small>

Path to root directory of user's profile on Windows systems.

### `UV`
<small class="added-in">added in `0.6.0`</small>

The path to the binary that was used to invoke uv.

This is propagated to all subprocesses spawned by uv.

If the executable was invoked through a symbolic link, some platforms will return the path
of the symbolic link and other platforms will return the path of the symbolic link’s target.

See <https://doc.rust-lang.org/std/env/fn.current_exe.html#security> for security
considerations.

### `VIRTUAL_ENV`
<small class="added-in">added in `0.0.5`</small>

Used to detect an activated virtual environment.

### `VIRTUAL_ENV_DISABLE_PROMPT`
<small class="added-in">added in `0.0.5`</small>

If set to `1` before a virtual environment is activated, then the
virtual environment name will not be prepended to the terminal prompt.

### `XDG_BIN_HOME`
<small class="added-in">added in `0.2.16`</small>

Path to directory where executables are installed.

### `XDG_CACHE_HOME`
<small class="added-in">added in `0.1.17`</small>

Path to cache directory on Unix systems.

### `XDG_CONFIG_DIRS`
<small class="added-in">added in `0.4.26`</small>

Path to system-level configuration directory on Unix systems.

### `XDG_CONFIG_HOME`
<small class="added-in">added in `0.1.34`</small>

Path to user-level configuration directory on Unix systems.

### `XDG_DATA_HOME`
<small class="added-in">added in `0.2.16`</small>

Path to directory for storing managed Python installations and tools.

### `ZDOTDIR`
<small class="added-in">added in `0.2.25`</small>

Used to determine which `.zshenv` to use when Zsh is being used.

### `ZSH_VERSION`
<small class="added-in">added in `0.1.28`</small>

Used to detect Zsh shell usage.

### `_CONDA_ROOT`
<small class="added-in">added in `0.8.18`</small>

Used to determine the root install path of Conda.

