/*
 * Copyright (C) 1998-2019 Gerwin Klein <lsf@jflex.de>
 * Copyright (C) 2008-2020 Steve Rowe <sarowe@gmail.com>
 * Copyright (C) 2018-2020 Google, LLC.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
// TODO(regisd) Move in same package
package jflex.core.unicode.data;

// TODO(regisd) Restrict to package visibility
public class Unicode_7_0 {

  // Only holds constants.
  private Unicode_7_0() {}

  /** Highest Unicode code point. */
  public static final int maximumCodePoint = 0x10ffff;

  public static final String[] propertyValues = {
    "age=unassigned",
    "age=v11",
    "age=v20",
    "age=v21",
    "age=v30",
    "age=v31",
    "age=v32",
    "age=v40",
    "age=v41",
    "age=v50",
    "age=v51",
    "age=v52",
    "age=v60",
    "age=v61",
    "age=v62",
    "age=v63",
    "age=v70",
    "alnum",
    "alphabetic",
    "arabic",
    "armenian",
    "asciihexdigit",
    "assigned",
    "avestan",
    "balinese",
    "bamum",
    "bassavah",
    "batak",
    "bengali",
    "bidicontrol",
    "blank",
    "block=aegeannumbers",
    "block=alchemicalsymbols",
    "block=alphabeticpresentationforms",
    "block=ancientgreekmusicalnotation",
    "block=ancientgreeknumbers",
    "block=ancientsymbols",
    "block=arabic",
    "block=arabicextendeda",
    "block=arabicmathematicalalphabeticsymbols",
    "block=arabicpresentationformsa",
    "block=arabicpresentationformsb",
    "block=arabicsupplement",
    "block=armenian",
    "block=arrows",
    "block=avestan",
    "block=balinese",
    "block=bamum",
    "block=bamumsupplement",
    "block=basiclatin",
    "block=bassavah",
    "block=batak",
    "block=bengali",
    "block=blockelements",
    "block=bopomofo",
    "block=bopomofoextended",
    "block=boxdrawing",
    "block=brahmi",
    "block=braillepatterns",
    "block=buginese",
    "block=buhid",
    "block=byzantinemusicalsymbols",
    "block=carian",
    "block=caucasianalbanian",
    "block=chakma",
    "block=cham",
    "block=cherokee",
    "block=cjkcompatibility",
    "block=cjkcompatibilityforms",
    "block=cjkcompatibilityideographs",
    "block=cjkcompatibilityideographssupplement",
    "block=cjkradicalssupplement",
    "block=cjkstrokes",
    "block=cjksymbolsandpunctuation",
    "block=cjkunifiedideographs",
    "block=cjkunifiedideographsextensiona",
    "block=cjkunifiedideographsextensionb",
    "block=cjkunifiedideographsextensionc",
    "block=cjkunifiedideographsextensiond",
    "block=combiningdiacriticalmarks",
    "block=combiningdiacriticalmarksextended",
    "block=combiningdiacriticalmarksforsymbols",
    "block=combiningdiacriticalmarkssupplement",
    "block=combininghalfmarks",
    "block=commonindicnumberforms",
    "block=controlpictures",
    "block=coptic",
    "block=copticepactnumbers",
    "block=countingrodnumerals",
    "block=cuneiform",
    "block=cuneiformnumbersandpunctuation",
    "block=currencysymbols",
    "block=cypriotsyllabary",
    "block=cyrillic",
    "block=cyrillicextendeda",
    "block=cyrillicextendedb",
    "block=cyrillicsupplement",
    "block=deseret",
    "block=devanagari",
    "block=devanagariextended",
    "block=dingbats",
    "block=dominotiles",
    "block=duployan",
    "block=egyptianhieroglyphs",
    "block=elbasan",
    "block=emoticons",
    "block=enclosedalphanumerics",
    "block=enclosedalphanumericsupplement",
    "block=enclosedcjklettersandmonths",
    "block=enclosedideographicsupplement",
    "block=ethiopic",
    "block=ethiopicextended",
    "block=ethiopicextendeda",
    "block=ethiopicsupplement",
    "block=generalpunctuation",
    "block=geometricshapes",
    "block=geometricshapesextended",
    "block=georgian",
    "block=georgiansupplement",
    "block=glagolitic",
    "block=gothic",
    "block=grantha",
    "block=greekandcoptic",
    "block=greekextended",
    "block=gujarati",
    "block=gurmukhi",
    "block=halfwidthandfullwidthforms",
    "block=hangulcompatibilityjamo",
    "block=hanguljamo",
    "block=hanguljamoextendeda",
    "block=hanguljamoextendedb",
    "block=hangulsyllables",
    "block=hanunoo",
    "block=hebrew",
    "block=hiragana",
    "block=ideographicdescriptioncharacters",
    "block=imperialaramaic",
    "block=inscriptionalpahlavi",
    "block=inscriptionalparthian",
    "block=ipaextensions",
    "block=javanese",
    "block=kaithi",
    "block=kanasupplement",
    "block=kanbun",
    "block=kangxiradicals",
    "block=kannada",
    "block=katakana",
    "block=katakanaphoneticextensions",
    "block=kayahli",
    "block=kharoshthi",
    "block=khmer",
    "block=khmersymbols",
    "block=khojki",
    "block=khudawadi",
    "block=lao",
    "block=latin1supplement",
    "block=latinextendeda",
    "block=latinextendedadditional",
    "block=latinextendedb",
    "block=latinextendedc",
    "block=latinextendedd",
    "block=latinextendede",
    "block=lepcha",
    "block=letterlikesymbols",
    "block=limbu",
    "block=lineara",
    "block=linearbideograms",
    "block=linearbsyllabary",
    "block=lisu",
    "block=lycian",
    "block=lydian",
    "block=mahajani",
    "block=mahjongtiles",
    "block=malayalam",
    "block=mandaic",
    "block=manichaean",
    "block=mathematicalalphanumericsymbols",
    "block=mathematicaloperators",
    "block=meeteimayek",
    "block=meeteimayekextensions",
    "block=mendekikakui",
    "block=meroiticcursive",
    "block=meroitichieroglyphs",
    "block=miao",
    "block=miscellaneousmathematicalsymbolsa",
    "block=miscellaneousmathematicalsymbolsb",
    "block=miscellaneoussymbols",
    "block=miscellaneoussymbolsandarrows",
    "block=miscellaneoussymbolsandpictographs",
    "block=miscellaneoustechnical",
    "block=modi",
    "block=modifiertoneletters",
    "block=mongolian",
    "block=mro",
    "block=musicalsymbols",
    "block=myanmar",
    "block=myanmarextendeda",
    "block=myanmarextendedb",
    "block=nabataean",
    "block=newtailue",
    "block=nko",
    "block=noblock",
    "block=numberforms",
    "block=ogham",
    "block=olchiki",
    "block=olditalic",
    "block=oldnortharabian",
    "block=oldpermic",
    "block=oldpersian",
    "block=oldsoutharabian",
    "block=oldturkic",
    "block=opticalcharacterrecognition",
    "block=oriya",
    "block=ornamentaldingbats",
    "block=osmanya",
    "block=pahawhhmong",
    "block=palmyrene",
    "block=paucinhau",
    "block=phagspa",
    "block=phaistosdisc",
    "block=phoenician",
    "block=phoneticextensions",
    "block=phoneticextensionssupplement",
    "block=playingcards",
    "block=privateusearea",
    "block=psalterpahlavi",
    "block=rejang",
    "block=ruminumeralsymbols",
    "block=runic",
    "block=samaritan",
    "block=saurashtra",
    "block=sharada",
    "block=shavian",
    "block=shorthandformatcontrols",
    "block=siddham",
    "block=sinhala",
    "block=sinhalaarchaicnumbers",
    "block=smallformvariants",
    "block=sorasompeng",
    "block=spacingmodifierletters",
    "block=specials",
    "block=sundanese",
    "block=sundanesesupplement",
    "block=superscriptsandsubscripts",
    "block=supplementalarrowsa",
    "block=supplementalarrowsb",
    "block=supplementalarrowsc",
    "block=supplementalmathematicaloperators",
    "block=supplementalpunctuation",
    "block=supplementaryprivateuseareaa",
    "block=supplementaryprivateuseareab",
    "block=sylotinagri",
    "block=syriac",
    "block=tagalog",
    "block=tagbanwa",
    "block=tags",
    "block=taile",
    "block=taitham",
    "block=taiviet",
    "block=taixuanjingsymbols",
    "block=takri",
    "block=tamil",
    "block=telugu",
    "block=thaana",
    "block=thai",
    "block=tibetan",
    "block=tifinagh",
    "block=tirhuta",
    "block=transportandmapsymbols",
    "block=ugaritic",
    "block=unifiedcanadianaboriginalsyllabics",
    "block=unifiedcanadianaboriginalsyllabicsextended",
    "block=vai",
    "block=variationselectors",
    "block=variationselectorssupplement",
    "block=vedicextensions",
    "block=verticalforms",
    "block=warangciti",
    "block=yijinghexagramsymbols",
    "block=yiradicals",
    "block=yisyllables",
    "bopomofo",
    "brahmi",
    "braille",
    "buginese",
    "buhid",
    "canadianaboriginal",
    "carian",
    "cased",
    "caseignorable",
    "caucasianalbanian",
    "cc",
    "cf",
    "chakma",
    "cham",
    "changeswhencasefolded",
    "changeswhencasemapped",
    "changeswhenlowercased",
    "changeswhentitlecased",
    "changeswhenuppercased",
    "cherokee",
    "cn",
    "co",
    "common",
    "coptic",
    "cuneiform",
    "cypriot",
    "cyrillic",
    "dash",
    "defaultignorablecodepoint",
    "deprecated",
    "deseret",
    "devanagari",
    "diacritic",
    "duployan",
    "egyptianhieroglyphs",
    "elbasan",
    "ethiopic",
    "extender",
    "georgian",
    "glagolitic",
    "gothic",
    "grantha",
    "graph",
    "graphemebase",
    "graphemeclusterbreak=control",
    "graphemeclusterbreak=cr",
    "graphemeclusterbreak=extend",
    "graphemeclusterbreak=l",
    "graphemeclusterbreak=lf",
    "graphemeclusterbreak=lv",
    "graphemeclusterbreak=lvt",
    "graphemeclusterbreak=other",
    "graphemeclusterbreak=regionalindicator",
    "graphemeclusterbreak=spacingmark",
    "graphemeclusterbreak=t",
    "graphemeclusterbreak=v",
    "graphemeextend",
    "graphemelink",
    "greek",
    "gujarati",
    "gurmukhi",
    "han",
    "hangul",
    "hanunoo",
    "hebrew",
    "hexdigit",
    "hiragana",
    "hyphen",
    "idcontinue",
    "ideographic",
    "idsbinaryoperator",
    "idstart",
    "idstrinaryoperator",
    "imperialaramaic",
    "inherited",
    "inscriptionalpahlavi",
    "inscriptionalparthian",
    "javanese",
    "joincontrol",
    "kaithi",
    "kannada",
    "katakana",
    "kayahli",
    "kharoshthi",
    "khmer",
    "khojki",
    "khudawadi",
    "lao",
    "latin",
    "lepcha",
    "limbu",
    "lineara",
    "linearb",
    "linebreak=alphabetic",
    "linebreak=ambiguous",
    "linebreak=breakafter",
    "linebreak=breakbefore",
    "linebreak=breakboth",
    "linebreak=breaksymbols",
    "linebreak=carriagereturn",
    "linebreak=closeparenthesis",
    "linebreak=closepunctuation",
    "linebreak=combiningmark",
    "linebreak=complexcontext",
    "linebreak=conditionaljapanesestarter",
    "linebreak=contingentbreak",
    "linebreak=exclamation",
    "linebreak=glue",
    "linebreak=h2",
    "linebreak=h3",
    "linebreak=hebrewletter",
    "linebreak=hyphen",
    "linebreak=ideographic",
    "linebreak=infixnumeric",
    "linebreak=inseparable",
    "linebreak=jl",
    "linebreak=jt",
    "linebreak=jv",
    "linebreak=linefeed",
    "linebreak=mandatorybreak",
    "linebreak=nextline",
    "linebreak=nonstarter",
    "linebreak=numeric",
    "linebreak=openpunctuation",
    "linebreak=postfixnumeric",
    "linebreak=prefixnumeric",
    "linebreak=quotation",
    "linebreak=regionalindicator",
    "linebreak=space",
    "linebreak=unknown",
    "linebreak=wordjoiner",
    "linebreak=zwspace",
    "lisu",
    "ll",
    "lm",
    "lo",
    "logicalorderexception",
    "lowercase",
    "lt",
    "lu",
    "lycian",
    "lydian",
    "mahajani",
    "malayalam",
    "mandaic",
    "manichaean",
    "math",
    "mc",
    "me",
    "meeteimayek",
    "mendekikakui",
    "meroiticcursive",
    "meroitichieroglyphs",
    "miao",
    "mn",
    "modi",
    "mongolian",
    "mro",
    "myanmar",
    "nabataean",
    "nd",
    "newtailue",
    "nko",
    "nl",
    "no",
    "noncharactercodepoint",
    "ogham",
    "olchiki",
    "olditalic",
    "oldnortharabian",
    "oldpermic",
    "oldpersian",
    "oldsoutharabian",
    "oldturkic",
    "oriya",
    "osmanya",
    "otheralphabetic",
    "otherdefaultignorablecodepoint",
    "othergraphemeextend",
    "otheridcontinue",
    "otheridstart",
    "otherlowercase",
    "othermath",
    "otheruppercase",
    "pahawhhmong",
    "palmyrene",
    "patternsyntax",
    "patternwhitespace",
    "paucinhau",
    "pc",
    "pd",
    "pe",
    "pf",
    "phagspa",
    "phoenician",
    "pi",
    "po",
    "print",
    "ps",
    "psalterpahlavi",
    "quotationmark",
    "radical",
    "rejang",
    "runic",
    "samaritan",
    "saurashtra",
    "sc",
    "scriptextensions=arabic",
    "scriptextensions=armenian",
    "scriptextensions=avestan",
    "scriptextensions=balinese",
    "scriptextensions=bamum",
    "scriptextensions=bassavah",
    "scriptextensions=batak",
    "scriptextensions=bengali",
    "scriptextensions=bopomofo",
    "scriptextensions=brahmi",
    "scriptextensions=braille",
    "scriptextensions=buginese",
    "scriptextensions=buhid",
    "scriptextensions=canadianaboriginal",
    "scriptextensions=carian",
    "scriptextensions=caucasianalbanian",
    "scriptextensions=chakma",
    "scriptextensions=cham",
    "scriptextensions=cherokee",
    "scriptextensions=common",
    "scriptextensions=coptic",
    "scriptextensions=cuneiform",
    "scriptextensions=cypriot",
    "scriptextensions=cyrillic",
    "scriptextensions=deseret",
    "scriptextensions=devanagari",
    "scriptextensions=duployan",
    "scriptextensions=egyptianhieroglyphs",
    "scriptextensions=elbasan",
    "scriptextensions=ethiopic",
    "scriptextensions=georgian",
    "scriptextensions=glagolitic",
    "scriptextensions=gothic",
    "scriptextensions=grantha",
    "scriptextensions=greek",
    "scriptextensions=gujarati",
    "scriptextensions=gurmukhi",
    "scriptextensions=han",
    "scriptextensions=hangul",
    "scriptextensions=hanunoo",
    "scriptextensions=hebrew",
    "scriptextensions=hiragana",
    "scriptextensions=imperialaramaic",
    "scriptextensions=inherited",
    "scriptextensions=inscriptionalpahlavi",
    "scriptextensions=inscriptionalparthian",
    "scriptextensions=javanese",
    "scriptextensions=kaithi",
    "scriptextensions=kannada",
    "scriptextensions=katakana",
    "scriptextensions=kayahli",
    "scriptextensions=kharoshthi",
    "scriptextensions=khmer",
    "scriptextensions=khojki",
    "scriptextensions=khudawadi",
    "scriptextensions=lao",
    "scriptextensions=latin",
    "scriptextensions=lepcha",
    "scriptextensions=limbu",
    "scriptextensions=lineara",
    "scriptextensions=linearb",
    "scriptextensions=lisu",
    "scriptextensions=lycian",
    "scriptextensions=lydian",
    "scriptextensions=mahajani",
    "scriptextensions=malayalam",
    "scriptextensions=mandaic",
    "scriptextensions=manichaean",
    "scriptextensions=meeteimayek",
    "scriptextensions=mendekikakui",
    "scriptextensions=meroiticcursive",
    "scriptextensions=meroitichieroglyphs",
    "scriptextensions=miao",
    "scriptextensions=modi",
    "scriptextensions=mongolian",
    "scriptextensions=mro",
    "scriptextensions=myanmar",
    "scriptextensions=nabataean",
    "scriptextensions=newtailue",
    "scriptextensions=nko",
    "scriptextensions=ogham",
    "scriptextensions=olchiki",
    "scriptextensions=olditalic",
    "scriptextensions=oldnortharabian",
    "scriptextensions=oldpermic",
    "scriptextensions=oldpersian",
    "scriptextensions=oldsoutharabian",
    "scriptextensions=oldturkic",
    "scriptextensions=oriya",
    "scriptextensions=osmanya",
    "scriptextensions=pahawhhmong",
    "scriptextensions=palmyrene",
    "scriptextensions=paucinhau",
    "scriptextensions=phagspa",
    "scriptextensions=phoenician",
    "scriptextensions=psalterpahlavi",
    "scriptextensions=rejang",
    "scriptextensions=runic",
    "scriptextensions=samaritan",
    "scriptextensions=saurashtra",
    "scriptextensions=sharada",
    "scriptextensions=shavian",
    "scriptextensions=siddham",
    "scriptextensions=sinhala",
    "scriptextensions=sorasompeng",
    "scriptextensions=sundanese",
    "scriptextensions=sylotinagri",
    "scriptextensions=syriac",
    "scriptextensions=tagalog",
    "scriptextensions=tagbanwa",
    "scriptextensions=taile",
    "scriptextensions=taitham",
    "scriptextensions=taiviet",
    "scriptextensions=takri",
    "scriptextensions=tamil",
    "scriptextensions=telugu",
    "scriptextensions=thaana",
    "scriptextensions=thai",
    "scriptextensions=tibetan",
    "scriptextensions=tifinagh",
    "scriptextensions=tirhuta",
    "scriptextensions=ugaritic",
    "scriptextensions=unknown",
    "scriptextensions=vai",
    "scriptextensions=warangciti",
    "scriptextensions=yi",
    "sentencebreak=aterm",
    "sentencebreak=close",
    "sentencebreak=cr",
    "sentencebreak=extend",
    "sentencebreak=format",
    "sentencebreak=lf",
    "sentencebreak=lower",
    "sentencebreak=numeric",
    "sentencebreak=oletter",
    "sentencebreak=other",
    "sentencebreak=scontinue",
    "sentencebreak=sep",
    "sentencebreak=sp",
    "sentencebreak=sterm",
    "sentencebreak=upper",
    "sharada",
    "shavian",
    "siddham",
    "sinhala",
    "sk",
    "sm",
    "so",
    "softdotted",
    "sorasompeng",
    "sterm",
    "sundanese",
    "sylotinagri",
    "syriac",
    "tagalog",
    "tagbanwa",
    "taile",
    "taitham",
    "taiviet",
    "takri",
    "tamil",
    "telugu",
    "terminalpunctuation",
    "thaana",
    "thai",
    "tibetan",
    "tifinagh",
    "tirhuta",
    "ugaritic",
    "unifiedideograph",
    "unknown",
    "uppercase",
    "vai",
    "variationselector",
    "warangciti",
    "whitespace",
    "wordbreak=aletter",
    "wordbreak=cr",
    "wordbreak=doublequote",
    "wordbreak=extend",
    "wordbreak=extendnumlet",
    "wordbreak=format",
    "wordbreak=hebrewletter",
    "wordbreak=katakana",
    "wordbreak=lf",
    "wordbreak=midletter",
    "wordbreak=midnum",
    "wordbreak=midnumlet",
    "wordbreak=newline",
    "wordbreak=numeric",
    "wordbreak=other",
    "wordbreak=regionalindicator",
    "wordbreak=singlequote",
    "xdigit",
    "xidcontinue",
    "xidstart",
    "yi",
    "zl",
    "zp",
    "zs"
  };

  public static final String[] intervals = {
    // Unicode 7.0 property value: {age=unassigned}
    "\u0378\u0379"
        + "\u0380\u0383"
        + "\u038b\u038b"
        + "\u038d\u038d"
        + "\u03a2\u03a2"
        + "\u0530\u0530"
        + "\u0557\u0558"
        + "\u0560\u0560"
        + "\u0588\u0588"
        + "\u058b\u058c"
        + "\u0590\u0590"
        + "\u05c8\u05cf"
        + "\u05eb\u05ef"
        + "\u05f5\u05ff"
        + "\u061d\u061d"
        + "\u070e\u070e"
        + "\u074b\u074c"
        + "\u07b2\u07bf"
        + "\u07fb\u07ff"
        + "\u082e\u082f"
        + "\u083f\u083f"
        + "\u085c\u085d"
        + "\u085f\u089f"
        + "\u08b3\u08e3"
        + "\u0984\u0984"
        + "\u098d\u098e"
        + "\u0991\u0992"
        + "\u09a9\u09a9"
        + "\u09b1\u09b1"
        + "\u09b3\u09b5"
        + "\u09ba\u09bb"
        + "\u09c5\u09c6"
        + "\u09c9\u09ca"
        + "\u09cf\u09d6"
        + "\u09d8\u09db"
        + "\u09de\u09de"
        + "\u09e4\u09e5"
        + "\u09fc\u0a00"
        + "\u0a04\u0a04"
        + "\u0a0b\u0a0e"
        + "\u0a11\u0a12"
        + "\u0a29\u0a29"
        + "\u0a31\u0a31"
        + "\u0a34\u0a34"
        + "\u0a37\u0a37"
        + "\u0a3a\u0a3b"
        + "\u0a3d\u0a3d"
        + "\u0a43\u0a46"
        + "\u0a49\u0a4a"
        + "\u0a4e\u0a50"
        + "\u0a52\u0a58"
        + "\u0a5d\u0a5d"
        + "\u0a5f\u0a65"
        + "\u0a76\u0a80"
        + "\u0a84\u0a84"
        + "\u0a8e\u0a8e"
        + "\u0a92\u0a92"
        + "\u0aa9\u0aa9"
        + "\u0ab1\u0ab1"
        + "\u0ab4\u0ab4"
        + "\u0aba\u0abb"
        + "\u0ac6\u0ac6"
        + "\u0aca\u0aca"
        + "\u0ace\u0acf"
        + "\u0ad1\u0adf"
        + "\u0ae4\u0ae5"
        + "\u0af2\u0b00"
        + "\u0b04\u0b04"
        + "\u0b0d\u0b0e"
        + "\u0b11\u0b12"
        + "\u0b29\u0b29"
        + "\u0b31\u0b31"
        + "\u0b34\u0b34"
        + "\u0b3a\u0b3b"
        + "\u0b45\u0b46"
        + "\u0b49\u0b4a"
        + "\u0b4e\u0b55"
        + "\u0b58\u0b5b"
        + "\u0b5e\u0b5e"
        + "\u0b64\u0b65"
        + "\u0b78\u0b81"
        + "\u0b84\u0b84"
        + "\u0b8b\u0b8d"
        + "\u0b91\u0b91"
        + "\u0b96\u0b98"
        + "\u0b9b\u0b9b"
        + "\u0b9d\u0b9d"
        + "\u0ba0\u0ba2"
        + "\u0ba5\u0ba7"
        + "\u0bab\u0bad"
        + "\u0bba\u0bbd"
        + "\u0bc3\u0bc5"
        + "\u0bc9\u0bc9"
        + "\u0bce\u0bcf"
        + "\u0bd1\u0bd6"
        + "\u0bd8\u0be5"
        + "\u0bfb\u0bff"
        + "\u0c04\u0c04"
        + "\u0c0d\u0c0d"
        + "\u0c11\u0c11"
        + "\u0c29\u0c29"
        + "\u0c3a\u0c3c"
        + "\u0c45\u0c45"
        + "\u0c49\u0c49"
        + "\u0c4e\u0c54"
        + "\u0c57\u0c57"
        + "\u0c5a\u0c5f"
        + "\u0c64\u0c65"
        + "\u0c70\u0c77"
        + "\u0c80\u0c80"
        + "\u0c84\u0c84"
        + "\u0c8d\u0c8d"
        + "\u0c91\u0c91"
        + "\u0ca9\u0ca9"
        + "\u0cb4\u0cb4"
        + "\u0cba\u0cbb"
        + "\u0cc5\u0cc5"
        + "\u0cc9\u0cc9"
        + "\u0cce\u0cd4"
        + "\u0cd7\u0cdd"
        + "\u0cdf\u0cdf"
        + "\u0ce4\u0ce5"
        + "\u0cf0\u0cf0"
        + "\u0cf3\u0d00"
        + "\u0d04\u0d04"
        + "\u0d0d\u0d0d"
        + "\u0d11\u0d11"
        + "\u0d3b\u0d3c"
        + "\u0d45\u0d45"
        + "\u0d49\u0d49"
        + "\u0d4f\u0d56"
        + "\u0d58\u0d5f"
        + "\u0d64\u0d65"
        + "\u0d76\u0d78"
        + "\u0d80\u0d81"
        + "\u0d84\u0d84"
        + "\u0d97\u0d99"
        + "\u0db2\u0db2"
        + "\u0dbc\u0dbc"
        + "\u0dbe\u0dbf"
        + "\u0dc7\u0dc9"
        + "\u0dcb\u0dce"
        + "\u0dd5\u0dd5"
        + "\u0dd7\u0dd7"
        + "\u0de0\u0de5"
        + "\u0df0\u0df1"
        + "\u0df5\u0e00"
        + "\u0e3b\u0e3e"
        + "\u0e5c\u0e80"
        + "\u0e83\u0e83"
        + "\u0e85\u0e86"
        + "\u0e89\u0e89"
        + "\u0e8b\u0e8c"
        + "\u0e8e\u0e93"
        + "\u0e98\u0e98"
        + "\u0ea0\u0ea0"
        + "\u0ea4\u0ea4"
        + "\u0ea6\u0ea6"
        + "\u0ea8\u0ea9"
        + "\u0eac\u0eac"
        + "\u0eba\u0eba"
        + "\u0ebe\u0ebf"
        + "\u0ec5\u0ec5"
        + "\u0ec7\u0ec7"
        + "\u0ece\u0ecf"
        + "\u0eda\u0edb"
        + "\u0ee0\u0eff"
        + "\u0f48\u0f48"
        + "\u0f6d\u0f70"
        + "\u0f98\u0f98"
        + "\u0fbd\u0fbd"
        + "\u0fcd\u0fcd"
        + "\u0fdb\u0fff"
        + "\u10c6\u10c6"
        + "\u10c8\u10cc"
        + "\u10ce\u10cf"
        + "\u1249\u1249"
        + "\u124e\u124f"
        + "\u1257\u1257"
        + "\u1259\u1259"
        + "\u125e\u125f"
        + "\u1289\u1289"
        + "\u128e\u128f"
        + "\u12b1\u12b1"
        + "\u12b6\u12b7"
        + "\u12bf\u12bf"
        + "\u12c1\u12c1"
        + "\u12c6\u12c7"
        + "\u12d7\u12d7"
        + "\u1311\u1311"
        + "\u1316\u1317"
        + "\u135b\u135c"
        + "\u137d\u137f"
        + "\u139a\u139f"
        + "\u13f5\u13ff"
        + "\u169d\u169f"
        + "\u16f9\u16ff"
        + "\u170d\u170d"
        + "\u1715\u171f"
        + "\u1737\u173f"
        + "\u1754\u175f"
        + "\u176d\u176d"
        + "\u1771\u1771"
        + "\u1774\u177f"
        + "\u17de\u17df"
        + "\u17ea\u17ef"
        + "\u17fa\u17ff"
        + "\u180f\u180f"
        + "\u181a\u181f"
        + "\u1878\u187f"
        + "\u18ab\u18af"
        + "\u18f6\u18ff"
        + "\u191f\u191f"
        + "\u192c\u192f"
        + "\u193c\u193f"
        + "\u1941\u1943"
        + "\u196e\u196f"
        + "\u1975\u197f"
        + "\u19ac\u19af"
        + "\u19ca\u19cf"
        + "\u19db\u19dd"
        + "\u1a1c\u1a1d"
        + "\u1a5f\u1a5f"
        + "\u1a7d\u1a7e"
        + "\u1a8a\u1a8f"
        + "\u1a9a\u1a9f"
        + "\u1aae\u1aaf"
        + "\u1abf\u1aff"
        + "\u1b4c\u1b4f"
        + "\u1b7d\u1b7f"
        + "\u1bf4\u1bfb"
        + "\u1c38\u1c3a"
        + "\u1c4a\u1c4c"
        + "\u1c80\u1cbf"
        + "\u1cc8\u1ccf"
        + "\u1cf7\u1cf7"
        + "\u1cfa\u1cff"
        + "\u1df6\u1dfb"
        + "\u1f16\u1f17"
        + "\u1f1e\u1f1f"
        + "\u1f46\u1f47"
        + "\u1f4e\u1f4f"
        + "\u1f58\u1f58"
        + "\u1f5a\u1f5a"
        + "\u1f5c\u1f5c"
        + "\u1f5e\u1f5e"
        + "\u1f7e\u1f7f"
        + "\u1fb5\u1fb5"
        + "\u1fc5\u1fc5"
        + "\u1fd4\u1fd5"
        + "\u1fdc\u1fdc"
        + "\u1ff0\u1ff1"
        + "\u1ff5\u1ff5"
        + "\u1fff\u1fff"
        + "\u2065\u2065"
        + "\u2072\u2073"
        + "\u208f\u208f"
        + "\u209d\u209f"
        + "\u20be\u20cf"
        + "\u20f1\u20ff"
        + "\u218a\u218f"
        + "\u23fb\u23ff"
        + "\u2427\u243f"
        + "\u244b\u245f"
        + "\u2b74\u2b75"
        + "\u2b96\u2b97"
        + "\u2bba\u2bbc"
        + "\u2bc9\u2bc9"
        + "\u2bd2\u2bff"
        + "\u2c2f\u2c2f"
        + "\u2c5f\u2c5f"
        + "\u2cf4\u2cf8"
        + "\u2d26\u2d26"
        + "\u2d28\u2d2c"
        + "\u2d2e\u2d2f"
        + "\u2d68\u2d6e"
        + "\u2d71\u2d7e"
        + "\u2d97\u2d9f"
        + "\u2da7\u2da7"
        + "\u2daf\u2daf"
        + "\u2db7\u2db7"
        + "\u2dbf\u2dbf"
        + "\u2dc7\u2dc7"
        + "\u2dcf\u2dcf"
        + "\u2dd7\u2dd7"
        + "\u2ddf\u2ddf"
        + "\u2e43\u2e7f"
        + "\u2e9a\u2e9a"
        + "\u2ef4\u2eff"
        + "\u2fd6\u2fef"
        + "\u2ffc\u2fff"
        + "\u3040\u3040"
        + "\u3097\u3098"
        + "\u3100\u3104"
        + "\u312e\u3130"
        + "\u318f\u318f"
        + "\u31bb\u31bf"
        + "\u31e4\u31ef"
        + "\u321f\u321f"
        + "\u32ff\u32ff"
        + "\u4db6\u4dbf"
        + "\u9fcd\u9fff"
        + "\ua48d\ua48f"
        + "\ua4c7\ua4cf"
        + "\ua62c\ua63f"
        + "\ua69e\ua69e"
        + "\ua6f8\ua6ff"
        + "\ua78f\ua78f"
        + "\ua7ae\ua7af"
        + "\ua7b2\ua7f6"
        + "\ua82c\ua82f"
        + "\ua83a\ua83f"
        + "\ua878\ua87f"
        + "\ua8c5\ua8cd"
        + "\ua8da\ua8df"
        + "\ua8fc\ua8ff"
        + "\ua954\ua95e"
        + "\ua97d\ua97f"
        + "\ua9ce\ua9ce"
        + "\ua9da\ua9dd"
        + "\ua9ff\ua9ff"
        + "\uaa37\uaa3f"
        + "\uaa4e\uaa4f"
        + "\uaa5a\uaa5b"
        + "\uaac3\uaada"
        + "\uaaf7\uab00"
        + "\uab07\uab08"
        + "\uab0f\uab10"
        + "\uab17\uab1f"
        + "\uab27\uab27"
        + "\uab2f\uab2f"
        + "\uab60\uab63"
        + "\uab66\uabbf"
        + "\uabee\uabef"
        + "\uabfa\uabff"
        + "\ud7a4\ud7af"
        + "\ud7c7\ud7ca"
        + "\ud7fc\ud7ff"
        + "\ufa6e\ufa6f"
        + "\ufada\ufaff"
        + "\ufb07\ufb12"
        + "\ufb18\ufb1c"
        + "\ufb37\ufb37"
        + "\ufb3d\ufb3d"
        + "\ufb3f\ufb3f"
        + "\ufb42\ufb42"
        + "\ufb45\ufb45"
        + "\ufbc2\ufbd2"
        + "\ufd40\ufd4f"
        + "\ufd90\ufd91"
        + "\ufdc8\ufdcf"
        + "\ufdfe\ufdff"
        + "\ufe1a\ufe1f"
        + "\ufe2e\ufe2f"
        + "\ufe53\ufe53"
        + "\ufe67\ufe67"
        + "\ufe6c\ufe6f"
        + "\ufe75\ufe75"
        + "\ufefd\ufefe"
        + "\uff00\uff00"
        + "\uffbf\uffc1"
        + "\uffc8\uffc9"
        + "\uffd0\uffd1"
        + "\uffd8\uffd9"
        + "\uffdd\uffdf"
        + "\uffe7\uffe7"
        + "\uffef\ufff8"
        + "\ud800\udc0c\ud800\udc0c"
        + "\ud800\udc27\ud800\udc27"
        + "\ud800\udc3b\ud800\udc3b"
        + "\ud800\udc3e\ud800\udc3e"
        + "\ud800\udc4e\ud800\udc4f"
        + "\ud800\udc5e\ud800\udc7f"
        + "\ud800\udcfb\ud800\udcff"
        + "\ud800\udd03\ud800\udd06"
        + "\ud800\udd34\ud800\udd36"
        + "\ud800\udd8d\ud800\udd8f"
        + "\ud800\udd9c\ud800\udd9f"
        + "\ud800\udda1\ud800\uddcf"
        + "\ud800\uddfe\ud800\ude7f"
        + "\ud800\ude9d\ud800\ude9f"
        + "\ud800\uded1\ud800\udedf"
        + "\ud800\udefc\ud800\udeff"
        + "\ud800\udf24\ud800\udf2f"
        + "\ud800\udf4b\ud800\udf4f"
        + "\ud800\udf7b\ud800\udf7f"
        + "\ud800\udf9e\ud800\udf9e"
        + "\ud800\udfc4\ud800\udfc7"
        + "\ud800\udfd6\ud800\udfff"
        + "\ud801\udc9e\ud801\udc9f"
        + "\ud801\udcaa\ud801\udcff"
        + "\ud801\udd28\ud801\udd2f"
        + "\ud801\udd64\ud801\udd6e"
        + "\ud801\udd70\ud801\uddff"
        + "\ud801\udf37\ud801\udf3f"
        + "\ud801\udf56\ud801\udf5f"
        + "\ud801\udf68\ud801\udfff"
        + "\ud802\udc06\ud802\udc07"
        + "\ud802\udc09\ud802\udc09"
        + "\ud802\udc36\ud802\udc36"
        + "\ud802\udc39\ud802\udc3b"
        + "\ud802\udc3d\ud802\udc3e"
        + "\ud802\udc56\ud802\udc56"
        + "\ud802\udc9f\ud802\udca6"
        + "\ud802\udcb0\ud802\udcff"
        + "\ud802\udd1c\ud802\udd1e"
        + "\ud802\udd3a\ud802\udd3e"
        + "\ud802\udd40\ud802\udd7f"
        + "\ud802\uddb8\ud802\uddbd"
        + "\ud802\uddc0\ud802\uddff"
        + "\ud802\ude04\ud802\ude04"
        + "\ud802\ude07\ud802\ude0b"
        + "\ud802\ude14\ud802\ude14"
        + "\ud802\ude18\ud802\ude18"
        + "\ud802\ude34\ud802\ude37"
        + "\ud802\ude3b\ud802\ude3e"
        + "\ud802\ude48\ud802\ude4f"
        + "\ud802\ude59\ud802\ude5f"
        + "\ud802\udea0\ud802\udebf"
        + "\ud802\udee7\ud802\udeea"
        + "\ud802\udef7\ud802\udeff"
        + "\ud802\udf36\ud802\udf38"
        + "\ud802\udf56\ud802\udf57"
        + "\ud802\udf73\ud802\udf77"
        + "\ud802\udf92\ud802\udf98"
        + "\ud802\udf9d\ud802\udfa8"
        + "\ud802\udfb0\ud802\udfff"
        + "\ud803\udc49\ud803\ude5f"
        + "\ud803\ude7f\ud803\udfff"
        + "\ud804\udc4e\ud804\udc51"
        + "\ud804\udc70\ud804\udc7e"
        + "\ud804\udcc2\ud804\udccf"
        + "\ud804\udce9\ud804\udcef"
        + "\ud804\udcfa\ud804\udcff"
        + "\ud804\udd35\ud804\udd35"
        + "\ud804\udd44\ud804\udd4f"
        + "\ud804\udd77\ud804\udd7f"
        + "\ud804\uddc9\ud804\uddcc"
        + "\ud804\uddce\ud804\uddcf"
        + "\ud804\udddb\ud804\udde0"
        + "\ud804\uddf5\ud804\uddff"
        + "\ud804\ude12\ud804\ude12"
        + "\ud804\ude3e\ud804\udeaf"
        + "\ud804\udeeb\ud804\udeef"
        + "\ud804\udefa\ud804\udf00"
        + "\ud804\udf04\ud804\udf04"
        + "\ud804\udf0d\ud804\udf0e"
        + "\ud804\udf11\ud804\udf12"
        + "\ud804\udf29\ud804\udf29"
        + "\ud804\udf31\ud804\udf31"
        + "\ud804\udf34\ud804\udf34"
        + "\ud804\udf3a\ud804\udf3b"
        + "\ud804\udf45\ud804\udf46"
        + "\ud804\udf49\ud804\udf4a"
        + "\ud804\udf4e\ud804\udf56"
        + "\ud804\udf58\ud804\udf5c"
        + "\ud804\udf64\ud804\udf65"
        + "\ud804\udf6d\ud804\udf6f"
        + "\ud804\udf75\ud805\udc7f"
        + "\ud805\udcc8\ud805\udccf"
        + "\ud805\udcda\ud805\udd7f"
        + "\ud805\uddb6\ud805\uddb7"
        + "\ud805\uddca\ud805\uddff"
        + "\ud805\ude45\ud805\ude4f"
        + "\ud805\ude5a\ud805\ude7f"
        + "\ud805\udeb8\ud805\udebf"
        + "\ud805\udeca\ud806\udc9f"
        + "\ud806\udcf3\ud806\udcfe"
        + "\ud806\udd00\ud806\udebf"
        + "\ud806\udef9\ud807\udfff"
        + "\ud808\udf99\ud808\udfff"
        + "\ud809\udc6f\ud809\udc6f"
        + "\ud809\udc75\ud80b\udfff"
        + "\ud80d\udc2f\ud819\udfff"
        + "\ud81a\ude39\ud81a\ude3f"
        + "\ud81a\ude5f\ud81a\ude5f"
        + "\ud81a\ude6a\ud81a\ude6d"
        + "\ud81a\ude70\ud81a\udecf"
        + "\ud81a\udeee\ud81a\udeef"
        + "\ud81a\udef6\ud81a\udeff"
        + "\ud81a\udf46\ud81a\udf4f"
        + "\ud81a\udf5a\ud81a\udf5a"
        + "\ud81a\udf62\ud81a\udf62"
        + "\ud81a\udf78\ud81a\udf7c"
        + "\ud81a\udf90\ud81b\udeff"
        + "\ud81b\udf45\ud81b\udf4f"
        + "\ud81b\udf7f\ud81b\udf8e"
        + "\ud81b\udfa0\ud82b\udfff"
        + "\ud82c\udc02\ud82e\udfff"
        + "\ud82f\udc6b\ud82f\udc6f"
        + "\ud82f\udc7d\ud82f\udc7f"
        + "\ud82f\udc89\ud82f\udc8f"
        + "\ud82f\udc9a\ud82f\udc9b"
        + "\ud82f\udca4\ud833\udfff"
        + "\ud834\udcf6\ud834\udcff"
        + "\ud834\udd27\ud834\udd28"
        + "\ud834\uddde\ud834\uddff"
        + "\ud834\ude46\ud834\udeff"
        + "\ud834\udf57\ud834\udf5f"
        + "\ud834\udf72\ud834\udfff"
        + "\ud835\udc55\ud835\udc55"
        + "\ud835\udc9d\ud835\udc9d"
        + "\ud835\udca0\ud835\udca1"
        + "\ud835\udca3\ud835\udca4"
        + "\ud835\udca7\ud835\udca8"
        + "\ud835\udcad\ud835\udcad"
        + "\ud835\udcba\ud835\udcba"
        + "\ud835\udcbc\ud835\udcbc"
        + "\ud835\udcc4\ud835\udcc4"
        + "\ud835\udd06\ud835\udd06"
        + "\ud835\udd0b\ud835\udd0c"
        + "\ud835\udd15\ud835\udd15"
        + "\ud835\udd1d\ud835\udd1d"
        + "\ud835\udd3a\ud835\udd3a"
        + "\ud835\udd3f\ud835\udd3f"
        + "\ud835\udd45\ud835\udd45"
        + "\ud835\udd47\ud835\udd49"
        + "\ud835\udd51\ud835\udd51"
        + "\ud835\udea6\ud835\udea7"
        + "\ud835\udfcc\ud835\udfcd"
        + "\ud836\udc00\ud839\udfff"
        + "\ud83a\udcc5\ud83a\udcc6"
        + "\ud83a\udcd7\ud83b\uddff"
        + "\ud83b\ude04\ud83b\ude04"
        + "\ud83b\ude20\ud83b\ude20"
        + "\ud83b\ude23\ud83b\ude23"
        + "\ud83b\ude25\ud83b\ude26"
        + "\ud83b\ude28\ud83b\ude28"
        + "\ud83b\ude33\ud83b\ude33"
        + "\ud83b\ude38\ud83b\ude38"
        + "\ud83b\ude3a\ud83b\ude3a"
        + "\ud83b\ude3c\ud83b\ude41"
        + "\ud83b\ude43\ud83b\ude46"
        + "\ud83b\ude48\ud83b\ude48"
        + "\ud83b\ude4a\ud83b\ude4a"
        + "\ud83b\ude4c\ud83b\ude4c"
        + "\ud83b\ude50\ud83b\ude50"
        + "\ud83b\ude53\ud83b\ude53"
        + "\ud83b\ude55\ud83b\ude56"
        + "\ud83b\ude58\ud83b\ude58"
        + "\ud83b\ude5a\ud83b\ude5a"
        + "\ud83b\ude5c\ud83b\ude5c"
        + "\ud83b\ude5e\ud83b\ude5e"
        + "\ud83b\ude60\ud83b\ude60"
        + "\ud83b\ude63\ud83b\ude63"
        + "\ud83b\ude65\ud83b\ude66"
        + "\ud83b\ude6b\ud83b\ude6b"
        + "\ud83b\ude73\ud83b\ude73"
        + "\ud83b\ude78\ud83b\ude78"
        + "\ud83b\ude7d\ud83b\ude7d"
        + "\ud83b\ude7f\ud83b\ude7f"
        + "\ud83b\ude8a\ud83b\ude8a"
        + "\ud83b\ude9c\ud83b\udea0"
        + "\ud83b\udea4\ud83b\udea4"
        + "\ud83b\udeaa\ud83b\udeaa"
        + "\ud83b\udebc\ud83b\udeef"
        + "\ud83b\udef2\ud83b\udfff"
        + "\ud83c\udc2c\ud83c\udc2f"
        + "\ud83c\udc94\ud83c\udc9f"
        + "\ud83c\udcaf\ud83c\udcb0"
        + "\ud83c\udcc0\ud83c\udcc0"
        + "\ud83c\udcd0\ud83c\udcd0"
        + "\ud83c\udcf6\ud83c\udcff"
        + "\ud83c\udd0d\ud83c\udd0f"
        + "\ud83c\udd2f\ud83c\udd2f"
        + "\ud83c\udd6c\ud83c\udd6f"
        + "\ud83c\udd9b\ud83c\udde5"
        + "\ud83c\ude03\ud83c\ude0f"
        + "\ud83c\ude3b\ud83c\ude3f"
        + "\ud83c\ude49\ud83c\ude4f"
        + "\ud83c\ude52\ud83c\udeff"
        + "\ud83c\udf2d\ud83c\udf2f"
        + "\ud83c\udf7e\ud83c\udf7f"
        + "\ud83c\udfcf\ud83c\udfd3"
        + "\ud83c\udff8\ud83c\udfff"
        + "\ud83d\udcff\ud83d\udcff"
        + "\ud83d\udd4b\ud83d\udd4f"
        + "\ud83d\udd7a\ud83d\udd7a"
        + "\ud83d\udda4\ud83d\udda4"
        + "\ud83d\ude43\ud83d\ude44"
        + "\ud83d\uded0\ud83d\udedf"
        + "\ud83d\udeed\ud83d\udeef"
        + "\ud83d\udef4\ud83d\udeff"
        + "\ud83d\udf74\ud83d\udf7f"
        + "\ud83d\udfd5\ud83d\udfff"
        + "\ud83e\udc0c\ud83e\udc0f"
        + "\ud83e\udc48\ud83e\udc4f"
        + "\ud83e\udc5a\ud83e\udc5f"
        + "\ud83e\udc88\ud83e\udc8f"
        + "\ud83e\udcae\ud83f\udffd"
        + "\ud869\uded7\ud869\udeff"
        + "\ud86d\udf35\ud86d\udf3f"
        + "\ud86e\udc1e\ud87d\udfff"
        + "\ud87e\ude1e\ud87f\udffd"
        + "\ud880\udc00\ud8bf\udffd"
        + "\ud8c0\udc00\ud8ff\udffd"
        + "\ud900\udc00\ud93f\udffd"
        + "\ud940\udc00\ud97f\udffd"
        + "\ud980\udc00\ud9bf\udffd"
        + "\ud9c0\udc00\ud9ff\udffd"
        + "\uda00\udc00\uda3f\udffd"
        + "\uda40\udc00\uda7f\udffd"
        + "\uda80\udc00\udabf\udffd"
        + "\udac0\udc00\udaff\udffd"
        + "\udb00\udc00\udb3f\udffd"
        + "\udb40\udc00\udb40\udc00"
        + "\udb40\udc02\udb40\udc1f"
        + "\udb40\udc80\udb40\udcff"
        + "\udb40\uddf0\udb7f\udffd",
    // Unicode 7.0 property value: {age=v11}
    "\000\u01f5"
        + "\u01fa\u0217"
        + "\u0250\u02a8"
        + "\u02b0\u02de"
        + "\u02e0\u02e9"
        + "\u0300\u0345"
        + "\u0360\u0361"
        + "\u0374\u0375"
        + "\u037a\u037a"
        + "\u037e\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03ce"
        + "\u03d0\u03d6"
        + "\u03da\u03da"
        + "\u03dc\u03dc"
        + "\u03de\u03de"
        + "\u03e0\u03e0"
        + "\u03e2\u03f3"
        + "\u0401\u040c"
        + "\u040e\u044f"
        + "\u0451\u045c"
        + "\u045e\u0486"
        + "\u0490\u04c4"
        + "\u04c7\u04c8"
        + "\u04cb\u04cc"
        + "\u04d0\u04eb"
        + "\u04ee\u04f5"
        + "\u04f8\u04f9"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u0589"
        + "\u05b0\u05b9"
        + "\u05bb\u05c3"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u060c\u060c"
        + "\u061b\u061b"
        + "\u061f\u061f"
        + "\u0621\u063a"
        + "\u0640\u0652"
        + "\u0660\u066d"
        + "\u0670\u06b7"
        + "\u06ba\u06be"
        + "\u06c0\u06ce"
        + "\u06d0\u06ed"
        + "\u06f0\u06f9"
        + "\u0901\u0903"
        + "\u0905\u0939"
        + "\u093c\u094d"
        + "\u0950\u0954"
        + "\u0958\u0970"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09bc"
        + "\u09be\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09cd"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fa"
        + "\u0a02\u0a02"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a74"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8b"
        + "\u0a8d\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae0"
        + "\u0ae6\u0aef"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b36\u0b39"
        + "\u0b3c\u0b43"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b66\u0b70"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb5"
        + "\u0bb7\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0be7\u0bf2"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3e\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c60\u0c61"
        + "\u0c66\u0c6f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbe\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0ce6\u0cef"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d28"
        + "\u0d2a\u0d39"
        + "\u0d3e\u0d43"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d60\u0d61"
        + "\u0d66\u0d6f"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edd"
        + "\u10a0\u10c5"
        + "\u10d0\u10f6"
        + "\u10fb\u10fb"
        + "\u1100\u1159"
        + "\u115f\u11a2"
        + "\u11a8\u11f9"
        + "\u1e00\u1e9a"
        + "\u1ea0\u1ef9"
        + "\u1f00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u202e"
        + "\u2030\u2046"
        + "\u206a\u2070"
        + "\u2074\u208e"
        + "\u20a0\u20aa"
        + "\u20d0\u20e1"
        + "\u2100\u2138"
        + "\u2153\u2182"
        + "\u2190\u21ea"
        + "\u2200\u22f1"
        + "\u2300\u2300"
        + "\u2302\u237a"
        + "\u2400\u2424"
        + "\u2440\u244a"
        + "\u2460\u24ea"
        + "\u2500\u2595"
        + "\u25a0\u25ef"
        + "\u2600\u2613"
        + "\u261a\u266f"
        + "\u2701\u2704"
        + "\u2706\u2709"
        + "\u270c\u2727"
        + "\u2729\u274b"
        + "\u274d\u274d"
        + "\u274f\u2752"
        + "\u2756\u2756"
        + "\u2758\u275e"
        + "\u2761\u2767"
        + "\u2776\u2794"
        + "\u2798\u27af"
        + "\u27b1\u27be"
        + "\u3000\u3037"
        + "\u303f\u303f"
        + "\u3041\u3094"
        + "\u3099\u309e"
        + "\u30a1\u30fe"
        + "\u3105\u312c"
        + "\u3131\u318e"
        + "\u3190\u319f"
        + "\u3200\u321c"
        + "\u3220\u3243"
        + "\u3260\u327b"
        + "\u327f\u32b0"
        + "\u32c0\u32cb"
        + "\u32d0\u32fe"
        + "\u3300\u3376"
        + "\u337b\u33dd"
        + "\u33e0\u33fe"
        + "\u4e00\u9fa5"
        + "\ue000\ufa2d"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1e\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfb"
        + "\ufe20\ufe23"
        + "\ufe30\ufe44"
        + "\ufe49\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe72"
        + "\ufe74\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uff5e"
        + "\uff61\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufffd\uffff",
    // Unicode 7.0 property value: {age=v20}
    "\000\u01f5"
        + "\u01fa\u0217"
        + "\u0250\u02a8"
        + "\u02b0\u02de"
        + "\u02e0\u02e9"
        + "\u0300\u0345"
        + "\u0360\u0361"
        + "\u0374\u0375"
        + "\u037a\u037a"
        + "\u037e\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03ce"
        + "\u03d0\u03d6"
        + "\u03da\u03da"
        + "\u03dc\u03dc"
        + "\u03de\u03de"
        + "\u03e0\u03e0"
        + "\u03e2\u03f3"
        + "\u0401\u040c"
        + "\u040e\u044f"
        + "\u0451\u045c"
        + "\u045e\u0486"
        + "\u0490\u04c4"
        + "\u04c7\u04c8"
        + "\u04cb\u04cc"
        + "\u04d0\u04eb"
        + "\u04ee\u04f5"
        + "\u04f8\u04f9"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u0589"
        + "\u0591\u05a1"
        + "\u05a3\u05b9"
        + "\u05bb\u05c4"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u060c\u060c"
        + "\u061b\u061b"
        + "\u061f\u061f"
        + "\u0621\u063a"
        + "\u0640\u0652"
        + "\u0660\u066d"
        + "\u0670\u06b7"
        + "\u06ba\u06be"
        + "\u06c0\u06ce"
        + "\u06d0\u06ed"
        + "\u06f0\u06f9"
        + "\u0901\u0903"
        + "\u0905\u0939"
        + "\u093c\u094d"
        + "\u0950\u0954"
        + "\u0958\u0970"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09bc"
        + "\u09be\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09cd"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fa"
        + "\u0a02\u0a02"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a74"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8b"
        + "\u0a8d\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae0"
        + "\u0ae6\u0aef"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b36\u0b39"
        + "\u0b3c\u0b43"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b66\u0b70"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb5"
        + "\u0bb7\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0be7\u0bf2"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3e\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c60\u0c61"
        + "\u0c66\u0c6f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbe\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0ce6\u0cef"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d28"
        + "\u0d2a\u0d39"
        + "\u0d3e\u0d43"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d60\u0d61"
        + "\u0d66\u0d6f"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edd"
        + "\u0f00\u0f47"
        + "\u0f49\u0f69"
        + "\u0f71\u0f8b"
        + "\u0f90\u0f95"
        + "\u0f97\u0f97"
        + "\u0f99\u0fad"
        + "\u0fb1\u0fb7"
        + "\u0fb9\u0fb9"
        + "\u10a0\u10c5"
        + "\u10d0\u10f6"
        + "\u10fb\u10fb"
        + "\u1100\u1159"
        + "\u115f\u11a2"
        + "\u11a8\u11f9"
        + "\u1e00\u1e9b"
        + "\u1ea0\u1ef9"
        + "\u1f00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u202e"
        + "\u2030\u2046"
        + "\u206a\u2070"
        + "\u2074\u208e"
        + "\u20a0\u20ab"
        + "\u20d0\u20e1"
        + "\u2100\u2138"
        + "\u2153\u2182"
        + "\u2190\u21ea"
        + "\u2200\u22f1"
        + "\u2300\u2300"
        + "\u2302\u237a"
        + "\u2400\u2424"
        + "\u2440\u244a"
        + "\u2460\u24ea"
        + "\u2500\u2595"
        + "\u25a0\u25ef"
        + "\u2600\u2613"
        + "\u261a\u266f"
        + "\u2701\u2704"
        + "\u2706\u2709"
        + "\u270c\u2727"
        + "\u2729\u274b"
        + "\u274d\u274d"
        + "\u274f\u2752"
        + "\u2756\u2756"
        + "\u2758\u275e"
        + "\u2761\u2767"
        + "\u2776\u2794"
        + "\u2798\u27af"
        + "\u27b1\u27be"
        + "\u3000\u3037"
        + "\u303f\u303f"
        + "\u3041\u3094"
        + "\u3099\u309e"
        + "\u30a1\u30fe"
        + "\u3105\u312c"
        + "\u3131\u318e"
        + "\u3190\u319f"
        + "\u3200\u321c"
        + "\u3220\u3243"
        + "\u3260\u327b"
        + "\u327f\u32b0"
        + "\u32c0\u32cb"
        + "\u32d0\u32fe"
        + "\u3300\u3376"
        + "\u337b\u33dd"
        + "\u33e0\u33fe"
        + "\u4e00\u9fa5"
        + "\uac00\ud7a3"
        + "\ue000\ufa2d"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1e\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfb"
        + "\ufe20\ufe23"
        + "\ufe30\ufe44"
        + "\ufe49\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe72"
        + "\ufe74\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uff5e"
        + "\uff61\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufffd\uffff"
        + "\ud83f\udffe\ud83f\udfff"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v21}
    "\000\u01f5"
        + "\u01fa\u0217"
        + "\u0250\u02a8"
        + "\u02b0\u02de"
        + "\u02e0\u02e9"
        + "\u0300\u0345"
        + "\u0360\u0361"
        + "\u0374\u0375"
        + "\u037a\u037a"
        + "\u037e\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03ce"
        + "\u03d0\u03d6"
        + "\u03da\u03da"
        + "\u03dc\u03dc"
        + "\u03de\u03de"
        + "\u03e0\u03e0"
        + "\u03e2\u03f3"
        + "\u0401\u040c"
        + "\u040e\u044f"
        + "\u0451\u045c"
        + "\u045e\u0486"
        + "\u0490\u04c4"
        + "\u04c7\u04c8"
        + "\u04cb\u04cc"
        + "\u04d0\u04eb"
        + "\u04ee\u04f5"
        + "\u04f8\u04f9"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u0589"
        + "\u0591\u05a1"
        + "\u05a3\u05b9"
        + "\u05bb\u05c4"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u060c\u060c"
        + "\u061b\u061b"
        + "\u061f\u061f"
        + "\u0621\u063a"
        + "\u0640\u0652"
        + "\u0660\u066d"
        + "\u0670\u06b7"
        + "\u06ba\u06be"
        + "\u06c0\u06ce"
        + "\u06d0\u06ed"
        + "\u06f0\u06f9"
        + "\u0901\u0903"
        + "\u0905\u0939"
        + "\u093c\u094d"
        + "\u0950\u0954"
        + "\u0958\u0970"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09bc"
        + "\u09be\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09cd"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fa"
        + "\u0a02\u0a02"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a74"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8b"
        + "\u0a8d\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae0"
        + "\u0ae6\u0aef"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b36\u0b39"
        + "\u0b3c\u0b43"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b66\u0b70"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb5"
        + "\u0bb7\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0be7\u0bf2"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3e\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c60\u0c61"
        + "\u0c66\u0c6f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbe\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0ce6\u0cef"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d28"
        + "\u0d2a\u0d39"
        + "\u0d3e\u0d43"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d60\u0d61"
        + "\u0d66\u0d6f"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edd"
        + "\u0f00\u0f47"
        + "\u0f49\u0f69"
        + "\u0f71\u0f8b"
        + "\u0f90\u0f95"
        + "\u0f97\u0f97"
        + "\u0f99\u0fad"
        + "\u0fb1\u0fb7"
        + "\u0fb9\u0fb9"
        + "\u10a0\u10c5"
        + "\u10d0\u10f6"
        + "\u10fb\u10fb"
        + "\u1100\u1159"
        + "\u115f\u11a2"
        + "\u11a8\u11f9"
        + "\u1e00\u1e9b"
        + "\u1ea0\u1ef9"
        + "\u1f00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u202e"
        + "\u2030\u2046"
        + "\u206a\u2070"
        + "\u2074\u208e"
        + "\u20a0\u20ac"
        + "\u20d0\u20e1"
        + "\u2100\u2138"
        + "\u2153\u2182"
        + "\u2190\u21ea"
        + "\u2200\u22f1"
        + "\u2300\u2300"
        + "\u2302\u237a"
        + "\u2400\u2424"
        + "\u2440\u244a"
        + "\u2460\u24ea"
        + "\u2500\u2595"
        + "\u25a0\u25ef"
        + "\u2600\u2613"
        + "\u261a\u266f"
        + "\u2701\u2704"
        + "\u2706\u2709"
        + "\u270c\u2727"
        + "\u2729\u274b"
        + "\u274d\u274d"
        + "\u274f\u2752"
        + "\u2756\u2756"
        + "\u2758\u275e"
        + "\u2761\u2767"
        + "\u2776\u2794"
        + "\u2798\u27af"
        + "\u27b1\u27be"
        + "\u3000\u3037"
        + "\u303f\u303f"
        + "\u3041\u3094"
        + "\u3099\u309e"
        + "\u30a1\u30fe"
        + "\u3105\u312c"
        + "\u3131\u318e"
        + "\u3190\u319f"
        + "\u3200\u321c"
        + "\u3220\u3243"
        + "\u3260\u327b"
        + "\u327f\u32b0"
        + "\u32c0\u32cb"
        + "\u32d0\u32fe"
        + "\u3300\u3376"
        + "\u337b\u33dd"
        + "\u33e0\u33fe"
        + "\u4e00\u9fa5"
        + "\uac00\ud7a3"
        + "\ue000\ufa2d"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1e\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfb"
        + "\ufe20\ufe23"
        + "\ufe30\ufe44"
        + "\ufe49\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe72"
        + "\ufe74\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uff5e"
        + "\uff61\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufffc\uffff"
        + "\ud83f\udffe\ud83f\udfff"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v30}
    "\000\u021f"
        + "\u0222\u0233"
        + "\u0250\u02ad"
        + "\u02b0\u02ee"
        + "\u0300\u034e"
        + "\u0360\u0362"
        + "\u0374\u0375"
        + "\u037a\u037a"
        + "\u037e\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03ce"
        + "\u03d0\u03d7"
        + "\u03da\u03f3"
        + "\u0400\u0486"
        + "\u0488\u0489"
        + "\u048c\u04c4"
        + "\u04c7\u04c8"
        + "\u04cb\u04cc"
        + "\u04d0\u04f5"
        + "\u04f8\u04f9"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u0591\u05a1"
        + "\u05a3\u05b9"
        + "\u05bb\u05c4"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u060c\u060c"
        + "\u061b\u061b"
        + "\u061f\u061f"
        + "\u0621\u063a"
        + "\u0640\u0655"
        + "\u0660\u066d"
        + "\u0670\u06ed"
        + "\u06f0\u06fe"
        + "\u0700\u070d"
        + "\u070f\u072c"
        + "\u0730\u074a"
        + "\u0780\u07b0"
        + "\u0901\u0903"
        + "\u0905\u0939"
        + "\u093c\u094d"
        + "\u0950\u0954"
        + "\u0958\u0970"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09bc"
        + "\u09be\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09cd"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fa"
        + "\u0a02\u0a02"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a74"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8b"
        + "\u0a8d\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae0"
        + "\u0ae6\u0aef"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b36\u0b39"
        + "\u0b3c\u0b43"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b66\u0b70"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb5"
        + "\u0bb7\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0be7\u0bf2"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3e\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c60\u0c61"
        + "\u0c66\u0c6f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbe\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0ce6\u0cef"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d28"
        + "\u0d2a\u0d39"
        + "\u0d3e\u0d43"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d60\u0d61"
        + "\u0d66\u0d6f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edd"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6a"
        + "\u0f71\u0f8b"
        + "\u0f90\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fcf\u0fcf"
        + "\u1000\u1021"
        + "\u1023\u1027"
        + "\u1029\u102a"
        + "\u102c\u1032"
        + "\u1036\u1039"
        + "\u1040\u1059"
        + "\u10a0\u10c5"
        + "\u10d0\u10f6"
        + "\u10fb\u10fb"
        + "\u1100\u1159"
        + "\u115f\u11a2"
        + "\u11a8\u11f9"
        + "\u1200\u1206"
        + "\u1208\u1246"
        + "\u1248\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1286"
        + "\u1288\u1288"
        + "\u128a\u128d"
        + "\u1290\u12ae"
        + "\u12b0\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12ce"
        + "\u12d0\u12d6"
        + "\u12d8\u12ee"
        + "\u12f0\u130e"
        + "\u1310\u1310"
        + "\u1312\u1315"
        + "\u1318\u131e"
        + "\u1320\u1346"
        + "\u1348\u135a"
        + "\u1361\u137c"
        + "\u13a0\u13f4"
        + "\u1401\u1676"
        + "\u1680\u169c"
        + "\u16a0\u16f0"
        + "\u1780\u17dc"
        + "\u17e0\u17e9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18a9"
        + "\u1e00\u1e9b"
        + "\u1ea0\u1ef9"
        + "\u1f00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2046"
        + "\u2048\u204d"
        + "\u206a\u2070"
        + "\u2074\u208e"
        + "\u20a0\u20af"
        + "\u20d0\u20e3"
        + "\u2100\u213a"
        + "\u2153\u2183"
        + "\u2190\u21f3"
        + "\u2200\u22f1"
        + "\u2300\u237b"
        + "\u237d\u239a"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u24ea"
        + "\u2500\u2595"
        + "\u25a0\u25f7"
        + "\u2600\u2613"
        + "\u2619\u2671"
        + "\u2701\u2704"
        + "\u2706\u2709"
        + "\u270c\u2727"
        + "\u2729\u274b"
        + "\u274d\u274d"
        + "\u274f\u2752"
        + "\u2756\u2756"
        + "\u2758\u275e"
        + "\u2761\u2767"
        + "\u2776\u2794"
        + "\u2798\u27af"
        + "\u27b1\u27be"
        + "\u2800\u28ff"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303a"
        + "\u303e\u303f"
        + "\u3041\u3094"
        + "\u3099\u309e"
        + "\u30a1\u30fe"
        + "\u3105\u312c"
        + "\u3131\u318e"
        + "\u3190\u31b7"
        + "\u3200\u321c"
        + "\u3220\u3243"
        + "\u3260\u327b"
        + "\u327f\u32b0"
        + "\u32c0\u32cb"
        + "\u32d0\u32fe"
        + "\u3300\u3376"
        + "\u337b\u33dd"
        + "\u33e0\u33fe"
        + "\u3400\u4db5"
        + "\u4e00\u9fa5"
        + "\ua000\ua48c"
        + "\ua490\ua4a1"
        + "\ua4a4\ua4b3"
        + "\ua4b5\ua4c0"
        + "\ua4c2\ua4c4"
        + "\ua4c6\ua4c6"
        + "\uac00\ud7a3"
        + "\ue000\ufa2d"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfb"
        + "\ufe20\ufe23"
        + "\ufe30\ufe44"
        + "\ufe49\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe72"
        + "\ufe74\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uff5e"
        + "\uff61\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\uffff"
        + "\ud83f\udffe\ud83f\udfff"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v31}
    "\000\u021f"
        + "\u0222\u0233"
        + "\u0250\u02ad"
        + "\u02b0\u02ee"
        + "\u0300\u034e"
        + "\u0360\u0362"
        + "\u0374\u0375"
        + "\u037a\u037a"
        + "\u037e\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03ce"
        + "\u03d0\u03d7"
        + "\u03da\u03f5"
        + "\u0400\u0486"
        + "\u0488\u0489"
        + "\u048c\u04c4"
        + "\u04c7\u04c8"
        + "\u04cb\u04cc"
        + "\u04d0\u04f5"
        + "\u04f8\u04f9"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u0591\u05a1"
        + "\u05a3\u05b9"
        + "\u05bb\u05c4"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u060c\u060c"
        + "\u061b\u061b"
        + "\u061f\u061f"
        + "\u0621\u063a"
        + "\u0640\u0655"
        + "\u0660\u066d"
        + "\u0670\u06ed"
        + "\u06f0\u06fe"
        + "\u0700\u070d"
        + "\u070f\u072c"
        + "\u0730\u074a"
        + "\u0780\u07b0"
        + "\u0901\u0903"
        + "\u0905\u0939"
        + "\u093c\u094d"
        + "\u0950\u0954"
        + "\u0958\u0970"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09bc"
        + "\u09be\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09cd"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fa"
        + "\u0a02\u0a02"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a74"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8b"
        + "\u0a8d\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae0"
        + "\u0ae6\u0aef"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b36\u0b39"
        + "\u0b3c\u0b43"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b66\u0b70"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb5"
        + "\u0bb7\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0be7\u0bf2"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3e\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c60\u0c61"
        + "\u0c66\u0c6f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbe\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0ce6\u0cef"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d28"
        + "\u0d2a\u0d39"
        + "\u0d3e\u0d43"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d60\u0d61"
        + "\u0d66\u0d6f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edd"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6a"
        + "\u0f71\u0f8b"
        + "\u0f90\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fcf\u0fcf"
        + "\u1000\u1021"
        + "\u1023\u1027"
        + "\u1029\u102a"
        + "\u102c\u1032"
        + "\u1036\u1039"
        + "\u1040\u1059"
        + "\u10a0\u10c5"
        + "\u10d0\u10f6"
        + "\u10fb\u10fb"
        + "\u1100\u1159"
        + "\u115f\u11a2"
        + "\u11a8\u11f9"
        + "\u1200\u1206"
        + "\u1208\u1246"
        + "\u1248\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1286"
        + "\u1288\u1288"
        + "\u128a\u128d"
        + "\u1290\u12ae"
        + "\u12b0\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12ce"
        + "\u12d0\u12d6"
        + "\u12d8\u12ee"
        + "\u12f0\u130e"
        + "\u1310\u1310"
        + "\u1312\u1315"
        + "\u1318\u131e"
        + "\u1320\u1346"
        + "\u1348\u135a"
        + "\u1361\u137c"
        + "\u13a0\u13f4"
        + "\u1401\u1676"
        + "\u1680\u169c"
        + "\u16a0\u16f0"
        + "\u1780\u17dc"
        + "\u17e0\u17e9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18a9"
        + "\u1e00\u1e9b"
        + "\u1ea0\u1ef9"
        + "\u1f00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2046"
        + "\u2048\u204d"
        + "\u206a\u2070"
        + "\u2074\u208e"
        + "\u20a0\u20af"
        + "\u20d0\u20e3"
        + "\u2100\u213a"
        + "\u2153\u2183"
        + "\u2190\u21f3"
        + "\u2200\u22f1"
        + "\u2300\u237b"
        + "\u237d\u239a"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u24ea"
        + "\u2500\u2595"
        + "\u25a0\u25f7"
        + "\u2600\u2613"
        + "\u2619\u2671"
        + "\u2701\u2704"
        + "\u2706\u2709"
        + "\u270c\u2727"
        + "\u2729\u274b"
        + "\u274d\u274d"
        + "\u274f\u2752"
        + "\u2756\u2756"
        + "\u2758\u275e"
        + "\u2761\u2767"
        + "\u2776\u2794"
        + "\u2798\u27af"
        + "\u27b1\u27be"
        + "\u2800\u28ff"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303a"
        + "\u303e\u303f"
        + "\u3041\u3094"
        + "\u3099\u309e"
        + "\u30a1\u30fe"
        + "\u3105\u312c"
        + "\u3131\u318e"
        + "\u3190\u31b7"
        + "\u3200\u321c"
        + "\u3220\u3243"
        + "\u3260\u327b"
        + "\u327f\u32b0"
        + "\u32c0\u32cb"
        + "\u32d0\u32fe"
        + "\u3300\u3376"
        + "\u337b\u33dd"
        + "\u33e0\u33fe"
        + "\u3400\u4db5"
        + "\u4e00\u9fa5"
        + "\ua000\ua48c"
        + "\ua490\ua4a1"
        + "\ua4a4\ua4b3"
        + "\ua4b5\ua4c0"
        + "\ua4c2\ua4c4"
        + "\ua4c6\ua4c6"
        + "\uac00\ud7a3"
        + "\ue000\ufa2d"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdd0\ufdfb"
        + "\ufe20\ufe23"
        + "\ufe30\ufe44"
        + "\ufe49\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe72"
        + "\ufe74\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uff5e"
        + "\uff61\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\uffff"
        + "\ud800\udf00\ud800\udf1e"
        + "\ud800\udf20\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud801\udc00\ud801\udc25"
        + "\ud801\udc28\ud801\udc4d"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd2a\ud834\udddd"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc0"
        + "\ud835\udcc2\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea3"
        + "\ud835\udea8\ud835\udfc9"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83f\udffe\ud869\uded6"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v32}
    "\000\u0220"
        + "\u0222\u0233"
        + "\u0250\u02ad"
        + "\u02b0\u02ee"
        + "\u0300\u034f"
        + "\u0360\u036f"
        + "\u0374\u0375"
        + "\u037a\u037a"
        + "\u037e\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03ce"
        + "\u03d0\u03f6"
        + "\u0400\u0486"
        + "\u0488\u04ce"
        + "\u04d0\u04f5"
        + "\u04f8\u04f9"
        + "\u0500\u050f"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u0591\u05a1"
        + "\u05a3\u05b9"
        + "\u05bb\u05c4"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u060c\u060c"
        + "\u061b\u061b"
        + "\u061f\u061f"
        + "\u0621\u063a"
        + "\u0640\u0655"
        + "\u0660\u06ed"
        + "\u06f0\u06fe"
        + "\u0700\u070d"
        + "\u070f\u072c"
        + "\u0730\u074a"
        + "\u0780\u07b1"
        + "\u0901\u0903"
        + "\u0905\u0939"
        + "\u093c\u094d"
        + "\u0950\u0954"
        + "\u0958\u0970"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09bc"
        + "\u09be\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09cd"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fa"
        + "\u0a02\u0a02"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a74"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8b"
        + "\u0a8d\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae0"
        + "\u0ae6\u0aef"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b36\u0b39"
        + "\u0b3c\u0b43"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b66\u0b70"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb5"
        + "\u0bb7\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0be7\u0bf2"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3e\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c60\u0c61"
        + "\u0c66\u0c6f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbe\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0ce6\u0cef"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d28"
        + "\u0d2a\u0d39"
        + "\u0d3e\u0d43"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d60\u0d61"
        + "\u0d66\u0d6f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edd"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6a"
        + "\u0f71\u0f8b"
        + "\u0f90\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fcf\u0fcf"
        + "\u1000\u1021"
        + "\u1023\u1027"
        + "\u1029\u102a"
        + "\u102c\u1032"
        + "\u1036\u1039"
        + "\u1040\u1059"
        + "\u10a0\u10c5"
        + "\u10d0\u10f8"
        + "\u10fb\u10fb"
        + "\u1100\u1159"
        + "\u115f\u11a2"
        + "\u11a8\u11f9"
        + "\u1200\u1206"
        + "\u1208\u1246"
        + "\u1248\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1286"
        + "\u1288\u1288"
        + "\u128a\u128d"
        + "\u1290\u12ae"
        + "\u12b0\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12ce"
        + "\u12d0\u12d6"
        + "\u12d8\u12ee"
        + "\u12f0\u130e"
        + "\u1310\u1310"
        + "\u1312\u1315"
        + "\u1318\u131e"
        + "\u1320\u1346"
        + "\u1348\u135a"
        + "\u1361\u137c"
        + "\u13a0\u13f4"
        + "\u1401\u1676"
        + "\u1680\u169c"
        + "\u16a0\u16f0"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dc"
        + "\u17e0\u17e9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18a9"
        + "\u1e00\u1e9b"
        + "\u1ea0\u1ef9"
        + "\u1f00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2052"
        + "\u2057\u2057"
        + "\u205f\u2063"
        + "\u206a\u2071"
        + "\u2074\u208e"
        + "\u20a0\u20b1"
        + "\u20d0\u20ea"
        + "\u2100\u213a"
        + "\u213d\u214b"
        + "\u2153\u2183"
        + "\u2190\u23ce"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u24fe"
        + "\u2500\u2613"
        + "\u2616\u2617"
        + "\u2619\u267d"
        + "\u2680\u2689"
        + "\u2701\u2704"
        + "\u2706\u2709"
        + "\u270c\u2727"
        + "\u2729\u274b"
        + "\u274d\u274d"
        + "\u274f\u2752"
        + "\u2756\u2756"
        + "\u2758\u275e"
        + "\u2761\u2794"
        + "\u2798\u27af"
        + "\u27b1\u27be"
        + "\u27d0\u27eb"
        + "\u27f0\u2aff"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312c"
        + "\u3131\u318e"
        + "\u3190\u31b7"
        + "\u31f0\u321c"
        + "\u3220\u3243"
        + "\u3251\u327b"
        + "\u327f\u32cb"
        + "\u32d0\u32fe"
        + "\u3300\u3376"
        + "\u337b\u33dd"
        + "\u33e0\u33fe"
        + "\u3400\u4db5"
        + "\u4e00\u9fa5"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\uac00\ud7a3"
        + "\ue000\ufa2d"
        + "\ufa30\ufa6a"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdd0\ufdfc"
        + "\ufe00\ufe0f"
        + "\ufe20\ufe23"
        + "\ufe30\ufe46"
        + "\ufe49\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\uffff"
        + "\ud800\udf00\ud800\udf1e"
        + "\ud800\udf20\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud801\udc00\ud801\udc25"
        + "\ud801\udc28\ud801\udc4d"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd2a\ud834\udddd"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc0"
        + "\ud835\udcc2\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea3"
        + "\ud835\udea8\ud835\udfc9"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83f\udffe\ud869\uded6"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v40}
    "\000\u0236"
        + "\u0250\u0357"
        + "\u035d\u036f"
        + "\u0374\u0375"
        + "\u037a\u037a"
        + "\u037e\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03ce"
        + "\u03d0\u03fb"
        + "\u0400\u0486"
        + "\u0488\u04ce"
        + "\u04d0\u04f5"
        + "\u04f8\u04f9"
        + "\u0500\u050f"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u0591\u05a1"
        + "\u05a3\u05b9"
        + "\u05bb\u05c4"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0600\u0603"
        + "\u060c\u0615"
        + "\u061b\u061b"
        + "\u061f\u061f"
        + "\u0621\u063a"
        + "\u0640\u0658"
        + "\u0660\u070d"
        + "\u070f\u074a"
        + "\u074d\u074f"
        + "\u0780\u07b1"
        + "\u0901\u0939"
        + "\u093c\u094d"
        + "\u0950\u0954"
        + "\u0958\u0970"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09cd"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fa"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a74"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0aef"
        + "\u0af1\u0af1"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b43"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b66\u0b71"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb5"
        + "\u0bb7\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0be7\u0bfa"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3e\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c60\u0c61"
        + "\u0c66\u0c6f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0ce6\u0cef"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d28"
        + "\u0d2a\u0d39"
        + "\u0d3e\u0d43"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d60\u0d61"
        + "\u0d66\u0d6f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edd"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6a"
        + "\u0f71\u0f8b"
        + "\u0f90\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fcf\u0fcf"
        + "\u1000\u1021"
        + "\u1023\u1027"
        + "\u1029\u102a"
        + "\u102c\u1032"
        + "\u1036\u1039"
        + "\u1040\u1059"
        + "\u10a0\u10c5"
        + "\u10d0\u10f8"
        + "\u10fb\u10fb"
        + "\u1100\u1159"
        + "\u115f\u11a2"
        + "\u11a8\u11f9"
        + "\u1200\u1206"
        + "\u1208\u1246"
        + "\u1248\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1286"
        + "\u1288\u1288"
        + "\u128a\u128d"
        + "\u1290\u12ae"
        + "\u12b0\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12ce"
        + "\u12d0\u12d6"
        + "\u12d8\u12ee"
        + "\u12f0\u130e"
        + "\u1310\u1310"
        + "\u1312\u1315"
        + "\u1318\u131e"
        + "\u1320\u1346"
        + "\u1348\u135a"
        + "\u1361\u137c"
        + "\u13a0\u13f4"
        + "\u1401\u1676"
        + "\u1680\u169c"
        + "\u16a0\u16f0"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dd"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18a9"
        + "\u1900\u191c"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u19e0\u19ff"
        + "\u1d00\u1d6b"
        + "\u1e00\u1e9b"
        + "\u1ea0\u1ef9"
        + "\u1f00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2054"
        + "\u2057\u2057"
        + "\u205f\u2063"
        + "\u206a\u2071"
        + "\u2074\u208e"
        + "\u20a0\u20b1"
        + "\u20d0\u20ea"
        + "\u2100\u213b"
        + "\u213d\u214b"
        + "\u2153\u2183"
        + "\u2190\u23d0"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u2617"
        + "\u2619\u267d"
        + "\u2680\u2691"
        + "\u26a0\u26a1"
        + "\u2701\u2704"
        + "\u2706\u2709"
        + "\u270c\u2727"
        + "\u2729\u274b"
        + "\u274d\u274d"
        + "\u274f\u2752"
        + "\u2756\u2756"
        + "\u2758\u275e"
        + "\u2761\u2794"
        + "\u2798\u27af"
        + "\u27b1\u27be"
        + "\u27d0\u27eb"
        + "\u27f0\u2b0d"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312c"
        + "\u3131\u318e"
        + "\u3190\u31b7"
        + "\u31f0\u321e"
        + "\u3220\u3243"
        + "\u3250\u327d"
        + "\u327f\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fa5"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\uac00\ud7a3"
        + "\ue000\ufa2d"
        + "\ufa30\ufa6a"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdd0\ufdfd"
        + "\ufe00\ufe0f"
        + "\ufe20\ufe23"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd3f"
        + "\ud800\udf00\ud800\udf1e"
        + "\ud800\udf20\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udf9f"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc3f"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd2a\ud834\udddd"
        + "\ud834\udf00\ud834\udf56"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea3"
        + "\ud835\udea8\ud835\udfc9"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83f\udffe\ud869\uded6"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v41}
    "\000\u0241"
        + "\u0250\u036f"
        + "\u0374\u0375"
        + "\u037a\u037a"
        + "\u037e\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03ce"
        + "\u03d0\u0486"
        + "\u0488\u04ce"
        + "\u04d0\u04f9"
        + "\u0500\u050f"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u0591\u05b9"
        + "\u05bb\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0600\u0603"
        + "\u060b\u0615"
        + "\u061b\u061b"
        + "\u061e\u061f"
        + "\u0621\u063a"
        + "\u0640\u065e"
        + "\u0660\u070d"
        + "\u070f\u074a"
        + "\u074d\u076d"
        + "\u0780\u07b1"
        + "\u0901\u0939"
        + "\u093c\u094d"
        + "\u0950\u0954"
        + "\u0958\u0970"
        + "\u097d\u097d"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fa"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a74"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0aef"
        + "\u0af1\u0af1"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b43"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b66\u0b71"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3e\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c60\u0c61"
        + "\u0c66\u0c6f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0ce6\u0cef"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d28"
        + "\u0d2a\u0d39"
        + "\u0d3e\u0d43"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d60\u0d61"
        + "\u0d66\u0d6f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edd"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6a"
        + "\u0f71\u0f8b"
        + "\u0f90\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fcf\u0fd1"
        + "\u1000\u1021"
        + "\u1023\u1027"
        + "\u1029\u102a"
        + "\u102c\u1032"
        + "\u1036\u1039"
        + "\u1040\u1059"
        + "\u10a0\u10c5"
        + "\u10d0\u10fc"
        + "\u1100\u1159"
        + "\u115f\u11a2"
        + "\u11a8\u11f9"
        + "\u1200\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135f\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1401\u1676"
        + "\u1680\u169c"
        + "\u16a0\u16f0"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dd"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18a9"
        + "\u1900\u191c"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u1980\u19a9"
        + "\u19b0\u19c9"
        + "\u19d0\u19d9"
        + "\u19de\u1a1b"
        + "\u1a1e\u1a1f"
        + "\u1d00\u1dc3"
        + "\u1e00\u1e9b"
        + "\u1ea0\u1ef9"
        + "\u1f00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2063"
        + "\u206a\u2071"
        + "\u2074\u208e"
        + "\u2090\u2094"
        + "\u20a0\u20b5"
        + "\u20d0\u20eb"
        + "\u2100\u214c"
        + "\u2153\u2183"
        + "\u2190\u23db"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u269c"
        + "\u26a0\u26b1"
        + "\u2701\u2704"
        + "\u2706\u2709"
        + "\u270c\u2727"
        + "\u2729\u274b"
        + "\u274d\u274d"
        + "\u274f\u2752"
        + "\u2756\u2756"
        + "\u2758\u275e"
        + "\u2761\u2794"
        + "\u2798\u27af"
        + "\u27b1\u27be"
        + "\u27c0\u27c6"
        + "\u27d0\u27eb"
        + "\u27f0\u2b13"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c80\u2cea"
        + "\u2cf9\u2d25"
        + "\u2d30\u2d65"
        + "\u2d6f\u2d6f"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2e00\u2e17"
        + "\u2e1c\u2e1d"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312c"
        + "\u3131\u318e"
        + "\u3190\u31b7"
        + "\u31c0\u31cf"
        + "\u31f0\u321e"
        + "\u3220\u3243"
        + "\u3250\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fbb"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\ua700\ua716"
        + "\ua800\ua82b"
        + "\uac00\ud7a3"
        + "\ue000\ufa2d"
        + "\ufa30\ufa6a"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdd0\ufdfd"
        + "\ufe00\ufe19"
        + "\ufe20\ufe23"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8a"
        + "\ud800\udf00\ud800\udf1e"
        + "\ud800\udf20\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc3f"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd2a\ud834\udddd"
        + "\ud834\ude00\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfc9"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83f\udffe\ud869\uded6"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v50}
    "\000\u036f"
        + "\u0374\u0375"
        + "\u037a\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03ce"
        + "\u03d0\u0486"
        + "\u0488\u0513"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u0591\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0600\u0603"
        + "\u060b\u0615"
        + "\u061b\u061b"
        + "\u061e\u061f"
        + "\u0621\u063a"
        + "\u0640\u065e"
        + "\u0660\u070d"
        + "\u070f\u074a"
        + "\u074d\u076d"
        + "\u0780\u07b1"
        + "\u07c0\u07fa"
        + "\u0901\u0939"
        + "\u093c\u094d"
        + "\u0950\u0954"
        + "\u0958\u0970"
        + "\u097b\u097f"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fa"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a74"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0aef"
        + "\u0af1\u0af1"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b43"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b66\u0b71"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3e\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c60\u0c61"
        + "\u0c66\u0c6f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d28"
        + "\u0d2a\u0d39"
        + "\u0d3e\u0d43"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d60\u0d61"
        + "\u0d66\u0d6f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edd"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6a"
        + "\u0f71\u0f8b"
        + "\u0f90\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fcf\u0fd1"
        + "\u1000\u1021"
        + "\u1023\u1027"
        + "\u1029\u102a"
        + "\u102c\u1032"
        + "\u1036\u1039"
        + "\u1040\u1059"
        + "\u10a0\u10c5"
        + "\u10d0\u10fc"
        + "\u1100\u1159"
        + "\u115f\u11a2"
        + "\u11a8\u11f9"
        + "\u1200\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135f\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1401\u1676"
        + "\u1680\u169c"
        + "\u16a0\u16f0"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dd"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18a9"
        + "\u1900\u191c"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u1980\u19a9"
        + "\u19b0\u19c9"
        + "\u19d0\u19d9"
        + "\u19de\u1a1b"
        + "\u1a1e\u1a1f"
        + "\u1b00\u1b4b"
        + "\u1b50\u1b7c"
        + "\u1d00\u1dca"
        + "\u1dfe\u1e9b"
        + "\u1ea0\u1ef9"
        + "\u1f00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2063"
        + "\u206a\u2071"
        + "\u2074\u208e"
        + "\u2090\u2094"
        + "\u20a0\u20b5"
        + "\u20d0\u20ef"
        + "\u2100\u214e"
        + "\u2153\u2184"
        + "\u2190\u23e7"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u269c"
        + "\u26a0\u26b2"
        + "\u2701\u2704"
        + "\u2706\u2709"
        + "\u270c\u2727"
        + "\u2729\u274b"
        + "\u274d\u274d"
        + "\u274f\u2752"
        + "\u2756\u2756"
        + "\u2758\u275e"
        + "\u2761\u2794"
        + "\u2798\u27af"
        + "\u27b1\u27be"
        + "\u27c0\u27ca"
        + "\u27d0\u27eb"
        + "\u27f0\u2b1a"
        + "\u2b20\u2b23"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2c6c"
        + "\u2c74\u2c77"
        + "\u2c80\u2cea"
        + "\u2cf9\u2d25"
        + "\u2d30\u2d65"
        + "\u2d6f\u2d6f"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2e00\u2e17"
        + "\u2e1c\u2e1d"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312c"
        + "\u3131\u318e"
        + "\u3190\u31b7"
        + "\u31c0\u31cf"
        + "\u31f0\u321e"
        + "\u3220\u3243"
        + "\u3250\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fbb"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\ua700\ua71a"
        + "\ua720\ua721"
        + "\ua800\ua82b"
        + "\ua840\ua877"
        + "\uac00\ud7a3"
        + "\ue000\ufa2d"
        + "\ufa30\ufa6a"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdd0\ufdfd"
        + "\ufe00\ufe19"
        + "\ufe20\ufe23"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8a"
        + "\ud800\udf00\ud800\udf1e"
        + "\ud800\udf20\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc3f"
        + "\ud802\udd00\ud802\udd19"
        + "\ud802\udd1f\ud802\udd1f"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58"
        + "\ud808\udc00\ud808\udf6e"
        + "\ud809\udc00\ud809\udc62"
        + "\ud809\udc70\ud809\udc73"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd2a\ud834\udddd"
        + "\ud834\ude00\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83f\udffe\ud869\uded6"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v51}
    "\000\u0377"
        + "\u037a\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u0523"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u0591\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0600\u0603"
        + "\u0606\u061b"
        + "\u061e\u061f"
        + "\u0621\u065e"
        + "\u0660\u070d"
        + "\u070f\u074a"
        + "\u074d\u07b1"
        + "\u07c0\u07fa"
        + "\u0901\u0939"
        + "\u093c\u094d"
        + "\u0950\u0954"
        + "\u0958\u0972"
        + "\u097b\u097f"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fa"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0aef"
        + "\u0af1\u0af1"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b71"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c78\u0c7f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d28"
        + "\u0d2a\u0d39"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d75"
        + "\u0d79\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edd"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f8b"
        + "\u0f90\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fce\u0fd4"
        + "\u1000\u1099"
        + "\u109e\u10c5"
        + "\u10d0\u10fc"
        + "\u1100\u1159"
        + "\u115f\u11a2"
        + "\u11a8\u11f9"
        + "\u1200\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135f\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1401\u1676"
        + "\u1680\u169c"
        + "\u16a0\u16f0"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dd"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u1900\u191c"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u1980\u19a9"
        + "\u19b0\u19c9"
        + "\u19d0\u19d9"
        + "\u19de\u1a1b"
        + "\u1a1e\u1a1f"
        + "\u1b00\u1b4b"
        + "\u1b50\u1b7c"
        + "\u1b80\u1baa"
        + "\u1bae\u1bb9"
        + "\u1c00\u1c37"
        + "\u1c3b\u1c49"
        + "\u1c4d\u1c7f"
        + "\u1d00\u1de6"
        + "\u1dfe\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2064"
        + "\u206a\u2071"
        + "\u2074\u208e"
        + "\u2090\u2094"
        + "\u20a0\u20b5"
        + "\u20d0\u20f0"
        + "\u2100\u214f"
        + "\u2153\u2188"
        + "\u2190\u23e7"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u269d"
        + "\u26a0\u26bc"
        + "\u26c0\u26c3"
        + "\u2701\u2704"
        + "\u2706\u2709"
        + "\u270c\u2727"
        + "\u2729\u274b"
        + "\u274d\u274d"
        + "\u274f\u2752"
        + "\u2756\u2756"
        + "\u2758\u275e"
        + "\u2761\u2794"
        + "\u2798\u27af"
        + "\u27b1\u27be"
        + "\u27c0\u27ca"
        + "\u27cc\u27cc"
        + "\u27d0\u2b4c"
        + "\u2b50\u2b54"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2c6f"
        + "\u2c71\u2c7d"
        + "\u2c80\u2cea"
        + "\u2cf9\u2d25"
        + "\u2d30\u2d65"
        + "\u2d6f\u2d6f"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2e30"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u3190\u31b7"
        + "\u31c0\u31e3"
        + "\u31f0\u321e"
        + "\u3220\u3243"
        + "\u3250\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fc3"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\ua500\ua62b"
        + "\ua640\ua65f"
        + "\ua662\ua673"
        + "\ua67c\ua697"
        + "\ua700\ua78c"
        + "\ua7fb\ua82b"
        + "\ua840\ua877"
        + "\ua880\ua8c4"
        + "\ua8ce\ua8d9"
        + "\ua900\ua953"
        + "\ua95f\ua95f"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa5c\uaa5f"
        + "\uac00\ud7a3"
        + "\ue000\ufa2d"
        + "\ufa30\ufa6a"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdd0\ufdfd"
        + "\ufe00\ufe19"
        + "\ufe20\ufe26"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8a"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\uddd0\ud800\uddfd"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udf00\ud800\udf1e"
        + "\ud800\udf20\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc3f"
        + "\ud802\udd00\ud802\udd19"
        + "\ud802\udd1f\ud802\udd39"
        + "\ud802\udd3f\ud802\udd3f"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58"
        + "\ud808\udc00\ud808\udf6e"
        + "\ud809\udc00\ud809\udc62"
        + "\ud809\udc70\ud809\udc73"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udddd"
        + "\ud834\ude00\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83f\udffe\ud869\uded6"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v52}
    "\000\u0377"
        + "\u037a\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u0525"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u0591\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0600\u0603"
        + "\u0606\u061b"
        + "\u061e\u061f"
        + "\u0621\u065e"
        + "\u0660\u070d"
        + "\u070f\u074a"
        + "\u074d\u07b1"
        + "\u07c0\u07fa"
        + "\u0800\u082d"
        + "\u0830\u083e"
        + "\u0900\u0939"
        + "\u093c\u094e"
        + "\u0950\u0955"
        + "\u0958\u0972"
        + "\u0979\u097f"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fb"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0aef"
        + "\u0af1\u0af1"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b71"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c78\u0c7f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d28"
        + "\u0d2a\u0d39"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d75"
        + "\u0d79\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edd"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f8b"
        + "\u0f90\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fce\u0fd8"
        + "\u1000\u10c5"
        + "\u10d0\u10fc"
        + "\u1100\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135f\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1400\u169c"
        + "\u16a0\u16f0"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dd"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191c"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19d0\u19da"
        + "\u19de\u1a1b"
        + "\u1a1e\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1a7f\u1a89"
        + "\u1a90\u1a99"
        + "\u1aa0\u1aad"
        + "\u1b00\u1b4b"
        + "\u1b50\u1b7c"
        + "\u1b80\u1baa"
        + "\u1bae\u1bb9"
        + "\u1c00\u1c37"
        + "\u1c3b\u1c49"
        + "\u1c4d\u1c7f"
        + "\u1cd0\u1cf2"
        + "\u1d00\u1de6"
        + "\u1dfd\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2064"
        + "\u206a\u2071"
        + "\u2074\u208e"
        + "\u2090\u2094"
        + "\u20a0\u20b8"
        + "\u20d0\u20f0"
        + "\u2100\u2189"
        + "\u2190\u23e8"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u26cd"
        + "\u26cf\u26e1"
        + "\u26e3\u26e3"
        + "\u26e8\u26ff"
        + "\u2701\u2704"
        + "\u2706\u2709"
        + "\u270c\u2727"
        + "\u2729\u274b"
        + "\u274d\u274d"
        + "\u274f\u2752"
        + "\u2756\u275e"
        + "\u2761\u2794"
        + "\u2798\u27af"
        + "\u27b1\u27be"
        + "\u27c0\u27ca"
        + "\u27cc\u27cc"
        + "\u27d0\u2b4c"
        + "\u2b50\u2b59"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2cf1"
        + "\u2cf9\u2d25"
        + "\u2d30\u2d65"
        + "\u2d6f\u2d6f"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2e31"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u3190\u31b7"
        + "\u31c0\u31e3"
        + "\u31f0\u321e"
        + "\u3220\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fcb"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\ua4d0\ua62b"
        + "\ua640\ua65f"
        + "\ua662\ua673"
        + "\ua67c\ua697"
        + "\ua6a0\ua6f7"
        + "\ua700\ua78c"
        + "\ua7fb\ua82b"
        + "\ua830\ua839"
        + "\ua840\ua877"
        + "\ua880\ua8c4"
        + "\ua8ce\ua8d9"
        + "\ua8e0\ua8fb"
        + "\ua900\ua953"
        + "\ua95f\ua97c"
        + "\ua980\ua9cd"
        + "\ua9cf\ua9d9"
        + "\ua9de\ua9df"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa5c\uaa7b"
        + "\uaa80\uaac2"
        + "\uaadb\uaadf"
        + "\uabc0\uabed"
        + "\uabf0\uabf9"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\ue000\ufa2d"
        + "\ufa30\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdd0\ufdfd"
        + "\ufe00\ufe19"
        + "\ufe20\ufe26"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8a"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\uddd0\ud800\uddfd"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udf00\ud800\udf1e"
        + "\ud800\udf20\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc57\ud802\udc5f"
        + "\ud802\udd00\ud802\udd1b"
        + "\ud802\udd1f\ud802\udd39"
        + "\ud802\udd3f\ud802\udd3f"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58"
        + "\ud802\ude60\ud802\ude7f"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf39\ud802\udf55"
        + "\ud802\udf58\ud802\udf72"
        + "\ud802\udf78\ud802\udf7f"
        + "\ud803\udc00\ud803\udc48"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud804\udc80\ud804\udcc1"
        + "\ud808\udc00\ud808\udf6e"
        + "\ud809\udc00\ud809\udc62"
        + "\ud809\udc70\ud809\udc73"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udddd"
        + "\ud834\ude00\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udd00\ud83c\udd0a"
        + "\ud83c\udd10\ud83c\udd2e"
        + "\ud83c\udd31\ud83c\udd31"
        + "\ud83c\udd3d\ud83c\udd3d"
        + "\ud83c\udd3f\ud83c\udd3f"
        + "\ud83c\udd42\ud83c\udd42"
        + "\ud83c\udd46\ud83c\udd46"
        + "\ud83c\udd4a\ud83c\udd4e"
        + "\ud83c\udd57\ud83c\udd57"
        + "\ud83c\udd5f\ud83c\udd5f"
        + "\ud83c\udd79\ud83c\udd79"
        + "\ud83c\udd7b\ud83c\udd7c"
        + "\ud83c\udd7f\ud83c\udd7f"
        + "\ud83c\udd8a\ud83c\udd8d"
        + "\ud83c\udd90\ud83c\udd90"
        + "\ud83c\ude00\ud83c\ude00"
        + "\ud83c\ude10\ud83c\ude31"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83f\udffe\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v60}
    "\000\u0377"
        + "\u037a\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u0527"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u0591\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0600\u0603"
        + "\u0606\u061b"
        + "\u061e\u070d"
        + "\u070f\u074a"
        + "\u074d\u07b1"
        + "\u07c0\u07fa"
        + "\u0800\u082d"
        + "\u0830\u083e"
        + "\u0840\u085b"
        + "\u085e\u085e"
        + "\u0900\u0977"
        + "\u0979\u097f"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fb"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0aef"
        + "\u0af1\u0af1"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b77"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c78\u0c7f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d75"
        + "\u0d79\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edd"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fce\u0fda"
        + "\u1000\u10c5"
        + "\u10d0\u10fc"
        + "\u1100\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135d\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1400\u169c"
        + "\u16a0\u16f0"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dd"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191c"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19d0\u19da"
        + "\u19de\u1a1b"
        + "\u1a1e\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1a7f\u1a89"
        + "\u1a90\u1a99"
        + "\u1aa0\u1aad"
        + "\u1b00\u1b4b"
        + "\u1b50\u1b7c"
        + "\u1b80\u1baa"
        + "\u1bae\u1bb9"
        + "\u1bc0\u1bf3"
        + "\u1bfc\u1c37"
        + "\u1c3b\u1c49"
        + "\u1c4d\u1c7f"
        + "\u1cd0\u1cf2"
        + "\u1d00\u1de6"
        + "\u1dfc\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2064"
        + "\u206a\u2071"
        + "\u2074\u208e"
        + "\u2090\u209c"
        + "\u20a0\u20b9"
        + "\u20d0\u20f0"
        + "\u2100\u2189"
        + "\u2190\u23f3"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u26ff"
        + "\u2701\u27ca"
        + "\u27cc\u27cc"
        + "\u27ce\u2b4c"
        + "\u2b50\u2b59"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2cf1"
        + "\u2cf9\u2d25"
        + "\u2d30\u2d65"
        + "\u2d6f\u2d70"
        + "\u2d7f\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2e31"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u3190\u31ba"
        + "\u31c0\u31e3"
        + "\u31f0\u321e"
        + "\u3220\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fcb"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\ua4d0\ua62b"
        + "\ua640\ua673"
        + "\ua67c\ua697"
        + "\ua6a0\ua6f7"
        + "\ua700\ua78e"
        + "\ua790\ua791"
        + "\ua7a0\ua7a9"
        + "\ua7fa\ua82b"
        + "\ua830\ua839"
        + "\ua840\ua877"
        + "\ua880\ua8c4"
        + "\ua8ce\ua8d9"
        + "\ua8e0\ua8fb"
        + "\ua900\ua953"
        + "\ua95f\ua97c"
        + "\ua980\ua9cd"
        + "\ua9cf\ua9d9"
        + "\ua9de\ua9df"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa5c\uaa7b"
        + "\uaa80\uaac2"
        + "\uaadb\uaadf"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uabc0\uabed"
        + "\uabf0\uabf9"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\ue000\ufa2d"
        + "\ufa30\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbc1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdd0\ufdfd"
        + "\ufe00\ufe19"
        + "\ufe20\ufe26"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8a"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\uddd0\ud800\uddfd"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udf00\ud800\udf1e"
        + "\ud800\udf20\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc57\ud802\udc5f"
        + "\ud802\udd00\ud802\udd1b"
        + "\ud802\udd1f\ud802\udd39"
        + "\ud802\udd3f\ud802\udd3f"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58"
        + "\ud802\ude60\ud802\ude7f"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf39\ud802\udf55"
        + "\ud802\udf58\ud802\udf72"
        + "\ud802\udf78\ud802\udf7f"
        + "\ud803\udc00\ud803\udc48"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud804\udc00\ud804\udc4d"
        + "\ud804\udc52\ud804\udc6f"
        + "\ud804\udc80\ud804\udcc1"
        + "\ud808\udc00\ud808\udf6e"
        + "\ud809\udc00\ud809\udc62"
        + "\ud809\udc70\ud809\udc73"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udddd"
        + "\ud834\ude00\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udca0\ud83c\udcae"
        + "\ud83c\udcb1\ud83c\udcbe"
        + "\ud83c\udcc1\ud83c\udccf"
        + "\ud83c\udcd1\ud83c\udcdf"
        + "\ud83c\udd00\ud83c\udd0a"
        + "\ud83c\udd10\ud83c\udd2e"
        + "\ud83c\udd30\ud83c\udd69"
        + "\ud83c\udd70\ud83c\udd9a"
        + "\ud83c\udde6\ud83c\ude02"
        + "\ud83c\ude10\ud83c\ude3a"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83c\ude50\ud83c\ude51"
        + "\ud83c\udf00\ud83c\udf20"
        + "\ud83c\udf30\ud83c\udf35"
        + "\ud83c\udf37\ud83c\udf7c"
        + "\ud83c\udf80\ud83c\udf93"
        + "\ud83c\udfa0\ud83c\udfc4"
        + "\ud83c\udfc6\ud83c\udfca"
        + "\ud83c\udfe0\ud83c\udff0"
        + "\ud83d\udc00\ud83d\udc3e"
        + "\ud83d\udc40\ud83d\udc40"
        + "\ud83d\udc42\ud83d\udcf7"
        + "\ud83d\udcf9\ud83d\udcfc"
        + "\ud83d\udd00\ud83d\udd3d"
        + "\ud83d\udd50\ud83d\udd67"
        + "\ud83d\uddfb\ud83d\uddff"
        + "\ud83d\ude01\ud83d\ude10"
        + "\ud83d\ude12\ud83d\ude14"
        + "\ud83d\ude16\ud83d\ude16"
        + "\ud83d\ude18\ud83d\ude18"
        + "\ud83d\ude1a\ud83d\ude1a"
        + "\ud83d\ude1c\ud83d\ude1e"
        + "\ud83d\ude20\ud83d\ude25"
        + "\ud83d\ude28\ud83d\ude2b"
        + "\ud83d\ude2d\ud83d\ude2d"
        + "\ud83d\ude30\ud83d\ude33"
        + "\ud83d\ude35\ud83d\ude40"
        + "\ud83d\ude45\ud83d\ude4f"
        + "\ud83d\ude80\ud83d\udec5"
        + "\ud83d\udf00\ud83d\udf73"
        + "\ud83f\udffe\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v61}
    "\000\u0377"
        + "\u037a\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u0527"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u058f\u058f"
        + "\u0591\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0600\u0604"
        + "\u0606\u061b"
        + "\u061e\u070d"
        + "\u070f\u074a"
        + "\u074d\u07b1"
        + "\u07c0\u07fa"
        + "\u0800\u082d"
        + "\u0830\u083e"
        + "\u0840\u085b"
        + "\u085e\u085e"
        + "\u08a0\u08a0"
        + "\u08a2\u08ac"
        + "\u08e4\u08fe"
        + "\u0900\u0977"
        + "\u0979\u097f"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fb"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0af1"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b77"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c78\u0c7f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d75"
        + "\u0d79\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edf"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fce\u0fda"
        + "\u1000\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135d\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1400\u169c"
        + "\u16a0\u16f0"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dd"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191c"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19d0\u19da"
        + "\u19de\u1a1b"
        + "\u1a1e\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1a7f\u1a89"
        + "\u1a90\u1a99"
        + "\u1aa0\u1aad"
        + "\u1b00\u1b4b"
        + "\u1b50\u1b7c"
        + "\u1b80\u1bf3"
        + "\u1bfc\u1c37"
        + "\u1c3b\u1c49"
        + "\u1c4d\u1c7f"
        + "\u1cc0\u1cc7"
        + "\u1cd0\u1cf6"
        + "\u1d00\u1de6"
        + "\u1dfc\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2064"
        + "\u206a\u2071"
        + "\u2074\u208e"
        + "\u2090\u209c"
        + "\u20a0\u20b9"
        + "\u20d0\u20f0"
        + "\u2100\u2189"
        + "\u2190\u23f3"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u26ff"
        + "\u2701\u2b4c"
        + "\u2b50\u2b59"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2cf3"
        + "\u2cf9\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d70"
        + "\u2d7f\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2e3b"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u3190\u31ba"
        + "\u31c0\u31e3"
        + "\u31f0\u321e"
        + "\u3220\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fcc"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\ua4d0\ua62b"
        + "\ua640\ua697"
        + "\ua69f\ua6f7"
        + "\ua700\ua78e"
        + "\ua790\ua793"
        + "\ua7a0\ua7aa"
        + "\ua7f8\ua82b"
        + "\ua830\ua839"
        + "\ua840\ua877"
        + "\ua880\ua8c4"
        + "\ua8ce\ua8d9"
        + "\ua8e0\ua8fb"
        + "\ua900\ua953"
        + "\ua95f\ua97c"
        + "\ua980\ua9cd"
        + "\ua9cf\ua9d9"
        + "\ua9de\ua9df"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa5c\uaa7b"
        + "\uaa80\uaac2"
        + "\uaadb\uaaf6"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uabc0\uabed"
        + "\uabf0\uabf9"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\ue000\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbc1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdd0\ufdfd"
        + "\ufe00\ufe19"
        + "\ufe20\ufe26"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8a"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\uddd0\ud800\uddfd"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udf00\ud800\udf1e"
        + "\ud800\udf20\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc57\ud802\udc5f"
        + "\ud802\udd00\ud802\udd1b"
        + "\ud802\udd1f\ud802\udd39"
        + "\ud802\udd3f\ud802\udd3f"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58"
        + "\ud802\ude60\ud802\ude7f"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf39\ud802\udf55"
        + "\ud802\udf58\ud802\udf72"
        + "\ud802\udf78\ud802\udf7f"
        + "\ud803\udc00\ud803\udc48"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud804\udc00\ud804\udc4d"
        + "\ud804\udc52\ud804\udc6f"
        + "\ud804\udc80\ud804\udcc1"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd00\ud804\udd34"
        + "\ud804\udd36\ud804\udd43"
        + "\ud804\udd80\ud804\uddc8"
        + "\ud804\uddd0\ud804\uddd9"
        + "\ud805\ude80\ud805\udeb7"
        + "\ud805\udec0\ud805\udec9"
        + "\ud808\udc00\ud808\udf6e"
        + "\ud809\udc00\ud809\udc62"
        + "\ud809\udc70\ud809\udc73"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf7e"
        + "\ud81b\udf8f\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udddd"
        + "\ud834\ude00\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83b\udef0\ud83b\udef1"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udca0\ud83c\udcae"
        + "\ud83c\udcb1\ud83c\udcbe"
        + "\ud83c\udcc1\ud83c\udccf"
        + "\ud83c\udcd1\ud83c\udcdf"
        + "\ud83c\udd00\ud83c\udd0a"
        + "\ud83c\udd10\ud83c\udd2e"
        + "\ud83c\udd30\ud83c\udd6b"
        + "\ud83c\udd70\ud83c\udd9a"
        + "\ud83c\udde6\ud83c\ude02"
        + "\ud83c\ude10\ud83c\ude3a"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83c\ude50\ud83c\ude51"
        + "\ud83c\udf00\ud83c\udf20"
        + "\ud83c\udf30\ud83c\udf35"
        + "\ud83c\udf37\ud83c\udf7c"
        + "\ud83c\udf80\ud83c\udf93"
        + "\ud83c\udfa0\ud83c\udfc4"
        + "\ud83c\udfc6\ud83c\udfca"
        + "\ud83c\udfe0\ud83c\udff0"
        + "\ud83d\udc00\ud83d\udc3e"
        + "\ud83d\udc40\ud83d\udc40"
        + "\ud83d\udc42\ud83d\udcf7"
        + "\ud83d\udcf9\ud83d\udcfc"
        + "\ud83d\udd00\ud83d\udd3d"
        + "\ud83d\udd40\ud83d\udd43"
        + "\ud83d\udd50\ud83d\udd67"
        + "\ud83d\uddfb\ud83d\ude40"
        + "\ud83d\ude45\ud83d\ude4f"
        + "\ud83d\ude80\ud83d\udec5"
        + "\ud83d\udf00\ud83d\udf73"
        + "\ud83f\udffe\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v62}
    "\000\u0377"
        + "\u037a\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u0527"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u058f\u058f"
        + "\u0591\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0600\u0604"
        + "\u0606\u061b"
        + "\u061e\u070d"
        + "\u070f\u074a"
        + "\u074d\u07b1"
        + "\u07c0\u07fa"
        + "\u0800\u082d"
        + "\u0830\u083e"
        + "\u0840\u085b"
        + "\u085e\u085e"
        + "\u08a0\u08a0"
        + "\u08a2\u08ac"
        + "\u08e4\u08fe"
        + "\u0900\u0977"
        + "\u0979\u097f"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fb"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0af1"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b77"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c78\u0c7f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d75"
        + "\u0d79\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edf"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fce\u0fda"
        + "\u1000\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135d\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1400\u169c"
        + "\u16a0\u16f0"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dd"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191c"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19d0\u19da"
        + "\u19de\u1a1b"
        + "\u1a1e\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1a7f\u1a89"
        + "\u1a90\u1a99"
        + "\u1aa0\u1aad"
        + "\u1b00\u1b4b"
        + "\u1b50\u1b7c"
        + "\u1b80\u1bf3"
        + "\u1bfc\u1c37"
        + "\u1c3b\u1c49"
        + "\u1c4d\u1c7f"
        + "\u1cc0\u1cc7"
        + "\u1cd0\u1cf6"
        + "\u1d00\u1de6"
        + "\u1dfc\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2064"
        + "\u206a\u2071"
        + "\u2074\u208e"
        + "\u2090\u209c"
        + "\u20a0\u20ba"
        + "\u20d0\u20f0"
        + "\u2100\u2189"
        + "\u2190\u23f3"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u26ff"
        + "\u2701\u2b4c"
        + "\u2b50\u2b59"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2cf3"
        + "\u2cf9\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d70"
        + "\u2d7f\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2e3b"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u3190\u31ba"
        + "\u31c0\u31e3"
        + "\u31f0\u321e"
        + "\u3220\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fcc"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\ua4d0\ua62b"
        + "\ua640\ua697"
        + "\ua69f\ua6f7"
        + "\ua700\ua78e"
        + "\ua790\ua793"
        + "\ua7a0\ua7aa"
        + "\ua7f8\ua82b"
        + "\ua830\ua839"
        + "\ua840\ua877"
        + "\ua880\ua8c4"
        + "\ua8ce\ua8d9"
        + "\ua8e0\ua8fb"
        + "\ua900\ua953"
        + "\ua95f\ua97c"
        + "\ua980\ua9cd"
        + "\ua9cf\ua9d9"
        + "\ua9de\ua9df"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa5c\uaa7b"
        + "\uaa80\uaac2"
        + "\uaadb\uaaf6"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uabc0\uabed"
        + "\uabf0\uabf9"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\ue000\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbc1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdd0\ufdfd"
        + "\ufe00\ufe19"
        + "\ufe20\ufe26"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8a"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\uddd0\ud800\uddfd"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udf00\ud800\udf1e"
        + "\ud800\udf20\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc57\ud802\udc5f"
        + "\ud802\udd00\ud802\udd1b"
        + "\ud802\udd1f\ud802\udd39"
        + "\ud802\udd3f\ud802\udd3f"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58"
        + "\ud802\ude60\ud802\ude7f"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf39\ud802\udf55"
        + "\ud802\udf58\ud802\udf72"
        + "\ud802\udf78\ud802\udf7f"
        + "\ud803\udc00\ud803\udc48"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud804\udc00\ud804\udc4d"
        + "\ud804\udc52\ud804\udc6f"
        + "\ud804\udc80\ud804\udcc1"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd00\ud804\udd34"
        + "\ud804\udd36\ud804\udd43"
        + "\ud804\udd80\ud804\uddc8"
        + "\ud804\uddd0\ud804\uddd9"
        + "\ud805\ude80\ud805\udeb7"
        + "\ud805\udec0\ud805\udec9"
        + "\ud808\udc00\ud808\udf6e"
        + "\ud809\udc00\ud809\udc62"
        + "\ud809\udc70\ud809\udc73"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf7e"
        + "\ud81b\udf8f\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udddd"
        + "\ud834\ude00\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83b\udef0\ud83b\udef1"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udca0\ud83c\udcae"
        + "\ud83c\udcb1\ud83c\udcbe"
        + "\ud83c\udcc1\ud83c\udccf"
        + "\ud83c\udcd1\ud83c\udcdf"
        + "\ud83c\udd00\ud83c\udd0a"
        + "\ud83c\udd10\ud83c\udd2e"
        + "\ud83c\udd30\ud83c\udd6b"
        + "\ud83c\udd70\ud83c\udd9a"
        + "\ud83c\udde6\ud83c\ude02"
        + "\ud83c\ude10\ud83c\ude3a"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83c\ude50\ud83c\ude51"
        + "\ud83c\udf00\ud83c\udf20"
        + "\ud83c\udf30\ud83c\udf35"
        + "\ud83c\udf37\ud83c\udf7c"
        + "\ud83c\udf80\ud83c\udf93"
        + "\ud83c\udfa0\ud83c\udfc4"
        + "\ud83c\udfc6\ud83c\udfca"
        + "\ud83c\udfe0\ud83c\udff0"
        + "\ud83d\udc00\ud83d\udc3e"
        + "\ud83d\udc40\ud83d\udc40"
        + "\ud83d\udc42\ud83d\udcf7"
        + "\ud83d\udcf9\ud83d\udcfc"
        + "\ud83d\udd00\ud83d\udd3d"
        + "\ud83d\udd40\ud83d\udd43"
        + "\ud83d\udd50\ud83d\udd67"
        + "\ud83d\uddfb\ud83d\ude40"
        + "\ud83d\ude45\ud83d\ude4f"
        + "\ud83d\ude80\ud83d\udec5"
        + "\ud83d\udf00\ud83d\udf73"
        + "\ud83f\udffe\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v63}
    "\000\u0377"
        + "\u037a\u037e"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u0527"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u058f\u058f"
        + "\u0591\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0600\u0604"
        + "\u0606\u061c"
        + "\u061e\u070d"
        + "\u070f\u074a"
        + "\u074d\u07b1"
        + "\u07c0\u07fa"
        + "\u0800\u082d"
        + "\u0830\u083e"
        + "\u0840\u085b"
        + "\u085e\u085e"
        + "\u08a0\u08a0"
        + "\u08a2\u08ac"
        + "\u08e4\u08fe"
        + "\u0900\u0977"
        + "\u0979\u097f"
        + "\u0981\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fb"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0af1"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b77"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c33"
        + "\u0c35\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c78\u0c7f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d75"
        + "\u0d79\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edf"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fce\u0fda"
        + "\u1000\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135d\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1400\u169c"
        + "\u16a0\u16f0"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dd"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191c"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19d0\u19da"
        + "\u19de\u1a1b"
        + "\u1a1e\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1a7f\u1a89"
        + "\u1a90\u1a99"
        + "\u1aa0\u1aad"
        + "\u1b00\u1b4b"
        + "\u1b50\u1b7c"
        + "\u1b80\u1bf3"
        + "\u1bfc\u1c37"
        + "\u1c3b\u1c49"
        + "\u1c4d\u1c7f"
        + "\u1cc0\u1cc7"
        + "\u1cd0\u1cf6"
        + "\u1d00\u1de6"
        + "\u1dfc\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2064"
        + "\u2066\u2071"
        + "\u2074\u208e"
        + "\u2090\u209c"
        + "\u20a0\u20ba"
        + "\u20d0\u20f0"
        + "\u2100\u2189"
        + "\u2190\u23f3"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u26ff"
        + "\u2701\u2b4c"
        + "\u2b50\u2b59"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2cf3"
        + "\u2cf9\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d70"
        + "\u2d7f\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2e3b"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u3190\u31ba"
        + "\u31c0\u31e3"
        + "\u31f0\u321e"
        + "\u3220\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fcc"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\ua4d0\ua62b"
        + "\ua640\ua697"
        + "\ua69f\ua6f7"
        + "\ua700\ua78e"
        + "\ua790\ua793"
        + "\ua7a0\ua7aa"
        + "\ua7f8\ua82b"
        + "\ua830\ua839"
        + "\ua840\ua877"
        + "\ua880\ua8c4"
        + "\ua8ce\ua8d9"
        + "\ua8e0\ua8fb"
        + "\ua900\ua953"
        + "\ua95f\ua97c"
        + "\ua980\ua9cd"
        + "\ua9cf\ua9d9"
        + "\ua9de\ua9df"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa5c\uaa7b"
        + "\uaa80\uaac2"
        + "\uaadb\uaaf6"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uabc0\uabed"
        + "\uabf0\uabf9"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\ue000\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbc1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdd0\ufdfd"
        + "\ufe00\ufe19"
        + "\ufe20\ufe26"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8a"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\uddd0\ud800\uddfd"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udf00\ud800\udf1e"
        + "\ud800\udf20\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc57\ud802\udc5f"
        + "\ud802\udd00\ud802\udd1b"
        + "\ud802\udd1f\ud802\udd39"
        + "\ud802\udd3f\ud802\udd3f"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58"
        + "\ud802\ude60\ud802\ude7f"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf39\ud802\udf55"
        + "\ud802\udf58\ud802\udf72"
        + "\ud802\udf78\ud802\udf7f"
        + "\ud803\udc00\ud803\udc48"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud804\udc00\ud804\udc4d"
        + "\ud804\udc52\ud804\udc6f"
        + "\ud804\udc80\ud804\udcc1"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd00\ud804\udd34"
        + "\ud804\udd36\ud804\udd43"
        + "\ud804\udd80\ud804\uddc8"
        + "\ud804\uddd0\ud804\uddd9"
        + "\ud805\ude80\ud805\udeb7"
        + "\ud805\udec0\ud805\udec9"
        + "\ud808\udc00\ud808\udf6e"
        + "\ud809\udc00\ud809\udc62"
        + "\ud809\udc70\ud809\udc73"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf7e"
        + "\ud81b\udf8f\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udddd"
        + "\ud834\ude00\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83b\udef0\ud83b\udef1"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udca0\ud83c\udcae"
        + "\ud83c\udcb1\ud83c\udcbe"
        + "\ud83c\udcc1\ud83c\udccf"
        + "\ud83c\udcd1\ud83c\udcdf"
        + "\ud83c\udd00\ud83c\udd0a"
        + "\ud83c\udd10\ud83c\udd2e"
        + "\ud83c\udd30\ud83c\udd6b"
        + "\ud83c\udd70\ud83c\udd9a"
        + "\ud83c\udde6\ud83c\ude02"
        + "\ud83c\ude10\ud83c\ude3a"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83c\ude50\ud83c\ude51"
        + "\ud83c\udf00\ud83c\udf20"
        + "\ud83c\udf30\ud83c\udf35"
        + "\ud83c\udf37\ud83c\udf7c"
        + "\ud83c\udf80\ud83c\udf93"
        + "\ud83c\udfa0\ud83c\udfc4"
        + "\ud83c\udfc6\ud83c\udfca"
        + "\ud83c\udfe0\ud83c\udff0"
        + "\ud83d\udc00\ud83d\udc3e"
        + "\ud83d\udc40\ud83d\udc40"
        + "\ud83d\udc42\ud83d\udcf7"
        + "\ud83d\udcf9\ud83d\udcfc"
        + "\ud83d\udd00\ud83d\udd3d"
        + "\ud83d\udd40\ud83d\udd43"
        + "\ud83d\udd50\ud83d\udd67"
        + "\ud83d\uddfb\ud83d\ude40"
        + "\ud83d\ude45\ud83d\ude4f"
        + "\ud83d\ude80\ud83d\udec5"
        + "\ud83d\udf00\ud83d\udf73"
        + "\ud83f\udffe\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {age=v70}
    "\000\u0377"
        + "\u037a\u037f"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u052f"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u058d\u058f"
        + "\u0591\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0600\u061c"
        + "\u061e\u070d"
        + "\u070f\u074a"
        + "\u074d\u07b1"
        + "\u07c0\u07fa"
        + "\u0800\u082d"
        + "\u0830\u083e"
        + "\u0840\u085b"
        + "\u085e\u085e"
        + "\u08a0\u08b2"
        + "\u08e4\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fb"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0af1"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b77"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa"
        + "\u0c00\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c78\u0c7f"
        + "\u0c81\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d01\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d75"
        + "\u0d79\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0de6\u0def"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edf"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fce\u0fda"
        + "\u1000\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135d\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1400\u169c"
        + "\u16a0\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dd"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19d0\u19da"
        + "\u19de\u1a1b"
        + "\u1a1e\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1a7f\u1a89"
        + "\u1a90\u1a99"
        + "\u1aa0\u1aad"
        + "\u1ab0\u1abe"
        + "\u1b00\u1b4b"
        + "\u1b50\u1b7c"
        + "\u1b80\u1bf3"
        + "\u1bfc\u1c37"
        + "\u1c3b\u1c49"
        + "\u1c4d\u1c7f"
        + "\u1cc0\u1cc7"
        + "\u1cd0\u1cf6"
        + "\u1cf8\u1cf9"
        + "\u1d00\u1df5"
        + "\u1dfc\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2064"
        + "\u2066\u2071"
        + "\u2074\u208e"
        + "\u2090\u209c"
        + "\u20a0\u20bd"
        + "\u20d0\u20f0"
        + "\u2100\u2189"
        + "\u2190\u23fa"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u2b73"
        + "\u2b76\u2b95"
        + "\u2b98\u2bb9"
        + "\u2bbd\u2bc8"
        + "\u2bca\u2bd1"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2cf3"
        + "\u2cf9\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d70"
        + "\u2d7f\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2e42"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u3190\u31ba"
        + "\u31c0\u31e3"
        + "\u31f0\u321e"
        + "\u3220\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fcc"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\ua4d0\ua62b"
        + "\ua640\ua69d"
        + "\ua69f\ua6f7"
        + "\ua700\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua82b"
        + "\ua830\ua839"
        + "\ua840\ua877"
        + "\ua880\ua8c4"
        + "\ua8ce\ua8d9"
        + "\ua8e0\ua8fb"
        + "\ua900\ua953"
        + "\ua95f\ua97c"
        + "\ua980\ua9cd"
        + "\ua9cf\ua9d9"
        + "\ua9de\ua9fe"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa5c\uaac2"
        + "\uaadb\uaaf6"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uab30\uab5f"
        + "\uab64\uab65"
        + "\uabc0\uabed"
        + "\uabf0\uabf9"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\ue000\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbc1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdd0\ufdfd"
        + "\ufe00\ufe19"
        + "\ufe20\ufe2d"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8c"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\udda0\ud800\udda0"
        + "\ud800\uddd0\ud800\uddfd"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udee0\ud800\udefb"
        + "\ud800\udf00\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf50\ud800\udf7a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\udd6f\ud801\udd6f"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc57\ud802\udc9e"
        + "\ud802\udca7\ud802\udcaf"
        + "\ud802\udd00\ud802\udd1b"
        + "\ud802\udd1f\ud802\udd39"
        + "\ud802\udd3f\ud802\udd3f"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58"
        + "\ud802\ude60\ud802\ude9f"
        + "\ud802\udec0\ud802\udee6"
        + "\ud802\udeeb\ud802\udef6"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf39\ud802\udf55"
        + "\ud802\udf58\ud802\udf72"
        + "\ud802\udf78\ud802\udf91"
        + "\ud802\udf99\ud802\udf9c"
        + "\ud802\udfa9\ud802\udfaf"
        + "\ud803\udc00\ud803\udc48"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud804\udc00\ud804\udc4d"
        + "\ud804\udc52\ud804\udc6f"
        + "\ud804\udc7f\ud804\udcc1"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd00\ud804\udd34"
        + "\ud804\udd36\ud804\udd43"
        + "\ud804\udd50\ud804\udd76"
        + "\ud804\udd80\ud804\uddc8"
        + "\ud804\uddcd\ud804\uddcd"
        + "\ud804\uddd0\ud804\uddda"
        + "\ud804\udde1\ud804\uddf4"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude3d"
        + "\ud804\udeb0\ud804\udeea"
        + "\ud804\udef0\ud804\udef9"
        + "\ud804\udf01\ud804\udf03"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3c\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf5d\ud804\udf63"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udc80\ud805\udcc7"
        + "\ud805\udcd0\ud805\udcd9"
        + "\ud805\udd80\ud805\uddb5"
        + "\ud805\uddb8\ud805\uddc9"
        + "\ud805\ude00\ud805\ude44"
        + "\ud805\ude50\ud805\ude59"
        + "\ud805\ude80\ud805\udeb7"
        + "\ud805\udec0\ud805\udec9"
        + "\ud806\udca0\ud806\udcf2"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud809\udc00\ud809\udc6e"
        + "\ud809\udc70\ud809\udc74"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\ude60\ud81a\ude69"
        + "\ud81a\ude6e\ud81a\ude6f"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udef0\ud81a\udef5"
        + "\ud81a\udf00\ud81a\udf45"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud81a\udf5b\ud81a\udf61"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf7e"
        + "\ud81b\udf8f\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud82f\udc9c\ud82f\udca3"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udddd"
        + "\ud834\ude00\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83a\udcc7\ud83a\udcd6"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83b\udef0\ud83b\udef1"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udca0\ud83c\udcae"
        + "\ud83c\udcb1\ud83c\udcbf"
        + "\ud83c\udcc1\ud83c\udccf"
        + "\ud83c\udcd1\ud83c\udcf5"
        + "\ud83c\udd00\ud83c\udd0c"
        + "\ud83c\udd10\ud83c\udd2e"
        + "\ud83c\udd30\ud83c\udd6b"
        + "\ud83c\udd70\ud83c\udd9a"
        + "\ud83c\udde6\ud83c\ude02"
        + "\ud83c\ude10\ud83c\ude3a"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83c\ude50\ud83c\ude51"
        + "\ud83c\udf00\ud83c\udf2c"
        + "\ud83c\udf30\ud83c\udf7d"
        + "\ud83c\udf80\ud83c\udfce"
        + "\ud83c\udfd4\ud83c\udff7"
        + "\ud83d\udc00\ud83d\udcfe"
        + "\ud83d\udd00\ud83d\udd4a"
        + "\ud83d\udd50\ud83d\udd79"
        + "\ud83d\udd7b\ud83d\udda3"
        + "\ud83d\udda5\ud83d\ude42"
        + "\ud83d\ude45\ud83d\udecf"
        + "\ud83d\udee0\ud83d\udeec"
        + "\ud83d\udef0\ud83d\udef3"
        + "\ud83d\udf00\ud83d\udf73"
        + "\ud83d\udf80\ud83d\udfd4"
        + "\ud83e\udc00\ud83e\udc0b"
        + "\ud83e\udc10\ud83e\udc47"
        + "\ud83e\udc50\ud83e\udc59"
        + "\ud83e\udc60\ud83e\udc87"
        + "\ud83e\udc90\ud83e\udcad"
        + "\ud83f\udffe\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef"
        + "\udb7f\udffe\udbff\udfff",
    // Unicode 7.0 property value: {alnum}
    "\u0030\u0039"
        + "\u0041\u005a"
        + "\u0061\u007a"
        + "\u00aa\u00aa"
        + "\u00b5\u00b5"
        + "\u00ba\u00ba"
        + "\u00c0\u00d6"
        + "\u00d8\u00f6"
        + "\u00f8\u02c1"
        + "\u02c6\u02d1"
        + "\u02e0\u02e4"
        + "\u02ec\u02ec"
        + "\u02ee\u02ee"
        + "\u0345\u0345"
        + "\u0370\u0374"
        + "\u0376\u0377"
        + "\u037a\u037d"
        + "\u037f\u037f"
        + "\u0386\u0386"
        + "\u0388\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03f5"
        + "\u03f7\u0481"
        + "\u048a\u052f"
        + "\u0531\u0556"
        + "\u0559\u0559"
        + "\u0561\u0587"
        + "\u05b0\u05bd"
        + "\u05bf\u05bf"
        + "\u05c1\u05c2"
        + "\u05c4\u05c5"
        + "\u05c7\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f2"
        + "\u0610\u061a"
        + "\u0620\u0657"
        + "\u0659\u0669"
        + "\u066e\u06d3"
        + "\u06d5\u06dc"
        + "\u06e1\u06e8"
        + "\u06ed\u06fc"
        + "\u06ff\u06ff"
        + "\u0710\u073f"
        + "\u074d\u07b1"
        + "\u07c0\u07ea"
        + "\u07f4\u07f5"
        + "\u07fa\u07fa"
        + "\u0800\u0817"
        + "\u081a\u082c"
        + "\u0840\u0858"
        + "\u08a0\u08b2"
        + "\u08e4\u08e9"
        + "\u08f0\u093b"
        + "\u093d\u094c"
        + "\u094e\u0950"
        + "\u0955\u0963"
        + "\u0966\u096f"
        + "\u0971\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bd\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09cc"
        + "\u09ce\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09f1"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4c"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abd\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acc"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0aef"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3d\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4c"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b6f"
        + "\u0b71\u0b71"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcc"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bef"
        + "\u0c00\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4c"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c81\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbd\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccc"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d01\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4c"
        + "\u0d4e\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d6f"
        + "\u0d7a\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0de6\u0def"
        + "\u0df2\u0df3"
        + "\u0e01\u0e3a"
        + "\u0e40\u0e46"
        + "\u0e4d\u0e4d"
        + "\u0e50\u0e59"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ecd\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edf"
        + "\u0f00\u0f00"
        + "\u0f20\u0f29"
        + "\u0f40\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f81"
        + "\u0f88\u0f97"
        + "\u0f99\u0fbc"
        + "\u1000\u1036"
        + "\u1038\u1038"
        + "\u103b\u1049"
        + "\u1050\u1062"
        + "\u1065\u1068"
        + "\u106e\u1086"
        + "\u108e\u108e"
        + "\u1090\u1099"
        + "\u109c\u109d"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u10fa"
        + "\u10fc\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135f\u135f"
        + "\u1380\u138f"
        + "\u13a0\u13f4"
        + "\u1401\u166c"
        + "\u166f\u167f"
        + "\u1681\u169a"
        + "\u16a0\u16ea"
        + "\u16ee\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1713"
        + "\u1720\u1733"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17b3"
        + "\u17b6\u17c8"
        + "\u17d7\u17d7"
        + "\u17dc\u17dc"
        + "\u17e0\u17e9"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1920\u192b"
        + "\u1930\u1938"
        + "\u1946\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19d0\u19d9"
        + "\u1a00\u1a1b"
        + "\u1a20\u1a5e"
        + "\u1a61\u1a74"
        + "\u1a80\u1a89"
        + "\u1a90\u1a99"
        + "\u1aa7\u1aa7"
        + "\u1b00\u1b33"
        + "\u1b35\u1b43"
        + "\u1b45\u1b4b"
        + "\u1b50\u1b59"
        + "\u1b80\u1ba9"
        + "\u1bac\u1be5"
        + "\u1be7\u1bf1"
        + "\u1c00\u1c35"
        + "\u1c40\u1c49"
        + "\u1c4d\u1c7d"
        + "\u1ce9\u1cec"
        + "\u1cee\u1cf3"
        + "\u1cf5\u1cf6"
        + "\u1d00\u1dbf"
        + "\u1de7\u1df4"
        + "\u1e00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fbc"
        + "\u1fbe\u1fbe"
        + "\u1fc2\u1fc4"
        + "\u1fc6\u1fcc"
        + "\u1fd0\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fe0\u1fec"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffc"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u2102\u2102"
        + "\u2107\u2107"
        + "\u210a\u2113"
        + "\u2115\u2115"
        + "\u2119\u211d"
        + "\u2124\u2124"
        + "\u2126\u2126"
        + "\u2128\u2128"
        + "\u212a\u212d"
        + "\u212f\u2139"
        + "\u213c\u213f"
        + "\u2145\u2149"
        + "\u214e\u214e"
        + "\u2160\u2188"
        + "\u24b6\u24e9"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2ce4"
        + "\u2ceb\u2cee"
        + "\u2cf2\u2cf3"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d6f"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2dff"
        + "\u2e2f\u2e2f"
        + "\u3005\u3007"
        + "\u3021\u3029"
        + "\u3031\u3035"
        + "\u3038\u303c"
        + "\u3041\u3096"
        + "\u309d\u309f"
        + "\u30a1\u30fa"
        + "\u30fc\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u31a0\u31ba"
        + "\u31f0\u31ff"
        + "\u3400\u4db5"
        + "\u4e00\u9fcc"
        + "\ua000\ua48c"
        + "\ua4d0\ua4fd"
        + "\ua500\ua60c"
        + "\ua610\ua62b"
        + "\ua640\ua66e"
        + "\ua674\ua67b"
        + "\ua67f\ua69d"
        + "\ua69f\ua6ef"
        + "\ua717\ua71f"
        + "\ua722\ua788"
        + "\ua78b\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua801"
        + "\ua803\ua805"
        + "\ua807\ua80a"
        + "\ua80c\ua827"
        + "\ua840\ua873"
        + "\ua880\ua8c3"
        + "\ua8d0\ua8d9"
        + "\ua8f2\ua8f7"
        + "\ua8fb\ua8fb"
        + "\ua900\ua92a"
        + "\ua930\ua952"
        + "\ua960\ua97c"
        + "\ua980\ua9b2"
        + "\ua9b4\ua9bf"
        + "\ua9cf\ua9d9"
        + "\ua9e0\ua9e4"
        + "\ua9e6\ua9fe"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa60\uaa76"
        + "\uaa7a\uaa7a"
        + "\uaa7e\uaabe"
        + "\uaac0\uaac0"
        + "\uaac2\uaac2"
        + "\uaadb\uaadd"
        + "\uaae0\uaaef"
        + "\uaaf2\uaaf5"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uab30\uab5a"
        + "\uab5c\uab5f"
        + "\uab64\uab65"
        + "\uabc0\uabea"
        + "\uabf0\uabf9"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\uf900\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb28"
        + "\ufb2a\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3d"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfb"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\uff10\uff19"
        + "\uff21\uff3a"
        + "\uff41\uff5a"
        + "\uff66\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd40\ud800\udd74"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udf00\ud800\udf1f"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf50\ud800\udf7a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udfa0\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfcf"
        + "\ud800\udfd1\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc60\ud802\udc76"
        + "\ud802\udc80\ud802\udc9e"
        + "\ud802\udd00\ud802\udd15"
        + "\ud802\udd20\ud802\udd39"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude60\ud802\ude7c"
        + "\ud802\ude80\ud802\ude9c"
        + "\ud802\udec0\ud802\udec7"
        + "\ud802\udec9\ud802\udee4"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf40\ud802\udf55"
        + "\ud802\udf60\ud802\udf72"
        + "\ud802\udf80\ud802\udf91"
        + "\ud803\udc00\ud803\udc48"
        + "\ud804\udc00\ud804\udc45"
        + "\ud804\udc66\ud804\udc6f"
        + "\ud804\udc82\ud804\udcb8"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd00\ud804\udd32"
        + "\ud804\udd36\ud804\udd3f"
        + "\ud804\udd50\ud804\udd72"
        + "\ud804\udd76\ud804\udd76"
        + "\ud804\udd80\ud804\uddbf"
        + "\ud804\uddc1\ud804\uddc4"
        + "\ud804\uddd0\ud804\uddda"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude34"
        + "\ud804\ude37\ud804\ude37"
        + "\ud804\udeb0\ud804\udee8"
        + "\ud804\udef0\ud804\udef9"
        + "\ud804\udf01\ud804\udf03"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3d\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4c"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf5d\ud804\udf63"
        + "\ud805\udc80\ud805\udcc1"
        + "\ud805\udcc4\ud805\udcc5"
        + "\ud805\udcc7\ud805\udcc7"
        + "\ud805\udcd0\ud805\udcd9"
        + "\ud805\udd80\ud805\uddb5"
        + "\ud805\uddb8\ud805\uddbe"
        + "\ud805\ude00\ud805\ude3e"
        + "\ud805\ude40\ud805\ude40"
        + "\ud805\ude44\ud805\ude44"
        + "\ud805\ude50\ud805\ude59"
        + "\ud805\ude80\ud805\udeb5"
        + "\ud805\udec0\ud805\udec9"
        + "\ud806\udca0\ud806\udce9"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud809\udc00\ud809\udc6e"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\ude60\ud81a\ude69"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udf00\ud81a\udf36"
        + "\ud81a\udf40\ud81a\udf43"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf7e"
        + "\ud81b\udf93\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud82f\udc9e\ud82f\udc9e"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udec0"
        + "\ud835\udec2\ud835\udeda"
        + "\ud835\udedc\ud835\udefa"
        + "\ud835\udefc\ud835\udf14"
        + "\ud835\udf16\ud835\udf34"
        + "\ud835\udf36\ud835\udf4e"
        + "\ud835\udf50\ud835\udf6e"
        + "\ud835\udf70\ud835\udf88"
        + "\ud835\udf8a\ud835\udfa8"
        + "\ud835\udfaa\ud835\udfc2"
        + "\ud835\udfc4\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83c\udd30\ud83c\udd49"
        + "\ud83c\udd50\ud83c\udd69"
        + "\ud83c\udd70\ud83c\udd89"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d",
    // Unicode 7.0 property value: {alphabetic}
    "\u0041\u005a"
        + "\u0061\u007a"
        + "\u00aa\u00aa"
        + "\u00b5\u00b5"
        + "\u00ba\u00ba"
        + "\u00c0\u00d6"
        + "\u00d8\u00f6"
        + "\u00f8\u02c1"
        + "\u02c6\u02d1"
        + "\u02e0\u02e4"
        + "\u02ec\u02ec"
        + "\u02ee\u02ee"
        + "\u0345\u0345"
        + "\u0370\u0374"
        + "\u0376\u0377"
        + "\u037a\u037d"
        + "\u037f\u037f"
        + "\u0386\u0386"
        + "\u0388\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03f5"
        + "\u03f7\u0481"
        + "\u048a\u052f"
        + "\u0531\u0556"
        + "\u0559\u0559"
        + "\u0561\u0587"
        + "\u05b0\u05bd"
        + "\u05bf\u05bf"
        + "\u05c1\u05c2"
        + "\u05c4\u05c5"
        + "\u05c7\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f2"
        + "\u0610\u061a"
        + "\u0620\u0657"
        + "\u0659\u065f"
        + "\u066e\u06d3"
        + "\u06d5\u06dc"
        + "\u06e1\u06e8"
        + "\u06ed\u06ef"
        + "\u06fa\u06fc"
        + "\u06ff\u06ff"
        + "\u0710\u073f"
        + "\u074d\u07b1"
        + "\u07ca\u07ea"
        + "\u07f4\u07f5"
        + "\u07fa\u07fa"
        + "\u0800\u0817"
        + "\u081a\u082c"
        + "\u0840\u0858"
        + "\u08a0\u08b2"
        + "\u08e4\u08e9"
        + "\u08f0\u093b"
        + "\u093d\u094c"
        + "\u094e\u0950"
        + "\u0955\u0963"
        + "\u0971\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bd\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09cc"
        + "\u09ce\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09f0\u09f1"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4c"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a70\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abd\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acc"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3d\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4c"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b71\u0b71"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcc"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0c00\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4c"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c81\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbd\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccc"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0cf1\u0cf2"
        + "\u0d01\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4c"
        + "\u0d4e\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d7a\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df3"
        + "\u0e01\u0e3a"
        + "\u0e40\u0e46"
        + "\u0e4d\u0e4d"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ecd\u0ecd"
        + "\u0edc\u0edf"
        + "\u0f00\u0f00"
        + "\u0f40\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f81"
        + "\u0f88\u0f97"
        + "\u0f99\u0fbc"
        + "\u1000\u1036"
        + "\u1038\u1038"
        + "\u103b\u103f"
        + "\u1050\u1062"
        + "\u1065\u1068"
        + "\u106e\u1086"
        + "\u108e\u108e"
        + "\u109c\u109d"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u10fa"
        + "\u10fc\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135f\u135f"
        + "\u1380\u138f"
        + "\u13a0\u13f4"
        + "\u1401\u166c"
        + "\u166f\u167f"
        + "\u1681\u169a"
        + "\u16a0\u16ea"
        + "\u16ee\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1713"
        + "\u1720\u1733"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17b3"
        + "\u17b6\u17c8"
        + "\u17d7\u17d7"
        + "\u17dc\u17dc"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1920\u192b"
        + "\u1930\u1938"
        + "\u1950\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u1a00\u1a1b"
        + "\u1a20\u1a5e"
        + "\u1a61\u1a74"
        + "\u1aa7\u1aa7"
        + "\u1b00\u1b33"
        + "\u1b35\u1b43"
        + "\u1b45\u1b4b"
        + "\u1b80\u1ba9"
        + "\u1bac\u1baf"
        + "\u1bba\u1be5"
        + "\u1be7\u1bf1"
        + "\u1c00\u1c35"
        + "\u1c4d\u1c4f"
        + "\u1c5a\u1c7d"
        + "\u1ce9\u1cec"
        + "\u1cee\u1cf3"
        + "\u1cf5\u1cf6"
        + "\u1d00\u1dbf"
        + "\u1de7\u1df4"
        + "\u1e00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fbc"
        + "\u1fbe\u1fbe"
        + "\u1fc2\u1fc4"
        + "\u1fc6\u1fcc"
        + "\u1fd0\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fe0\u1fec"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffc"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u2102\u2102"
        + "\u2107\u2107"
        + "\u210a\u2113"
        + "\u2115\u2115"
        + "\u2119\u211d"
        + "\u2124\u2124"
        + "\u2126\u2126"
        + "\u2128\u2128"
        + "\u212a\u212d"
        + "\u212f\u2139"
        + "\u213c\u213f"
        + "\u2145\u2149"
        + "\u214e\u214e"
        + "\u2160\u2188"
        + "\u24b6\u24e9"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2ce4"
        + "\u2ceb\u2cee"
        + "\u2cf2\u2cf3"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d6f"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2dff"
        + "\u2e2f\u2e2f"
        + "\u3005\u3007"
        + "\u3021\u3029"
        + "\u3031\u3035"
        + "\u3038\u303c"
        + "\u3041\u3096"
        + "\u309d\u309f"
        + "\u30a1\u30fa"
        + "\u30fc\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u31a0\u31ba"
        + "\u31f0\u31ff"
        + "\u3400\u4db5"
        + "\u4e00\u9fcc"
        + "\ua000\ua48c"
        + "\ua4d0\ua4fd"
        + "\ua500\ua60c"
        + "\ua610\ua61f"
        + "\ua62a\ua62b"
        + "\ua640\ua66e"
        + "\ua674\ua67b"
        + "\ua67f\ua69d"
        + "\ua69f\ua6ef"
        + "\ua717\ua71f"
        + "\ua722\ua788"
        + "\ua78b\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua801"
        + "\ua803\ua805"
        + "\ua807\ua80a"
        + "\ua80c\ua827"
        + "\ua840\ua873"
        + "\ua880\ua8c3"
        + "\ua8f2\ua8f7"
        + "\ua8fb\ua8fb"
        + "\ua90a\ua92a"
        + "\ua930\ua952"
        + "\ua960\ua97c"
        + "\ua980\ua9b2"
        + "\ua9b4\ua9bf"
        + "\ua9cf\ua9cf"
        + "\ua9e0\ua9e4"
        + "\ua9e6\ua9ef"
        + "\ua9fa\ua9fe"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa60\uaa76"
        + "\uaa7a\uaa7a"
        + "\uaa7e\uaabe"
        + "\uaac0\uaac0"
        + "\uaac2\uaac2"
        + "\uaadb\uaadd"
        + "\uaae0\uaaef"
        + "\uaaf2\uaaf5"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uab30\uab5a"
        + "\uab5c\uab5f"
        + "\uab64\uab65"
        + "\uabc0\uabea"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\uf900\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb28"
        + "\ufb2a\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3d"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfb"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\uff21\uff3a"
        + "\uff41\uff5a"
        + "\uff66\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd40\ud800\udd74"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udf00\ud800\udf1f"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf50\ud800\udf7a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udfa0\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfcf"
        + "\ud800\udfd1\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc60\ud802\udc76"
        + "\ud802\udc80\ud802\udc9e"
        + "\ud802\udd00\ud802\udd15"
        + "\ud802\udd20\ud802\udd39"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude60\ud802\ude7c"
        + "\ud802\ude80\ud802\ude9c"
        + "\ud802\udec0\ud802\udec7"
        + "\ud802\udec9\ud802\udee4"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf40\ud802\udf55"
        + "\ud802\udf60\ud802\udf72"
        + "\ud802\udf80\ud802\udf91"
        + "\ud803\udc00\ud803\udc48"
        + "\ud804\udc00\ud804\udc45"
        + "\ud804\udc82\ud804\udcb8"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udd00\ud804\udd32"
        + "\ud804\udd50\ud804\udd72"
        + "\ud804\udd76\ud804\udd76"
        + "\ud804\udd80\ud804\uddbf"
        + "\ud804\uddc1\ud804\uddc4"
        + "\ud804\uddda\ud804\uddda"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude34"
        + "\ud804\ude37\ud804\ude37"
        + "\ud804\udeb0\ud804\udee8"
        + "\ud804\udf01\ud804\udf03"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3d\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4c"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf5d\ud804\udf63"
        + "\ud805\udc80\ud805\udcc1"
        + "\ud805\udcc4\ud805\udcc5"
        + "\ud805\udcc7\ud805\udcc7"
        + "\ud805\udd80\ud805\uddb5"
        + "\ud805\uddb8\ud805\uddbe"
        + "\ud805\ude00\ud805\ude3e"
        + "\ud805\ude40\ud805\ude40"
        + "\ud805\ude44\ud805\ude44"
        + "\ud805\ude80\ud805\udeb5"
        + "\ud806\udca0\ud806\udcdf"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud809\udc00\ud809\udc6e"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udf00\ud81a\udf36"
        + "\ud81a\udf40\ud81a\udf43"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf7e"
        + "\ud81b\udf93\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud82f\udc9e\ud82f\udc9e"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udec0"
        + "\ud835\udec2\ud835\udeda"
        + "\ud835\udedc\ud835\udefa"
        + "\ud835\udefc\ud835\udf14"
        + "\ud835\udf16\ud835\udf34"
        + "\ud835\udf36\ud835\udf4e"
        + "\ud835\udf50\ud835\udf6e"
        + "\ud835\udf70\ud835\udf88"
        + "\ud835\udf8a\ud835\udfa8"
        + "\ud835\udfaa\ud835\udfc2"
        + "\ud835\udfc4\ud835\udfcb"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83c\udd30\ud83c\udd49"
        + "\ud83c\udd50\ud83c\udd69"
        + "\ud83c\udd70\ud83c\udd89"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d",
    // Unicode 7.0 property value: {arabic}
    "\u0600\u0604"
        + "\u0606\u060b"
        + "\u060d\u061a"
        + "\u061e\u061e"
        + "\u0620\u063f"
        + "\u0641\u064a"
        + "\u0656\u065f"
        + "\u066a\u066f"
        + "\u0671\u06dc"
        + "\u06de\u06ff"
        + "\u0750\u077f"
        + "\u08a0\u08b2"
        + "\u08e4\u08ff"
        + "\ufb50\ufbc1"
        + "\ufbd3\ufd3d"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfd"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83b\udef0\ud83b\udef1",
    // Unicode 7.0 property value: {armenian}
    "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u058a\u058a"
        + "\u058d\u058f"
        + "\ufb13\ufb17",
    // Unicode 7.0 property value: {asciihexdigit}
    "\u0030\u0039" + "\u0041\u0046" + "\u0061\u0066",
    // Unicode 7.0 property value: {assigned}
    "\000\u0377"
        + "\u037a\u037f"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u052f"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u058d\u058f"
        + "\u0591\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0600\u061c"
        + "\u061e\u070d"
        + "\u070f\u074a"
        + "\u074d\u07b1"
        + "\u07c0\u07fa"
        + "\u0800\u082d"
        + "\u0830\u083e"
        + "\u0840\u085b"
        + "\u085e\u085e"
        + "\u08a0\u08b2"
        + "\u08e4\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fb"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0af1"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b77"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa"
        + "\u0c00\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c78\u0c7f"
        + "\u0c81\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d01\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d75"
        + "\u0d79\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0de6\u0def"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edf"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fce\u0fda"
        + "\u1000\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135d\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1400\u169c"
        + "\u16a0\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dd"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19d0\u19da"
        + "\u19de\u1a1b"
        + "\u1a1e\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1a7f\u1a89"
        + "\u1a90\u1a99"
        + "\u1aa0\u1aad"
        + "\u1ab0\u1abe"
        + "\u1b00\u1b4b"
        + "\u1b50\u1b7c"
        + "\u1b80\u1bf3"
        + "\u1bfc\u1c37"
        + "\u1c3b\u1c49"
        + "\u1c4d\u1c7f"
        + "\u1cc0\u1cc7"
        + "\u1cd0\u1cf6"
        + "\u1cf8\u1cf9"
        + "\u1d00\u1df5"
        + "\u1dfc\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2064"
        + "\u2066\u2071"
        + "\u2074\u208e"
        + "\u2090\u209c"
        + "\u20a0\u20bd"
        + "\u20d0\u20f0"
        + "\u2100\u2189"
        + "\u2190\u23fa"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u2b73"
        + "\u2b76\u2b95"
        + "\u2b98\u2bb9"
        + "\u2bbd\u2bc8"
        + "\u2bca\u2bd1"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2cf3"
        + "\u2cf9\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d70"
        + "\u2d7f\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2e42"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u3190\u31ba"
        + "\u31c0\u31e3"
        + "\u31f0\u321e"
        + "\u3220\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fcc"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\ua4d0\ua62b"
        + "\ua640\ua69d"
        + "\ua69f\ua6f7"
        + "\ua700\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua82b"
        + "\ua830\ua839"
        + "\ua840\ua877"
        + "\ua880\ua8c4"
        + "\ua8ce\ua8d9"
        + "\ua8e0\ua8fb"
        + "\ua900\ua953"
        + "\ua95f\ua97c"
        + "\ua980\ua9cd"
        + "\ua9cf\ua9d9"
        + "\ua9de\ua9fe"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa5c\uaac2"
        + "\uaadb\uaaf6"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uab30\uab5f"
        + "\uab64\uab65"
        + "\uabc0\uabed"
        + "\uabf0\uabf9"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\ue000\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbc1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfd"
        + "\ufe00\ufe19"
        + "\ufe20\ufe2d"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ufffd"
        + "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8c"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\udda0\ud800\udda0"
        + "\ud800\uddd0\ud800\uddfd"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udee0\ud800\udefb"
        + "\ud800\udf00\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf50\ud800\udf7a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\udd6f\ud801\udd6f"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc57\ud802\udc9e"
        + "\ud802\udca7\ud802\udcaf"
        + "\ud802\udd00\ud802\udd1b"
        + "\ud802\udd1f\ud802\udd39"
        + "\ud802\udd3f\ud802\udd3f"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58"
        + "\ud802\ude60\ud802\ude9f"
        + "\ud802\udec0\ud802\udee6"
        + "\ud802\udeeb\ud802\udef6"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf39\ud802\udf55"
        + "\ud802\udf58\ud802\udf72"
        + "\ud802\udf78\ud802\udf91"
        + "\ud802\udf99\ud802\udf9c"
        + "\ud802\udfa9\ud802\udfaf"
        + "\ud803\udc00\ud803\udc48"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud804\udc00\ud804\udc4d"
        + "\ud804\udc52\ud804\udc6f"
        + "\ud804\udc7f\ud804\udcc1"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd00\ud804\udd34"
        + "\ud804\udd36\ud804\udd43"
        + "\ud804\udd50\ud804\udd76"
        + "\ud804\udd80\ud804\uddc8"
        + "\ud804\uddcd\ud804\uddcd"
        + "\ud804\uddd0\ud804\uddda"
        + "\ud804\udde1\ud804\uddf4"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude3d"
        + "\ud804\udeb0\ud804\udeea"
        + "\ud804\udef0\ud804\udef9"
        + "\ud804\udf01\ud804\udf03"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3c\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf5d\ud804\udf63"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udc80\ud805\udcc7"
        + "\ud805\udcd0\ud805\udcd9"
        + "\ud805\udd80\ud805\uddb5"
        + "\ud805\uddb8\ud805\uddc9"
        + "\ud805\ude00\ud805\ude44"
        + "\ud805\ude50\ud805\ude59"
        + "\ud805\ude80\ud805\udeb7"
        + "\ud805\udec0\ud805\udec9"
        + "\ud806\udca0\ud806\udcf2"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud809\udc00\ud809\udc6e"
        + "\ud809\udc70\ud809\udc74"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\ude60\ud81a\ude69"
        + "\ud81a\ude6e\ud81a\ude6f"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udef0\ud81a\udef5"
        + "\ud81a\udf00\ud81a\udf45"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud81a\udf5b\ud81a\udf61"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf7e"
        + "\ud81b\udf8f\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud82f\udc9c\ud82f\udca3"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udddd"
        + "\ud834\ude00\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83a\udcc7\ud83a\udcd6"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83b\udef0\ud83b\udef1"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udca0\ud83c\udcae"
        + "\ud83c\udcb1\ud83c\udcbf"
        + "\ud83c\udcc1\ud83c\udccf"
        + "\ud83c\udcd1\ud83c\udcf5"
        + "\ud83c\udd00\ud83c\udd0c"
        + "\ud83c\udd10\ud83c\udd2e"
        + "\ud83c\udd30\ud83c\udd6b"
        + "\ud83c\udd70\ud83c\udd9a"
        + "\ud83c\udde6\ud83c\ude02"
        + "\ud83c\ude10\ud83c\ude3a"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83c\ude50\ud83c\ude51"
        + "\ud83c\udf00\ud83c\udf2c"
        + "\ud83c\udf30\ud83c\udf7d"
        + "\ud83c\udf80\ud83c\udfce"
        + "\ud83c\udfd4\ud83c\udff7"
        + "\ud83d\udc00\ud83d\udcfe"
        + "\ud83d\udd00\ud83d\udd4a"
        + "\ud83d\udd50\ud83d\udd79"
        + "\ud83d\udd7b\ud83d\udda3"
        + "\ud83d\udda5\ud83d\ude42"
        + "\ud83d\ude45\ud83d\udecf"
        + "\ud83d\udee0\ud83d\udeec"
        + "\ud83d\udef0\ud83d\udef3"
        + "\ud83d\udf00\ud83d\udf73"
        + "\ud83d\udf80\ud83d\udfd4"
        + "\ud83e\udc00\ud83e\udc0b"
        + "\ud83e\udc10\ud83e\udc47"
        + "\ud83e\udc50\ud83e\udc59"
        + "\ud83e\udc60\ud83e\udc87"
        + "\ud83e\udc90\ud83e\udcad"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef"
        + "\udb80\udc00\udbbf\udffd"
        + "\udbc0\udc00\udbff\udffd",
    // Unicode 7.0 property value: {avestan}
    "\ud802\udf00\ud802\udf35" + "\ud802\udf39\ud802\udf3f",
    // Unicode 7.0 property value: {balinese}
    "\u1b00\u1b4b" + "\u1b50\u1b7c",
    // Unicode 7.0 property value: {bamum}
    "\ua6a0\ua6f7" + "\ud81a\udc00\ud81a\ude38",
    // Unicode 7.0 property value: {bassavah}
    "\ud81a\uded0\ud81a\udeed" + "\ud81a\udef0\ud81a\udef5",
    // Unicode 7.0 property value: {batak}
    "\u1bc0\u1bf3" + "\u1bfc\u1bff",
    // Unicode 7.0 property value: {bengali}
    "\u0980\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fb",
    // Unicode 7.0 property value: {bidicontrol}
    "\u061c\u061c" + "\u200e\u200f" + "\u202a\u202e" + "\u2066\u2069",
    // Unicode 7.0 property value: {blank}
    "\t\t"
        + "\u0020\u0020"
        + "\u00a0\u00a0"
        + "\u1680\u1680"
        + "\u2000\u200a"
        + "\u202f\u202f"
        + "\u205f\u205f"
        + "\u3000\u3000",
    // Unicode 7.0 property value: {block=aegeannumbers}
    "\ud800\udd00\ud800\udd3f",
    // Unicode 7.0 property value: {block=alchemicalsymbols}
    "\ud83d\udf00\ud83d\udf7f",
    // Unicode 7.0 property value: {block=alphabeticpresentationforms}
    "\ufb00\ufb4f",
    // Unicode 7.0 property value: {block=ancientgreekmusicalnotation}
    "\ud834\ude00\ud834\ude4f",
    // Unicode 7.0 property value: {block=ancientgreeknumbers}
    "\ud800\udd40\ud800\udd8f",
    // Unicode 7.0 property value: {block=ancientsymbols}
    "\ud800\udd90\ud800\uddcf",
    // Unicode 7.0 property value: {block=arabic}
    "\u0600\u06ff",
    // Unicode 7.0 property value: {block=arabicextendeda}
    "\u08a0\u08ff",
    // Unicode 7.0 property value: {block=arabicmathematicalalphabeticsymbols}
    "\ud83b\ude00\ud83b\udeff",
    // Unicode 7.0 property value: {block=arabicpresentationformsa}
    "\ufb50\ufdff",
    // Unicode 7.0 property value: {block=arabicpresentationformsb}
    "\ufe70\ufeff",
    // Unicode 7.0 property value: {block=arabicsupplement}
    "\u0750\u077f",
    // Unicode 7.0 property value: {block=armenian}
    "\u0530\u058f",
    // Unicode 7.0 property value: {block=arrows}
    "\u2190\u21ff",
    // Unicode 7.0 property value: {block=avestan}
    "\ud802\udf00\ud802\udf3f",
    // Unicode 7.0 property value: {block=balinese}
    "\u1b00\u1b7f",
    // Unicode 7.0 property value: {block=bamum}
    "\ua6a0\ua6ff",
    // Unicode 7.0 property value: {block=bamumsupplement}
    "\ud81a\udc00\ud81a\ude3f",
    // Unicode 7.0 property value: {block=basiclatin}
    "\000\u007f",
    // Unicode 7.0 property value: {block=bassavah}
    "\ud81a\uded0\ud81a\udeff",
    // Unicode 7.0 property value: {block=batak}
    "\u1bc0\u1bff",
    // Unicode 7.0 property value: {block=bengali}
    "\u0980\u09ff",
    // Unicode 7.0 property value: {block=blockelements}
    "\u2580\u259f",
    // Unicode 7.0 property value: {block=bopomofo}
    "\u3100\u312f",
    // Unicode 7.0 property value: {block=bopomofoextended}
    "\u31a0\u31bf",
    // Unicode 7.0 property value: {block=boxdrawing}
    "\u2500\u257f",
    // Unicode 7.0 property value: {block=brahmi}
    "\ud804\udc00\ud804\udc7f",
    // Unicode 7.0 property value: {block=braillepatterns}
    "\u2800\u28ff",
    // Unicode 7.0 property value: {block=buginese}
    "\u1a00\u1a1f",
    // Unicode 7.0 property value: {block=buhid}
    "\u1740\u175f",
    // Unicode 7.0 property value: {block=byzantinemusicalsymbols}
    "\ud834\udc00\ud834\udcff",
    // Unicode 7.0 property value: {block=carian}
    "\ud800\udea0\ud800\udedf",
    // Unicode 7.0 property value: {block=caucasianalbanian}
    "\ud801\udd30\ud801\udd6f",
    // Unicode 7.0 property value: {block=chakma}
    "\ud804\udd00\ud804\udd4f",
    // Unicode 7.0 property value: {block=cham}
    "\uaa00\uaa5f",
    // Unicode 7.0 property value: {block=cherokee}
    "\u13a0\u13ff",
    // Unicode 7.0 property value: {block=cjkcompatibility}
    "\u3300\u33ff",
    // Unicode 7.0 property value: {block=cjkcompatibilityforms}
    "\ufe30\ufe4f",
    // Unicode 7.0 property value: {block=cjkcompatibilityideographs}
    "\uf900\ufaff",
    // Unicode 7.0 property value: {block=cjkcompatibilityideographssupplement}
    "\ud87e\udc00\ud87e\ude1f",
    // Unicode 7.0 property value: {block=cjkradicalssupplement}
    "\u2e80\u2eff",
    // Unicode 7.0 property value: {block=cjkstrokes}
    "\u31c0\u31ef",
    // Unicode 7.0 property value: {block=cjksymbolsandpunctuation}
    "\u3000\u303f",
    // Unicode 7.0 property value: {block=cjkunifiedideographs}
    "\u4e00\u9fff",
    // Unicode 7.0 property value: {block=cjkunifiedideographsextensiona}
    "\u3400\u4dbf",
    // Unicode 7.0 property value: {block=cjkunifiedideographsextensionb}
    "\ud840\udc00\ud869\udedf",
    // Unicode 7.0 property value: {block=cjkunifiedideographsextensionc}
    "\ud869\udf00\ud86d\udf3f",
    // Unicode 7.0 property value: {block=cjkunifiedideographsextensiond}
    "\ud86d\udf40\ud86e\udc1f",
    // Unicode 7.0 property value: {block=combiningdiacriticalmarks}
    "\u0300\u036f",
    // Unicode 7.0 property value: {block=combiningdiacriticalmarksextended}
    "\u1ab0\u1aff",
    // Unicode 7.0 property value: {block=combiningdiacriticalmarksforsymbols}
    "\u20d0\u20ff",
    // Unicode 7.0 property value: {block=combiningdiacriticalmarkssupplement}
    "\u1dc0\u1dff",
    // Unicode 7.0 property value: {block=combininghalfmarks}
    "\ufe20\ufe2f",
    // Unicode 7.0 property value: {block=commonindicnumberforms}
    "\ua830\ua83f",
    // Unicode 7.0 property value: {block=controlpictures}
    "\u2400\u243f",
    // Unicode 7.0 property value: {block=coptic}
    "\u2c80\u2cff",
    // Unicode 7.0 property value: {block=copticepactnumbers}
    "\ud800\udee0\ud800\udeff",
    // Unicode 7.0 property value: {block=countingrodnumerals}
    "\ud834\udf60\ud834\udf7f",
    // Unicode 7.0 property value: {block=cuneiform}
    "\ud808\udc00\ud808\udfff",
    // Unicode 7.0 property value: {block=cuneiformnumbersandpunctuation}
    "\ud809\udc00\ud809\udc7f",
    // Unicode 7.0 property value: {block=currencysymbols}
    "\u20a0\u20cf",
    // Unicode 7.0 property value: {block=cypriotsyllabary}
    "\ud802\udc00\ud802\udc3f",
    // Unicode 7.0 property value: {block=cyrillic}
    "\u0400\u04ff",
    // Unicode 7.0 property value: {block=cyrillicextendeda}
    "\u2de0\u2dff",
    // Unicode 7.0 property value: {block=cyrillicextendedb}
    "\ua640\ua69f",
    // Unicode 7.0 property value: {block=cyrillicsupplement}
    "\u0500\u052f",
    // Unicode 7.0 property value: {block=deseret}
    "\ud801\udc00\ud801\udc4f",
    // Unicode 7.0 property value: {block=devanagari}
    "\u0900\u097f",
    // Unicode 7.0 property value: {block=devanagariextended}
    "\ua8e0\ua8ff",
    // Unicode 7.0 property value: {block=dingbats}
    "\u2700\u27bf",
    // Unicode 7.0 property value: {block=dominotiles}
    "\ud83c\udc30\ud83c\udc9f",
    // Unicode 7.0 property value: {block=duployan}
    "\ud82f\udc00\ud82f\udc9f",
    // Unicode 7.0 property value: {block=egyptianhieroglyphs}
    "\ud80c\udc00\ud80d\udc2f",
    // Unicode 7.0 property value: {block=elbasan}
    "\ud801\udd00\ud801\udd2f",
    // Unicode 7.0 property value: {block=emoticons}
    "\ud83d\ude00\ud83d\ude4f",
    // Unicode 7.0 property value: {block=enclosedalphanumerics}
    "\u2460\u24ff",
    // Unicode 7.0 property value: {block=enclosedalphanumericsupplement}
    "\ud83c\udd00\ud83c\uddff",
    // Unicode 7.0 property value: {block=enclosedcjklettersandmonths}
    "\u3200\u32ff",
    // Unicode 7.0 property value: {block=enclosedideographicsupplement}
    "\ud83c\ude00\ud83c\udeff",
    // Unicode 7.0 property value: {block=ethiopic}
    "\u1200\u137f",
    // Unicode 7.0 property value: {block=ethiopicextended}
    "\u2d80\u2ddf",
    // Unicode 7.0 property value: {block=ethiopicextendeda}
    "\uab00\uab2f",
    // Unicode 7.0 property value: {block=ethiopicsupplement}
    "\u1380\u139f",
    // Unicode 7.0 property value: {block=generalpunctuation}
    "\u2000\u206f",
    // Unicode 7.0 property value: {block=geometricshapes}
    "\u25a0\u25ff",
    // Unicode 7.0 property value: {block=geometricshapesextended}
    "\ud83d\udf80\ud83d\udfff",
    // Unicode 7.0 property value: {block=georgian}
    "\u10a0\u10ff",
    // Unicode 7.0 property value: {block=georgiansupplement}
    "\u2d00\u2d2f",
    // Unicode 7.0 property value: {block=glagolitic}
    "\u2c00\u2c5f",
    // Unicode 7.0 property value: {block=gothic}
    "\ud800\udf30\ud800\udf4f",
    // Unicode 7.0 property value: {block=grantha}
    "\ud804\udf00\ud804\udf7f",
    // Unicode 7.0 property value: {block=greekandcoptic}
    "\u0370\u03ff",
    // Unicode 7.0 property value: {block=greekextended}
    "\u1f00\u1fff",
    // Unicode 7.0 property value: {block=gujarati}
    "\u0a80\u0aff",
    // Unicode 7.0 property value: {block=gurmukhi}
    "\u0a00\u0a7f",
    // Unicode 7.0 property value: {block=halfwidthandfullwidthforms}
    "\uff00\uffef",
    // Unicode 7.0 property value: {block=hangulcompatibilityjamo}
    "\u3130\u318f",
    // Unicode 7.0 property value: {block=hanguljamo}
    "\u1100\u11ff",
    // Unicode 7.0 property value: {block=hanguljamoextendeda}
    "\ua960\ua97f",
    // Unicode 7.0 property value: {block=hanguljamoextendedb}
    "\ud7b0\ud7ff",
    // Unicode 7.0 property value: {block=hangulsyllables}
    "\uac00\ud7af",
    // Unicode 7.0 property value: {block=hanunoo}
    "\u1720\u173f",
    // Unicode 7.0 property value: {block=hebrew}
    "\u0590\u05ff",
    // Unicode 7.0 property value: {block=hiragana}
    "\u3040\u309f",
    // Unicode 7.0 property value: {block=ideographicdescriptioncharacters}
    "\u2ff0\u2fff",
    // Unicode 7.0 property value: {block=imperialaramaic}
    "\ud802\udc40\ud802\udc5f",
    // Unicode 7.0 property value: {block=inscriptionalpahlavi}
    "\ud802\udf60\ud802\udf7f",
    // Unicode 7.0 property value: {block=inscriptionalparthian}
    "\ud802\udf40\ud802\udf5f",
    // Unicode 7.0 property value: {block=ipaextensions}
    "\u0250\u02af",
    // Unicode 7.0 property value: {block=javanese}
    "\ua980\ua9df",
    // Unicode 7.0 property value: {block=kaithi}
    "\ud804\udc80\ud804\udccf",
    // Unicode 7.0 property value: {block=kanasupplement}
    "\ud82c\udc00\ud82c\udcff",
    // Unicode 7.0 property value: {block=kanbun}
    "\u3190\u319f",
    // Unicode 7.0 property value: {block=kangxiradicals}
    "\u2f00\u2fdf",
    // Unicode 7.0 property value: {block=kannada}
    "\u0c80\u0cff",
    // Unicode 7.0 property value: {block=katakana}
    "\u30a0\u30ff",
    // Unicode 7.0 property value: {block=katakanaphoneticextensions}
    "\u31f0\u31ff",
    // Unicode 7.0 property value: {block=kayahli}
    "\ua900\ua92f",
    // Unicode 7.0 property value: {block=kharoshthi}
    "\ud802\ude00\ud802\ude5f",
    // Unicode 7.0 property value: {block=khmer}
    "\u1780\u17ff",
    // Unicode 7.0 property value: {block=khmersymbols}
    "\u19e0\u19ff",
    // Unicode 7.0 property value: {block=khojki}
    "\ud804\ude00\ud804\ude4f",
    // Unicode 7.0 property value: {block=khudawadi}
    "\ud804\udeb0\ud804\udeff",
    // Unicode 7.0 property value: {block=lao}
    "\u0e80\u0eff",
    // Unicode 7.0 property value: {block=latin1supplement}
    "\u0080\u00ff",
    // Unicode 7.0 property value: {block=latinextendeda}
    "\u0100\u017f",
    // Unicode 7.0 property value: {block=latinextendedadditional}
    "\u1e00\u1eff",
    // Unicode 7.0 property value: {block=latinextendedb}
    "\u0180\u024f",
    // Unicode 7.0 property value: {block=latinextendedc}
    "\u2c60\u2c7f",
    // Unicode 7.0 property value: {block=latinextendedd}
    "\ua720\ua7ff",
    // Unicode 7.0 property value: {block=latinextendede}
    "\uab30\uab6f",
    // Unicode 7.0 property value: {block=lepcha}
    "\u1c00\u1c4f",
    // Unicode 7.0 property value: {block=letterlikesymbols}
    "\u2100\u214f",
    // Unicode 7.0 property value: {block=limbu}
    "\u1900\u194f",
    // Unicode 7.0 property value: {block=lineara}
    "\ud801\ude00\ud801\udf7f",
    // Unicode 7.0 property value: {block=linearbideograms}
    "\ud800\udc80\ud800\udcff",
    // Unicode 7.0 property value: {block=linearbsyllabary}
    "\ud800\udc00\ud800\udc7f",
    // Unicode 7.0 property value: {block=lisu}
    "\ua4d0\ua4ff",
    // Unicode 7.0 property value: {block=lycian}
    "\ud800\ude80\ud800\ude9f",
    // Unicode 7.0 property value: {block=lydian}
    "\ud802\udd20\ud802\udd3f",
    // Unicode 7.0 property value: {block=mahajani}
    "\ud804\udd50\ud804\udd7f",
    // Unicode 7.0 property value: {block=mahjongtiles}
    "\ud83c\udc00\ud83c\udc2f",
    // Unicode 7.0 property value: {block=malayalam}
    "\u0d00\u0d7f",
    // Unicode 7.0 property value: {block=mandaic}
    "\u0840\u085f",
    // Unicode 7.0 property value: {block=manichaean}
    "\ud802\udec0\ud802\udeff",
    // Unicode 7.0 property value: {block=mathematicalalphanumericsymbols}
    "\ud835\udc00\ud835\udfff",
    // Unicode 7.0 property value: {block=mathematicaloperators}
    "\u2200\u22ff",
    // Unicode 7.0 property value: {block=meeteimayek}
    "\uabc0\uabff",
    // Unicode 7.0 property value: {block=meeteimayekextensions}
    "\uaae0\uaaff",
    // Unicode 7.0 property value: {block=mendekikakui}
    "\ud83a\udc00\ud83a\udcdf",
    // Unicode 7.0 property value: {block=meroiticcursive}
    "\ud802\udda0\ud802\uddff",
    // Unicode 7.0 property value: {block=meroitichieroglyphs}
    "\ud802\udd80\ud802\udd9f",
    // Unicode 7.0 property value: {block=miao}
    "\ud81b\udf00\ud81b\udf9f",
    // Unicode 7.0 property value: {block=miscellaneousmathematicalsymbolsa}
    "\u27c0\u27ef",
    // Unicode 7.0 property value: {block=miscellaneousmathematicalsymbolsb}
    "\u2980\u29ff",
    // Unicode 7.0 property value: {block=miscellaneoussymbols}
    "\u2600\u26ff",
    // Unicode 7.0 property value: {block=miscellaneoussymbolsandarrows}
    "\u2b00\u2bff",
    // Unicode 7.0 property value: {block=miscellaneoussymbolsandpictographs}
    "\ud83c\udf00\ud83d\uddff",
    // Unicode 7.0 property value: {block=miscellaneoustechnical}
    "\u2300\u23ff",
    // Unicode 7.0 property value: {block=modi}
    "\ud805\ude00\ud805\ude5f",
    // Unicode 7.0 property value: {block=modifiertoneletters}
    "\ua700\ua71f",
    // Unicode 7.0 property value: {block=mongolian}
    "\u1800\u18af",
    // Unicode 7.0 property value: {block=mro}
    "\ud81a\ude40\ud81a\ude6f",
    // Unicode 7.0 property value: {block=musicalsymbols}
    "\ud834\udd00\ud834\uddff",
    // Unicode 7.0 property value: {block=myanmar}
    "\u1000\u109f",
    // Unicode 7.0 property value: {block=myanmarextendeda}
    "\uaa60\uaa7f",
    // Unicode 7.0 property value: {block=myanmarextendedb}
    "\ua9e0\ua9ff",
    // Unicode 7.0 property value: {block=nabataean}
    "\ud802\udc80\ud802\udcaf",
    // Unicode 7.0 property value: {block=newtailue}
    "\u1980\u19df",
    // Unicode 7.0 property value: {block=nko}
    "\u07c0\u07ff",
    // Unicode 7.0 property value: {block=noblock}
    "\u0860\u089f"
        + "\u1c80\u1cbf"
        + "\u2fe0\u2fef"
        + "\uab70\uabbf"
        + "\ud800\ude00\ud800\ude7f"
        + "\ud800\udfe0\ud800\udfff"
        + "\ud801\udcb0\ud801\udcff"
        + "\ud801\udd70\ud801\uddff"
        + "\ud801\udf80\ud801\udfff"
        + "\ud802\udcb0\ud802\udcff"
        + "\ud802\udd40\ud802\udd7f"
        + "\ud802\udea0\ud802\udebf"
        + "\ud802\udfb0\ud802\udfff"
        + "\ud803\udc50\ud803\ude5f"
        + "\ud803\ude80\ud803\udfff"
        + "\ud804\ude50\ud804\udeaf"
        + "\ud804\udf80\ud805\udc7f"
        + "\ud805\udce0\ud805\udd7f"
        + "\ud805\ude60\ud805\ude7f"
        + "\ud805\uded0\ud806\udc9f"
        + "\ud806\udd00\ud806\udebf"
        + "\ud806\udf00\ud807\udfff"
        + "\ud809\udc80\ud80b\udfff"
        + "\ud80d\udc30\ud819\udfff"
        + "\ud81a\ude70\ud81a\udecf"
        + "\ud81a\udf90\ud81b\udeff"
        + "\ud81b\udfa0\ud82b\udfff"
        + "\ud82c\udd00\ud82e\udfff"
        + "\ud82f\udcb0\ud833\udfff"
        + "\ud834\ude50\ud834\udeff"
        + "\ud834\udf80\ud834\udfff"
        + "\ud836\udc00\ud839\udfff"
        + "\ud83a\udce0\ud83b\uddff"
        + "\ud83b\udf00\ud83b\udfff"
        + "\ud83e\udd00\ud83f\udfff"
        + "\ud869\udee0\ud869\udeff"
        + "\ud86e\udc20\ud87d\udfff"
        + "\ud87e\ude20\udb3f\udfff"
        + "\udb40\udc80\udb40\udcff"
        + "\udb40\uddf0\udb7f\udfff",
    // Unicode 7.0 property value: {block=numberforms}
    "\u2150\u218f",
    // Unicode 7.0 property value: {block=ogham}
    "\u1680\u169f",
    // Unicode 7.0 property value: {block=olchiki}
    "\u1c50\u1c7f",
    // Unicode 7.0 property value: {block=olditalic}
    "\ud800\udf00\ud800\udf2f",
    // Unicode 7.0 property value: {block=oldnortharabian}
    "\ud802\ude80\ud802\ude9f",
    // Unicode 7.0 property value: {block=oldpermic}
    "\ud800\udf50\ud800\udf7f",
    // Unicode 7.0 property value: {block=oldpersian}
    "\ud800\udfa0\ud800\udfdf",
    // Unicode 7.0 property value: {block=oldsoutharabian}
    "\ud802\ude60\ud802\ude7f",
    // Unicode 7.0 property value: {block=oldturkic}
    "\ud803\udc00\ud803\udc4f",
    // Unicode 7.0 property value: {block=opticalcharacterrecognition}
    "\u2440\u245f",
    // Unicode 7.0 property value: {block=oriya}
    "\u0b00\u0b7f",
    // Unicode 7.0 property value: {block=ornamentaldingbats}
    "\ud83d\ude50\ud83d\ude7f",
    // Unicode 7.0 property value: {block=osmanya}
    "\ud801\udc80\ud801\udcaf",
    // Unicode 7.0 property value: {block=pahawhhmong}
    "\ud81a\udf00\ud81a\udf8f",
    // Unicode 7.0 property value: {block=palmyrene}
    "\ud802\udc60\ud802\udc7f",
    // Unicode 7.0 property value: {block=paucinhau}
    "\ud806\udec0\ud806\udeff",
    // Unicode 7.0 property value: {block=phagspa}
    "\ua840\ua87f",
    // Unicode 7.0 property value: {block=phaistosdisc}
    "\ud800\uddd0\ud800\uddff",
    // Unicode 7.0 property value: {block=phoenician}
    "\ud802\udd00\ud802\udd1f",
    // Unicode 7.0 property value: {block=phoneticextensions}
    "\u1d00\u1d7f",
    // Unicode 7.0 property value: {block=phoneticextensionssupplement}
    "\u1d80\u1dbf",
    // Unicode 7.0 property value: {block=playingcards}
    "\ud83c\udca0\ud83c\udcff",
    // Unicode 7.0 property value: {block=privateusearea}
    "\ue000\uf8ff",
    // Unicode 7.0 property value: {block=psalterpahlavi}
    "\ud802\udf80\ud802\udfaf",
    // Unicode 7.0 property value: {block=rejang}
    "\ua930\ua95f",
    // Unicode 7.0 property value: {block=ruminumeralsymbols}
    "\ud803\ude60\ud803\ude7f",
    // Unicode 7.0 property value: {block=runic}
    "\u16a0\u16ff",
    // Unicode 7.0 property value: {block=samaritan}
    "\u0800\u083f",
    // Unicode 7.0 property value: {block=saurashtra}
    "\ua880\ua8df",
    // Unicode 7.0 property value: {block=sharada}
    "\ud804\udd80\ud804\udddf",
    // Unicode 7.0 property value: {block=shavian}
    "\ud801\udc50\ud801\udc7f",
    // Unicode 7.0 property value: {block=shorthandformatcontrols}
    "\ud82f\udca0\ud82f\udcaf",
    // Unicode 7.0 property value: {block=siddham}
    "\ud805\udd80\ud805\uddff",
    // Unicode 7.0 property value: {block=sinhala}
    "\u0d80\u0dff",
    // Unicode 7.0 property value: {block=sinhalaarchaicnumbers}
    "\ud804\udde0\ud804\uddff",
    // Unicode 7.0 property value: {block=smallformvariants}
    "\ufe50\ufe6f",
    // Unicode 7.0 property value: {block=sorasompeng}
    "\ud804\udcd0\ud804\udcff",
    // Unicode 7.0 property value: {block=spacingmodifierletters}
    "\u02b0\u02ff",
    // Unicode 7.0 property value: {block=specials}
    "\ufff0\uffff",
    // Unicode 7.0 property value: {block=sundanese}
    "\u1b80\u1bbf",
    // Unicode 7.0 property value: {block=sundanesesupplement}
    "\u1cc0\u1ccf",
    // Unicode 7.0 property value: {block=superscriptsandsubscripts}
    "\u2070\u209f",
    // Unicode 7.0 property value: {block=supplementalarrowsa}
    "\u27f0\u27ff",
    // Unicode 7.0 property value: {block=supplementalarrowsb}
    "\u2900\u297f",
    // Unicode 7.0 property value: {block=supplementalarrowsc}
    "\ud83e\udc00\ud83e\udcff",
    // Unicode 7.0 property value: {block=supplementalmathematicaloperators}
    "\u2a00\u2aff",
    // Unicode 7.0 property value: {block=supplementalpunctuation}
    "\u2e00\u2e7f",
    // Unicode 7.0 property value: {block=supplementaryprivateuseareaa}
    "\udb80\udc00\udbbf\udfff",
    // Unicode 7.0 property value: {block=supplementaryprivateuseareab}
    "\udbc0\udc00\udbff\udfff",
    // Unicode 7.0 property value: {block=sylotinagri}
    "\ua800\ua82f",
    // Unicode 7.0 property value: {block=syriac}
    "\u0700\u074f",
    // Unicode 7.0 property value: {block=tagalog}
    "\u1700\u171f",
    // Unicode 7.0 property value: {block=tagbanwa}
    "\u1760\u177f",
    // Unicode 7.0 property value: {block=tags}
    "\udb40\udc00\udb40\udc7f",
    // Unicode 7.0 property value: {block=taile}
    "\u1950\u197f",
    // Unicode 7.0 property value: {block=taitham}
    "\u1a20\u1aaf",
    // Unicode 7.0 property value: {block=taiviet}
    "\uaa80\uaadf",
    // Unicode 7.0 property value: {block=taixuanjingsymbols}
    "\ud834\udf00\ud834\udf5f",
    // Unicode 7.0 property value: {block=takri}
    "\ud805\ude80\ud805\udecf",
    // Unicode 7.0 property value: {block=tamil}
    "\u0b80\u0bff",
    // Unicode 7.0 property value: {block=telugu}
    "\u0c00\u0c7f",
    // Unicode 7.0 property value: {block=thaana}
    "\u0780\u07bf",
    // Unicode 7.0 property value: {block=thai}
    "\u0e00\u0e7f",
    // Unicode 7.0 property value: {block=tibetan}
    "\u0f00\u0fff",
    // Unicode 7.0 property value: {block=tifinagh}
    "\u2d30\u2d7f",
    // Unicode 7.0 property value: {block=tirhuta}
    "\ud805\udc80\ud805\udcdf",
    // Unicode 7.0 property value: {block=transportandmapsymbols}
    "\ud83d\ude80\ud83d\udeff",
    // Unicode 7.0 property value: {block=ugaritic}
    "\ud800\udf80\ud800\udf9f",
    // Unicode 7.0 property value: {block=unifiedcanadianaboriginalsyllabics}
    "\u1400\u167f",
    // Unicode 7.0 property value: {block=unifiedcanadianaboriginalsyllabicsextended}
    "\u18b0\u18ff",
    // Unicode 7.0 property value: {block=vai}
    "\ua500\ua63f",
    // Unicode 7.0 property value: {block=variationselectors}
    "\ufe00\ufe0f",
    // Unicode 7.0 property value: {block=variationselectorssupplement}
    "\udb40\udd00\udb40\uddef",
    // Unicode 7.0 property value: {block=vedicextensions}
    "\u1cd0\u1cff",
    // Unicode 7.0 property value: {block=verticalforms}
    "\ufe10\ufe1f",
    // Unicode 7.0 property value: {block=warangciti}
    "\ud806\udca0\ud806\udcff",
    // Unicode 7.0 property value: {block=yijinghexagramsymbols}
    "\u4dc0\u4dff",
    // Unicode 7.0 property value: {block=yiradicals}
    "\ua490\ua4cf",
    // Unicode 7.0 property value: {block=yisyllables}
    "\ua000\ua48f",
    // Unicode 7.0 property value: {bopomofo}
    "\u02ea\u02eb" + "\u3105\u312d" + "\u31a0\u31ba",
    // Unicode 7.0 property value: {brahmi}
    "\ud804\udc00\ud804\udc4d" + "\ud804\udc52\ud804\udc6f" + "\ud804\udc7f\ud804\udc7f",
    // Unicode 7.0 property value: {braille}
    "\u2800\u28ff",
    // Unicode 7.0 property value: {buginese}
    "\u1a00\u1a1b" + "\u1a1e\u1a1f",
    // Unicode 7.0 property value: {buhid}
    "\u1740\u1753",
    // Unicode 7.0 property value: {canadianaboriginal}
    "\u1400\u167f" + "\u18b0\u18f5",
    // Unicode 7.0 property value: {carian}
    "\ud800\udea0\ud800\uded0",
    // Unicode 7.0 property value: {cased}
    "\u0041\u005a"
        + "\u0061\u007a"
        + "\u00aa\u00aa"
        + "\u00b5\u00b5"
        + "\u00ba\u00ba"
        + "\u00c0\u00d6"
        + "\u00d8\u00f6"
        + "\u00f8\u01ba"
        + "\u01bc\u01bf"
        + "\u01c4\u0293"
        + "\u0295\u02b8"
        + "\u02c0\u02c1"
        + "\u02e0\u02e4"
        + "\u0345\u0345"
        + "\u0370\u0373"
        + "\u0376\u0377"
        + "\u037a\u037d"
        + "\u037f\u037f"
        + "\u0386\u0386"
        + "\u0388\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03f5"
        + "\u03f7\u0481"
        + "\u048a\u052f"
        + "\u0531\u0556"
        + "\u0561\u0587"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u1d00\u1dbf"
        + "\u1e00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fbc"
        + "\u1fbe\u1fbe"
        + "\u1fc2\u1fc4"
        + "\u1fc6\u1fcc"
        + "\u1fd0\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fe0\u1fec"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffc"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u2102\u2102"
        + "\u2107\u2107"
        + "\u210a\u2113"
        + "\u2115\u2115"
        + "\u2119\u211d"
        + "\u2124\u2124"
        + "\u2126\u2126"
        + "\u2128\u2128"
        + "\u212a\u212d"
        + "\u212f\u2134"
        + "\u2139\u2139"
        + "\u213c\u213f"
        + "\u2145\u2149"
        + "\u214e\u214e"
        + "\u2160\u217f"
        + "\u2183\u2184"
        + "\u24b6\u24e9"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2ce4"
        + "\u2ceb\u2cee"
        + "\u2cf2\u2cf3"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\ua640\ua66d"
        + "\ua680\ua69d"
        + "\ua722\ua787"
        + "\ua78b\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f8\ua7fa"
        + "\uab30\uab5a"
        + "\uab5c\uab5f"
        + "\uab64\uab65"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\uff21\uff3a"
        + "\uff41\uff5a"
        + "\ud801\udc00\ud801\udc4f"
        + "\ud806\udca0\ud806\udcdf"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udec0"
        + "\ud835\udec2\ud835\udeda"
        + "\ud835\udedc\ud835\udefa"
        + "\ud835\udefc\ud835\udf14"
        + "\ud835\udf16\ud835\udf34"
        + "\ud835\udf36\ud835\udf4e"
        + "\ud835\udf50\ud835\udf6e"
        + "\ud835\udf70\ud835\udf88"
        + "\ud835\udf8a\ud835\udfa8"
        + "\ud835\udfaa\ud835\udfc2"
        + "\ud835\udfc4\ud835\udfcb"
        + "\ud83c\udd30\ud83c\udd49"
        + "\ud83c\udd50\ud83c\udd69"
        + "\ud83c\udd70\ud83c\udd89",
    // Unicode 7.0 property value: {caseignorable}
    "\u0027\u0027"
        + "\u002e\u002e"
        + "\u003a\u003a"
        + "\u005e\u005e"
        + "\u0060\u0060"
        + "\u00a8\u00a8"
        + "\u00ad\u00ad"
        + "\u00af\u00af"
        + "\u00b4\u00b4"
        + "\u00b7\u00b8"
        + "\u02b0\u036f"
        + "\u0374\u0375"
        + "\u037a\u037a"
        + "\u0384\u0385"
        + "\u0387\u0387"
        + "\u0483\u0489"
        + "\u0559\u0559"
        + "\u0591\u05bd"
        + "\u05bf\u05bf"
        + "\u05c1\u05c2"
        + "\u05c4\u05c5"
        + "\u05c7\u05c7"
        + "\u05f4\u05f4"
        + "\u0600\u0605"
        + "\u0610\u061a"
        + "\u061c\u061c"
        + "\u0640\u0640"
        + "\u064b\u065f"
        + "\u0670\u0670"
        + "\u06d6\u06dd"
        + "\u06df\u06e8"
        + "\u06ea\u06ed"
        + "\u070f\u070f"
        + "\u0711\u0711"
        + "\u0730\u074a"
        + "\u07a6\u07b0"
        + "\u07eb\u07f5"
        + "\u07fa\u07fa"
        + "\u0816\u082d"
        + "\u0859\u085b"
        + "\u08e4\u0902"
        + "\u093a\u093a"
        + "\u093c\u093c"
        + "\u0941\u0948"
        + "\u094d\u094d"
        + "\u0951\u0957"
        + "\u0962\u0963"
        + "\u0971\u0971"
        + "\u0981\u0981"
        + "\u09bc\u09bc"
        + "\u09c1\u09c4"
        + "\u09cd\u09cd"
        + "\u09e2\u09e3"
        + "\u0a01\u0a02"
        + "\u0a3c\u0a3c"
        + "\u0a41\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a70\u0a71"
        + "\u0a75\u0a75"
        + "\u0a81\u0a82"
        + "\u0abc\u0abc"
        + "\u0ac1\u0ac5"
        + "\u0ac7\u0ac8"
        + "\u0acd\u0acd"
        + "\u0ae2\u0ae3"
        + "\u0b01\u0b01"
        + "\u0b3c\u0b3c"
        + "\u0b3f\u0b3f"
        + "\u0b41\u0b44"
        + "\u0b4d\u0b4d"
        + "\u0b56\u0b56"
        + "\u0b62\u0b63"
        + "\u0b82\u0b82"
        + "\u0bc0\u0bc0"
        + "\u0bcd\u0bcd"
        + "\u0c00\u0c00"
        + "\u0c3e\u0c40"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c62\u0c63"
        + "\u0c81\u0c81"
        + "\u0cbc\u0cbc"
        + "\u0cbf\u0cbf"
        + "\u0cc6\u0cc6"
        + "\u0ccc\u0ccd"
        + "\u0ce2\u0ce3"
        + "\u0d01\u0d01"
        + "\u0d41\u0d44"
        + "\u0d4d\u0d4d"
        + "\u0d62\u0d63"
        + "\u0dca\u0dca"
        + "\u0dd2\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0e31\u0e31"
        + "\u0e34\u0e3a"
        + "\u0e46\u0e4e"
        + "\u0eb1\u0eb1"
        + "\u0eb4\u0eb9"
        + "\u0ebb\u0ebc"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0f18\u0f19"
        + "\u0f35\u0f35"
        + "\u0f37\u0f37"
        + "\u0f39\u0f39"
        + "\u0f71\u0f7e"
        + "\u0f80\u0f84"
        + "\u0f86\u0f87"
        + "\u0f8d\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fc6\u0fc6"
        + "\u102d\u1030"
        + "\u1032\u1037"
        + "\u1039\u103a"
        + "\u103d\u103e"
        + "\u1058\u1059"
        + "\u105e\u1060"
        + "\u1071\u1074"
        + "\u1082\u1082"
        + "\u1085\u1086"
        + "\u108d\u108d"
        + "\u109d\u109d"
        + "\u10fc\u10fc"
        + "\u135d\u135f"
        + "\u1712\u1714"
        + "\u1732\u1734"
        + "\u1752\u1753"
        + "\u1772\u1773"
        + "\u17b4\u17b5"
        + "\u17b7\u17bd"
        + "\u17c6\u17c6"
        + "\u17c9\u17d3"
        + "\u17d7\u17d7"
        + "\u17dd\u17dd"
        + "\u180b\u180e"
        + "\u1843\u1843"
        + "\u18a9\u18a9"
        + "\u1920\u1922"
        + "\u1927\u1928"
        + "\u1932\u1932"
        + "\u1939\u193b"
        + "\u1a17\u1a18"
        + "\u1a1b\u1a1b"
        + "\u1a56\u1a56"
        + "\u1a58\u1a5e"
        + "\u1a60\u1a60"
        + "\u1a62\u1a62"
        + "\u1a65\u1a6c"
        + "\u1a73\u1a7c"
        + "\u1a7f\u1a7f"
        + "\u1aa7\u1aa7"
        + "\u1ab0\u1abe"
        + "\u1b00\u1b03"
        + "\u1b34\u1b34"
        + "\u1b36\u1b3a"
        + "\u1b3c\u1b3c"
        + "\u1b42\u1b42"
        + "\u1b6b\u1b73"
        + "\u1b80\u1b81"
        + "\u1ba2\u1ba5"
        + "\u1ba8\u1ba9"
        + "\u1bab\u1bad"
        + "\u1be6\u1be6"
        + "\u1be8\u1be9"
        + "\u1bed\u1bed"
        + "\u1bef\u1bf1"
        + "\u1c2c\u1c33"
        + "\u1c36\u1c37"
        + "\u1c78\u1c7d"
        + "\u1cd0\u1cd2"
        + "\u1cd4\u1ce0"
        + "\u1ce2\u1ce8"
        + "\u1ced\u1ced"
        + "\u1cf4\u1cf4"
        + "\u1cf8\u1cf9"
        + "\u1d2c\u1d6a"
        + "\u1d78\u1d78"
        + "\u1d9b\u1df5"
        + "\u1dfc\u1dff"
        + "\u1fbd\u1fbd"
        + "\u1fbf\u1fc1"
        + "\u1fcd\u1fcf"
        + "\u1fdd\u1fdf"
        + "\u1fed\u1fef"
        + "\u1ffd\u1ffe"
        + "\u200b\u200f"
        + "\u2018\u2019"
        + "\u2024\u2024"
        + "\u2027\u2027"
        + "\u202a\u202e"
        + "\u2060\u2064"
        + "\u2066\u206f"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u20d0\u20f0"
        + "\u2c7c\u2c7d"
        + "\u2cef\u2cf1"
        + "\u2d6f\u2d6f"
        + "\u2d7f\u2d7f"
        + "\u2de0\u2dff"
        + "\u2e2f\u2e2f"
        + "\u3005\u3005"
        + "\u302a\u302d"
        + "\u3031\u3035"
        + "\u303b\u303b"
        + "\u3099\u309e"
        + "\u30fc\u30fe"
        + "\ua015\ua015"
        + "\ua4f8\ua4fd"
        + "\ua60c\ua60c"
        + "\ua66f\ua672"
        + "\ua674\ua67d"
        + "\ua67f\ua67f"
        + "\ua69c\ua69d"
        + "\ua69f\ua69f"
        + "\ua6f0\ua6f1"
        + "\ua700\ua721"
        + "\ua770\ua770"
        + "\ua788\ua78a"
        + "\ua7f8\ua7f9"
        + "\ua802\ua802"
        + "\ua806\ua806"
        + "\ua80b\ua80b"
        + "\ua825\ua826"
        + "\ua8c4\ua8c4"
        + "\ua8e0\ua8f1"
        + "\ua926\ua92d"
        + "\ua947\ua951"
        + "\ua980\ua982"
        + "\ua9b3\ua9b3"
        + "\ua9b6\ua9b9"
        + "\ua9bc\ua9bc"
        + "\ua9cf\ua9cf"
        + "\ua9e5\ua9e6"
        + "\uaa29\uaa2e"
        + "\uaa31\uaa32"
        + "\uaa35\uaa36"
        + "\uaa43\uaa43"
        + "\uaa4c\uaa4c"
        + "\uaa70\uaa70"
        + "\uaa7c\uaa7c"
        + "\uaab0\uaab0"
        + "\uaab2\uaab4"
        + "\uaab7\uaab8"
        + "\uaabe\uaabf"
        + "\uaac1\uaac1"
        + "\uaadd\uaadd"
        + "\uaaec\uaaed"
        + "\uaaf3\uaaf4"
        + "\uaaf6\uaaf6"
        + "\uab5b\uab5f"
        + "\uabe5\uabe5"
        + "\uabe8\uabe8"
        + "\uabed\uabed"
        + "\ufb1e\ufb1e"
        + "\ufbb2\ufbc1"
        + "\ufe00\ufe0f"
        + "\ufe13\ufe13"
        + "\ufe20\ufe2d"
        + "\ufe52\ufe52"
        + "\ufe55\ufe55"
        + "\ufeff\ufeff"
        + "\uff07\uff07"
        + "\uff0e\uff0e"
        + "\uff1a\uff1a"
        + "\uff3e\uff3e"
        + "\uff40\uff40"
        + "\uff70\uff70"
        + "\uff9e\uff9f"
        + "\uffe3\uffe3"
        + "\ufff9\ufffb"
        + "\ud800\uddfd\ud800\uddfd"
        + "\ud800\udee0\ud800\udee0"
        + "\ud800\udf76\ud800\udf7a"
        + "\ud802\ude01\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude0f"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude3f"
        + "\ud802\udee5\ud802\udee6"
        + "\ud804\udc01\ud804\udc01"
        + "\ud804\udc38\ud804\udc46"
        + "\ud804\udc7f\ud804\udc81"
        + "\ud804\udcb3\ud804\udcb6"
        + "\ud804\udcb9\ud804\udcba"
        + "\ud804\udcbd\ud804\udcbd"
        + "\ud804\udd00\ud804\udd02"
        + "\ud804\udd27\ud804\udd2b"
        + "\ud804\udd2d\ud804\udd34"
        + "\ud804\udd73\ud804\udd73"
        + "\ud804\udd80\ud804\udd81"
        + "\ud804\uddb6\ud804\uddbe"
        + "\ud804\ude2f\ud804\ude31"
        + "\ud804\ude34\ud804\ude34"
        + "\ud804\ude36\ud804\ude37"
        + "\ud804\udedf\ud804\udedf"
        + "\ud804\udee3\ud804\udeea"
        + "\ud804\udf01\ud804\udf01"
        + "\ud804\udf3c\ud804\udf3c"
        + "\ud804\udf40\ud804\udf40"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udcb3\ud805\udcb8"
        + "\ud805\udcba\ud805\udcba"
        + "\ud805\udcbf\ud805\udcc0"
        + "\ud805\udcc2\ud805\udcc3"
        + "\ud805\uddb2\ud805\uddb5"
        + "\ud805\uddbc\ud805\uddbd"
        + "\ud805\uddbf\ud805\uddc0"
        + "\ud805\ude33\ud805\ude3a"
        + "\ud805\ude3d\ud805\ude3d"
        + "\ud805\ude3f\ud805\ude40"
        + "\ud805\udeab\ud805\udeab"
        + "\ud805\udead\ud805\udead"
        + "\ud805\udeb0\ud805\udeb5"
        + "\ud805\udeb7\ud805\udeb7"
        + "\ud81a\udef0\ud81a\udef4"
        + "\ud81a\udf30\ud81a\udf36"
        + "\ud81a\udf40\ud81a\udf43"
        + "\ud81b\udf8f\ud81b\udf9f"
        + "\ud82f\udc9d\ud82f\udc9e"
        + "\ud82f\udca0\ud82f\udca3"
        + "\ud834\udd67\ud834\udd69"
        + "\ud834\udd73\ud834\udd82"
        + "\ud834\udd85\ud834\udd8b"
        + "\ud834\uddaa\ud834\uddad"
        + "\ud834\ude42\ud834\ude44"
        + "\ud83a\udcd0\ud83a\udcd6"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef",
    // Unicode 7.0 property value: {caucasianalbanian}
    "\ud801\udd30\ud801\udd63" + "\ud801\udd6f\ud801\udd6f",
    // Unicode 7.0 property value: {cc}
    "\000\u001f" + "\u007f\u009f",
    // Unicode 7.0 property value: {cf}
    "\u00ad\u00ad"
        + "\u0600\u0605"
        + "\u061c\u061c"
        + "\u06dd\u06dd"
        + "\u070f\u070f"
        + "\u180e\u180e"
        + "\u200b\u200f"
        + "\u202a\u202e"
        + "\u2060\u2064"
        + "\u2066\u206f"
        + "\ufeff\ufeff"
        + "\ufff9\ufffb"
        + "\ud804\udcbd\ud804\udcbd"
        + "\ud82f\udca0\ud82f\udca3"
        + "\ud834\udd73\ud834\udd7a"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f",
    // Unicode 7.0 property value: {chakma}
    "\ud804\udd00\ud804\udd34" + "\ud804\udd36\ud804\udd43",
    // Unicode 7.0 property value: {cham}
    "\uaa00\uaa36" + "\uaa40\uaa4d" + "\uaa50\uaa59" + "\uaa5c\uaa5f",
    // Unicode 7.0 property value: {changeswhencasefolded}
    "\u0041\u005a"
        + "\u00b5\u00b5"
        + "\u00c0\u00d6"
        + "\u00d8\u00df"
        + "\u0100\u0100"
        + "\u0102\u0102"
        + "\u0104\u0104"
        + "\u0106\u0106"
        + "\u0108\u0108"
        + "\u010a\u010a"
        + "\u010c\u010c"
        + "\u010e\u010e"
        + "\u0110\u0110"
        + "\u0112\u0112"
        + "\u0114\u0114"
        + "\u0116\u0116"
        + "\u0118\u0118"
        + "\u011a\u011a"
        + "\u011c\u011c"
        + "\u011e\u011e"
        + "\u0120\u0120"
        + "\u0122\u0122"
        + "\u0124\u0124"
        + "\u0126\u0126"
        + "\u0128\u0128"
        + "\u012a\u012a"
        + "\u012c\u012c"
        + "\u012e\u012e"
        + "\u0130\u0130"
        + "\u0132\u0132"
        + "\u0134\u0134"
        + "\u0136\u0136"
        + "\u0139\u0139"
        + "\u013b\u013b"
        + "\u013d\u013d"
        + "\u013f\u013f"
        + "\u0141\u0141"
        + "\u0143\u0143"
        + "\u0145\u0145"
        + "\u0147\u0147"
        + "\u0149\u014a"
        + "\u014c\u014c"
        + "\u014e\u014e"
        + "\u0150\u0150"
        + "\u0152\u0152"
        + "\u0154\u0154"
        + "\u0156\u0156"
        + "\u0158\u0158"
        + "\u015a\u015a"
        + "\u015c\u015c"
        + "\u015e\u015e"
        + "\u0160\u0160"
        + "\u0162\u0162"
        + "\u0164\u0164"
        + "\u0166\u0166"
        + "\u0168\u0168"
        + "\u016a\u016a"
        + "\u016c\u016c"
        + "\u016e\u016e"
        + "\u0170\u0170"
        + "\u0172\u0172"
        + "\u0174\u0174"
        + "\u0176\u0176"
        + "\u0178\u0179"
        + "\u017b\u017b"
        + "\u017d\u017d"
        + "\u017f\u017f"
        + "\u0181\u0182"
        + "\u0184\u0184"
        + "\u0186\u0187"
        + "\u0189\u018b"
        + "\u018e\u0191"
        + "\u0193\u0194"
        + "\u0196\u0198"
        + "\u019c\u019d"
        + "\u019f\u01a0"
        + "\u01a2\u01a2"
        + "\u01a4\u01a4"
        + "\u01a6\u01a7"
        + "\u01a9\u01a9"
        + "\u01ac\u01ac"
        + "\u01ae\u01af"
        + "\u01b1\u01b3"
        + "\u01b5\u01b5"
        + "\u01b7\u01b8"
        + "\u01bc\u01bc"
        + "\u01c4\u01c5"
        + "\u01c7\u01c8"
        + "\u01ca\u01cb"
        + "\u01cd\u01cd"
        + "\u01cf\u01cf"
        + "\u01d1\u01d1"
        + "\u01d3\u01d3"
        + "\u01d5\u01d5"
        + "\u01d7\u01d7"
        + "\u01d9\u01d9"
        + "\u01db\u01db"
        + "\u01de\u01de"
        + "\u01e0\u01e0"
        + "\u01e2\u01e2"
        + "\u01e4\u01e4"
        + "\u01e6\u01e6"
        + "\u01e8\u01e8"
        + "\u01ea\u01ea"
        + "\u01ec\u01ec"
        + "\u01ee\u01ee"
        + "\u01f1\u01f2"
        + "\u01f4\u01f4"
        + "\u01f6\u01f8"
        + "\u01fa\u01fa"
        + "\u01fc\u01fc"
        + "\u01fe\u01fe"
        + "\u0200\u0200"
        + "\u0202\u0202"
        + "\u0204\u0204"
        + "\u0206\u0206"
        + "\u0208\u0208"
        + "\u020a\u020a"
        + "\u020c\u020c"
        + "\u020e\u020e"
        + "\u0210\u0210"
        + "\u0212\u0212"
        + "\u0214\u0214"
        + "\u0216\u0216"
        + "\u0218\u0218"
        + "\u021a\u021a"
        + "\u021c\u021c"
        + "\u021e\u021e"
        + "\u0220\u0220"
        + "\u0222\u0222"
        + "\u0224\u0224"
        + "\u0226\u0226"
        + "\u0228\u0228"
        + "\u022a\u022a"
        + "\u022c\u022c"
        + "\u022e\u022e"
        + "\u0230\u0230"
        + "\u0232\u0232"
        + "\u023a\u023b"
        + "\u023d\u023e"
        + "\u0241\u0241"
        + "\u0243\u0246"
        + "\u0248\u0248"
        + "\u024a\u024a"
        + "\u024c\u024c"
        + "\u024e\u024e"
        + "\u0345\u0345"
        + "\u0370\u0370"
        + "\u0372\u0372"
        + "\u0376\u0376"
        + "\u037f\u037f"
        + "\u0386\u0386"
        + "\u0388\u038a"
        + "\u038c\u038c"
        + "\u038e\u038f"
        + "\u0391\u03a1"
        + "\u03a3\u03ab"
        + "\u03c2\u03c2"
        + "\u03cf\u03d1"
        + "\u03d5\u03d6"
        + "\u03d8\u03d8"
        + "\u03da\u03da"
        + "\u03dc\u03dc"
        + "\u03de\u03de"
        + "\u03e0\u03e0"
        + "\u03e2\u03e2"
        + "\u03e4\u03e4"
        + "\u03e6\u03e6"
        + "\u03e8\u03e8"
        + "\u03ea\u03ea"
        + "\u03ec\u03ec"
        + "\u03ee\u03ee"
        + "\u03f0\u03f1"
        + "\u03f4\u03f5"
        + "\u03f7\u03f7"
        + "\u03f9\u03fa"
        + "\u03fd\u042f"
        + "\u0460\u0460"
        + "\u0462\u0462"
        + "\u0464\u0464"
        + "\u0466\u0466"
        + "\u0468\u0468"
        + "\u046a\u046a"
        + "\u046c\u046c"
        + "\u046e\u046e"
        + "\u0470\u0470"
        + "\u0472\u0472"
        + "\u0474\u0474"
        + "\u0476\u0476"
        + "\u0478\u0478"
        + "\u047a\u047a"
        + "\u047c\u047c"
        + "\u047e\u047e"
        + "\u0480\u0480"
        + "\u048a\u048a"
        + "\u048c\u048c"
        + "\u048e\u048e"
        + "\u0490\u0490"
        + "\u0492\u0492"
        + "\u0494\u0494"
        + "\u0496\u0496"
        + "\u0498\u0498"
        + "\u049a\u049a"
        + "\u049c\u049c"
        + "\u049e\u049e"
        + "\u04a0\u04a0"
        + "\u04a2\u04a2"
        + "\u04a4\u04a4"
        + "\u04a6\u04a6"
        + "\u04a8\u04a8"
        + "\u04aa\u04aa"
        + "\u04ac\u04ac"
        + "\u04ae\u04ae"
        + "\u04b0\u04b0"
        + "\u04b2\u04b2"
        + "\u04b4\u04b4"
        + "\u04b6\u04b6"
        + "\u04b8\u04b8"
        + "\u04ba\u04ba"
        + "\u04bc\u04bc"
        + "\u04be\u04be"
        + "\u04c0\u04c1"
        + "\u04c3\u04c3"
        + "\u04c5\u04c5"
        + "\u04c7\u04c7"
        + "\u04c9\u04c9"
        + "\u04cb\u04cb"
        + "\u04cd\u04cd"
        + "\u04d0\u04d0"
        + "\u04d2\u04d2"
        + "\u04d4\u04d4"
        + "\u04d6\u04d6"
        + "\u04d8\u04d8"
        + "\u04da\u04da"
        + "\u04dc\u04dc"
        + "\u04de\u04de"
        + "\u04e0\u04e0"
        + "\u04e2\u04e2"
        + "\u04e4\u04e4"
        + "\u04e6\u04e6"
        + "\u04e8\u04e8"
        + "\u04ea\u04ea"
        + "\u04ec\u04ec"
        + "\u04ee\u04ee"
        + "\u04f0\u04f0"
        + "\u04f2\u04f2"
        + "\u04f4\u04f4"
        + "\u04f6\u04f6"
        + "\u04f8\u04f8"
        + "\u04fa\u04fa"
        + "\u04fc\u04fc"
        + "\u04fe\u04fe"
        + "\u0500\u0500"
        + "\u0502\u0502"
        + "\u0504\u0504"
        + "\u0506\u0506"
        + "\u0508\u0508"
        + "\u050a\u050a"
        + "\u050c\u050c"
        + "\u050e\u050e"
        + "\u0510\u0510"
        + "\u0512\u0512"
        + "\u0514\u0514"
        + "\u0516\u0516"
        + "\u0518\u0518"
        + "\u051a\u051a"
        + "\u051c\u051c"
        + "\u051e\u051e"
        + "\u0520\u0520"
        + "\u0522\u0522"
        + "\u0524\u0524"
        + "\u0526\u0526"
        + "\u0528\u0528"
        + "\u052a\u052a"
        + "\u052c\u052c"
        + "\u052e\u052e"
        + "\u0531\u0556"
        + "\u0587\u0587"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u1e00\u1e00"
        + "\u1e02\u1e02"
        + "\u1e04\u1e04"
        + "\u1e06\u1e06"
        + "\u1e08\u1e08"
        + "\u1e0a\u1e0a"
        + "\u1e0c\u1e0c"
        + "\u1e0e\u1e0e"
        + "\u1e10\u1e10"
        + "\u1e12\u1e12"
        + "\u1e14\u1e14"
        + "\u1e16\u1e16"
        + "\u1e18\u1e18"
        + "\u1e1a\u1e1a"
        + "\u1e1c\u1e1c"
        + "\u1e1e\u1e1e"
        + "\u1e20\u1e20"
        + "\u1e22\u1e22"
        + "\u1e24\u1e24"
        + "\u1e26\u1e26"
        + "\u1e28\u1e28"
        + "\u1e2a\u1e2a"
        + "\u1e2c\u1e2c"
        + "\u1e2e\u1e2e"
        + "\u1e30\u1e30"
        + "\u1e32\u1e32"
        + "\u1e34\u1e34"
        + "\u1e36\u1e36"
        + "\u1e38\u1e38"
        + "\u1e3a\u1e3a"
        + "\u1e3c\u1e3c"
        + "\u1e3e\u1e3e"
        + "\u1e40\u1e40"
        + "\u1e42\u1e42"
        + "\u1e44\u1e44"
        + "\u1e46\u1e46"
        + "\u1e48\u1e48"
        + "\u1e4a\u1e4a"
        + "\u1e4c\u1e4c"
        + "\u1e4e\u1e4e"
        + "\u1e50\u1e50"
        + "\u1e52\u1e52"
        + "\u1e54\u1e54"
        + "\u1e56\u1e56"
        + "\u1e58\u1e58"
        + "\u1e5a\u1e5a"
        + "\u1e5c\u1e5c"
        + "\u1e5e\u1e5e"
        + "\u1e60\u1e60"
        + "\u1e62\u1e62"
        + "\u1e64\u1e64"
        + "\u1e66\u1e66"
        + "\u1e68\u1e68"
        + "\u1e6a\u1e6a"
        + "\u1e6c\u1e6c"
        + "\u1e6e\u1e6e"
        + "\u1e70\u1e70"
        + "\u1e72\u1e72"
        + "\u1e74\u1e74"
        + "\u1e76\u1e76"
        + "\u1e78\u1e78"
        + "\u1e7a\u1e7a"
        + "\u1e7c\u1e7c"
        + "\u1e7e\u1e7e"
        + "\u1e80\u1e80"
        + "\u1e82\u1e82"
        + "\u1e84\u1e84"
        + "\u1e86\u1e86"
        + "\u1e88\u1e88"
        + "\u1e8a\u1e8a"
        + "\u1e8c\u1e8c"
        + "\u1e8e\u1e8e"
        + "\u1e90\u1e90"
        + "\u1e92\u1e92"
        + "\u1e94\u1e94"
        + "\u1e9a\u1e9b"
        + "\u1e9e\u1e9e"
        + "\u1ea0\u1ea0"
        + "\u1ea2\u1ea2"
        + "\u1ea4\u1ea4"
        + "\u1ea6\u1ea6"
        + "\u1ea8\u1ea8"
        + "\u1eaa\u1eaa"
        + "\u1eac\u1eac"
        + "\u1eae\u1eae"
        + "\u1eb0\u1eb0"
        + "\u1eb2\u1eb2"
        + "\u1eb4\u1eb4"
        + "\u1eb6\u1eb6"
        + "\u1eb8\u1eb8"
        + "\u1eba\u1eba"
        + "\u1ebc\u1ebc"
        + "\u1ebe\u1ebe"
        + "\u1ec0\u1ec0"
        + "\u1ec2\u1ec2"
        + "\u1ec4\u1ec4"
        + "\u1ec6\u1ec6"
        + "\u1ec8\u1ec8"
        + "\u1eca\u1eca"
        + "\u1ecc\u1ecc"
        + "\u1ece\u1ece"
        + "\u1ed0\u1ed0"
        + "\u1ed2\u1ed2"
        + "\u1ed4\u1ed4"
        + "\u1ed6\u1ed6"
        + "\u1ed8\u1ed8"
        + "\u1eda\u1eda"
        + "\u1edc\u1edc"
        + "\u1ede\u1ede"
        + "\u1ee0\u1ee0"
        + "\u1ee2\u1ee2"
        + "\u1ee4\u1ee4"
        + "\u1ee6\u1ee6"
        + "\u1ee8\u1ee8"
        + "\u1eea\u1eea"
        + "\u1eec\u1eec"
        + "\u1eee\u1eee"
        + "\u1ef0\u1ef0"
        + "\u1ef2\u1ef2"
        + "\u1ef4\u1ef4"
        + "\u1ef6\u1ef6"
        + "\u1ef8\u1ef8"
        + "\u1efa\u1efa"
        + "\u1efc\u1efc"
        + "\u1efe\u1efe"
        + "\u1f08\u1f0f"
        + "\u1f18\u1f1d"
        + "\u1f28\u1f2f"
        + "\u1f38\u1f3f"
        + "\u1f48\u1f4d"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f5f"
        + "\u1f68\u1f6f"
        + "\u1f80\u1faf"
        + "\u1fb2\u1fb4"
        + "\u1fb7\u1fbc"
        + "\u1fc2\u1fc4"
        + "\u1fc7\u1fcc"
        + "\u1fd8\u1fdb"
        + "\u1fe8\u1fec"
        + "\u1ff2\u1ff4"
        + "\u1ff7\u1ffc"
        + "\u2126\u2126"
        + "\u212a\u212b"
        + "\u2132\u2132"
        + "\u2160\u216f"
        + "\u2183\u2183"
        + "\u24b6\u24cf"
        + "\u2c00\u2c2e"
        + "\u2c60\u2c60"
        + "\u2c62\u2c64"
        + "\u2c67\u2c67"
        + "\u2c69\u2c69"
        + "\u2c6b\u2c6b"
        + "\u2c6d\u2c70"
        + "\u2c72\u2c72"
        + "\u2c75\u2c75"
        + "\u2c7e\u2c80"
        + "\u2c82\u2c82"
        + "\u2c84\u2c84"
        + "\u2c86\u2c86"
        + "\u2c88\u2c88"
        + "\u2c8a\u2c8a"
        + "\u2c8c\u2c8c"
        + "\u2c8e\u2c8e"
        + "\u2c90\u2c90"
        + "\u2c92\u2c92"
        + "\u2c94\u2c94"
        + "\u2c96\u2c96"
        + "\u2c98\u2c98"
        + "\u2c9a\u2c9a"
        + "\u2c9c\u2c9c"
        + "\u2c9e\u2c9e"
        + "\u2ca0\u2ca0"
        + "\u2ca2\u2ca2"
        + "\u2ca4\u2ca4"
        + "\u2ca6\u2ca6"
        + "\u2ca8\u2ca8"
        + "\u2caa\u2caa"
        + "\u2cac\u2cac"
        + "\u2cae\u2cae"
        + "\u2cb0\u2cb0"
        + "\u2cb2\u2cb2"
        + "\u2cb4\u2cb4"
        + "\u2cb6\u2cb6"
        + "\u2cb8\u2cb8"
        + "\u2cba\u2cba"
        + "\u2cbc\u2cbc"
        + "\u2cbe\u2cbe"
        + "\u2cc0\u2cc0"
        + "\u2cc2\u2cc2"
        + "\u2cc4\u2cc4"
        + "\u2cc6\u2cc6"
        + "\u2cc8\u2cc8"
        + "\u2cca\u2cca"
        + "\u2ccc\u2ccc"
        + "\u2cce\u2cce"
        + "\u2cd0\u2cd0"
        + "\u2cd2\u2cd2"
        + "\u2cd4\u2cd4"
        + "\u2cd6\u2cd6"
        + "\u2cd8\u2cd8"
        + "\u2cda\u2cda"
        + "\u2cdc\u2cdc"
        + "\u2cde\u2cde"
        + "\u2ce0\u2ce0"
        + "\u2ce2\u2ce2"
        + "\u2ceb\u2ceb"
        + "\u2ced\u2ced"
        + "\u2cf2\u2cf2"
        + "\ua640\ua640"
        + "\ua642\ua642"
        + "\ua644\ua644"
        + "\ua646\ua646"
        + "\ua648\ua648"
        + "\ua64a\ua64a"
        + "\ua64c\ua64c"
        + "\ua64e\ua64e"
        + "\ua650\ua650"
        + "\ua652\ua652"
        + "\ua654\ua654"
        + "\ua656\ua656"
        + "\ua658\ua658"
        + "\ua65a\ua65a"
        + "\ua65c\ua65c"
        + "\ua65e\ua65e"
        + "\ua660\ua660"
        + "\ua662\ua662"
        + "\ua664\ua664"
        + "\ua666\ua666"
        + "\ua668\ua668"
        + "\ua66a\ua66a"
        + "\ua66c\ua66c"
        + "\ua680\ua680"
        + "\ua682\ua682"
        + "\ua684\ua684"
        + "\ua686\ua686"
        + "\ua688\ua688"
        + "\ua68a\ua68a"
        + "\ua68c\ua68c"
        + "\ua68e\ua68e"
        + "\ua690\ua690"
        + "\ua692\ua692"
        + "\ua694\ua694"
        + "\ua696\ua696"
        + "\ua698\ua698"
        + "\ua69a\ua69a"
        + "\ua722\ua722"
        + "\ua724\ua724"
        + "\ua726\ua726"
        + "\ua728\ua728"
        + "\ua72a\ua72a"
        + "\ua72c\ua72c"
        + "\ua72e\ua72e"
        + "\ua732\ua732"
        + "\ua734\ua734"
        + "\ua736\ua736"
        + "\ua738\ua738"
        + "\ua73a\ua73a"
        + "\ua73c\ua73c"
        + "\ua73e\ua73e"
        + "\ua740\ua740"
        + "\ua742\ua742"
        + "\ua744\ua744"
        + "\ua746\ua746"
        + "\ua748\ua748"
        + "\ua74a\ua74a"
        + "\ua74c\ua74c"
        + "\ua74e\ua74e"
        + "\ua750\ua750"
        + "\ua752\ua752"
        + "\ua754\ua754"
        + "\ua756\ua756"
        + "\ua758\ua758"
        + "\ua75a\ua75a"
        + "\ua75c\ua75c"
        + "\ua75e\ua75e"
        + "\ua760\ua760"
        + "\ua762\ua762"
        + "\ua764\ua764"
        + "\ua766\ua766"
        + "\ua768\ua768"
        + "\ua76a\ua76a"
        + "\ua76c\ua76c"
        + "\ua76e\ua76e"
        + "\ua779\ua779"
        + "\ua77b\ua77b"
        + "\ua77d\ua77e"
        + "\ua780\ua780"
        + "\ua782\ua782"
        + "\ua784\ua784"
        + "\ua786\ua786"
        + "\ua78b\ua78b"
        + "\ua78d\ua78d"
        + "\ua790\ua790"
        + "\ua792\ua792"
        + "\ua796\ua796"
        + "\ua798\ua798"
        + "\ua79a\ua79a"
        + "\ua79c\ua79c"
        + "\ua79e\ua79e"
        + "\ua7a0\ua7a0"
        + "\ua7a2\ua7a2"
        + "\ua7a4\ua7a4"
        + "\ua7a6\ua7a6"
        + "\ua7a8\ua7a8"
        + "\ua7aa\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\uff21\uff3a"
        + "\ud801\udc00\ud801\udc27"
        + "\ud806\udca0\ud806\udcbf",
    // Unicode 7.0 property value: {changeswhencasemapped}
    "\u0041\u005a"
        + "\u0061\u007a"
        + "\u00b5\u00b5"
        + "\u00c0\u00d6"
        + "\u00d8\u00f6"
        + "\u00f8\u0137"
        + "\u0139\u018c"
        + "\u018e\u019a"
        + "\u019c\u01a9"
        + "\u01ac\u01b9"
        + "\u01bc\u01bd"
        + "\u01bf\u01bf"
        + "\u01c4\u0220"
        + "\u0222\u0233"
        + "\u023a\u0254"
        + "\u0256\u0257"
        + "\u0259\u0259"
        + "\u025b\u025c"
        + "\u0260\u0261"
        + "\u0263\u0263"
        + "\u0265\u0266"
        + "\u0268\u0269"
        + "\u026b\u026c"
        + "\u026f\u026f"
        + "\u0271\u0272"
        + "\u0275\u0275"
        + "\u027d\u027d"
        + "\u0280\u0280"
        + "\u0283\u0283"
        + "\u0287\u028c"
        + "\u0292\u0292"
        + "\u029e\u029e"
        + "\u0345\u0345"
        + "\u0370\u0373"
        + "\u0376\u0377"
        + "\u037b\u037d"
        + "\u037f\u037f"
        + "\u0386\u0386"
        + "\u0388\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03d1"
        + "\u03d5\u03f5"
        + "\u03f7\u03fb"
        + "\u03fd\u0481"
        + "\u048a\u052f"
        + "\u0531\u0556"
        + "\u0561\u0587"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u1d79\u1d79"
        + "\u1d7d\u1d7d"
        + "\u1e00\u1e9b"
        + "\u1e9e\u1e9e"
        + "\u1ea0\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fbc"
        + "\u1fbe\u1fbe"
        + "\u1fc2\u1fc4"
        + "\u1fc6\u1fcc"
        + "\u1fd0\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fe0\u1fec"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffc"
        + "\u2126\u2126"
        + "\u212a\u212b"
        + "\u2132\u2132"
        + "\u214e\u214e"
        + "\u2160\u217f"
        + "\u2183\u2184"
        + "\u24b6\u24e9"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2c70"
        + "\u2c72\u2c73"
        + "\u2c75\u2c76"
        + "\u2c7e\u2ce3"
        + "\u2ceb\u2cee"
        + "\u2cf2\u2cf3"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\ua640\ua66d"
        + "\ua680\ua69b"
        + "\ua722\ua72f"
        + "\ua732\ua76f"
        + "\ua779\ua787"
        + "\ua78b\ua78d"
        + "\ua790\ua793"
        + "\ua796\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\uff21\uff3a"
        + "\uff41\uff5a"
        + "\ud801\udc00\ud801\udc4f"
        + "\ud806\udca0\ud806\udcdf",
    // Unicode 7.0 property value: {changeswhenlowercased}
    "\u0041\u005a"
        + "\u00c0\u00d6"
        + "\u00d8\u00de"
        + "\u0100\u0100"
        + "\u0102\u0102"
        + "\u0104\u0104"
        + "\u0106\u0106"
        + "\u0108\u0108"
        + "\u010a\u010a"
        + "\u010c\u010c"
        + "\u010e\u010e"
        + "\u0110\u0110"
        + "\u0112\u0112"
        + "\u0114\u0114"
        + "\u0116\u0116"
        + "\u0118\u0118"
        + "\u011a\u011a"
        + "\u011c\u011c"
        + "\u011e\u011e"
        + "\u0120\u0120"
        + "\u0122\u0122"
        + "\u0124\u0124"
        + "\u0126\u0126"
        + "\u0128\u0128"
        + "\u012a\u012a"
        + "\u012c\u012c"
        + "\u012e\u012e"
        + "\u0130\u0130"
        + "\u0132\u0132"
        + "\u0134\u0134"
        + "\u0136\u0136"
        + "\u0139\u0139"
        + "\u013b\u013b"
        + "\u013d\u013d"
        + "\u013f\u013f"
        + "\u0141\u0141"
        + "\u0143\u0143"
        + "\u0145\u0145"
        + "\u0147\u0147"
        + "\u014a\u014a"
        + "\u014c\u014c"
        + "\u014e\u014e"
        + "\u0150\u0150"
        + "\u0152\u0152"
        + "\u0154\u0154"
        + "\u0156\u0156"
        + "\u0158\u0158"
        + "\u015a\u015a"
        + "\u015c\u015c"
        + "\u015e\u015e"
        + "\u0160\u0160"
        + "\u0162\u0162"
        + "\u0164\u0164"
        + "\u0166\u0166"
        + "\u0168\u0168"
        + "\u016a\u016a"
        + "\u016c\u016c"
        + "\u016e\u016e"
        + "\u0170\u0170"
        + "\u0172\u0172"
        + "\u0174\u0174"
        + "\u0176\u0176"
        + "\u0178\u0179"
        + "\u017b\u017b"
        + "\u017d\u017d"
        + "\u0181\u0182"
        + "\u0184\u0184"
        + "\u0186\u0187"
        + "\u0189\u018b"
        + "\u018e\u0191"
        + "\u0193\u0194"
        + "\u0196\u0198"
        + "\u019c\u019d"
        + "\u019f\u01a0"
        + "\u01a2\u01a2"
        + "\u01a4\u01a4"
        + "\u01a6\u01a7"
        + "\u01a9\u01a9"
        + "\u01ac\u01ac"
        + "\u01ae\u01af"
        + "\u01b1\u01b3"
        + "\u01b5\u01b5"
        + "\u01b7\u01b8"
        + "\u01bc\u01bc"
        + "\u01c4\u01c5"
        + "\u01c7\u01c8"
        + "\u01ca\u01cb"
        + "\u01cd\u01cd"
        + "\u01cf\u01cf"
        + "\u01d1\u01d1"
        + "\u01d3\u01d3"
        + "\u01d5\u01d5"
        + "\u01d7\u01d7"
        + "\u01d9\u01d9"
        + "\u01db\u01db"
        + "\u01de\u01de"
        + "\u01e0\u01e0"
        + "\u01e2\u01e2"
        + "\u01e4\u01e4"
        + "\u01e6\u01e6"
        + "\u01e8\u01e8"
        + "\u01ea\u01ea"
        + "\u01ec\u01ec"
        + "\u01ee\u01ee"
        + "\u01f1\u01f2"
        + "\u01f4\u01f4"
        + "\u01f6\u01f8"
        + "\u01fa\u01fa"
        + "\u01fc\u01fc"
        + "\u01fe\u01fe"
        + "\u0200\u0200"
        + "\u0202\u0202"
        + "\u0204\u0204"
        + "\u0206\u0206"
        + "\u0208\u0208"
        + "\u020a\u020a"
        + "\u020c\u020c"
        + "\u020e\u020e"
        + "\u0210\u0210"
        + "\u0212\u0212"
        + "\u0214\u0214"
        + "\u0216\u0216"
        + "\u0218\u0218"
        + "\u021a\u021a"
        + "\u021c\u021c"
        + "\u021e\u021e"
        + "\u0220\u0220"
        + "\u0222\u0222"
        + "\u0224\u0224"
        + "\u0226\u0226"
        + "\u0228\u0228"
        + "\u022a\u022a"
        + "\u022c\u022c"
        + "\u022e\u022e"
        + "\u0230\u0230"
        + "\u0232\u0232"
        + "\u023a\u023b"
        + "\u023d\u023e"
        + "\u0241\u0241"
        + "\u0243\u0246"
        + "\u0248\u0248"
        + "\u024a\u024a"
        + "\u024c\u024c"
        + "\u024e\u024e"
        + "\u0370\u0370"
        + "\u0372\u0372"
        + "\u0376\u0376"
        + "\u037f\u037f"
        + "\u0386\u0386"
        + "\u0388\u038a"
        + "\u038c\u038c"
        + "\u038e\u038f"
        + "\u0391\u03a1"
        + "\u03a3\u03ab"
        + "\u03cf\u03cf"
        + "\u03d8\u03d8"
        + "\u03da\u03da"
        + "\u03dc\u03dc"
        + "\u03de\u03de"
        + "\u03e0\u03e0"
        + "\u03e2\u03e2"
        + "\u03e4\u03e4"
        + "\u03e6\u03e6"
        + "\u03e8\u03e8"
        + "\u03ea\u03ea"
        + "\u03ec\u03ec"
        + "\u03ee\u03ee"
        + "\u03f4\u03f4"
        + "\u03f7\u03f7"
        + "\u03f9\u03fa"
        + "\u03fd\u042f"
        + "\u0460\u0460"
        + "\u0462\u0462"
        + "\u0464\u0464"
        + "\u0466\u0466"
        + "\u0468\u0468"
        + "\u046a\u046a"
        + "\u046c\u046c"
        + "\u046e\u046e"
        + "\u0470\u0470"
        + "\u0472\u0472"
        + "\u0474\u0474"
        + "\u0476\u0476"
        + "\u0478\u0478"
        + "\u047a\u047a"
        + "\u047c\u047c"
        + "\u047e\u047e"
        + "\u0480\u0480"
        + "\u048a\u048a"
        + "\u048c\u048c"
        + "\u048e\u048e"
        + "\u0490\u0490"
        + "\u0492\u0492"
        + "\u0494\u0494"
        + "\u0496\u0496"
        + "\u0498\u0498"
        + "\u049a\u049a"
        + "\u049c\u049c"
        + "\u049e\u049e"
        + "\u04a0\u04a0"
        + "\u04a2\u04a2"
        + "\u04a4\u04a4"
        + "\u04a6\u04a6"
        + "\u04a8\u04a8"
        + "\u04aa\u04aa"
        + "\u04ac\u04ac"
        + "\u04ae\u04ae"
        + "\u04b0\u04b0"
        + "\u04b2\u04b2"
        + "\u04b4\u04b4"
        + "\u04b6\u04b6"
        + "\u04b8\u04b8"
        + "\u04ba\u04ba"
        + "\u04bc\u04bc"
        + "\u04be\u04be"
        + "\u04c0\u04c1"
        + "\u04c3\u04c3"
        + "\u04c5\u04c5"
        + "\u04c7\u04c7"
        + "\u04c9\u04c9"
        + "\u04cb\u04cb"
        + "\u04cd\u04cd"
        + "\u04d0\u04d0"
        + "\u04d2\u04d2"
        + "\u04d4\u04d4"
        + "\u04d6\u04d6"
        + "\u04d8\u04d8"
        + "\u04da\u04da"
        + "\u04dc\u04dc"
        + "\u04de\u04de"
        + "\u04e0\u04e0"
        + "\u04e2\u04e2"
        + "\u04e4\u04e4"
        + "\u04e6\u04e6"
        + "\u04e8\u04e8"
        + "\u04ea\u04ea"
        + "\u04ec\u04ec"
        + "\u04ee\u04ee"
        + "\u04f0\u04f0"
        + "\u04f2\u04f2"
        + "\u04f4\u04f4"
        + "\u04f6\u04f6"
        + "\u04f8\u04f8"
        + "\u04fa\u04fa"
        + "\u04fc\u04fc"
        + "\u04fe\u04fe"
        + "\u0500\u0500"
        + "\u0502\u0502"
        + "\u0504\u0504"
        + "\u0506\u0506"
        + "\u0508\u0508"
        + "\u050a\u050a"
        + "\u050c\u050c"
        + "\u050e\u050e"
        + "\u0510\u0510"
        + "\u0512\u0512"
        + "\u0514\u0514"
        + "\u0516\u0516"
        + "\u0518\u0518"
        + "\u051a\u051a"
        + "\u051c\u051c"
        + "\u051e\u051e"
        + "\u0520\u0520"
        + "\u0522\u0522"
        + "\u0524\u0524"
        + "\u0526\u0526"
        + "\u0528\u0528"
        + "\u052a\u052a"
        + "\u052c\u052c"
        + "\u052e\u052e"
        + "\u0531\u0556"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u1e00\u1e00"
        + "\u1e02\u1e02"
        + "\u1e04\u1e04"
        + "\u1e06\u1e06"
        + "\u1e08\u1e08"
        + "\u1e0a\u1e0a"
        + "\u1e0c\u1e0c"
        + "\u1e0e\u1e0e"
        + "\u1e10\u1e10"
        + "\u1e12\u1e12"
        + "\u1e14\u1e14"
        + "\u1e16\u1e16"
        + "\u1e18\u1e18"
        + "\u1e1a\u1e1a"
        + "\u1e1c\u1e1c"
        + "\u1e1e\u1e1e"
        + "\u1e20\u1e20"
        + "\u1e22\u1e22"
        + "\u1e24\u1e24"
        + "\u1e26\u1e26"
        + "\u1e28\u1e28"
        + "\u1e2a\u1e2a"
        + "\u1e2c\u1e2c"
        + "\u1e2e\u1e2e"
        + "\u1e30\u1e30"
        + "\u1e32\u1e32"
        + "\u1e34\u1e34"
        + "\u1e36\u1e36"
        + "\u1e38\u1e38"
        + "\u1e3a\u1e3a"
        + "\u1e3c\u1e3c"
        + "\u1e3e\u1e3e"
        + "\u1e40\u1e40"
        + "\u1e42\u1e42"
        + "\u1e44\u1e44"
        + "\u1e46\u1e46"
        + "\u1e48\u1e48"
        + "\u1e4a\u1e4a"
        + "\u1e4c\u1e4c"
        + "\u1e4e\u1e4e"
        + "\u1e50\u1e50"
        + "\u1e52\u1e52"
        + "\u1e54\u1e54"
        + "\u1e56\u1e56"
        + "\u1e58\u1e58"
        + "\u1e5a\u1e5a"
        + "\u1e5c\u1e5c"
        + "\u1e5e\u1e5e"
        + "\u1e60\u1e60"
        + "\u1e62\u1e62"
        + "\u1e64\u1e64"
        + "\u1e66\u1e66"
        + "\u1e68\u1e68"
        + "\u1e6a\u1e6a"
        + "\u1e6c\u1e6c"
        + "\u1e6e\u1e6e"
        + "\u1e70\u1e70"
        + "\u1e72\u1e72"
        + "\u1e74\u1e74"
        + "\u1e76\u1e76"
        + "\u1e78\u1e78"
        + "\u1e7a\u1e7a"
        + "\u1e7c\u1e7c"
        + "\u1e7e\u1e7e"
        + "\u1e80\u1e80"
        + "\u1e82\u1e82"
        + "\u1e84\u1e84"
        + "\u1e86\u1e86"
        + "\u1e88\u1e88"
        + "\u1e8a\u1e8a"
        + "\u1e8c\u1e8c"
        + "\u1e8e\u1e8e"
        + "\u1e90\u1e90"
        + "\u1e92\u1e92"
        + "\u1e94\u1e94"
        + "\u1e9e\u1e9e"
        + "\u1ea0\u1ea0"
        + "\u1ea2\u1ea2"
        + "\u1ea4\u1ea4"
        + "\u1ea6\u1ea6"
        + "\u1ea8\u1ea8"
        + "\u1eaa\u1eaa"
        + "\u1eac\u1eac"
        + "\u1eae\u1eae"
        + "\u1eb0\u1eb0"
        + "\u1eb2\u1eb2"
        + "\u1eb4\u1eb4"
        + "\u1eb6\u1eb6"
        + "\u1eb8\u1eb8"
        + "\u1eba\u1eba"
        + "\u1ebc\u1ebc"
        + "\u1ebe\u1ebe"
        + "\u1ec0\u1ec0"
        + "\u1ec2\u1ec2"
        + "\u1ec4\u1ec4"
        + "\u1ec6\u1ec6"
        + "\u1ec8\u1ec8"
        + "\u1eca\u1eca"
        + "\u1ecc\u1ecc"
        + "\u1ece\u1ece"
        + "\u1ed0\u1ed0"
        + "\u1ed2\u1ed2"
        + "\u1ed4\u1ed4"
        + "\u1ed6\u1ed6"
        + "\u1ed8\u1ed8"
        + "\u1eda\u1eda"
        + "\u1edc\u1edc"
        + "\u1ede\u1ede"
        + "\u1ee0\u1ee0"
        + "\u1ee2\u1ee2"
        + "\u1ee4\u1ee4"
        + "\u1ee6\u1ee6"
        + "\u1ee8\u1ee8"
        + "\u1eea\u1eea"
        + "\u1eec\u1eec"
        + "\u1eee\u1eee"
        + "\u1ef0\u1ef0"
        + "\u1ef2\u1ef2"
        + "\u1ef4\u1ef4"
        + "\u1ef6\u1ef6"
        + "\u1ef8\u1ef8"
        + "\u1efa\u1efa"
        + "\u1efc\u1efc"
        + "\u1efe\u1efe"
        + "\u1f08\u1f0f"
        + "\u1f18\u1f1d"
        + "\u1f28\u1f2f"
        + "\u1f38\u1f3f"
        + "\u1f48\u1f4d"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f5f"
        + "\u1f68\u1f6f"
        + "\u1f88\u1f8f"
        + "\u1f98\u1f9f"
        + "\u1fa8\u1faf"
        + "\u1fb8\u1fbc"
        + "\u1fc8\u1fcc"
        + "\u1fd8\u1fdb"
        + "\u1fe8\u1fec"
        + "\u1ff8\u1ffc"
        + "\u2126\u2126"
        + "\u212a\u212b"
        + "\u2132\u2132"
        + "\u2160\u216f"
        + "\u2183\u2183"
        + "\u24b6\u24cf"
        + "\u2c00\u2c2e"
        + "\u2c60\u2c60"
        + "\u2c62\u2c64"
        + "\u2c67\u2c67"
        + "\u2c69\u2c69"
        + "\u2c6b\u2c6b"
        + "\u2c6d\u2c70"
        + "\u2c72\u2c72"
        + "\u2c75\u2c75"
        + "\u2c7e\u2c80"
        + "\u2c82\u2c82"
        + "\u2c84\u2c84"
        + "\u2c86\u2c86"
        + "\u2c88\u2c88"
        + "\u2c8a\u2c8a"
        + "\u2c8c\u2c8c"
        + "\u2c8e\u2c8e"
        + "\u2c90\u2c90"
        + "\u2c92\u2c92"
        + "\u2c94\u2c94"
        + "\u2c96\u2c96"
        + "\u2c98\u2c98"
        + "\u2c9a\u2c9a"
        + "\u2c9c\u2c9c"
        + "\u2c9e\u2c9e"
        + "\u2ca0\u2ca0"
        + "\u2ca2\u2ca2"
        + "\u2ca4\u2ca4"
        + "\u2ca6\u2ca6"
        + "\u2ca8\u2ca8"
        + "\u2caa\u2caa"
        + "\u2cac\u2cac"
        + "\u2cae\u2cae"
        + "\u2cb0\u2cb0"
        + "\u2cb2\u2cb2"
        + "\u2cb4\u2cb4"
        + "\u2cb6\u2cb6"
        + "\u2cb8\u2cb8"
        + "\u2cba\u2cba"
        + "\u2cbc\u2cbc"
        + "\u2cbe\u2cbe"
        + "\u2cc0\u2cc0"
        + "\u2cc2\u2cc2"
        + "\u2cc4\u2cc4"
        + "\u2cc6\u2cc6"
        + "\u2cc8\u2cc8"
        + "\u2cca\u2cca"
        + "\u2ccc\u2ccc"
        + "\u2cce\u2cce"
        + "\u2cd0\u2cd0"
        + "\u2cd2\u2cd2"
        + "\u2cd4\u2cd4"
        + "\u2cd6\u2cd6"
        + "\u2cd8\u2cd8"
        + "\u2cda\u2cda"
        + "\u2cdc\u2cdc"
        + "\u2cde\u2cde"
        + "\u2ce0\u2ce0"
        + "\u2ce2\u2ce2"
        + "\u2ceb\u2ceb"
        + "\u2ced\u2ced"
        + "\u2cf2\u2cf2"
        + "\ua640\ua640"
        + "\ua642\ua642"
        + "\ua644\ua644"
        + "\ua646\ua646"
        + "\ua648\ua648"
        + "\ua64a\ua64a"
        + "\ua64c\ua64c"
        + "\ua64e\ua64e"
        + "\ua650\ua650"
        + "\ua652\ua652"
        + "\ua654\ua654"
        + "\ua656\ua656"
        + "\ua658\ua658"
        + "\ua65a\ua65a"
        + "\ua65c\ua65c"
        + "\ua65e\ua65e"
        + "\ua660\ua660"
        + "\ua662\ua662"
        + "\ua664\ua664"
        + "\ua666\ua666"
        + "\ua668\ua668"
        + "\ua66a\ua66a"
        + "\ua66c\ua66c"
        + "\ua680\ua680"
        + "\ua682\ua682"
        + "\ua684\ua684"
        + "\ua686\ua686"
        + "\ua688\ua688"
        + "\ua68a\ua68a"
        + "\ua68c\ua68c"
        + "\ua68e\ua68e"
        + "\ua690\ua690"
        + "\ua692\ua692"
        + "\ua694\ua694"
        + "\ua696\ua696"
        + "\ua698\ua698"
        + "\ua69a\ua69a"
        + "\ua722\ua722"
        + "\ua724\ua724"
        + "\ua726\ua726"
        + "\ua728\ua728"
        + "\ua72a\ua72a"
        + "\ua72c\ua72c"
        + "\ua72e\ua72e"
        + "\ua732\ua732"
        + "\ua734\ua734"
        + "\ua736\ua736"
        + "\ua738\ua738"
        + "\ua73a\ua73a"
        + "\ua73c\ua73c"
        + "\ua73e\ua73e"
        + "\ua740\ua740"
        + "\ua742\ua742"
        + "\ua744\ua744"
        + "\ua746\ua746"
        + "\ua748\ua748"
        + "\ua74a\ua74a"
        + "\ua74c\ua74c"
        + "\ua74e\ua74e"
        + "\ua750\ua750"
        + "\ua752\ua752"
        + "\ua754\ua754"
        + "\ua756\ua756"
        + "\ua758\ua758"
        + "\ua75a\ua75a"
        + "\ua75c\ua75c"
        + "\ua75e\ua75e"
        + "\ua760\ua760"
        + "\ua762\ua762"
        + "\ua764\ua764"
        + "\ua766\ua766"
        + "\ua768\ua768"
        + "\ua76a\ua76a"
        + "\ua76c\ua76c"
        + "\ua76e\ua76e"
        + "\ua779\ua779"
        + "\ua77b\ua77b"
        + "\ua77d\ua77e"
        + "\ua780\ua780"
        + "\ua782\ua782"
        + "\ua784\ua784"
        + "\ua786\ua786"
        + "\ua78b\ua78b"
        + "\ua78d\ua78d"
        + "\ua790\ua790"
        + "\ua792\ua792"
        + "\ua796\ua796"
        + "\ua798\ua798"
        + "\ua79a\ua79a"
        + "\ua79c\ua79c"
        + "\ua79e\ua79e"
        + "\ua7a0\ua7a0"
        + "\ua7a2\ua7a2"
        + "\ua7a4\ua7a4"
        + "\ua7a6\ua7a6"
        + "\ua7a8\ua7a8"
        + "\ua7aa\ua7ad"
        + "\ua7b0\ua7b1"
        + "\uff21\uff3a"
        + "\ud801\udc00\ud801\udc27"
        + "\ud806\udca0\ud806\udcbf",
    // Unicode 7.0 property value: {changeswhentitlecased}
    "\u0061\u007a"
        + "\u00b5\u00b5"
        + "\u00df\u00f6"
        + "\u00f8\u00ff"
        + "\u0101\u0101"
        + "\u0103\u0103"
        + "\u0105\u0105"
        + "\u0107\u0107"
        + "\u0109\u0109"
        + "\u010b\u010b"
        + "\u010d\u010d"
        + "\u010f\u010f"
        + "\u0111\u0111"
        + "\u0113\u0113"
        + "\u0115\u0115"
        + "\u0117\u0117"
        + "\u0119\u0119"
        + "\u011b\u011b"
        + "\u011d\u011d"
        + "\u011f\u011f"
        + "\u0121\u0121"
        + "\u0123\u0123"
        + "\u0125\u0125"
        + "\u0127\u0127"
        + "\u0129\u0129"
        + "\u012b\u012b"
        + "\u012d\u012d"
        + "\u012f\u012f"
        + "\u0131\u0131"
        + "\u0133\u0133"
        + "\u0135\u0135"
        + "\u0137\u0137"
        + "\u013a\u013a"
        + "\u013c\u013c"
        + "\u013e\u013e"
        + "\u0140\u0140"
        + "\u0142\u0142"
        + "\u0144\u0144"
        + "\u0146\u0146"
        + "\u0148\u0149"
        + "\u014b\u014b"
        + "\u014d\u014d"
        + "\u014f\u014f"
        + "\u0151\u0151"
        + "\u0153\u0153"
        + "\u0155\u0155"
        + "\u0157\u0157"
        + "\u0159\u0159"
        + "\u015b\u015b"
        + "\u015d\u015d"
        + "\u015f\u015f"
        + "\u0161\u0161"
        + "\u0163\u0163"
        + "\u0165\u0165"
        + "\u0167\u0167"
        + "\u0169\u0169"
        + "\u016b\u016b"
        + "\u016d\u016d"
        + "\u016f\u016f"
        + "\u0171\u0171"
        + "\u0173\u0173"
        + "\u0175\u0175"
        + "\u0177\u0177"
        + "\u017a\u017a"
        + "\u017c\u017c"
        + "\u017e\u0180"
        + "\u0183\u0183"
        + "\u0185\u0185"
        + "\u0188\u0188"
        + "\u018c\u018c"
        + "\u0192\u0192"
        + "\u0195\u0195"
        + "\u0199\u019a"
        + "\u019e\u019e"
        + "\u01a1\u01a1"
        + "\u01a3\u01a3"
        + "\u01a5\u01a5"
        + "\u01a8\u01a8"
        + "\u01ad\u01ad"
        + "\u01b0\u01b0"
        + "\u01b4\u01b4"
        + "\u01b6\u01b6"
        + "\u01b9\u01b9"
        + "\u01bd\u01bd"
        + "\u01bf\u01bf"
        + "\u01c4\u01c4"
        + "\u01c6\u01c7"
        + "\u01c9\u01ca"
        + "\u01cc\u01cc"
        + "\u01ce\u01ce"
        + "\u01d0\u01d0"
        + "\u01d2\u01d2"
        + "\u01d4\u01d4"
        + "\u01d6\u01d6"
        + "\u01d8\u01d8"
        + "\u01da\u01da"
        + "\u01dc\u01dd"
        + "\u01df\u01df"
        + "\u01e1\u01e1"
        + "\u01e3\u01e3"
        + "\u01e5\u01e5"
        + "\u01e7\u01e7"
        + "\u01e9\u01e9"
        + "\u01eb\u01eb"
        + "\u01ed\u01ed"
        + "\u01ef\u01f1"
        + "\u01f3\u01f3"
        + "\u01f5\u01f5"
        + "\u01f9\u01f9"
        + "\u01fb\u01fb"
        + "\u01fd\u01fd"
        + "\u01ff\u01ff"
        + "\u0201\u0201"
        + "\u0203\u0203"
        + "\u0205\u0205"
        + "\u0207\u0207"
        + "\u0209\u0209"
        + "\u020b\u020b"
        + "\u020d\u020d"
        + "\u020f\u020f"
        + "\u0211\u0211"
        + "\u0213\u0213"
        + "\u0215\u0215"
        + "\u0217\u0217"
        + "\u0219\u0219"
        + "\u021b\u021b"
        + "\u021d\u021d"
        + "\u021f\u021f"
        + "\u0223\u0223"
        + "\u0225\u0225"
        + "\u0227\u0227"
        + "\u0229\u0229"
        + "\u022b\u022b"
        + "\u022d\u022d"
        + "\u022f\u022f"
        + "\u0231\u0231"
        + "\u0233\u0233"
        + "\u023c\u023c"
        + "\u023f\u0240"
        + "\u0242\u0242"
        + "\u0247\u0247"
        + "\u0249\u0249"
        + "\u024b\u024b"
        + "\u024d\u024d"
        + "\u024f\u0254"
        + "\u0256\u0257"
        + "\u0259\u0259"
        + "\u025b\u025c"
        + "\u0260\u0261"
        + "\u0263\u0263"
        + "\u0265\u0266"
        + "\u0268\u0269"
        + "\u026b\u026c"
        + "\u026f\u026f"
        + "\u0271\u0272"
        + "\u0275\u0275"
        + "\u027d\u027d"
        + "\u0280\u0280"
        + "\u0283\u0283"
        + "\u0287\u028c"
        + "\u0292\u0292"
        + "\u029e\u029e"
        + "\u0345\u0345"
        + "\u0371\u0371"
        + "\u0373\u0373"
        + "\u0377\u0377"
        + "\u037b\u037d"
        + "\u0390\u0390"
        + "\u03ac\u03ce"
        + "\u03d0\u03d1"
        + "\u03d5\u03d7"
        + "\u03d9\u03d9"
        + "\u03db\u03db"
        + "\u03dd\u03dd"
        + "\u03df\u03df"
        + "\u03e1\u03e1"
        + "\u03e3\u03e3"
        + "\u03e5\u03e5"
        + "\u03e7\u03e7"
        + "\u03e9\u03e9"
        + "\u03eb\u03eb"
        + "\u03ed\u03ed"
        + "\u03ef\u03f3"
        + "\u03f5\u03f5"
        + "\u03f8\u03f8"
        + "\u03fb\u03fb"
        + "\u0430\u045f"
        + "\u0461\u0461"
        + "\u0463\u0463"
        + "\u0465\u0465"
        + "\u0467\u0467"
        + "\u0469\u0469"
        + "\u046b\u046b"
        + "\u046d\u046d"
        + "\u046f\u046f"
        + "\u0471\u0471"
        + "\u0473\u0473"
        + "\u0475\u0475"
        + "\u0477\u0477"
        + "\u0479\u0479"
        + "\u047b\u047b"
        + "\u047d\u047d"
        + "\u047f\u047f"
        + "\u0481\u0481"
        + "\u048b\u048b"
        + "\u048d\u048d"
        + "\u048f\u048f"
        + "\u0491\u0491"
        + "\u0493\u0493"
        + "\u0495\u0495"
        + "\u0497\u0497"
        + "\u0499\u0499"
        + "\u049b\u049b"
        + "\u049d\u049d"
        + "\u049f\u049f"
        + "\u04a1\u04a1"
        + "\u04a3\u04a3"
        + "\u04a5\u04a5"
        + "\u04a7\u04a7"
        + "\u04a9\u04a9"
        + "\u04ab\u04ab"
        + "\u04ad\u04ad"
        + "\u04af\u04af"
        + "\u04b1\u04b1"
        + "\u04b3\u04b3"
        + "\u04b5\u04b5"
        + "\u04b7\u04b7"
        + "\u04b9\u04b9"
        + "\u04bb\u04bb"
        + "\u04bd\u04bd"
        + "\u04bf\u04bf"
        + "\u04c2\u04c2"
        + "\u04c4\u04c4"
        + "\u04c6\u04c6"
        + "\u04c8\u04c8"
        + "\u04ca\u04ca"
        + "\u04cc\u04cc"
        + "\u04ce\u04cf"
        + "\u04d1\u04d1"
        + "\u04d3\u04d3"
        + "\u04d5\u04d5"
        + "\u04d7\u04d7"
        + "\u04d9\u04d9"
        + "\u04db\u04db"
        + "\u04dd\u04dd"
        + "\u04df\u04df"
        + "\u04e1\u04e1"
        + "\u04e3\u04e3"
        + "\u04e5\u04e5"
        + "\u04e7\u04e7"
        + "\u04e9\u04e9"
        + "\u04eb\u04eb"
        + "\u04ed\u04ed"
        + "\u04ef\u04ef"
        + "\u04f1\u04f1"
        + "\u04f3\u04f3"
        + "\u04f5\u04f5"
        + "\u04f7\u04f7"
        + "\u04f9\u04f9"
        + "\u04fb\u04fb"
        + "\u04fd\u04fd"
        + "\u04ff\u04ff"
        + "\u0501\u0501"
        + "\u0503\u0503"
        + "\u0505\u0505"
        + "\u0507\u0507"
        + "\u0509\u0509"
        + "\u050b\u050b"
        + "\u050d\u050d"
        + "\u050f\u050f"
        + "\u0511\u0511"
        + "\u0513\u0513"
        + "\u0515\u0515"
        + "\u0517\u0517"
        + "\u0519\u0519"
        + "\u051b\u051b"
        + "\u051d\u051d"
        + "\u051f\u051f"
        + "\u0521\u0521"
        + "\u0523\u0523"
        + "\u0525\u0525"
        + "\u0527\u0527"
        + "\u0529\u0529"
        + "\u052b\u052b"
        + "\u052d\u052d"
        + "\u052f\u052f"
        + "\u0561\u0587"
        + "\u1d79\u1d79"
        + "\u1d7d\u1d7d"
        + "\u1e01\u1e01"
        + "\u1e03\u1e03"
        + "\u1e05\u1e05"
        + "\u1e07\u1e07"
        + "\u1e09\u1e09"
        + "\u1e0b\u1e0b"
        + "\u1e0d\u1e0d"
        + "\u1e0f\u1e0f"
        + "\u1e11\u1e11"
        + "\u1e13\u1e13"
        + "\u1e15\u1e15"
        + "\u1e17\u1e17"
        + "\u1e19\u1e19"
        + "\u1e1b\u1e1b"
        + "\u1e1d\u1e1d"
        + "\u1e1f\u1e1f"
        + "\u1e21\u1e21"
        + "\u1e23\u1e23"
        + "\u1e25\u1e25"
        + "\u1e27\u1e27"
        + "\u1e29\u1e29"
        + "\u1e2b\u1e2b"
        + "\u1e2d\u1e2d"
        + "\u1e2f\u1e2f"
        + "\u1e31\u1e31"
        + "\u1e33\u1e33"
        + "\u1e35\u1e35"
        + "\u1e37\u1e37"
        + "\u1e39\u1e39"
        + "\u1e3b\u1e3b"
        + "\u1e3d\u1e3d"
        + "\u1e3f\u1e3f"
        + "\u1e41\u1e41"
        + "\u1e43\u1e43"
        + "\u1e45\u1e45"
        + "\u1e47\u1e47"
        + "\u1e49\u1e49"
        + "\u1e4b\u1e4b"
        + "\u1e4d\u1e4d"
        + "\u1e4f\u1e4f"
        + "\u1e51\u1e51"
        + "\u1e53\u1e53"
        + "\u1e55\u1e55"
        + "\u1e57\u1e57"
        + "\u1e59\u1e59"
        + "\u1e5b\u1e5b"
        + "\u1e5d\u1e5d"
        + "\u1e5f\u1e5f"
        + "\u1e61\u1e61"
        + "\u1e63\u1e63"
        + "\u1e65\u1e65"
        + "\u1e67\u1e67"
        + "\u1e69\u1e69"
        + "\u1e6b\u1e6b"
        + "\u1e6d\u1e6d"
        + "\u1e6f\u1e6f"
        + "\u1e71\u1e71"
        + "\u1e73\u1e73"
        + "\u1e75\u1e75"
        + "\u1e77\u1e77"
        + "\u1e79\u1e79"
        + "\u1e7b\u1e7b"
        + "\u1e7d\u1e7d"
        + "\u1e7f\u1e7f"
        + "\u1e81\u1e81"
        + "\u1e83\u1e83"
        + "\u1e85\u1e85"
        + "\u1e87\u1e87"
        + "\u1e89\u1e89"
        + "\u1e8b\u1e8b"
        + "\u1e8d\u1e8d"
        + "\u1e8f\u1e8f"
        + "\u1e91\u1e91"
        + "\u1e93\u1e93"
        + "\u1e95\u1e9b"
        + "\u1ea1\u1ea1"
        + "\u1ea3\u1ea3"
        + "\u1ea5\u1ea5"
        + "\u1ea7\u1ea7"
        + "\u1ea9\u1ea9"
        + "\u1eab\u1eab"
        + "\u1ead\u1ead"
        + "\u1eaf\u1eaf"
        + "\u1eb1\u1eb1"
        + "\u1eb3\u1eb3"
        + "\u1eb5\u1eb5"
        + "\u1eb7\u1eb7"
        + "\u1eb9\u1eb9"
        + "\u1ebb\u1ebb"
        + "\u1ebd\u1ebd"
        + "\u1ebf\u1ebf"
        + "\u1ec1\u1ec1"
        + "\u1ec3\u1ec3"
        + "\u1ec5\u1ec5"
        + "\u1ec7\u1ec7"
        + "\u1ec9\u1ec9"
        + "\u1ecb\u1ecb"
        + "\u1ecd\u1ecd"
        + "\u1ecf\u1ecf"
        + "\u1ed1\u1ed1"
        + "\u1ed3\u1ed3"
        + "\u1ed5\u1ed5"
        + "\u1ed7\u1ed7"
        + "\u1ed9\u1ed9"
        + "\u1edb\u1edb"
        + "\u1edd\u1edd"
        + "\u1edf\u1edf"
        + "\u1ee1\u1ee1"
        + "\u1ee3\u1ee3"
        + "\u1ee5\u1ee5"
        + "\u1ee7\u1ee7"
        + "\u1ee9\u1ee9"
        + "\u1eeb\u1eeb"
        + "\u1eed\u1eed"
        + "\u1eef\u1eef"
        + "\u1ef1\u1ef1"
        + "\u1ef3\u1ef3"
        + "\u1ef5\u1ef5"
        + "\u1ef7\u1ef7"
        + "\u1ef9\u1ef9"
        + "\u1efb\u1efb"
        + "\u1efd\u1efd"
        + "\u1eff\u1f07"
        + "\u1f10\u1f15"
        + "\u1f20\u1f27"
        + "\u1f30\u1f37"
        + "\u1f40\u1f45"
        + "\u1f50\u1f57"
        + "\u1f60\u1f67"
        + "\u1f70\u1f7d"
        + "\u1f80\u1f87"
        + "\u1f90\u1f97"
        + "\u1fa0\u1fa7"
        + "\u1fb0\u1fb4"
        + "\u1fb6\u1fb7"
        + "\u1fbe\u1fbe"
        + "\u1fc2\u1fc4"
        + "\u1fc6\u1fc7"
        + "\u1fd0\u1fd3"
        + "\u1fd6\u1fd7"
        + "\u1fe0\u1fe7"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ff7"
        + "\u214e\u214e"
        + "\u2170\u217f"
        + "\u2184\u2184"
        + "\u24d0\u24e9"
        + "\u2c30\u2c5e"
        + "\u2c61\u2c61"
        + "\u2c65\u2c66"
        + "\u2c68\u2c68"
        + "\u2c6a\u2c6a"
        + "\u2c6c\u2c6c"
        + "\u2c73\u2c73"
        + "\u2c76\u2c76"
        + "\u2c81\u2c81"
        + "\u2c83\u2c83"
        + "\u2c85\u2c85"
        + "\u2c87\u2c87"
        + "\u2c89\u2c89"
        + "\u2c8b\u2c8b"
        + "\u2c8d\u2c8d"
        + "\u2c8f\u2c8f"
        + "\u2c91\u2c91"
        + "\u2c93\u2c93"
        + "\u2c95\u2c95"
        + "\u2c97\u2c97"
        + "\u2c99\u2c99"
        + "\u2c9b\u2c9b"
        + "\u2c9d\u2c9d"
        + "\u2c9f\u2c9f"
        + "\u2ca1\u2ca1"
        + "\u2ca3\u2ca3"
        + "\u2ca5\u2ca5"
        + "\u2ca7\u2ca7"
        + "\u2ca9\u2ca9"
        + "\u2cab\u2cab"
        + "\u2cad\u2cad"
        + "\u2caf\u2caf"
        + "\u2cb1\u2cb1"
        + "\u2cb3\u2cb3"
        + "\u2cb5\u2cb5"
        + "\u2cb7\u2cb7"
        + "\u2cb9\u2cb9"
        + "\u2cbb\u2cbb"
        + "\u2cbd\u2cbd"
        + "\u2cbf\u2cbf"
        + "\u2cc1\u2cc1"
        + "\u2cc3\u2cc3"
        + "\u2cc5\u2cc5"
        + "\u2cc7\u2cc7"
        + "\u2cc9\u2cc9"
        + "\u2ccb\u2ccb"
        + "\u2ccd\u2ccd"
        + "\u2ccf\u2ccf"
        + "\u2cd1\u2cd1"
        + "\u2cd3\u2cd3"
        + "\u2cd5\u2cd5"
        + "\u2cd7\u2cd7"
        + "\u2cd9\u2cd9"
        + "\u2cdb\u2cdb"
        + "\u2cdd\u2cdd"
        + "\u2cdf\u2cdf"
        + "\u2ce1\u2ce1"
        + "\u2ce3\u2ce3"
        + "\u2cec\u2cec"
        + "\u2cee\u2cee"
        + "\u2cf3\u2cf3"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\ua641\ua641"
        + "\ua643\ua643"
        + "\ua645\ua645"
        + "\ua647\ua647"
        + "\ua649\ua649"
        + "\ua64b\ua64b"
        + "\ua64d\ua64d"
        + "\ua64f\ua64f"
        + "\ua651\ua651"
        + "\ua653\ua653"
        + "\ua655\ua655"
        + "\ua657\ua657"
        + "\ua659\ua659"
        + "\ua65b\ua65b"
        + "\ua65d\ua65d"
        + "\ua65f\ua65f"
        + "\ua661\ua661"
        + "\ua663\ua663"
        + "\ua665\ua665"
        + "\ua667\ua667"
        + "\ua669\ua669"
        + "\ua66b\ua66b"
        + "\ua66d\ua66d"
        + "\ua681\ua681"
        + "\ua683\ua683"
        + "\ua685\ua685"
        + "\ua687\ua687"
        + "\ua689\ua689"
        + "\ua68b\ua68b"
        + "\ua68d\ua68d"
        + "\ua68f\ua68f"
        + "\ua691\ua691"
        + "\ua693\ua693"
        + "\ua695\ua695"
        + "\ua697\ua697"
        + "\ua699\ua699"
        + "\ua69b\ua69b"
        + "\ua723\ua723"
        + "\ua725\ua725"
        + "\ua727\ua727"
        + "\ua729\ua729"
        + "\ua72b\ua72b"
        + "\ua72d\ua72d"
        + "\ua72f\ua72f"
        + "\ua733\ua733"
        + "\ua735\ua735"
        + "\ua737\ua737"
        + "\ua739\ua739"
        + "\ua73b\ua73b"
        + "\ua73d\ua73d"
        + "\ua73f\ua73f"
        + "\ua741\ua741"
        + "\ua743\ua743"
        + "\ua745\ua745"
        + "\ua747\ua747"
        + "\ua749\ua749"
        + "\ua74b\ua74b"
        + "\ua74d\ua74d"
        + "\ua74f\ua74f"
        + "\ua751\ua751"
        + "\ua753\ua753"
        + "\ua755\ua755"
        + "\ua757\ua757"
        + "\ua759\ua759"
        + "\ua75b\ua75b"
        + "\ua75d\ua75d"
        + "\ua75f\ua75f"
        + "\ua761\ua761"
        + "\ua763\ua763"
        + "\ua765\ua765"
        + "\ua767\ua767"
        + "\ua769\ua769"
        + "\ua76b\ua76b"
        + "\ua76d\ua76d"
        + "\ua76f\ua76f"
        + "\ua77a\ua77a"
        + "\ua77c\ua77c"
        + "\ua77f\ua77f"
        + "\ua781\ua781"
        + "\ua783\ua783"
        + "\ua785\ua785"
        + "\ua787\ua787"
        + "\ua78c\ua78c"
        + "\ua791\ua791"
        + "\ua793\ua793"
        + "\ua797\ua797"
        + "\ua799\ua799"
        + "\ua79b\ua79b"
        + "\ua79d\ua79d"
        + "\ua79f\ua79f"
        + "\ua7a1\ua7a1"
        + "\ua7a3\ua7a3"
        + "\ua7a5\ua7a5"
        + "\ua7a7\ua7a7"
        + "\ua7a9\ua7a9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\uff41\uff5a"
        + "\ud801\udc28\ud801\udc4f"
        + "\ud806\udcc0\ud806\udcdf",
    // Unicode 7.0 property value: {changeswhenuppercased}
    "\u0061\u007a"
        + "\u00b5\u00b5"
        + "\u00df\u00f6"
        + "\u00f8\u00ff"
        + "\u0101\u0101"
        + "\u0103\u0103"
        + "\u0105\u0105"
        + "\u0107\u0107"
        + "\u0109\u0109"
        + "\u010b\u010b"
        + "\u010d\u010d"
        + "\u010f\u010f"
        + "\u0111\u0111"
        + "\u0113\u0113"
        + "\u0115\u0115"
        + "\u0117\u0117"
        + "\u0119\u0119"
        + "\u011b\u011b"
        + "\u011d\u011d"
        + "\u011f\u011f"
        + "\u0121\u0121"
        + "\u0123\u0123"
        + "\u0125\u0125"
        + "\u0127\u0127"
        + "\u0129\u0129"
        + "\u012b\u012b"
        + "\u012d\u012d"
        + "\u012f\u012f"
        + "\u0131\u0131"
        + "\u0133\u0133"
        + "\u0135\u0135"
        + "\u0137\u0137"
        + "\u013a\u013a"
        + "\u013c\u013c"
        + "\u013e\u013e"
        + "\u0140\u0140"
        + "\u0142\u0142"
        + "\u0144\u0144"
        + "\u0146\u0146"
        + "\u0148\u0149"
        + "\u014b\u014b"
        + "\u014d\u014d"
        + "\u014f\u014f"
        + "\u0151\u0151"
        + "\u0153\u0153"
        + "\u0155\u0155"
        + "\u0157\u0157"
        + "\u0159\u0159"
        + "\u015b\u015b"
        + "\u015d\u015d"
        + "\u015f\u015f"
        + "\u0161\u0161"
        + "\u0163\u0163"
        + "\u0165\u0165"
        + "\u0167\u0167"
        + "\u0169\u0169"
        + "\u016b\u016b"
        + "\u016d\u016d"
        + "\u016f\u016f"
        + "\u0171\u0171"
        + "\u0173\u0173"
        + "\u0175\u0175"
        + "\u0177\u0177"
        + "\u017a\u017a"
        + "\u017c\u017c"
        + "\u017e\u0180"
        + "\u0183\u0183"
        + "\u0185\u0185"
        + "\u0188\u0188"
        + "\u018c\u018c"
        + "\u0192\u0192"
        + "\u0195\u0195"
        + "\u0199\u019a"
        + "\u019e\u019e"
        + "\u01a1\u01a1"
        + "\u01a3\u01a3"
        + "\u01a5\u01a5"
        + "\u01a8\u01a8"
        + "\u01ad\u01ad"
        + "\u01b0\u01b0"
        + "\u01b4\u01b4"
        + "\u01b6\u01b6"
        + "\u01b9\u01b9"
        + "\u01bd\u01bd"
        + "\u01bf\u01bf"
        + "\u01c5\u01c6"
        + "\u01c8\u01c9"
        + "\u01cb\u01cc"
        + "\u01ce\u01ce"
        + "\u01d0\u01d0"
        + "\u01d2\u01d2"
        + "\u01d4\u01d4"
        + "\u01d6\u01d6"
        + "\u01d8\u01d8"
        + "\u01da\u01da"
        + "\u01dc\u01dd"
        + "\u01df\u01df"
        + "\u01e1\u01e1"
        + "\u01e3\u01e3"
        + "\u01e5\u01e5"
        + "\u01e7\u01e7"
        + "\u01e9\u01e9"
        + "\u01eb\u01eb"
        + "\u01ed\u01ed"
        + "\u01ef\u01f0"
        + "\u01f2\u01f3"
        + "\u01f5\u01f5"
        + "\u01f9\u01f9"
        + "\u01fb\u01fb"
        + "\u01fd\u01fd"
        + "\u01ff\u01ff"
        + "\u0201\u0201"
        + "\u0203\u0203"
        + "\u0205\u0205"
        + "\u0207\u0207"
        + "\u0209\u0209"
        + "\u020b\u020b"
        + "\u020d\u020d"
        + "\u020f\u020f"
        + "\u0211\u0211"
        + "\u0213\u0213"
        + "\u0215\u0215"
        + "\u0217\u0217"
        + "\u0219\u0219"
        + "\u021b\u021b"
        + "\u021d\u021d"
        + "\u021f\u021f"
        + "\u0223\u0223"
        + "\u0225\u0225"
        + "\u0227\u0227"
        + "\u0229\u0229"
        + "\u022b\u022b"
        + "\u022d\u022d"
        + "\u022f\u022f"
        + "\u0231\u0231"
        + "\u0233\u0233"
        + "\u023c\u023c"
        + "\u023f\u0240"
        + "\u0242\u0242"
        + "\u0247\u0247"
        + "\u0249\u0249"
        + "\u024b\u024b"
        + "\u024d\u024d"
        + "\u024f\u0254"
        + "\u0256\u0257"
        + "\u0259\u0259"
        + "\u025b\u025c"
        + "\u0260\u0261"
        + "\u0263\u0263"
        + "\u0265\u0266"
        + "\u0268\u0269"
        + "\u026b\u026c"
        + "\u026f\u026f"
        + "\u0271\u0272"
        + "\u0275\u0275"
        + "\u027d\u027d"
        + "\u0280\u0280"
        + "\u0283\u0283"
        + "\u0287\u028c"
        + "\u0292\u0292"
        + "\u029e\u029e"
        + "\u0345\u0345"
        + "\u0371\u0371"
        + "\u0373\u0373"
        + "\u0377\u0377"
        + "\u037b\u037d"
        + "\u0390\u0390"
        + "\u03ac\u03ce"
        + "\u03d0\u03d1"
        + "\u03d5\u03d7"
        + "\u03d9\u03d9"
        + "\u03db\u03db"
        + "\u03dd\u03dd"
        + "\u03df\u03df"
        + "\u03e1\u03e1"
        + "\u03e3\u03e3"
        + "\u03e5\u03e5"
        + "\u03e7\u03e7"
        + "\u03e9\u03e9"
        + "\u03eb\u03eb"
        + "\u03ed\u03ed"
        + "\u03ef\u03f3"
        + "\u03f5\u03f5"
        + "\u03f8\u03f8"
        + "\u03fb\u03fb"
        + "\u0430\u045f"
        + "\u0461\u0461"
        + "\u0463\u0463"
        + "\u0465\u0465"
        + "\u0467\u0467"
        + "\u0469\u0469"
        + "\u046b\u046b"
        + "\u046d\u046d"
        + "\u046f\u046f"
        + "\u0471\u0471"
        + "\u0473\u0473"
        + "\u0475\u0475"
        + "\u0477\u0477"
        + "\u0479\u0479"
        + "\u047b\u047b"
        + "\u047d\u047d"
        + "\u047f\u047f"
        + "\u0481\u0481"
        + "\u048b\u048b"
        + "\u048d\u048d"
        + "\u048f\u048f"
        + "\u0491\u0491"
        + "\u0493\u0493"
        + "\u0495\u0495"
        + "\u0497\u0497"
        + "\u0499\u0499"
        + "\u049b\u049b"
        + "\u049d\u049d"
        + "\u049f\u049f"
        + "\u04a1\u04a1"
        + "\u04a3\u04a3"
        + "\u04a5\u04a5"
        + "\u04a7\u04a7"
        + "\u04a9\u04a9"
        + "\u04ab\u04ab"
        + "\u04ad\u04ad"
        + "\u04af\u04af"
        + "\u04b1\u04b1"
        + "\u04b3\u04b3"
        + "\u04b5\u04b5"
        + "\u04b7\u04b7"
        + "\u04b9\u04b9"
        + "\u04bb\u04bb"
        + "\u04bd\u04bd"
        + "\u04bf\u04bf"
        + "\u04c2\u04c2"
        + "\u04c4\u04c4"
        + "\u04c6\u04c6"
        + "\u04c8\u04c8"
        + "\u04ca\u04ca"
        + "\u04cc\u04cc"
        + "\u04ce\u04cf"
        + "\u04d1\u04d1"
        + "\u04d3\u04d3"
        + "\u04d5\u04d5"
        + "\u04d7\u04d7"
        + "\u04d9\u04d9"
        + "\u04db\u04db"
        + "\u04dd\u04dd"
        + "\u04df\u04df"
        + "\u04e1\u04e1"
        + "\u04e3\u04e3"
        + "\u04e5\u04e5"
        + "\u04e7\u04e7"
        + "\u04e9\u04e9"
        + "\u04eb\u04eb"
        + "\u04ed\u04ed"
        + "\u04ef\u04ef"
        + "\u04f1\u04f1"
        + "\u04f3\u04f3"
        + "\u04f5\u04f5"
        + "\u04f7\u04f7"
        + "\u04f9\u04f9"
        + "\u04fb\u04fb"
        + "\u04fd\u04fd"
        + "\u04ff\u04ff"
        + "\u0501\u0501"
        + "\u0503\u0503"
        + "\u0505\u0505"
        + "\u0507\u0507"
        + "\u0509\u0509"
        + "\u050b\u050b"
        + "\u050d\u050d"
        + "\u050f\u050f"
        + "\u0511\u0511"
        + "\u0513\u0513"
        + "\u0515\u0515"
        + "\u0517\u0517"
        + "\u0519\u0519"
        + "\u051b\u051b"
        + "\u051d\u051d"
        + "\u051f\u051f"
        + "\u0521\u0521"
        + "\u0523\u0523"
        + "\u0525\u0525"
        + "\u0527\u0527"
        + "\u0529\u0529"
        + "\u052b\u052b"
        + "\u052d\u052d"
        + "\u052f\u052f"
        + "\u0561\u0587"
        + "\u1d79\u1d79"
        + "\u1d7d\u1d7d"
        + "\u1e01\u1e01"
        + "\u1e03\u1e03"
        + "\u1e05\u1e05"
        + "\u1e07\u1e07"
        + "\u1e09\u1e09"
        + "\u1e0b\u1e0b"
        + "\u1e0d\u1e0d"
        + "\u1e0f\u1e0f"
        + "\u1e11\u1e11"
        + "\u1e13\u1e13"
        + "\u1e15\u1e15"
        + "\u1e17\u1e17"
        + "\u1e19\u1e19"
        + "\u1e1b\u1e1b"
        + "\u1e1d\u1e1d"
        + "\u1e1f\u1e1f"
        + "\u1e21\u1e21"
        + "\u1e23\u1e23"
        + "\u1e25\u1e25"
        + "\u1e27\u1e27"
        + "\u1e29\u1e29"
        + "\u1e2b\u1e2b"
        + "\u1e2d\u1e2d"
        + "\u1e2f\u1e2f"
        + "\u1e31\u1e31"
        + "\u1e33\u1e33"
        + "\u1e35\u1e35"
        + "\u1e37\u1e37"
        + "\u1e39\u1e39"
        + "\u1e3b\u1e3b"
        + "\u1e3d\u1e3d"
        + "\u1e3f\u1e3f"
        + "\u1e41\u1e41"
        + "\u1e43\u1e43"
        + "\u1e45\u1e45"
        + "\u1e47\u1e47"
        + "\u1e49\u1e49"
        + "\u1e4b\u1e4b"
        + "\u1e4d\u1e4d"
        + "\u1e4f\u1e4f"
        + "\u1e51\u1e51"
        + "\u1e53\u1e53"
        + "\u1e55\u1e55"
        + "\u1e57\u1e57"
        + "\u1e59\u1e59"
        + "\u1e5b\u1e5b"
        + "\u1e5d\u1e5d"
        + "\u1e5f\u1e5f"
        + "\u1e61\u1e61"
        + "\u1e63\u1e63"
        + "\u1e65\u1e65"
        + "\u1e67\u1e67"
        + "\u1e69\u1e69"
        + "\u1e6b\u1e6b"
        + "\u1e6d\u1e6d"
        + "\u1e6f\u1e6f"
        + "\u1e71\u1e71"
        + "\u1e73\u1e73"
        + "\u1e75\u1e75"
        + "\u1e77\u1e77"
        + "\u1e79\u1e79"
        + "\u1e7b\u1e7b"
        + "\u1e7d\u1e7d"
        + "\u1e7f\u1e7f"
        + "\u1e81\u1e81"
        + "\u1e83\u1e83"
        + "\u1e85\u1e85"
        + "\u1e87\u1e87"
        + "\u1e89\u1e89"
        + "\u1e8b\u1e8b"
        + "\u1e8d\u1e8d"
        + "\u1e8f\u1e8f"
        + "\u1e91\u1e91"
        + "\u1e93\u1e93"
        + "\u1e95\u1e9b"
        + "\u1ea1\u1ea1"
        + "\u1ea3\u1ea3"
        + "\u1ea5\u1ea5"
        + "\u1ea7\u1ea7"
        + "\u1ea9\u1ea9"
        + "\u1eab\u1eab"
        + "\u1ead\u1ead"
        + "\u1eaf\u1eaf"
        + "\u1eb1\u1eb1"
        + "\u1eb3\u1eb3"
        + "\u1eb5\u1eb5"
        + "\u1eb7\u1eb7"
        + "\u1eb9\u1eb9"
        + "\u1ebb\u1ebb"
        + "\u1ebd\u1ebd"
        + "\u1ebf\u1ebf"
        + "\u1ec1\u1ec1"
        + "\u1ec3\u1ec3"
        + "\u1ec5\u1ec5"
        + "\u1ec7\u1ec7"
        + "\u1ec9\u1ec9"
        + "\u1ecb\u1ecb"
        + "\u1ecd\u1ecd"
        + "\u1ecf\u1ecf"
        + "\u1ed1\u1ed1"
        + "\u1ed3\u1ed3"
        + "\u1ed5\u1ed5"
        + "\u1ed7\u1ed7"
        + "\u1ed9\u1ed9"
        + "\u1edb\u1edb"
        + "\u1edd\u1edd"
        + "\u1edf\u1edf"
        + "\u1ee1\u1ee1"
        + "\u1ee3\u1ee3"
        + "\u1ee5\u1ee5"
        + "\u1ee7\u1ee7"
        + "\u1ee9\u1ee9"
        + "\u1eeb\u1eeb"
        + "\u1eed\u1eed"
        + "\u1eef\u1eef"
        + "\u1ef1\u1ef1"
        + "\u1ef3\u1ef3"
        + "\u1ef5\u1ef5"
        + "\u1ef7\u1ef7"
        + "\u1ef9\u1ef9"
        + "\u1efb\u1efb"
        + "\u1efd\u1efd"
        + "\u1eff\u1f07"
        + "\u1f10\u1f15"
        + "\u1f20\u1f27"
        + "\u1f30\u1f37"
        + "\u1f40\u1f45"
        + "\u1f50\u1f57"
        + "\u1f60\u1f67"
        + "\u1f70\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fb7"
        + "\u1fbc\u1fbc"
        + "\u1fbe\u1fbe"
        + "\u1fc2\u1fc4"
        + "\u1fc6\u1fc7"
        + "\u1fcc\u1fcc"
        + "\u1fd0\u1fd3"
        + "\u1fd6\u1fd7"
        + "\u1fe0\u1fe7"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ff7"
        + "\u1ffc\u1ffc"
        + "\u214e\u214e"
        + "\u2170\u217f"
        + "\u2184\u2184"
        + "\u24d0\u24e9"
        + "\u2c30\u2c5e"
        + "\u2c61\u2c61"
        + "\u2c65\u2c66"
        + "\u2c68\u2c68"
        + "\u2c6a\u2c6a"
        + "\u2c6c\u2c6c"
        + "\u2c73\u2c73"
        + "\u2c76\u2c76"
        + "\u2c81\u2c81"
        + "\u2c83\u2c83"
        + "\u2c85\u2c85"
        + "\u2c87\u2c87"
        + "\u2c89\u2c89"
        + "\u2c8b\u2c8b"
        + "\u2c8d\u2c8d"
        + "\u2c8f\u2c8f"
        + "\u2c91\u2c91"
        + "\u2c93\u2c93"
        + "\u2c95\u2c95"
        + "\u2c97\u2c97"
        + "\u2c99\u2c99"
        + "\u2c9b\u2c9b"
        + "\u2c9d\u2c9d"
        + "\u2c9f\u2c9f"
        + "\u2ca1\u2ca1"
        + "\u2ca3\u2ca3"
        + "\u2ca5\u2ca5"
        + "\u2ca7\u2ca7"
        + "\u2ca9\u2ca9"
        + "\u2cab\u2cab"
        + "\u2cad\u2cad"
        + "\u2caf\u2caf"
        + "\u2cb1\u2cb1"
        + "\u2cb3\u2cb3"
        + "\u2cb5\u2cb5"
        + "\u2cb7\u2cb7"
        + "\u2cb9\u2cb9"
        + "\u2cbb\u2cbb"
        + "\u2cbd\u2cbd"
        + "\u2cbf\u2cbf"
        + "\u2cc1\u2cc1"
        + "\u2cc3\u2cc3"
        + "\u2cc5\u2cc5"
        + "\u2cc7\u2cc7"
        + "\u2cc9\u2cc9"
        + "\u2ccb\u2ccb"
        + "\u2ccd\u2ccd"
        + "\u2ccf\u2ccf"
        + "\u2cd1\u2cd1"
        + "\u2cd3\u2cd3"
        + "\u2cd5\u2cd5"
        + "\u2cd7\u2cd7"
        + "\u2cd9\u2cd9"
        + "\u2cdb\u2cdb"
        + "\u2cdd\u2cdd"
        + "\u2cdf\u2cdf"
        + "\u2ce1\u2ce1"
        + "\u2ce3\u2ce3"
        + "\u2cec\u2cec"
        + "\u2cee\u2cee"
        + "\u2cf3\u2cf3"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\ua641\ua641"
        + "\ua643\ua643"
        + "\ua645\ua645"
        + "\ua647\ua647"
        + "\ua649\ua649"
        + "\ua64b\ua64b"
        + "\ua64d\ua64d"
        + "\ua64f\ua64f"
        + "\ua651\ua651"
        + "\ua653\ua653"
        + "\ua655\ua655"
        + "\ua657\ua657"
        + "\ua659\ua659"
        + "\ua65b\ua65b"
        + "\ua65d\ua65d"
        + "\ua65f\ua65f"
        + "\ua661\ua661"
        + "\ua663\ua663"
        + "\ua665\ua665"
        + "\ua667\ua667"
        + "\ua669\ua669"
        + "\ua66b\ua66b"
        + "\ua66d\ua66d"
        + "\ua681\ua681"
        + "\ua683\ua683"
        + "\ua685\ua685"
        + "\ua687\ua687"
        + "\ua689\ua689"
        + "\ua68b\ua68b"
        + "\ua68d\ua68d"
        + "\ua68f\ua68f"
        + "\ua691\ua691"
        + "\ua693\ua693"
        + "\ua695\ua695"
        + "\ua697\ua697"
        + "\ua699\ua699"
        + "\ua69b\ua69b"
        + "\ua723\ua723"
        + "\ua725\ua725"
        + "\ua727\ua727"
        + "\ua729\ua729"
        + "\ua72b\ua72b"
        + "\ua72d\ua72d"
        + "\ua72f\ua72f"
        + "\ua733\ua733"
        + "\ua735\ua735"
        + "\ua737\ua737"
        + "\ua739\ua739"
        + "\ua73b\ua73b"
        + "\ua73d\ua73d"
        + "\ua73f\ua73f"
        + "\ua741\ua741"
        + "\ua743\ua743"
        + "\ua745\ua745"
        + "\ua747\ua747"
        + "\ua749\ua749"
        + "\ua74b\ua74b"
        + "\ua74d\ua74d"
        + "\ua74f\ua74f"
        + "\ua751\ua751"
        + "\ua753\ua753"
        + "\ua755\ua755"
        + "\ua757\ua757"
        + "\ua759\ua759"
        + "\ua75b\ua75b"
        + "\ua75d\ua75d"
        + "\ua75f\ua75f"
        + "\ua761\ua761"
        + "\ua763\ua763"
        + "\ua765\ua765"
        + "\ua767\ua767"
        + "\ua769\ua769"
        + "\ua76b\ua76b"
        + "\ua76d\ua76d"
        + "\ua76f\ua76f"
        + "\ua77a\ua77a"
        + "\ua77c\ua77c"
        + "\ua77f\ua77f"
        + "\ua781\ua781"
        + "\ua783\ua783"
        + "\ua785\ua785"
        + "\ua787\ua787"
        + "\ua78c\ua78c"
        + "\ua791\ua791"
        + "\ua793\ua793"
        + "\ua797\ua797"
        + "\ua799\ua799"
        + "\ua79b\ua79b"
        + "\ua79d\ua79d"
        + "\ua79f\ua79f"
        + "\ua7a1\ua7a1"
        + "\ua7a3\ua7a3"
        + "\ua7a5\ua7a5"
        + "\ua7a7\ua7a7"
        + "\ua7a9\ua7a9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\uff41\uff5a"
        + "\ud801\udc28\ud801\udc4f"
        + "\ud806\udcc0\ud806\udcdf",
    // Unicode 7.0 property value: {cherokee}
    "\u13a0\u13f4",
    // Unicode 7.0 property value: {cn}
    "\u0378\u0379"
        + "\u0380\u0383"
        + "\u038b\u038b"
        + "\u038d\u038d"
        + "\u03a2\u03a2"
        + "\u0530\u0530"
        + "\u0557\u0558"
        + "\u0560\u0560"
        + "\u0588\u0588"
        + "\u058b\u058c"
        + "\u0590\u0590"
        + "\u05c8\u05cf"
        + "\u05eb\u05ef"
        + "\u05f5\u05ff"
        + "\u061d\u061d"
        + "\u070e\u070e"
        + "\u074b\u074c"
        + "\u07b2\u07bf"
        + "\u07fb\u07ff"
        + "\u082e\u082f"
        + "\u083f\u083f"
        + "\u085c\u085d"
        + "\u085f\u089f"
        + "\u08b3\u08e3"
        + "\u0984\u0984"
        + "\u098d\u098e"
        + "\u0991\u0992"
        + "\u09a9\u09a9"
        + "\u09b1\u09b1"
        + "\u09b3\u09b5"
        + "\u09ba\u09bb"
        + "\u09c5\u09c6"
        + "\u09c9\u09ca"
        + "\u09cf\u09d6"
        + "\u09d8\u09db"
        + "\u09de\u09de"
        + "\u09e4\u09e5"
        + "\u09fc\u0a00"
        + "\u0a04\u0a04"
        + "\u0a0b\u0a0e"
        + "\u0a11\u0a12"
        + "\u0a29\u0a29"
        + "\u0a31\u0a31"
        + "\u0a34\u0a34"
        + "\u0a37\u0a37"
        + "\u0a3a\u0a3b"
        + "\u0a3d\u0a3d"
        + "\u0a43\u0a46"
        + "\u0a49\u0a4a"
        + "\u0a4e\u0a50"
        + "\u0a52\u0a58"
        + "\u0a5d\u0a5d"
        + "\u0a5f\u0a65"
        + "\u0a76\u0a80"
        + "\u0a84\u0a84"
        + "\u0a8e\u0a8e"
        + "\u0a92\u0a92"
        + "\u0aa9\u0aa9"
        + "\u0ab1\u0ab1"
        + "\u0ab4\u0ab4"
        + "\u0aba\u0abb"
        + "\u0ac6\u0ac6"
        + "\u0aca\u0aca"
        + "\u0ace\u0acf"
        + "\u0ad1\u0adf"
        + "\u0ae4\u0ae5"
        + "\u0af2\u0b00"
        + "\u0b04\u0b04"
        + "\u0b0d\u0b0e"
        + "\u0b11\u0b12"
        + "\u0b29\u0b29"
        + "\u0b31\u0b31"
        + "\u0b34\u0b34"
        + "\u0b3a\u0b3b"
        + "\u0b45\u0b46"
        + "\u0b49\u0b4a"
        + "\u0b4e\u0b55"
        + "\u0b58\u0b5b"
        + "\u0b5e\u0b5e"
        + "\u0b64\u0b65"
        + "\u0b78\u0b81"
        + "\u0b84\u0b84"
        + "\u0b8b\u0b8d"
        + "\u0b91\u0b91"
        + "\u0b96\u0b98"
        + "\u0b9b\u0b9b"
        + "\u0b9d\u0b9d"
        + "\u0ba0\u0ba2"
        + "\u0ba5\u0ba7"
        + "\u0bab\u0bad"
        + "\u0bba\u0bbd"
        + "\u0bc3\u0bc5"
        + "\u0bc9\u0bc9"
        + "\u0bce\u0bcf"
        + "\u0bd1\u0bd6"
        + "\u0bd8\u0be5"
        + "\u0bfb\u0bff"
        + "\u0c04\u0c04"
        + "\u0c0d\u0c0d"
        + "\u0c11\u0c11"
        + "\u0c29\u0c29"
        + "\u0c3a\u0c3c"
        + "\u0c45\u0c45"
        + "\u0c49\u0c49"
        + "\u0c4e\u0c54"
        + "\u0c57\u0c57"
        + "\u0c5a\u0c5f"
        + "\u0c64\u0c65"
        + "\u0c70\u0c77"
        + "\u0c80\u0c80"
        + "\u0c84\u0c84"
        + "\u0c8d\u0c8d"
        + "\u0c91\u0c91"
        + "\u0ca9\u0ca9"
        + "\u0cb4\u0cb4"
        + "\u0cba\u0cbb"
        + "\u0cc5\u0cc5"
        + "\u0cc9\u0cc9"
        + "\u0cce\u0cd4"
        + "\u0cd7\u0cdd"
        + "\u0cdf\u0cdf"
        + "\u0ce4\u0ce5"
        + "\u0cf0\u0cf0"
        + "\u0cf3\u0d00"
        + "\u0d04\u0d04"
        + "\u0d0d\u0d0d"
        + "\u0d11\u0d11"
        + "\u0d3b\u0d3c"
        + "\u0d45\u0d45"
        + "\u0d49\u0d49"
        + "\u0d4f\u0d56"
        + "\u0d58\u0d5f"
        + "\u0d64\u0d65"
        + "\u0d76\u0d78"
        + "\u0d80\u0d81"
        + "\u0d84\u0d84"
        + "\u0d97\u0d99"
        + "\u0db2\u0db2"
        + "\u0dbc\u0dbc"
        + "\u0dbe\u0dbf"
        + "\u0dc7\u0dc9"
        + "\u0dcb\u0dce"
        + "\u0dd5\u0dd5"
        + "\u0dd7\u0dd7"
        + "\u0de0\u0de5"
        + "\u0df0\u0df1"
        + "\u0df5\u0e00"
        + "\u0e3b\u0e3e"
        + "\u0e5c\u0e80"
        + "\u0e83\u0e83"
        + "\u0e85\u0e86"
        + "\u0e89\u0e89"
        + "\u0e8b\u0e8c"
        + "\u0e8e\u0e93"
        + "\u0e98\u0e98"
        + "\u0ea0\u0ea0"
        + "\u0ea4\u0ea4"
        + "\u0ea6\u0ea6"
        + "\u0ea8\u0ea9"
        + "\u0eac\u0eac"
        + "\u0eba\u0eba"
        + "\u0ebe\u0ebf"
        + "\u0ec5\u0ec5"
        + "\u0ec7\u0ec7"
        + "\u0ece\u0ecf"
        + "\u0eda\u0edb"
        + "\u0ee0\u0eff"
        + "\u0f48\u0f48"
        + "\u0f6d\u0f70"
        + "\u0f98\u0f98"
        + "\u0fbd\u0fbd"
        + "\u0fcd\u0fcd"
        + "\u0fdb\u0fff"
        + "\u10c6\u10c6"
        + "\u10c8\u10cc"
        + "\u10ce\u10cf"
        + "\u1249\u1249"
        + "\u124e\u124f"
        + "\u1257\u1257"
        + "\u1259\u1259"
        + "\u125e\u125f"
        + "\u1289\u1289"
        + "\u128e\u128f"
        + "\u12b1\u12b1"
        + "\u12b6\u12b7"
        + "\u12bf\u12bf"
        + "\u12c1\u12c1"
        + "\u12c6\u12c7"
        + "\u12d7\u12d7"
        + "\u1311\u1311"
        + "\u1316\u1317"
        + "\u135b\u135c"
        + "\u137d\u137f"
        + "\u139a\u139f"
        + "\u13f5\u13ff"
        + "\u169d\u169f"
        + "\u16f9\u16ff"
        + "\u170d\u170d"
        + "\u1715\u171f"
        + "\u1737\u173f"
        + "\u1754\u175f"
        + "\u176d\u176d"
        + "\u1771\u1771"
        + "\u1774\u177f"
        + "\u17de\u17df"
        + "\u17ea\u17ef"
        + "\u17fa\u17ff"
        + "\u180f\u180f"
        + "\u181a\u181f"
        + "\u1878\u187f"
        + "\u18ab\u18af"
        + "\u18f6\u18ff"
        + "\u191f\u191f"
        + "\u192c\u192f"
        + "\u193c\u193f"
        + "\u1941\u1943"
        + "\u196e\u196f"
        + "\u1975\u197f"
        + "\u19ac\u19af"
        + "\u19ca\u19cf"
        + "\u19db\u19dd"
        + "\u1a1c\u1a1d"
        + "\u1a5f\u1a5f"
        + "\u1a7d\u1a7e"
        + "\u1a8a\u1a8f"
        + "\u1a9a\u1a9f"
        + "\u1aae\u1aaf"
        + "\u1abf\u1aff"
        + "\u1b4c\u1b4f"
        + "\u1b7d\u1b7f"
        + "\u1bf4\u1bfb"
        + "\u1c38\u1c3a"
        + "\u1c4a\u1c4c"
        + "\u1c80\u1cbf"
        + "\u1cc8\u1ccf"
        + "\u1cf7\u1cf7"
        + "\u1cfa\u1cff"
        + "\u1df6\u1dfb"
        + "\u1f16\u1f17"
        + "\u1f1e\u1f1f"
        + "\u1f46\u1f47"
        + "\u1f4e\u1f4f"
        + "\u1f58\u1f58"
        + "\u1f5a\u1f5a"
        + "\u1f5c\u1f5c"
        + "\u1f5e\u1f5e"
        + "\u1f7e\u1f7f"
        + "\u1fb5\u1fb5"
        + "\u1fc5\u1fc5"
        + "\u1fd4\u1fd5"
        + "\u1fdc\u1fdc"
        + "\u1ff0\u1ff1"
        + "\u1ff5\u1ff5"
        + "\u1fff\u1fff"
        + "\u2065\u2065"
        + "\u2072\u2073"
        + "\u208f\u208f"
        + "\u209d\u209f"
        + "\u20be\u20cf"
        + "\u20f1\u20ff"
        + "\u218a\u218f"
        + "\u23fb\u23ff"
        + "\u2427\u243f"
        + "\u244b\u245f"
        + "\u2b74\u2b75"
        + "\u2b96\u2b97"
        + "\u2bba\u2bbc"
        + "\u2bc9\u2bc9"
        + "\u2bd2\u2bff"
        + "\u2c2f\u2c2f"
        + "\u2c5f\u2c5f"
        + "\u2cf4\u2cf8"
        + "\u2d26\u2d26"
        + "\u2d28\u2d2c"
        + "\u2d2e\u2d2f"
        + "\u2d68\u2d6e"
        + "\u2d71\u2d7e"
        + "\u2d97\u2d9f"
        + "\u2da7\u2da7"
        + "\u2daf\u2daf"
        + "\u2db7\u2db7"
        + "\u2dbf\u2dbf"
        + "\u2dc7\u2dc7"
        + "\u2dcf\u2dcf"
        + "\u2dd7\u2dd7"
        + "\u2ddf\u2ddf"
        + "\u2e43\u2e7f"
        + "\u2e9a\u2e9a"
        + "\u2ef4\u2eff"
        + "\u2fd6\u2fef"
        + "\u2ffc\u2fff"
        + "\u3040\u3040"
        + "\u3097\u3098"
        + "\u3100\u3104"
        + "\u312e\u3130"
        + "\u318f\u318f"
        + "\u31bb\u31bf"
        + "\u31e4\u31ef"
        + "\u321f\u321f"
        + "\u32ff\u32ff"
        + "\u4db6\u4dbf"
        + "\u9fcd\u9fff"
        + "\ua48d\ua48f"
        + "\ua4c7\ua4cf"
        + "\ua62c\ua63f"
        + "\ua69e\ua69e"
        + "\ua6f8\ua6ff"
        + "\ua78f\ua78f"
        + "\ua7ae\ua7af"
        + "\ua7b2\ua7f6"
        + "\ua82c\ua82f"
        + "\ua83a\ua83f"
        + "\ua878\ua87f"
        + "\ua8c5\ua8cd"
        + "\ua8da\ua8df"
        + "\ua8fc\ua8ff"
        + "\ua954\ua95e"
        + "\ua97d\ua97f"
        + "\ua9ce\ua9ce"
        + "\ua9da\ua9dd"
        + "\ua9ff\ua9ff"
        + "\uaa37\uaa3f"
        + "\uaa4e\uaa4f"
        + "\uaa5a\uaa5b"
        + "\uaac3\uaada"
        + "\uaaf7\uab00"
        + "\uab07\uab08"
        + "\uab0f\uab10"
        + "\uab17\uab1f"
        + "\uab27\uab27"
        + "\uab2f\uab2f"
        + "\uab60\uab63"
        + "\uab66\uabbf"
        + "\uabee\uabef"
        + "\uabfa\uabff"
        + "\ud7a4\ud7af"
        + "\ud7c7\ud7ca"
        + "\ud7fc\ud7ff"
        + "\ufa6e\ufa6f"
        + "\ufada\ufaff"
        + "\ufb07\ufb12"
        + "\ufb18\ufb1c"
        + "\ufb37\ufb37"
        + "\ufb3d\ufb3d"
        + "\ufb3f\ufb3f"
        + "\ufb42\ufb42"
        + "\ufb45\ufb45"
        + "\ufbc2\ufbd2"
        + "\ufd40\ufd4f"
        + "\ufd90\ufd91"
        + "\ufdc8\ufdef"
        + "\ufdfe\ufdff"
        + "\ufe1a\ufe1f"
        + "\ufe2e\ufe2f"
        + "\ufe53\ufe53"
        + "\ufe67\ufe67"
        + "\ufe6c\ufe6f"
        + "\ufe75\ufe75"
        + "\ufefd\ufefe"
        + "\uff00\uff00"
        + "\uffbf\uffc1"
        + "\uffc8\uffc9"
        + "\uffd0\uffd1"
        + "\uffd8\uffd9"
        + "\uffdd\uffdf"
        + "\uffe7\uffe7"
        + "\uffef\ufff8"
        + "\ufffe\uffff"
        + "\ud800\udc0c\ud800\udc0c"
        + "\ud800\udc27\ud800\udc27"
        + "\ud800\udc3b\ud800\udc3b"
        + "\ud800\udc3e\ud800\udc3e"
        + "\ud800\udc4e\ud800\udc4f"
        + "\ud800\udc5e\ud800\udc7f"
        + "\ud800\udcfb\ud800\udcff"
        + "\ud800\udd03\ud800\udd06"
        + "\ud800\udd34\ud800\udd36"
        + "\ud800\udd8d\ud800\udd8f"
        + "\ud800\udd9c\ud800\udd9f"
        + "\ud800\udda1\ud800\uddcf"
        + "\ud800\uddfe\ud800\ude7f"
        + "\ud800\ude9d\ud800\ude9f"
        + "\ud800\uded1\ud800\udedf"
        + "\ud800\udefc\ud800\udeff"
        + "\ud800\udf24\ud800\udf2f"
        + "\ud800\udf4b\ud800\udf4f"
        + "\ud800\udf7b\ud800\udf7f"
        + "\ud800\udf9e\ud800\udf9e"
        + "\ud800\udfc4\ud800\udfc7"
        + "\ud800\udfd6\ud800\udfff"
        + "\ud801\udc9e\ud801\udc9f"
        + "\ud801\udcaa\ud801\udcff"
        + "\ud801\udd28\ud801\udd2f"
        + "\ud801\udd64\ud801\udd6e"
        + "\ud801\udd70\ud801\uddff"
        + "\ud801\udf37\ud801\udf3f"
        + "\ud801\udf56\ud801\udf5f"
        + "\ud801\udf68\ud801\udfff"
        + "\ud802\udc06\ud802\udc07"
        + "\ud802\udc09\ud802\udc09"
        + "\ud802\udc36\ud802\udc36"
        + "\ud802\udc39\ud802\udc3b"
        + "\ud802\udc3d\ud802\udc3e"
        + "\ud802\udc56\ud802\udc56"
        + "\ud802\udc9f\ud802\udca6"
        + "\ud802\udcb0\ud802\udcff"
        + "\ud802\udd1c\ud802\udd1e"
        + "\ud802\udd3a\ud802\udd3e"
        + "\ud802\udd40\ud802\udd7f"
        + "\ud802\uddb8\ud802\uddbd"
        + "\ud802\uddc0\ud802\uddff"
        + "\ud802\ude04\ud802\ude04"
        + "\ud802\ude07\ud802\ude0b"
        + "\ud802\ude14\ud802\ude14"
        + "\ud802\ude18\ud802\ude18"
        + "\ud802\ude34\ud802\ude37"
        + "\ud802\ude3b\ud802\ude3e"
        + "\ud802\ude48\ud802\ude4f"
        + "\ud802\ude59\ud802\ude5f"
        + "\ud802\udea0\ud802\udebf"
        + "\ud802\udee7\ud802\udeea"
        + "\ud802\udef7\ud802\udeff"
        + "\ud802\udf36\ud802\udf38"
        + "\ud802\udf56\ud802\udf57"
        + "\ud802\udf73\ud802\udf77"
        + "\ud802\udf92\ud802\udf98"
        + "\ud802\udf9d\ud802\udfa8"
        + "\ud802\udfb0\ud802\udfff"
        + "\ud803\udc49\ud803\ude5f"
        + "\ud803\ude7f\ud803\udfff"
        + "\ud804\udc4e\ud804\udc51"
        + "\ud804\udc70\ud804\udc7e"
        + "\ud804\udcc2\ud804\udccf"
        + "\ud804\udce9\ud804\udcef"
        + "\ud804\udcfa\ud804\udcff"
        + "\ud804\udd35\ud804\udd35"
        + "\ud804\udd44\ud804\udd4f"
        + "\ud804\udd77\ud804\udd7f"
        + "\ud804\uddc9\ud804\uddcc"
        + "\ud804\uddce\ud804\uddcf"
        + "\ud804\udddb\ud804\udde0"
        + "\ud804\uddf5\ud804\uddff"
        + "\ud804\ude12\ud804\ude12"
        + "\ud804\ude3e\ud804\udeaf"
        + "\ud804\udeeb\ud804\udeef"
        + "\ud804\udefa\ud804\udf00"
        + "\ud804\udf04\ud804\udf04"
        + "\ud804\udf0d\ud804\udf0e"
        + "\ud804\udf11\ud804\udf12"
        + "\ud804\udf29\ud804\udf29"
        + "\ud804\udf31\ud804\udf31"
        + "\ud804\udf34\ud804\udf34"
        + "\ud804\udf3a\ud804\udf3b"
        + "\ud804\udf45\ud804\udf46"
        + "\ud804\udf49\ud804\udf4a"
        + "\ud804\udf4e\ud804\udf56"
        + "\ud804\udf58\ud804\udf5c"
        + "\ud804\udf64\ud804\udf65"
        + "\ud804\udf6d\ud804\udf6f"
        + "\ud804\udf75\ud805\udc7f"
        + "\ud805\udcc8\ud805\udccf"
        + "\ud805\udcda\ud805\udd7f"
        + "\ud805\uddb6\ud805\uddb7"
        + "\ud805\uddca\ud805\uddff"
        + "\ud805\ude45\ud805\ude4f"
        + "\ud805\ude5a\ud805\ude7f"
        + "\ud805\udeb8\ud805\udebf"
        + "\ud805\udeca\ud806\udc9f"
        + "\ud806\udcf3\ud806\udcfe"
        + "\ud806\udd00\ud806\udebf"
        + "\ud806\udef9\ud807\udfff"
        + "\ud808\udf99\ud808\udfff"
        + "\ud809\udc6f\ud809\udc6f"
        + "\ud809\udc75\ud80b\udfff"
        + "\ud80d\udc2f\ud819\udfff"
        + "\ud81a\ude39\ud81a\ude3f"
        + "\ud81a\ude5f\ud81a\ude5f"
        + "\ud81a\ude6a\ud81a\ude6d"
        + "\ud81a\ude70\ud81a\udecf"
        + "\ud81a\udeee\ud81a\udeef"
        + "\ud81a\udef6\ud81a\udeff"
        + "\ud81a\udf46\ud81a\udf4f"
        + "\ud81a\udf5a\ud81a\udf5a"
        + "\ud81a\udf62\ud81a\udf62"
        + "\ud81a\udf78\ud81a\udf7c"
        + "\ud81a\udf90\ud81b\udeff"
        + "\ud81b\udf45\ud81b\udf4f"
        + "\ud81b\udf7f\ud81b\udf8e"
        + "\ud81b\udfa0\ud82b\udfff"
        + "\ud82c\udc02\ud82e\udfff"
        + "\ud82f\udc6b\ud82f\udc6f"
        + "\ud82f\udc7d\ud82f\udc7f"
        + "\ud82f\udc89\ud82f\udc8f"
        + "\ud82f\udc9a\ud82f\udc9b"
        + "\ud82f\udca4\ud833\udfff"
        + "\ud834\udcf6\ud834\udcff"
        + "\ud834\udd27\ud834\udd28"
        + "\ud834\uddde\ud834\uddff"
        + "\ud834\ude46\ud834\udeff"
        + "\ud834\udf57\ud834\udf5f"
        + "\ud834\udf72\ud834\udfff"
        + "\ud835\udc55\ud835\udc55"
        + "\ud835\udc9d\ud835\udc9d"
        + "\ud835\udca0\ud835\udca1"
        + "\ud835\udca3\ud835\udca4"
        + "\ud835\udca7\ud835\udca8"
        + "\ud835\udcad\ud835\udcad"
        + "\ud835\udcba\ud835\udcba"
        + "\ud835\udcbc\ud835\udcbc"
        + "\ud835\udcc4\ud835\udcc4"
        + "\ud835\udd06\ud835\udd06"
        + "\ud835\udd0b\ud835\udd0c"
        + "\ud835\udd15\ud835\udd15"
        + "\ud835\udd1d\ud835\udd1d"
        + "\ud835\udd3a\ud835\udd3a"
        + "\ud835\udd3f\ud835\udd3f"
        + "\ud835\udd45\ud835\udd45"
        + "\ud835\udd47\ud835\udd49"
        + "\ud835\udd51\ud835\udd51"
        + "\ud835\udea6\ud835\udea7"
        + "\ud835\udfcc\ud835\udfcd"
        + "\ud836\udc00\ud839\udfff"
        + "\ud83a\udcc5\ud83a\udcc6"
        + "\ud83a\udcd7\ud83b\uddff"
        + "\ud83b\ude04\ud83b\ude04"
        + "\ud83b\ude20\ud83b\ude20"
        + "\ud83b\ude23\ud83b\ude23"
        + "\ud83b\ude25\ud83b\ude26"
        + "\ud83b\ude28\ud83b\ude28"
        + "\ud83b\ude33\ud83b\ude33"
        + "\ud83b\ude38\ud83b\ude38"
        + "\ud83b\ude3a\ud83b\ude3a"
        + "\ud83b\ude3c\ud83b\ude41"
        + "\ud83b\ude43\ud83b\ude46"
        + "\ud83b\ude48\ud83b\ude48"
        + "\ud83b\ude4a\ud83b\ude4a"
        + "\ud83b\ude4c\ud83b\ude4c"
        + "\ud83b\ude50\ud83b\ude50"
        + "\ud83b\ude53\ud83b\ude53"
        + "\ud83b\ude55\ud83b\ude56"
        + "\ud83b\ude58\ud83b\ude58"
        + "\ud83b\ude5a\ud83b\ude5a"
        + "\ud83b\ude5c\ud83b\ude5c"
        + "\ud83b\ude5e\ud83b\ude5e"
        + "\ud83b\ude60\ud83b\ude60"
        + "\ud83b\ude63\ud83b\ude63"
        + "\ud83b\ude65\ud83b\ude66"
        + "\ud83b\ude6b\ud83b\ude6b"
        + "\ud83b\ude73\ud83b\ude73"
        + "\ud83b\ude78\ud83b\ude78"
        + "\ud83b\ude7d\ud83b\ude7d"
        + "\ud83b\ude7f\ud83b\ude7f"
        + "\ud83b\ude8a\ud83b\ude8a"
        + "\ud83b\ude9c\ud83b\udea0"
        + "\ud83b\udea4\ud83b\udea4"
        + "\ud83b\udeaa\ud83b\udeaa"
        + "\ud83b\udebc\ud83b\udeef"
        + "\ud83b\udef2\ud83b\udfff"
        + "\ud83c\udc2c\ud83c\udc2f"
        + "\ud83c\udc94\ud83c\udc9f"
        + "\ud83c\udcaf\ud83c\udcb0"
        + "\ud83c\udcc0\ud83c\udcc0"
        + "\ud83c\udcd0\ud83c\udcd0"
        + "\ud83c\udcf6\ud83c\udcff"
        + "\ud83c\udd0d\ud83c\udd0f"
        + "\ud83c\udd2f\ud83c\udd2f"
        + "\ud83c\udd6c\ud83c\udd6f"
        + "\ud83c\udd9b\ud83c\udde5"
        + "\ud83c\ude03\ud83c\ude0f"
        + "\ud83c\ude3b\ud83c\ude3f"
        + "\ud83c\ude49\ud83c\ude4f"
        + "\ud83c\ude52\ud83c\udeff"
        + "\ud83c\udf2d\ud83c\udf2f"
        + "\ud83c\udf7e\ud83c\udf7f"
        + "\ud83c\udfcf\ud83c\udfd3"
        + "\ud83c\udff8\ud83c\udfff"
        + "\ud83d\udcff\ud83d\udcff"
        + "\ud83d\udd4b\ud83d\udd4f"
        + "\ud83d\udd7a\ud83d\udd7a"
        + "\ud83d\udda4\ud83d\udda4"
        + "\ud83d\ude43\ud83d\ude44"
        + "\ud83d\uded0\ud83d\udedf"
        + "\ud83d\udeed\ud83d\udeef"
        + "\ud83d\udef4\ud83d\udeff"
        + "\ud83d\udf74\ud83d\udf7f"
        + "\ud83d\udfd5\ud83d\udfff"
        + "\ud83e\udc0c\ud83e\udc0f"
        + "\ud83e\udc48\ud83e\udc4f"
        + "\ud83e\udc5a\ud83e\udc5f"
        + "\ud83e\udc88\ud83e\udc8f"
        + "\ud83e\udcae\ud83f\udfff"
        + "\ud869\uded7\ud869\udeff"
        + "\ud86d\udf35\ud86d\udf3f"
        + "\ud86e\udc1e\ud87d\udfff"
        + "\ud87e\ude1e\udb40\udc00"
        + "\udb40\udc02\udb40\udc1f"
        + "\udb40\udc80\udb40\udcff"
        + "\udb40\uddf0\udb7f\udfff"
        + "\udbbf\udffe\udbbf\udfff"
        + "\udbff\udffe\udbff\udfff",
    // Unicode 7.0 property value: {co}
    "\ue000\uf8ff" + "\udb80\udc00\udbbf\udffd" + "\udbc0\udc00\udbff\udffd",
    // Unicode 7.0 property value: {common}
    "\000\u0040"
        + "\u005b\u0060"
        + "\u007b\u00a9"
        + "\u00ab\u00b9"
        + "\u00bb\u00bf"
        + "\u00d7\u00d7"
        + "\u00f7\u00f7"
        + "\u02b9\u02df"
        + "\u02e5\u02e9"
        + "\u02ec\u02ff"
        + "\u0374\u0374"
        + "\u037e\u037e"
        + "\u0385\u0385"
        + "\u0387\u0387"
        + "\u0589\u0589"
        + "\u0605\u0605"
        + "\u060c\u060c"
        + "\u061b\u061c"
        + "\u061f\u061f"
        + "\u0640\u0640"
        + "\u0660\u0669"
        + "\u06dd\u06dd"
        + "\u0964\u0965"
        + "\u0e3f\u0e3f"
        + "\u0fd5\u0fd8"
        + "\u10fb\u10fb"
        + "\u16eb\u16ed"
        + "\u1735\u1736"
        + "\u1802\u1803"
        + "\u1805\u1805"
        + "\u1cd3\u1cd3"
        + "\u1ce1\u1ce1"
        + "\u1ce9\u1cec"
        + "\u1cee\u1cf3"
        + "\u1cf5\u1cf6"
        + "\u2000\u200b"
        + "\u200e\u2064"
        + "\u2066\u2070"
        + "\u2074\u207e"
        + "\u2080\u208e"
        + "\u20a0\u20bd"
        + "\u2100\u2125"
        + "\u2127\u2129"
        + "\u212c\u2131"
        + "\u2133\u214d"
        + "\u214f\u215f"
        + "\u2189\u2189"
        + "\u2190\u23fa"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u27ff"
        + "\u2900\u2b73"
        + "\u2b76\u2b95"
        + "\u2b98\u2bb9"
        + "\u2bbd\u2bc8"
        + "\u2bca\u2bd1"
        + "\u2e00\u2e42"
        + "\u2ff0\u2ffb"
        + "\u3000\u3004"
        + "\u3006\u3006"
        + "\u3008\u3020"
        + "\u3030\u3037"
        + "\u303c\u303f"
        + "\u309b\u309c"
        + "\u30a0\u30a0"
        + "\u30fb\u30fc"
        + "\u3190\u319f"
        + "\u31c0\u31e3"
        + "\u3220\u325f"
        + "\u327f\u32cf"
        + "\u3358\u33ff"
        + "\u4dc0\u4dff"
        + "\ua700\ua721"
        + "\ua788\ua78a"
        + "\ua830\ua839"
        + "\ua92e\ua92e"
        + "\ua9cf\ua9cf"
        + "\uab5b\uab5b"
        + "\ufd3e\ufd3f"
        + "\ufe10\ufe19"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufeff\ufeff"
        + "\uff01\uff20"
        + "\uff3b\uff40"
        + "\uff5b\uff65"
        + "\uff70\uff70"
        + "\uff9e\uff9f"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ufffd"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd3f"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\uddd0\ud800\uddfc"
        + "\ud800\udee1\ud800\udefb"
        + "\ud82f\udca0\ud82f\udca3"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udd66"
        + "\ud834\udd6a\ud834\udd7a"
        + "\ud834\udd83\ud834\udd84"
        + "\ud834\udd8c\ud834\udda9"
        + "\ud834\uddae\ud834\udddd"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udca0\ud83c\udcae"
        + "\ud83c\udcb1\ud83c\udcbf"
        + "\ud83c\udcc1\ud83c\udccf"
        + "\ud83c\udcd1\ud83c\udcf5"
        + "\ud83c\udd00\ud83c\udd0c"
        + "\ud83c\udd10\ud83c\udd2e"
        + "\ud83c\udd30\ud83c\udd6b"
        + "\ud83c\udd70\ud83c\udd9a"
        + "\ud83c\udde6\ud83c\uddff"
        + "\ud83c\ude01\ud83c\ude02"
        + "\ud83c\ude10\ud83c\ude3a"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83c\ude50\ud83c\ude51"
        + "\ud83c\udf00\ud83c\udf2c"
        + "\ud83c\udf30\ud83c\udf7d"
        + "\ud83c\udf80\ud83c\udfce"
        + "\ud83c\udfd4\ud83c\udff7"
        + "\ud83d\udc00\ud83d\udcfe"
        + "\ud83d\udd00\ud83d\udd4a"
        + "\ud83d\udd50\ud83d\udd79"
        + "\ud83d\udd7b\ud83d\udda3"
        + "\ud83d\udda5\ud83d\ude42"
        + "\ud83d\ude45\ud83d\udecf"
        + "\ud83d\udee0\ud83d\udeec"
        + "\ud83d\udef0\ud83d\udef3"
        + "\ud83d\udf00\ud83d\udf73"
        + "\ud83d\udf80\ud83d\udfd4"
        + "\ud83e\udc00\ud83e\udc0b"
        + "\ud83e\udc10\ud83e\udc47"
        + "\ud83e\udc50\ud83e\udc59"
        + "\ud83e\udc60\ud83e\udc87"
        + "\ud83e\udc90\ud83e\udcad"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f",
    // Unicode 7.0 property value: {coptic}
    "\u03e2\u03ef" + "\u2c80\u2cf3" + "\u2cf9\u2cff",
    // Unicode 7.0 property value: {cuneiform}
    "\ud808\udc00\ud808\udf98" + "\ud809\udc00\ud809\udc6e" + "\ud809\udc70\ud809\udc74",
    // Unicode 7.0 property value: {cypriot}
    "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc3f",
    // Unicode 7.0 property value: {cyrillic}
    "\u0400\u0484"
        + "\u0487\u052f"
        + "\u1d2b\u1d2b"
        + "\u1d78\u1d78"
        + "\u2de0\u2dff"
        + "\ua640\ua69d"
        + "\ua69f\ua69f",
    // Unicode 7.0 property value: {dash}
    "\u002d\u002d"
        + "\u058a\u058a"
        + "\u05be\u05be"
        + "\u1400\u1400"
        + "\u1806\u1806"
        + "\u2010\u2015"
        + "\u2053\u2053"
        + "\u207b\u207b"
        + "\u208b\u208b"
        + "\u2212\u2212"
        + "\u2e17\u2e17"
        + "\u2e1a\u2e1a"
        + "\u2e3a\u2e3b"
        + "\u2e40\u2e40"
        + "\u301c\u301c"
        + "\u3030\u3030"
        + "\u30a0\u30a0"
        + "\ufe31\ufe32"
        + "\ufe58\ufe58"
        + "\ufe63\ufe63"
        + "\uff0d\uff0d",
    // Unicode 7.0 property value: {defaultignorablecodepoint}
    "\u00ad\u00ad"
        + "\u034f\u034f"
        + "\u061c\u061c"
        + "\u115f\u1160"
        + "\u17b4\u17b5"
        + "\u180b\u180e"
        + "\u200b\u200f"
        + "\u202a\u202e"
        + "\u2060\u206f"
        + "\u3164\u3164"
        + "\ufe00\ufe0f"
        + "\ufeff\ufeff"
        + "\uffa0\uffa0"
        + "\ufff0\ufff8"
        + "\ud82f\udca0\ud82f\udca3"
        + "\ud834\udd73\ud834\udd7a"
        + "\udb40\udc00\udb43\udfff",
    // Unicode 7.0 property value: {deprecated}
    "\u0149\u0149"
        + "\u0673\u0673"
        + "\u0f77\u0f77"
        + "\u0f79\u0f79"
        + "\u17a3\u17a4"
        + "\u206a\u206f"
        + "\u2329\u232a"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f",
    // Unicode 7.0 property value: {deseret}
    "\ud801\udc00\ud801\udc4f",
    // Unicode 7.0 property value: {devanagari}
    "\u0900\u0950" + "\u0953\u0963" + "\u0966\u097f" + "\ua8e0\ua8fb",
    // Unicode 7.0 property value: {diacritic}
    "\u005e\u005e"
        + "\u0060\u0060"
        + "\u00a8\u00a8"
        + "\u00af\u00af"
        + "\u00b4\u00b4"
        + "\u00b7\u00b8"
        + "\u02b0\u034e"
        + "\u0350\u0357"
        + "\u035d\u0362"
        + "\u0374\u0375"
        + "\u037a\u037a"
        + "\u0384\u0385"
        + "\u0483\u0487"
        + "\u0559\u0559"
        + "\u0591\u05a1"
        + "\u05a3\u05bd"
        + "\u05bf\u05bf"
        + "\u05c1\u05c2"
        + "\u05c4\u05c4"
        + "\u064b\u0652"
        + "\u0657\u0658"
        + "\u06df\u06e0"
        + "\u06e5\u06e6"
        + "\u06ea\u06ec"
        + "\u0730\u074a"
        + "\u07a6\u07b0"
        + "\u07eb\u07f5"
        + "\u0818\u0819"
        + "\u08e4\u08fe"
        + "\u093c\u093c"
        + "\u094d\u094d"
        + "\u0951\u0954"
        + "\u0971\u0971"
        + "\u09bc\u09bc"
        + "\u09cd\u09cd"
        + "\u0a3c\u0a3c"
        + "\u0a4d\u0a4d"
        + "\u0abc\u0abc"
        + "\u0acd\u0acd"
        + "\u0b3c\u0b3c"
        + "\u0b4d\u0b4d"
        + "\u0bcd\u0bcd"
        + "\u0c4d\u0c4d"
        + "\u0cbc\u0cbc"
        + "\u0ccd\u0ccd"
        + "\u0d4d\u0d4d"
        + "\u0dca\u0dca"
        + "\u0e47\u0e4c"
        + "\u0e4e\u0e4e"
        + "\u0ec8\u0ecc"
        + "\u0f18\u0f19"
        + "\u0f35\u0f35"
        + "\u0f37\u0f37"
        + "\u0f39\u0f39"
        + "\u0f3e\u0f3f"
        + "\u0f82\u0f84"
        + "\u0f86\u0f87"
        + "\u0fc6\u0fc6"
        + "\u1037\u1037"
        + "\u1039\u103a"
        + "\u1087\u108d"
        + "\u108f\u108f"
        + "\u109a\u109b"
        + "\u17c9\u17d3"
        + "\u17dd\u17dd"
        + "\u1939\u193b"
        + "\u1a75\u1a7c"
        + "\u1a7f\u1a7f"
        + "\u1ab0\u1abd"
        + "\u1b34\u1b34"
        + "\u1b44\u1b44"
        + "\u1b6b\u1b73"
        + "\u1baa\u1bab"
        + "\u1c36\u1c37"
        + "\u1c78\u1c7d"
        + "\u1cd0\u1ce8"
        + "\u1ced\u1ced"
        + "\u1cf4\u1cf4"
        + "\u1cf8\u1cf9"
        + "\u1d2c\u1d6a"
        + "\u1dc4\u1dcf"
        + "\u1df5\u1df5"
        + "\u1dfd\u1dff"
        + "\u1fbd\u1fbd"
        + "\u1fbf\u1fc1"
        + "\u1fcd\u1fcf"
        + "\u1fdd\u1fdf"
        + "\u1fed\u1fef"
        + "\u1ffd\u1ffe"
        + "\u2cef\u2cf1"
        + "\u2e2f\u2e2f"
        + "\u302a\u302f"
        + "\u3099\u309c"
        + "\u30fc\u30fc"
        + "\ua66f\ua66f"
        + "\ua67c\ua67d"
        + "\ua67f\ua67f"
        + "\ua69c\ua69d"
        + "\ua6f0\ua6f1"
        + "\ua717\ua721"
        + "\ua788\ua788"
        + "\ua7f8\ua7f9"
        + "\ua8c4\ua8c4"
        + "\ua8e0\ua8f1"
        + "\ua92b\ua92e"
        + "\ua953\ua953"
        + "\ua9b3\ua9b3"
        + "\ua9c0\ua9c0"
        + "\ua9e5\ua9e5"
        + "\uaa7b\uaa7d"
        + "\uaabf\uaac2"
        + "\uaaf6\uaaf6"
        + "\uab5b\uab5f"
        + "\uabec\uabed"
        + "\ufb1e\ufb1e"
        + "\ufe20\ufe2d"
        + "\uff3e\uff3e"
        + "\uff40\uff40"
        + "\uff70\uff70"
        + "\uff9e\uff9f"
        + "\uffe3\uffe3"
        + "\ud800\udee0\ud800\udee0"
        + "\ud802\udee5\ud802\udee6"
        + "\ud804\udcb9\ud804\udcba"
        + "\ud804\udd33\ud804\udd34"
        + "\ud804\udd73\ud804\udd73"
        + "\ud804\uddc0\ud804\uddc0"
        + "\ud804\ude35\ud804\ude36"
        + "\ud804\udee9\ud804\udeea"
        + "\ud804\udf3c\ud804\udf3c"
        + "\ud804\udf4d\ud804\udf4d"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udcc2\ud805\udcc3"
        + "\ud805\uddbf\ud805\uddc0"
        + "\ud805\ude3f\ud805\ude3f"
        + "\ud805\udeb6\ud805\udeb7"
        + "\ud81a\udef0\ud81a\udef4"
        + "\ud81b\udf8f\ud81b\udf9f"
        + "\ud834\udd67\ud834\udd69"
        + "\ud834\udd6d\ud834\udd72"
        + "\ud834\udd7b\ud834\udd82"
        + "\ud834\udd85\ud834\udd8b"
        + "\ud834\uddaa\ud834\uddad"
        + "\ud83a\udcd0\ud83a\udcd6",
    // Unicode 7.0 property value: {duployan}
    "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud82f\udc9c\ud82f\udc9f",
    // Unicode 7.0 property value: {egyptianhieroglyphs}
    "\ud80c\udc00\ud80d\udc2e",
    // Unicode 7.0 property value: {elbasan}
    "\ud801\udd00\ud801\udd27",
    // Unicode 7.0 property value: {ethiopic}
    "\u1200\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135d\u137c"
        + "\u1380\u1399"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e",
    // Unicode 7.0 property value: {extender}
    "\u00b7\u00b7"
        + "\u02d0\u02d1"
        + "\u0640\u0640"
        + "\u07fa\u07fa"
        + "\u0e46\u0e46"
        + "\u0ec6\u0ec6"
        + "\u180a\u180a"
        + "\u1843\u1843"
        + "\u1aa7\u1aa7"
        + "\u1c36\u1c36"
        + "\u1c7b\u1c7b"
        + "\u3005\u3005"
        + "\u3031\u3035"
        + "\u309d\u309e"
        + "\u30fc\u30fe"
        + "\ua015\ua015"
        + "\ua60c\ua60c"
        + "\ua9cf\ua9cf"
        + "\ua9e6\ua9e6"
        + "\uaa70\uaa70"
        + "\uaadd\uaadd"
        + "\uaaf3\uaaf4"
        + "\uff70\uff70"
        + "\ud804\udf5d\ud804\udf5d"
        + "\ud805\uddc6\ud805\uddc8"
        + "\ud81a\udf42\ud81a\udf43",
    // Unicode 7.0 property value: {georgian}
    "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u10fa"
        + "\u10fc\u10ff"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d",
    // Unicode 7.0 property value: {glagolitic}
    "\u2c00\u2c2e" + "\u2c30\u2c5e",
    // Unicode 7.0 property value: {gothic}
    "\ud800\udf30\ud800\udf4a",
    // Unicode 7.0 property value: {grantha}
    "\ud804\udf01\ud804\udf03"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3c\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf5d\ud804\udf63"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74",
    // Unicode 7.0 property value: {graph}
    "\u0021\u007e"
        + "\u00a1\u0377"
        + "\u037a\u037f"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u052f"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u058d\u058f"
        + "\u0591\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0600\u061c"
        + "\u061e\u070d"
        + "\u070f\u074a"
        + "\u074d\u07b1"
        + "\u07c0\u07fa"
        + "\u0800\u082d"
        + "\u0830\u083e"
        + "\u0840\u085b"
        + "\u085e\u085e"
        + "\u08a0\u08b2"
        + "\u08e4\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fb"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0af1"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b77"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa"
        + "\u0c00\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c78\u0c7f"
        + "\u0c81\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d01\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d75"
        + "\u0d79\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0de6\u0def"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edf"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fce\u0fda"
        + "\u1000\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135d\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1400\u167f"
        + "\u1681\u169c"
        + "\u16a0\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dd"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19d0\u19da"
        + "\u19de\u1a1b"
        + "\u1a1e\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1a7f\u1a89"
        + "\u1a90\u1a99"
        + "\u1aa0\u1aad"
        + "\u1ab0\u1abe"
        + "\u1b00\u1b4b"
        + "\u1b50\u1b7c"
        + "\u1b80\u1bf3"
        + "\u1bfc\u1c37"
        + "\u1c3b\u1c49"
        + "\u1c4d\u1c7f"
        + "\u1cc0\u1cc7"
        + "\u1cd0\u1cf6"
        + "\u1cf8\u1cf9"
        + "\u1d00\u1df5"
        + "\u1dfc\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u200b\u2027"
        + "\u202a\u202e"
        + "\u2030\u205e"
        + "\u2060\u2064"
        + "\u2066\u2071"
        + "\u2074\u208e"
        + "\u2090\u209c"
        + "\u20a0\u20bd"
        + "\u20d0\u20f0"
        + "\u2100\u2189"
        + "\u2190\u23fa"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u2b73"
        + "\u2b76\u2b95"
        + "\u2b98\u2bb9"
        + "\u2bbd\u2bc8"
        + "\u2bca\u2bd1"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2cf3"
        + "\u2cf9\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d70"
        + "\u2d7f\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2e42"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3001\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u3190\u31ba"
        + "\u31c0\u31e3"
        + "\u31f0\u321e"
        + "\u3220\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fcc"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\ua4d0\ua62b"
        + "\ua640\ua69d"
        + "\ua69f\ua6f7"
        + "\ua700\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua82b"
        + "\ua830\ua839"
        + "\ua840\ua877"
        + "\ua880\ua8c4"
        + "\ua8ce\ua8d9"
        + "\ua8e0\ua8fb"
        + "\ua900\ua953"
        + "\ua95f\ua97c"
        + "\ua980\ua9cd"
        + "\ua9cf\ua9d9"
        + "\ua9de\ua9fe"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa5c\uaac2"
        + "\uaadb\uaaf6"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uab30\uab5f"
        + "\uab64\uab65"
        + "\uabc0\uabed"
        + "\uabf0\uabf9"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\ue000\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbc1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfd"
        + "\ufe00\ufe19"
        + "\ufe20\ufe2d"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ufffd"
        + "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8c"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\udda0\ud800\udda0"
        + "\ud800\uddd0\ud800\uddfd"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udee0\ud800\udefb"
        + "\ud800\udf00\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf50\ud800\udf7a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\udd6f\ud801\udd6f"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc57\ud802\udc9e"
        + "\ud802\udca7\ud802\udcaf"
        + "\ud802\udd00\ud802\udd1b"
        + "\ud802\udd1f\ud802\udd39"
        + "\ud802\udd3f\ud802\udd3f"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58"
        + "\ud802\ude60\ud802\ude9f"
        + "\ud802\udec0\ud802\udee6"
        + "\ud802\udeeb\ud802\udef6"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf39\ud802\udf55"
        + "\ud802\udf58\ud802\udf72"
        + "\ud802\udf78\ud802\udf91"
        + "\ud802\udf99\ud802\udf9c"
        + "\ud802\udfa9\ud802\udfaf"
        + "\ud803\udc00\ud803\udc48"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud804\udc00\ud804\udc4d"
        + "\ud804\udc52\ud804\udc6f"
        + "\ud804\udc7f\ud804\udcc1"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd00\ud804\udd34"
        + "\ud804\udd36\ud804\udd43"
        + "\ud804\udd50\ud804\udd76"
        + "\ud804\udd80\ud804\uddc8"
        + "\ud804\uddcd\ud804\uddcd"
        + "\ud804\uddd0\ud804\uddda"
        + "\ud804\udde1\ud804\uddf4"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude3d"
        + "\ud804\udeb0\ud804\udeea"
        + "\ud804\udef0\ud804\udef9"
        + "\ud804\udf01\ud804\udf03"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3c\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf5d\ud804\udf63"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udc80\ud805\udcc7"
        + "\ud805\udcd0\ud805\udcd9"
        + "\ud805\udd80\ud805\uddb5"
        + "\ud805\uddb8\ud805\uddc9"
        + "\ud805\ude00\ud805\ude44"
        + "\ud805\ude50\ud805\ude59"
        + "\ud805\ude80\ud805\udeb7"
        + "\ud805\udec0\ud805\udec9"
        + "\ud806\udca0\ud806\udcf2"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud809\udc00\ud809\udc6e"
        + "\ud809\udc70\ud809\udc74"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\ude60\ud81a\ude69"
        + "\ud81a\ude6e\ud81a\ude6f"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udef0\ud81a\udef5"
        + "\ud81a\udf00\ud81a\udf45"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud81a\udf5b\ud81a\udf61"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf7e"
        + "\ud81b\udf8f\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud82f\udc9c\ud82f\udca3"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udddd"
        + "\ud834\ude00\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83a\udcc7\ud83a\udcd6"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83b\udef0\ud83b\udef1"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udca0\ud83c\udcae"
        + "\ud83c\udcb1\ud83c\udcbf"
        + "\ud83c\udcc1\ud83c\udccf"
        + "\ud83c\udcd1\ud83c\udcf5"
        + "\ud83c\udd00\ud83c\udd0c"
        + "\ud83c\udd10\ud83c\udd2e"
        + "\ud83c\udd30\ud83c\udd6b"
        + "\ud83c\udd70\ud83c\udd9a"
        + "\ud83c\udde6\ud83c\ude02"
        + "\ud83c\ude10\ud83c\ude3a"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83c\ude50\ud83c\ude51"
        + "\ud83c\udf00\ud83c\udf2c"
        + "\ud83c\udf30\ud83c\udf7d"
        + "\ud83c\udf80\ud83c\udfce"
        + "\ud83c\udfd4\ud83c\udff7"
        + "\ud83d\udc00\ud83d\udcfe"
        + "\ud83d\udd00\ud83d\udd4a"
        + "\ud83d\udd50\ud83d\udd79"
        + "\ud83d\udd7b\ud83d\udda3"
        + "\ud83d\udda5\ud83d\ude42"
        + "\ud83d\ude45\ud83d\udecf"
        + "\ud83d\udee0\ud83d\udeec"
        + "\ud83d\udef0\ud83d\udef3"
        + "\ud83d\udf00\ud83d\udf73"
        + "\ud83d\udf80\ud83d\udfd4"
        + "\ud83e\udc00\ud83e\udc0b"
        + "\ud83e\udc10\ud83e\udc47"
        + "\ud83e\udc50\ud83e\udc59"
        + "\ud83e\udc60\ud83e\udc87"
        + "\ud83e\udc90\ud83e\udcad"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef"
        + "\udb80\udc00\udbbf\udffd"
        + "\udbc0\udc00\udbff\udffd",
    // Unicode 7.0 property value: {graphemebase}
    "\u0020\u007e"
        + "\u00a0\u00ac"
        + "\u00ae\u02ff"
        + "\u0370\u0377"
        + "\u037a\u037f"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u0482"
        + "\u048a\u052f"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u058d\u058f"
        + "\u05be\u05be"
        + "\u05c0\u05c0"
        + "\u05c3\u05c3"
        + "\u05c6\u05c6"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0606\u060f"
        + "\u061b\u061b"
        + "\u061e\u064a"
        + "\u0660\u066f"
        + "\u0671\u06d5"
        + "\u06de\u06de"
        + "\u06e5\u06e6"
        + "\u06e9\u06e9"
        + "\u06ee\u070d"
        + "\u0710\u0710"
        + "\u0712\u072f"
        + "\u074d\u07a5"
        + "\u07b1\u07b1"
        + "\u07c0\u07ea"
        + "\u07f4\u07fa"
        + "\u0800\u0815"
        + "\u081a\u081a"
        + "\u0824\u0824"
        + "\u0828\u0828"
        + "\u0830\u083e"
        + "\u0840\u0858"
        + "\u085e\u085e"
        + "\u08a0\u08b2"
        + "\u0903\u0939"
        + "\u093b\u093b"
        + "\u093d\u0940"
        + "\u0949\u094c"
        + "\u094e\u0950"
        + "\u0958\u0961"
        + "\u0964\u0980"
        + "\u0982\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bd\u09bd"
        + "\u09bf\u09c0"
        + "\u09c7\u09c8"
        + "\u09cb\u09cc"
        + "\u09ce\u09ce"
        + "\u09dc\u09dd"
        + "\u09df\u09e1"
        + "\u09e6\u09fb"
        + "\u0a03\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3e\u0a40"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a6f"
        + "\u0a72\u0a74"
        + "\u0a83\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abd\u0ac0"
        + "\u0ac9\u0ac9"
        + "\u0acb\u0acc"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae1"
        + "\u0ae6\u0af1"
        + "\u0b02\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3d\u0b3d"
        + "\u0b40\u0b40"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4c"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b66\u0b77"
        + "\u0b83\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbf\u0bbf"
        + "\u0bc1\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcc"
        + "\u0bd0\u0bd0"
        + "\u0be6\u0bfa"
        + "\u0c01\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c3d"
        + "\u0c41\u0c44"
        + "\u0c58\u0c59"
        + "\u0c60\u0c61"
        + "\u0c66\u0c6f"
        + "\u0c78\u0c7f"
        + "\u0c82\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbd\u0cbe"
        + "\u0cc0\u0cc1"
        + "\u0cc3\u0cc4"
        + "\u0cc7\u0cc8"
        + "\u0cca\u0ccb"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d02\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d3d"
        + "\u0d3f\u0d40"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4c"
        + "\u0d4e\u0d4e"
        + "\u0d60\u0d61"
        + "\u0d66\u0d75"
        + "\u0d79\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dd0\u0dd1"
        + "\u0dd8\u0dde"
        + "\u0de6\u0def"
        + "\u0df2\u0df4"
        + "\u0e01\u0e30"
        + "\u0e32\u0e33"
        + "\u0e3f\u0e46"
        + "\u0e4f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb0"
        + "\u0eb2\u0eb3"
        + "\u0ebd\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edf"
        + "\u0f00\u0f17"
        + "\u0f1a\u0f34"
        + "\u0f36\u0f36"
        + "\u0f38\u0f38"
        + "\u0f3a\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f7f\u0f7f"
        + "\u0f85\u0f85"
        + "\u0f88\u0f8c"
        + "\u0fbe\u0fc5"
        + "\u0fc7\u0fcc"
        + "\u0fce\u0fda"
        + "\u1000\u102c"
        + "\u1031\u1031"
        + "\u1038\u1038"
        + "\u103b\u103c"
        + "\u103f\u1057"
        + "\u105a\u105d"
        + "\u1061\u1070"
        + "\u1075\u1081"
        + "\u1083\u1084"
        + "\u1087\u108c"
        + "\u108e\u109c"
        + "\u109e\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u1360\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1400\u169c"
        + "\u16a0\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1711"
        + "\u1720\u1731"
        + "\u1735\u1736"
        + "\u1740\u1751"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1780\u17b3"
        + "\u17b6\u17b6"
        + "\u17be\u17c5"
        + "\u17c7\u17c8"
        + "\u17d4\u17dc"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180a"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18a8"
        + "\u18aa\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1923\u1926"
        + "\u1929\u192b"
        + "\u1930\u1931"
        + "\u1933\u1938"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19d0\u19da"
        + "\u19de\u1a16"
        + "\u1a19\u1a1a"
        + "\u1a1e\u1a55"
        + "\u1a57\u1a57"
        + "\u1a61\u1a61"
        + "\u1a63\u1a64"
        + "\u1a6d\u1a72"
        + "\u1a80\u1a89"
        + "\u1a90\u1a99"
        + "\u1aa0\u1aad"
        + "\u1b04\u1b33"
        + "\u1b35\u1b35"
        + "\u1b3b\u1b3b"
        + "\u1b3d\u1b41"
        + "\u1b43\u1b4b"
        + "\u1b50\u1b6a"
        + "\u1b74\u1b7c"
        + "\u1b82\u1ba1"
        + "\u1ba6\u1ba7"
        + "\u1baa\u1baa"
        + "\u1bae\u1be5"
        + "\u1be7\u1be7"
        + "\u1bea\u1bec"
        + "\u1bee\u1bee"
        + "\u1bf2\u1bf3"
        + "\u1bfc\u1c2b"
        + "\u1c34\u1c35"
        + "\u1c3b\u1c49"
        + "\u1c4d\u1c7f"
        + "\u1cc0\u1cc7"
        + "\u1cd3\u1cd3"
        + "\u1ce1\u1ce1"
        + "\u1ce9\u1cec"
        + "\u1cee\u1cf3"
        + "\u1cf5\u1cf6"
        + "\u1d00\u1dbf"
        + "\u1e00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u200a"
        + "\u2010\u2027"
        + "\u202f\u205f"
        + "\u2070\u2071"
        + "\u2074\u208e"
        + "\u2090\u209c"
        + "\u20a0\u20bd"
        + "\u2100\u2189"
        + "\u2190\u23fa"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u2b73"
        + "\u2b76\u2b95"
        + "\u2b98\u2bb9"
        + "\u2bbd\u2bc8"
        + "\u2bca\u2bd1"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2cee"
        + "\u2cf2\u2cf3"
        + "\u2cf9\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d70"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2e00\u2e42"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u3029"
        + "\u3030\u303f"
        + "\u3041\u3096"
        + "\u309b\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u3190\u31ba"
        + "\u31c0\u31e3"
        + "\u31f0\u321e"
        + "\u3220\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fcc"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\ua4d0\ua62b"
        + "\ua640\ua66e"
        + "\ua673\ua673"
        + "\ua67e\ua69d"
        + "\ua6a0\ua6ef"
        + "\ua6f2\ua6f7"
        + "\ua700\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua801"
        + "\ua803\ua805"
        + "\ua807\ua80a"
        + "\ua80c\ua824"
        + "\ua827\ua82b"
        + "\ua830\ua839"
        + "\ua840\ua877"
        + "\ua880\ua8c3"
        + "\ua8ce\ua8d9"
        + "\ua8f2\ua8fb"
        + "\ua900\ua925"
        + "\ua92e\ua946"
        + "\ua952\ua953"
        + "\ua95f\ua97c"
        + "\ua983\ua9b2"
        + "\ua9b4\ua9b5"
        + "\ua9ba\ua9bb"
        + "\ua9bd\ua9cd"
        + "\ua9cf\ua9d9"
        + "\ua9de\ua9e4"
        + "\ua9e6\ua9fe"
        + "\uaa00\uaa28"
        + "\uaa2f\uaa30"
        + "\uaa33\uaa34"
        + "\uaa40\uaa42"
        + "\uaa44\uaa4b"
        + "\uaa4d\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa5c\uaa7b"
        + "\uaa7d\uaaaf"
        + "\uaab1\uaab1"
        + "\uaab5\uaab6"
        + "\uaab9\uaabd"
        + "\uaac0\uaac0"
        + "\uaac2\uaac2"
        + "\uaadb\uaaeb"
        + "\uaaee\uaaf5"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uab30\uab5f"
        + "\uab64\uab65"
        + "\uabc0\uabe4"
        + "\uabe6\uabe7"
        + "\uabe9\uabec"
        + "\uabf0\uabf9"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\uf900\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb1d"
        + "\ufb1f\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbc1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfd"
        + "\ufe10\ufe19"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\uff01\uff9d"
        + "\uffa0\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufffc\ufffd"
        + "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8c"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\udda0\ud800\udda0"
        + "\ud800\uddd0\ud800\uddfc"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udee1\ud800\udefb"
        + "\ud800\udf00\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf50\ud800\udf75"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\udd6f\ud801\udd6f"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc57\ud802\udc9e"
        + "\ud802\udca7\ud802\udcaf"
        + "\ud802\udd00\ud802\udd1b"
        + "\ud802\udd1f\ud802\udd39"
        + "\ud802\udd3f\ud802\udd3f"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude00"
        + "\ud802\ude10\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude40\ud802\ude47"
        + "\ud802\ude50\ud802\ude58"
        + "\ud802\ude60\ud802\ude9f"
        + "\ud802\udec0\ud802\udee4"
        + "\ud802\udeeb\ud802\udef6"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf39\ud802\udf55"
        + "\ud802\udf58\ud802\udf72"
        + "\ud802\udf78\ud802\udf91"
        + "\ud802\udf99\ud802\udf9c"
        + "\ud802\udfa9\ud802\udfaf"
        + "\ud803\udc00\ud803\udc48"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud804\udc00\ud804\udc00"
        + "\ud804\udc02\ud804\udc37"
        + "\ud804\udc47\ud804\udc4d"
        + "\ud804\udc52\ud804\udc6f"
        + "\ud804\udc82\ud804\udcb2"
        + "\ud804\udcb7\ud804\udcb8"
        + "\ud804\udcbb\ud804\udcbc"
        + "\ud804\udcbe\ud804\udcc1"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd03\ud804\udd26"
        + "\ud804\udd2c\ud804\udd2c"
        + "\ud804\udd36\ud804\udd43"
        + "\ud804\udd50\ud804\udd72"
        + "\ud804\udd74\ud804\udd76"
        + "\ud804\udd82\ud804\uddb5"
        + "\ud804\uddbf\ud804\uddc8"
        + "\ud804\uddcd\ud804\uddcd"
        + "\ud804\uddd0\ud804\uddda"
        + "\ud804\udde1\ud804\uddf4"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude2e"
        + "\ud804\ude32\ud804\ude33"
        + "\ud804\ude35\ud804\ude35"
        + "\ud804\ude38\ud804\ude3d"
        + "\ud804\udeb0\ud804\udede"
        + "\ud804\udee0\ud804\udee2"
        + "\ud804\udef0\ud804\udef9"
        + "\ud804\udf02\ud804\udf03"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3d\ud804\udf3d"
        + "\ud804\udf3f\ud804\udf3f"
        + "\ud804\udf41\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf5d\ud804\udf63"
        + "\ud805\udc80\ud805\udcaf"
        + "\ud805\udcb1\ud805\udcb2"
        + "\ud805\udcb9\ud805\udcb9"
        + "\ud805\udcbb\ud805\udcbc"
        + "\ud805\udcbe\ud805\udcbe"
        + "\ud805\udcc1\ud805\udcc1"
        + "\ud805\udcc4\ud805\udcc7"
        + "\ud805\udcd0\ud805\udcd9"
        + "\ud805\udd80\ud805\uddae"
        + "\ud805\uddb0\ud805\uddb1"
        + "\ud805\uddb8\ud805\uddbb"
        + "\ud805\uddbe\ud805\uddbe"
        + "\ud805\uddc1\ud805\uddc9"
        + "\ud805\ude00\ud805\ude32"
        + "\ud805\ude3b\ud805\ude3c"
        + "\ud805\ude3e\ud805\ude3e"
        + "\ud805\ude41\ud805\ude44"
        + "\ud805\ude50\ud805\ude59"
        + "\ud805\ude80\ud805\udeaa"
        + "\ud805\udeac\ud805\udeac"
        + "\ud805\udeae\ud805\udeaf"
        + "\ud805\udeb6\ud805\udeb6"
        + "\ud805\udec0\ud805\udec9"
        + "\ud806\udca0\ud806\udcf2"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud809\udc00\ud809\udc6e"
        + "\ud809\udc70\ud809\udc74"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\ude60\ud81a\ude69"
        + "\ud81a\ude6e\ud81a\ude6f"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udef5\ud81a\udef5"
        + "\ud81a\udf00\ud81a\udf2f"
        + "\ud81a\udf37\ud81a\udf45"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud81a\udf5b\ud81a\udf61"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf7e"
        + "\ud81b\udf93\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud82f\udc9c\ud82f\udc9c"
        + "\ud82f\udc9f\ud82f\udc9f"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udd64"
        + "\ud834\udd66\ud834\udd66"
        + "\ud834\udd6a\ud834\udd6d"
        + "\ud834\udd83\ud834\udd84"
        + "\ud834\udd8c\ud834\udda9"
        + "\ud834\uddae\ud834\udddd"
        + "\ud834\ude00\ud834\ude41"
        + "\ud834\ude45\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83a\udcc7\ud83a\udccf"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83b\udef0\ud83b\udef1"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udca0\ud83c\udcae"
        + "\ud83c\udcb1\ud83c\udcbf"
        + "\ud83c\udcc1\ud83c\udccf"
        + "\ud83c\udcd1\ud83c\udcf5"
        + "\ud83c\udd00\ud83c\udd0c"
        + "\ud83c\udd10\ud83c\udd2e"
        + "\ud83c\udd30\ud83c\udd6b"
        + "\ud83c\udd70\ud83c\udd9a"
        + "\ud83c\udde6\ud83c\ude02"
        + "\ud83c\ude10\ud83c\ude3a"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83c\ude50\ud83c\ude51"
        + "\ud83c\udf00\ud83c\udf2c"
        + "\ud83c\udf30\ud83c\udf7d"
        + "\ud83c\udf80\ud83c\udfce"
        + "\ud83c\udfd4\ud83c\udff7"
        + "\ud83d\udc00\ud83d\udcfe"
        + "\ud83d\udd00\ud83d\udd4a"
        + "\ud83d\udd50\ud83d\udd79"
        + "\ud83d\udd7b\ud83d\udda3"
        + "\ud83d\udda5\ud83d\ude42"
        + "\ud83d\ude45\ud83d\udecf"
        + "\ud83d\udee0\ud83d\udeec"
        + "\ud83d\udef0\ud83d\udef3"
        + "\ud83d\udf00\ud83d\udf73"
        + "\ud83d\udf80\ud83d\udfd4"
        + "\ud83e\udc00\ud83e\udc0b"
        + "\ud83e\udc10\ud83e\udc47"
        + "\ud83e\udc50\ud83e\udc59"
        + "\ud83e\udc60\ud83e\udc87"
        + "\ud83e\udc90\ud83e\udcad"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d",
    // Unicode 7.0 property value: {graphemeclusterbreak=control}
    "\000\t"
        + "\u000b\f"
        + "\u000e\u001f"
        + "\u007f\u009f"
        + "\u00ad\u00ad"
        + "\u0600\u0605"
        + "\u061c\u061c"
        + "\u06dd\u06dd"
        + "\u070f\u070f"
        + "\u180e\u180e"
        + "\u200b\u200b"
        + "\u200e\u200f"
        + "\u2028\u202e"
        + "\u2060\u206f"
        + "\ufeff\ufeff"
        + "\ufff0\ufffb"
        + "\ud804\udcbd\ud804\udcbd"
        + "\ud82f\udca0\ud82f\udca3"
        + "\ud834\udd73\ud834\udd7a"
        + "\udb40\udc00\udb40\udcff"
        + "\udb40\uddf0\udb43\udfff",
    // Unicode 7.0 property value: {graphemeclusterbreak=cr}
    "\r\r",
    // Unicode 7.0 property value: {graphemeclusterbreak=extend}
    "\u0300\u036f"
        + "\u0483\u0489"
        + "\u0591\u05bd"
        + "\u05bf\u05bf"
        + "\u05c1\u05c2"
        + "\u05c4\u05c5"
        + "\u05c7\u05c7"
        + "\u0610\u061a"
        + "\u064b\u065f"
        + "\u0670\u0670"
        + "\u06d6\u06dc"
        + "\u06df\u06e4"
        + "\u06e7\u06e8"
        + "\u06ea\u06ed"
        + "\u0711\u0711"
        + "\u0730\u074a"
        + "\u07a6\u07b0"
        + "\u07eb\u07f3"
        + "\u0816\u0819"
        + "\u081b\u0823"
        + "\u0825\u0827"
        + "\u0829\u082d"
        + "\u0859\u085b"
        + "\u08e4\u0902"
        + "\u093a\u093a"
        + "\u093c\u093c"
        + "\u0941\u0948"
        + "\u094d\u094d"
        + "\u0951\u0957"
        + "\u0962\u0963"
        + "\u0981\u0981"
        + "\u09bc\u09bc"
        + "\u09be\u09be"
        + "\u09c1\u09c4"
        + "\u09cd\u09cd"
        + "\u09d7\u09d7"
        + "\u09e2\u09e3"
        + "\u0a01\u0a02"
        + "\u0a3c\u0a3c"
        + "\u0a41\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a70\u0a71"
        + "\u0a75\u0a75"
        + "\u0a81\u0a82"
        + "\u0abc\u0abc"
        + "\u0ac1\u0ac5"
        + "\u0ac7\u0ac8"
        + "\u0acd\u0acd"
        + "\u0ae2\u0ae3"
        + "\u0b01\u0b01"
        + "\u0b3c\u0b3c"
        + "\u0b3e\u0b3f"
        + "\u0b41\u0b44"
        + "\u0b4d\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b62\u0b63"
        + "\u0b82\u0b82"
        + "\u0bbe\u0bbe"
        + "\u0bc0\u0bc0"
        + "\u0bcd\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0c00\u0c00"
        + "\u0c3e\u0c40"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c62\u0c63"
        + "\u0c81\u0c81"
        + "\u0cbc\u0cbc"
        + "\u0cbf\u0cbf"
        + "\u0cc2\u0cc2"
        + "\u0cc6\u0cc6"
        + "\u0ccc\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0ce2\u0ce3"
        + "\u0d01\u0d01"
        + "\u0d3e\u0d3e"
        + "\u0d41\u0d44"
        + "\u0d4d\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d62\u0d63"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dcf"
        + "\u0dd2\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0ddf\u0ddf"
        + "\u0e31\u0e31"
        + "\u0e34\u0e3a"
        + "\u0e47\u0e4e"
        + "\u0eb1\u0eb1"
        + "\u0eb4\u0eb9"
        + "\u0ebb\u0ebc"
        + "\u0ec8\u0ecd"
        + "\u0f18\u0f19"
        + "\u0f35\u0f35"
        + "\u0f37\u0f37"
        + "\u0f39\u0f39"
        + "\u0f71\u0f7e"
        + "\u0f80\u0f84"
        + "\u0f86\u0f87"
        + "\u0f8d\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fc6\u0fc6"
        + "\u102d\u1030"
        + "\u1032\u1037"
        + "\u1039\u103a"
        + "\u103d\u103e"
        + "\u1058\u1059"
        + "\u105e\u1060"
        + "\u1071\u1074"
        + "\u1082\u1082"
        + "\u1085\u1086"
        + "\u108d\u108d"
        + "\u109d\u109d"
        + "\u135d\u135f"
        + "\u1712\u1714"
        + "\u1732\u1734"
        + "\u1752\u1753"
        + "\u1772\u1773"
        + "\u17b4\u17b5"
        + "\u17b7\u17bd"
        + "\u17c6\u17c6"
        + "\u17c9\u17d3"
        + "\u17dd\u17dd"
        + "\u180b\u180d"
        + "\u18a9\u18a9"
        + "\u1920\u1922"
        + "\u1927\u1928"
        + "\u1932\u1932"
        + "\u1939\u193b"
        + "\u1a17\u1a18"
        + "\u1a1b\u1a1b"
        + "\u1a56\u1a56"
        + "\u1a58\u1a5e"
        + "\u1a60\u1a60"
        + "\u1a62\u1a62"
        + "\u1a65\u1a6c"
        + "\u1a73\u1a7c"
        + "\u1a7f\u1a7f"
        + "\u1ab0\u1abe"
        + "\u1b00\u1b03"
        + "\u1b34\u1b34"
        + "\u1b36\u1b3a"
        + "\u1b3c\u1b3c"
        + "\u1b42\u1b42"
        + "\u1b6b\u1b73"
        + "\u1b80\u1b81"
        + "\u1ba2\u1ba5"
        + "\u1ba8\u1ba9"
        + "\u1bab\u1bad"
        + "\u1be6\u1be6"
        + "\u1be8\u1be9"
        + "\u1bed\u1bed"
        + "\u1bef\u1bf1"
        + "\u1c2c\u1c33"
        + "\u1c36\u1c37"
        + "\u1cd0\u1cd2"
        + "\u1cd4\u1ce0"
        + "\u1ce2\u1ce8"
        + "\u1ced\u1ced"
        + "\u1cf4\u1cf4"
        + "\u1cf8\u1cf9"
        + "\u1dc0\u1df5"
        + "\u1dfc\u1dff"
        + "\u200c\u200d"
        + "\u20d0\u20f0"
        + "\u2cef\u2cf1"
        + "\u2d7f\u2d7f"
        + "\u2de0\u2dff"
        + "\u302a\u302f"
        + "\u3099\u309a"
        + "\ua66f\ua672"
        + "\ua674\ua67d"
        + "\ua69f\ua69f"
        + "\ua6f0\ua6f1"
        + "\ua802\ua802"
        + "\ua806\ua806"
        + "\ua80b\ua80b"
        + "\ua825\ua826"
        + "\ua8c4\ua8c4"
        + "\ua8e0\ua8f1"
        + "\ua926\ua92d"
        + "\ua947\ua951"
        + "\ua980\ua982"
        + "\ua9b3\ua9b3"
        + "\ua9b6\ua9b9"
        + "\ua9bc\ua9bc"
        + "\ua9e5\ua9e5"
        + "\uaa29\uaa2e"
        + "\uaa31\uaa32"
        + "\uaa35\uaa36"
        + "\uaa43\uaa43"
        + "\uaa4c\uaa4c"
        + "\uaa7c\uaa7c"
        + "\uaab0\uaab0"
        + "\uaab2\uaab4"
        + "\uaab7\uaab8"
        + "\uaabe\uaabf"
        + "\uaac1\uaac1"
        + "\uaaec\uaaed"
        + "\uaaf6\uaaf6"
        + "\uabe5\uabe5"
        + "\uabe8\uabe8"
        + "\uabed\uabed"
        + "\ufb1e\ufb1e"
        + "\ufe00\ufe0f"
        + "\ufe20\ufe2d"
        + "\uff9e\uff9f"
        + "\ud800\uddfd\ud800\uddfd"
        + "\ud800\udee0\ud800\udee0"
        + "\ud800\udf76\ud800\udf7a"
        + "\ud802\ude01\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude0f"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude3f"
        + "\ud802\udee5\ud802\udee6"
        + "\ud804\udc01\ud804\udc01"
        + "\ud804\udc38\ud804\udc46"
        + "\ud804\udc7f\ud804\udc81"
        + "\ud804\udcb3\ud804\udcb6"
        + "\ud804\udcb9\ud804\udcba"
        + "\ud804\udd00\ud804\udd02"
        + "\ud804\udd27\ud804\udd2b"
        + "\ud804\udd2d\ud804\udd34"
        + "\ud804\udd73\ud804\udd73"
        + "\ud804\udd80\ud804\udd81"
        + "\ud804\uddb6\ud804\uddbe"
        + "\ud804\ude2f\ud804\ude31"
        + "\ud804\ude34\ud804\ude34"
        + "\ud804\ude36\ud804\ude37"
        + "\ud804\udedf\ud804\udedf"
        + "\ud804\udee3\ud804\udeea"
        + "\ud804\udf01\ud804\udf01"
        + "\ud804\udf3c\ud804\udf3c"
        + "\ud804\udf3e\ud804\udf3e"
        + "\ud804\udf40\ud804\udf40"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udcb0\ud805\udcb0"
        + "\ud805\udcb3\ud805\udcb8"
        + "\ud805\udcba\ud805\udcba"
        + "\ud805\udcbd\ud805\udcbd"
        + "\ud805\udcbf\ud805\udcc0"
        + "\ud805\udcc2\ud805\udcc3"
        + "\ud805\uddaf\ud805\uddaf"
        + "\ud805\uddb2\ud805\uddb5"
        + "\ud805\uddbc\ud805\uddbd"
        + "\ud805\uddbf\ud805\uddc0"
        + "\ud805\ude33\ud805\ude3a"
        + "\ud805\ude3d\ud805\ude3d"
        + "\ud805\ude3f\ud805\ude40"
        + "\ud805\udeab\ud805\udeab"
        + "\ud805\udead\ud805\udead"
        + "\ud805\udeb0\ud805\udeb5"
        + "\ud805\udeb7\ud805\udeb7"
        + "\ud81a\udef0\ud81a\udef4"
        + "\ud81a\udf30\ud81a\udf36"
        + "\ud81b\udf8f\ud81b\udf92"
        + "\ud82f\udc9d\ud82f\udc9e"
        + "\ud834\udd65\ud834\udd65"
        + "\ud834\udd67\ud834\udd69"
        + "\ud834\udd6e\ud834\udd72"
        + "\ud834\udd7b\ud834\udd82"
        + "\ud834\udd85\ud834\udd8b"
        + "\ud834\uddaa\ud834\uddad"
        + "\ud834\ude42\ud834\ude44"
        + "\ud83a\udcd0\ud83a\udcd6"
        + "\udb40\udd00\udb40\uddef",
    // Unicode 7.0 property value: {graphemeclusterbreak=l}
    "\u1100\u115f" + "\ua960\ua97c",
    // Unicode 7.0 property value: {graphemeclusterbreak=lf}
    "\n\n",
    // Unicode 7.0 property value: {graphemeclusterbreak=lv}
    "\uac00\uac00"
        + "\uac1c\uac1c"
        + "\uac38\uac38"
        + "\uac54\uac54"
        + "\uac70\uac70"
        + "\uac8c\uac8c"
        + "\uaca8\uaca8"
        + "\uacc4\uacc4"
        + "\uace0\uace0"
        + "\uacfc\uacfc"
        + "\uad18\uad18"
        + "\uad34\uad34"
        + "\uad50\uad50"
        + "\uad6c\uad6c"
        + "\uad88\uad88"
        + "\uada4\uada4"
        + "\uadc0\uadc0"
        + "\uaddc\uaddc"
        + "\uadf8\uadf8"
        + "\uae14\uae14"
        + "\uae30\uae30"
        + "\uae4c\uae4c"
        + "\uae68\uae68"
        + "\uae84\uae84"
        + "\uaea0\uaea0"
        + "\uaebc\uaebc"
        + "\uaed8\uaed8"
        + "\uaef4\uaef4"
        + "\uaf10\uaf10"
        + "\uaf2c\uaf2c"
        + "\uaf48\uaf48"
        + "\uaf64\uaf64"
        + "\uaf80\uaf80"
        + "\uaf9c\uaf9c"
        + "\uafb8\uafb8"
        + "\uafd4\uafd4"
        + "\uaff0\uaff0"
        + "\ub00c\ub00c"
        + "\ub028\ub028"
        + "\ub044\ub044"
        + "\ub060\ub060"
        + "\ub07c\ub07c"
        + "\ub098\ub098"
        + "\ub0b4\ub0b4"
        + "\ub0d0\ub0d0"
        + "\ub0ec\ub0ec"
        + "\ub108\ub108"
        + "\ub124\ub124"
        + "\ub140\ub140"
        + "\ub15c\ub15c"
        + "\ub178\ub178"
        + "\ub194\ub194"
        + "\ub1b0\ub1b0"
        + "\ub1cc\ub1cc"
        + "\ub1e8\ub1e8"
        + "\ub204\ub204"
        + "\ub220\ub220"
        + "\ub23c\ub23c"
        + "\ub258\ub258"
        + "\ub274\ub274"
        + "\ub290\ub290"
        + "\ub2ac\ub2ac"
        + "\ub2c8\ub2c8"
        + "\ub2e4\ub2e4"
        + "\ub300\ub300"
        + "\ub31c\ub31c"
        + "\ub338\ub338"
        + "\ub354\ub354"
        + "\ub370\ub370"
        + "\ub38c\ub38c"
        + "\ub3a8\ub3a8"
        + "\ub3c4\ub3c4"
        + "\ub3e0\ub3e0"
        + "\ub3fc\ub3fc"
        + "\ub418\ub418"
        + "\ub434\ub434"
        + "\ub450\ub450"
        + "\ub46c\ub46c"
        + "\ub488\ub488"
        + "\ub4a4\ub4a4"
        + "\ub4c0\ub4c0"
        + "\ub4dc\ub4dc"
        + "\ub4f8\ub4f8"
        + "\ub514\ub514"
        + "\ub530\ub530"
        + "\ub54c\ub54c"
        + "\ub568\ub568"
        + "\ub584\ub584"
        + "\ub5a0\ub5a0"
        + "\ub5bc\ub5bc"
        + "\ub5d8\ub5d8"
        + "\ub5f4\ub5f4"
        + "\ub610\ub610"
        + "\ub62c\ub62c"
        + "\ub648\ub648"
        + "\ub664\ub664"
        + "\ub680\ub680"
        + "\ub69c\ub69c"
        + "\ub6b8\ub6b8"
        + "\ub6d4\ub6d4"
        + "\ub6f0\ub6f0"
        + "\ub70c\ub70c"
        + "\ub728\ub728"
        + "\ub744\ub744"
        + "\ub760\ub760"
        + "\ub77c\ub77c"
        + "\ub798\ub798"
        + "\ub7b4\ub7b4"
        + "\ub7d0\ub7d0"
        + "\ub7ec\ub7ec"
        + "\ub808\ub808"
        + "\ub824\ub824"
        + "\ub840\ub840"
        + "\ub85c\ub85c"
        + "\ub878\ub878"
        + "\ub894\ub894"
        + "\ub8b0\ub8b0"
        + "\ub8cc\ub8cc"
        + "\ub8e8\ub8e8"
        + "\ub904\ub904"
        + "\ub920\ub920"
        + "\ub93c\ub93c"
        + "\ub958\ub958"
        + "\ub974\ub974"
        + "\ub990\ub990"
        + "\ub9ac\ub9ac"
        + "\ub9c8\ub9c8"
        + "\ub9e4\ub9e4"
        + "\uba00\uba00"
        + "\uba1c\uba1c"
        + "\uba38\uba38"
        + "\uba54\uba54"
        + "\uba70\uba70"
        + "\uba8c\uba8c"
        + "\ubaa8\ubaa8"
        + "\ubac4\ubac4"
        + "\ubae0\ubae0"
        + "\ubafc\ubafc"
        + "\ubb18\ubb18"
        + "\ubb34\ubb34"
        + "\ubb50\ubb50"
        + "\ubb6c\ubb6c"
        + "\ubb88\ubb88"
        + "\ubba4\ubba4"
        + "\ubbc0\ubbc0"
        + "\ubbdc\ubbdc"
        + "\ubbf8\ubbf8"
        + "\ubc14\ubc14"
        + "\ubc30\ubc30"
        + "\ubc4c\ubc4c"
        + "\ubc68\ubc68"
        + "\ubc84\ubc84"
        + "\ubca0\ubca0"
        + "\ubcbc\ubcbc"
        + "\ubcd8\ubcd8"
        + "\ubcf4\ubcf4"
        + "\ubd10\ubd10"
        + "\ubd2c\ubd2c"
        + "\ubd48\ubd48"
        + "\ubd64\ubd64"
        + "\ubd80\ubd80"
        + "\ubd9c\ubd9c"
        + "\ubdb8\ubdb8"
        + "\ubdd4\ubdd4"
        + "\ubdf0\ubdf0"
        + "\ube0c\ube0c"
        + "\ube28\ube28"
        + "\ube44\ube44"
        + "\ube60\ube60"
        + "\ube7c\ube7c"
        + "\ube98\ube98"
        + "\ubeb4\ubeb4"
        + "\ubed0\ubed0"
        + "\ubeec\ubeec"
        + "\ubf08\ubf08"
        + "\ubf24\ubf24"
        + "\ubf40\ubf40"
        + "\ubf5c\ubf5c"
        + "\ubf78\ubf78"
        + "\ubf94\ubf94"
        + "\ubfb0\ubfb0"
        + "\ubfcc\ubfcc"
        + "\ubfe8\ubfe8"
        + "\uc004\uc004"
        + "\uc020\uc020"
        + "\uc03c\uc03c"
        + "\uc058\uc058"
        + "\uc074\uc074"
        + "\uc090\uc090"
        + "\uc0ac\uc0ac"
        + "\uc0c8\uc0c8"
        + "\uc0e4\uc0e4"
        + "\uc100\uc100"
        + "\uc11c\uc11c"
        + "\uc138\uc138"
        + "\uc154\uc154"
        + "\uc170\uc170"
        + "\uc18c\uc18c"
        + "\uc1a8\uc1a8"
        + "\uc1c4\uc1c4"
        + "\uc1e0\uc1e0"
        + "\uc1fc\uc1fc"
        + "\uc218\uc218"
        + "\uc234\uc234"
        + "\uc250\uc250"
        + "\uc26c\uc26c"
        + "\uc288\uc288"
        + "\uc2a4\uc2a4"
        + "\uc2c0\uc2c0"
        + "\uc2dc\uc2dc"
        + "\uc2f8\uc2f8"
        + "\uc314\uc314"
        + "\uc330\uc330"
        + "\uc34c\uc34c"
        + "\uc368\uc368"
        + "\uc384\uc384"
        + "\uc3a0\uc3a0"
        + "\uc3bc\uc3bc"
        + "\uc3d8\uc3d8"
        + "\uc3f4\uc3f4"
        + "\uc410\uc410"
        + "\uc42c\uc42c"
        + "\uc448\uc448"
        + "\uc464\uc464"
        + "\uc480\uc480"
        + "\uc49c\uc49c"
        + "\uc4b8\uc4b8"
        + "\uc4d4\uc4d4"
        + "\uc4f0\uc4f0"
        + "\uc50c\uc50c"
        + "\uc528\uc528"
        + "\uc544\uc544"
        + "\uc560\uc560"
        + "\uc57c\uc57c"
        + "\uc598\uc598"
        + "\uc5b4\uc5b4"
        + "\uc5d0\uc5d0"
        + "\uc5ec\uc5ec"
        + "\uc608\uc608"
        + "\uc624\uc624"
        + "\uc640\uc640"
        + "\uc65c\uc65c"
        + "\uc678\uc678"
        + "\uc694\uc694"
        + "\uc6b0\uc6b0"
        + "\uc6cc\uc6cc"
        + "\uc6e8\uc6e8"
        + "\uc704\uc704"
        + "\uc720\uc720"
        + "\uc73c\uc73c"
        + "\uc758\uc758"
        + "\uc774\uc774"
        + "\uc790\uc790"
        + "\uc7ac\uc7ac"
        + "\uc7c8\uc7c8"
        + "\uc7e4\uc7e4"
        + "\uc800\uc800"
        + "\uc81c\uc81c"
        + "\uc838\uc838"
        + "\uc854\uc854"
        + "\uc870\uc870"
        + "\uc88c\uc88c"
        + "\uc8a8\uc8a8"
        + "\uc8c4\uc8c4"
        + "\uc8e0\uc8e0"
        + "\uc8fc\uc8fc"
        + "\uc918\uc918"
        + "\uc934\uc934"
        + "\uc950\uc950"
        + "\uc96c\uc96c"
        + "\uc988\uc988"
        + "\uc9a4\uc9a4"
        + "\uc9c0\uc9c0"
        + "\uc9dc\uc9dc"
        + "\uc9f8\uc9f8"
        + "\uca14\uca14"
        + "\uca30\uca30"
        + "\uca4c\uca4c"
        + "\uca68\uca68"
        + "\uca84\uca84"
        + "\ucaa0\ucaa0"
        + "\ucabc\ucabc"
        + "\ucad8\ucad8"
        + "\ucaf4\ucaf4"
        + "\ucb10\ucb10"
        + "\ucb2c\ucb2c"
        + "\ucb48\ucb48"
        + "\ucb64\ucb64"
        + "\ucb80\ucb80"
        + "\ucb9c\ucb9c"
        + "\ucbb8\ucbb8"
        + "\ucbd4\ucbd4"
        + "\ucbf0\ucbf0"
        + "\ucc0c\ucc0c"
        + "\ucc28\ucc28"
        + "\ucc44\ucc44"
        + "\ucc60\ucc60"
        + "\ucc7c\ucc7c"
        + "\ucc98\ucc98"
        + "\uccb4\uccb4"
        + "\uccd0\uccd0"
        + "\uccec\uccec"
        + "\ucd08\ucd08"
        + "\ucd24\ucd24"
        + "\ucd40\ucd40"
        + "\ucd5c\ucd5c"
        + "\ucd78\ucd78"
        + "\ucd94\ucd94"
        + "\ucdb0\ucdb0"
        + "\ucdcc\ucdcc"
        + "\ucde8\ucde8"
        + "\uce04\uce04"
        + "\uce20\uce20"
        + "\uce3c\uce3c"
        + "\uce58\uce58"
        + "\uce74\uce74"
        + "\uce90\uce90"
        + "\uceac\uceac"
        + "\ucec8\ucec8"
        + "\ucee4\ucee4"
        + "\ucf00\ucf00"
        + "\ucf1c\ucf1c"
        + "\ucf38\ucf38"
        + "\ucf54\ucf54"
        + "\ucf70\ucf70"
        + "\ucf8c\ucf8c"
        + "\ucfa8\ucfa8"
        + "\ucfc4\ucfc4"
        + "\ucfe0\ucfe0"
        + "\ucffc\ucffc"
        + "\ud018\ud018"
        + "\ud034\ud034"
        + "\ud050\ud050"
        + "\ud06c\ud06c"
        + "\ud088\ud088"
        + "\ud0a4\ud0a4"
        + "\ud0c0\ud0c0"
        + "\ud0dc\ud0dc"
        + "\ud0f8\ud0f8"
        + "\ud114\ud114"
        + "\ud130\ud130"
        + "\ud14c\ud14c"
        + "\ud168\ud168"
        + "\ud184\ud184"
        + "\ud1a0\ud1a0"
        + "\ud1bc\ud1bc"
        + "\ud1d8\ud1d8"
        + "\ud1f4\ud1f4"
        + "\ud210\ud210"
        + "\ud22c\ud22c"
        + "\ud248\ud248"
        + "\ud264\ud264"
        + "\ud280\ud280"
        + "\ud29c\ud29c"
        + "\ud2b8\ud2b8"
        + "\ud2d4\ud2d4"
        + "\ud2f0\ud2f0"
        + "\ud30c\ud30c"
        + "\ud328\ud328"
        + "\ud344\ud344"
        + "\ud360\ud360"
        + "\ud37c\ud37c"
        + "\ud398\ud398"
        + "\ud3b4\ud3b4"
        + "\ud3d0\ud3d0"
        + "\ud3ec\ud3ec"
        + "\ud408\ud408"
        + "\ud424\ud424"
        + "\ud440\ud440"
        + "\ud45c\ud45c"
        + "\ud478\ud478"
        + "\ud494\ud494"
        + "\ud4b0\ud4b0"
        + "\ud4cc\ud4cc"
        + "\ud4e8\ud4e8"
        + "\ud504\ud504"
        + "\ud520\ud520"
        + "\ud53c\ud53c"
        + "\ud558\ud558"
        + "\ud574\ud574"
        + "\ud590\ud590"
        + "\ud5ac\ud5ac"
        + "\ud5c8\ud5c8"
        + "\ud5e4\ud5e4"
        + "\ud600\ud600"
        + "\ud61c\ud61c"
        + "\ud638\ud638"
        + "\ud654\ud654"
        + "\ud670\ud670"
        + "\ud68c\ud68c"
        + "\ud6a8\ud6a8"
        + "\ud6c4\ud6c4"
        + "\ud6e0\ud6e0"
        + "\ud6fc\ud6fc"
        + "\ud718\ud718"
        + "\ud734\ud734"
        + "\ud750\ud750"
        + "\ud76c\ud76c"
        + "\ud788\ud788",
    // Unicode 7.0 property value: {graphemeclusterbreak=lvt}
    "\uac01\uac1b"
        + "\uac1d\uac37"
        + "\uac39\uac53"
        + "\uac55\uac6f"
        + "\uac71\uac8b"
        + "\uac8d\uaca7"
        + "\uaca9\uacc3"
        + "\uacc5\uacdf"
        + "\uace1\uacfb"
        + "\uacfd\uad17"
        + "\uad19\uad33"
        + "\uad35\uad4f"
        + "\uad51\uad6b"
        + "\uad6d\uad87"
        + "\uad89\uada3"
        + "\uada5\uadbf"
        + "\uadc1\uaddb"
        + "\uaddd\uadf7"
        + "\uadf9\uae13"
        + "\uae15\uae2f"
        + "\uae31\uae4b"
        + "\uae4d\uae67"
        + "\uae69\uae83"
        + "\uae85\uae9f"
        + "\uaea1\uaebb"
        + "\uaebd\uaed7"
        + "\uaed9\uaef3"
        + "\uaef5\uaf0f"
        + "\uaf11\uaf2b"
        + "\uaf2d\uaf47"
        + "\uaf49\uaf63"
        + "\uaf65\uaf7f"
        + "\uaf81\uaf9b"
        + "\uaf9d\uafb7"
        + "\uafb9\uafd3"
        + "\uafd5\uafef"
        + "\uaff1\ub00b"
        + "\ub00d\ub027"
        + "\ub029\ub043"
        + "\ub045\ub05f"
        + "\ub061\ub07b"
        + "\ub07d\ub097"
        + "\ub099\ub0b3"
        + "\ub0b5\ub0cf"
        + "\ub0d1\ub0eb"
        + "\ub0ed\ub107"
        + "\ub109\ub123"
        + "\ub125\ub13f"
        + "\ub141\ub15b"
        + "\ub15d\ub177"
        + "\ub179\ub193"
        + "\ub195\ub1af"
        + "\ub1b1\ub1cb"
        + "\ub1cd\ub1e7"
        + "\ub1e9\ub203"
        + "\ub205\ub21f"
        + "\ub221\ub23b"
        + "\ub23d\ub257"
        + "\ub259\ub273"
        + "\ub275\ub28f"
        + "\ub291\ub2ab"
        + "\ub2ad\ub2c7"
        + "\ub2c9\ub2e3"
        + "\ub2e5\ub2ff"
        + "\ub301\ub31b"
        + "\ub31d\ub337"
        + "\ub339\ub353"
        + "\ub355\ub36f"
        + "\ub371\ub38b"
        + "\ub38d\ub3a7"
        + "\ub3a9\ub3c3"
        + "\ub3c5\ub3df"
        + "\ub3e1\ub3fb"
        + "\ub3fd\ub417"
        + "\ub419\ub433"
        + "\ub435\ub44f"
        + "\ub451\ub46b"
        + "\ub46d\ub487"
        + "\ub489\ub4a3"
        + "\ub4a5\ub4bf"
        + "\ub4c1\ub4db"
        + "\ub4dd\ub4f7"
        + "\ub4f9\ub513"
        + "\ub515\ub52f"
        + "\ub531\ub54b"
        + "\ub54d\ub567"
        + "\ub569\ub583"
        + "\ub585\ub59f"
        + "\ub5a1\ub5bb"
        + "\ub5bd\ub5d7"
        + "\ub5d9\ub5f3"
        + "\ub5f5\ub60f"
        + "\ub611\ub62b"
        + "\ub62d\ub647"
        + "\ub649\ub663"
        + "\ub665\ub67f"
        + "\ub681\ub69b"
        + "\ub69d\ub6b7"
        + "\ub6b9\ub6d3"
        + "\ub6d5\ub6ef"
        + "\ub6f1\ub70b"
        + "\ub70d\ub727"
        + "\ub729\ub743"
        + "\ub745\ub75f"
        + "\ub761\ub77b"
        + "\ub77d\ub797"
        + "\ub799\ub7b3"
        + "\ub7b5\ub7cf"
        + "\ub7d1\ub7eb"
        + "\ub7ed\ub807"
        + "\ub809\ub823"
        + "\ub825\ub83f"
        + "\ub841\ub85b"
        + "\ub85d\ub877"
        + "\ub879\ub893"
        + "\ub895\ub8af"
        + "\ub8b1\ub8cb"
        + "\ub8cd\ub8e7"
        + "\ub8e9\ub903"
        + "\ub905\ub91f"
        + "\ub921\ub93b"
        + "\ub93d\ub957"
        + "\ub959\ub973"
        + "\ub975\ub98f"
        + "\ub991\ub9ab"
        + "\ub9ad\ub9c7"
        + "\ub9c9\ub9e3"
        + "\ub9e5\ub9ff"
        + "\uba01\uba1b"
        + "\uba1d\uba37"
        + "\uba39\uba53"
        + "\uba55\uba6f"
        + "\uba71\uba8b"
        + "\uba8d\ubaa7"
        + "\ubaa9\ubac3"
        + "\ubac5\ubadf"
        + "\ubae1\ubafb"
        + "\ubafd\ubb17"
        + "\ubb19\ubb33"
        + "\ubb35\ubb4f"
        + "\ubb51\ubb6b"
        + "\ubb6d\ubb87"
        + "\ubb89\ubba3"
        + "\ubba5\ubbbf"
        + "\ubbc1\ubbdb"
        + "\ubbdd\ubbf7"
        + "\ubbf9\ubc13"
        + "\ubc15\ubc2f"
        + "\ubc31\ubc4b"
        + "\ubc4d\ubc67"
        + "\ubc69\ubc83"
        + "\ubc85\ubc9f"
        + "\ubca1\ubcbb"
        + "\ubcbd\ubcd7"
        + "\ubcd9\ubcf3"
        + "\ubcf5\ubd0f"
        + "\ubd11\ubd2b"
        + "\ubd2d\ubd47"
        + "\ubd49\ubd63"
        + "\ubd65\ubd7f"
        + "\ubd81\ubd9b"
        + "\ubd9d\ubdb7"
        + "\ubdb9\ubdd3"
        + "\ubdd5\ubdef"
        + "\ubdf1\ube0b"
        + "\ube0d\ube27"
        + "\ube29\ube43"
        + "\ube45\ube5f"
        + "\ube61\ube7b"
        + "\ube7d\ube97"
        + "\ube99\ubeb3"
        + "\ubeb5\ubecf"
        + "\ubed1\ubeeb"
        + "\ubeed\ubf07"
        + "\ubf09\ubf23"
        + "\ubf25\ubf3f"
        + "\ubf41\ubf5b"
        + "\ubf5d\ubf77"
        + "\ubf79\ubf93"
        + "\ubf95\ubfaf"
        + "\ubfb1\ubfcb"
        + "\ubfcd\ubfe7"
        + "\ubfe9\uc003"
        + "\uc005\uc01f"
        + "\uc021\uc03b"
        + "\uc03d\uc057"
        + "\uc059\uc073"
        + "\uc075\uc08f"
        + "\uc091\uc0ab"
        + "\uc0ad\uc0c7"
        + "\uc0c9\uc0e3"
        + "\uc0e5\uc0ff"
        + "\uc101\uc11b"
        + "\uc11d\uc137"
        + "\uc139\uc153"
        + "\uc155\uc16f"
        + "\uc171\uc18b"
        + "\uc18d\uc1a7"
        + "\uc1a9\uc1c3"
        + "\uc1c5\uc1df"
        + "\uc1e1\uc1fb"
        + "\uc1fd\uc217"
        + "\uc219\uc233"
        + "\uc235\uc24f"
        + "\uc251\uc26b"
        + "\uc26d\uc287"
        + "\uc289\uc2a3"
        + "\uc2a5\uc2bf"
        + "\uc2c1\uc2db"
        + "\uc2dd\uc2f7"
        + "\uc2f9\uc313"
        + "\uc315\uc32f"
        + "\uc331\uc34b"
        + "\uc34d\uc367"
        + "\uc369\uc383"
        + "\uc385\uc39f"
        + "\uc3a1\uc3bb"
        + "\uc3bd\uc3d7"
        + "\uc3d9\uc3f3"
        + "\uc3f5\uc40f"
        + "\uc411\uc42b"
        + "\uc42d\uc447"
        + "\uc449\uc463"
        + "\uc465\uc47f"
        + "\uc481\uc49b"
        + "\uc49d\uc4b7"
        + "\uc4b9\uc4d3"
        + "\uc4d5\uc4ef"
        + "\uc4f1\uc50b"
        + "\uc50d\uc527"
        + "\uc529\uc543"
        + "\uc545\uc55f"
        + "\uc561\uc57b"
        + "\uc57d\uc597"
        + "\uc599\uc5b3"
        + "\uc5b5\uc5cf"
        + "\uc5d1\uc5eb"
        + "\uc5ed\uc607"
        + "\uc609\uc623"
        + "\uc625\uc63f"
        + "\uc641\uc65b"
        + "\uc65d\uc677"
        + "\uc679\uc693"
        + "\uc695\uc6af"
        + "\uc6b1\uc6cb"
        + "\uc6cd\uc6e7"
        + "\uc6e9\uc703"
        + "\uc705\uc71f"
        + "\uc721\uc73b"
        + "\uc73d\uc757"
        + "\uc759\uc773"
        + "\uc775\uc78f"
        + "\uc791\uc7ab"
        + "\uc7ad\uc7c7"
        + "\uc7c9\uc7e3"
        + "\uc7e5\uc7ff"
        + "\uc801\uc81b"
        + "\uc81d\uc837"
        + "\uc839\uc853"
        + "\uc855\uc86f"
        + "\uc871\uc88b"
        + "\uc88d\uc8a7"
        + "\uc8a9\uc8c3"
        + "\uc8c5\uc8df"
        + "\uc8e1\uc8fb"
        + "\uc8fd\uc917"
        + "\uc919\uc933"
        + "\uc935\uc94f"
        + "\uc951\uc96b"
        + "\uc96d\uc987"
        + "\uc989\uc9a3"
        + "\uc9a5\uc9bf"
        + "\uc9c1\uc9db"
        + "\uc9dd\uc9f7"
        + "\uc9f9\uca13"
        + "\uca15\uca2f"
        + "\uca31\uca4b"
        + "\uca4d\uca67"
        + "\uca69\uca83"
        + "\uca85\uca9f"
        + "\ucaa1\ucabb"
        + "\ucabd\ucad7"
        + "\ucad9\ucaf3"
        + "\ucaf5\ucb0f"
        + "\ucb11\ucb2b"
        + "\ucb2d\ucb47"
        + "\ucb49\ucb63"
        + "\ucb65\ucb7f"
        + "\ucb81\ucb9b"
        + "\ucb9d\ucbb7"
        + "\ucbb9\ucbd3"
        + "\ucbd5\ucbef"
        + "\ucbf1\ucc0b"
        + "\ucc0d\ucc27"
        + "\ucc29\ucc43"
        + "\ucc45\ucc5f"
        + "\ucc61\ucc7b"
        + "\ucc7d\ucc97"
        + "\ucc99\uccb3"
        + "\uccb5\ucccf"
        + "\uccd1\ucceb"
        + "\ucced\ucd07"
        + "\ucd09\ucd23"
        + "\ucd25\ucd3f"
        + "\ucd41\ucd5b"
        + "\ucd5d\ucd77"
        + "\ucd79\ucd93"
        + "\ucd95\ucdaf"
        + "\ucdb1\ucdcb"
        + "\ucdcd\ucde7"
        + "\ucde9\uce03"
        + "\uce05\uce1f"
        + "\uce21\uce3b"
        + "\uce3d\uce57"
        + "\uce59\uce73"
        + "\uce75\uce8f"
        + "\uce91\uceab"
        + "\ucead\ucec7"
        + "\ucec9\ucee3"
        + "\ucee5\uceff"
        + "\ucf01\ucf1b"
        + "\ucf1d\ucf37"
        + "\ucf39\ucf53"
        + "\ucf55\ucf6f"
        + "\ucf71\ucf8b"
        + "\ucf8d\ucfa7"
        + "\ucfa9\ucfc3"
        + "\ucfc5\ucfdf"
        + "\ucfe1\ucffb"
        + "\ucffd\ud017"
        + "\ud019\ud033"
        + "\ud035\ud04f"
        + "\ud051\ud06b"
        + "\ud06d\ud087"
        + "\ud089\ud0a3"
        + "\ud0a5\ud0bf"
        + "\ud0c1\ud0db"
        + "\ud0dd\ud0f7"
        + "\ud0f9\ud113"
        + "\ud115\ud12f"
        + "\ud131\ud14b"
        + "\ud14d\ud167"
        + "\ud169\ud183"
        + "\ud185\ud19f"
        + "\ud1a1\ud1bb"
        + "\ud1bd\ud1d7"
        + "\ud1d9\ud1f3"
        + "\ud1f5\ud20f"
        + "\ud211\ud22b"
        + "\ud22d\ud247"
        + "\ud249\ud263"
        + "\ud265\ud27f"
        + "\ud281\ud29b"
        + "\ud29d\ud2b7"
        + "\ud2b9\ud2d3"
        + "\ud2d5\ud2ef"
        + "\ud2f1\ud30b"
        + "\ud30d\ud327"
        + "\ud329\ud343"
        + "\ud345\ud35f"
        + "\ud361\ud37b"
        + "\ud37d\ud397"
        + "\ud399\ud3b3"
        + "\ud3b5\ud3cf"
        + "\ud3d1\ud3eb"
        + "\ud3ed\ud407"
        + "\ud409\ud423"
        + "\ud425\ud43f"
        + "\ud441\ud45b"
        + "\ud45d\ud477"
        + "\ud479\ud493"
        + "\ud495\ud4af"
        + "\ud4b1\ud4cb"
        + "\ud4cd\ud4e7"
        + "\ud4e9\ud503"
        + "\ud505\ud51f"
        + "\ud521\ud53b"
        + "\ud53d\ud557"
        + "\ud559\ud573"
        + "\ud575\ud58f"
        + "\ud591\ud5ab"
        + "\ud5ad\ud5c7"
        + "\ud5c9\ud5e3"
        + "\ud5e5\ud5ff"
        + "\ud601\ud61b"
        + "\ud61d\ud637"
        + "\ud639\ud653"
        + "\ud655\ud66f"
        + "\ud671\ud68b"
        + "\ud68d\ud6a7"
        + "\ud6a9\ud6c3"
        + "\ud6c5\ud6df"
        + "\ud6e1\ud6fb"
        + "\ud6fd\ud717"
        + "\ud719\ud733"
        + "\ud735\ud74f"
        + "\ud751\ud76b"
        + "\ud76d\ud787"
        + "\ud789\ud7a3",
    // Unicode 7.0 property value: {graphemeclusterbreak=other}
    "\u0020\u007e"
        + "\u00a0\u00ac"
        + "\u00ae\u02ff"
        + "\u0370\u0482"
        + "\u048a\u0590"
        + "\u05be\u05be"
        + "\u05c0\u05c0"
        + "\u05c3\u05c3"
        + "\u05c6\u05c6"
        + "\u05c8\u05ff"
        + "\u0606\u060f"
        + "\u061b\u061b"
        + "\u061d\u064a"
        + "\u0660\u066f"
        + "\u0671\u06d5"
        + "\u06de\u06de"
        + "\u06e5\u06e6"
        + "\u06e9\u06e9"
        + "\u06ee\u070e"
        + "\u0710\u0710"
        + "\u0712\u072f"
        + "\u074b\u07a5"
        + "\u07b1\u07ea"
        + "\u07f4\u0815"
        + "\u081a\u081a"
        + "\u0824\u0824"
        + "\u0828\u0828"
        + "\u082e\u0858"
        + "\u085c\u08e3"
        + "\u0904\u0939"
        + "\u093d\u093d"
        + "\u0950\u0950"
        + "\u0958\u0961"
        + "\u0964\u0980"
        + "\u0984\u09bb"
        + "\u09bd\u09bd"
        + "\u09c5\u09c6"
        + "\u09c9\u09ca"
        + "\u09ce\u09d6"
        + "\u09d8\u09e1"
        + "\u09e4\u0a00"
        + "\u0a04\u0a3b"
        + "\u0a3d\u0a3d"
        + "\u0a43\u0a46"
        + "\u0a49\u0a4a"
        + "\u0a4e\u0a50"
        + "\u0a52\u0a6f"
        + "\u0a72\u0a74"
        + "\u0a76\u0a80"
        + "\u0a84\u0abb"
        + "\u0abd\u0abd"
        + "\u0ac6\u0ac6"
        + "\u0aca\u0aca"
        + "\u0ace\u0ae1"
        + "\u0ae4\u0b00"
        + "\u0b04\u0b3b"
        + "\u0b3d\u0b3d"
        + "\u0b45\u0b46"
        + "\u0b49\u0b4a"
        + "\u0b4e\u0b55"
        + "\u0b58\u0b61"
        + "\u0b64\u0b81"
        + "\u0b83\u0bbd"
        + "\u0bc3\u0bc5"
        + "\u0bc9\u0bc9"
        + "\u0bce\u0bd6"
        + "\u0bd8\u0bff"
        + "\u0c04\u0c3d"
        + "\u0c45\u0c45"
        + "\u0c49\u0c49"
        + "\u0c4e\u0c54"
        + "\u0c57\u0c61"
        + "\u0c64\u0c80"
        + "\u0c84\u0cbb"
        + "\u0cbd\u0cbd"
        + "\u0cc5\u0cc5"
        + "\u0cc9\u0cc9"
        + "\u0cce\u0cd4"
        + "\u0cd7\u0ce1"
        + "\u0ce4\u0d00"
        + "\u0d04\u0d3d"
        + "\u0d45\u0d45"
        + "\u0d49\u0d49"
        + "\u0d4e\u0d56"
        + "\u0d58\u0d61"
        + "\u0d64\u0d81"
        + "\u0d84\u0dc9"
        + "\u0dcb\u0dce"
        + "\u0dd5\u0dd5"
        + "\u0dd7\u0dd7"
        + "\u0de0\u0df1"
        + "\u0df4\u0e30"
        + "\u0e32\u0e32"
        + "\u0e3b\u0e46"
        + "\u0e4f\u0eb0"
        + "\u0eb2\u0eb2"
        + "\u0eba\u0eba"
        + "\u0ebd\u0ec7"
        + "\u0ece\u0f17"
        + "\u0f1a\u0f34"
        + "\u0f36\u0f36"
        + "\u0f38\u0f38"
        + "\u0f3a\u0f3d"
        + "\u0f40\u0f70"
        + "\u0f85\u0f85"
        + "\u0f88\u0f8c"
        + "\u0f98\u0f98"
        + "\u0fbd\u0fc5"
        + "\u0fc7\u102c"
        + "\u1038\u1038"
        + "\u103f\u1055"
        + "\u105a\u105d"
        + "\u1061\u1070"
        + "\u1075\u1081"
        + "\u1083\u1083"
        + "\u1087\u108c"
        + "\u108e\u109c"
        + "\u109e\u10ff"
        + "\u1200\u135c"
        + "\u1360\u1711"
        + "\u1715\u1731"
        + "\u1735\u1751"
        + "\u1754\u1771"
        + "\u1774\u17b3"
        + "\u17d4\u17dc"
        + "\u17de\u180a"
        + "\u180f\u18a8"
        + "\u18aa\u191f"
        + "\u192c\u192f"
        + "\u193c\u19b4"
        + "\u19b8\u19b9"
        + "\u19bb\u1a16"
        + "\u1a1c\u1a54"
        + "\u1a5f\u1a5f"
        + "\u1a61\u1a61"
        + "\u1a63\u1a64"
        + "\u1a7d\u1a7e"
        + "\u1a80\u1aaf"
        + "\u1abf\u1aff"
        + "\u1b05\u1b33"
        + "\u1b45\u1b6a"
        + "\u1b74\u1b7f"
        + "\u1b83\u1ba0"
        + "\u1bae\u1be5"
        + "\u1bf4\u1c23"
        + "\u1c38\u1ccf"
        + "\u1cd3\u1cd3"
        + "\u1ce9\u1cec"
        + "\u1cee\u1cf1"
        + "\u1cf5\u1cf7"
        + "\u1cfa\u1dbf"
        + "\u1df6\u1dfb"
        + "\u1e00\u200a"
        + "\u2010\u2027"
        + "\u202f\u205f"
        + "\u2070\u20cf"
        + "\u20f1\u2cee"
        + "\u2cf2\u2d7e"
        + "\u2d80\u2ddf"
        + "\u2e00\u3029"
        + "\u3030\u3098"
        + "\u309b\ua66e"
        + "\ua673\ua673"
        + "\ua67e\ua69e"
        + "\ua6a0\ua6ef"
        + "\ua6f2\ua801"
        + "\ua803\ua805"
        + "\ua807\ua80a"
        + "\ua80c\ua822"
        + "\ua828\ua87f"
        + "\ua882\ua8b3"
        + "\ua8c5\ua8df"
        + "\ua8f2\ua925"
        + "\ua92e\ua946"
        + "\ua954\ua95f"
        + "\ua97d\ua97f"
        + "\ua984\ua9b2"
        + "\ua9c1\ua9e4"
        + "\ua9e6\uaa28"
        + "\uaa37\uaa42"
        + "\uaa44\uaa4b"
        + "\uaa4e\uaa7b"
        + "\uaa7d\uaaaf"
        + "\uaab1\uaab1"
        + "\uaab5\uaab6"
        + "\uaab9\uaabd"
        + "\uaac0\uaac0"
        + "\uaac2\uaaea"
        + "\uaaf0\uaaf4"
        + "\uaaf7\uabe2"
        + "\uabeb\uabeb"
        + "\uabee\uabff"
        + "\ud7a4\ud7af"
        + "\ud7c7\ud7ca"
        + "\ud7fc\ud7ff"
        + "\ue000\ufb1d"
        + "\ufb1f\ufdff"
        + "\ufe10\ufe1f"
        + "\ufe2e\ufefe"
        + "\uff00\uff9d"
        + "\uffa0\uffef"
        + "\ufffc\ud800\uddfc"
        + "\ud800\uddfe\ud800\udedf"
        + "\ud800\udee1\ud800\udf75"
        + "\ud800\udf7b\ud802\ude00"
        + "\ud802\ude04\ud802\ude04"
        + "\ud802\ude07\ud802\ude0b"
        + "\ud802\ude10\ud802\ude37"
        + "\ud802\ude3b\ud802\ude3e"
        + "\ud802\ude40\ud802\udee4"
        + "\ud802\udee7\ud803\udfff"
        + "\ud804\udc03\ud804\udc37"
        + "\ud804\udc47\ud804\udc7e"
        + "\ud804\udc83\ud804\udcaf"
        + "\ud804\udcbb\ud804\udcbc"
        + "\ud804\udcbe\ud804\udcff"
        + "\ud804\udd03\ud804\udd26"
        + "\ud804\udd35\ud804\udd72"
        + "\ud804\udd74\ud804\udd7f"
        + "\ud804\udd83\ud804\uddb2"
        + "\ud804\uddc1\ud804\ude2b"
        + "\ud804\ude38\ud804\udede"
        + "\ud804\udeeb\ud804\udf00"
        + "\ud804\udf04\ud804\udf3b"
        + "\ud804\udf3d\ud804\udf3d"
        + "\ud804\udf45\ud804\udf46"
        + "\ud804\udf49\ud804\udf4a"
        + "\ud804\udf4e\ud804\udf56"
        + "\ud804\udf58\ud804\udf61"
        + "\ud804\udf64\ud804\udf65"
        + "\ud804\udf6d\ud804\udf6f"
        + "\ud804\udf75\ud805\udcaf"
        + "\ud805\udcc4\ud805\uddae"
        + "\ud805\uddb6\ud805\uddb7"
        + "\ud805\uddc1\ud805\ude2f"
        + "\ud805\ude41\ud805\udeaa"
        + "\ud805\udeb8\ud81a\udeef"
        + "\ud81a\udef5\ud81a\udf2f"
        + "\ud81a\udf37\ud81b\udf50"
        + "\ud81b\udf7f\ud81b\udf8e"
        + "\ud81b\udf93\ud82f\udc9c"
        + "\ud82f\udc9f\ud82f\udc9f"
        + "\ud82f\udca4\ud834\udd64"
        + "\ud834\udd6a\ud834\udd6c"
        + "\ud834\udd83\ud834\udd84"
        + "\ud834\udd8c\ud834\udda9"
        + "\ud834\uddae\ud834\ude41"
        + "\ud834\ude45\ud83a\udccf"
        + "\ud83a\udcd7\ud83c\udde5"
        + "\ud83c\ude00\udb3f\udfff"
        + "\udb44\udc00\udbff\udfff",
    // Unicode 7.0 property value: {graphemeclusterbreak=regionalindicator}
    "\ud83c\udde6\ud83c\uddff",
    // Unicode 7.0 property value: {graphemeclusterbreak=spacingmark}
    "\u0903\u0903"
        + "\u093b\u093b"
        + "\u093e\u0940"
        + "\u0949\u094c"
        + "\u094e\u094f"
        + "\u0982\u0983"
        + "\u09bf\u09c0"
        + "\u09c7\u09c8"
        + "\u09cb\u09cc"
        + "\u0a03\u0a03"
        + "\u0a3e\u0a40"
        + "\u0a83\u0a83"
        + "\u0abe\u0ac0"
        + "\u0ac9\u0ac9"
        + "\u0acb\u0acc"
        + "\u0b02\u0b03"
        + "\u0b40\u0b40"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4c"
        + "\u0bbf\u0bbf"
        + "\u0bc1\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcc"
        + "\u0c01\u0c03"
        + "\u0c41\u0c44"
        + "\u0c82\u0c83"
        + "\u0cbe\u0cbe"
        + "\u0cc0\u0cc1"
        + "\u0cc3\u0cc4"
        + "\u0cc7\u0cc8"
        + "\u0cca\u0ccb"
        + "\u0d02\u0d03"
        + "\u0d3f\u0d40"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4c"
        + "\u0d82\u0d83"
        + "\u0dd0\u0dd1"
        + "\u0dd8\u0dde"
        + "\u0df2\u0df3"
        + "\u0e33\u0e33"
        + "\u0eb3\u0eb3"
        + "\u0f3e\u0f3f"
        + "\u0f7f\u0f7f"
        + "\u1031\u1031"
        + "\u103b\u103c"
        + "\u1056\u1057"
        + "\u1084\u1084"
        + "\u17b6\u17b6"
        + "\u17be\u17c5"
        + "\u17c7\u17c8"
        + "\u1923\u1926"
        + "\u1929\u192b"
        + "\u1930\u1931"
        + "\u1933\u1938"
        + "\u19b5\u19b7"
        + "\u19ba\u19ba"
        + "\u1a19\u1a1a"
        + "\u1a55\u1a55"
        + "\u1a57\u1a57"
        + "\u1a6d\u1a72"
        + "\u1b04\u1b04"
        + "\u1b35\u1b35"
        + "\u1b3b\u1b3b"
        + "\u1b3d\u1b41"
        + "\u1b43\u1b44"
        + "\u1b82\u1b82"
        + "\u1ba1\u1ba1"
        + "\u1ba6\u1ba7"
        + "\u1baa\u1baa"
        + "\u1be7\u1be7"
        + "\u1bea\u1bec"
        + "\u1bee\u1bee"
        + "\u1bf2\u1bf3"
        + "\u1c24\u1c2b"
        + "\u1c34\u1c35"
        + "\u1ce1\u1ce1"
        + "\u1cf2\u1cf3"
        + "\ua823\ua824"
        + "\ua827\ua827"
        + "\ua880\ua881"
        + "\ua8b4\ua8c3"
        + "\ua952\ua953"
        + "\ua983\ua983"
        + "\ua9b4\ua9b5"
        + "\ua9ba\ua9bb"
        + "\ua9bd\ua9c0"
        + "\uaa2f\uaa30"
        + "\uaa33\uaa34"
        + "\uaa4d\uaa4d"
        + "\uaaeb\uaaeb"
        + "\uaaee\uaaef"
        + "\uaaf5\uaaf5"
        + "\uabe3\uabe4"
        + "\uabe6\uabe7"
        + "\uabe9\uabea"
        + "\uabec\uabec"
        + "\ud804\udc00\ud804\udc00"
        + "\ud804\udc02\ud804\udc02"
        + "\ud804\udc82\ud804\udc82"
        + "\ud804\udcb0\ud804\udcb2"
        + "\ud804\udcb7\ud804\udcb8"
        + "\ud804\udd2c\ud804\udd2c"
        + "\ud804\udd82\ud804\udd82"
        + "\ud804\uddb3\ud804\uddb5"
        + "\ud804\uddbf\ud804\uddc0"
        + "\ud804\ude2c\ud804\ude2e"
        + "\ud804\ude32\ud804\ude33"
        + "\ud804\ude35\ud804\ude35"
        + "\ud804\udee0\ud804\udee2"
        + "\ud804\udf02\ud804\udf03"
        + "\ud804\udf3f\ud804\udf3f"
        + "\ud804\udf41\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf62\ud804\udf63"
        + "\ud805\udcb1\ud805\udcb2"
        + "\ud805\udcb9\ud805\udcb9"
        + "\ud805\udcbb\ud805\udcbc"
        + "\ud805\udcbe\ud805\udcbe"
        + "\ud805\udcc1\ud805\udcc1"
        + "\ud805\uddb0\ud805\uddb1"
        + "\ud805\uddb8\ud805\uddbb"
        + "\ud805\uddbe\ud805\uddbe"
        + "\ud805\ude30\ud805\ude32"
        + "\ud805\ude3b\ud805\ude3c"
        + "\ud805\ude3e\ud805\ude3e"
        + "\ud805\udeac\ud805\udeac"
        + "\ud805\udeae\ud805\udeaf"
        + "\ud805\udeb6\ud805\udeb6"
        + "\ud81b\udf51\ud81b\udf7e"
        + "\ud834\udd66\ud834\udd66"
        + "\ud834\udd6d\ud834\udd6d",
    // Unicode 7.0 property value: {graphemeclusterbreak=t}
    "\u11a8\u11ff" + "\ud7cb\ud7fb",
    // Unicode 7.0 property value: {graphemeclusterbreak=v}
    "\u1160\u11a7" + "\ud7b0\ud7c6",
    // Unicode 7.0 property value: {graphemeextend}
    "\u0300\u036f"
        + "\u0483\u0489"
        + "\u0591\u05bd"
        + "\u05bf\u05bf"
        + "\u05c1\u05c2"
        + "\u05c4\u05c5"
        + "\u05c7\u05c7"
        + "\u0610\u061a"
        + "\u064b\u065f"
        + "\u0670\u0670"
        + "\u06d6\u06dc"
        + "\u06df\u06e4"
        + "\u06e7\u06e8"
        + "\u06ea\u06ed"
        + "\u0711\u0711"
        + "\u0730\u074a"
        + "\u07a6\u07b0"
        + "\u07eb\u07f3"
        + "\u0816\u0819"
        + "\u081b\u0823"
        + "\u0825\u0827"
        + "\u0829\u082d"
        + "\u0859\u085b"
        + "\u08e4\u0902"
        + "\u093a\u093a"
        + "\u093c\u093c"
        + "\u0941\u0948"
        + "\u094d\u094d"
        + "\u0951\u0957"
        + "\u0962\u0963"
        + "\u0981\u0981"
        + "\u09bc\u09bc"
        + "\u09be\u09be"
        + "\u09c1\u09c4"
        + "\u09cd\u09cd"
        + "\u09d7\u09d7"
        + "\u09e2\u09e3"
        + "\u0a01\u0a02"
        + "\u0a3c\u0a3c"
        + "\u0a41\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a70\u0a71"
        + "\u0a75\u0a75"
        + "\u0a81\u0a82"
        + "\u0abc\u0abc"
        + "\u0ac1\u0ac5"
        + "\u0ac7\u0ac8"
        + "\u0acd\u0acd"
        + "\u0ae2\u0ae3"
        + "\u0b01\u0b01"
        + "\u0b3c\u0b3c"
        + "\u0b3e\u0b3f"
        + "\u0b41\u0b44"
        + "\u0b4d\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b62\u0b63"
        + "\u0b82\u0b82"
        + "\u0bbe\u0bbe"
        + "\u0bc0\u0bc0"
        + "\u0bcd\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0c00\u0c00"
        + "\u0c3e\u0c40"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c62\u0c63"
        + "\u0c81\u0c81"
        + "\u0cbc\u0cbc"
        + "\u0cbf\u0cbf"
        + "\u0cc2\u0cc2"
        + "\u0cc6\u0cc6"
        + "\u0ccc\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0ce2\u0ce3"
        + "\u0d01\u0d01"
        + "\u0d3e\u0d3e"
        + "\u0d41\u0d44"
        + "\u0d4d\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d62\u0d63"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dcf"
        + "\u0dd2\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0ddf\u0ddf"
        + "\u0e31\u0e31"
        + "\u0e34\u0e3a"
        + "\u0e47\u0e4e"
        + "\u0eb1\u0eb1"
        + "\u0eb4\u0eb9"
        + "\u0ebb\u0ebc"
        + "\u0ec8\u0ecd"
        + "\u0f18\u0f19"
        + "\u0f35\u0f35"
        + "\u0f37\u0f37"
        + "\u0f39\u0f39"
        + "\u0f71\u0f7e"
        + "\u0f80\u0f84"
        + "\u0f86\u0f87"
        + "\u0f8d\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fc6\u0fc6"
        + "\u102d\u1030"
        + "\u1032\u1037"
        + "\u1039\u103a"
        + "\u103d\u103e"
        + "\u1058\u1059"
        + "\u105e\u1060"
        + "\u1071\u1074"
        + "\u1082\u1082"
        + "\u1085\u1086"
        + "\u108d\u108d"
        + "\u109d\u109d"
        + "\u135d\u135f"
        + "\u1712\u1714"
        + "\u1732\u1734"
        + "\u1752\u1753"
        + "\u1772\u1773"
        + "\u17b4\u17b5"
        + "\u17b7\u17bd"
        + "\u17c6\u17c6"
        + "\u17c9\u17d3"
        + "\u17dd\u17dd"
        + "\u180b\u180d"
        + "\u18a9\u18a9"
        + "\u1920\u1922"
        + "\u1927\u1928"
        + "\u1932\u1932"
        + "\u1939\u193b"
        + "\u1a17\u1a18"
        + "\u1a1b\u1a1b"
        + "\u1a56\u1a56"
        + "\u1a58\u1a5e"
        + "\u1a60\u1a60"
        + "\u1a62\u1a62"
        + "\u1a65\u1a6c"
        + "\u1a73\u1a7c"
        + "\u1a7f\u1a7f"
        + "\u1ab0\u1abe"
        + "\u1b00\u1b03"
        + "\u1b34\u1b34"
        + "\u1b36\u1b3a"
        + "\u1b3c\u1b3c"
        + "\u1b42\u1b42"
        + "\u1b6b\u1b73"
        + "\u1b80\u1b81"
        + "\u1ba2\u1ba5"
        + "\u1ba8\u1ba9"
        + "\u1bab\u1bad"
        + "\u1be6\u1be6"
        + "\u1be8\u1be9"
        + "\u1bed\u1bed"
        + "\u1bef\u1bf1"
        + "\u1c2c\u1c33"
        + "\u1c36\u1c37"
        + "\u1cd0\u1cd2"
        + "\u1cd4\u1ce0"
        + "\u1ce2\u1ce8"
        + "\u1ced\u1ced"
        + "\u1cf4\u1cf4"
        + "\u1cf8\u1cf9"
        + "\u1dc0\u1df5"
        + "\u1dfc\u1dff"
        + "\u200c\u200d"
        + "\u20d0\u20f0"
        + "\u2cef\u2cf1"
        + "\u2d7f\u2d7f"
        + "\u2de0\u2dff"
        + "\u302a\u302f"
        + "\u3099\u309a"
        + "\ua66f\ua672"
        + "\ua674\ua67d"
        + "\ua69f\ua69f"
        + "\ua6f0\ua6f1"
        + "\ua802\ua802"
        + "\ua806\ua806"
        + "\ua80b\ua80b"
        + "\ua825\ua826"
        + "\ua8c4\ua8c4"
        + "\ua8e0\ua8f1"
        + "\ua926\ua92d"
        + "\ua947\ua951"
        + "\ua980\ua982"
        + "\ua9b3\ua9b3"
        + "\ua9b6\ua9b9"
        + "\ua9bc\ua9bc"
        + "\ua9e5\ua9e5"
        + "\uaa29\uaa2e"
        + "\uaa31\uaa32"
        + "\uaa35\uaa36"
        + "\uaa43\uaa43"
        + "\uaa4c\uaa4c"
        + "\uaa7c\uaa7c"
        + "\uaab0\uaab0"
        + "\uaab2\uaab4"
        + "\uaab7\uaab8"
        + "\uaabe\uaabf"
        + "\uaac1\uaac1"
        + "\uaaec\uaaed"
        + "\uaaf6\uaaf6"
        + "\uabe5\uabe5"
        + "\uabe8\uabe8"
        + "\uabed\uabed"
        + "\ufb1e\ufb1e"
        + "\ufe00\ufe0f"
        + "\ufe20\ufe2d"
        + "\uff9e\uff9f"
        + "\ud800\uddfd\ud800\uddfd"
        + "\ud800\udee0\ud800\udee0"
        + "\ud800\udf76\ud800\udf7a"
        + "\ud802\ude01\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude0f"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude3f"
        + "\ud802\udee5\ud802\udee6"
        + "\ud804\udc01\ud804\udc01"
        + "\ud804\udc38\ud804\udc46"
        + "\ud804\udc7f\ud804\udc81"
        + "\ud804\udcb3\ud804\udcb6"
        + "\ud804\udcb9\ud804\udcba"
        + "\ud804\udd00\ud804\udd02"
        + "\ud804\udd27\ud804\udd2b"
        + "\ud804\udd2d\ud804\udd34"
        + "\ud804\udd73\ud804\udd73"
        + "\ud804\udd80\ud804\udd81"
        + "\ud804\uddb6\ud804\uddbe"
        + "\ud804\ude2f\ud804\ude31"
        + "\ud804\ude34\ud804\ude34"
        + "\ud804\ude36\ud804\ude37"
        + "\ud804\udedf\ud804\udedf"
        + "\ud804\udee3\ud804\udeea"
        + "\ud804\udf01\ud804\udf01"
        + "\ud804\udf3c\ud804\udf3c"
        + "\ud804\udf3e\ud804\udf3e"
        + "\ud804\udf40\ud804\udf40"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udcb0\ud805\udcb0"
        + "\ud805\udcb3\ud805\udcb8"
        + "\ud805\udcba\ud805\udcba"
        + "\ud805\udcbd\ud805\udcbd"
        + "\ud805\udcbf\ud805\udcc0"
        + "\ud805\udcc2\ud805\udcc3"
        + "\ud805\uddaf\ud805\uddaf"
        + "\ud805\uddb2\ud805\uddb5"
        + "\ud805\uddbc\ud805\uddbd"
        + "\ud805\uddbf\ud805\uddc0"
        + "\ud805\ude33\ud805\ude3a"
        + "\ud805\ude3d\ud805\ude3d"
        + "\ud805\ude3f\ud805\ude40"
        + "\ud805\udeab\ud805\udeab"
        + "\ud805\udead\ud805\udead"
        + "\ud805\udeb0\ud805\udeb5"
        + "\ud805\udeb7\ud805\udeb7"
        + "\ud81a\udef0\ud81a\udef4"
        + "\ud81a\udf30\ud81a\udf36"
        + "\ud81b\udf8f\ud81b\udf92"
        + "\ud82f\udc9d\ud82f\udc9e"
        + "\ud834\udd65\ud834\udd65"
        + "\ud834\udd67\ud834\udd69"
        + "\ud834\udd6e\ud834\udd72"
        + "\ud834\udd7b\ud834\udd82"
        + "\ud834\udd85\ud834\udd8b"
        + "\ud834\uddaa\ud834\uddad"
        + "\ud834\ude42\ud834\ude44"
        + "\ud83a\udcd0\ud83a\udcd6"
        + "\udb40\udd00\udb40\uddef",
    // Unicode 7.0 property value: {graphemelink}
    "\u094d\u094d"
        + "\u09cd\u09cd"
        + "\u0a4d\u0a4d"
        + "\u0acd\u0acd"
        + "\u0b4d\u0b4d"
        + "\u0bcd\u0bcd"
        + "\u0c4d\u0c4d"
        + "\u0ccd\u0ccd"
        + "\u0d4d\u0d4d"
        + "\u0dca\u0dca"
        + "\u0e3a\u0e3a"
        + "\u0f84\u0f84"
        + "\u1039\u103a"
        + "\u1714\u1714"
        + "\u1734\u1734"
        + "\u17d2\u17d2"
        + "\u1a60\u1a60"
        + "\u1b44\u1b44"
        + "\u1baa\u1bab"
        + "\u1bf2\u1bf3"
        + "\u2d7f\u2d7f"
        + "\ua806\ua806"
        + "\ua8c4\ua8c4"
        + "\ua953\ua953"
        + "\ua9c0\ua9c0"
        + "\uaaf6\uaaf6"
        + "\uabed\uabed"
        + "\ud802\ude3f\ud802\ude3f"
        + "\ud804\udc46\ud804\udc46"
        + "\ud804\udc7f\ud804\udc7f"
        + "\ud804\udcb9\ud804\udcb9"
        + "\ud804\udd33\ud804\udd34"
        + "\ud804\uddc0\ud804\uddc0"
        + "\ud804\ude35\ud804\ude35"
        + "\ud804\udeea\ud804\udeea"
        + "\ud804\udf4d\ud804\udf4d"
        + "\ud805\udcc2\ud805\udcc2"
        + "\ud805\uddbf\ud805\uddbf"
        + "\ud805\ude3f\ud805\ude3f"
        + "\ud805\udeb6\ud805\udeb6",
    // Unicode 7.0 property value: {greek}
    "\u0370\u0373"
        + "\u0375\u0377"
        + "\u037a\u037d"
        + "\u037f\u037f"
        + "\u0384\u0384"
        + "\u0386\u0386"
        + "\u0388\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03e1"
        + "\u03f0\u03ff"
        + "\u1d26\u1d2a"
        + "\u1d5d\u1d61"
        + "\u1d66\u1d6a"
        + "\u1dbf\u1dbf"
        + "\u1f00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2126\u2126"
        + "\uab65\uab65"
        + "\ud800\udd40\ud800\udd8c"
        + "\ud800\udda0\ud800\udda0"
        + "\ud834\ude00\ud834\ude45",
    // Unicode 7.0 property value: {gujarati}
    "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0af1",
    // Unicode 7.0 property value: {gurmukhi}
    "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75",
    // Unicode 7.0 property value: {han}
    "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u3005\u3005"
        + "\u3007\u3007"
        + "\u3021\u3029"
        + "\u3038\u303b"
        + "\u3400\u4db5"
        + "\u4e00\u9fcc"
        + "\uf900\ufa6d"
        + "\ufa70\ufad9"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d",
    // Unicode 7.0 property value: {hangul}
    "\u1100\u11ff"
        + "\u302e\u302f"
        + "\u3131\u318e"
        + "\u3200\u321e"
        + "\u3260\u327e"
        + "\ua960\ua97c"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\uffa0\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc",
    // Unicode 7.0 property value: {hanunoo}
    "\u1720\u1734",
    // Unicode 7.0 property value: {hebrew}
    "\u0591\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufb4f",
    // Unicode 7.0 property value: {hexdigit}
    "\u0030\u0039"
        + "\u0041\u0046"
        + "\u0061\u0066"
        + "\uff10\uff19"
        + "\uff21\uff26"
        + "\uff41\uff46",
    // Unicode 7.0 property value: {hiragana}
    "\u3041\u3096" + "\u309d\u309f" + "\ud82c\udc01\ud82c\udc01" + "\ud83c\ude00\ud83c\ude00",
    // Unicode 7.0 property value: {hyphen}
    "\u002d\u002d"
        + "\u00ad\u00ad"
        + "\u058a\u058a"
        + "\u1806\u1806"
        + "\u2010\u2011"
        + "\u2e17\u2e17"
        + "\u30fb\u30fb"
        + "\ufe63\ufe63"
        + "\uff0d\uff0d"
        + "\uff65\uff65",
    // Unicode 7.0 property value: {idcontinue}
    "\u0030\u0039"
        + "\u0041\u005a"
        + "\u005f\u005f"
        + "\u0061\u007a"
        + "\u00aa\u00aa"
        + "\u00b5\u00b5"
        + "\u00b7\u00b7"
        + "\u00ba\u00ba"
        + "\u00c0\u00d6"
        + "\u00d8\u00f6"
        + "\u00f8\u02c1"
        + "\u02c6\u02d1"
        + "\u02e0\u02e4"
        + "\u02ec\u02ec"
        + "\u02ee\u02ee"
        + "\u0300\u0374"
        + "\u0376\u0377"
        + "\u037a\u037d"
        + "\u037f\u037f"
        + "\u0386\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03f5"
        + "\u03f7\u0481"
        + "\u0483\u0487"
        + "\u048a\u052f"
        + "\u0531\u0556"
        + "\u0559\u0559"
        + "\u0561\u0587"
        + "\u0591\u05bd"
        + "\u05bf\u05bf"
        + "\u05c1\u05c2"
        + "\u05c4\u05c5"
        + "\u05c7\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f2"
        + "\u0610\u061a"
        + "\u0620\u0669"
        + "\u066e\u06d3"
        + "\u06d5\u06dc"
        + "\u06df\u06e8"
        + "\u06ea\u06fc"
        + "\u06ff\u06ff"
        + "\u0710\u074a"
        + "\u074d\u07b1"
        + "\u07c0\u07f5"
        + "\u07fa\u07fa"
        + "\u0800\u082d"
        + "\u0840\u085b"
        + "\u08a0\u08b2"
        + "\u08e4\u0963"
        + "\u0966\u096f"
        + "\u0971\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09f1"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0aef"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b6f"
        + "\u0b71\u0b71"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bef"
        + "\u0c00\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c81\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d01\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d6f"
        + "\u0d7a\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0de6\u0def"
        + "\u0df2\u0df3"
        + "\u0e01\u0e3a"
        + "\u0e40\u0e4e"
        + "\u0e50\u0e59"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edf"
        + "\u0f00\u0f00"
        + "\u0f18\u0f19"
        + "\u0f20\u0f29"
        + "\u0f35\u0f35"
        + "\u0f37\u0f37"
        + "\u0f39\u0f39"
        + "\u0f3e\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f84"
        + "\u0f86\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fc6\u0fc6"
        + "\u1000\u1049"
        + "\u1050\u109d"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u10fa"
        + "\u10fc\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135d\u135f"
        + "\u1369\u1371"
        + "\u1380\u138f"
        + "\u13a0\u13f4"
        + "\u1401\u166c"
        + "\u166f\u167f"
        + "\u1681\u169a"
        + "\u16a0\u16ea"
        + "\u16ee\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1734"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17d3"
        + "\u17d7\u17d7"
        + "\u17dc\u17dd"
        + "\u17e0\u17e9"
        + "\u180b\u180d"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1946\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19d0\u19da"
        + "\u1a00\u1a1b"
        + "\u1a20\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1a7f\u1a89"
        + "\u1a90\u1a99"
        + "\u1aa7\u1aa7"
        + "\u1ab0\u1abd"
        + "\u1b00\u1b4b"
        + "\u1b50\u1b59"
        + "\u1b6b\u1b73"
        + "\u1b80\u1bf3"
        + "\u1c00\u1c37"
        + "\u1c40\u1c49"
        + "\u1c4d\u1c7d"
        + "\u1cd0\u1cd2"
        + "\u1cd4\u1cf6"
        + "\u1cf8\u1cf9"
        + "\u1d00\u1df5"
        + "\u1dfc\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fbc"
        + "\u1fbe\u1fbe"
        + "\u1fc2\u1fc4"
        + "\u1fc6\u1fcc"
        + "\u1fd0\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fe0\u1fec"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffc"
        + "\u203f\u2040"
        + "\u2054\u2054"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u20d0\u20dc"
        + "\u20e1\u20e1"
        + "\u20e5\u20f0"
        + "\u2102\u2102"
        + "\u2107\u2107"
        + "\u210a\u2113"
        + "\u2115\u2115"
        + "\u2118\u211d"
        + "\u2124\u2124"
        + "\u2126\u2126"
        + "\u2128\u2128"
        + "\u212a\u2139"
        + "\u213c\u213f"
        + "\u2145\u2149"
        + "\u214e\u214e"
        + "\u2160\u2188"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2ce4"
        + "\u2ceb\u2cf3"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d6f"
        + "\u2d7f\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2dff"
        + "\u3005\u3007"
        + "\u3021\u302f"
        + "\u3031\u3035"
        + "\u3038\u303c"
        + "\u3041\u3096"
        + "\u3099\u309f"
        + "\u30a1\u30fa"
        + "\u30fc\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u31a0\u31ba"
        + "\u31f0\u31ff"
        + "\u3400\u4db5"
        + "\u4e00\u9fcc"
        + "\ua000\ua48c"
        + "\ua4d0\ua4fd"
        + "\ua500\ua60c"
        + "\ua610\ua62b"
        + "\ua640\ua66f"
        + "\ua674\ua67d"
        + "\ua67f\ua69d"
        + "\ua69f\ua6f1"
        + "\ua717\ua71f"
        + "\ua722\ua788"
        + "\ua78b\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua827"
        + "\ua840\ua873"
        + "\ua880\ua8c4"
        + "\ua8d0\ua8d9"
        + "\ua8e0\ua8f7"
        + "\ua8fb\ua8fb"
        + "\ua900\ua92d"
        + "\ua930\ua953"
        + "\ua960\ua97c"
        + "\ua980\ua9c0"
        + "\ua9cf\ua9d9"
        + "\ua9e0\ua9fe"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa60\uaa76"
        + "\uaa7a\uaac2"
        + "\uaadb\uaadd"
        + "\uaae0\uaaef"
        + "\uaaf2\uaaf6"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uab30\uab5a"
        + "\uab5c\uab5f"
        + "\uab64\uab65"
        + "\uabc0\uabea"
        + "\uabec\uabed"
        + "\uabf0\uabf9"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\uf900\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb28"
        + "\ufb2a\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3d"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfb"
        + "\ufe00\ufe0f"
        + "\ufe20\ufe2d"
        + "\ufe33\ufe34"
        + "\ufe4d\ufe4f"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\uff10\uff19"
        + "\uff21\uff3a"
        + "\uff3f\uff3f"
        + "\uff41\uff5a"
        + "\uff66\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd40\ud800\udd74"
        + "\ud800\uddfd\ud800\uddfd"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udee0\ud800\udee0"
        + "\ud800\udf00\ud800\udf1f"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf50\ud800\udf7a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udfa0\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfcf"
        + "\ud800\udfd1\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc60\ud802\udc76"
        + "\ud802\udc80\ud802\udc9e"
        + "\ud802\udd00\ud802\udd15"
        + "\ud802\udd20\ud802\udd39"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude3f"
        + "\ud802\ude60\ud802\ude7c"
        + "\ud802\ude80\ud802\ude9c"
        + "\ud802\udec0\ud802\udec7"
        + "\ud802\udec9\ud802\udee6"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf40\ud802\udf55"
        + "\ud802\udf60\ud802\udf72"
        + "\ud802\udf80\ud802\udf91"
        + "\ud803\udc00\ud803\udc48"
        + "\ud804\udc00\ud804\udc46"
        + "\ud804\udc66\ud804\udc6f"
        + "\ud804\udc7f\ud804\udcba"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd00\ud804\udd34"
        + "\ud804\udd36\ud804\udd3f"
        + "\ud804\udd50\ud804\udd73"
        + "\ud804\udd76\ud804\udd76"
        + "\ud804\udd80\ud804\uddc4"
        + "\ud804\uddd0\ud804\uddda"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude37"
        + "\ud804\udeb0\ud804\udeea"
        + "\ud804\udef0\ud804\udef9"
        + "\ud804\udf01\ud804\udf03"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3c\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf5d\ud804\udf63"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udc80\ud805\udcc5"
        + "\ud805\udcc7\ud805\udcc7"
        + "\ud805\udcd0\ud805\udcd9"
        + "\ud805\udd80\ud805\uddb5"
        + "\ud805\uddb8\ud805\uddc0"
        + "\ud805\ude00\ud805\ude40"
        + "\ud805\ude44\ud805\ude44"
        + "\ud805\ude50\ud805\ude59"
        + "\ud805\ude80\ud805\udeb7"
        + "\ud805\udec0\ud805\udec9"
        + "\ud806\udca0\ud806\udce9"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud809\udc00\ud809\udc6e"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\ude60\ud81a\ude69"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udef0\ud81a\udef4"
        + "\ud81a\udf00\ud81a\udf36"
        + "\ud81a\udf40\ud81a\udf43"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf7e"
        + "\ud81b\udf8f\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud82f\udc9d\ud82f\udc9e"
        + "\ud834\udd65\ud834\udd69"
        + "\ud834\udd6d\ud834\udd72"
        + "\ud834\udd7b\ud834\udd82"
        + "\ud834\udd85\ud834\udd8b"
        + "\ud834\uddaa\ud834\uddad"
        + "\ud834\ude42\ud834\ude44"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udec0"
        + "\ud835\udec2\ud835\udeda"
        + "\ud835\udedc\ud835\udefa"
        + "\ud835\udefc\ud835\udf14"
        + "\ud835\udf16\ud835\udf34"
        + "\ud835\udf36\ud835\udf4e"
        + "\ud835\udf50\ud835\udf6e"
        + "\ud835\udf70\ud835\udf88"
        + "\ud835\udf8a\ud835\udfa8"
        + "\ud835\udfaa\ud835\udfc2"
        + "\ud835\udfc4\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83a\udcd0\ud83a\udcd6"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\udb40\udd00\udb40\uddef",
    // Unicode 7.0 property value: {ideographic}
    "\u3006\u3007"
        + "\u3021\u3029"
        + "\u3038\u303a"
        + "\u3400\u4db5"
        + "\u4e00\u9fcc"
        + "\uf900\ufa6d"
        + "\ufa70\ufad9"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d",
    // Unicode 7.0 property value: {idsbinaryoperator}
    "\u2ff0\u2ff1" + "\u2ff4\u2ffb",
    // Unicode 7.0 property value: {idstart}
    "\u0041\u005a"
        + "\u0061\u007a"
        + "\u00aa\u00aa"
        + "\u00b5\u00b5"
        + "\u00ba\u00ba"
        + "\u00c0\u00d6"
        + "\u00d8\u00f6"
        + "\u00f8\u02c1"
        + "\u02c6\u02d1"
        + "\u02e0\u02e4"
        + "\u02ec\u02ec"
        + "\u02ee\u02ee"
        + "\u0370\u0374"
        + "\u0376\u0377"
        + "\u037a\u037d"
        + "\u037f\u037f"
        + "\u0386\u0386"
        + "\u0388\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03f5"
        + "\u03f7\u0481"
        + "\u048a\u052f"
        + "\u0531\u0556"
        + "\u0559\u0559"
        + "\u0561\u0587"
        + "\u05d0\u05ea"
        + "\u05f0\u05f2"
        + "\u0620\u064a"
        + "\u066e\u066f"
        + "\u0671\u06d3"
        + "\u06d5\u06d5"
        + "\u06e5\u06e6"
        + "\u06ee\u06ef"
        + "\u06fa\u06fc"
        + "\u06ff\u06ff"
        + "\u0710\u0710"
        + "\u0712\u072f"
        + "\u074d\u07a5"
        + "\u07b1\u07b1"
        + "\u07ca\u07ea"
        + "\u07f4\u07f5"
        + "\u07fa\u07fa"
        + "\u0800\u0815"
        + "\u081a\u081a"
        + "\u0824\u0824"
        + "\u0828\u0828"
        + "\u0840\u0858"
        + "\u08a0\u08b2"
        + "\u0904\u0939"
        + "\u093d\u093d"
        + "\u0950\u0950"
        + "\u0958\u0961"
        + "\u0971\u0980"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bd\u09bd"
        + "\u09ce\u09ce"
        + "\u09dc\u09dd"
        + "\u09df\u09e1"
        + "\u09f0\u09f1"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a72\u0a74"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abd\u0abd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae1"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3d\u0b3d"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b71\u0b71"
        + "\u0b83\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bd0\u0bd0"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c3d"
        + "\u0c58\u0c59"
        + "\u0c60\u0c61"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbd\u0cbd"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0cf1\u0cf2"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d3d"
        + "\u0d4e\u0d4e"
        + "\u0d60\u0d61"
        + "\u0d7a\u0d7f"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0e01\u0e30"
        + "\u0e32\u0e33"
        + "\u0e40\u0e46"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb0"
        + "\u0eb2\u0eb3"
        + "\u0ebd\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0edc\u0edf"
        + "\u0f00\u0f00"
        + "\u0f40\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f88\u0f8c"
        + "\u1000\u102a"
        + "\u103f\u103f"
        + "\u1050\u1055"
        + "\u105a\u105d"
        + "\u1061\u1061"
        + "\u1065\u1066"
        + "\u106e\u1070"
        + "\u1075\u1081"
        + "\u108e\u108e"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u10fa"
        + "\u10fc\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u1380\u138f"
        + "\u13a0\u13f4"
        + "\u1401\u166c"
        + "\u166f\u167f"
        + "\u1681\u169a"
        + "\u16a0\u16ea"
        + "\u16ee\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1711"
        + "\u1720\u1731"
        + "\u1740\u1751"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1780\u17b3"
        + "\u17d7\u17d7"
        + "\u17dc\u17dc"
        + "\u1820\u1877"
        + "\u1880\u18a8"
        + "\u18aa\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1950\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19c1\u19c7"
        + "\u1a00\u1a16"
        + "\u1a20\u1a54"
        + "\u1aa7\u1aa7"
        + "\u1b05\u1b33"
        + "\u1b45\u1b4b"
        + "\u1b83\u1ba0"
        + "\u1bae\u1baf"
        + "\u1bba\u1be5"
        + "\u1c00\u1c23"
        + "\u1c4d\u1c4f"
        + "\u1c5a\u1c7d"
        + "\u1ce9\u1cec"
        + "\u1cee\u1cf1"
        + "\u1cf5\u1cf6"
        + "\u1d00\u1dbf"
        + "\u1e00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fbc"
        + "\u1fbe\u1fbe"
        + "\u1fc2\u1fc4"
        + "\u1fc6\u1fcc"
        + "\u1fd0\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fe0\u1fec"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffc"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u2102\u2102"
        + "\u2107\u2107"
        + "\u210a\u2113"
        + "\u2115\u2115"
        + "\u2118\u211d"
        + "\u2124\u2124"
        + "\u2126\u2126"
        + "\u2128\u2128"
        + "\u212a\u2139"
        + "\u213c\u213f"
        + "\u2145\u2149"
        + "\u214e\u214e"
        + "\u2160\u2188"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2ce4"
        + "\u2ceb\u2cee"
        + "\u2cf2\u2cf3"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d6f"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u3005\u3007"
        + "\u3021\u3029"
        + "\u3031\u3035"
        + "\u3038\u303c"
        + "\u3041\u3096"
        + "\u309b\u309f"
        + "\u30a1\u30fa"
        + "\u30fc\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u31a0\u31ba"
        + "\u31f0\u31ff"
        + "\u3400\u4db5"
        + "\u4e00\u9fcc"
        + "\ua000\ua48c"
        + "\ua4d0\ua4fd"
        + "\ua500\ua60c"
        + "\ua610\ua61f"
        + "\ua62a\ua62b"
        + "\ua640\ua66e"
        + "\ua67f\ua69d"
        + "\ua6a0\ua6ef"
        + "\ua717\ua71f"
        + "\ua722\ua788"
        + "\ua78b\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua801"
        + "\ua803\ua805"
        + "\ua807\ua80a"
        + "\ua80c\ua822"
        + "\ua840\ua873"
        + "\ua882\ua8b3"
        + "\ua8f2\ua8f7"
        + "\ua8fb\ua8fb"
        + "\ua90a\ua925"
        + "\ua930\ua946"
        + "\ua960\ua97c"
        + "\ua984\ua9b2"
        + "\ua9cf\ua9cf"
        + "\ua9e0\ua9e4"
        + "\ua9e6\ua9ef"
        + "\ua9fa\ua9fe"
        + "\uaa00\uaa28"
        + "\uaa40\uaa42"
        + "\uaa44\uaa4b"
        + "\uaa60\uaa76"
        + "\uaa7a\uaa7a"
        + "\uaa7e\uaaaf"
        + "\uaab1\uaab1"
        + "\uaab5\uaab6"
        + "\uaab9\uaabd"
        + "\uaac0\uaac0"
        + "\uaac2\uaac2"
        + "\uaadb\uaadd"
        + "\uaae0\uaaea"
        + "\uaaf2\uaaf4"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uab30\uab5a"
        + "\uab5c\uab5f"
        + "\uab64\uab65"
        + "\uabc0\uabe2"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\uf900\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb1d"
        + "\ufb1f\ufb28"
        + "\ufb2a\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3d"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfb"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\uff21\uff3a"
        + "\uff41\uff5a"
        + "\uff66\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd40\ud800\udd74"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udf00\ud800\udf1f"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf50\ud800\udf75"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udfa0\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfcf"
        + "\ud800\udfd1\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc60\ud802\udc76"
        + "\ud802\udc80\ud802\udc9e"
        + "\ud802\udd00\ud802\udd15"
        + "\ud802\udd20\ud802\udd39"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude00"
        + "\ud802\ude10\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude60\ud802\ude7c"
        + "\ud802\ude80\ud802\ude9c"
        + "\ud802\udec0\ud802\udec7"
        + "\ud802\udec9\ud802\udee4"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf40\ud802\udf55"
        + "\ud802\udf60\ud802\udf72"
        + "\ud802\udf80\ud802\udf91"
        + "\ud803\udc00\ud803\udc48"
        + "\ud804\udc03\ud804\udc37"
        + "\ud804\udc83\ud804\udcaf"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udd03\ud804\udd26"
        + "\ud804\udd50\ud804\udd72"
        + "\ud804\udd76\ud804\udd76"
        + "\ud804\udd83\ud804\uddb2"
        + "\ud804\uddc1\ud804\uddc4"
        + "\ud804\uddda\ud804\uddda"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude2b"
        + "\ud804\udeb0\ud804\udede"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3d\ud804\udf3d"
        + "\ud804\udf5d\ud804\udf61"
        + "\ud805\udc80\ud805\udcaf"
        + "\ud805\udcc4\ud805\udcc5"
        + "\ud805\udcc7\ud805\udcc7"
        + "\ud805\udd80\ud805\uddae"
        + "\ud805\ude00\ud805\ude2f"
        + "\ud805\ude44\ud805\ude44"
        + "\ud805\ude80\ud805\udeaa"
        + "\ud806\udca0\ud806\udcdf"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud809\udc00\ud809\udc6e"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udf00\ud81a\udf2f"
        + "\ud81a\udf40\ud81a\udf43"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf50"
        + "\ud81b\udf93\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udec0"
        + "\ud835\udec2\ud835\udeda"
        + "\ud835\udedc\ud835\udefa"
        + "\ud835\udefc\ud835\udf14"
        + "\ud835\udf16\ud835\udf34"
        + "\ud835\udf36\ud835\udf4e"
        + "\ud835\udf50\ud835\udf6e"
        + "\ud835\udf70\ud835\udf88"
        + "\ud835\udf8a\ud835\udfa8"
        + "\ud835\udfaa\ud835\udfc2"
        + "\ud835\udfc4\ud835\udfcb"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d",
    // Unicode 7.0 property value: {idstrinaryoperator}
    "\u2ff2\u2ff3",
    // Unicode 7.0 property value: {imperialaramaic}
    "\ud802\udc40\ud802\udc55" + "\ud802\udc57\ud802\udc5f",
    // Unicode 7.0 property value: {inherited}
    "\u0300\u036f"
        + "\u0485\u0486"
        + "\u064b\u0655"
        + "\u0670\u0670"
        + "\u0951\u0952"
        + "\u1ab0\u1abe"
        + "\u1cd0\u1cd2"
        + "\u1cd4\u1ce0"
        + "\u1ce2\u1ce8"
        + "\u1ced\u1ced"
        + "\u1cf4\u1cf4"
        + "\u1cf8\u1cf9"
        + "\u1dc0\u1df5"
        + "\u1dfc\u1dff"
        + "\u200c\u200d"
        + "\u20d0\u20f0"
        + "\u302a\u302d"
        + "\u3099\u309a"
        + "\ufe00\ufe0f"
        + "\ufe20\ufe2d"
        + "\ud800\uddfd\ud800\uddfd"
        + "\ud800\udee0\ud800\udee0"
        + "\ud834\udd67\ud834\udd69"
        + "\ud834\udd7b\ud834\udd82"
        + "\ud834\udd85\ud834\udd8b"
        + "\ud834\uddaa\ud834\uddad"
        + "\udb40\udd00\udb40\uddef",
    // Unicode 7.0 property value: {inscriptionalpahlavi}
    "\ud802\udf60\ud802\udf72" + "\ud802\udf78\ud802\udf7f",
    // Unicode 7.0 property value: {inscriptionalparthian}
    "\ud802\udf40\ud802\udf55" + "\ud802\udf58\ud802\udf5f",
    // Unicode 7.0 property value: {javanese}
    "\ua980\ua9cd" + "\ua9d0\ua9d9" + "\ua9de\ua9df",
    // Unicode 7.0 property value: {joincontrol}
    "\u200c\u200d",
    // Unicode 7.0 property value: {kaithi}
    "\ud804\udc80\ud804\udcc1",
    // Unicode 7.0 property value: {kannada}
    "\u0c81\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2",
    // Unicode 7.0 property value: {katakana}
    "\u30a1\u30fa"
        + "\u30fd\u30ff"
        + "\u31f0\u31ff"
        + "\u32d0\u32fe"
        + "\u3300\u3357"
        + "\uff66\uff6f"
        + "\uff71\uff9d"
        + "\ud82c\udc00\ud82c\udc00",
    // Unicode 7.0 property value: {kayahli}
    "\ua900\ua92d" + "\ua92f\ua92f",
    // Unicode 7.0 property value: {kharoshthi}
    "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58",
    // Unicode 7.0 property value: {khmer}
    "\u1780\u17dd" + "\u17e0\u17e9" + "\u17f0\u17f9" + "\u19e0\u19ff",
    // Unicode 7.0 property value: {khojki}
    "\ud804\ude00\ud804\ude11" + "\ud804\ude13\ud804\ude3d",
    // Unicode 7.0 property value: {khudawadi}
    "\ud804\udeb0\ud804\udeea" + "\ud804\udef0\ud804\udef9",
    // Unicode 7.0 property value: {lao}
    "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edf",
    // Unicode 7.0 property value: {latin}
    "\u0041\u005a"
        + "\u0061\u007a"
        + "\u00aa\u00aa"
        + "\u00ba\u00ba"
        + "\u00c0\u00d6"
        + "\u00d8\u00f6"
        + "\u00f8\u02b8"
        + "\u02e0\u02e4"
        + "\u1d00\u1d25"
        + "\u1d2c\u1d5c"
        + "\u1d62\u1d65"
        + "\u1d6b\u1d77"
        + "\u1d79\u1dbe"
        + "\u1e00\u1eff"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u212a\u212b"
        + "\u2132\u2132"
        + "\u214e\u214e"
        + "\u2160\u2188"
        + "\u2c60\u2c7f"
        + "\ua722\ua787"
        + "\ua78b\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua7ff"
        + "\uab30\uab5a"
        + "\uab5c\uab5f"
        + "\uab64\uab64"
        + "\ufb00\ufb06"
        + "\uff21\uff3a"
        + "\uff41\uff5a",
    // Unicode 7.0 property value: {lepcha}
    "\u1c00\u1c37" + "\u1c3b\u1c49" + "\u1c4d\u1c4f",
    // Unicode 7.0 property value: {limbu}
    "\u1900\u191e" + "\u1920\u192b" + "\u1930\u193b" + "\u1940\u1940" + "\u1944\u194f",
    // Unicode 7.0 property value: {lineara}
    "\ud801\ude00\ud801\udf36" + "\ud801\udf40\ud801\udf55" + "\ud801\udf60\ud801\udf67",
    // Unicode 7.0 property value: {linearb}
    "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa",
    // Unicode 7.0 property value: {linebreak=alphabetic}
    "\u0023\u0023"
        + "\u0026\u0026"
        + "\u002a\u002a"
        + "\u003c\u003e"
        + "\u0040\u005a"
        + "\u005e\u007a"
        + "\u007e\u007e"
        + "\u00a6\u00a6"
        + "\u00a9\u00a9"
        + "\u00ac\u00ac"
        + "\u00ae\u00af"
        + "\u00b5\u00b5"
        + "\u00c0\u00d6"
        + "\u00d8\u00f6"
        + "\u00f8\u02c6"
        + "\u02ce\u02cf"
        + "\u02d1\u02d7"
        + "\u02dc\u02dc"
        + "\u02de\u02de"
        + "\u02e0\u02ff"
        + "\u0370\u0377"
        + "\u037a\u037d"
        + "\u037f\u037f"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u0482"
        + "\u048a\u052f"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u058d\u058e"
        + "\u05c0\u05c0"
        + "\u05c3\u05c3"
        + "\u05f3\u05f4"
        + "\u0600\u0608"
        + "\u060e\u060f"
        + "\u0620\u064a"
        + "\u066d\u066f"
        + "\u0671\u06d3"
        + "\u06d5\u06d5"
        + "\u06dd\u06de"
        + "\u06e5\u06e6"
        + "\u06e9\u06e9"
        + "\u06ee\u06ef"
        + "\u06fa\u070d"
        + "\u070f\u0710"
        + "\u0712\u072f"
        + "\u074d\u07a5"
        + "\u07b1\u07b1"
        + "\u07ca\u07ea"
        + "\u07f4\u07f7"
        + "\u07fa\u07fa"
        + "\u0800\u0815"
        + "\u081a\u081a"
        + "\u0824\u0824"
        + "\u0828\u0828"
        + "\u0830\u083e"
        + "\u0840\u0858"
        + "\u085e\u085e"
        + "\u08a0\u08b2"
        + "\u0904\u0939"
        + "\u093d\u093d"
        + "\u0950\u0950"
        + "\u0958\u0961"
        + "\u0970\u0980"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bd\u09bd"
        + "\u09ce\u09ce"
        + "\u09dc\u09dd"
        + "\u09df\u09e1"
        + "\u09f0\u09f1"
        + "\u09f4\u09f8"
        + "\u09fa\u09fa"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a72\u0a74"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abd\u0abd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae1"
        + "\u0af0\u0af0"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3d\u0b3d"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b70\u0b77"
        + "\u0b83\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bd0\u0bd0"
        + "\u0bf0\u0bf8"
        + "\u0bfa\u0bfa"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c3d"
        + "\u0c58\u0c59"
        + "\u0c60\u0c61"
        + "\u0c78\u0c7f"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbd\u0cbd"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0cf1\u0cf2"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d3d"
        + "\u0d4e\u0d4e"
        + "\u0d60\u0d61"
        + "\u0d70\u0d75"
        + "\u0d7a\u0d7f"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0df4\u0df4"
        + "\u0e4f\u0e4f"
        + "\u0f00\u0f00"
        + "\u0f05\u0f05"
        + "\u0f13\u0f13"
        + "\u0f15\u0f17"
        + "\u0f1a\u0f1f"
        + "\u0f2a\u0f33"
        + "\u0f36\u0f36"
        + "\u0f38\u0f38"
        + "\u0f40\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f88\u0f8c"
        + "\u0fc0\u0fc5"
        + "\u0fc7\u0fcc"
        + "\u0fce\u0fcf"
        + "\u0fd4\u0fd8"
        + "\u104c\u104f"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u10ff"
        + "\u1200\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u1360\u1360"
        + "\u1362\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1401\u167f"
        + "\u1681\u169a"
        + "\u16a0\u16ea"
        + "\u16ee\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1711"
        + "\u1720\u1731"
        + "\u1740\u1751"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u17d9\u17d9"
        + "\u17f0\u17f9"
        + "\u1800\u1801"
        + "\u1807\u1807"
        + "\u180a\u180a"
        + "\u1820\u1877"
        + "\u1880\u18a8"
        + "\u18aa\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1940\u1940"
        + "\u19e0\u1a16"
        + "\u1a1e\u1a1f"
        + "\u1b05\u1b33"
        + "\u1b45\u1b4b"
        + "\u1b5c\u1b5c"
        + "\u1b61\u1b6a"
        + "\u1b74\u1b7c"
        + "\u1b83\u1ba0"
        + "\u1bae\u1baf"
        + "\u1bba\u1be5"
        + "\u1bfc\u1c23"
        + "\u1c4d\u1c4f"
        + "\u1c5a\u1c7d"
        + "\u1cc0\u1cc7"
        + "\u1cd3\u1cd3"
        + "\u1ce9\u1cec"
        + "\u1cee\u1cf1"
        + "\u1cf5\u1cf6"
        + "\u1d00\u1dbf"
        + "\u1e00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffc"
        + "\u1ffe\u1ffe"
        + "\u2017\u2017"
        + "\u2022\u2023"
        + "\u2038\u2038"
        + "\u203e\u2043"
        + "\u204a\u2055"
        + "\u2057\u2057"
        + "\u205c\u205c"
        + "\u2061\u2064"
        + "\u2070\u2071"
        + "\u2075\u207c"
        + "\u2080\u2080"
        + "\u2085\u208c"
        + "\u2090\u209c"
        + "\u2100\u2102"
        + "\u2104\u2104"
        + "\u2106\u2108"
        + "\u210a\u2112"
        + "\u2114\u2115"
        + "\u2117\u2120"
        + "\u2123\u212a"
        + "\u212c\u2153"
        + "\u2156\u215a"
        + "\u215c\u215d"
        + "\u215f\u215f"
        + "\u216c\u216f"
        + "\u217a\u2188"
        + "\u219a\u21d1"
        + "\u21d3\u21d3"
        + "\u21d5\u21ff"
        + "\u2201\u2201"
        + "\u2204\u2206"
        + "\u2209\u220a"
        + "\u220c\u220e"
        + "\u2210\u2210"
        + "\u2214\u2214"
        + "\u2216\u2219"
        + "\u221b\u221c"
        + "\u2221\u2222"
        + "\u2224\u2224"
        + "\u2226\u2226"
        + "\u222d\u222d"
        + "\u222f\u2233"
        + "\u2238\u223b"
        + "\u223e\u2247"
        + "\u2249\u224b"
        + "\u224d\u2251"
        + "\u2253\u225f"
        + "\u2262\u2263"
        + "\u2268\u2269"
        + "\u226c\u226d"
        + "\u2270\u2281"
        + "\u2284\u2285"
        + "\u2288\u2294"
        + "\u2296\u2298"
        + "\u229a\u22a4"
        + "\u22a6\u22be"
        + "\u22c0\u2307"
        + "\u230c\u2311"
        + "\u2313\u2319"
        + "\u231c\u2328"
        + "\u232b\u23ef"
        + "\u23f4\u23fa"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u24ff\u24ff"
        + "\u254c\u254f"
        + "\u2575\u257f"
        + "\u2590\u2591"
        + "\u2596\u259f"
        + "\u25a2\u25a2"
        + "\u25aa\u25b1"
        + "\u25b4\u25b5"
        + "\u25b8\u25bb"
        + "\u25be\u25bf"
        + "\u25c2\u25c5"
        + "\u25c9\u25ca"
        + "\u25cc\u25cd"
        + "\u25d2\u25e1"
        + "\u25e6\u25ee"
        + "\u25f0\u25ff"
        + "\u2604\u2604"
        + "\u2607\u2608"
        + "\u260a\u260d"
        + "\u2610\u2613"
        + "\u2619\u2619"
        + "\u2620\u2638"
        + "\u263c\u263f"
        + "\u2641\u2641"
        + "\u2643\u265f"
        + "\u2662\u2662"
        + "\u2666\u2666"
        + "\u266b\u266b"
        + "\u266e\u266e"
        + "\u2670\u267e"
        + "\u2680\u269d"
        + "\u26a0\u26bc"
        + "\u26ce\u26ce"
        + "\u26e2\u26e2"
        + "\u26e4\u26e7"
        + "\u2705\u2707"
        + "\u270e\u2756"
        + "\u2758\u275a"
        + "\u2761\u2761"
        + "\u2764\u2767"
        + "\u2794\u27c4"
        + "\u27c7\u27e5"
        + "\u27f0\u2982"
        + "\u2999\u29d7"
        + "\u29dc\u29fb"
        + "\u29fe\u2b54"
        + "\u2b5a\u2b73"
        + "\u2b76\u2b95"
        + "\u2b98\u2bb9"
        + "\u2bbd\u2bc8"
        + "\u2bca\u2bd1"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2cee"
        + "\u2cf2\u2cf3"
        + "\u2cfd\u2cfd"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d6f"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2e16\u2e16"
        + "\u2e1a\u2e1b"
        + "\u2e1e\u2e1f"
        + "\u2e2f\u2e2f"
        + "\u2e32\u2e32"
        + "\u2e35\u2e39"
        + "\u2e3f\u2e3f"
        + "\u4dc0\u4dff"
        + "\ua4d0\ua4fd"
        + "\ua500\ua60c"
        + "\ua610\ua61f"
        + "\ua62a\ua62b"
        + "\ua640\ua66e"
        + "\ua673\ua673"
        + "\ua67e\ua69d"
        + "\ua6a0\ua6ef"
        + "\ua6f2\ua6f2"
        + "\ua700\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua801"
        + "\ua803\ua805"
        + "\ua807\ua80a"
        + "\ua80c\ua822"
        + "\ua828\ua82b"
        + "\ua830\ua837"
        + "\ua839\ua839"
        + "\ua840\ua873"
        + "\ua882\ua8b3"
        + "\ua8f2\ua8fb"
        + "\ua90a\ua925"
        + "\ua930\ua946"
        + "\ua95f\ua95f"
        + "\ua984\ua9b2"
        + "\ua9c1\ua9c6"
        + "\ua9ca\ua9cd"
        + "\ua9cf\ua9cf"
        + "\ua9de\ua9df"
        + "\uaa00\uaa28"
        + "\uaa40\uaa42"
        + "\uaa44\uaa4b"
        + "\uaa5c\uaa5c"
        + "\uaae0\uaaea"
        + "\uaaf2\uaaf4"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uab30\uab5f"
        + "\uab64\uab65"
        + "\uabc0\uabe2"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb29\ufb29"
        + "\ufb50\ufbc1"
        + "\ufbd3\ufd3d"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfb"
        + "\ufdfd\ufdfd"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\uff66\uff66"
        + "\uff71\uff9d"
        + "\uffa0\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe8\uffee"
        + "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8c"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\udda0\ud800\udda0"
        + "\ud800\uddd0\ud800\uddfc"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udee1\ud800\udefb"
        + "\ud800\udf00\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf50\ud800\udf75"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udfa0\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfcf"
        + "\ud800\udfd1\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\udd6f\ud801\udd6f"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc58\ud802\udc9e"
        + "\ud802\udca7\ud802\udcaf"
        + "\ud802\udd00\ud802\udd1b"
        + "\ud802\udd20\ud802\udd39"
        + "\ud802\udd3f\ud802\udd3f"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude00"
        + "\ud802\ude10\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude40\ud802\ude47"
        + "\ud802\ude58\ud802\ude58"
        + "\ud802\ude60\ud802\ude9f"
        + "\ud802\udec0\ud802\udee4"
        + "\ud802\udeeb\ud802\udeef"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf40\ud802\udf55"
        + "\ud802\udf58\ud802\udf72"
        + "\ud802\udf78\ud802\udf91"
        + "\ud802\udf99\ud802\udf9c"
        + "\ud802\udfa9\ud802\udfaf"
        + "\ud803\udc00\ud803\udc48"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud804\udc03\ud804\udc37"
        + "\ud804\udc49\ud804\udc4d"
        + "\ud804\udc52\ud804\udc65"
        + "\ud804\udc83\ud804\udcaf"
        + "\ud804\udcbb\ud804\udcbd"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udd03\ud804\udd26"
        + "\ud804\udd50\ud804\udd72"
        + "\ud804\udd74\ud804\udd74"
        + "\ud804\udd76\ud804\udd76"
        + "\ud804\udd83\ud804\uddb2"
        + "\ud804\uddc1\ud804\uddc4"
        + "\ud804\uddc7\ud804\uddc7"
        + "\ud804\uddcd\ud804\uddcd"
        + "\ud804\uddda\ud804\uddda"
        + "\ud804\udde1\ud804\uddf4"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude2b"
        + "\ud804\ude3a\ud804\ude3a"
        + "\ud804\ude3d\ud804\ude3d"
        + "\ud804\udeb0\ud804\udede"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3d\ud804\udf3d"
        + "\ud804\udf5d\ud804\udf61"
        + "\ud805\udc80\ud805\udcaf"
        + "\ud805\udcc4\ud805\udcc7"
        + "\ud805\udd80\ud805\uddae"
        + "\ud805\uddc6\ud805\uddc8"
        + "\ud805\ude00\ud805\ude2f"
        + "\ud805\ude43\ud805\ude44"
        + "\ud805\ude80\ud805\udeaa"
        + "\ud806\udca0\ud806\udcdf"
        + "\ud806\udcea\ud806\udcf2"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud809\udc00\ud809\udc6e"
        + "\ud80c\udc00\ud80c\ude57"
        + "\ud80c\ude5e\ud80c\ude81"
        + "\ud80c\ude83\ud80c\ude85"
        + "\ud80c\ude8a\ud80c\udf78"
        + "\ud80c\udf7c\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udf00\ud81a\udf2f"
        + "\ud81a\udf3a\ud81a\udf43"
        + "\ud81a\udf45\ud81a\udf45"
        + "\ud81a\udf5b\ud81a\udf61"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf50"
        + "\ud81b\udf93\ud81b\udf9f"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud82f\udc9c\ud82f\udc9c"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udd64"
        + "\ud834\udd6a\ud834\udd6c"
        + "\ud834\udd83\ud834\udd84"
        + "\ud834\udd8c\ud834\udda9"
        + "\ud834\uddae\ud834\udddd"
        + "\ud834\ude00\ud834\ude41"
        + "\ud834\ude45\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83a\udcc7\ud83a\udccf"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83b\udef0\ud83b\udef1"
        + "\ud83c\udd2e\ud83c\udd2e"
        + "\ud83c\udd6a\ud83c\udd6b"
        + "\ud83c\udf9c\ud83c\udf9d"
        + "\ud83c\udfb5\ud83c\udfb6"
        + "\ud83c\udfbc\ud83c\udfbc"
        + "\ud83d\udca0\ud83d\udca0"
        + "\ud83d\udca2\ud83d\udca2"
        + "\ud83d\udca4\ud83d\udca4"
        + "\ud83d\udcaf\ud83d\udcaf"
        + "\ud83d\udcb1\ud83d\udcb2"
        + "\ud83d\udd00\ud83d\udd06"
        + "\ud83d\udd17\ud83d\udd24"
        + "\ud83d\udd32\ud83d\udd49"
        + "\ud83d\uddd4\ud83d\udddb"
        + "\ud83d\uddf4\ud83d\uddf9"
        + "\ud83d\ude50\ud83d\ude75"
        + "\ud83d\ude7c\ud83d\ude7f"
        + "\ud83d\udf00\ud83d\udf73"
        + "\ud83d\udf80\ud83d\udfd4"
        + "\ud83e\udc00\ud83e\udc0b"
        + "\ud83e\udc10\ud83e\udc47"
        + "\ud83e\udc50\ud83e\udc59"
        + "\ud83e\udc60\ud83e\udc87"
        + "\ud83e\udc90\ud83e\udcad",
    // Unicode 7.0 property value: {linebreak=ambiguous}
    "\u00a7\u00a8"
        + "\u00aa\u00aa"
        + "\u00b2\u00b3"
        + "\u00b6\u00ba"
        + "\u00bc\u00be"
        + "\u00d7\u00d7"
        + "\u00f7\u00f7"
        + "\u02c7\u02c7"
        + "\u02c9\u02cb"
        + "\u02cd\u02cd"
        + "\u02d0\u02d0"
        + "\u02d8\u02db"
        + "\u02dd\u02dd"
        + "\u2015\u2016"
        + "\u2020\u2021"
        + "\u203b\u203b"
        + "\u2074\u2074"
        + "\u207f\u207f"
        + "\u2081\u2084"
        + "\u2105\u2105"
        + "\u2113\u2113"
        + "\u2121\u2122"
        + "\u212b\u212b"
        + "\u2154\u2155"
        + "\u215b\u215b"
        + "\u215e\u215e"
        + "\u2160\u216b"
        + "\u2170\u2179"
        + "\u2189\u2189"
        + "\u2190\u2199"
        + "\u21d2\u21d2"
        + "\u21d4\u21d4"
        + "\u2200\u2200"
        + "\u2202\u2203"
        + "\u2207\u2208"
        + "\u220b\u220b"
        + "\u220f\u220f"
        + "\u2211\u2211"
        + "\u2215\u2215"
        + "\u221a\u221a"
        + "\u221d\u2220"
        + "\u2223\u2223"
        + "\u2225\u2225"
        + "\u2227\u222c"
        + "\u222e\u222e"
        + "\u2234\u2237"
        + "\u223c\u223d"
        + "\u2248\u2248"
        + "\u224c\u224c"
        + "\u2252\u2252"
        + "\u2260\u2261"
        + "\u2264\u2267"
        + "\u226a\u226b"
        + "\u226e\u226f"
        + "\u2282\u2283"
        + "\u2286\u2287"
        + "\u2295\u2295"
        + "\u2299\u2299"
        + "\u22a5\u22a5"
        + "\u22bf\u22bf"
        + "\u2312\u2312"
        + "\u2460\u24fe"
        + "\u2500\u254b"
        + "\u2550\u2574"
        + "\u2580\u258f"
        + "\u2592\u2595"
        + "\u25a0\u25a1"
        + "\u25a3\u25a9"
        + "\u25b2\u25b3"
        + "\u25b6\u25b7"
        + "\u25bc\u25bd"
        + "\u25c0\u25c1"
        + "\u25c6\u25c8"
        + "\u25cb\u25cb"
        + "\u25ce\u25d1"
        + "\u25e2\u25e5"
        + "\u25ef\u25ef"
        + "\u2605\u2606"
        + "\u2609\u2609"
        + "\u260e\u260f"
        + "\u2616\u2617"
        + "\u2640\u2640"
        + "\u2642\u2642"
        + "\u2660\u2661"
        + "\u2663\u2665"
        + "\u2667\u2667"
        + "\u2669\u266a"
        + "\u266c\u266d"
        + "\u266f\u266f"
        + "\u269e\u269f"
        + "\u26c9\u26cc"
        + "\u26d2\u26d2"
        + "\u26d5\u26d7"
        + "\u26da\u26db"
        + "\u26dd\u26de"
        + "\u26e3\u26e3"
        + "\u26e8\u26e9"
        + "\u26eb\u26f0"
        + "\u26f6\u26f6"
        + "\u26fb\u26fc"
        + "\u2757\u2757"
        + "\u2776\u2793"
        + "\u2b55\u2b59"
        + "\u3248\u324f"
        + "\ufffd\ufffd"
        + "\ud83c\udd00\ud83c\udd0c"
        + "\ud83c\udd10\ud83c\udd2d"
        + "\ud83c\udd30\ud83c\udd69"
        + "\ud83c\udd70\ud83c\udd9a",
    // Unicode 7.0 property value: {linebreak=breakafter}
    "\t\t"
        + "\u007c\u007c"
        + "\u00ad\u00ad"
        + "\u058a\u058a"
        + "\u05be\u05be"
        + "\u0964\u0965"
        + "\u0e5a\u0e5b"
        + "\u0f0b\u0f0b"
        + "\u0f34\u0f34"
        + "\u0f7f\u0f7f"
        + "\u0f85\u0f85"
        + "\u0fbe\u0fbf"
        + "\u0fd2\u0fd2"
        + "\u104a\u104b"
        + "\u1361\u1361"
        + "\u1400\u1400"
        + "\u1680\u1680"
        + "\u16eb\u16ed"
        + "\u1735\u1736"
        + "\u17d4\u17d5"
        + "\u17d8\u17d8"
        + "\u17da\u17da"
        + "\u1804\u1805"
        + "\u1b5a\u1b5b"
        + "\u1b5d\u1b60"
        + "\u1c3b\u1c3f"
        + "\u1c7e\u1c7f"
        + "\u2000\u2006"
        + "\u2008\u200a"
        + "\u2010\u2010"
        + "\u2012\u2013"
        + "\u2027\u2027"
        + "\u2056\u2056"
        + "\u2058\u205b"
        + "\u205d\u205f"
        + "\u2cfa\u2cfc"
        + "\u2cff\u2cff"
        + "\u2d70\u2d70"
        + "\u2e0e\u2e15"
        + "\u2e17\u2e17"
        + "\u2e19\u2e19"
        + "\u2e2a\u2e2d"
        + "\u2e30\u2e31"
        + "\u2e33\u2e34"
        + "\u2e3c\u2e3e"
        + "\u2e40\u2e41"
        + "\u3000\u3000"
        + "\ua4fe\ua4ff"
        + "\ua60d\ua60d"
        + "\ua60f\ua60f"
        + "\ua6f3\ua6f7"
        + "\ua8ce\ua8cf"
        + "\ua92e\ua92f"
        + "\ua9c7\ua9c9"
        + "\uaa5d\uaa5f"
        + "\uaaf0\uaaf1"
        + "\uabeb\uabeb"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udf9f\ud800\udf9f"
        + "\ud800\udfd0\ud800\udfd0"
        + "\ud802\udc57\ud802\udc57"
        + "\ud802\udd1f\ud802\udd1f"
        + "\ud802\ude50\ud802\ude57"
        + "\ud802\udef0\ud802\udef5"
        + "\ud802\udf39\ud802\udf3f"
        + "\ud804\udc47\ud804\udc48"
        + "\ud804\udcbe\ud804\udcc1"
        + "\ud804\udd40\ud804\udd43"
        + "\ud804\uddc5\ud804\uddc6"
        + "\ud804\uddc8\ud804\uddc8"
        + "\ud804\ude38\ud804\ude39"
        + "\ud804\ude3b\ud804\ude3c"
        + "\ud805\uddc2\ud805\uddc3"
        + "\ud805\uddc9\ud805\uddc9"
        + "\ud805\ude41\ud805\ude42"
        + "\ud809\udc70\ud809\udc74"
        + "\ud81a\ude6e\ud81a\ude6f"
        + "\ud81a\udef5\ud81a\udef5"
        + "\ud81a\udf37\ud81a\udf39"
        + "\ud81a\udf44\ud81a\udf44"
        + "\ud82f\udc9f\ud82f\udc9f",
    // Unicode 7.0 property value: {linebreak=breakbefore}
    "\u00b4\u00b4"
        + "\u02c8\u02c8"
        + "\u02cc\u02cc"
        + "\u02df\u02df"
        + "\u0f01\u0f04"
        + "\u0f06\u0f07"
        + "\u0f09\u0f0a"
        + "\u0fd0\u0fd1"
        + "\u0fd3\u0fd3"
        + "\u1806\u1806"
        + "\u1ffd\u1ffd"
        + "\ua874\ua875"
        + "\ud804\udd75\ud804\udd75"
        + "\ud805\uddc1\ud805\uddc1",
    // Unicode 7.0 property value: {linebreak=breakboth}
    "\u2014\u2014" + "\u2e3a\u2e3b",
    // Unicode 7.0 property value: {linebreak=breaksymbols}
    "\u002f\u002f",
    // Unicode 7.0 property value: {linebreak=carriagereturn}
    "\r\r",
    // Unicode 7.0 property value: {linebreak=closeparenthesis}
    "\u0029\u0029" + "\u005d\u005d",
    // Unicode 7.0 property value: {linebreak=closepunctuation}
    "\u007d\u007d"
        + "\u0f3b\u0f3b"
        + "\u0f3d\u0f3d"
        + "\u169c\u169c"
        + "\u2046\u2046"
        + "\u207e\u207e"
        + "\u208e\u208e"
        + "\u2309\u2309"
        + "\u230b\u230b"
        + "\u232a\u232a"
        + "\u2769\u2769"
        + "\u276b\u276b"
        + "\u276d\u276d"
        + "\u276f\u276f"
        + "\u2771\u2771"
        + "\u2773\u2773"
        + "\u2775\u2775"
        + "\u27c6\u27c6"
        + "\u27e7\u27e7"
        + "\u27e9\u27e9"
        + "\u27eb\u27eb"
        + "\u27ed\u27ed"
        + "\u27ef\u27ef"
        + "\u2984\u2984"
        + "\u2986\u2986"
        + "\u2988\u2988"
        + "\u298a\u298a"
        + "\u298c\u298c"
        + "\u298e\u298e"
        + "\u2990\u2990"
        + "\u2992\u2992"
        + "\u2994\u2994"
        + "\u2996\u2996"
        + "\u2998\u2998"
        + "\u29d9\u29d9"
        + "\u29db\u29db"
        + "\u29fd\u29fd"
        + "\u2e23\u2e23"
        + "\u2e25\u2e25"
        + "\u2e27\u2e27"
        + "\u2e29\u2e29"
        + "\u3001\u3002"
        + "\u3009\u3009"
        + "\u300b\u300b"
        + "\u300d\u300d"
        + "\u300f\u300f"
        + "\u3011\u3011"
        + "\u3015\u3015"
        + "\u3017\u3017"
        + "\u3019\u3019"
        + "\u301b\u301b"
        + "\u301e\u301f"
        + "\ufd3e\ufd3e"
        + "\ufe11\ufe12"
        + "\ufe18\ufe18"
        + "\ufe36\ufe36"
        + "\ufe38\ufe38"
        + "\ufe3a\ufe3a"
        + "\ufe3c\ufe3c"
        + "\ufe3e\ufe3e"
        + "\ufe40\ufe40"
        + "\ufe42\ufe42"
        + "\ufe44\ufe44"
        + "\ufe48\ufe48"
        + "\ufe50\ufe50"
        + "\ufe52\ufe52"
        + "\ufe5a\ufe5a"
        + "\ufe5c\ufe5c"
        + "\ufe5e\ufe5e"
        + "\uff09\uff09"
        + "\uff0c\uff0c"
        + "\uff0e\uff0e"
        + "\uff3d\uff3d"
        + "\uff5d\uff5d"
        + "\uff60\uff61"
        + "\uff63\uff64"
        + "\ud80c\ude5b\ud80c\ude5d"
        + "\ud80c\ude82\ud80c\ude82"
        + "\ud80c\ude87\ud80c\ude87"
        + "\ud80c\ude89\ud80c\ude89"
        + "\ud80c\udf7a\ud80c\udf7b",
    // Unicode 7.0 property value: {linebreak=combiningmark}
    "\000\u0008"
        + "\u000e\u001f"
        + "\u007f\u0084"
        + "\u0086\u009f"
        + "\u0300\u034e"
        + "\u0350\u035b"
        + "\u0363\u036f"
        + "\u0483\u0489"
        + "\u0591\u05bd"
        + "\u05bf\u05bf"
        + "\u05c1\u05c2"
        + "\u05c4\u05c5"
        + "\u05c7\u05c7"
        + "\u0610\u061a"
        + "\u061c\u061c"
        + "\u064b\u065f"
        + "\u0670\u0670"
        + "\u06d6\u06dc"
        + "\u06df\u06e4"
        + "\u06e7\u06e8"
        + "\u06ea\u06ed"
        + "\u0711\u0711"
        + "\u0730\u074a"
        + "\u07a6\u07b0"
        + "\u07eb\u07f3"
        + "\u0816\u0819"
        + "\u081b\u0823"
        + "\u0825\u0827"
        + "\u0829\u082d"
        + "\u0859\u085b"
        + "\u08e4\u0903"
        + "\u093a\u093c"
        + "\u093e\u094f"
        + "\u0951\u0957"
        + "\u0962\u0963"
        + "\u0981\u0983"
        + "\u09bc\u09bc"
        + "\u09be\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09cd"
        + "\u09d7\u09d7"
        + "\u09e2\u09e3"
        + "\u0a01\u0a03"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a70\u0a71"
        + "\u0a75\u0a75"
        + "\u0a81\u0a83"
        + "\u0abc\u0abc"
        + "\u0abe\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ae2\u0ae3"
        + "\u0b01\u0b03"
        + "\u0b3c\u0b3c"
        + "\u0b3e\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b62\u0b63"
        + "\u0b82\u0b82"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0c00\u0c03"
        + "\u0c3e\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c62\u0c63"
        + "\u0c81\u0c83"
        + "\u0cbc\u0cbc"
        + "\u0cbe\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0ce2\u0ce3"
        + "\u0d01\u0d03"
        + "\u0d3e\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d62\u0d63"
        + "\u0d82\u0d83"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df3"
        + "\u0f18\u0f19"
        + "\u0f35\u0f35"
        + "\u0f37\u0f37"
        + "\u0f39\u0f39"
        + "\u0f3e\u0f3f"
        + "\u0f71\u0f7e"
        + "\u0f80\u0f84"
        + "\u0f86\u0f87"
        + "\u0f8d\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fc6\u0fc6"
        + "\u135d\u135f"
        + "\u1712\u1714"
        + "\u1732\u1734"
        + "\u1752\u1753"
        + "\u1772\u1773"
        + "\u180b\u180d"
        + "\u18a9\u18a9"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1a17\u1a1b"
        + "\u1a7f\u1a7f"
        + "\u1ab0\u1abe"
        + "\u1b00\u1b04"
        + "\u1b34\u1b44"
        + "\u1b6b\u1b73"
        + "\u1b80\u1b82"
        + "\u1ba1\u1bad"
        + "\u1be6\u1bf3"
        + "\u1c24\u1c37"
        + "\u1cd0\u1cd2"
        + "\u1cd4\u1ce8"
        + "\u1ced\u1ced"
        + "\u1cf2\u1cf4"
        + "\u1cf8\u1cf9"
        + "\u1dc0\u1df5"
        + "\u1dfc\u1dff"
        + "\u200c\u200f"
        + "\u202a\u202e"
        + "\u2066\u206f"
        + "\u20d0\u20f0"
        + "\u2cef\u2cf1"
        + "\u2d7f\u2d7f"
        + "\u2de0\u2dff"
        + "\u302a\u302f"
        + "\u3035\u3035"
        + "\u3099\u309a"
        + "\ua66f\ua672"
        + "\ua674\ua67d"
        + "\ua69f\ua69f"
        + "\ua6f0\ua6f1"
        + "\ua802\ua802"
        + "\ua806\ua806"
        + "\ua80b\ua80b"
        + "\ua823\ua827"
        + "\ua880\ua881"
        + "\ua8b4\ua8c4"
        + "\ua8e0\ua8f1"
        + "\ua926\ua92d"
        + "\ua947\ua953"
        + "\ua980\ua983"
        + "\ua9b3\ua9c0"
        + "\uaa29\uaa36"
        + "\uaa43\uaa43"
        + "\uaa4c\uaa4d"
        + "\uaaeb\uaaef"
        + "\uaaf5\uaaf6"
        + "\uabe3\uabea"
        + "\uabec\uabed"
        + "\ufb1e\ufb1e"
        + "\ufe00\ufe0f"
        + "\ufe20\ufe2d"
        + "\ufff9\ufffb"
        + "\ud800\uddfd\ud800\uddfd"
        + "\ud800\udee0\ud800\udee0"
        + "\ud800\udf76\ud800\udf7a"
        + "\ud802\ude01\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude0f"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude3f"
        + "\ud802\udee5\ud802\udee6"
        + "\ud804\udc00\ud804\udc02"
        + "\ud804\udc38\ud804\udc46"
        + "\ud804\udc7f\ud804\udc82"
        + "\ud804\udcb0\ud804\udcba"
        + "\ud804\udd00\ud804\udd02"
        + "\ud804\udd27\ud804\udd34"
        + "\ud804\udd73\ud804\udd73"
        + "\ud804\udd80\ud804\udd82"
        + "\ud804\uddb3\ud804\uddc0"
        + "\ud804\ude2c\ud804\ude37"
        + "\ud804\udedf\ud804\udeea"
        + "\ud804\udf01\ud804\udf03"
        + "\ud804\udf3c\ud804\udf3c"
        + "\ud804\udf3e\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf62\ud804\udf63"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udcb0\ud805\udcc3"
        + "\ud805\uddaf\ud805\uddb5"
        + "\ud805\uddb8\ud805\uddc0"
        + "\ud805\ude30\ud805\ude40"
        + "\ud805\udeab\ud805\udeb7"
        + "\ud81a\udef0\ud81a\udef4"
        + "\ud81a\udf30\ud81a\udf36"
        + "\ud81b\udf51\ud81b\udf7e"
        + "\ud81b\udf8f\ud81b\udf92"
        + "\ud82f\udc9d\ud82f\udc9e"
        + "\ud82f\udca0\ud82f\udca3"
        + "\ud834\udd65\ud834\udd69"
        + "\ud834\udd6d\ud834\udd82"
        + "\ud834\udd85\ud834\udd8b"
        + "\ud834\uddaa\ud834\uddad"
        + "\ud834\ude42\ud834\ude44"
        + "\ud83a\udcd0\ud83a\udcd6"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef",
    // Unicode 7.0 property value: {linebreak=complexcontext}
    "\u0e01\u0e3a"
        + "\u0e40\u0e4e"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0edc\u0edf"
        + "\u1000\u103f"
        + "\u1050\u108f"
        + "\u109a\u109f"
        + "\u1780\u17d3"
        + "\u17d7\u17d7"
        + "\u17dc\u17dd"
        + "\u1950\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19da\u19da"
        + "\u19de\u19df"
        + "\u1a20\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1aa0\u1aad"
        + "\ua9e0\ua9ef"
        + "\ua9fa\ua9fe"
        + "\uaa60\uaac2"
        + "\uaadb\uaadf",
    // Unicode 7.0 property value: {linebreak=conditionaljapanesestarter}
    "\u3041\u3041"
        + "\u3043\u3043"
        + "\u3045\u3045"
        + "\u3047\u3047"
        + "\u3049\u3049"
        + "\u3063\u3063"
        + "\u3083\u3083"
        + "\u3085\u3085"
        + "\u3087\u3087"
        + "\u308e\u308e"
        + "\u3095\u3096"
        + "\u30a1\u30a1"
        + "\u30a3\u30a3"
        + "\u30a5\u30a5"
        + "\u30a7\u30a7"
        + "\u30a9\u30a9"
        + "\u30c3\u30c3"
        + "\u30e3\u30e3"
        + "\u30e5\u30e5"
        + "\u30e7\u30e7"
        + "\u30ee\u30ee"
        + "\u30f5\u30f6"
        + "\u30fc\u30fc"
        + "\u31f0\u31ff"
        + "\uff67\uff70",
    // Unicode 7.0 property value: {linebreak=contingentbreak}
    "\ufffc\ufffc",
    // Unicode 7.0 property value: {linebreak=exclamation}
    "\u0021\u0021"
        + "\u003f\u003f"
        + "\u05c6\u05c6"
        + "\u061b\u061b"
        + "\u061e\u061f"
        + "\u06d4\u06d4"
        + "\u07f9\u07f9"
        + "\u0f0d\u0f11"
        + "\u0f14\u0f14"
        + "\u1802\u1803"
        + "\u1808\u1809"
        + "\u1944\u1945"
        + "\u2762\u2763"
        + "\u2cf9\u2cf9"
        + "\u2cfe\u2cfe"
        + "\u2e2e\u2e2e"
        + "\ua60e\ua60e"
        + "\ua876\ua877"
        + "\ufe15\ufe16"
        + "\ufe56\ufe57"
        + "\uff01\uff01"
        + "\uff1f\uff1f"
        + "\ud805\uddc4\ud805\uddc5",
    // Unicode 7.0 property value: {linebreak=glue}
    "\u00a0\u00a0"
        + "\u034f\u034f"
        + "\u035c\u0362"
        + "\u0f08\u0f08"
        + "\u0f0c\u0f0c"
        + "\u0f12\u0f12"
        + "\u0fd9\u0fda"
        + "\u180e\u180e"
        + "\u2007\u2007"
        + "\u2011\u2011"
        + "\u202f\u202f",
    // Unicode 7.0 property value: {linebreak=h2}
    "\uac00\uac00"
        + "\uac1c\uac1c"
        + "\uac38\uac38"
        + "\uac54\uac54"
        + "\uac70\uac70"
        + "\uac8c\uac8c"
        + "\uaca8\uaca8"
        + "\uacc4\uacc4"
        + "\uace0\uace0"
        + "\uacfc\uacfc"
        + "\uad18\uad18"
        + "\uad34\uad34"
        + "\uad50\uad50"
        + "\uad6c\uad6c"
        + "\uad88\uad88"
        + "\uada4\uada4"
        + "\uadc0\uadc0"
        + "\uaddc\uaddc"
        + "\uadf8\uadf8"
        + "\uae14\uae14"
        + "\uae30\uae30"
        + "\uae4c\uae4c"
        + "\uae68\uae68"
        + "\uae84\uae84"
        + "\uaea0\uaea0"
        + "\uaebc\uaebc"
        + "\uaed8\uaed8"
        + "\uaef4\uaef4"
        + "\uaf10\uaf10"
        + "\uaf2c\uaf2c"
        + "\uaf48\uaf48"
        + "\uaf64\uaf64"
        + "\uaf80\uaf80"
        + "\uaf9c\uaf9c"
        + "\uafb8\uafb8"
        + "\uafd4\uafd4"
        + "\uaff0\uaff0"
        + "\ub00c\ub00c"
        + "\ub028\ub028"
        + "\ub044\ub044"
        + "\ub060\ub060"
        + "\ub07c\ub07c"
        + "\ub098\ub098"
        + "\ub0b4\ub0b4"
        + "\ub0d0\ub0d0"
        + "\ub0ec\ub0ec"
        + "\ub108\ub108"
        + "\ub124\ub124"
        + "\ub140\ub140"
        + "\ub15c\ub15c"
        + "\ub178\ub178"
        + "\ub194\ub194"
        + "\ub1b0\ub1b0"
        + "\ub1cc\ub1cc"
        + "\ub1e8\ub1e8"
        + "\ub204\ub204"
        + "\ub220\ub220"
        + "\ub23c\ub23c"
        + "\ub258\ub258"
        + "\ub274\ub274"
        + "\ub290\ub290"
        + "\ub2ac\ub2ac"
        + "\ub2c8\ub2c8"
        + "\ub2e4\ub2e4"
        + "\ub300\ub300"
        + "\ub31c\ub31c"
        + "\ub338\ub338"
        + "\ub354\ub354"
        + "\ub370\ub370"
        + "\ub38c\ub38c"
        + "\ub3a8\ub3a8"
        + "\ub3c4\ub3c4"
        + "\ub3e0\ub3e0"
        + "\ub3fc\ub3fc"
        + "\ub418\ub418"
        + "\ub434\ub434"
        + "\ub450\ub450"
        + "\ub46c\ub46c"
        + "\ub488\ub488"
        + "\ub4a4\ub4a4"
        + "\ub4c0\ub4c0"
        + "\ub4dc\ub4dc"
        + "\ub4f8\ub4f8"
        + "\ub514\ub514"
        + "\ub530\ub530"
        + "\ub54c\ub54c"
        + "\ub568\ub568"
        + "\ub584\ub584"
        + "\ub5a0\ub5a0"
        + "\ub5bc\ub5bc"
        + "\ub5d8\ub5d8"
        + "\ub5f4\ub5f4"
        + "\ub610\ub610"
        + "\ub62c\ub62c"
        + "\ub648\ub648"
        + "\ub664\ub664"
        + "\ub680\ub680"
        + "\ub69c\ub69c"
        + "\ub6b8\ub6b8"
        + "\ub6d4\ub6d4"
        + "\ub6f0\ub6f0"
        + "\ub70c\ub70c"
        + "\ub728\ub728"
        + "\ub744\ub744"
        + "\ub760\ub760"
        + "\ub77c\ub77c"
        + "\ub798\ub798"
        + "\ub7b4\ub7b4"
        + "\ub7d0\ub7d0"
        + "\ub7ec\ub7ec"
        + "\ub808\ub808"
        + "\ub824\ub824"
        + "\ub840\ub840"
        + "\ub85c\ub85c"
        + "\ub878\ub878"
        + "\ub894\ub894"
        + "\ub8b0\ub8b0"
        + "\ub8cc\ub8cc"
        + "\ub8e8\ub8e8"
        + "\ub904\ub904"
        + "\ub920\ub920"
        + "\ub93c\ub93c"
        + "\ub958\ub958"
        + "\ub974\ub974"
        + "\ub990\ub990"
        + "\ub9ac\ub9ac"
        + "\ub9c8\ub9c8"
        + "\ub9e4\ub9e4"
        + "\uba00\uba00"
        + "\uba1c\uba1c"
        + "\uba38\uba38"
        + "\uba54\uba54"
        + "\uba70\uba70"
        + "\uba8c\uba8c"
        + "\ubaa8\ubaa8"
        + "\ubac4\ubac4"
        + "\ubae0\ubae0"
        + "\ubafc\ubafc"
        + "\ubb18\ubb18"
        + "\ubb34\ubb34"
        + "\ubb50\ubb50"
        + "\ubb6c\ubb6c"
        + "\ubb88\ubb88"
        + "\ubba4\ubba4"
        + "\ubbc0\ubbc0"
        + "\ubbdc\ubbdc"
        + "\ubbf8\ubbf8"
        + "\ubc14\ubc14"
        + "\ubc30\ubc30"
        + "\ubc4c\ubc4c"
        + "\ubc68\ubc68"
        + "\ubc84\ubc84"
        + "\ubca0\ubca0"
        + "\ubcbc\ubcbc"
        + "\ubcd8\ubcd8"
        + "\ubcf4\ubcf4"
        + "\ubd10\ubd10"
        + "\ubd2c\ubd2c"
        + "\ubd48\ubd48"
        + "\ubd64\ubd64"
        + "\ubd80\ubd80"
        + "\ubd9c\ubd9c"
        + "\ubdb8\ubdb8"
        + "\ubdd4\ubdd4"
        + "\ubdf0\ubdf0"
        + "\ube0c\ube0c"
        + "\ube28\ube28"
        + "\ube44\ube44"
        + "\ube60\ube60"
        + "\ube7c\ube7c"
        + "\ube98\ube98"
        + "\ubeb4\ubeb4"
        + "\ubed0\ubed0"
        + "\ubeec\ubeec"
        + "\ubf08\ubf08"
        + "\ubf24\ubf24"
        + "\ubf40\ubf40"
        + "\ubf5c\ubf5c"
        + "\ubf78\ubf78"
        + "\ubf94\ubf94"
        + "\ubfb0\ubfb0"
        + "\ubfcc\ubfcc"
        + "\ubfe8\ubfe8"
        + "\uc004\uc004"
        + "\uc020\uc020"
        + "\uc03c\uc03c"
        + "\uc058\uc058"
        + "\uc074\uc074"
        + "\uc090\uc090"
        + "\uc0ac\uc0ac"
        + "\uc0c8\uc0c8"
        + "\uc0e4\uc0e4"
        + "\uc100\uc100"
        + "\uc11c\uc11c"
        + "\uc138\uc138"
        + "\uc154\uc154"
        + "\uc170\uc170"
        + "\uc18c\uc18c"
        + "\uc1a8\uc1a8"
        + "\uc1c4\uc1c4"
        + "\uc1e0\uc1e0"
        + "\uc1fc\uc1fc"
        + "\uc218\uc218"
        + "\uc234\uc234"
        + "\uc250\uc250"
        + "\uc26c\uc26c"
        + "\uc288\uc288"
        + "\uc2a4\uc2a4"
        + "\uc2c0\uc2c0"
        + "\uc2dc\uc2dc"
        + "\uc2f8\uc2f8"
        + "\uc314\uc314"
        + "\uc330\uc330"
        + "\uc34c\uc34c"
        + "\uc368\uc368"
        + "\uc384\uc384"
        + "\uc3a0\uc3a0"
        + "\uc3bc\uc3bc"
        + "\uc3d8\uc3d8"
        + "\uc3f4\uc3f4"
        + "\uc410\uc410"
        + "\uc42c\uc42c"
        + "\uc448\uc448"
        + "\uc464\uc464"
        + "\uc480\uc480"
        + "\uc49c\uc49c"
        + "\uc4b8\uc4b8"
        + "\uc4d4\uc4d4"
        + "\uc4f0\uc4f0"
        + "\uc50c\uc50c"
        + "\uc528\uc528"
        + "\uc544\uc544"
        + "\uc560\uc560"
        + "\uc57c\uc57c"
        + "\uc598\uc598"
        + "\uc5b4\uc5b4"
        + "\uc5d0\uc5d0"
        + "\uc5ec\uc5ec"
        + "\uc608\uc608"
        + "\uc624\uc624"
        + "\uc640\uc640"
        + "\uc65c\uc65c"
        + "\uc678\uc678"
        + "\uc694\uc694"
        + "\uc6b0\uc6b0"
        + "\uc6cc\uc6cc"
        + "\uc6e8\uc6e8"
        + "\uc704\uc704"
        + "\uc720\uc720"
        + "\uc73c\uc73c"
        + "\uc758\uc758"
        + "\uc774\uc774"
        + "\uc790\uc790"
        + "\uc7ac\uc7ac"
        + "\uc7c8\uc7c8"
        + "\uc7e4\uc7e4"
        + "\uc800\uc800"
        + "\uc81c\uc81c"
        + "\uc838\uc838"
        + "\uc854\uc854"
        + "\uc870\uc870"
        + "\uc88c\uc88c"
        + "\uc8a8\uc8a8"
        + "\uc8c4\uc8c4"
        + "\uc8e0\uc8e0"
        + "\uc8fc\uc8fc"
        + "\uc918\uc918"
        + "\uc934\uc934"
        + "\uc950\uc950"
        + "\uc96c\uc96c"
        + "\uc988\uc988"
        + "\uc9a4\uc9a4"
        + "\uc9c0\uc9c0"
        + "\uc9dc\uc9dc"
        + "\uc9f8\uc9f8"
        + "\uca14\uca14"
        + "\uca30\uca30"
        + "\uca4c\uca4c"
        + "\uca68\uca68"
        + "\uca84\uca84"
        + "\ucaa0\ucaa0"
        + "\ucabc\ucabc"
        + "\ucad8\ucad8"
        + "\ucaf4\ucaf4"
        + "\ucb10\ucb10"
        + "\ucb2c\ucb2c"
        + "\ucb48\ucb48"
        + "\ucb64\ucb64"
        + "\ucb80\ucb80"
        + "\ucb9c\ucb9c"
        + "\ucbb8\ucbb8"
        + "\ucbd4\ucbd4"
        + "\ucbf0\ucbf0"
        + "\ucc0c\ucc0c"
        + "\ucc28\ucc28"
        + "\ucc44\ucc44"
        + "\ucc60\ucc60"
        + "\ucc7c\ucc7c"
        + "\ucc98\ucc98"
        + "\uccb4\uccb4"
        + "\uccd0\uccd0"
        + "\uccec\uccec"
        + "\ucd08\ucd08"
        + "\ucd24\ucd24"
        + "\ucd40\ucd40"
        + "\ucd5c\ucd5c"
        + "\ucd78\ucd78"
        + "\ucd94\ucd94"
        + "\ucdb0\ucdb0"
        + "\ucdcc\ucdcc"
        + "\ucde8\ucde8"
        + "\uce04\uce04"
        + "\uce20\uce20"
        + "\uce3c\uce3c"
        + "\uce58\uce58"
        + "\uce74\uce74"
        + "\uce90\uce90"
        + "\uceac\uceac"
        + "\ucec8\ucec8"
        + "\ucee4\ucee4"
        + "\ucf00\ucf00"
        + "\ucf1c\ucf1c"
        + "\ucf38\ucf38"
        + "\ucf54\ucf54"
        + "\ucf70\ucf70"
        + "\ucf8c\ucf8c"
        + "\ucfa8\ucfa8"
        + "\ucfc4\ucfc4"
        + "\ucfe0\ucfe0"
        + "\ucffc\ucffc"
        + "\ud018\ud018"
        + "\ud034\ud034"
        + "\ud050\ud050"
        + "\ud06c\ud06c"
        + "\ud088\ud088"
        + "\ud0a4\ud0a4"
        + "\ud0c0\ud0c0"
        + "\ud0dc\ud0dc"
        + "\ud0f8\ud0f8"
        + "\ud114\ud114"
        + "\ud130\ud130"
        + "\ud14c\ud14c"
        + "\ud168\ud168"
        + "\ud184\ud184"
        + "\ud1a0\ud1a0"
        + "\ud1bc\ud1bc"
        + "\ud1d8\ud1d8"
        + "\ud1f4\ud1f4"
        + "\ud210\ud210"
        + "\ud22c\ud22c"
        + "\ud248\ud248"
        + "\ud264\ud264"
        + "\ud280\ud280"
        + "\ud29c\ud29c"
        + "\ud2b8\ud2b8"
        + "\ud2d4\ud2d4"
        + "\ud2f0\ud2f0"
        + "\ud30c\ud30c"
        + "\ud328\ud328"
        + "\ud344\ud344"
        + "\ud360\ud360"
        + "\ud37c\ud37c"
        + "\ud398\ud398"
        + "\ud3b4\ud3b4"
        + "\ud3d0\ud3d0"
        + "\ud3ec\ud3ec"
        + "\ud408\ud408"
        + "\ud424\ud424"
        + "\ud440\ud440"
        + "\ud45c\ud45c"
        + "\ud478\ud478"
        + "\ud494\ud494"
        + "\ud4b0\ud4b0"
        + "\ud4cc\ud4cc"
        + "\ud4e8\ud4e8"
        + "\ud504\ud504"
        + "\ud520\ud520"
        + "\ud53c\ud53c"
        + "\ud558\ud558"
        + "\ud574\ud574"
        + "\ud590\ud590"
        + "\ud5ac\ud5ac"
        + "\ud5c8\ud5c8"
        + "\ud5e4\ud5e4"
        + "\ud600\ud600"
        + "\ud61c\ud61c"
        + "\ud638\ud638"
        + "\ud654\ud654"
        + "\ud670\ud670"
        + "\ud68c\ud68c"
        + "\ud6a8\ud6a8"
        + "\ud6c4\ud6c4"
        + "\ud6e0\ud6e0"
        + "\ud6fc\ud6fc"
        + "\ud718\ud718"
        + "\ud734\ud734"
        + "\ud750\ud750"
        + "\ud76c\ud76c"
        + "\ud788\ud788",
    // Unicode 7.0 property value: {linebreak=h3}
    "\uac01\uac1b"
        + "\uac1d\uac37"
        + "\uac39\uac53"
        + "\uac55\uac6f"
        + "\uac71\uac8b"
        + "\uac8d\uaca7"
        + "\uaca9\uacc3"
        + "\uacc5\uacdf"
        + "\uace1\uacfb"
        + "\uacfd\uad17"
        + "\uad19\uad33"
        + "\uad35\uad4f"
        + "\uad51\uad6b"
        + "\uad6d\uad87"
        + "\uad89\uada3"
        + "\uada5\uadbf"
        + "\uadc1\uaddb"
        + "\uaddd\uadf7"
        + "\uadf9\uae13"
        + "\uae15\uae2f"
        + "\uae31\uae4b"
        + "\uae4d\uae67"
        + "\uae69\uae83"
        + "\uae85\uae9f"
        + "\uaea1\uaebb"
        + "\uaebd\uaed7"
        + "\uaed9\uaef3"
        + "\uaef5\uaf0f"
        + "\uaf11\uaf2b"
        + "\uaf2d\uaf47"
        + "\uaf49\uaf63"
        + "\uaf65\uaf7f"
        + "\uaf81\uaf9b"
        + "\uaf9d\uafb7"
        + "\uafb9\uafd3"
        + "\uafd5\uafef"
        + "\uaff1\ub00b"
        + "\ub00d\ub027"
        + "\ub029\ub043"
        + "\ub045\ub05f"
        + "\ub061\ub07b"
        + "\ub07d\ub097"
        + "\ub099\ub0b3"
        + "\ub0b5\ub0cf"
        + "\ub0d1\ub0eb"
        + "\ub0ed\ub107"
        + "\ub109\ub123"
        + "\ub125\ub13f"
        + "\ub141\ub15b"
        + "\ub15d\ub177"
        + "\ub179\ub193"
        + "\ub195\ub1af"
        + "\ub1b1\ub1cb"
        + "\ub1cd\ub1e7"
        + "\ub1e9\ub203"
        + "\ub205\ub21f"
        + "\ub221\ub23b"
        + "\ub23d\ub257"
        + "\ub259\ub273"
        + "\ub275\ub28f"
        + "\ub291\ub2ab"
        + "\ub2ad\ub2c7"
        + "\ub2c9\ub2e3"
        + "\ub2e5\ub2ff"
        + "\ub301\ub31b"
        + "\ub31d\ub337"
        + "\ub339\ub353"
        + "\ub355\ub36f"
        + "\ub371\ub38b"
        + "\ub38d\ub3a7"
        + "\ub3a9\ub3c3"
        + "\ub3c5\ub3df"
        + "\ub3e1\ub3fb"
        + "\ub3fd\ub417"
        + "\ub419\ub433"
        + "\ub435\ub44f"
        + "\ub451\ub46b"
        + "\ub46d\ub487"
        + "\ub489\ub4a3"
        + "\ub4a5\ub4bf"
        + "\ub4c1\ub4db"
        + "\ub4dd\ub4f7"
        + "\ub4f9\ub513"
        + "\ub515\ub52f"
        + "\ub531\ub54b"
        + "\ub54d\ub567"
        + "\ub569\ub583"
        + "\ub585\ub59f"
        + "\ub5a1\ub5bb"
        + "\ub5bd\ub5d7"
        + "\ub5d9\ub5f3"
        + "\ub5f5\ub60f"
        + "\ub611\ub62b"
        + "\ub62d\ub647"
        + "\ub649\ub663"
        + "\ub665\ub67f"
        + "\ub681\ub69b"
        + "\ub69d\ub6b7"
        + "\ub6b9\ub6d3"
        + "\ub6d5\ub6ef"
        + "\ub6f1\ub70b"
        + "\ub70d\ub727"
        + "\ub729\ub743"
        + "\ub745\ub75f"
        + "\ub761\ub77b"
        + "\ub77d\ub797"
        + "\ub799\ub7b3"
        + "\ub7b5\ub7cf"
        + "\ub7d1\ub7eb"
        + "\ub7ed\ub807"
        + "\ub809\ub823"
        + "\ub825\ub83f"
        + "\ub841\ub85b"
        + "\ub85d\ub877"
        + "\ub879\ub893"
        + "\ub895\ub8af"
        + "\ub8b1\ub8cb"
        + "\ub8cd\ub8e7"
        + "\ub8e9\ub903"
        + "\ub905\ub91f"
        + "\ub921\ub93b"
        + "\ub93d\ub957"
        + "\ub959\ub973"
        + "\ub975\ub98f"
        + "\ub991\ub9ab"
        + "\ub9ad\ub9c7"
        + "\ub9c9\ub9e3"
        + "\ub9e5\ub9ff"
        + "\uba01\uba1b"
        + "\uba1d\uba37"
        + "\uba39\uba53"
        + "\uba55\uba6f"
        + "\uba71\uba8b"
        + "\uba8d\ubaa7"
        + "\ubaa9\ubac3"
        + "\ubac5\ubadf"
        + "\ubae1\ubafb"
        + "\ubafd\ubb17"
        + "\ubb19\ubb33"
        + "\ubb35\ubb4f"
        + "\ubb51\ubb6b"
        + "\ubb6d\ubb87"
        + "\ubb89\ubba3"
        + "\ubba5\ubbbf"
        + "\ubbc1\ubbdb"
        + "\ubbdd\ubbf7"
        + "\ubbf9\ubc13"
        + "\ubc15\ubc2f"
        + "\ubc31\ubc4b"
        + "\ubc4d\ubc67"
        + "\ubc69\ubc83"
        + "\ubc85\ubc9f"
        + "\ubca1\ubcbb"
        + "\ubcbd\ubcd7"
        + "\ubcd9\ubcf3"
        + "\ubcf5\ubd0f"
        + "\ubd11\ubd2b"
        + "\ubd2d\ubd47"
        + "\ubd49\ubd63"
        + "\ubd65\ubd7f"
        + "\ubd81\ubd9b"
        + "\ubd9d\ubdb7"
        + "\ubdb9\ubdd3"
        + "\ubdd5\ubdef"
        + "\ubdf1\ube0b"
        + "\ube0d\ube27"
        + "\ube29\ube43"
        + "\ube45\ube5f"
        + "\ube61\ube7b"
        + "\ube7d\ube97"
        + "\ube99\ubeb3"
        + "\ubeb5\ubecf"
        + "\ubed1\ubeeb"
        + "\ubeed\ubf07"
        + "\ubf09\ubf23"
        + "\ubf25\ubf3f"
        + "\ubf41\ubf5b"
        + "\ubf5d\ubf77"
        + "\ubf79\ubf93"
        + "\ubf95\ubfaf"
        + "\ubfb1\ubfcb"
        + "\ubfcd\ubfe7"
        + "\ubfe9\uc003"
        + "\uc005\uc01f"
        + "\uc021\uc03b"
        + "\uc03d\uc057"
        + "\uc059\uc073"
        + "\uc075\uc08f"
        + "\uc091\uc0ab"
        + "\uc0ad\uc0c7"
        + "\uc0c9\uc0e3"
        + "\uc0e5\uc0ff"
        + "\uc101\uc11b"
        + "\uc11d\uc137"
        + "\uc139\uc153"
        + "\uc155\uc16f"
        + "\uc171\uc18b"
        + "\uc18d\uc1a7"
        + "\uc1a9\uc1c3"
        + "\uc1c5\uc1df"
        + "\uc1e1\uc1fb"
        + "\uc1fd\uc217"
        + "\uc219\uc233"
        + "\uc235\uc24f"
        + "\uc251\uc26b"
        + "\uc26d\uc287"
        + "\uc289\uc2a3"
        + "\uc2a5\uc2bf"
        + "\uc2c1\uc2db"
        + "\uc2dd\uc2f7"
        + "\uc2f9\uc313"
        + "\uc315\uc32f"
        + "\uc331\uc34b"
        + "\uc34d\uc367"
        + "\uc369\uc383"
        + "\uc385\uc39f"
        + "\uc3a1\uc3bb"
        + "\uc3bd\uc3d7"
        + "\uc3d9\uc3f3"
        + "\uc3f5\uc40f"
        + "\uc411\uc42b"
        + "\uc42d\uc447"
        + "\uc449\uc463"
        + "\uc465\uc47f"
        + "\uc481\uc49b"
        + "\uc49d\uc4b7"
        + "\uc4b9\uc4d3"
        + "\uc4d5\uc4ef"
        + "\uc4f1\uc50b"
        + "\uc50d\uc527"
        + "\uc529\uc543"
        + "\uc545\uc55f"
        + "\uc561\uc57b"
        + "\uc57d\uc597"
        + "\uc599\uc5b3"
        + "\uc5b5\uc5cf"
        + "\uc5d1\uc5eb"
        + "\uc5ed\uc607"
        + "\uc609\uc623"
        + "\uc625\uc63f"
        + "\uc641\uc65b"
        + "\uc65d\uc677"
        + "\uc679\uc693"
        + "\uc695\uc6af"
        + "\uc6b1\uc6cb"
        + "\uc6cd\uc6e7"
        + "\uc6e9\uc703"
        + "\uc705\uc71f"
        + "\uc721\uc73b"
        + "\uc73d\uc757"
        + "\uc759\uc773"
        + "\uc775\uc78f"
        + "\uc791\uc7ab"
        + "\uc7ad\uc7c7"
        + "\uc7c9\uc7e3"
        + "\uc7e5\uc7ff"
        + "\uc801\uc81b"
        + "\uc81d\uc837"
        + "\uc839\uc853"
        + "\uc855\uc86f"
        + "\uc871\uc88b"
        + "\uc88d\uc8a7"
        + "\uc8a9\uc8c3"
        + "\uc8c5\uc8df"
        + "\uc8e1\uc8fb"
        + "\uc8fd\uc917"
        + "\uc919\uc933"
        + "\uc935\uc94f"
        + "\uc951\uc96b"
        + "\uc96d\uc987"
        + "\uc989\uc9a3"
        + "\uc9a5\uc9bf"
        + "\uc9c1\uc9db"
        + "\uc9dd\uc9f7"
        + "\uc9f9\uca13"
        + "\uca15\uca2f"
        + "\uca31\uca4b"
        + "\uca4d\uca67"
        + "\uca69\uca83"
        + "\uca85\uca9f"
        + "\ucaa1\ucabb"
        + "\ucabd\ucad7"
        + "\ucad9\ucaf3"
        + "\ucaf5\ucb0f"
        + "\ucb11\ucb2b"
        + "\ucb2d\ucb47"
        + "\ucb49\ucb63"
        + "\ucb65\ucb7f"
        + "\ucb81\ucb9b"
        + "\ucb9d\ucbb7"
        + "\ucbb9\ucbd3"
        + "\ucbd5\ucbef"
        + "\ucbf1\ucc0b"
        + "\ucc0d\ucc27"
        + "\ucc29\ucc43"
        + "\ucc45\ucc5f"
        + "\ucc61\ucc7b"
        + "\ucc7d\ucc97"
        + "\ucc99\uccb3"
        + "\uccb5\ucccf"
        + "\uccd1\ucceb"
        + "\ucced\ucd07"
        + "\ucd09\ucd23"
        + "\ucd25\ucd3f"
        + "\ucd41\ucd5b"
        + "\ucd5d\ucd77"
        + "\ucd79\ucd93"
        + "\ucd95\ucdaf"
        + "\ucdb1\ucdcb"
        + "\ucdcd\ucde7"
        + "\ucde9\uce03"
        + "\uce05\uce1f"
        + "\uce21\uce3b"
        + "\uce3d\uce57"
        + "\uce59\uce73"
        + "\uce75\uce8f"
        + "\uce91\uceab"
        + "\ucead\ucec7"
        + "\ucec9\ucee3"
        + "\ucee5\uceff"
        + "\ucf01\ucf1b"
        + "\ucf1d\ucf37"
        + "\ucf39\ucf53"
        + "\ucf55\ucf6f"
        + "\ucf71\ucf8b"
        + "\ucf8d\ucfa7"
        + "\ucfa9\ucfc3"
        + "\ucfc5\ucfdf"
        + "\ucfe1\ucffb"
        + "\ucffd\ud017"
        + "\ud019\ud033"
        + "\ud035\ud04f"
        + "\ud051\ud06b"
        + "\ud06d\ud087"
        + "\ud089\ud0a3"
        + "\ud0a5\ud0bf"
        + "\ud0c1\ud0db"
        + "\ud0dd\ud0f7"
        + "\ud0f9\ud113"
        + "\ud115\ud12f"
        + "\ud131\ud14b"
        + "\ud14d\ud167"
        + "\ud169\ud183"
        + "\ud185\ud19f"
        + "\ud1a1\ud1bb"
        + "\ud1bd\ud1d7"
        + "\ud1d9\ud1f3"
        + "\ud1f5\ud20f"
        + "\ud211\ud22b"
        + "\ud22d\ud247"
        + "\ud249\ud263"
        + "\ud265\ud27f"
        + "\ud281\ud29b"
        + "\ud29d\ud2b7"
        + "\ud2b9\ud2d3"
        + "\ud2d5\ud2ef"
        + "\ud2f1\ud30b"
        + "\ud30d\ud327"
        + "\ud329\ud343"
        + "\ud345\ud35f"
        + "\ud361\ud37b"
        + "\ud37d\ud397"
        + "\ud399\ud3b3"
        + "\ud3b5\ud3cf"
        + "\ud3d1\ud3eb"
        + "\ud3ed\ud407"
        + "\ud409\ud423"
        + "\ud425\ud43f"
        + "\ud441\ud45b"
        + "\ud45d\ud477"
        + "\ud479\ud493"
        + "\ud495\ud4af"
        + "\ud4b1\ud4cb"
        + "\ud4cd\ud4e7"
        + "\ud4e9\ud503"
        + "\ud505\ud51f"
        + "\ud521\ud53b"
        + "\ud53d\ud557"
        + "\ud559\ud573"
        + "\ud575\ud58f"
        + "\ud591\ud5ab"
        + "\ud5ad\ud5c7"
        + "\ud5c9\ud5e3"
        + "\ud5e5\ud5ff"
        + "\ud601\ud61b"
        + "\ud61d\ud637"
        + "\ud639\ud653"
        + "\ud655\ud66f"
        + "\ud671\ud68b"
        + "\ud68d\ud6a7"
        + "\ud6a9\ud6c3"
        + "\ud6c5\ud6df"
        + "\ud6e1\ud6fb"
        + "\ud6fd\ud717"
        + "\ud719\ud733"
        + "\ud735\ud74f"
        + "\ud751\ud76b"
        + "\ud76d\ud787"
        + "\ud789\ud7a3",
    // Unicode 7.0 property value: {linebreak=hebrewletter}
    "\u05d0\u05ea"
        + "\u05f0\u05f2"
        + "\ufb1d\ufb1d"
        + "\ufb1f\ufb28"
        + "\ufb2a\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufb4f",
    // Unicode 7.0 property value: {linebreak=hyphen}
    "\u002d\u002d",
    // Unicode 7.0 property value: {linebreak=ideographic}
    "\u231a\u231b"
        + "\u23f0\u23f3"
        + "\u2600\u2603"
        + "\u2614\u2615"
        + "\u2618\u2618"
        + "\u261a\u261f"
        + "\u2639\u263b"
        + "\u2668\u2668"
        + "\u267f\u267f"
        + "\u26bd\u26c8"
        + "\u26cd\u26cd"
        + "\u26cf\u26d1"
        + "\u26d3\u26d4"
        + "\u26d8\u26d9"
        + "\u26dc\u26dc"
        + "\u26df\u26e1"
        + "\u26ea\u26ea"
        + "\u26f1\u26f5"
        + "\u26f7\u26fa"
        + "\u26fd\u2704"
        + "\u2708\u270d"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3003\u3004"
        + "\u3006\u3007"
        + "\u3012\u3013"
        + "\u3020\u3029"
        + "\u3030\u3034"
        + "\u3036\u303a"
        + "\u303d\u303f"
        + "\u3042\u3042"
        + "\u3044\u3044"
        + "\u3046\u3046"
        + "\u3048\u3048"
        + "\u304a\u3062"
        + "\u3064\u3082"
        + "\u3084\u3084"
        + "\u3086\u3086"
        + "\u3088\u308d"
        + "\u308f\u3094"
        + "\u309f\u309f"
        + "\u30a2\u30a2"
        + "\u30a4\u30a4"
        + "\u30a6\u30a6"
        + "\u30a8\u30a8"
        + "\u30aa\u30c2"
        + "\u30c4\u30e2"
        + "\u30e4\u30e4"
        + "\u30e6\u30e6"
        + "\u30e8\u30ed"
        + "\u30ef\u30f4"
        + "\u30f7\u30fa"
        + "\u30ff\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u3190\u31ba"
        + "\u31c0\u31e3"
        + "\u3200\u321e"
        + "\u3220\u3247"
        + "\u3250\u32fe"
        + "\u3300\u4dbf"
        + "\u4e00\ua014"
        + "\ua016\ua48c"
        + "\ua490\ua4c6"
        + "\uf900\ufaff"
        + "\ufe30\ufe34"
        + "\ufe45\ufe46"
        + "\ufe49\ufe4f"
        + "\ufe51\ufe51"
        + "\ufe58\ufe58"
        + "\ufe5f\ufe66"
        + "\ufe68\ufe68"
        + "\ufe6b\ufe6b"
        + "\uff02\uff03"
        + "\uff06\uff07"
        + "\uff0a\uff0b"
        + "\uff0d\uff0d"
        + "\uff0f\uff19"
        + "\uff1c\uff1e"
        + "\uff20\uff3a"
        + "\uff3c\uff3c"
        + "\uff3e\uff5a"
        + "\uff5c\uff5c"
        + "\uff5e\uff5e"
        + "\uffe2\uffe4"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udca0\ud83c\udcae"
        + "\ud83c\udcb1\ud83c\udcbf"
        + "\ud83c\udcc1\ud83c\udccf"
        + "\ud83c\udcd1\ud83c\udcf5"
        + "\ud83c\ude00\ud83c\ude02"
        + "\ud83c\ude10\ud83c\ude3a"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83c\ude50\ud83c\ude51"
        + "\ud83c\udf00\ud83c\udf2c"
        + "\ud83c\udf30\ud83c\udf7d"
        + "\ud83c\udf80\ud83c\udf9b"
        + "\ud83c\udf9e\ud83c\udfb4"
        + "\ud83c\udfb7\ud83c\udfbb"
        + "\ud83c\udfbd\ud83c\udfce"
        + "\ud83c\udfd4\ud83c\udff7"
        + "\ud83d\udc00\ud83d\udc9f"
        + "\ud83d\udca1\ud83d\udca1"
        + "\ud83d\udca3\ud83d\udca3"
        + "\ud83d\udca5\ud83d\udcae"
        + "\ud83d\udcb0\ud83d\udcb0"
        + "\ud83d\udcb3\ud83d\udcfe"
        + "\ud83d\udd07\ud83d\udd16"
        + "\ud83d\udd25\ud83d\udd31"
        + "\ud83d\udd4a\ud83d\udd4a"
        + "\ud83d\udd50\ud83d\udd79"
        + "\ud83d\udd7b\ud83d\udda3"
        + "\ud83d\udda5\ud83d\uddd3"
        + "\ud83d\udddc\ud83d\uddf3"
        + "\ud83d\uddfa\ud83d\ude42"
        + "\ud83d\ude45\ud83d\ude4f"
        + "\ud83d\ude80\ud83d\udecf"
        + "\ud83d\udee0\ud83d\udeec"
        + "\ud83d\udef0\ud83d\udef3"
        + "\ud840\udc00\ud87f\udffd"
        + "\ud880\udc00\ud8bf\udffd",
    // Unicode 7.0 property value: {linebreak=infixnumeric}
    "\u002c\u002c"
        + "\u002e\u002e"
        + "\u003a\u003b"
        + "\u037e\u037e"
        + "\u0589\u0589"
        + "\u060c\u060d"
        + "\u07f8\u07f8"
        + "\u2044\u2044"
        + "\ufe10\ufe10"
        + "\ufe13\ufe14",
    // Unicode 7.0 property value: {linebreak=inseparable}
    "\u2024\u2026" + "\ufe19\ufe19" + "\ud802\udef6\ud802\udef6",
    // Unicode 7.0 property value: {linebreak=jl}
    "\u1100\u115f" + "\ua960\ua97c",
    // Unicode 7.0 property value: {linebreak=jt}
    "\u11a8\u11ff" + "\ud7cb\ud7fb",
    // Unicode 7.0 property value: {linebreak=jv}
    "\u1160\u11a7" + "\ud7b0\ud7c6",
    // Unicode 7.0 property value: {linebreak=linefeed}
    "\n\n",
    // Unicode 7.0 property value: {linebreak=mandatorybreak}
    "\u000b\f" + "\u2028\u2029",
    // Unicode 7.0 property value: {linebreak=nextline}
    "\u0085\u0085",
    // Unicode 7.0 property value: {linebreak=nonstarter}
    "\u17d6\u17d6"
        + "\u203c\u203d"
        + "\u2047\u2049"
        + "\u3005\u3005"
        + "\u301c\u301c"
        + "\u303b\u303c"
        + "\u309b\u309e"
        + "\u30a0\u30a0"
        + "\u30fb\u30fb"
        + "\u30fd\u30fe"
        + "\ua015\ua015"
        + "\ufe54\ufe55"
        + "\uff1a\uff1b"
        + "\uff65\uff65"
        + "\uff9e\uff9f"
        + "\ud83d\ude79\ud83d\ude7b",
    // Unicode 7.0 property value: {linebreak=numeric}
    "\u0030\u0039"
        + "\u0660\u0669"
        + "\u066b\u066c"
        + "\u06f0\u06f9"
        + "\u07c0\u07c9"
        + "\u0966\u096f"
        + "\u09e6\u09ef"
        + "\u0a66\u0a6f"
        + "\u0ae6\u0aef"
        + "\u0b66\u0b6f"
        + "\u0be6\u0bef"
        + "\u0c66\u0c6f"
        + "\u0ce6\u0cef"
        + "\u0d66\u0d6f"
        + "\u0de6\u0def"
        + "\u0e50\u0e59"
        + "\u0ed0\u0ed9"
        + "\u0f20\u0f29"
        + "\u1040\u1049"
        + "\u1090\u1099"
        + "\u17e0\u17e9"
        + "\u1810\u1819"
        + "\u1946\u194f"
        + "\u19d0\u19d9"
        + "\u1a80\u1a89"
        + "\u1a90\u1a99"
        + "\u1b50\u1b59"
        + "\u1bb0\u1bb9"
        + "\u1c40\u1c49"
        + "\u1c50\u1c59"
        + "\ua620\ua629"
        + "\ua8d0\ua8d9"
        + "\ua900\ua909"
        + "\ua9d0\ua9d9"
        + "\ua9f0\ua9f9"
        + "\uaa50\uaa59"
        + "\uabf0\uabf9"
        + "\ud801\udca0\ud801\udca9"
        + "\ud804\udc66\ud804\udc6f"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd36\ud804\udd3f"
        + "\ud804\uddd0\ud804\uddd9"
        + "\ud804\udef0\ud804\udef9"
        + "\ud805\udcd0\ud805\udcd9"
        + "\ud805\ude50\ud805\ude59"
        + "\ud805\udec0\ud805\udec9"
        + "\ud806\udce0\ud806\udce9"
        + "\ud81a\ude60\ud81a\ude69"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud835\udfce\ud835\udfff",
    // Unicode 7.0 property value: {linebreak=openpunctuation}
    "\u0028\u0028"
        + "\u005b\u005b"
        + "\u007b\u007b"
        + "\u00a1\u00a1"
        + "\u00bf\u00bf"
        + "\u0f3a\u0f3a"
        + "\u0f3c\u0f3c"
        + "\u169b\u169b"
        + "\u201a\u201a"
        + "\u201e\u201e"
        + "\u2045\u2045"
        + "\u207d\u207d"
        + "\u208d\u208d"
        + "\u2308\u2308"
        + "\u230a\u230a"
        + "\u2329\u2329"
        + "\u2768\u2768"
        + "\u276a\u276a"
        + "\u276c\u276c"
        + "\u276e\u276e"
        + "\u2770\u2770"
        + "\u2772\u2772"
        + "\u2774\u2774"
        + "\u27c5\u27c5"
        + "\u27e6\u27e6"
        + "\u27e8\u27e8"
        + "\u27ea\u27ea"
        + "\u27ec\u27ec"
        + "\u27ee\u27ee"
        + "\u2983\u2983"
        + "\u2985\u2985"
        + "\u2987\u2987"
        + "\u2989\u2989"
        + "\u298b\u298b"
        + "\u298d\u298d"
        + "\u298f\u298f"
        + "\u2991\u2991"
        + "\u2993\u2993"
        + "\u2995\u2995"
        + "\u2997\u2997"
        + "\u29d8\u29d8"
        + "\u29da\u29da"
        + "\u29fc\u29fc"
        + "\u2e18\u2e18"
        + "\u2e22\u2e22"
        + "\u2e24\u2e24"
        + "\u2e26\u2e26"
        + "\u2e28\u2e28"
        + "\u2e42\u2e42"
        + "\u3008\u3008"
        + "\u300a\u300a"
        + "\u300c\u300c"
        + "\u300e\u300e"
        + "\u3010\u3010"
        + "\u3014\u3014"
        + "\u3016\u3016"
        + "\u3018\u3018"
        + "\u301a\u301a"
        + "\u301d\u301d"
        + "\ufd3f\ufd3f"
        + "\ufe17\ufe17"
        + "\ufe35\ufe35"
        + "\ufe37\ufe37"
        + "\ufe39\ufe39"
        + "\ufe3b\ufe3b"
        + "\ufe3d\ufe3d"
        + "\ufe3f\ufe3f"
        + "\ufe41\ufe41"
        + "\ufe43\ufe43"
        + "\ufe47\ufe47"
        + "\ufe59\ufe59"
        + "\ufe5b\ufe5b"
        + "\ufe5d\ufe5d"
        + "\uff08\uff08"
        + "\uff3b\uff3b"
        + "\uff5b\uff5b"
        + "\uff5f\uff5f"
        + "\uff62\uff62"
        + "\ud80c\ude58\ud80c\ude5a"
        + "\ud80c\ude86\ud80c\ude86"
        + "\ud80c\ude88\ud80c\ude88"
        + "\ud80c\udf79\ud80c\udf79",
    // Unicode 7.0 property value: {linebreak=postfixnumeric}
    "\u0025\u0025"
        + "\u00a2\u00a2"
        + "\u00b0\u00b0"
        + "\u0609\u060b"
        + "\u066a\u066a"
        + "\u09f2\u09f3"
        + "\u09f9\u09f9"
        + "\u0d79\u0d79"
        + "\u2030\u2037"
        + "\u20a7\u20a7"
        + "\u20b6\u20b6"
        + "\u20bb\u20bb"
        + "\u2103\u2103"
        + "\u2109\u2109"
        + "\ua838\ua838"
        + "\ufdfc\ufdfc"
        + "\ufe6a\ufe6a"
        + "\uff05\uff05"
        + "\uffe0\uffe0",
    // Unicode 7.0 property value: {linebreak=prefixnumeric}
    "\u0024\u0024"
        + "\u002b\u002b"
        + "\\\\"
        + "\u00a3\u00a5"
        + "\u00b1\u00b1"
        + "\u058f\u058f"
        + "\u09fb\u09fb"
        + "\u0af1\u0af1"
        + "\u0bf9\u0bf9"
        + "\u0e3f\u0e3f"
        + "\u17db\u17db"
        + "\u20a0\u20a6"
        + "\u20a8\u20b5"
        + "\u20b7\u20ba"
        + "\u20bc\u20cf"
        + "\u2116\u2116"
        + "\u2212\u2213"
        + "\ufe69\ufe69"
        + "\uff04\uff04"
        + "\uffe1\uffe1"
        + "\uffe5\uffe6",
    // Unicode 7.0 property value: {linebreak=quotation}
    "\"\""
        + "\u0027\u0027"
        + "\u00ab\u00ab"
        + "\u00bb\u00bb"
        + "\u2018\u2019"
        + "\u201b\u201d"
        + "\u201f\u201f"
        + "\u2039\u203a"
        + "\u275b\u2760"
        + "\u2e00\u2e0d"
        + "\u2e1c\u2e1d"
        + "\u2e20\u2e21"
        + "\ud83d\ude76\ud83d\ude78",
    // Unicode 7.0 property value: {linebreak=regionalindicator}
    "\ud83c\udde6\ud83c\uddff",
    // Unicode 7.0 property value: {linebreak=space}
    "\u0020\u0020",
    // Unicode 7.0 property value: {linebreak=unknown}
    "\u0378\u0379"
        + "\u0380\u0383"
        + "\u038b\u038b"
        + "\u038d\u038d"
        + "\u03a2\u03a2"
        + "\u0530\u0530"
        + "\u0557\u0558"
        + "\u0560\u0560"
        + "\u0588\u0588"
        + "\u058b\u058c"
        + "\u0590\u0590"
        + "\u05c8\u05cf"
        + "\u05eb\u05ef"
        + "\u05f5\u05ff"
        + "\u061d\u061d"
        + "\u070e\u070e"
        + "\u074b\u074c"
        + "\u07b2\u07bf"
        + "\u07fb\u07ff"
        + "\u082e\u082f"
        + "\u083f\u083f"
        + "\u085c\u085d"
        + "\u085f\u089f"
        + "\u08b3\u08e3"
        + "\u0984\u0984"
        + "\u098d\u098e"
        + "\u0991\u0992"
        + "\u09a9\u09a9"
        + "\u09b1\u09b1"
        + "\u09b3\u09b5"
        + "\u09ba\u09bb"
        + "\u09c5\u09c6"
        + "\u09c9\u09ca"
        + "\u09cf\u09d6"
        + "\u09d8\u09db"
        + "\u09de\u09de"
        + "\u09e4\u09e5"
        + "\u09fc\u0a00"
        + "\u0a04\u0a04"
        + "\u0a0b\u0a0e"
        + "\u0a11\u0a12"
        + "\u0a29\u0a29"
        + "\u0a31\u0a31"
        + "\u0a34\u0a34"
        + "\u0a37\u0a37"
        + "\u0a3a\u0a3b"
        + "\u0a3d\u0a3d"
        + "\u0a43\u0a46"
        + "\u0a49\u0a4a"
        + "\u0a4e\u0a50"
        + "\u0a52\u0a58"
        + "\u0a5d\u0a5d"
        + "\u0a5f\u0a65"
        + "\u0a76\u0a80"
        + "\u0a84\u0a84"
        + "\u0a8e\u0a8e"
        + "\u0a92\u0a92"
        + "\u0aa9\u0aa9"
        + "\u0ab1\u0ab1"
        + "\u0ab4\u0ab4"
        + "\u0aba\u0abb"
        + "\u0ac6\u0ac6"
        + "\u0aca\u0aca"
        + "\u0ace\u0acf"
        + "\u0ad1\u0adf"
        + "\u0ae4\u0ae5"
        + "\u0af2\u0b00"
        + "\u0b04\u0b04"
        + "\u0b0d\u0b0e"
        + "\u0b11\u0b12"
        + "\u0b29\u0b29"
        + "\u0b31\u0b31"
        + "\u0b34\u0b34"
        + "\u0b3a\u0b3b"
        + "\u0b45\u0b46"
        + "\u0b49\u0b4a"
        + "\u0b4e\u0b55"
        + "\u0b58\u0b5b"
        + "\u0b5e\u0b5e"
        + "\u0b64\u0b65"
        + "\u0b78\u0b81"
        + "\u0b84\u0b84"
        + "\u0b8b\u0b8d"
        + "\u0b91\u0b91"
        + "\u0b96\u0b98"
        + "\u0b9b\u0b9b"
        + "\u0b9d\u0b9d"
        + "\u0ba0\u0ba2"
        + "\u0ba5\u0ba7"
        + "\u0bab\u0bad"
        + "\u0bba\u0bbd"
        + "\u0bc3\u0bc5"
        + "\u0bc9\u0bc9"
        + "\u0bce\u0bcf"
        + "\u0bd1\u0bd6"
        + "\u0bd8\u0be5"
        + "\u0bfb\u0bff"
        + "\u0c04\u0c04"
        + "\u0c0d\u0c0d"
        + "\u0c11\u0c11"
        + "\u0c29\u0c29"
        + "\u0c3a\u0c3c"
        + "\u0c45\u0c45"
        + "\u0c49\u0c49"
        + "\u0c4e\u0c54"
        + "\u0c57\u0c57"
        + "\u0c5a\u0c5f"
        + "\u0c64\u0c65"
        + "\u0c70\u0c77"
        + "\u0c80\u0c80"
        + "\u0c84\u0c84"
        + "\u0c8d\u0c8d"
        + "\u0c91\u0c91"
        + "\u0ca9\u0ca9"
        + "\u0cb4\u0cb4"
        + "\u0cba\u0cbb"
        + "\u0cc5\u0cc5"
        + "\u0cc9\u0cc9"
        + "\u0cce\u0cd4"
        + "\u0cd7\u0cdd"
        + "\u0cdf\u0cdf"
        + "\u0ce4\u0ce5"
        + "\u0cf0\u0cf0"
        + "\u0cf3\u0d00"
        + "\u0d04\u0d04"
        + "\u0d0d\u0d0d"
        + "\u0d11\u0d11"
        + "\u0d3b\u0d3c"
        + "\u0d45\u0d45"
        + "\u0d49\u0d49"
        + "\u0d4f\u0d56"
        + "\u0d58\u0d5f"
        + "\u0d64\u0d65"
        + "\u0d76\u0d78"
        + "\u0d80\u0d81"
        + "\u0d84\u0d84"
        + "\u0d97\u0d99"
        + "\u0db2\u0db2"
        + "\u0dbc\u0dbc"
        + "\u0dbe\u0dbf"
        + "\u0dc7\u0dc9"
        + "\u0dcb\u0dce"
        + "\u0dd5\u0dd5"
        + "\u0dd7\u0dd7"
        + "\u0de0\u0de5"
        + "\u0df0\u0df1"
        + "\u0df5\u0e00"
        + "\u0e3b\u0e3e"
        + "\u0e5c\u0e80"
        + "\u0e83\u0e83"
        + "\u0e85\u0e86"
        + "\u0e89\u0e89"
        + "\u0e8b\u0e8c"
        + "\u0e8e\u0e93"
        + "\u0e98\u0e98"
        + "\u0ea0\u0ea0"
        + "\u0ea4\u0ea4"
        + "\u0ea6\u0ea6"
        + "\u0ea8\u0ea9"
        + "\u0eac\u0eac"
        + "\u0eba\u0eba"
        + "\u0ebe\u0ebf"
        + "\u0ec5\u0ec5"
        + "\u0ec7\u0ec7"
        + "\u0ece\u0ecf"
        + "\u0eda\u0edb"
        + "\u0ee0\u0eff"
        + "\u0f48\u0f48"
        + "\u0f6d\u0f70"
        + "\u0f98\u0f98"
        + "\u0fbd\u0fbd"
        + "\u0fcd\u0fcd"
        + "\u0fdb\u0fff"
        + "\u10c6\u10c6"
        + "\u10c8\u10cc"
        + "\u10ce\u10cf"
        + "\u1249\u1249"
        + "\u124e\u124f"
        + "\u1257\u1257"
        + "\u1259\u1259"
        + "\u125e\u125f"
        + "\u1289\u1289"
        + "\u128e\u128f"
        + "\u12b1\u12b1"
        + "\u12b6\u12b7"
        + "\u12bf\u12bf"
        + "\u12c1\u12c1"
        + "\u12c6\u12c7"
        + "\u12d7\u12d7"
        + "\u1311\u1311"
        + "\u1316\u1317"
        + "\u135b\u135c"
        + "\u137d\u137f"
        + "\u139a\u139f"
        + "\u13f5\u13ff"
        + "\u169d\u169f"
        + "\u16f9\u16ff"
        + "\u170d\u170d"
        + "\u1715\u171f"
        + "\u1737\u173f"
        + "\u1754\u175f"
        + "\u176d\u176d"
        + "\u1771\u1771"
        + "\u1774\u177f"
        + "\u17de\u17df"
        + "\u17ea\u17ef"
        + "\u17fa\u17ff"
        + "\u180f\u180f"
        + "\u181a\u181f"
        + "\u1878\u187f"
        + "\u18ab\u18af"
        + "\u18f6\u18ff"
        + "\u191f\u191f"
        + "\u192c\u192f"
        + "\u193c\u193f"
        + "\u1941\u1943"
        + "\u196e\u196f"
        + "\u1975\u197f"
        + "\u19ac\u19af"
        + "\u19ca\u19cf"
        + "\u19db\u19dd"
        + "\u1a1c\u1a1d"
        + "\u1a5f\u1a5f"
        + "\u1a7d\u1a7e"
        + "\u1a8a\u1a8f"
        + "\u1a9a\u1a9f"
        + "\u1aae\u1aaf"
        + "\u1abf\u1aff"
        + "\u1b4c\u1b4f"
        + "\u1b7d\u1b7f"
        + "\u1bf4\u1bfb"
        + "\u1c38\u1c3a"
        + "\u1c4a\u1c4c"
        + "\u1c80\u1cbf"
        + "\u1cc8\u1ccf"
        + "\u1cf7\u1cf7"
        + "\u1cfa\u1cff"
        + "\u1df6\u1dfb"
        + "\u1f16\u1f17"
        + "\u1f1e\u1f1f"
        + "\u1f46\u1f47"
        + "\u1f4e\u1f4f"
        + "\u1f58\u1f58"
        + "\u1f5a\u1f5a"
        + "\u1f5c\u1f5c"
        + "\u1f5e\u1f5e"
        + "\u1f7e\u1f7f"
        + "\u1fb5\u1fb5"
        + "\u1fc5\u1fc5"
        + "\u1fd4\u1fd5"
        + "\u1fdc\u1fdc"
        + "\u1ff0\u1ff1"
        + "\u1ff5\u1ff5"
        + "\u1fff\u1fff"
        + "\u2065\u2065"
        + "\u2072\u2073"
        + "\u208f\u208f"
        + "\u209d\u209f"
        + "\u20f1\u20ff"
        + "\u218a\u218f"
        + "\u23fb\u23ff"
        + "\u2427\u243f"
        + "\u244b\u245f"
        + "\u2b74\u2b75"
        + "\u2b96\u2b97"
        + "\u2bba\u2bbc"
        + "\u2bc9\u2bc9"
        + "\u2bd2\u2bff"
        + "\u2c2f\u2c2f"
        + "\u2c5f\u2c5f"
        + "\u2cf4\u2cf8"
        + "\u2d26\u2d26"
        + "\u2d28\u2d2c"
        + "\u2d2e\u2d2f"
        + "\u2d68\u2d6e"
        + "\u2d71\u2d7e"
        + "\u2d97\u2d9f"
        + "\u2da7\u2da7"
        + "\u2daf\u2daf"
        + "\u2db7\u2db7"
        + "\u2dbf\u2dbf"
        + "\u2dc7\u2dc7"
        + "\u2dcf\u2dcf"
        + "\u2dd7\u2dd7"
        + "\u2ddf\u2ddf"
        + "\u2e43\u2e7f"
        + "\u2e9a\u2e9a"
        + "\u2ef4\u2eff"
        + "\u2fd6\u2fef"
        + "\u2ffc\u2fff"
        + "\u3040\u3040"
        + "\u3097\u3098"
        + "\u3100\u3104"
        + "\u312e\u3130"
        + "\u318f\u318f"
        + "\u31bb\u31bf"
        + "\u31e4\u31ef"
        + "\u321f\u321f"
        + "\u32ff\u32ff"
        + "\ua48d\ua48f"
        + "\ua4c7\ua4cf"
        + "\ua62c\ua63f"
        + "\ua69e\ua69e"
        + "\ua6f8\ua6ff"
        + "\ua78f\ua78f"
        + "\ua7ae\ua7af"
        + "\ua7b2\ua7f6"
        + "\ua82c\ua82f"
        + "\ua83a\ua83f"
        + "\ua878\ua87f"
        + "\ua8c5\ua8cd"
        + "\ua8da\ua8df"
        + "\ua8fc\ua8ff"
        + "\ua954\ua95e"
        + "\ua97d\ua97f"
        + "\ua9ce\ua9ce"
        + "\ua9da\ua9dd"
        + "\ua9ff\ua9ff"
        + "\uaa37\uaa3f"
        + "\uaa4e\uaa4f"
        + "\uaa5a\uaa5b"
        + "\uaac3\uaada"
        + "\uaaf7\uab00"
        + "\uab07\uab08"
        + "\uab0f\uab10"
        + "\uab17\uab1f"
        + "\uab27\uab27"
        + "\uab2f\uab2f"
        + "\uab60\uab63"
        + "\uab66\uabbf"
        + "\uabee\uabef"
        + "\uabfa\uabff"
        + "\ud7a4\ud7af"
        + "\ud7c7\ud7ca"
        + "\ud7fc\ud7ff"
        + "\ue000\uf8ff"
        + "\ufb07\ufb12"
        + "\ufb18\ufb1c"
        + "\ufb37\ufb37"
        + "\ufb3d\ufb3d"
        + "\ufb3f\ufb3f"
        + "\ufb42\ufb42"
        + "\ufb45\ufb45"
        + "\ufbc2\ufbd2"
        + "\ufd40\ufd4f"
        + "\ufd90\ufd91"
        + "\ufdc8\ufdef"
        + "\ufdfe\ufdff"
        + "\ufe1a\ufe1f"
        + "\ufe2e\ufe2f"
        + "\ufe53\ufe53"
        + "\ufe67\ufe67"
        + "\ufe6c\ufe6f"
        + "\ufe75\ufe75"
        + "\ufefd\ufefe"
        + "\uff00\uff00"
        + "\uffbf\uffc1"
        + "\uffc8\uffc9"
        + "\uffd0\uffd1"
        + "\uffd8\uffd9"
        + "\uffdd\uffdf"
        + "\uffe7\uffe7"
        + "\uffef\ufff8"
        + "\ufffe\uffff"
        + "\ud800\udc0c\ud800\udc0c"
        + "\ud800\udc27\ud800\udc27"
        + "\ud800\udc3b\ud800\udc3b"
        + "\ud800\udc3e\ud800\udc3e"
        + "\ud800\udc4e\ud800\udc4f"
        + "\ud800\udc5e\ud800\udc7f"
        + "\ud800\udcfb\ud800\udcff"
        + "\ud800\udd03\ud800\udd06"
        + "\ud800\udd34\ud800\udd36"
        + "\ud800\udd8d\ud800\udd8f"
        + "\ud800\udd9c\ud800\udd9f"
        + "\ud800\udda1\ud800\uddcf"
        + "\ud800\uddfe\ud800\ude7f"
        + "\ud800\ude9d\ud800\ude9f"
        + "\ud800\uded1\ud800\udedf"
        + "\ud800\udefc\ud800\udeff"
        + "\ud800\udf24\ud800\udf2f"
        + "\ud800\udf4b\ud800\udf4f"
        + "\ud800\udf7b\ud800\udf7f"
        + "\ud800\udf9e\ud800\udf9e"
        + "\ud800\udfc4\ud800\udfc7"
        + "\ud800\udfd6\ud800\udfff"
        + "\ud801\udc9e\ud801\udc9f"
        + "\ud801\udcaa\ud801\udcff"
        + "\ud801\udd28\ud801\udd2f"
        + "\ud801\udd64\ud801\udd6e"
        + "\ud801\udd70\ud801\uddff"
        + "\ud801\udf37\ud801\udf3f"
        + "\ud801\udf56\ud801\udf5f"
        + "\ud801\udf68\ud801\udfff"
        + "\ud802\udc06\ud802\udc07"
        + "\ud802\udc09\ud802\udc09"
        + "\ud802\udc36\ud802\udc36"
        + "\ud802\udc39\ud802\udc3b"
        + "\ud802\udc3d\ud802\udc3e"
        + "\ud802\udc56\ud802\udc56"
        + "\ud802\udc9f\ud802\udca6"
        + "\ud802\udcb0\ud802\udcff"
        + "\ud802\udd1c\ud802\udd1e"
        + "\ud802\udd3a\ud802\udd3e"
        + "\ud802\udd40\ud802\udd7f"
        + "\ud802\uddb8\ud802\uddbd"
        + "\ud802\uddc0\ud802\uddff"
        + "\ud802\ude04\ud802\ude04"
        + "\ud802\ude07\ud802\ude0b"
        + "\ud802\ude14\ud802\ude14"
        + "\ud802\ude18\ud802\ude18"
        + "\ud802\ude34\ud802\ude37"
        + "\ud802\ude3b\ud802\ude3e"
        + "\ud802\ude48\ud802\ude4f"
        + "\ud802\ude59\ud802\ude5f"
        + "\ud802\udea0\ud802\udebf"
        + "\ud802\udee7\ud802\udeea"
        + "\ud802\udef7\ud802\udeff"
        + "\ud802\udf36\ud802\udf38"
        + "\ud802\udf56\ud802\udf57"
        + "\ud802\udf73\ud802\udf77"
        + "\ud802\udf92\ud802\udf98"
        + "\ud802\udf9d\ud802\udfa8"
        + "\ud802\udfb0\ud802\udfff"
        + "\ud803\udc49\ud803\ude5f"
        + "\ud803\ude7f\ud803\udfff"
        + "\ud804\udc4e\ud804\udc51"
        + "\ud804\udc70\ud804\udc7e"
        + "\ud804\udcc2\ud804\udccf"
        + "\ud804\udce9\ud804\udcef"
        + "\ud804\udcfa\ud804\udcff"
        + "\ud804\udd35\ud804\udd35"
        + "\ud804\udd44\ud804\udd4f"
        + "\ud804\udd77\ud804\udd7f"
        + "\ud804\uddc9\ud804\uddcc"
        + "\ud804\uddce\ud804\uddcf"
        + "\ud804\udddb\ud804\udde0"
        + "\ud804\uddf5\ud804\uddff"
        + "\ud804\ude12\ud804\ude12"
        + "\ud804\ude3e\ud804\udeaf"
        + "\ud804\udeeb\ud804\udeef"
        + "\ud804\udefa\ud804\udf00"
        + "\ud804\udf04\ud804\udf04"
        + "\ud804\udf0d\ud804\udf0e"
        + "\ud804\udf11\ud804\udf12"
        + "\ud804\udf29\ud804\udf29"
        + "\ud804\udf31\ud804\udf31"
        + "\ud804\udf34\ud804\udf34"
        + "\ud804\udf3a\ud804\udf3b"
        + "\ud804\udf45\ud804\udf46"
        + "\ud804\udf49\ud804\udf4a"
        + "\ud804\udf4e\ud804\udf56"
        + "\ud804\udf58\ud804\udf5c"
        + "\ud804\udf64\ud804\udf65"
        + "\ud804\udf6d\ud804\udf6f"
        + "\ud804\udf75\ud805\udc7f"
        + "\ud805\udcc8\ud805\udccf"
        + "\ud805\udcda\ud805\udd7f"
        + "\ud805\uddb6\ud805\uddb7"
        + "\ud805\uddca\ud805\uddff"
        + "\ud805\ude45\ud805\ude4f"
        + "\ud805\ude5a\ud805\ude7f"
        + "\ud805\udeb8\ud805\udebf"
        + "\ud805\udeca\ud806\udc9f"
        + "\ud806\udcf3\ud806\udcfe"
        + "\ud806\udd00\ud806\udebf"
        + "\ud806\udef9\ud807\udfff"
        + "\ud808\udf99\ud808\udfff"
        + "\ud809\udc6f\ud809\udc6f"
        + "\ud809\udc75\ud80b\udfff"
        + "\ud80d\udc2f\ud819\udfff"
        + "\ud81a\ude39\ud81a\ude3f"
        + "\ud81a\ude5f\ud81a\ude5f"
        + "\ud81a\ude6a\ud81a\ude6d"
        + "\ud81a\ude70\ud81a\udecf"
        + "\ud81a\udeee\ud81a\udeef"
        + "\ud81a\udef6\ud81a\udeff"
        + "\ud81a\udf46\ud81a\udf4f"
        + "\ud81a\udf5a\ud81a\udf5a"
        + "\ud81a\udf62\ud81a\udf62"
        + "\ud81a\udf78\ud81a\udf7c"
        + "\ud81a\udf90\ud81b\udeff"
        + "\ud81b\udf45\ud81b\udf4f"
        + "\ud81b\udf7f\ud81b\udf8e"
        + "\ud81b\udfa0\ud82b\udfff"
        + "\ud82c\udc02\ud82e\udfff"
        + "\ud82f\udc6b\ud82f\udc6f"
        + "\ud82f\udc7d\ud82f\udc7f"
        + "\ud82f\udc89\ud82f\udc8f"
        + "\ud82f\udc9a\ud82f\udc9b"
        + "\ud82f\udca4\ud833\udfff"
        + "\ud834\udcf6\ud834\udcff"
        + "\ud834\udd27\ud834\udd28"
        + "\ud834\uddde\ud834\uddff"
        + "\ud834\ude46\ud834\udeff"
        + "\ud834\udf57\ud834\udf5f"
        + "\ud834\udf72\ud834\udfff"
        + "\ud835\udc55\ud835\udc55"
        + "\ud835\udc9d\ud835\udc9d"
        + "\ud835\udca0\ud835\udca1"
        + "\ud835\udca3\ud835\udca4"
        + "\ud835\udca7\ud835\udca8"
        + "\ud835\udcad\ud835\udcad"
        + "\ud835\udcba\ud835\udcba"
        + "\ud835\udcbc\ud835\udcbc"
        + "\ud835\udcc4\ud835\udcc4"
        + "\ud835\udd06\ud835\udd06"
        + "\ud835\udd0b\ud835\udd0c"
        + "\ud835\udd15\ud835\udd15"
        + "\ud835\udd1d\ud835\udd1d"
        + "\ud835\udd3a\ud835\udd3a"
        + "\ud835\udd3f\ud835\udd3f"
        + "\ud835\udd45\ud835\udd45"
        + "\ud835\udd47\ud835\udd49"
        + "\ud835\udd51\ud835\udd51"
        + "\ud835\udea6\ud835\udea7"
        + "\ud835\udfcc\ud835\udfcd"
        + "\ud836\udc00\ud839\udfff"
        + "\ud83a\udcc5\ud83a\udcc6"
        + "\ud83a\udcd7\ud83b\uddff"
        + "\ud83b\ude04\ud83b\ude04"
        + "\ud83b\ude20\ud83b\ude20"
        + "\ud83b\ude23\ud83b\ude23"
        + "\ud83b\ude25\ud83b\ude26"
        + "\ud83b\ude28\ud83b\ude28"
        + "\ud83b\ude33\ud83b\ude33"
        + "\ud83b\ude38\ud83b\ude38"
        + "\ud83b\ude3a\ud83b\ude3a"
        + "\ud83b\ude3c\ud83b\ude41"
        + "\ud83b\ude43\ud83b\ude46"
        + "\ud83b\ude48\ud83b\ude48"
        + "\ud83b\ude4a\ud83b\ude4a"
        + "\ud83b\ude4c\ud83b\ude4c"
        + "\ud83b\ude50\ud83b\ude50"
        + "\ud83b\ude53\ud83b\ude53"
        + "\ud83b\ude55\ud83b\ude56"
        + "\ud83b\ude58\ud83b\ude58"
        + "\ud83b\ude5a\ud83b\ude5a"
        + "\ud83b\ude5c\ud83b\ude5c"
        + "\ud83b\ude5e\ud83b\ude5e"
        + "\ud83b\ude60\ud83b\ude60"
        + "\ud83b\ude63\ud83b\ude63"
        + "\ud83b\ude65\ud83b\ude66"
        + "\ud83b\ude6b\ud83b\ude6b"
        + "\ud83b\ude73\ud83b\ude73"
        + "\ud83b\ude78\ud83b\ude78"
        + "\ud83b\ude7d\ud83b\ude7d"
        + "\ud83b\ude7f\ud83b\ude7f"
        + "\ud83b\ude8a\ud83b\ude8a"
        + "\ud83b\ude9c\ud83b\udea0"
        + "\ud83b\udea4\ud83b\udea4"
        + "\ud83b\udeaa\ud83b\udeaa"
        + "\ud83b\udebc\ud83b\udeef"
        + "\ud83b\udef2\ud83b\udfff"
        + "\ud83c\udc2c\ud83c\udc2f"
        + "\ud83c\udc94\ud83c\udc9f"
        + "\ud83c\udcaf\ud83c\udcb0"
        + "\ud83c\udcc0\ud83c\udcc0"
        + "\ud83c\udcd0\ud83c\udcd0"
        + "\ud83c\udcf6\ud83c\udcff"
        + "\ud83c\udd0d\ud83c\udd0f"
        + "\ud83c\udd2f\ud83c\udd2f"
        + "\ud83c\udd6c\ud83c\udd6f"
        + "\ud83c\udd9b\ud83c\udde5"
        + "\ud83c\ude03\ud83c\ude0f"
        + "\ud83c\ude3b\ud83c\ude3f"
        + "\ud83c\ude49\ud83c\ude4f"
        + "\ud83c\ude52\ud83c\udeff"
        + "\ud83c\udf2d\ud83c\udf2f"
        + "\ud83c\udf7e\ud83c\udf7f"
        + "\ud83c\udfcf\ud83c\udfd3"
        + "\ud83c\udff8\ud83c\udfff"
        + "\ud83d\udcff\ud83d\udcff"
        + "\ud83d\udd4b\ud83d\udd4f"
        + "\ud83d\udd7a\ud83d\udd7a"
        + "\ud83d\udda4\ud83d\udda4"
        + "\ud83d\ude43\ud83d\ude44"
        + "\ud83d\uded0\ud83d\udedf"
        + "\ud83d\udeed\ud83d\udeef"
        + "\ud83d\udef4\ud83d\udeff"
        + "\ud83d\udf74\ud83d\udf7f"
        + "\ud83d\udfd5\ud83d\udfff"
        + "\ud83e\udc0c\ud83e\udc0f"
        + "\ud83e\udc48\ud83e\udc4f"
        + "\ud83e\udc5a\ud83e\udc5f"
        + "\ud83e\udc88\ud83e\udc8f"
        + "\ud83e\udcae\ud83f\udfff"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\udb40\udc00"
        + "\udb40\udc02\udb40\udc1f"
        + "\udb40\udc80\udb40\udcff"
        + "\udb40\uddf0\udbff\udfff",
    // Unicode 7.0 property value: {linebreak=wordjoiner}
    "\u2060\u2060" + "\ufeff\ufeff",
    // Unicode 7.0 property value: {linebreak=zwspace}
    "\u200b\u200b",
    // Unicode 7.0 property value: {lisu}
    "\ua4d0\ua4ff",
    // Unicode 7.0 property value: {ll}
    "\u0061\u007a"
        + "\u00b5\u00b5"
        + "\u00df\u00f6"
        + "\u00f8\u00ff"
        + "\u0101\u0101"
        + "\u0103\u0103"
        + "\u0105\u0105"
        + "\u0107\u0107"
        + "\u0109\u0109"
        + "\u010b\u010b"
        + "\u010d\u010d"
        + "\u010f\u010f"
        + "\u0111\u0111"
        + "\u0113\u0113"
        + "\u0115\u0115"
        + "\u0117\u0117"
        + "\u0119\u0119"
        + "\u011b\u011b"
        + "\u011d\u011d"
        + "\u011f\u011f"
        + "\u0121\u0121"
        + "\u0123\u0123"
        + "\u0125\u0125"
        + "\u0127\u0127"
        + "\u0129\u0129"
        + "\u012b\u012b"
        + "\u012d\u012d"
        + "\u012f\u012f"
        + "\u0131\u0131"
        + "\u0133\u0133"
        + "\u0135\u0135"
        + "\u0137\u0138"
        + "\u013a\u013a"
        + "\u013c\u013c"
        + "\u013e\u013e"
        + "\u0140\u0140"
        + "\u0142\u0142"
        + "\u0144\u0144"
        + "\u0146\u0146"
        + "\u0148\u0149"
        + "\u014b\u014b"
        + "\u014d\u014d"
        + "\u014f\u014f"
        + "\u0151\u0151"
        + "\u0153\u0153"
        + "\u0155\u0155"
        + "\u0157\u0157"
        + "\u0159\u0159"
        + "\u015b\u015b"
        + "\u015d\u015d"
        + "\u015f\u015f"
        + "\u0161\u0161"
        + "\u0163\u0163"
        + "\u0165\u0165"
        + "\u0167\u0167"
        + "\u0169\u0169"
        + "\u016b\u016b"
        + "\u016d\u016d"
        + "\u016f\u016f"
        + "\u0171\u0171"
        + "\u0173\u0173"
        + "\u0175\u0175"
        + "\u0177\u0177"
        + "\u017a\u017a"
        + "\u017c\u017c"
        + "\u017e\u0180"
        + "\u0183\u0183"
        + "\u0185\u0185"
        + "\u0188\u0188"
        + "\u018c\u018d"
        + "\u0192\u0192"
        + "\u0195\u0195"
        + "\u0199\u019b"
        + "\u019e\u019e"
        + "\u01a1\u01a1"
        + "\u01a3\u01a3"
        + "\u01a5\u01a5"
        + "\u01a8\u01a8"
        + "\u01aa\u01ab"
        + "\u01ad\u01ad"
        + "\u01b0\u01b0"
        + "\u01b4\u01b4"
        + "\u01b6\u01b6"
        + "\u01b9\u01ba"
        + "\u01bd\u01bf"
        + "\u01c6\u01c6"
        + "\u01c9\u01c9"
        + "\u01cc\u01cc"
        + "\u01ce\u01ce"
        + "\u01d0\u01d0"
        + "\u01d2\u01d2"
        + "\u01d4\u01d4"
        + "\u01d6\u01d6"
        + "\u01d8\u01d8"
        + "\u01da\u01da"
        + "\u01dc\u01dd"
        + "\u01df\u01df"
        + "\u01e1\u01e1"
        + "\u01e3\u01e3"
        + "\u01e5\u01e5"
        + "\u01e7\u01e7"
        + "\u01e9\u01e9"
        + "\u01eb\u01eb"
        + "\u01ed\u01ed"
        + "\u01ef\u01f0"
        + "\u01f3\u01f3"
        + "\u01f5\u01f5"
        + "\u01f9\u01f9"
        + "\u01fb\u01fb"
        + "\u01fd\u01fd"
        + "\u01ff\u01ff"
        + "\u0201\u0201"
        + "\u0203\u0203"
        + "\u0205\u0205"
        + "\u0207\u0207"
        + "\u0209\u0209"
        + "\u020b\u020b"
        + "\u020d\u020d"
        + "\u020f\u020f"
        + "\u0211\u0211"
        + "\u0213\u0213"
        + "\u0215\u0215"
        + "\u0217\u0217"
        + "\u0219\u0219"
        + "\u021b\u021b"
        + "\u021d\u021d"
        + "\u021f\u021f"
        + "\u0221\u0221"
        + "\u0223\u0223"
        + "\u0225\u0225"
        + "\u0227\u0227"
        + "\u0229\u0229"
        + "\u022b\u022b"
        + "\u022d\u022d"
        + "\u022f\u022f"
        + "\u0231\u0231"
        + "\u0233\u0239"
        + "\u023c\u023c"
        + "\u023f\u0240"
        + "\u0242\u0242"
        + "\u0247\u0247"
        + "\u0249\u0249"
        + "\u024b\u024b"
        + "\u024d\u024d"
        + "\u024f\u0293"
        + "\u0295\u02af"
        + "\u0371\u0371"
        + "\u0373\u0373"
        + "\u0377\u0377"
        + "\u037b\u037d"
        + "\u0390\u0390"
        + "\u03ac\u03ce"
        + "\u03d0\u03d1"
        + "\u03d5\u03d7"
        + "\u03d9\u03d9"
        + "\u03db\u03db"
        + "\u03dd\u03dd"
        + "\u03df\u03df"
        + "\u03e1\u03e1"
        + "\u03e3\u03e3"
        + "\u03e5\u03e5"
        + "\u03e7\u03e7"
        + "\u03e9\u03e9"
        + "\u03eb\u03eb"
        + "\u03ed\u03ed"
        + "\u03ef\u03f3"
        + "\u03f5\u03f5"
        + "\u03f8\u03f8"
        + "\u03fb\u03fc"
        + "\u0430\u045f"
        + "\u0461\u0461"
        + "\u0463\u0463"
        + "\u0465\u0465"
        + "\u0467\u0467"
        + "\u0469\u0469"
        + "\u046b\u046b"
        + "\u046d\u046d"
        + "\u046f\u046f"
        + "\u0471\u0471"
        + "\u0473\u0473"
        + "\u0475\u0475"
        + "\u0477\u0477"
        + "\u0479\u0479"
        + "\u047b\u047b"
        + "\u047d\u047d"
        + "\u047f\u047f"
        + "\u0481\u0481"
        + "\u048b\u048b"
        + "\u048d\u048d"
        + "\u048f\u048f"
        + "\u0491\u0491"
        + "\u0493\u0493"
        + "\u0495\u0495"
        + "\u0497\u0497"
        + "\u0499\u0499"
        + "\u049b\u049b"
        + "\u049d\u049d"
        + "\u049f\u049f"
        + "\u04a1\u04a1"
        + "\u04a3\u04a3"
        + "\u04a5\u04a5"
        + "\u04a7\u04a7"
        + "\u04a9\u04a9"
        + "\u04ab\u04ab"
        + "\u04ad\u04ad"
        + "\u04af\u04af"
        + "\u04b1\u04b1"
        + "\u04b3\u04b3"
        + "\u04b5\u04b5"
        + "\u04b7\u04b7"
        + "\u04b9\u04b9"
        + "\u04bb\u04bb"
        + "\u04bd\u04bd"
        + "\u04bf\u04bf"
        + "\u04c2\u04c2"
        + "\u04c4\u04c4"
        + "\u04c6\u04c6"
        + "\u04c8\u04c8"
        + "\u04ca\u04ca"
        + "\u04cc\u04cc"
        + "\u04ce\u04cf"
        + "\u04d1\u04d1"
        + "\u04d3\u04d3"
        + "\u04d5\u04d5"
        + "\u04d7\u04d7"
        + "\u04d9\u04d9"
        + "\u04db\u04db"
        + "\u04dd\u04dd"
        + "\u04df\u04df"
        + "\u04e1\u04e1"
        + "\u04e3\u04e3"
        + "\u04e5\u04e5"
        + "\u04e7\u04e7"
        + "\u04e9\u04e9"
        + "\u04eb\u04eb"
        + "\u04ed\u04ed"
        + "\u04ef\u04ef"
        + "\u04f1\u04f1"
        + "\u04f3\u04f3"
        + "\u04f5\u04f5"
        + "\u04f7\u04f7"
        + "\u04f9\u04f9"
        + "\u04fb\u04fb"
        + "\u04fd\u04fd"
        + "\u04ff\u04ff"
        + "\u0501\u0501"
        + "\u0503\u0503"
        + "\u0505\u0505"
        + "\u0507\u0507"
        + "\u0509\u0509"
        + "\u050b\u050b"
        + "\u050d\u050d"
        + "\u050f\u050f"
        + "\u0511\u0511"
        + "\u0513\u0513"
        + "\u0515\u0515"
        + "\u0517\u0517"
        + "\u0519\u0519"
        + "\u051b\u051b"
        + "\u051d\u051d"
        + "\u051f\u051f"
        + "\u0521\u0521"
        + "\u0523\u0523"
        + "\u0525\u0525"
        + "\u0527\u0527"
        + "\u0529\u0529"
        + "\u052b\u052b"
        + "\u052d\u052d"
        + "\u052f\u052f"
        + "\u0561\u0587"
        + "\u1d00\u1d2b"
        + "\u1d6b\u1d77"
        + "\u1d79\u1d9a"
        + "\u1e01\u1e01"
        + "\u1e03\u1e03"
        + "\u1e05\u1e05"
        + "\u1e07\u1e07"
        + "\u1e09\u1e09"
        + "\u1e0b\u1e0b"
        + "\u1e0d\u1e0d"
        + "\u1e0f\u1e0f"
        + "\u1e11\u1e11"
        + "\u1e13\u1e13"
        + "\u1e15\u1e15"
        + "\u1e17\u1e17"
        + "\u1e19\u1e19"
        + "\u1e1b\u1e1b"
        + "\u1e1d\u1e1d"
        + "\u1e1f\u1e1f"
        + "\u1e21\u1e21"
        + "\u1e23\u1e23"
        + "\u1e25\u1e25"
        + "\u1e27\u1e27"
        + "\u1e29\u1e29"
        + "\u1e2b\u1e2b"
        + "\u1e2d\u1e2d"
        + "\u1e2f\u1e2f"
        + "\u1e31\u1e31"
        + "\u1e33\u1e33"
        + "\u1e35\u1e35"
        + "\u1e37\u1e37"
        + "\u1e39\u1e39"
        + "\u1e3b\u1e3b"
        + "\u1e3d\u1e3d"
        + "\u1e3f\u1e3f"
        + "\u1e41\u1e41"
        + "\u1e43\u1e43"
        + "\u1e45\u1e45"
        + "\u1e47\u1e47"
        + "\u1e49\u1e49"
        + "\u1e4b\u1e4b"
        + "\u1e4d\u1e4d"
        + "\u1e4f\u1e4f"
        + "\u1e51\u1e51"
        + "\u1e53\u1e53"
        + "\u1e55\u1e55"
        + "\u1e57\u1e57"
        + "\u1e59\u1e59"
        + "\u1e5b\u1e5b"
        + "\u1e5d\u1e5d"
        + "\u1e5f\u1e5f"
        + "\u1e61\u1e61"
        + "\u1e63\u1e63"
        + "\u1e65\u1e65"
        + "\u1e67\u1e67"
        + "\u1e69\u1e69"
        + "\u1e6b\u1e6b"
        + "\u1e6d\u1e6d"
        + "\u1e6f\u1e6f"
        + "\u1e71\u1e71"
        + "\u1e73\u1e73"
        + "\u1e75\u1e75"
        + "\u1e77\u1e77"
        + "\u1e79\u1e79"
        + "\u1e7b\u1e7b"
        + "\u1e7d\u1e7d"
        + "\u1e7f\u1e7f"
        + "\u1e81\u1e81"
        + "\u1e83\u1e83"
        + "\u1e85\u1e85"
        + "\u1e87\u1e87"
        + "\u1e89\u1e89"
        + "\u1e8b\u1e8b"
        + "\u1e8d\u1e8d"
        + "\u1e8f\u1e8f"
        + "\u1e91\u1e91"
        + "\u1e93\u1e93"
        + "\u1e95\u1e9d"
        + "\u1e9f\u1e9f"
        + "\u1ea1\u1ea1"
        + "\u1ea3\u1ea3"
        + "\u1ea5\u1ea5"
        + "\u1ea7\u1ea7"
        + "\u1ea9\u1ea9"
        + "\u1eab\u1eab"
        + "\u1ead\u1ead"
        + "\u1eaf\u1eaf"
        + "\u1eb1\u1eb1"
        + "\u1eb3\u1eb3"
        + "\u1eb5\u1eb5"
        + "\u1eb7\u1eb7"
        + "\u1eb9\u1eb9"
        + "\u1ebb\u1ebb"
        + "\u1ebd\u1ebd"
        + "\u1ebf\u1ebf"
        + "\u1ec1\u1ec1"
        + "\u1ec3\u1ec3"
        + "\u1ec5\u1ec5"
        + "\u1ec7\u1ec7"
        + "\u1ec9\u1ec9"
        + "\u1ecb\u1ecb"
        + "\u1ecd\u1ecd"
        + "\u1ecf\u1ecf"
        + "\u1ed1\u1ed1"
        + "\u1ed3\u1ed3"
        + "\u1ed5\u1ed5"
        + "\u1ed7\u1ed7"
        + "\u1ed9\u1ed9"
        + "\u1edb\u1edb"
        + "\u1edd\u1edd"
        + "\u1edf\u1edf"
        + "\u1ee1\u1ee1"
        + "\u1ee3\u1ee3"
        + "\u1ee5\u1ee5"
        + "\u1ee7\u1ee7"
        + "\u1ee9\u1ee9"
        + "\u1eeb\u1eeb"
        + "\u1eed\u1eed"
        + "\u1eef\u1eef"
        + "\u1ef1\u1ef1"
        + "\u1ef3\u1ef3"
        + "\u1ef5\u1ef5"
        + "\u1ef7\u1ef7"
        + "\u1ef9\u1ef9"
        + "\u1efb\u1efb"
        + "\u1efd\u1efd"
        + "\u1eff\u1f07"
        + "\u1f10\u1f15"
        + "\u1f20\u1f27"
        + "\u1f30\u1f37"
        + "\u1f40\u1f45"
        + "\u1f50\u1f57"
        + "\u1f60\u1f67"
        + "\u1f70\u1f7d"
        + "\u1f80\u1f87"
        + "\u1f90\u1f97"
        + "\u1fa0\u1fa7"
        + "\u1fb0\u1fb4"
        + "\u1fb6\u1fb7"
        + "\u1fbe\u1fbe"
        + "\u1fc2\u1fc4"
        + "\u1fc6\u1fc7"
        + "\u1fd0\u1fd3"
        + "\u1fd6\u1fd7"
        + "\u1fe0\u1fe7"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ff7"
        + "\u210a\u210a"
        + "\u210e\u210f"
        + "\u2113\u2113"
        + "\u212f\u212f"
        + "\u2134\u2134"
        + "\u2139\u2139"
        + "\u213c\u213d"
        + "\u2146\u2149"
        + "\u214e\u214e"
        + "\u2184\u2184"
        + "\u2c30\u2c5e"
        + "\u2c61\u2c61"
        + "\u2c65\u2c66"
        + "\u2c68\u2c68"
        + "\u2c6a\u2c6a"
        + "\u2c6c\u2c6c"
        + "\u2c71\u2c71"
        + "\u2c73\u2c74"
        + "\u2c76\u2c7b"
        + "\u2c81\u2c81"
        + "\u2c83\u2c83"
        + "\u2c85\u2c85"
        + "\u2c87\u2c87"
        + "\u2c89\u2c89"
        + "\u2c8b\u2c8b"
        + "\u2c8d\u2c8d"
        + "\u2c8f\u2c8f"
        + "\u2c91\u2c91"
        + "\u2c93\u2c93"
        + "\u2c95\u2c95"
        + "\u2c97\u2c97"
        + "\u2c99\u2c99"
        + "\u2c9b\u2c9b"
        + "\u2c9d\u2c9d"
        + "\u2c9f\u2c9f"
        + "\u2ca1\u2ca1"
        + "\u2ca3\u2ca3"
        + "\u2ca5\u2ca5"
        + "\u2ca7\u2ca7"
        + "\u2ca9\u2ca9"
        + "\u2cab\u2cab"
        + "\u2cad\u2cad"
        + "\u2caf\u2caf"
        + "\u2cb1\u2cb1"
        + "\u2cb3\u2cb3"
        + "\u2cb5\u2cb5"
        + "\u2cb7\u2cb7"
        + "\u2cb9\u2cb9"
        + "\u2cbb\u2cbb"
        + "\u2cbd\u2cbd"
        + "\u2cbf\u2cbf"
        + "\u2cc1\u2cc1"
        + "\u2cc3\u2cc3"
        + "\u2cc5\u2cc5"
        + "\u2cc7\u2cc7"
        + "\u2cc9\u2cc9"
        + "\u2ccb\u2ccb"
        + "\u2ccd\u2ccd"
        + "\u2ccf\u2ccf"
        + "\u2cd1\u2cd1"
        + "\u2cd3\u2cd3"
        + "\u2cd5\u2cd5"
        + "\u2cd7\u2cd7"
        + "\u2cd9\u2cd9"
        + "\u2cdb\u2cdb"
        + "\u2cdd\u2cdd"
        + "\u2cdf\u2cdf"
        + "\u2ce1\u2ce1"
        + "\u2ce3\u2ce4"
        + "\u2cec\u2cec"
        + "\u2cee\u2cee"
        + "\u2cf3\u2cf3"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\ua641\ua641"
        + "\ua643\ua643"
        + "\ua645\ua645"
        + "\ua647\ua647"
        + "\ua649\ua649"
        + "\ua64b\ua64b"
        + "\ua64d\ua64d"
        + "\ua64f\ua64f"
        + "\ua651\ua651"
        + "\ua653\ua653"
        + "\ua655\ua655"
        + "\ua657\ua657"
        + "\ua659\ua659"
        + "\ua65b\ua65b"
        + "\ua65d\ua65d"
        + "\ua65f\ua65f"
        + "\ua661\ua661"
        + "\ua663\ua663"
        + "\ua665\ua665"
        + "\ua667\ua667"
        + "\ua669\ua669"
        + "\ua66b\ua66b"
        + "\ua66d\ua66d"
        + "\ua681\ua681"
        + "\ua683\ua683"
        + "\ua685\ua685"
        + "\ua687\ua687"
        + "\ua689\ua689"
        + "\ua68b\ua68b"
        + "\ua68d\ua68d"
        + "\ua68f\ua68f"
        + "\ua691\ua691"
        + "\ua693\ua693"
        + "\ua695\ua695"
        + "\ua697\ua697"
        + "\ua699\ua699"
        + "\ua69b\ua69b"
        + "\ua723\ua723"
        + "\ua725\ua725"
        + "\ua727\ua727"
        + "\ua729\ua729"
        + "\ua72b\ua72b"
        + "\ua72d\ua72d"
        + "\ua72f\ua731"
        + "\ua733\ua733"
        + "\ua735\ua735"
        + "\ua737\ua737"
        + "\ua739\ua739"
        + "\ua73b\ua73b"
        + "\ua73d\ua73d"
        + "\ua73f\ua73f"
        + "\ua741\ua741"
        + "\ua743\ua743"
        + "\ua745\ua745"
        + "\ua747\ua747"
        + "\ua749\ua749"
        + "\ua74b\ua74b"
        + "\ua74d\ua74d"
        + "\ua74f\ua74f"
        + "\ua751\ua751"
        + "\ua753\ua753"
        + "\ua755\ua755"
        + "\ua757\ua757"
        + "\ua759\ua759"
        + "\ua75b\ua75b"
        + "\ua75d\ua75d"
        + "\ua75f\ua75f"
        + "\ua761\ua761"
        + "\ua763\ua763"
        + "\ua765\ua765"
        + "\ua767\ua767"
        + "\ua769\ua769"
        + "\ua76b\ua76b"
        + "\ua76d\ua76d"
        + "\ua76f\ua76f"
        + "\ua771\ua778"
        + "\ua77a\ua77a"
        + "\ua77c\ua77c"
        + "\ua77f\ua77f"
        + "\ua781\ua781"
        + "\ua783\ua783"
        + "\ua785\ua785"
        + "\ua787\ua787"
        + "\ua78c\ua78c"
        + "\ua78e\ua78e"
        + "\ua791\ua791"
        + "\ua793\ua795"
        + "\ua797\ua797"
        + "\ua799\ua799"
        + "\ua79b\ua79b"
        + "\ua79d\ua79d"
        + "\ua79f\ua79f"
        + "\ua7a1\ua7a1"
        + "\ua7a3\ua7a3"
        + "\ua7a5\ua7a5"
        + "\ua7a7\ua7a7"
        + "\ua7a9\ua7a9"
        + "\ua7fa\ua7fa"
        + "\uab30\uab5a"
        + "\uab64\uab65"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\uff41\uff5a"
        + "\ud801\udc28\ud801\udc4f"
        + "\ud806\udcc0\ud806\udcdf"
        + "\ud835\udc1a\ud835\udc33"
        + "\ud835\udc4e\ud835\udc54"
        + "\ud835\udc56\ud835\udc67"
        + "\ud835\udc82\ud835\udc9b"
        + "\ud835\udcb6\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udccf"
        + "\ud835\udcea\ud835\udd03"
        + "\ud835\udd1e\ud835\udd37"
        + "\ud835\udd52\ud835\udd6b"
        + "\ud835\udd86\ud835\udd9f"
        + "\ud835\uddba\ud835\uddd3"
        + "\ud835\uddee\ud835\ude07"
        + "\ud835\ude22\ud835\ude3b"
        + "\ud835\ude56\ud835\ude6f"
        + "\ud835\ude8a\ud835\udea5"
        + "\ud835\udec2\ud835\udeda"
        + "\ud835\udedc\ud835\udee1"
        + "\ud835\udefc\ud835\udf14"
        + "\ud835\udf16\ud835\udf1b"
        + "\ud835\udf36\ud835\udf4e"
        + "\ud835\udf50\ud835\udf55"
        + "\ud835\udf70\ud835\udf88"
        + "\ud835\udf8a\ud835\udf8f"
        + "\ud835\udfaa\ud835\udfc2"
        + "\ud835\udfc4\ud835\udfc9"
        + "\ud835\udfcb\ud835\udfcb",
    // Unicode 7.0 property value: {lm}
    "\u02b0\u02c1"
        + "\u02c6\u02d1"
        + "\u02e0\u02e4"
        + "\u02ec\u02ec"
        + "\u02ee\u02ee"
        + "\u0374\u0374"
        + "\u037a\u037a"
        + "\u0559\u0559"
        + "\u0640\u0640"
        + "\u06e5\u06e6"
        + "\u07f4\u07f5"
        + "\u07fa\u07fa"
        + "\u081a\u081a"
        + "\u0824\u0824"
        + "\u0828\u0828"
        + "\u0971\u0971"
        + "\u0e46\u0e46"
        + "\u0ec6\u0ec6"
        + "\u10fc\u10fc"
        + "\u17d7\u17d7"
        + "\u1843\u1843"
        + "\u1aa7\u1aa7"
        + "\u1c78\u1c7d"
        + "\u1d2c\u1d6a"
        + "\u1d78\u1d78"
        + "\u1d9b\u1dbf"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u2c7c\u2c7d"
        + "\u2d6f\u2d6f"
        + "\u2e2f\u2e2f"
        + "\u3005\u3005"
        + "\u3031\u3035"
        + "\u303b\u303b"
        + "\u309d\u309e"
        + "\u30fc\u30fe"
        + "\ua015\ua015"
        + "\ua4f8\ua4fd"
        + "\ua60c\ua60c"
        + "\ua67f\ua67f"
        + "\ua69c\ua69d"
        + "\ua717\ua71f"
        + "\ua770\ua770"
        + "\ua788\ua788"
        + "\ua7f8\ua7f9"
        + "\ua9cf\ua9cf"
        + "\ua9e6\ua9e6"
        + "\uaa70\uaa70"
        + "\uaadd\uaadd"
        + "\uaaf3\uaaf4"
        + "\uab5c\uab5f"
        + "\uff70\uff70"
        + "\uff9e\uff9f"
        + "\ud81a\udf40\ud81a\udf43"
        + "\ud81b\udf93\ud81b\udf9f",
    // Unicode 7.0 property value: {lo}
    "\u00aa\u00aa"
        + "\u00ba\u00ba"
        + "\u01bb\u01bb"
        + "\u01c0\u01c3"
        + "\u0294\u0294"
        + "\u05d0\u05ea"
        + "\u05f0\u05f2"
        + "\u0620\u063f"
        + "\u0641\u064a"
        + "\u066e\u066f"
        + "\u0671\u06d3"
        + "\u06d5\u06d5"
        + "\u06ee\u06ef"
        + "\u06fa\u06fc"
        + "\u06ff\u06ff"
        + "\u0710\u0710"
        + "\u0712\u072f"
        + "\u074d\u07a5"
        + "\u07b1\u07b1"
        + "\u07ca\u07ea"
        + "\u0800\u0815"
        + "\u0840\u0858"
        + "\u08a0\u08b2"
        + "\u0904\u0939"
        + "\u093d\u093d"
        + "\u0950\u0950"
        + "\u0958\u0961"
        + "\u0972\u0980"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bd\u09bd"
        + "\u09ce\u09ce"
        + "\u09dc\u09dd"
        + "\u09df\u09e1"
        + "\u09f0\u09f1"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a72\u0a74"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abd\u0abd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae1"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3d\u0b3d"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b71\u0b71"
        + "\u0b83\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bd0\u0bd0"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c3d"
        + "\u0c58\u0c59"
        + "\u0c60\u0c61"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbd\u0cbd"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0cf1\u0cf2"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d3d"
        + "\u0d4e\u0d4e"
        + "\u0d60\u0d61"
        + "\u0d7a\u0d7f"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0e01\u0e30"
        + "\u0e32\u0e33"
        + "\u0e40\u0e45"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb0"
        + "\u0eb2\u0eb3"
        + "\u0ebd\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0edc\u0edf"
        + "\u0f00\u0f00"
        + "\u0f40\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f88\u0f8c"
        + "\u1000\u102a"
        + "\u103f\u103f"
        + "\u1050\u1055"
        + "\u105a\u105d"
        + "\u1061\u1061"
        + "\u1065\u1066"
        + "\u106e\u1070"
        + "\u1075\u1081"
        + "\u108e\u108e"
        + "\u10d0\u10fa"
        + "\u10fd\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u1380\u138f"
        + "\u13a0\u13f4"
        + "\u1401\u166c"
        + "\u166f\u167f"
        + "\u1681\u169a"
        + "\u16a0\u16ea"
        + "\u16f1\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1711"
        + "\u1720\u1731"
        + "\u1740\u1751"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1780\u17b3"
        + "\u17dc\u17dc"
        + "\u1820\u1842"
        + "\u1844\u1877"
        + "\u1880\u18a8"
        + "\u18aa\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1950\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19c1\u19c7"
        + "\u1a00\u1a16"
        + "\u1a20\u1a54"
        + "\u1b05\u1b33"
        + "\u1b45\u1b4b"
        + "\u1b83\u1ba0"
        + "\u1bae\u1baf"
        + "\u1bba\u1be5"
        + "\u1c00\u1c23"
        + "\u1c4d\u1c4f"
        + "\u1c5a\u1c77"
        + "\u1ce9\u1cec"
        + "\u1cee\u1cf1"
        + "\u1cf5\u1cf6"
        + "\u2135\u2138"
        + "\u2d30\u2d67"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u3006\u3006"
        + "\u303c\u303c"
        + "\u3041\u3096"
        + "\u309f\u309f"
        + "\u30a1\u30fa"
        + "\u30ff\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u31a0\u31ba"
        + "\u31f0\u31ff"
        + "\u3400\u4db5"
        + "\u4e00\u9fcc"
        + "\ua000\ua014"
        + "\ua016\ua48c"
        + "\ua4d0\ua4f7"
        + "\ua500\ua60b"
        + "\ua610\ua61f"
        + "\ua62a\ua62b"
        + "\ua66e\ua66e"
        + "\ua6a0\ua6e5"
        + "\ua7f7\ua7f7"
        + "\ua7fb\ua801"
        + "\ua803\ua805"
        + "\ua807\ua80a"
        + "\ua80c\ua822"
        + "\ua840\ua873"
        + "\ua882\ua8b3"
        + "\ua8f2\ua8f7"
        + "\ua8fb\ua8fb"
        + "\ua90a\ua925"
        + "\ua930\ua946"
        + "\ua960\ua97c"
        + "\ua984\ua9b2"
        + "\ua9e0\ua9e4"
        + "\ua9e7\ua9ef"
        + "\ua9fa\ua9fe"
        + "\uaa00\uaa28"
        + "\uaa40\uaa42"
        + "\uaa44\uaa4b"
        + "\uaa60\uaa6f"
        + "\uaa71\uaa76"
        + "\uaa7a\uaa7a"
        + "\uaa7e\uaaaf"
        + "\uaab1\uaab1"
        + "\uaab5\uaab6"
        + "\uaab9\uaabd"
        + "\uaac0\uaac0"
        + "\uaac2\uaac2"
        + "\uaadb\uaadc"
        + "\uaae0\uaaea"
        + "\uaaf2\uaaf2"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uabc0\uabe2"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\uf900\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb1d\ufb1d"
        + "\ufb1f\ufb28"
        + "\ufb2a\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3d"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfb"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\uff66\uff6f"
        + "\uff71\uff9d"
        + "\uffa0\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udf00\ud800\udf1f"
        + "\ud800\udf30\ud800\udf40"
        + "\ud800\udf42\ud800\udf49"
        + "\ud800\udf50\ud800\udf75"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udfa0\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfcf"
        + "\ud801\udc50\ud801\udc9d"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc60\ud802\udc76"
        + "\ud802\udc80\ud802\udc9e"
        + "\ud802\udd00\ud802\udd15"
        + "\ud802\udd20\ud802\udd39"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude00"
        + "\ud802\ude10\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude60\ud802\ude7c"
        + "\ud802\ude80\ud802\ude9c"
        + "\ud802\udec0\ud802\udec7"
        + "\ud802\udec9\ud802\udee4"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf40\ud802\udf55"
        + "\ud802\udf60\ud802\udf72"
        + "\ud802\udf80\ud802\udf91"
        + "\ud803\udc00\ud803\udc48"
        + "\ud804\udc03\ud804\udc37"
        + "\ud804\udc83\ud804\udcaf"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udd03\ud804\udd26"
        + "\ud804\udd50\ud804\udd72"
        + "\ud804\udd76\ud804\udd76"
        + "\ud804\udd83\ud804\uddb2"
        + "\ud804\uddc1\ud804\uddc4"
        + "\ud804\uddda\ud804\uddda"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude2b"
        + "\ud804\udeb0\ud804\udede"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3d\ud804\udf3d"
        + "\ud804\udf5d\ud804\udf61"
        + "\ud805\udc80\ud805\udcaf"
        + "\ud805\udcc4\ud805\udcc5"
        + "\ud805\udcc7\ud805\udcc7"
        + "\ud805\udd80\ud805\uddae"
        + "\ud805\ude00\ud805\ude2f"
        + "\ud805\ude44\ud805\ude44"
        + "\ud805\ude80\ud805\udeaa"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udf00\ud81a\udf2f"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf50"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d",
    // Unicode 7.0 property value: {logicalorderexception}
    "\u0e40\u0e44" + "\u0ec0\u0ec4" + "\uaab5\uaab6" + "\uaab9\uaab9" + "\uaabb\uaabc",
    // Unicode 7.0 property value: {lowercase}
    "\u0061\u007a"
        + "\u00aa\u00aa"
        + "\u00b5\u00b5"
        + "\u00ba\u00ba"
        + "\u00df\u00f6"
        + "\u00f8\u00ff"
        + "\u0101\u0101"
        + "\u0103\u0103"
        + "\u0105\u0105"
        + "\u0107\u0107"
        + "\u0109\u0109"
        + "\u010b\u010b"
        + "\u010d\u010d"
        + "\u010f\u010f"
        + "\u0111\u0111"
        + "\u0113\u0113"
        + "\u0115\u0115"
        + "\u0117\u0117"
        + "\u0119\u0119"
        + "\u011b\u011b"
        + "\u011d\u011d"
        + "\u011f\u011f"
        + "\u0121\u0121"
        + "\u0123\u0123"
        + "\u0125\u0125"
        + "\u0127\u0127"
        + "\u0129\u0129"
        + "\u012b\u012b"
        + "\u012d\u012d"
        + "\u012f\u012f"
        + "\u0131\u0131"
        + "\u0133\u0133"
        + "\u0135\u0135"
        + "\u0137\u0138"
        + "\u013a\u013a"
        + "\u013c\u013c"
        + "\u013e\u013e"
        + "\u0140\u0140"
        + "\u0142\u0142"
        + "\u0144\u0144"
        + "\u0146\u0146"
        + "\u0148\u0149"
        + "\u014b\u014b"
        + "\u014d\u014d"
        + "\u014f\u014f"
        + "\u0151\u0151"
        + "\u0153\u0153"
        + "\u0155\u0155"
        + "\u0157\u0157"
        + "\u0159\u0159"
        + "\u015b\u015b"
        + "\u015d\u015d"
        + "\u015f\u015f"
        + "\u0161\u0161"
        + "\u0163\u0163"
        + "\u0165\u0165"
        + "\u0167\u0167"
        + "\u0169\u0169"
        + "\u016b\u016b"
        + "\u016d\u016d"
        + "\u016f\u016f"
        + "\u0171\u0171"
        + "\u0173\u0173"
        + "\u0175\u0175"
        + "\u0177\u0177"
        + "\u017a\u017a"
        + "\u017c\u017c"
        + "\u017e\u0180"
        + "\u0183\u0183"
        + "\u0185\u0185"
        + "\u0188\u0188"
        + "\u018c\u018d"
        + "\u0192\u0192"
        + "\u0195\u0195"
        + "\u0199\u019b"
        + "\u019e\u019e"
        + "\u01a1\u01a1"
        + "\u01a3\u01a3"
        + "\u01a5\u01a5"
        + "\u01a8\u01a8"
        + "\u01aa\u01ab"
        + "\u01ad\u01ad"
        + "\u01b0\u01b0"
        + "\u01b4\u01b4"
        + "\u01b6\u01b6"
        + "\u01b9\u01ba"
        + "\u01bd\u01bf"
        + "\u01c6\u01c6"
        + "\u01c9\u01c9"
        + "\u01cc\u01cc"
        + "\u01ce\u01ce"
        + "\u01d0\u01d0"
        + "\u01d2\u01d2"
        + "\u01d4\u01d4"
        + "\u01d6\u01d6"
        + "\u01d8\u01d8"
        + "\u01da\u01da"
        + "\u01dc\u01dd"
        + "\u01df\u01df"
        + "\u01e1\u01e1"
        + "\u01e3\u01e3"
        + "\u01e5\u01e5"
        + "\u01e7\u01e7"
        + "\u01e9\u01e9"
        + "\u01eb\u01eb"
        + "\u01ed\u01ed"
        + "\u01ef\u01f0"
        + "\u01f3\u01f3"
        + "\u01f5\u01f5"
        + "\u01f9\u01f9"
        + "\u01fb\u01fb"
        + "\u01fd\u01fd"
        + "\u01ff\u01ff"
        + "\u0201\u0201"
        + "\u0203\u0203"
        + "\u0205\u0205"
        + "\u0207\u0207"
        + "\u0209\u0209"
        + "\u020b\u020b"
        + "\u020d\u020d"
        + "\u020f\u020f"
        + "\u0211\u0211"
        + "\u0213\u0213"
        + "\u0215\u0215"
        + "\u0217\u0217"
        + "\u0219\u0219"
        + "\u021b\u021b"
        + "\u021d\u021d"
        + "\u021f\u021f"
        + "\u0221\u0221"
        + "\u0223\u0223"
        + "\u0225\u0225"
        + "\u0227\u0227"
        + "\u0229\u0229"
        + "\u022b\u022b"
        + "\u022d\u022d"
        + "\u022f\u022f"
        + "\u0231\u0231"
        + "\u0233\u0239"
        + "\u023c\u023c"
        + "\u023f\u0240"
        + "\u0242\u0242"
        + "\u0247\u0247"
        + "\u0249\u0249"
        + "\u024b\u024b"
        + "\u024d\u024d"
        + "\u024f\u0293"
        + "\u0295\u02b8"
        + "\u02c0\u02c1"
        + "\u02e0\u02e4"
        + "\u0345\u0345"
        + "\u0371\u0371"
        + "\u0373\u0373"
        + "\u0377\u0377"
        + "\u037a\u037d"
        + "\u0390\u0390"
        + "\u03ac\u03ce"
        + "\u03d0\u03d1"
        + "\u03d5\u03d7"
        + "\u03d9\u03d9"
        + "\u03db\u03db"
        + "\u03dd\u03dd"
        + "\u03df\u03df"
        + "\u03e1\u03e1"
        + "\u03e3\u03e3"
        + "\u03e5\u03e5"
        + "\u03e7\u03e7"
        + "\u03e9\u03e9"
        + "\u03eb\u03eb"
        + "\u03ed\u03ed"
        + "\u03ef\u03f3"
        + "\u03f5\u03f5"
        + "\u03f8\u03f8"
        + "\u03fb\u03fc"
        + "\u0430\u045f"
        + "\u0461\u0461"
        + "\u0463\u0463"
        + "\u0465\u0465"
        + "\u0467\u0467"
        + "\u0469\u0469"
        + "\u046b\u046b"
        + "\u046d\u046d"
        + "\u046f\u046f"
        + "\u0471\u0471"
        + "\u0473\u0473"
        + "\u0475\u0475"
        + "\u0477\u0477"
        + "\u0479\u0479"
        + "\u047b\u047b"
        + "\u047d\u047d"
        + "\u047f\u047f"
        + "\u0481\u0481"
        + "\u048b\u048b"
        + "\u048d\u048d"
        + "\u048f\u048f"
        + "\u0491\u0491"
        + "\u0493\u0493"
        + "\u0495\u0495"
        + "\u0497\u0497"
        + "\u0499\u0499"
        + "\u049b\u049b"
        + "\u049d\u049d"
        + "\u049f\u049f"
        + "\u04a1\u04a1"
        + "\u04a3\u04a3"
        + "\u04a5\u04a5"
        + "\u04a7\u04a7"
        + "\u04a9\u04a9"
        + "\u04ab\u04ab"
        + "\u04ad\u04ad"
        + "\u04af\u04af"
        + "\u04b1\u04b1"
        + "\u04b3\u04b3"
        + "\u04b5\u04b5"
        + "\u04b7\u04b7"
        + "\u04b9\u04b9"
        + "\u04bb\u04bb"
        + "\u04bd\u04bd"
        + "\u04bf\u04bf"
        + "\u04c2\u04c2"
        + "\u04c4\u04c4"
        + "\u04c6\u04c6"
        + "\u04c8\u04c8"
        + "\u04ca\u04ca"
        + "\u04cc\u04cc"
        + "\u04ce\u04cf"
        + "\u04d1\u04d1"
        + "\u04d3\u04d3"
        + "\u04d5\u04d5"
        + "\u04d7\u04d7"
        + "\u04d9\u04d9"
        + "\u04db\u04db"
        + "\u04dd\u04dd"
        + "\u04df\u04df"
        + "\u04e1\u04e1"
        + "\u04e3\u04e3"
        + "\u04e5\u04e5"
        + "\u04e7\u04e7"
        + "\u04e9\u04e9"
        + "\u04eb\u04eb"
        + "\u04ed\u04ed"
        + "\u04ef\u04ef"
        + "\u04f1\u04f1"
        + "\u04f3\u04f3"
        + "\u04f5\u04f5"
        + "\u04f7\u04f7"
        + "\u04f9\u04f9"
        + "\u04fb\u04fb"
        + "\u04fd\u04fd"
        + "\u04ff\u04ff"
        + "\u0501\u0501"
        + "\u0503\u0503"
        + "\u0505\u0505"
        + "\u0507\u0507"
        + "\u0509\u0509"
        + "\u050b\u050b"
        + "\u050d\u050d"
        + "\u050f\u050f"
        + "\u0511\u0511"
        + "\u0513\u0513"
        + "\u0515\u0515"
        + "\u0517\u0517"
        + "\u0519\u0519"
        + "\u051b\u051b"
        + "\u051d\u051d"
        + "\u051f\u051f"
        + "\u0521\u0521"
        + "\u0523\u0523"
        + "\u0525\u0525"
        + "\u0527\u0527"
        + "\u0529\u0529"
        + "\u052b\u052b"
        + "\u052d\u052d"
        + "\u052f\u052f"
        + "\u0561\u0587"
        + "\u1d00\u1dbf"
        + "\u1e01\u1e01"
        + "\u1e03\u1e03"
        + "\u1e05\u1e05"
        + "\u1e07\u1e07"
        + "\u1e09\u1e09"
        + "\u1e0b\u1e0b"
        + "\u1e0d\u1e0d"
        + "\u1e0f\u1e0f"
        + "\u1e11\u1e11"
        + "\u1e13\u1e13"
        + "\u1e15\u1e15"
        + "\u1e17\u1e17"
        + "\u1e19\u1e19"
        + "\u1e1b\u1e1b"
        + "\u1e1d\u1e1d"
        + "\u1e1f\u1e1f"
        + "\u1e21\u1e21"
        + "\u1e23\u1e23"
        + "\u1e25\u1e25"
        + "\u1e27\u1e27"
        + "\u1e29\u1e29"
        + "\u1e2b\u1e2b"
        + "\u1e2d\u1e2d"
        + "\u1e2f\u1e2f"
        + "\u1e31\u1e31"
        + "\u1e33\u1e33"
        + "\u1e35\u1e35"
        + "\u1e37\u1e37"
        + "\u1e39\u1e39"
        + "\u1e3b\u1e3b"
        + "\u1e3d\u1e3d"
        + "\u1e3f\u1e3f"
        + "\u1e41\u1e41"
        + "\u1e43\u1e43"
        + "\u1e45\u1e45"
        + "\u1e47\u1e47"
        + "\u1e49\u1e49"
        + "\u1e4b\u1e4b"
        + "\u1e4d\u1e4d"
        + "\u1e4f\u1e4f"
        + "\u1e51\u1e51"
        + "\u1e53\u1e53"
        + "\u1e55\u1e55"
        + "\u1e57\u1e57"
        + "\u1e59\u1e59"
        + "\u1e5b\u1e5b"
        + "\u1e5d\u1e5d"
        + "\u1e5f\u1e5f"
        + "\u1e61\u1e61"
        + "\u1e63\u1e63"
        + "\u1e65\u1e65"
        + "\u1e67\u1e67"
        + "\u1e69\u1e69"
        + "\u1e6b\u1e6b"
        + "\u1e6d\u1e6d"
        + "\u1e6f\u1e6f"
        + "\u1e71\u1e71"
        + "\u1e73\u1e73"
        + "\u1e75\u1e75"
        + "\u1e77\u1e77"
        + "\u1e79\u1e79"
        + "\u1e7b\u1e7b"
        + "\u1e7d\u1e7d"
        + "\u1e7f\u1e7f"
        + "\u1e81\u1e81"
        + "\u1e83\u1e83"
        + "\u1e85\u1e85"
        + "\u1e87\u1e87"
        + "\u1e89\u1e89"
        + "\u1e8b\u1e8b"
        + "\u1e8d\u1e8d"
        + "\u1e8f\u1e8f"
        + "\u1e91\u1e91"
        + "\u1e93\u1e93"
        + "\u1e95\u1e9d"
        + "\u1e9f\u1e9f"
        + "\u1ea1\u1ea1"
        + "\u1ea3\u1ea3"
        + "\u1ea5\u1ea5"
        + "\u1ea7\u1ea7"
        + "\u1ea9\u1ea9"
        + "\u1eab\u1eab"
        + "\u1ead\u1ead"
        + "\u1eaf\u1eaf"
        + "\u1eb1\u1eb1"
        + "\u1eb3\u1eb3"
        + "\u1eb5\u1eb5"
        + "\u1eb7\u1eb7"
        + "\u1eb9\u1eb9"
        + "\u1ebb\u1ebb"
        + "\u1ebd\u1ebd"
        + "\u1ebf\u1ebf"
        + "\u1ec1\u1ec1"
        + "\u1ec3\u1ec3"
        + "\u1ec5\u1ec5"
        + "\u1ec7\u1ec7"
        + "\u1ec9\u1ec9"
        + "\u1ecb\u1ecb"
        + "\u1ecd\u1ecd"
        + "\u1ecf\u1ecf"
        + "\u1ed1\u1ed1"
        + "\u1ed3\u1ed3"
        + "\u1ed5\u1ed5"
        + "\u1ed7\u1ed7"
        + "\u1ed9\u1ed9"
        + "\u1edb\u1edb"
        + "\u1edd\u1edd"
        + "\u1edf\u1edf"
        + "\u1ee1\u1ee1"
        + "\u1ee3\u1ee3"
        + "\u1ee5\u1ee5"
        + "\u1ee7\u1ee7"
        + "\u1ee9\u1ee9"
        + "\u1eeb\u1eeb"
        + "\u1eed\u1eed"
        + "\u1eef\u1eef"
        + "\u1ef1\u1ef1"
        + "\u1ef3\u1ef3"
        + "\u1ef5\u1ef5"
        + "\u1ef7\u1ef7"
        + "\u1ef9\u1ef9"
        + "\u1efb\u1efb"
        + "\u1efd\u1efd"
        + "\u1eff\u1f07"
        + "\u1f10\u1f15"
        + "\u1f20\u1f27"
        + "\u1f30\u1f37"
        + "\u1f40\u1f45"
        + "\u1f50\u1f57"
        + "\u1f60\u1f67"
        + "\u1f70\u1f7d"
        + "\u1f80\u1f87"
        + "\u1f90\u1f97"
        + "\u1fa0\u1fa7"
        + "\u1fb0\u1fb4"
        + "\u1fb6\u1fb7"
        + "\u1fbe\u1fbe"
        + "\u1fc2\u1fc4"
        + "\u1fc6\u1fc7"
        + "\u1fd0\u1fd3"
        + "\u1fd6\u1fd7"
        + "\u1fe0\u1fe7"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ff7"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u210a\u210a"
        + "\u210e\u210f"
        + "\u2113\u2113"
        + "\u212f\u212f"
        + "\u2134\u2134"
        + "\u2139\u2139"
        + "\u213c\u213d"
        + "\u2146\u2149"
        + "\u214e\u214e"
        + "\u2170\u217f"
        + "\u2184\u2184"
        + "\u24d0\u24e9"
        + "\u2c30\u2c5e"
        + "\u2c61\u2c61"
        + "\u2c65\u2c66"
        + "\u2c68\u2c68"
        + "\u2c6a\u2c6a"
        + "\u2c6c\u2c6c"
        + "\u2c71\u2c71"
        + "\u2c73\u2c74"
        + "\u2c76\u2c7d"
        + "\u2c81\u2c81"
        + "\u2c83\u2c83"
        + "\u2c85\u2c85"
        + "\u2c87\u2c87"
        + "\u2c89\u2c89"
        + "\u2c8b\u2c8b"
        + "\u2c8d\u2c8d"
        + "\u2c8f\u2c8f"
        + "\u2c91\u2c91"
        + "\u2c93\u2c93"
        + "\u2c95\u2c95"
        + "\u2c97\u2c97"
        + "\u2c99\u2c99"
        + "\u2c9b\u2c9b"
        + "\u2c9d\u2c9d"
        + "\u2c9f\u2c9f"
        + "\u2ca1\u2ca1"
        + "\u2ca3\u2ca3"
        + "\u2ca5\u2ca5"
        + "\u2ca7\u2ca7"
        + "\u2ca9\u2ca9"
        + "\u2cab\u2cab"
        + "\u2cad\u2cad"
        + "\u2caf\u2caf"
        + "\u2cb1\u2cb1"
        + "\u2cb3\u2cb3"
        + "\u2cb5\u2cb5"
        + "\u2cb7\u2cb7"
        + "\u2cb9\u2cb9"
        + "\u2cbb\u2cbb"
        + "\u2cbd\u2cbd"
        + "\u2cbf\u2cbf"
        + "\u2cc1\u2cc1"
        + "\u2cc3\u2cc3"
        + "\u2cc5\u2cc5"
        + "\u2cc7\u2cc7"
        + "\u2cc9\u2cc9"
        + "\u2ccb\u2ccb"
        + "\u2ccd\u2ccd"
        + "\u2ccf\u2ccf"
        + "\u2cd1\u2cd1"
        + "\u2cd3\u2cd3"
        + "\u2cd5\u2cd5"
        + "\u2cd7\u2cd7"
        + "\u2cd9\u2cd9"
        + "\u2cdb\u2cdb"
        + "\u2cdd\u2cdd"
        + "\u2cdf\u2cdf"
        + "\u2ce1\u2ce1"
        + "\u2ce3\u2ce4"
        + "\u2cec\u2cec"
        + "\u2cee\u2cee"
        + "\u2cf3\u2cf3"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\ua641\ua641"
        + "\ua643\ua643"
        + "\ua645\ua645"
        + "\ua647\ua647"
        + "\ua649\ua649"
        + "\ua64b\ua64b"
        + "\ua64d\ua64d"
        + "\ua64f\ua64f"
        + "\ua651\ua651"
        + "\ua653\ua653"
        + "\ua655\ua655"
        + "\ua657\ua657"
        + "\ua659\ua659"
        + "\ua65b\ua65b"
        + "\ua65d\ua65d"
        + "\ua65f\ua65f"
        + "\ua661\ua661"
        + "\ua663\ua663"
        + "\ua665\ua665"
        + "\ua667\ua667"
        + "\ua669\ua669"
        + "\ua66b\ua66b"
        + "\ua66d\ua66d"
        + "\ua681\ua681"
        + "\ua683\ua683"
        + "\ua685\ua685"
        + "\ua687\ua687"
        + "\ua689\ua689"
        + "\ua68b\ua68b"
        + "\ua68d\ua68d"
        + "\ua68f\ua68f"
        + "\ua691\ua691"
        + "\ua693\ua693"
        + "\ua695\ua695"
        + "\ua697\ua697"
        + "\ua699\ua699"
        + "\ua69b\ua69d"
        + "\ua723\ua723"
        + "\ua725\ua725"
        + "\ua727\ua727"
        + "\ua729\ua729"
        + "\ua72b\ua72b"
        + "\ua72d\ua72d"
        + "\ua72f\ua731"
        + "\ua733\ua733"
        + "\ua735\ua735"
        + "\ua737\ua737"
        + "\ua739\ua739"
        + "\ua73b\ua73b"
        + "\ua73d\ua73d"
        + "\ua73f\ua73f"
        + "\ua741\ua741"
        + "\ua743\ua743"
        + "\ua745\ua745"
        + "\ua747\ua747"
        + "\ua749\ua749"
        + "\ua74b\ua74b"
        + "\ua74d\ua74d"
        + "\ua74f\ua74f"
        + "\ua751\ua751"
        + "\ua753\ua753"
        + "\ua755\ua755"
        + "\ua757\ua757"
        + "\ua759\ua759"
        + "\ua75b\ua75b"
        + "\ua75d\ua75d"
        + "\ua75f\ua75f"
        + "\ua761\ua761"
        + "\ua763\ua763"
        + "\ua765\ua765"
        + "\ua767\ua767"
        + "\ua769\ua769"
        + "\ua76b\ua76b"
        + "\ua76d\ua76d"
        + "\ua76f\ua778"
        + "\ua77a\ua77a"
        + "\ua77c\ua77c"
        + "\ua77f\ua77f"
        + "\ua781\ua781"
        + "\ua783\ua783"
        + "\ua785\ua785"
        + "\ua787\ua787"
        + "\ua78c\ua78c"
        + "\ua78e\ua78e"
        + "\ua791\ua791"
        + "\ua793\ua795"
        + "\ua797\ua797"
        + "\ua799\ua799"
        + "\ua79b\ua79b"
        + "\ua79d\ua79d"
        + "\ua79f\ua79f"
        + "\ua7a1\ua7a1"
        + "\ua7a3\ua7a3"
        + "\ua7a5\ua7a5"
        + "\ua7a7\ua7a7"
        + "\ua7a9\ua7a9"
        + "\ua7f8\ua7fa"
        + "\uab30\uab5a"
        + "\uab5c\uab5f"
        + "\uab64\uab65"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\uff41\uff5a"
        + "\ud801\udc28\ud801\udc4f"
        + "\ud806\udcc0\ud806\udcdf"
        + "\ud835\udc1a\ud835\udc33"
        + "\ud835\udc4e\ud835\udc54"
        + "\ud835\udc56\ud835\udc67"
        + "\ud835\udc82\ud835\udc9b"
        + "\ud835\udcb6\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udccf"
        + "\ud835\udcea\ud835\udd03"
        + "\ud835\udd1e\ud835\udd37"
        + "\ud835\udd52\ud835\udd6b"
        + "\ud835\udd86\ud835\udd9f"
        + "\ud835\uddba\ud835\uddd3"
        + "\ud835\uddee\ud835\ude07"
        + "\ud835\ude22\ud835\ude3b"
        + "\ud835\ude56\ud835\ude6f"
        + "\ud835\ude8a\ud835\udea5"
        + "\ud835\udec2\ud835\udeda"
        + "\ud835\udedc\ud835\udee1"
        + "\ud835\udefc\ud835\udf14"
        + "\ud835\udf16\ud835\udf1b"
        + "\ud835\udf36\ud835\udf4e"
        + "\ud835\udf50\ud835\udf55"
        + "\ud835\udf70\ud835\udf88"
        + "\ud835\udf8a\ud835\udf8f"
        + "\ud835\udfaa\ud835\udfc2"
        + "\ud835\udfc4\ud835\udfc9"
        + "\ud835\udfcb\ud835\udfcb",
    // Unicode 7.0 property value: {lt}
    "\u01c5\u01c5"
        + "\u01c8\u01c8"
        + "\u01cb\u01cb"
        + "\u01f2\u01f2"
        + "\u1f88\u1f8f"
        + "\u1f98\u1f9f"
        + "\u1fa8\u1faf"
        + "\u1fbc\u1fbc"
        + "\u1fcc\u1fcc"
        + "\u1ffc\u1ffc",
    // Unicode 7.0 property value: {lu}
    "\u0041\u005a"
        + "\u00c0\u00d6"
        + "\u00d8\u00de"
        + "\u0100\u0100"
        + "\u0102\u0102"
        + "\u0104\u0104"
        + "\u0106\u0106"
        + "\u0108\u0108"
        + "\u010a\u010a"
        + "\u010c\u010c"
        + "\u010e\u010e"
        + "\u0110\u0110"
        + "\u0112\u0112"
        + "\u0114\u0114"
        + "\u0116\u0116"
        + "\u0118\u0118"
        + "\u011a\u011a"
        + "\u011c\u011c"
        + "\u011e\u011e"
        + "\u0120\u0120"
        + "\u0122\u0122"
        + "\u0124\u0124"
        + "\u0126\u0126"
        + "\u0128\u0128"
        + "\u012a\u012a"
        + "\u012c\u012c"
        + "\u012e\u012e"
        + "\u0130\u0130"
        + "\u0132\u0132"
        + "\u0134\u0134"
        + "\u0136\u0136"
        + "\u0139\u0139"
        + "\u013b\u013b"
        + "\u013d\u013d"
        + "\u013f\u013f"
        + "\u0141\u0141"
        + "\u0143\u0143"
        + "\u0145\u0145"
        + "\u0147\u0147"
        + "\u014a\u014a"
        + "\u014c\u014c"
        + "\u014e\u014e"
        + "\u0150\u0150"
        + "\u0152\u0152"
        + "\u0154\u0154"
        + "\u0156\u0156"
        + "\u0158\u0158"
        + "\u015a\u015a"
        + "\u015c\u015c"
        + "\u015e\u015e"
        + "\u0160\u0160"
        + "\u0162\u0162"
        + "\u0164\u0164"
        + "\u0166\u0166"
        + "\u0168\u0168"
        + "\u016a\u016a"
        + "\u016c\u016c"
        + "\u016e\u016e"
        + "\u0170\u0170"
        + "\u0172\u0172"
        + "\u0174\u0174"
        + "\u0176\u0176"
        + "\u0178\u0179"
        + "\u017b\u017b"
        + "\u017d\u017d"
        + "\u0181\u0182"
        + "\u0184\u0184"
        + "\u0186\u0187"
        + "\u0189\u018b"
        + "\u018e\u0191"
        + "\u0193\u0194"
        + "\u0196\u0198"
        + "\u019c\u019d"
        + "\u019f\u01a0"
        + "\u01a2\u01a2"
        + "\u01a4\u01a4"
        + "\u01a6\u01a7"
        + "\u01a9\u01a9"
        + "\u01ac\u01ac"
        + "\u01ae\u01af"
        + "\u01b1\u01b3"
        + "\u01b5\u01b5"
        + "\u01b7\u01b8"
        + "\u01bc\u01bc"
        + "\u01c4\u01c4"
        + "\u01c7\u01c7"
        + "\u01ca\u01ca"
        + "\u01cd\u01cd"
        + "\u01cf\u01cf"
        + "\u01d1\u01d1"
        + "\u01d3\u01d3"
        + "\u01d5\u01d5"
        + "\u01d7\u01d7"
        + "\u01d9\u01d9"
        + "\u01db\u01db"
        + "\u01de\u01de"
        + "\u01e0\u01e0"
        + "\u01e2\u01e2"
        + "\u01e4\u01e4"
        + "\u01e6\u01e6"
        + "\u01e8\u01e8"
        + "\u01ea\u01ea"
        + "\u01ec\u01ec"
        + "\u01ee\u01ee"
        + "\u01f1\u01f1"
        + "\u01f4\u01f4"
        + "\u01f6\u01f8"
        + "\u01fa\u01fa"
        + "\u01fc\u01fc"
        + "\u01fe\u01fe"
        + "\u0200\u0200"
        + "\u0202\u0202"
        + "\u0204\u0204"
        + "\u0206\u0206"
        + "\u0208\u0208"
        + "\u020a\u020a"
        + "\u020c\u020c"
        + "\u020e\u020e"
        + "\u0210\u0210"
        + "\u0212\u0212"
        + "\u0214\u0214"
        + "\u0216\u0216"
        + "\u0218\u0218"
        + "\u021a\u021a"
        + "\u021c\u021c"
        + "\u021e\u021e"
        + "\u0220\u0220"
        + "\u0222\u0222"
        + "\u0224\u0224"
        + "\u0226\u0226"
        + "\u0228\u0228"
        + "\u022a\u022a"
        + "\u022c\u022c"
        + "\u022e\u022e"
        + "\u0230\u0230"
        + "\u0232\u0232"
        + "\u023a\u023b"
        + "\u023d\u023e"
        + "\u0241\u0241"
        + "\u0243\u0246"
        + "\u0248\u0248"
        + "\u024a\u024a"
        + "\u024c\u024c"
        + "\u024e\u024e"
        + "\u0370\u0370"
        + "\u0372\u0372"
        + "\u0376\u0376"
        + "\u037f\u037f"
        + "\u0386\u0386"
        + "\u0388\u038a"
        + "\u038c\u038c"
        + "\u038e\u038f"
        + "\u0391\u03a1"
        + "\u03a3\u03ab"
        + "\u03cf\u03cf"
        + "\u03d2\u03d4"
        + "\u03d8\u03d8"
        + "\u03da\u03da"
        + "\u03dc\u03dc"
        + "\u03de\u03de"
        + "\u03e0\u03e0"
        + "\u03e2\u03e2"
        + "\u03e4\u03e4"
        + "\u03e6\u03e6"
        + "\u03e8\u03e8"
        + "\u03ea\u03ea"
        + "\u03ec\u03ec"
        + "\u03ee\u03ee"
        + "\u03f4\u03f4"
        + "\u03f7\u03f7"
        + "\u03f9\u03fa"
        + "\u03fd\u042f"
        + "\u0460\u0460"
        + "\u0462\u0462"
        + "\u0464\u0464"
        + "\u0466\u0466"
        + "\u0468\u0468"
        + "\u046a\u046a"
        + "\u046c\u046c"
        + "\u046e\u046e"
        + "\u0470\u0470"
        + "\u0472\u0472"
        + "\u0474\u0474"
        + "\u0476\u0476"
        + "\u0478\u0478"
        + "\u047a\u047a"
        + "\u047c\u047c"
        + "\u047e\u047e"
        + "\u0480\u0480"
        + "\u048a\u048a"
        + "\u048c\u048c"
        + "\u048e\u048e"
        + "\u0490\u0490"
        + "\u0492\u0492"
        + "\u0494\u0494"
        + "\u0496\u0496"
        + "\u0498\u0498"
        + "\u049a\u049a"
        + "\u049c\u049c"
        + "\u049e\u049e"
        + "\u04a0\u04a0"
        + "\u04a2\u04a2"
        + "\u04a4\u04a4"
        + "\u04a6\u04a6"
        + "\u04a8\u04a8"
        + "\u04aa\u04aa"
        + "\u04ac\u04ac"
        + "\u04ae\u04ae"
        + "\u04b0\u04b0"
        + "\u04b2\u04b2"
        + "\u04b4\u04b4"
        + "\u04b6\u04b6"
        + "\u04b8\u04b8"
        + "\u04ba\u04ba"
        + "\u04bc\u04bc"
        + "\u04be\u04be"
        + "\u04c0\u04c1"
        + "\u04c3\u04c3"
        + "\u04c5\u04c5"
        + "\u04c7\u04c7"
        + "\u04c9\u04c9"
        + "\u04cb\u04cb"
        + "\u04cd\u04cd"
        + "\u04d0\u04d0"
        + "\u04d2\u04d2"
        + "\u04d4\u04d4"
        + "\u04d6\u04d6"
        + "\u04d8\u04d8"
        + "\u04da\u04da"
        + "\u04dc\u04dc"
        + "\u04de\u04de"
        + "\u04e0\u04e0"
        + "\u04e2\u04e2"
        + "\u04e4\u04e4"
        + "\u04e6\u04e6"
        + "\u04e8\u04e8"
        + "\u04ea\u04ea"
        + "\u04ec\u04ec"
        + "\u04ee\u04ee"
        + "\u04f0\u04f0"
        + "\u04f2\u04f2"
        + "\u04f4\u04f4"
        + "\u04f6\u04f6"
        + "\u04f8\u04f8"
        + "\u04fa\u04fa"
        + "\u04fc\u04fc"
        + "\u04fe\u04fe"
        + "\u0500\u0500"
        + "\u0502\u0502"
        + "\u0504\u0504"
        + "\u0506\u0506"
        + "\u0508\u0508"
        + "\u050a\u050a"
        + "\u050c\u050c"
        + "\u050e\u050e"
        + "\u0510\u0510"
        + "\u0512\u0512"
        + "\u0514\u0514"
        + "\u0516\u0516"
        + "\u0518\u0518"
        + "\u051a\u051a"
        + "\u051c\u051c"
        + "\u051e\u051e"
        + "\u0520\u0520"
        + "\u0522\u0522"
        + "\u0524\u0524"
        + "\u0526\u0526"
        + "\u0528\u0528"
        + "\u052a\u052a"
        + "\u052c\u052c"
        + "\u052e\u052e"
        + "\u0531\u0556"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u1e00\u1e00"
        + "\u1e02\u1e02"
        + "\u1e04\u1e04"
        + "\u1e06\u1e06"
        + "\u1e08\u1e08"
        + "\u1e0a\u1e0a"
        + "\u1e0c\u1e0c"
        + "\u1e0e\u1e0e"
        + "\u1e10\u1e10"
        + "\u1e12\u1e12"
        + "\u1e14\u1e14"
        + "\u1e16\u1e16"
        + "\u1e18\u1e18"
        + "\u1e1a\u1e1a"
        + "\u1e1c\u1e1c"
        + "\u1e1e\u1e1e"
        + "\u1e20\u1e20"
        + "\u1e22\u1e22"
        + "\u1e24\u1e24"
        + "\u1e26\u1e26"
        + "\u1e28\u1e28"
        + "\u1e2a\u1e2a"
        + "\u1e2c\u1e2c"
        + "\u1e2e\u1e2e"
        + "\u1e30\u1e30"
        + "\u1e32\u1e32"
        + "\u1e34\u1e34"
        + "\u1e36\u1e36"
        + "\u1e38\u1e38"
        + "\u1e3a\u1e3a"
        + "\u1e3c\u1e3c"
        + "\u1e3e\u1e3e"
        + "\u1e40\u1e40"
        + "\u1e42\u1e42"
        + "\u1e44\u1e44"
        + "\u1e46\u1e46"
        + "\u1e48\u1e48"
        + "\u1e4a\u1e4a"
        + "\u1e4c\u1e4c"
        + "\u1e4e\u1e4e"
        + "\u1e50\u1e50"
        + "\u1e52\u1e52"
        + "\u1e54\u1e54"
        + "\u1e56\u1e56"
        + "\u1e58\u1e58"
        + "\u1e5a\u1e5a"
        + "\u1e5c\u1e5c"
        + "\u1e5e\u1e5e"
        + "\u1e60\u1e60"
        + "\u1e62\u1e62"
        + "\u1e64\u1e64"
        + "\u1e66\u1e66"
        + "\u1e68\u1e68"
        + "\u1e6a\u1e6a"
        + "\u1e6c\u1e6c"
        + "\u1e6e\u1e6e"
        + "\u1e70\u1e70"
        + "\u1e72\u1e72"
        + "\u1e74\u1e74"
        + "\u1e76\u1e76"
        + "\u1e78\u1e78"
        + "\u1e7a\u1e7a"
        + "\u1e7c\u1e7c"
        + "\u1e7e\u1e7e"
        + "\u1e80\u1e80"
        + "\u1e82\u1e82"
        + "\u1e84\u1e84"
        + "\u1e86\u1e86"
        + "\u1e88\u1e88"
        + "\u1e8a\u1e8a"
        + "\u1e8c\u1e8c"
        + "\u1e8e\u1e8e"
        + "\u1e90\u1e90"
        + "\u1e92\u1e92"
        + "\u1e94\u1e94"
        + "\u1e9e\u1e9e"
        + "\u1ea0\u1ea0"
        + "\u1ea2\u1ea2"
        + "\u1ea4\u1ea4"
        + "\u1ea6\u1ea6"
        + "\u1ea8\u1ea8"
        + "\u1eaa\u1eaa"
        + "\u1eac\u1eac"
        + "\u1eae\u1eae"
        + "\u1eb0\u1eb0"
        + "\u1eb2\u1eb2"
        + "\u1eb4\u1eb4"
        + "\u1eb6\u1eb6"
        + "\u1eb8\u1eb8"
        + "\u1eba\u1eba"
        + "\u1ebc\u1ebc"
        + "\u1ebe\u1ebe"
        + "\u1ec0\u1ec0"
        + "\u1ec2\u1ec2"
        + "\u1ec4\u1ec4"
        + "\u1ec6\u1ec6"
        + "\u1ec8\u1ec8"
        + "\u1eca\u1eca"
        + "\u1ecc\u1ecc"
        + "\u1ece\u1ece"
        + "\u1ed0\u1ed0"
        + "\u1ed2\u1ed2"
        + "\u1ed4\u1ed4"
        + "\u1ed6\u1ed6"
        + "\u1ed8\u1ed8"
        + "\u1eda\u1eda"
        + "\u1edc\u1edc"
        + "\u1ede\u1ede"
        + "\u1ee0\u1ee0"
        + "\u1ee2\u1ee2"
        + "\u1ee4\u1ee4"
        + "\u1ee6\u1ee6"
        + "\u1ee8\u1ee8"
        + "\u1eea\u1eea"
        + "\u1eec\u1eec"
        + "\u1eee\u1eee"
        + "\u1ef0\u1ef0"
        + "\u1ef2\u1ef2"
        + "\u1ef4\u1ef4"
        + "\u1ef6\u1ef6"
        + "\u1ef8\u1ef8"
        + "\u1efa\u1efa"
        + "\u1efc\u1efc"
        + "\u1efe\u1efe"
        + "\u1f08\u1f0f"
        + "\u1f18\u1f1d"
        + "\u1f28\u1f2f"
        + "\u1f38\u1f3f"
        + "\u1f48\u1f4d"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f5f"
        + "\u1f68\u1f6f"
        + "\u1fb8\u1fbb"
        + "\u1fc8\u1fcb"
        + "\u1fd8\u1fdb"
        + "\u1fe8\u1fec"
        + "\u1ff8\u1ffb"
        + "\u2102\u2102"
        + "\u2107\u2107"
        + "\u210b\u210d"
        + "\u2110\u2112"
        + "\u2115\u2115"
        + "\u2119\u211d"
        + "\u2124\u2124"
        + "\u2126\u2126"
        + "\u2128\u2128"
        + "\u212a\u212d"
        + "\u2130\u2133"
        + "\u213e\u213f"
        + "\u2145\u2145"
        + "\u2183\u2183"
        + "\u2c00\u2c2e"
        + "\u2c60\u2c60"
        + "\u2c62\u2c64"
        + "\u2c67\u2c67"
        + "\u2c69\u2c69"
        + "\u2c6b\u2c6b"
        + "\u2c6d\u2c70"
        + "\u2c72\u2c72"
        + "\u2c75\u2c75"
        + "\u2c7e\u2c80"
        + "\u2c82\u2c82"
        + "\u2c84\u2c84"
        + "\u2c86\u2c86"
        + "\u2c88\u2c88"
        + "\u2c8a\u2c8a"
        + "\u2c8c\u2c8c"
        + "\u2c8e\u2c8e"
        + "\u2c90\u2c90"
        + "\u2c92\u2c92"
        + "\u2c94\u2c94"
        + "\u2c96\u2c96"
        + "\u2c98\u2c98"
        + "\u2c9a\u2c9a"
        + "\u2c9c\u2c9c"
        + "\u2c9e\u2c9e"
        + "\u2ca0\u2ca0"
        + "\u2ca2\u2ca2"
        + "\u2ca4\u2ca4"
        + "\u2ca6\u2ca6"
        + "\u2ca8\u2ca8"
        + "\u2caa\u2caa"
        + "\u2cac\u2cac"
        + "\u2cae\u2cae"
        + "\u2cb0\u2cb0"
        + "\u2cb2\u2cb2"
        + "\u2cb4\u2cb4"
        + "\u2cb6\u2cb6"
        + "\u2cb8\u2cb8"
        + "\u2cba\u2cba"
        + "\u2cbc\u2cbc"
        + "\u2cbe\u2cbe"
        + "\u2cc0\u2cc0"
        + "\u2cc2\u2cc2"
        + "\u2cc4\u2cc4"
        + "\u2cc6\u2cc6"
        + "\u2cc8\u2cc8"
        + "\u2cca\u2cca"
        + "\u2ccc\u2ccc"
        + "\u2cce\u2cce"
        + "\u2cd0\u2cd0"
        + "\u2cd2\u2cd2"
        + "\u2cd4\u2cd4"
        + "\u2cd6\u2cd6"
        + "\u2cd8\u2cd8"
        + "\u2cda\u2cda"
        + "\u2cdc\u2cdc"
        + "\u2cde\u2cde"
        + "\u2ce0\u2ce0"
        + "\u2ce2\u2ce2"
        + "\u2ceb\u2ceb"
        + "\u2ced\u2ced"
        + "\u2cf2\u2cf2"
        + "\ua640\ua640"
        + "\ua642\ua642"
        + "\ua644\ua644"
        + "\ua646\ua646"
        + "\ua648\ua648"
        + "\ua64a\ua64a"
        + "\ua64c\ua64c"
        + "\ua64e\ua64e"
        + "\ua650\ua650"
        + "\ua652\ua652"
        + "\ua654\ua654"
        + "\ua656\ua656"
        + "\ua658\ua658"
        + "\ua65a\ua65a"
        + "\ua65c\ua65c"
        + "\ua65e\ua65e"
        + "\ua660\ua660"
        + "\ua662\ua662"
        + "\ua664\ua664"
        + "\ua666\ua666"
        + "\ua668\ua668"
        + "\ua66a\ua66a"
        + "\ua66c\ua66c"
        + "\ua680\ua680"
        + "\ua682\ua682"
        + "\ua684\ua684"
        + "\ua686\ua686"
        + "\ua688\ua688"
        + "\ua68a\ua68a"
        + "\ua68c\ua68c"
        + "\ua68e\ua68e"
        + "\ua690\ua690"
        + "\ua692\ua692"
        + "\ua694\ua694"
        + "\ua696\ua696"
        + "\ua698\ua698"
        + "\ua69a\ua69a"
        + "\ua722\ua722"
        + "\ua724\ua724"
        + "\ua726\ua726"
        + "\ua728\ua728"
        + "\ua72a\ua72a"
        + "\ua72c\ua72c"
        + "\ua72e\ua72e"
        + "\ua732\ua732"
        + "\ua734\ua734"
        + "\ua736\ua736"
        + "\ua738\ua738"
        + "\ua73a\ua73a"
        + "\ua73c\ua73c"
        + "\ua73e\ua73e"
        + "\ua740\ua740"
        + "\ua742\ua742"
        + "\ua744\ua744"
        + "\ua746\ua746"
        + "\ua748\ua748"
        + "\ua74a\ua74a"
        + "\ua74c\ua74c"
        + "\ua74e\ua74e"
        + "\ua750\ua750"
        + "\ua752\ua752"
        + "\ua754\ua754"
        + "\ua756\ua756"
        + "\ua758\ua758"
        + "\ua75a\ua75a"
        + "\ua75c\ua75c"
        + "\ua75e\ua75e"
        + "\ua760\ua760"
        + "\ua762\ua762"
        + "\ua764\ua764"
        + "\ua766\ua766"
        + "\ua768\ua768"
        + "\ua76a\ua76a"
        + "\ua76c\ua76c"
        + "\ua76e\ua76e"
        + "\ua779\ua779"
        + "\ua77b\ua77b"
        + "\ua77d\ua77e"
        + "\ua780\ua780"
        + "\ua782\ua782"
        + "\ua784\ua784"
        + "\ua786\ua786"
        + "\ua78b\ua78b"
        + "\ua78d\ua78d"
        + "\ua790\ua790"
        + "\ua792\ua792"
        + "\ua796\ua796"
        + "\ua798\ua798"
        + "\ua79a\ua79a"
        + "\ua79c\ua79c"
        + "\ua79e\ua79e"
        + "\ua7a0\ua7a0"
        + "\ua7a2\ua7a2"
        + "\ua7a4\ua7a4"
        + "\ua7a6\ua7a6"
        + "\ua7a8\ua7a8"
        + "\ua7aa\ua7ad"
        + "\ua7b0\ua7b1"
        + "\uff21\uff3a"
        + "\ud801\udc00\ud801\udc27"
        + "\ud806\udca0\ud806\udcbf"
        + "\ud835\udc00\ud835\udc19"
        + "\ud835\udc34\ud835\udc4d"
        + "\ud835\udc68\ud835\udc81"
        + "\ud835\udc9c\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb5"
        + "\ud835\udcd0\ud835\udce9"
        + "\ud835\udd04\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd38\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd6c\ud835\udd85"
        + "\ud835\udda0\ud835\uddb9"
        + "\ud835\uddd4\ud835\udded"
        + "\ud835\ude08\ud835\ude21"
        + "\ud835\ude3c\ud835\ude55"
        + "\ud835\ude70\ud835\ude89"
        + "\ud835\udea8\ud835\udec0"
        + "\ud835\udee2\ud835\udefa"
        + "\ud835\udf1c\ud835\udf34"
        + "\ud835\udf56\ud835\udf6e"
        + "\ud835\udf90\ud835\udfa8"
        + "\ud835\udfca\ud835\udfca",
    // Unicode 7.0 property value: {lycian}
    "\ud800\ude80\ud800\ude9c",
    // Unicode 7.0 property value: {lydian}
    "\ud802\udd20\ud802\udd39" + "\ud802\udd3f\ud802\udd3f",
    // Unicode 7.0 property value: {mahajani}
    "\ud804\udd50\ud804\udd76",
    // Unicode 7.0 property value: {malayalam}
    "\u0d01\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d75"
        + "\u0d79\u0d7f",
    // Unicode 7.0 property value: {mandaic}
    "\u0840\u085b" + "\u085e\u085e",
    // Unicode 7.0 property value: {manichaean}
    "\ud802\udec0\ud802\udee6" + "\ud802\udeeb\ud802\udef6",
    // Unicode 7.0 property value: {math}
    "\u002b\u002b"
        + "\u003c\u003e"
        + "\u005e\u005e"
        + "\u007c\u007c"
        + "\u007e\u007e"
        + "\u00ac\u00ac"
        + "\u00b1\u00b1"
        + "\u00d7\u00d7"
        + "\u00f7\u00f7"
        + "\u03d0\u03d2"
        + "\u03d5\u03d5"
        + "\u03f0\u03f1"
        + "\u03f4\u03f6"
        + "\u0606\u0608"
        + "\u2016\u2016"
        + "\u2032\u2034"
        + "\u2040\u2040"
        + "\u2044\u2044"
        + "\u2052\u2052"
        + "\u2061\u2064"
        + "\u207a\u207e"
        + "\u208a\u208e"
        + "\u20d0\u20dc"
        + "\u20e1\u20e1"
        + "\u20e5\u20e6"
        + "\u20eb\u20ef"
        + "\u2102\u2102"
        + "\u2107\u2107"
        + "\u210a\u2113"
        + "\u2115\u2115"
        + "\u2118\u211d"
        + "\u2124\u2124"
        + "\u2128\u2129"
        + "\u212c\u212d"
        + "\u212f\u2131"
        + "\u2133\u2138"
        + "\u213c\u2149"
        + "\u214b\u214b"
        + "\u2190\u21a7"
        + "\u21a9\u21ae"
        + "\u21b0\u21b1"
        + "\u21b6\u21b7"
        + "\u21bc\u21db"
        + "\u21dd\u21dd"
        + "\u21e4\u21e5"
        + "\u21f4\u22ff"
        + "\u2308\u230b"
        + "\u2320\u2321"
        + "\u237c\u237c"
        + "\u239b\u23b5"
        + "\u23b7\u23b7"
        + "\u23d0\u23d0"
        + "\u23dc\u23e2"
        + "\u25a0\u25a1"
        + "\u25ae\u25b7"
        + "\u25bc\u25c1"
        + "\u25c6\u25c7"
        + "\u25ca\u25cb"
        + "\u25cf\u25d3"
        + "\u25e2\u25e2"
        + "\u25e4\u25e4"
        + "\u25e7\u25ec"
        + "\u25f8\u25ff"
        + "\u2605\u2606"
        + "\u2640\u2640"
        + "\u2642\u2642"
        + "\u2660\u2663"
        + "\u266d\u266f"
        + "\u27c0\u27ff"
        + "\u2900\u2aff"
        + "\u2b30\u2b44"
        + "\u2b47\u2b4c"
        + "\ufb29\ufb29"
        + "\ufe61\ufe66"
        + "\ufe68\ufe68"
        + "\uff0b\uff0b"
        + "\uff1c\uff1e"
        + "\uff3c\uff3c"
        + "\uff3e\uff3e"
        + "\uff5c\uff5c"
        + "\uff5e\uff5e"
        + "\uffe2\uffe2"
        + "\uffe9\uffec"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83b\udef0\ud83b\udef1",
    // Unicode 7.0 property value: {mc}
    "\u0903\u0903"
        + "\u093b\u093b"
        + "\u093e\u0940"
        + "\u0949\u094c"
        + "\u094e\u094f"
        + "\u0982\u0983"
        + "\u09be\u09c0"
        + "\u09c7\u09c8"
        + "\u09cb\u09cc"
        + "\u09d7\u09d7"
        + "\u0a03\u0a03"
        + "\u0a3e\u0a40"
        + "\u0a83\u0a83"
        + "\u0abe\u0ac0"
        + "\u0ac9\u0ac9"
        + "\u0acb\u0acc"
        + "\u0b02\u0b03"
        + "\u0b3e\u0b3e"
        + "\u0b40\u0b40"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4c"
        + "\u0b57\u0b57"
        + "\u0bbe\u0bbf"
        + "\u0bc1\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcc"
        + "\u0bd7\u0bd7"
        + "\u0c01\u0c03"
        + "\u0c41\u0c44"
        + "\u0c82\u0c83"
        + "\u0cbe\u0cbe"
        + "\u0cc0\u0cc4"
        + "\u0cc7\u0cc8"
        + "\u0cca\u0ccb"
        + "\u0cd5\u0cd6"
        + "\u0d02\u0d03"
        + "\u0d3e\u0d40"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4c"
        + "\u0d57\u0d57"
        + "\u0d82\u0d83"
        + "\u0dcf\u0dd1"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df3"
        + "\u0f3e\u0f3f"
        + "\u0f7f\u0f7f"
        + "\u102b\u102c"
        + "\u1031\u1031"
        + "\u1038\u1038"
        + "\u103b\u103c"
        + "\u1056\u1057"
        + "\u1062\u1064"
        + "\u1067\u106d"
        + "\u1083\u1084"
        + "\u1087\u108c"
        + "\u108f\u108f"
        + "\u109a\u109c"
        + "\u17b6\u17b6"
        + "\u17be\u17c5"
        + "\u17c7\u17c8"
        + "\u1923\u1926"
        + "\u1929\u192b"
        + "\u1930\u1931"
        + "\u1933\u1938"
        + "\u19b0\u19c0"
        + "\u19c8\u19c9"
        + "\u1a19\u1a1a"
        + "\u1a55\u1a55"
        + "\u1a57\u1a57"
        + "\u1a61\u1a61"
        + "\u1a63\u1a64"
        + "\u1a6d\u1a72"
        + "\u1b04\u1b04"
        + "\u1b35\u1b35"
        + "\u1b3b\u1b3b"
        + "\u1b3d\u1b41"
        + "\u1b43\u1b44"
        + "\u1b82\u1b82"
        + "\u1ba1\u1ba1"
        + "\u1ba6\u1ba7"
        + "\u1baa\u1baa"
        + "\u1be7\u1be7"
        + "\u1bea\u1bec"
        + "\u1bee\u1bee"
        + "\u1bf2\u1bf3"
        + "\u1c24\u1c2b"
        + "\u1c34\u1c35"
        + "\u1ce1\u1ce1"
        + "\u1cf2\u1cf3"
        + "\u302e\u302f"
        + "\ua823\ua824"
        + "\ua827\ua827"
        + "\ua880\ua881"
        + "\ua8b4\ua8c3"
        + "\ua952\ua953"
        + "\ua983\ua983"
        + "\ua9b4\ua9b5"
        + "\ua9ba\ua9bb"
        + "\ua9bd\ua9c0"
        + "\uaa2f\uaa30"
        + "\uaa33\uaa34"
        + "\uaa4d\uaa4d"
        + "\uaa7b\uaa7b"
        + "\uaa7d\uaa7d"
        + "\uaaeb\uaaeb"
        + "\uaaee\uaaef"
        + "\uaaf5\uaaf5"
        + "\uabe3\uabe4"
        + "\uabe6\uabe7"
        + "\uabe9\uabea"
        + "\uabec\uabec"
        + "\ud804\udc00\ud804\udc00"
        + "\ud804\udc02\ud804\udc02"
        + "\ud804\udc82\ud804\udc82"
        + "\ud804\udcb0\ud804\udcb2"
        + "\ud804\udcb7\ud804\udcb8"
        + "\ud804\udd2c\ud804\udd2c"
        + "\ud804\udd82\ud804\udd82"
        + "\ud804\uddb3\ud804\uddb5"
        + "\ud804\uddbf\ud804\uddc0"
        + "\ud804\ude2c\ud804\ude2e"
        + "\ud804\ude32\ud804\ude33"
        + "\ud804\ude35\ud804\ude35"
        + "\ud804\udee0\ud804\udee2"
        + "\ud804\udf02\ud804\udf03"
        + "\ud804\udf3e\ud804\udf3f"
        + "\ud804\udf41\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf62\ud804\udf63"
        + "\ud805\udcb0\ud805\udcb2"
        + "\ud805\udcb9\ud805\udcb9"
        + "\ud805\udcbb\ud805\udcbe"
        + "\ud805\udcc1\ud805\udcc1"
        + "\ud805\uddaf\ud805\uddb1"
        + "\ud805\uddb8\ud805\uddbb"
        + "\ud805\uddbe\ud805\uddbe"
        + "\ud805\ude30\ud805\ude32"
        + "\ud805\ude3b\ud805\ude3c"
        + "\ud805\ude3e\ud805\ude3e"
        + "\ud805\udeac\ud805\udeac"
        + "\ud805\udeae\ud805\udeaf"
        + "\ud805\udeb6\ud805\udeb6"
        + "\ud81b\udf51\ud81b\udf7e"
        + "\ud834\udd65\ud834\udd66"
        + "\ud834\udd6d\ud834\udd72",
    // Unicode 7.0 property value: {me}
    "\u0488\u0489" + "\u1abe\u1abe" + "\u20dd\u20e0" + "\u20e2\u20e4" + "\ua670\ua672",
    // Unicode 7.0 property value: {meeteimayek}
    "\uaae0\uaaf6" + "\uabc0\uabed" + "\uabf0\uabf9",
    // Unicode 7.0 property value: {mendekikakui}
    "\ud83a\udc00\ud83a\udcc4" + "\ud83a\udcc7\ud83a\udcd6",
    // Unicode 7.0 property value: {meroiticcursive}
    "\ud802\udda0\ud802\uddb7" + "\ud802\uddbe\ud802\uddbf",
    // Unicode 7.0 property value: {meroitichieroglyphs}
    "\ud802\udd80\ud802\udd9f",
    // Unicode 7.0 property value: {miao}
    "\ud81b\udf00\ud81b\udf44" + "\ud81b\udf50\ud81b\udf7e" + "\ud81b\udf8f\ud81b\udf9f",
    // Unicode 7.0 property value: {mn}
    "\u0300\u036f"
        + "\u0483\u0487"
        + "\u0591\u05bd"
        + "\u05bf\u05bf"
        + "\u05c1\u05c2"
        + "\u05c4\u05c5"
        + "\u05c7\u05c7"
        + "\u0610\u061a"
        + "\u064b\u065f"
        + "\u0670\u0670"
        + "\u06d6\u06dc"
        + "\u06df\u06e4"
        + "\u06e7\u06e8"
        + "\u06ea\u06ed"
        + "\u0711\u0711"
        + "\u0730\u074a"
        + "\u07a6\u07b0"
        + "\u07eb\u07f3"
        + "\u0816\u0819"
        + "\u081b\u0823"
        + "\u0825\u0827"
        + "\u0829\u082d"
        + "\u0859\u085b"
        + "\u08e4\u0902"
        + "\u093a\u093a"
        + "\u093c\u093c"
        + "\u0941\u0948"
        + "\u094d\u094d"
        + "\u0951\u0957"
        + "\u0962\u0963"
        + "\u0981\u0981"
        + "\u09bc\u09bc"
        + "\u09c1\u09c4"
        + "\u09cd\u09cd"
        + "\u09e2\u09e3"
        + "\u0a01\u0a02"
        + "\u0a3c\u0a3c"
        + "\u0a41\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a70\u0a71"
        + "\u0a75\u0a75"
        + "\u0a81\u0a82"
        + "\u0abc\u0abc"
        + "\u0ac1\u0ac5"
        + "\u0ac7\u0ac8"
        + "\u0acd\u0acd"
        + "\u0ae2\u0ae3"
        + "\u0b01\u0b01"
        + "\u0b3c\u0b3c"
        + "\u0b3f\u0b3f"
        + "\u0b41\u0b44"
        + "\u0b4d\u0b4d"
        + "\u0b56\u0b56"
        + "\u0b62\u0b63"
        + "\u0b82\u0b82"
        + "\u0bc0\u0bc0"
        + "\u0bcd\u0bcd"
        + "\u0c00\u0c00"
        + "\u0c3e\u0c40"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c62\u0c63"
        + "\u0c81\u0c81"
        + "\u0cbc\u0cbc"
        + "\u0cbf\u0cbf"
        + "\u0cc6\u0cc6"
        + "\u0ccc\u0ccd"
        + "\u0ce2\u0ce3"
        + "\u0d01\u0d01"
        + "\u0d41\u0d44"
        + "\u0d4d\u0d4d"
        + "\u0d62\u0d63"
        + "\u0dca\u0dca"
        + "\u0dd2\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0e31\u0e31"
        + "\u0e34\u0e3a"
        + "\u0e47\u0e4e"
        + "\u0eb1\u0eb1"
        + "\u0eb4\u0eb9"
        + "\u0ebb\u0ebc"
        + "\u0ec8\u0ecd"
        + "\u0f18\u0f19"
        + "\u0f35\u0f35"
        + "\u0f37\u0f37"
        + "\u0f39\u0f39"
        + "\u0f71\u0f7e"
        + "\u0f80\u0f84"
        + "\u0f86\u0f87"
        + "\u0f8d\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fc6\u0fc6"
        + "\u102d\u1030"
        + "\u1032\u1037"
        + "\u1039\u103a"
        + "\u103d\u103e"
        + "\u1058\u1059"
        + "\u105e\u1060"
        + "\u1071\u1074"
        + "\u1082\u1082"
        + "\u1085\u1086"
        + "\u108d\u108d"
        + "\u109d\u109d"
        + "\u135d\u135f"
        + "\u1712\u1714"
        + "\u1732\u1734"
        + "\u1752\u1753"
        + "\u1772\u1773"
        + "\u17b4\u17b5"
        + "\u17b7\u17bd"
        + "\u17c6\u17c6"
        + "\u17c9\u17d3"
        + "\u17dd\u17dd"
        + "\u180b\u180d"
        + "\u18a9\u18a9"
        + "\u1920\u1922"
        + "\u1927\u1928"
        + "\u1932\u1932"
        + "\u1939\u193b"
        + "\u1a17\u1a18"
        + "\u1a1b\u1a1b"
        + "\u1a56\u1a56"
        + "\u1a58\u1a5e"
        + "\u1a60\u1a60"
        + "\u1a62\u1a62"
        + "\u1a65\u1a6c"
        + "\u1a73\u1a7c"
        + "\u1a7f\u1a7f"
        + "\u1ab0\u1abd"
        + "\u1b00\u1b03"
        + "\u1b34\u1b34"
        + "\u1b36\u1b3a"
        + "\u1b3c\u1b3c"
        + "\u1b42\u1b42"
        + "\u1b6b\u1b73"
        + "\u1b80\u1b81"
        + "\u1ba2\u1ba5"
        + "\u1ba8\u1ba9"
        + "\u1bab\u1bad"
        + "\u1be6\u1be6"
        + "\u1be8\u1be9"
        + "\u1bed\u1bed"
        + "\u1bef\u1bf1"
        + "\u1c2c\u1c33"
        + "\u1c36\u1c37"
        + "\u1cd0\u1cd2"
        + "\u1cd4\u1ce0"
        + "\u1ce2\u1ce8"
        + "\u1ced\u1ced"
        + "\u1cf4\u1cf4"
        + "\u1cf8\u1cf9"
        + "\u1dc0\u1df5"
        + "\u1dfc\u1dff"
        + "\u20d0\u20dc"
        + "\u20e1\u20e1"
        + "\u20e5\u20f0"
        + "\u2cef\u2cf1"
        + "\u2d7f\u2d7f"
        + "\u2de0\u2dff"
        + "\u302a\u302d"
        + "\u3099\u309a"
        + "\ua66f\ua66f"
        + "\ua674\ua67d"
        + "\ua69f\ua69f"
        + "\ua6f0\ua6f1"
        + "\ua802\ua802"
        + "\ua806\ua806"
        + "\ua80b\ua80b"
        + "\ua825\ua826"
        + "\ua8c4\ua8c4"
        + "\ua8e0\ua8f1"
        + "\ua926\ua92d"
        + "\ua947\ua951"
        + "\ua980\ua982"
        + "\ua9b3\ua9b3"
        + "\ua9b6\ua9b9"
        + "\ua9bc\ua9bc"
        + "\ua9e5\ua9e5"
        + "\uaa29\uaa2e"
        + "\uaa31\uaa32"
        + "\uaa35\uaa36"
        + "\uaa43\uaa43"
        + "\uaa4c\uaa4c"
        + "\uaa7c\uaa7c"
        + "\uaab0\uaab0"
        + "\uaab2\uaab4"
        + "\uaab7\uaab8"
        + "\uaabe\uaabf"
        + "\uaac1\uaac1"
        + "\uaaec\uaaed"
        + "\uaaf6\uaaf6"
        + "\uabe5\uabe5"
        + "\uabe8\uabe8"
        + "\uabed\uabed"
        + "\ufb1e\ufb1e"
        + "\ufe00\ufe0f"
        + "\ufe20\ufe2d"
        + "\ud800\uddfd\ud800\uddfd"
        + "\ud800\udee0\ud800\udee0"
        + "\ud800\udf76\ud800\udf7a"
        + "\ud802\ude01\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude0f"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude3f"
        + "\ud802\udee5\ud802\udee6"
        + "\ud804\udc01\ud804\udc01"
        + "\ud804\udc38\ud804\udc46"
        + "\ud804\udc7f\ud804\udc81"
        + "\ud804\udcb3\ud804\udcb6"
        + "\ud804\udcb9\ud804\udcba"
        + "\ud804\udd00\ud804\udd02"
        + "\ud804\udd27\ud804\udd2b"
        + "\ud804\udd2d\ud804\udd34"
        + "\ud804\udd73\ud804\udd73"
        + "\ud804\udd80\ud804\udd81"
        + "\ud804\uddb6\ud804\uddbe"
        + "\ud804\ude2f\ud804\ude31"
        + "\ud804\ude34\ud804\ude34"
        + "\ud804\ude36\ud804\ude37"
        + "\ud804\udedf\ud804\udedf"
        + "\ud804\udee3\ud804\udeea"
        + "\ud804\udf01\ud804\udf01"
        + "\ud804\udf3c\ud804\udf3c"
        + "\ud804\udf40\ud804\udf40"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udcb3\ud805\udcb8"
        + "\ud805\udcba\ud805\udcba"
        + "\ud805\udcbf\ud805\udcc0"
        + "\ud805\udcc2\ud805\udcc3"
        + "\ud805\uddb2\ud805\uddb5"
        + "\ud805\uddbc\ud805\uddbd"
        + "\ud805\uddbf\ud805\uddc0"
        + "\ud805\ude33\ud805\ude3a"
        + "\ud805\ude3d\ud805\ude3d"
        + "\ud805\ude3f\ud805\ude40"
        + "\ud805\udeab\ud805\udeab"
        + "\ud805\udead\ud805\udead"
        + "\ud805\udeb0\ud805\udeb5"
        + "\ud805\udeb7\ud805\udeb7"
        + "\ud81a\udef0\ud81a\udef4"
        + "\ud81a\udf30\ud81a\udf36"
        + "\ud81b\udf8f\ud81b\udf92"
        + "\ud82f\udc9d\ud82f\udc9e"
        + "\ud834\udd67\ud834\udd69"
        + "\ud834\udd7b\ud834\udd82"
        + "\ud834\udd85\ud834\udd8b"
        + "\ud834\uddaa\ud834\uddad"
        + "\ud834\ude42\ud834\ude44"
        + "\ud83a\udcd0\ud83a\udcd6"
        + "\udb40\udd00\udb40\uddef",
    // Unicode 7.0 property value: {modi}
    "\ud805\ude00\ud805\ude44" + "\ud805\ude50\ud805\ude59",
    // Unicode 7.0 property value: {mongolian}
    "\u1800\u1801"
        + "\u1804\u1804"
        + "\u1806\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa",
    // Unicode 7.0 property value: {mro}
    "\ud81a\ude40\ud81a\ude5e" + "\ud81a\ude60\ud81a\ude69" + "\ud81a\ude6e\ud81a\ude6f",
    // Unicode 7.0 property value: {myanmar}
    "\u1000\u109f" + "\ua9e0\ua9fe" + "\uaa60\uaa7f",
    // Unicode 7.0 property value: {nabataean}
    "\ud802\udc80\ud802\udc9e" + "\ud802\udca7\ud802\udcaf",
    // Unicode 7.0 property value: {nd}
    "\u0030\u0039"
        + "\u0660\u0669"
        + "\u06f0\u06f9"
        + "\u07c0\u07c9"
        + "\u0966\u096f"
        + "\u09e6\u09ef"
        + "\u0a66\u0a6f"
        + "\u0ae6\u0aef"
        + "\u0b66\u0b6f"
        + "\u0be6\u0bef"
        + "\u0c66\u0c6f"
        + "\u0ce6\u0cef"
        + "\u0d66\u0d6f"
        + "\u0de6\u0def"
        + "\u0e50\u0e59"
        + "\u0ed0\u0ed9"
        + "\u0f20\u0f29"
        + "\u1040\u1049"
        + "\u1090\u1099"
        + "\u17e0\u17e9"
        + "\u1810\u1819"
        + "\u1946\u194f"
        + "\u19d0\u19d9"
        + "\u1a80\u1a89"
        + "\u1a90\u1a99"
        + "\u1b50\u1b59"
        + "\u1bb0\u1bb9"
        + "\u1c40\u1c49"
        + "\u1c50\u1c59"
        + "\ua620\ua629"
        + "\ua8d0\ua8d9"
        + "\ua900\ua909"
        + "\ua9d0\ua9d9"
        + "\ua9f0\ua9f9"
        + "\uaa50\uaa59"
        + "\uabf0\uabf9"
        + "\uff10\uff19"
        + "\ud801\udca0\ud801\udca9"
        + "\ud804\udc66\ud804\udc6f"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd36\ud804\udd3f"
        + "\ud804\uddd0\ud804\uddd9"
        + "\ud804\udef0\ud804\udef9"
        + "\ud805\udcd0\ud805\udcd9"
        + "\ud805\ude50\ud805\ude59"
        + "\ud805\udec0\ud805\udec9"
        + "\ud806\udce0\ud806\udce9"
        + "\ud81a\ude60\ud81a\ude69"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud835\udfce\ud835\udfff",
    // Unicode 7.0 property value: {newtailue}
    "\u1980\u19ab" + "\u19b0\u19c9" + "\u19d0\u19da" + "\u19de\u19df",
    // Unicode 7.0 property value: {nko}
    "\u07c0\u07fa",
    // Unicode 7.0 property value: {nl}
    "\u16ee\u16f0"
        + "\u2160\u2182"
        + "\u2185\u2188"
        + "\u3007\u3007"
        + "\u3021\u3029"
        + "\u3038\u303a"
        + "\ua6e6\ua6ef"
        + "\ud800\udd40\ud800\udd74"
        + "\ud800\udf41\ud800\udf41"
        + "\ud800\udf4a\ud800\udf4a"
        + "\ud800\udfd1\ud800\udfd5"
        + "\ud809\udc00\ud809\udc6e",
    // Unicode 7.0 property value: {no}
    "\u00b2\u00b3"
        + "\u00b9\u00b9"
        + "\u00bc\u00be"
        + "\u09f4\u09f9"
        + "\u0b72\u0b77"
        + "\u0bf0\u0bf2"
        + "\u0c78\u0c7e"
        + "\u0d70\u0d75"
        + "\u0f2a\u0f33"
        + "\u1369\u137c"
        + "\u17f0\u17f9"
        + "\u19da\u19da"
        + "\u2070\u2070"
        + "\u2074\u2079"
        + "\u2080\u2089"
        + "\u2150\u215f"
        + "\u2189\u2189"
        + "\u2460\u249b"
        + "\u24ea\u24ff"
        + "\u2776\u2793"
        + "\u2cfd\u2cfd"
        + "\u3192\u3195"
        + "\u3220\u3229"
        + "\u3248\u324f"
        + "\u3251\u325f"
        + "\u3280\u3289"
        + "\u32b1\u32bf"
        + "\ua830\ua835"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd75\ud800\udd78"
        + "\ud800\udd8a\ud800\udd8b"
        + "\ud800\udee1\ud800\udefb"
        + "\ud800\udf20\ud800\udf23"
        + "\ud802\udc58\ud802\udc5f"
        + "\ud802\udc79\ud802\udc7f"
        + "\ud802\udca7\ud802\udcaf"
        + "\ud802\udd16\ud802\udd1b"
        + "\ud802\ude40\ud802\ude47"
        + "\ud802\ude7d\ud802\ude7e"
        + "\ud802\ude9d\ud802\ude9f"
        + "\ud802\udeeb\ud802\udeef"
        + "\ud802\udf58\ud802\udf5f"
        + "\ud802\udf78\ud802\udf7f"
        + "\ud802\udfa9\ud802\udfaf"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud804\udc52\ud804\udc65"
        + "\ud804\udde1\ud804\uddf4"
        + "\ud806\udcea\ud806\udcf2"
        + "\ud81a\udf5b\ud81a\udf61"
        + "\ud834\udf60\ud834\udf71"
        + "\ud83a\udcc7\ud83a\udccf"
        + "\ud83c\udd00\ud83c\udd0c",
    // Unicode 7.0 property value: {noncharactercodepoint}
    "\ufdd0\ufdef"
        + "\ufffe\uffff"
        + "\ud83f\udffe\ud83f\udfff"
        + "\ud87f\udffe\ud87f\udfff"
        + "\ud8bf\udffe\ud8bf\udfff"
        + "\ud8ff\udffe\ud8ff\udfff"
        + "\ud93f\udffe\ud93f\udfff"
        + "\ud97f\udffe\ud97f\udfff"
        + "\ud9bf\udffe\ud9bf\udfff"
        + "\ud9ff\udffe\ud9ff\udfff"
        + "\uda3f\udffe\uda3f\udfff"
        + "\uda7f\udffe\uda7f\udfff"
        + "\udabf\udffe\udabf\udfff"
        + "\udaff\udffe\udaff\udfff"
        + "\udb3f\udffe\udb3f\udfff"
        + "\udb7f\udffe\udb7f\udfff"
        + "\udbbf\udffe\udbbf\udfff"
        + "\udbff\udffe\udbff\udfff",
    // Unicode 7.0 property value: {ogham}
    "\u1680\u169c",
    // Unicode 7.0 property value: {olchiki}
    "\u1c50\u1c7f",
    // Unicode 7.0 property value: {olditalic}
    "\ud800\udf00\ud800\udf23",
    // Unicode 7.0 property value: {oldnortharabian}
    "\ud802\ude80\ud802\ude9f",
    // Unicode 7.0 property value: {oldpermic}
    "\ud800\udf50\ud800\udf7a",
    // Unicode 7.0 property value: {oldpersian}
    "\ud800\udfa0\ud800\udfc3" + "\ud800\udfc8\ud800\udfd5",
    // Unicode 7.0 property value: {oldsoutharabian}
    "\ud802\ude60\ud802\ude7f",
    // Unicode 7.0 property value: {oldturkic}
    "\ud803\udc00\ud803\udc48",
    // Unicode 7.0 property value: {oriya}
    "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b77",
    // Unicode 7.0 property value: {osmanya}
    "\ud801\udc80\ud801\udc9d" + "\ud801\udca0\ud801\udca9",
    // Unicode 7.0 property value: {otheralphabetic}
    "\u0345\u0345"
        + "\u05b0\u05bd"
        + "\u05bf\u05bf"
        + "\u05c1\u05c2"
        + "\u05c4\u05c5"
        + "\u05c7\u05c7"
        + "\u0610\u061a"
        + "\u064b\u0657"
        + "\u0659\u065f"
        + "\u0670\u0670"
        + "\u06d6\u06dc"
        + "\u06e1\u06e4"
        + "\u06e7\u06e8"
        + "\u06ed\u06ed"
        + "\u0711\u0711"
        + "\u0730\u073f"
        + "\u07a6\u07b0"
        + "\u0816\u0817"
        + "\u081b\u0823"
        + "\u0825\u0827"
        + "\u0829\u082c"
        + "\u08e4\u08e9"
        + "\u08f0\u0903"
        + "\u093a\u093b"
        + "\u093e\u094c"
        + "\u094e\u094f"
        + "\u0955\u0957"
        + "\u0962\u0963"
        + "\u0981\u0983"
        + "\u09be\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09cc"
        + "\u09d7\u09d7"
        + "\u09e2\u09e3"
        + "\u0a01\u0a03"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4c"
        + "\u0a51\u0a51"
        + "\u0a70\u0a71"
        + "\u0a75\u0a75"
        + "\u0a81\u0a83"
        + "\u0abe\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acc"
        + "\u0ae2\u0ae3"
        + "\u0b01\u0b03"
        + "\u0b3e\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4c"
        + "\u0b56\u0b57"
        + "\u0b62\u0b63"
        + "\u0b82\u0b82"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcc"
        + "\u0bd7\u0bd7"
        + "\u0c00\u0c03"
        + "\u0c3e\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4c"
        + "\u0c55\u0c56"
        + "\u0c62\u0c63"
        + "\u0c81\u0c83"
        + "\u0cbe\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccc"
        + "\u0cd5\u0cd6"
        + "\u0ce2\u0ce3"
        + "\u0d01\u0d03"
        + "\u0d3e\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4c"
        + "\u0d57\u0d57"
        + "\u0d62\u0d63"
        + "\u0d82\u0d83"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df3"
        + "\u0e31\u0e31"
        + "\u0e34\u0e3a"
        + "\u0e4d\u0e4d"
        + "\u0eb1\u0eb1"
        + "\u0eb4\u0eb9"
        + "\u0ebb\u0ebc"
        + "\u0ecd\u0ecd"
        + "\u0f71\u0f81"
        + "\u0f8d\u0f97"
        + "\u0f99\u0fbc"
        + "\u102b\u1036"
        + "\u1038\u1038"
        + "\u103b\u103e"
        + "\u1056\u1059"
        + "\u105e\u1060"
        + "\u1062\u1062"
        + "\u1067\u1068"
        + "\u1071\u1074"
        + "\u1082\u1086"
        + "\u109c\u109d"
        + "\u135f\u135f"
        + "\u1712\u1713"
        + "\u1732\u1733"
        + "\u1752\u1753"
        + "\u1772\u1773"
        + "\u17b6\u17c8"
        + "\u18a9\u18a9"
        + "\u1920\u192b"
        + "\u1930\u1938"
        + "\u19b0\u19c0"
        + "\u19c8\u19c9"
        + "\u1a17\u1a1b"
        + "\u1a55\u1a5e"
        + "\u1a61\u1a74"
        + "\u1b00\u1b04"
        + "\u1b35\u1b43"
        + "\u1b80\u1b82"
        + "\u1ba1\u1ba9"
        + "\u1bac\u1bad"
        + "\u1be7\u1bf1"
        + "\u1c24\u1c35"
        + "\u1cf2\u1cf3"
        + "\u1de7\u1df4"
        + "\u24b6\u24e9"
        + "\u2de0\u2dff"
        + "\ua674\ua67b"
        + "\ua69f\ua69f"
        + "\ua823\ua827"
        + "\ua880\ua881"
        + "\ua8b4\ua8c3"
        + "\ua926\ua92a"
        + "\ua947\ua952"
        + "\ua980\ua983"
        + "\ua9b4\ua9bf"
        + "\uaa29\uaa36"
        + "\uaa43\uaa43"
        + "\uaa4c\uaa4d"
        + "\uaab0\uaab0"
        + "\uaab2\uaab4"
        + "\uaab7\uaab8"
        + "\uaabe\uaabe"
        + "\uaaeb\uaaef"
        + "\uaaf5\uaaf5"
        + "\uabe3\uabea"
        + "\ufb1e\ufb1e"
        + "\ud800\udf76\ud800\udf7a"
        + "\ud802\ude01\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude0f"
        + "\ud804\udc00\ud804\udc02"
        + "\ud804\udc38\ud804\udc45"
        + "\ud804\udc82\ud804\udc82"
        + "\ud804\udcb0\ud804\udcb8"
        + "\ud804\udd00\ud804\udd02"
        + "\ud804\udd27\ud804\udd32"
        + "\ud804\udd80\ud804\udd82"
        + "\ud804\uddb3\ud804\uddbf"
        + "\ud804\ude2c\ud804\ude34"
        + "\ud804\ude37\ud804\ude37"
        + "\ud804\udedf\ud804\udee8"
        + "\ud804\udf01\ud804\udf03"
        + "\ud804\udf3e\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4c"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf62\ud804\udf63"
        + "\ud805\udcb0\ud805\udcc1"
        + "\ud805\uddaf\ud805\uddb5"
        + "\ud805\uddb8\ud805\uddbe"
        + "\ud805\ude30\ud805\ude3e"
        + "\ud805\ude40\ud805\ude40"
        + "\ud805\udeab\ud805\udeb5"
        + "\ud81a\udf30\ud81a\udf36"
        + "\ud81b\udf51\ud81b\udf7e"
        + "\ud82f\udc9e\ud82f\udc9e"
        + "\ud83c\udd30\ud83c\udd49"
        + "\ud83c\udd50\ud83c\udd69"
        + "\ud83c\udd70\ud83c\udd89",
    // Unicode 7.0 property value: {otherdefaultignorablecodepoint}
    "\u034f\u034f"
        + "\u115f\u1160"
        + "\u17b4\u17b5"
        + "\u2065\u2065"
        + "\u3164\u3164"
        + "\uffa0\uffa0"
        + "\ufff0\ufff8"
        + "\udb40\udc00\udb40\udc00"
        + "\udb40\udc02\udb40\udc1f"
        + "\udb40\udc80\udb40\udcff"
        + "\udb40\uddf0\udb43\udfff",
    // Unicode 7.0 property value: {othergraphemeextend}
    "\u09be\u09be"
        + "\u09d7\u09d7"
        + "\u0b3e\u0b3e"
        + "\u0b57\u0b57"
        + "\u0bbe\u0bbe"
        + "\u0bd7\u0bd7"
        + "\u0cc2\u0cc2"
        + "\u0cd5\u0cd6"
        + "\u0d3e\u0d3e"
        + "\u0d57\u0d57"
        + "\u0dcf\u0dcf"
        + "\u0ddf\u0ddf"
        + "\u200c\u200d"
        + "\u302e\u302f"
        + "\uff9e\uff9f"
        + "\ud804\udf3e\ud804\udf3e"
        + "\ud804\udf57\ud804\udf57"
        + "\ud805\udcb0\ud805\udcb0"
        + "\ud805\udcbd\ud805\udcbd"
        + "\ud805\uddaf\ud805\uddaf"
        + "\ud834\udd65\ud834\udd65"
        + "\ud834\udd6e\ud834\udd72",
    // Unicode 7.0 property value: {otheridcontinue}
    "\u00b7\u00b7" + "\u0387\u0387" + "\u1369\u1371" + "\u19da\u19da",
    // Unicode 7.0 property value: {otheridstart}
    "\u2118\u2118" + "\u212e\u212e" + "\u309b\u309c",
    // Unicode 7.0 property value: {otherlowercase}
    "\u00aa\u00aa"
        + "\u00ba\u00ba"
        + "\u02b0\u02b8"
        + "\u02c0\u02c1"
        + "\u02e0\u02e4"
        + "\u0345\u0345"
        + "\u037a\u037a"
        + "\u1d2c\u1d6a"
        + "\u1d78\u1d78"
        + "\u1d9b\u1dbf"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u2170\u217f"
        + "\u24d0\u24e9"
        + "\u2c7c\u2c7d"
        + "\ua69c\ua69d"
        + "\ua770\ua770"
        + "\ua7f8\ua7f9"
        + "\uab5c\uab5f",
    // Unicode 7.0 property value: {othermath}
    "\u005e\u005e"
        + "\u03d0\u03d2"
        + "\u03d5\u03d5"
        + "\u03f0\u03f1"
        + "\u03f4\u03f5"
        + "\u2016\u2016"
        + "\u2032\u2034"
        + "\u2040\u2040"
        + "\u2061\u2064"
        + "\u207d\u207e"
        + "\u208d\u208e"
        + "\u20d0\u20dc"
        + "\u20e1\u20e1"
        + "\u20e5\u20e6"
        + "\u20eb\u20ef"
        + "\u2102\u2102"
        + "\u2107\u2107"
        + "\u210a\u2113"
        + "\u2115\u2115"
        + "\u2119\u211d"
        + "\u2124\u2124"
        + "\u2128\u2129"
        + "\u212c\u212d"
        + "\u212f\u2131"
        + "\u2133\u2138"
        + "\u213c\u213f"
        + "\u2145\u2149"
        + "\u2195\u2199"
        + "\u219c\u219f"
        + "\u21a1\u21a2"
        + "\u21a4\u21a5"
        + "\u21a7\u21a7"
        + "\u21a9\u21ad"
        + "\u21b0\u21b1"
        + "\u21b6\u21b7"
        + "\u21bc\u21cd"
        + "\u21d0\u21d1"
        + "\u21d3\u21d3"
        + "\u21d5\u21db"
        + "\u21dd\u21dd"
        + "\u21e4\u21e5"
        + "\u2308\u230b"
        + "\u23b4\u23b5"
        + "\u23b7\u23b7"
        + "\u23d0\u23d0"
        + "\u23e2\u23e2"
        + "\u25a0\u25a1"
        + "\u25ae\u25b6"
        + "\u25bc\u25c0"
        + "\u25c6\u25c7"
        + "\u25ca\u25cb"
        + "\u25cf\u25d3"
        + "\u25e2\u25e2"
        + "\u25e4\u25e4"
        + "\u25e7\u25ec"
        + "\u2605\u2606"
        + "\u2640\u2640"
        + "\u2642\u2642"
        + "\u2660\u2663"
        + "\u266d\u266e"
        + "\u27c5\u27c6"
        + "\u27e6\u27ef"
        + "\u2983\u2998"
        + "\u29d8\u29db"
        + "\u29fc\u29fd"
        + "\ufe61\ufe61"
        + "\ufe63\ufe63"
        + "\ufe68\ufe68"
        + "\uff3c\uff3c"
        + "\uff3e\uff3e"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udec0"
        + "\ud835\udec2\ud835\udeda"
        + "\ud835\udedc\ud835\udefa"
        + "\ud835\udefc\ud835\udf14"
        + "\ud835\udf16\ud835\udf34"
        + "\ud835\udf36\ud835\udf4e"
        + "\ud835\udf50\ud835\udf6e"
        + "\ud835\udf70\ud835\udf88"
        + "\ud835\udf8a\ud835\udfa8"
        + "\ud835\udfaa\ud835\udfc2"
        + "\ud835\udfc4\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb",
    // Unicode 7.0 property value: {otheruppercase}
    "\u2160\u216f"
        + "\u24b6\u24cf"
        + "\ud83c\udd30\ud83c\udd49"
        + "\ud83c\udd50\ud83c\udd69"
        + "\ud83c\udd70\ud83c\udd89",
    // Unicode 7.0 property value: {pahawhhmong}
    "\ud81a\udf00\ud81a\udf45"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud81a\udf5b\ud81a\udf61"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f",
    // Unicode 7.0 property value: {palmyrene}
    "\ud802\udc60\ud802\udc7f",
    // Unicode 7.0 property value: {patternsyntax}
    "\u0021\u002f"
        + "\u003a\u0040"
        + "\u005b\u005e"
        + "\u0060\u0060"
        + "\u007b\u007e"
        + "\u00a1\u00a7"
        + "\u00a9\u00a9"
        + "\u00ab\u00ac"
        + "\u00ae\u00ae"
        + "\u00b0\u00b1"
        + "\u00b6\u00b6"
        + "\u00bb\u00bb"
        + "\u00bf\u00bf"
        + "\u00d7\u00d7"
        + "\u00f7\u00f7"
        + "\u2010\u2027"
        + "\u2030\u203e"
        + "\u2041\u2053"
        + "\u2055\u205e"
        + "\u2190\u245f"
        + "\u2500\u2775"
        + "\u2794\u2bff"
        + "\u2e00\u2e7f"
        + "\u3001\u3003"
        + "\u3008\u3020"
        + "\u3030\u3030"
        + "\ufd3e\ufd3f"
        + "\ufe45\ufe46",
    // Unicode 7.0 property value: {patternwhitespace}
    "\t\r" + "\u0020\u0020" + "\u0085\u0085" + "\u200e\u200f" + "\u2028\u2029",
    // Unicode 7.0 property value: {paucinhau}
    "\ud806\udec0\ud806\udef8",
    // Unicode 7.0 property value: {pc}
    "\u005f\u005f"
        + "\u203f\u2040"
        + "\u2054\u2054"
        + "\ufe33\ufe34"
        + "\ufe4d\ufe4f"
        + "\uff3f\uff3f",
    // Unicode 7.0 property value: {pd}
    "\u002d\u002d"
        + "\u058a\u058a"
        + "\u05be\u05be"
        + "\u1400\u1400"
        + "\u1806\u1806"
        + "\u2010\u2015"
        + "\u2e17\u2e17"
        + "\u2e1a\u2e1a"
        + "\u2e3a\u2e3b"
        + "\u2e40\u2e40"
        + "\u301c\u301c"
        + "\u3030\u3030"
        + "\u30a0\u30a0"
        + "\ufe31\ufe32"
        + "\ufe58\ufe58"
        + "\ufe63\ufe63"
        + "\uff0d\uff0d",
    // Unicode 7.0 property value: {pe}
    "\u0029\u0029"
        + "\u005d\u005d"
        + "\u007d\u007d"
        + "\u0f3b\u0f3b"
        + "\u0f3d\u0f3d"
        + "\u169c\u169c"
        + "\u2046\u2046"
        + "\u207e\u207e"
        + "\u208e\u208e"
        + "\u2309\u2309"
        + "\u230b\u230b"
        + "\u232a\u232a"
        + "\u2769\u2769"
        + "\u276b\u276b"
        + "\u276d\u276d"
        + "\u276f\u276f"
        + "\u2771\u2771"
        + "\u2773\u2773"
        + "\u2775\u2775"
        + "\u27c6\u27c6"
        + "\u27e7\u27e7"
        + "\u27e9\u27e9"
        + "\u27eb\u27eb"
        + "\u27ed\u27ed"
        + "\u27ef\u27ef"
        + "\u2984\u2984"
        + "\u2986\u2986"
        + "\u2988\u2988"
        + "\u298a\u298a"
        + "\u298c\u298c"
        + "\u298e\u298e"
        + "\u2990\u2990"
        + "\u2992\u2992"
        + "\u2994\u2994"
        + "\u2996\u2996"
        + "\u2998\u2998"
        + "\u29d9\u29d9"
        + "\u29db\u29db"
        + "\u29fd\u29fd"
        + "\u2e23\u2e23"
        + "\u2e25\u2e25"
        + "\u2e27\u2e27"
        + "\u2e29\u2e29"
        + "\u3009\u3009"
        + "\u300b\u300b"
        + "\u300d\u300d"
        + "\u300f\u300f"
        + "\u3011\u3011"
        + "\u3015\u3015"
        + "\u3017\u3017"
        + "\u3019\u3019"
        + "\u301b\u301b"
        + "\u301e\u301f"
        + "\ufd3e\ufd3e"
        + "\ufe18\ufe18"
        + "\ufe36\ufe36"
        + "\ufe38\ufe38"
        + "\ufe3a\ufe3a"
        + "\ufe3c\ufe3c"
        + "\ufe3e\ufe3e"
        + "\ufe40\ufe40"
        + "\ufe42\ufe42"
        + "\ufe44\ufe44"
        + "\ufe48\ufe48"
        + "\ufe5a\ufe5a"
        + "\ufe5c\ufe5c"
        + "\ufe5e\ufe5e"
        + "\uff09\uff09"
        + "\uff3d\uff3d"
        + "\uff5d\uff5d"
        + "\uff60\uff60"
        + "\uff63\uff63",
    // Unicode 7.0 property value: {pf}
    "\u00bb\u00bb"
        + "\u2019\u2019"
        + "\u201d\u201d"
        + "\u203a\u203a"
        + "\u2e03\u2e03"
        + "\u2e05\u2e05"
        + "\u2e0a\u2e0a"
        + "\u2e0d\u2e0d"
        + "\u2e1d\u2e1d"
        + "\u2e21\u2e21",
    // Unicode 7.0 property value: {phagspa}
    "\ua840\ua877",
    // Unicode 7.0 property value: {phoenician}
    "\ud802\udd00\ud802\udd1b" + "\ud802\udd1f\ud802\udd1f",
    // Unicode 7.0 property value: {pi}
    "\u00ab\u00ab"
        + "\u2018\u2018"
        + "\u201b\u201c"
        + "\u201f\u201f"
        + "\u2039\u2039"
        + "\u2e02\u2e02"
        + "\u2e04\u2e04"
        + "\u2e09\u2e09"
        + "\u2e0c\u2e0c"
        + "\u2e1c\u2e1c"
        + "\u2e20\u2e20",
    // Unicode 7.0 property value: {po}
    "\u0021\u0023"
        + "\u0025\u0027"
        + "\u002a\u002a"
        + "\u002c\u002c"
        + "\u002e\u002f"
        + "\u003a\u003b"
        + "\u003f\u0040"
        + "\\\\"
        + "\u00a1\u00a1"
        + "\u00a7\u00a7"
        + "\u00b6\u00b7"
        + "\u00bf\u00bf"
        + "\u037e\u037e"
        + "\u0387\u0387"
        + "\u055a\u055f"
        + "\u0589\u0589"
        + "\u05c0\u05c0"
        + "\u05c3\u05c3"
        + "\u05c6\u05c6"
        + "\u05f3\u05f4"
        + "\u0609\u060a"
        + "\u060c\u060d"
        + "\u061b\u061b"
        + "\u061e\u061f"
        + "\u066a\u066d"
        + "\u06d4\u06d4"
        + "\u0700\u070d"
        + "\u07f7\u07f9"
        + "\u0830\u083e"
        + "\u085e\u085e"
        + "\u0964\u0965"
        + "\u0970\u0970"
        + "\u0af0\u0af0"
        + "\u0df4\u0df4"
        + "\u0e4f\u0e4f"
        + "\u0e5a\u0e5b"
        + "\u0f04\u0f12"
        + "\u0f14\u0f14"
        + "\u0f85\u0f85"
        + "\u0fd0\u0fd4"
        + "\u0fd9\u0fda"
        + "\u104a\u104f"
        + "\u10fb\u10fb"
        + "\u1360\u1368"
        + "\u166d\u166e"
        + "\u16eb\u16ed"
        + "\u1735\u1736"
        + "\u17d4\u17d6"
        + "\u17d8\u17da"
        + "\u1800\u1805"
        + "\u1807\u180a"
        + "\u1944\u1945"
        + "\u1a1e\u1a1f"
        + "\u1aa0\u1aa6"
        + "\u1aa8\u1aad"
        + "\u1b5a\u1b60"
        + "\u1bfc\u1bff"
        + "\u1c3b\u1c3f"
        + "\u1c7e\u1c7f"
        + "\u1cc0\u1cc7"
        + "\u1cd3\u1cd3"
        + "\u2016\u2017"
        + "\u2020\u2027"
        + "\u2030\u2038"
        + "\u203b\u203e"
        + "\u2041\u2043"
        + "\u2047\u2051"
        + "\u2053\u2053"
        + "\u2055\u205e"
        + "\u2cf9\u2cfc"
        + "\u2cfe\u2cff"
        + "\u2d70\u2d70"
        + "\u2e00\u2e01"
        + "\u2e06\u2e08"
        + "\u2e0b\u2e0b"
        + "\u2e0e\u2e16"
        + "\u2e18\u2e19"
        + "\u2e1b\u2e1b"
        + "\u2e1e\u2e1f"
        + "\u2e2a\u2e2e"
        + "\u2e30\u2e39"
        + "\u2e3c\u2e3f"
        + "\u2e41\u2e41"
        + "\u3001\u3003"
        + "\u303d\u303d"
        + "\u30fb\u30fb"
        + "\ua4fe\ua4ff"
        + "\ua60d\ua60f"
        + "\ua673\ua673"
        + "\ua67e\ua67e"
        + "\ua6f2\ua6f7"
        + "\ua874\ua877"
        + "\ua8ce\ua8cf"
        + "\ua8f8\ua8fa"
        + "\ua92e\ua92f"
        + "\ua95f\ua95f"
        + "\ua9c1\ua9cd"
        + "\ua9de\ua9df"
        + "\uaa5c\uaa5f"
        + "\uaade\uaadf"
        + "\uaaf0\uaaf1"
        + "\uabeb\uabeb"
        + "\ufe10\ufe16"
        + "\ufe19\ufe19"
        + "\ufe30\ufe30"
        + "\ufe45\ufe46"
        + "\ufe49\ufe4c"
        + "\ufe50\ufe52"
        + "\ufe54\ufe57"
        + "\ufe5f\ufe61"
        + "\ufe68\ufe68"
        + "\ufe6a\ufe6b"
        + "\uff01\uff03"
        + "\uff05\uff07"
        + "\uff0a\uff0a"
        + "\uff0c\uff0c"
        + "\uff0e\uff0f"
        + "\uff1a\uff1b"
        + "\uff1f\uff20"
        + "\uff3c\uff3c"
        + "\uff61\uff61"
        + "\uff64\uff65"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udf9f\ud800\udf9f"
        + "\ud800\udfd0\ud800\udfd0"
        + "\ud801\udd6f\ud801\udd6f"
        + "\ud802\udc57\ud802\udc57"
        + "\ud802\udd1f\ud802\udd1f"
        + "\ud802\udd3f\ud802\udd3f"
        + "\ud802\ude50\ud802\ude58"
        + "\ud802\ude7f\ud802\ude7f"
        + "\ud802\udef0\ud802\udef6"
        + "\ud802\udf39\ud802\udf3f"
        + "\ud802\udf99\ud802\udf9c"
        + "\ud804\udc47\ud804\udc4d"
        + "\ud804\udcbb\ud804\udcbc"
        + "\ud804\udcbe\ud804\udcc1"
        + "\ud804\udd40\ud804\udd43"
        + "\ud804\udd74\ud804\udd75"
        + "\ud804\uddc5\ud804\uddc8"
        + "\ud804\uddcd\ud804\uddcd"
        + "\ud804\ude38\ud804\ude3d"
        + "\ud805\udcc6\ud805\udcc6"
        + "\ud805\uddc1\ud805\uddc9"
        + "\ud805\ude41\ud805\ude43"
        + "\ud809\udc70\ud809\udc74"
        + "\ud81a\ude6e\ud81a\ude6f"
        + "\ud81a\udef5\ud81a\udef5"
        + "\ud81a\udf37\ud81a\udf3b"
        + "\ud81a\udf44\ud81a\udf44"
        + "\ud82f\udc9f\ud82f\udc9f",
    // Unicode 7.0 property value: {print}
    "\u0020\u007e"
        + "\u00a0\u0377"
        + "\u037a\u037f"
        + "\u0384\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u052f"
        + "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u058d\u058f"
        + "\u0591\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\u0600\u061c"
        + "\u061e\u070d"
        + "\u070f\u074a"
        + "\u074d\u07b1"
        + "\u07c0\u07fa"
        + "\u0800\u082d"
        + "\u0830\u083e"
        + "\u0840\u085b"
        + "\u085e\u085e"
        + "\u08a0\u08b2"
        + "\u08e4\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fb"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0af1"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b77"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa"
        + "\u0c00\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c78\u0c7f"
        + "\u0c81\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d01\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d75"
        + "\u0d79\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0de6\u0def"
        + "\u0df2\u0df4"
        + "\u0e01\u0e3a"
        + "\u0e3f\u0e5b"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edf"
        + "\u0f00\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fce\u0fda"
        + "\u1000\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135d\u137c"
        + "\u1380\u1399"
        + "\u13a0\u13f4"
        + "\u1400\u169c"
        + "\u16a0\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1736"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17dd"
        + "\u17e0\u17e9"
        + "\u17f0\u17f9"
        + "\u1800\u180e"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19d0\u19da"
        + "\u19de\u1a1b"
        + "\u1a1e\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1a7f\u1a89"
        + "\u1a90\u1a99"
        + "\u1aa0\u1aad"
        + "\u1ab0\u1abe"
        + "\u1b00\u1b4b"
        + "\u1b50\u1b7c"
        + "\u1b80\u1bf3"
        + "\u1bfc\u1c37"
        + "\u1c3b\u1c49"
        + "\u1c4d\u1c7f"
        + "\u1cc0\u1cc7"
        + "\u1cd0\u1cf6"
        + "\u1cf8\u1cf9"
        + "\u1d00\u1df5"
        + "\u1dfc\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2000\u2027"
        + "\u202a\u2064"
        + "\u2066\u2071"
        + "\u2074\u208e"
        + "\u2090\u209c"
        + "\u20a0\u20bd"
        + "\u20d0\u20f0"
        + "\u2100\u2189"
        + "\u2190\u23fa"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u2b73"
        + "\u2b76\u2b95"
        + "\u2b98\u2bb9"
        + "\u2bbd\u2bc8"
        + "\u2bca\u2bd1"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2cf3"
        + "\u2cf9\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d70"
        + "\u2d7f\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2e42"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3000\u303f"
        + "\u3041\u3096"
        + "\u3099\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u3190\u31ba"
        + "\u31c0\u31e3"
        + "\u31f0\u321e"
        + "\u3220\u32fe"
        + "\u3300\u4db5"
        + "\u4dc0\u9fcc"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\ua4d0\ua62b"
        + "\ua640\ua69d"
        + "\ua69f\ua6f7"
        + "\ua700\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua82b"
        + "\ua830\ua839"
        + "\ua840\ua877"
        + "\ua880\ua8c4"
        + "\ua8ce\ua8d9"
        + "\ua8e0\ua8fb"
        + "\ua900\ua953"
        + "\ua95f\ua97c"
        + "\ua980\ua9cd"
        + "\ua9cf\ua9d9"
        + "\ua9de\ua9fe"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa5c\uaac2"
        + "\uaadb\uaaf6"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uab30\uab5f"
        + "\uab64\uab65"
        + "\uabc0\uabed"
        + "\uabf0\uabf9"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\ue000\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbc1"
        + "\ufbd3\ufd3f"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfd"
        + "\ufe00\ufe19"
        + "\ufe20\ufe2d"
        + "\ufe30\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ufeff\ufeff"
        + "\uff01\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ufffd"
        + "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd8c"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\udda0\ud800\udda0"
        + "\ud800\uddd0\ud800\uddfd"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udee0\ud800\udefb"
        + "\ud800\udf00\ud800\udf23"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf50\ud800\udf7a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udf9f\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\udd6f\ud801\udd6f"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc57\ud802\udc9e"
        + "\ud802\udca7\ud802\udcaf"
        + "\ud802\udd00\ud802\udd1b"
        + "\ud802\udd1f\ud802\udd39"
        + "\ud802\udd3f\ud802\udd3f"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58"
        + "\ud802\ude60\ud802\ude9f"
        + "\ud802\udec0\ud802\udee6"
        + "\ud802\udeeb\ud802\udef6"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf39\ud802\udf55"
        + "\ud802\udf58\ud802\udf72"
        + "\ud802\udf78\ud802\udf91"
        + "\ud802\udf99\ud802\udf9c"
        + "\ud802\udfa9\ud802\udfaf"
        + "\ud803\udc00\ud803\udc48"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud804\udc00\ud804\udc4d"
        + "\ud804\udc52\ud804\udc6f"
        + "\ud804\udc7f\ud804\udcc1"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd00\ud804\udd34"
        + "\ud804\udd36\ud804\udd43"
        + "\ud804\udd50\ud804\udd76"
        + "\ud804\udd80\ud804\uddc8"
        + "\ud804\uddcd\ud804\uddcd"
        + "\ud804\uddd0\ud804\uddda"
        + "\ud804\udde1\ud804\uddf4"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude3d"
        + "\ud804\udeb0\ud804\udeea"
        + "\ud804\udef0\ud804\udef9"
        + "\ud804\udf01\ud804\udf03"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3c\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf5d\ud804\udf63"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udc80\ud805\udcc7"
        + "\ud805\udcd0\ud805\udcd9"
        + "\ud805\udd80\ud805\uddb5"
        + "\ud805\uddb8\ud805\uddc9"
        + "\ud805\ude00\ud805\ude44"
        + "\ud805\ude50\ud805\ude59"
        + "\ud805\ude80\ud805\udeb7"
        + "\ud805\udec0\ud805\udec9"
        + "\ud806\udca0\ud806\udcf2"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud809\udc00\ud809\udc6e"
        + "\ud809\udc70\ud809\udc74"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\ude60\ud81a\ude69"
        + "\ud81a\ude6e\ud81a\ude6f"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udef0\ud81a\udef5"
        + "\ud81a\udf00\ud81a\udf45"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud81a\udf5b\ud81a\udf61"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf7e"
        + "\ud81b\udf8f\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud82f\udc9c\ud82f\udca3"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udddd"
        + "\ud834\ude00\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83a\udcc7\ud83a\udcd6"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83b\udef0\ud83b\udef1"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udca0\ud83c\udcae"
        + "\ud83c\udcb1\ud83c\udcbf"
        + "\ud83c\udcc1\ud83c\udccf"
        + "\ud83c\udcd1\ud83c\udcf5"
        + "\ud83c\udd00\ud83c\udd0c"
        + "\ud83c\udd10\ud83c\udd2e"
        + "\ud83c\udd30\ud83c\udd6b"
        + "\ud83c\udd70\ud83c\udd9a"
        + "\ud83c\udde6\ud83c\ude02"
        + "\ud83c\ude10\ud83c\ude3a"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83c\ude50\ud83c\ude51"
        + "\ud83c\udf00\ud83c\udf2c"
        + "\ud83c\udf30\ud83c\udf7d"
        + "\ud83c\udf80\ud83c\udfce"
        + "\ud83c\udfd4\ud83c\udff7"
        + "\ud83d\udc00\ud83d\udcfe"
        + "\ud83d\udd00\ud83d\udd4a"
        + "\ud83d\udd50\ud83d\udd79"
        + "\ud83d\udd7b\ud83d\udda3"
        + "\ud83d\udda5\ud83d\ude42"
        + "\ud83d\ude45\ud83d\udecf"
        + "\ud83d\udee0\ud83d\udeec"
        + "\ud83d\udef0\ud83d\udef3"
        + "\ud83d\udf00\ud83d\udf73"
        + "\ud83d\udf80\ud83d\udfd4"
        + "\ud83e\udc00\ud83e\udc0b"
        + "\ud83e\udc10\ud83e\udc47"
        + "\ud83e\udc50\ud83e\udc59"
        + "\ud83e\udc60\ud83e\udc87"
        + "\ud83e\udc90\ud83e\udcad"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f"
        + "\udb40\udd00\udb40\uddef"
        + "\udb80\udc00\udbbf\udffd"
        + "\udbc0\udc00\udbff\udffd",
    // Unicode 7.0 property value: {ps}
    "\u0028\u0028"
        + "\u005b\u005b"
        + "\u007b\u007b"
        + "\u0f3a\u0f3a"
        + "\u0f3c\u0f3c"
        + "\u169b\u169b"
        + "\u201a\u201a"
        + "\u201e\u201e"
        + "\u2045\u2045"
        + "\u207d\u207d"
        + "\u208d\u208d"
        + "\u2308\u2308"
        + "\u230a\u230a"
        + "\u2329\u2329"
        + "\u2768\u2768"
        + "\u276a\u276a"
        + "\u276c\u276c"
        + "\u276e\u276e"
        + "\u2770\u2770"
        + "\u2772\u2772"
        + "\u2774\u2774"
        + "\u27c5\u27c5"
        + "\u27e6\u27e6"
        + "\u27e8\u27e8"
        + "\u27ea\u27ea"
        + "\u27ec\u27ec"
        + "\u27ee\u27ee"
        + "\u2983\u2983"
        + "\u2985\u2985"
        + "\u2987\u2987"
        + "\u2989\u2989"
        + "\u298b\u298b"
        + "\u298d\u298d"
        + "\u298f\u298f"
        + "\u2991\u2991"
        + "\u2993\u2993"
        + "\u2995\u2995"
        + "\u2997\u2997"
        + "\u29d8\u29d8"
        + "\u29da\u29da"
        + "\u29fc\u29fc"
        + "\u2e22\u2e22"
        + "\u2e24\u2e24"
        + "\u2e26\u2e26"
        + "\u2e28\u2e28"
        + "\u2e42\u2e42"
        + "\u3008\u3008"
        + "\u300a\u300a"
        + "\u300c\u300c"
        + "\u300e\u300e"
        + "\u3010\u3010"
        + "\u3014\u3014"
        + "\u3016\u3016"
        + "\u3018\u3018"
        + "\u301a\u301a"
        + "\u301d\u301d"
        + "\ufd3f\ufd3f"
        + "\ufe17\ufe17"
        + "\ufe35\ufe35"
        + "\ufe37\ufe37"
        + "\ufe39\ufe39"
        + "\ufe3b\ufe3b"
        + "\ufe3d\ufe3d"
        + "\ufe3f\ufe3f"
        + "\ufe41\ufe41"
        + "\ufe43\ufe43"
        + "\ufe47\ufe47"
        + "\ufe59\ufe59"
        + "\ufe5b\ufe5b"
        + "\ufe5d\ufe5d"
        + "\uff08\uff08"
        + "\uff3b\uff3b"
        + "\uff5b\uff5b"
        + "\uff5f\uff5f"
        + "\uff62\uff62",
    // Unicode 7.0 property value: {psalterpahlavi}
    "\ud802\udf80\ud802\udf91" + "\ud802\udf99\ud802\udf9c" + "\ud802\udfa9\ud802\udfaf",
    // Unicode 7.0 property value: {quotationmark}
    "\"\""
        + "\u0027\u0027"
        + "\u00ab\u00ab"
        + "\u00bb\u00bb"
        + "\u2018\u201f"
        + "\u2039\u203a"
        + "\u2e42\u2e42"
        + "\u300c\u300f"
        + "\u301d\u301f"
        + "\ufe41\ufe44"
        + "\uff02\uff02"
        + "\uff07\uff07"
        + "\uff62\uff63",
    // Unicode 7.0 property value: {radical}
    "\u2e80\u2e99" + "\u2e9b\u2ef3" + "\u2f00\u2fd5",
    // Unicode 7.0 property value: {rejang}
    "\ua930\ua953" + "\ua95f\ua95f",
    // Unicode 7.0 property value: {runic}
    "\u16a0\u16ea" + "\u16ee\u16f8",
    // Unicode 7.0 property value: {samaritan}
    "\u0800\u082d" + "\u0830\u083e",
    // Unicode 7.0 property value: {saurashtra}
    "\ua880\ua8c4" + "\ua8ce\ua8d9",
    // Unicode 7.0 property value: {sc}
    "\u0024\u0024"
        + "\u00a2\u00a5"
        + "\u058f\u058f"
        + "\u060b\u060b"
        + "\u09f2\u09f3"
        + "\u09fb\u09fb"
        + "\u0af1\u0af1"
        + "\u0bf9\u0bf9"
        + "\u0e3f\u0e3f"
        + "\u17db\u17db"
        + "\u20a0\u20bd"
        + "\ua838\ua838"
        + "\ufdfc\ufdfc"
        + "\ufe69\ufe69"
        + "\uff04\uff04"
        + "\uffe0\uffe1"
        + "\uffe5\uffe6",
    // Unicode 7.0 property value: {scriptextensions=arabic}
    "\u0600\u0604"
        + "\u0606\u061b"
        + "\u061e\u06dc"
        + "\u06de\u06ff"
        + "\u0750\u077f"
        + "\u08a0\u08b2"
        + "\u08e4\u08ff"
        + "\ufb50\ufbc1"
        + "\ufbd3\ufd3d"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfd"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\ud800\udee0\ud800\udefb"
        + "\ud803\ude60\ud803\ude7e"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83b\udef0\ud83b\udef1",
    // Unicode 7.0 property value: {scriptextensions=armenian}
    "\u0531\u0556"
        + "\u0559\u055f"
        + "\u0561\u0587"
        + "\u0589\u058a"
        + "\u058d\u058f"
        + "\ufb13\ufb17",
    // Unicode 7.0 property value: {scriptextensions=avestan}
    "\ud802\udf00\ud802\udf35" + "\ud802\udf39\ud802\udf3f",
    // Unicode 7.0 property value: {scriptextensions=balinese}
    "\u1b00\u1b4b" + "\u1b50\u1b7c",
    // Unicode 7.0 property value: {scriptextensions=bamum}
    "\ua6a0\ua6f7" + "\ud81a\udc00\ud81a\ude38",
    // Unicode 7.0 property value: {scriptextensions=bassavah}
    "\ud81a\uded0\ud81a\udeed" + "\ud81a\udef0\ud81a\udef5",
    // Unicode 7.0 property value: {scriptextensions=batak}
    "\u1bc0\u1bf3" + "\u1bfc\u1bff",
    // Unicode 7.0 property value: {scriptextensions=bengali}
    "\u0964\u0965"
        + "\u0980\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09fb",
    // Unicode 7.0 property value: {scriptextensions=bopomofo}
    "\u02ea\u02eb"
        + "\u3001\u3003"
        + "\u3008\u3011"
        + "\u3013\u301f"
        + "\u302a\u302d"
        + "\u3030\u3030"
        + "\u3037\u3037"
        + "\u303e\u303f"
        + "\u30fb\u30fb"
        + "\u3105\u312d"
        + "\u31a0\u31ba"
        + "\u31c0\u31e3"
        + "\u3220\u3243"
        + "\u3280\u32b0"
        + "\u32c0\u32cb"
        + "\u3358\u3370"
        + "\u337b\u337f"
        + "\u33e0\u33fe"
        + "\ufe45\ufe46"
        + "\uff61\uff65",
    // Unicode 7.0 property value: {scriptextensions=brahmi}
    "\ud804\udc00\ud804\udc4d" + "\ud804\udc52\ud804\udc6f" + "\ud804\udc7f\ud804\udc7f",
    // Unicode 7.0 property value: {scriptextensions=braille}
    "\u2800\u28ff",
    // Unicode 7.0 property value: {scriptextensions=buginese}
    "\u1a00\u1a1b" + "\u1a1e\u1a1f" + "\ua9cf\ua9cf",
    // Unicode 7.0 property value: {scriptextensions=buhid}
    "\u1735\u1736" + "\u1740\u1753",
    // Unicode 7.0 property value: {scriptextensions=canadianaboriginal}
    "\u1400\u167f" + "\u18b0\u18f5",
    // Unicode 7.0 property value: {scriptextensions=carian}
    "\ud800\udea0\ud800\uded0",
    // Unicode 7.0 property value: {scriptextensions=caucasianalbanian}
    "\ud801\udd30\ud801\udd63" + "\ud801\udd6f\ud801\udd6f",
    // Unicode 7.0 property value: {scriptextensions=chakma}
    "\u09e6\u09ef" + "\u1040\u1049" + "\ud804\udd00\ud804\udd34" + "\ud804\udd36\ud804\udd43",
    // Unicode 7.0 property value: {scriptextensions=cham}
    "\uaa00\uaa36" + "\uaa40\uaa4d" + "\uaa50\uaa59" + "\uaa5c\uaa5f",
    // Unicode 7.0 property value: {scriptextensions=cherokee}
    "\u13a0\u13f4",
    // Unicode 7.0 property value: {scriptextensions=common}
    "\000\u0040"
        + "\u005b\u0060"
        + "\u007b\u00a9"
        + "\u00ab\u00b9"
        + "\u00bb\u00bf"
        + "\u00d7\u00d7"
        + "\u00f7\u00f7"
        + "\u02b9\u02df"
        + "\u02e5\u02e9"
        + "\u02ec\u02ff"
        + "\u0374\u0374"
        + "\u037e\u037e"
        + "\u0385\u0385"
        + "\u0387\u0387"
        + "\u0605\u0605"
        + "\u061c\u061c"
        + "\u06dd\u06dd"
        + "\u0e3f\u0e3f"
        + "\u0fd5\u0fd8"
        + "\u10fb\u10fb"
        + "\u16eb\u16ed"
        + "\u1cd3\u1cd3"
        + "\u1ce9\u1cec"
        + "\u1cee\u1cf1"
        + "\u1cf5\u1cf6"
        + "\u2000\u200b"
        + "\u200e\u2064"
        + "\u2066\u2070"
        + "\u2074\u207e"
        + "\u2080\u208e"
        + "\u20a0\u20bd"
        + "\u2100\u2125"
        + "\u2127\u2129"
        + "\u212c\u2131"
        + "\u2133\u214d"
        + "\u214f\u215f"
        + "\u2189\u2189"
        + "\u2190\u23fa"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u2460\u27ff"
        + "\u2900\u2b73"
        + "\u2b76\u2b95"
        + "\u2b98\u2bb9"
        + "\u2bbd\u2bc8"
        + "\u2bca\u2bd1"
        + "\u2e00\u2e42"
        + "\u2ff0\u2ffb"
        + "\u3000\u3000"
        + "\u3004\u3004"
        + "\u3012\u3012"
        + "\u3020\u3020"
        + "\u3036\u3036"
        + "\u3244\u325f"
        + "\u327f\u327f"
        + "\u32b1\u32bf"
        + "\u32cc\u32cf"
        + "\u3371\u337a"
        + "\u3380\u33df"
        + "\u33ff\u33ff"
        + "\u4dc0\u4dff"
        + "\ua700\ua721"
        + "\ua788\ua78a"
        + "\uab5b\uab5b"
        + "\ufd3e\ufd3f"
        + "\ufe10\ufe19"
        + "\ufe30\ufe44"
        + "\ufe47\ufe52"
        + "\ufe54\ufe66"
        + "\ufe68\ufe6b"
        + "\ufeff\ufeff"
        + "\uff01\uff20"
        + "\uff3b\uff40"
        + "\uff5b\uff60"
        + "\uffe0\uffe6"
        + "\uffe8\uffee"
        + "\ufff9\ufffd"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\uddd0\ud800\uddfc"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udd66"
        + "\ud834\udd6a\ud834\udd7a"
        + "\ud834\udd83\ud834\udd84"
        + "\ud834\udd8c\ud834\udda9"
        + "\ud834\uddae\ud834\udddd"
        + "\ud834\udf00\ud834\udf56"
        + "\ud834\udf60\ud834\udf71"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udca0\ud83c\udcae"
        + "\ud83c\udcb1\ud83c\udcbf"
        + "\ud83c\udcc1\ud83c\udccf"
        + "\ud83c\udcd1\ud83c\udcf5"
        + "\ud83c\udd00\ud83c\udd0c"
        + "\ud83c\udd10\ud83c\udd2e"
        + "\ud83c\udd30\ud83c\udd6b"
        + "\ud83c\udd70\ud83c\udd9a"
        + "\ud83c\udde6\ud83c\uddff"
        + "\ud83c\ude01\ud83c\ude02"
        + "\ud83c\ude10\ud83c\ude3a"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83c\ude50\ud83c\ude51"
        + "\ud83c\udf00\ud83c\udf2c"
        + "\ud83c\udf30\ud83c\udf7d"
        + "\ud83c\udf80\ud83c\udfce"
        + "\ud83c\udfd4\ud83c\udff7"
        + "\ud83d\udc00\ud83d\udcfe"
        + "\ud83d\udd00\ud83d\udd4a"
        + "\ud83d\udd50\ud83d\udd79"
        + "\ud83d\udd7b\ud83d\udda3"
        + "\ud83d\udda5\ud83d\ude42"
        + "\ud83d\ude45\ud83d\udecf"
        + "\ud83d\udee0\ud83d\udeec"
        + "\ud83d\udef0\ud83d\udef3"
        + "\ud83d\udf00\ud83d\udf73"
        + "\ud83d\udf80\ud83d\udfd4"
        + "\ud83e\udc00\ud83e\udc0b"
        + "\ud83e\udc10\ud83e\udc47"
        + "\ud83e\udc50\ud83e\udc59"
        + "\ud83e\udc60\ud83e\udc87"
        + "\ud83e\udc90\ud83e\udcad"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f",
    // Unicode 7.0 property value: {scriptextensions=coptic}
    "\u03e2\u03ef" + "\u2c80\u2cf3" + "\u2cf9\u2cff" + "\ud800\udee0\ud800\udefb",
    // Unicode 7.0 property value: {scriptextensions=cuneiform}
    "\ud808\udc00\ud808\udf98" + "\ud809\udc00\ud809\udc6e" + "\ud809\udc70\ud809\udc74",
    // Unicode 7.0 property value: {scriptextensions=cypriot}
    "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd3f"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc3f",
    // Unicode 7.0 property value: {scriptextensions=cyrillic}
    "\u0400\u052f"
        + "\u1d2b\u1d2b"
        + "\u1d78\u1d78"
        + "\u2de0\u2dff"
        + "\ua640\ua69d"
        + "\ua69f\ua69f",
    // Unicode 7.0 property value: {scriptextensions=deseret}
    "\ud801\udc00\ud801\udc4f",
    // Unicode 7.0 property value: {scriptextensions=devanagari}
    "\u0900\u097f"
        + "\u1cd0\u1cd2"
        + "\u1cd4\u1ce8"
        + "\u1ced\u1ced"
        + "\u1cf2\u1cf4"
        + "\u1cf8\u1cf9"
        + "\ua830\ua839"
        + "\ua8e0\ua8fb",
    // Unicode 7.0 property value: {scriptextensions=duployan}
    "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud82f\udc9c\ud82f\udca3",
    // Unicode 7.0 property value: {scriptextensions=egyptianhieroglyphs}
    "\ud80c\udc00\ud80d\udc2e",
    // Unicode 7.0 property value: {scriptextensions=elbasan}
    "\ud801\udd00\ud801\udd27",
    // Unicode 7.0 property value: {scriptextensions=ethiopic}
    "\u1200\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135d\u137c"
        + "\u1380\u1399"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e",
    // Unicode 7.0 property value: {scriptextensions=georgian}
    "\u0589\u0589"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u10fa"
        + "\u10fc\u10ff"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d",
    // Unicode 7.0 property value: {scriptextensions=glagolitic}
    "\u2c00\u2c2e" + "\u2c30\u2c5e",
    // Unicode 7.0 property value: {scriptextensions=gothic}
    "\ud800\udf30\ud800\udf4a",
    // Unicode 7.0 property value: {scriptextensions=grantha}
    "\u0964\u0965"
        + "\ud804\udf01\ud804\udf03"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3c\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf5d\ud804\udf63"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74",
    // Unicode 7.0 property value: {scriptextensions=greek}
    "\u0342\u0342"
        + "\u0345\u0345"
        + "\u0370\u0373"
        + "\u0375\u0377"
        + "\u037a\u037d"
        + "\u037f\u037f"
        + "\u0384\u0384"
        + "\u0386\u0386"
        + "\u0388\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03e1"
        + "\u03f0\u03ff"
        + "\u1d26\u1d2a"
        + "\u1d5d\u1d61"
        + "\u1d66\u1d6a"
        + "\u1dbf\u1dc1"
        + "\u1f00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fc4"
        + "\u1fc6\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fdd\u1fef"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffe"
        + "\u2126\u2126"
        + "\uab65\uab65"
        + "\ud800\udd40\ud800\udd8c"
        + "\ud800\udda0\ud800\udda0"
        + "\ud834\ude00\ud834\ude45",
    // Unicode 7.0 property value: {scriptextensions=gujarati}
    "\u0964\u0965"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0af1"
        + "\ua830\ua839",
    // Unicode 7.0 property value: {scriptextensions=gurmukhi}
    "\u0964\u0965"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\ua830\ua839",
    // Unicode 7.0 property value: {scriptextensions=han}
    "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u3001\u3003"
        + "\u3005\u3011"
        + "\u3013\u301f"
        + "\u3021\u302d"
        + "\u3030\u3030"
        + "\u3037\u303f"
        + "\u30fb\u30fb"
        + "\u3190\u319f"
        + "\u31c0\u31e3"
        + "\u3220\u3243"
        + "\u3280\u32b0"
        + "\u32c0\u32cb"
        + "\u3358\u3370"
        + "\u337b\u337f"
        + "\u33e0\u33fe"
        + "\u3400\u4db5"
        + "\u4e00\u9fcc"
        + "\uf900\ufa6d"
        + "\ufa70\ufad9"
        + "\ufe45\ufe46"
        + "\uff61\uff65"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d",
    // Unicode 7.0 property value: {scriptextensions=hangul}
    "\u1100\u11ff"
        + "\u3001\u3003"
        + "\u3008\u3011"
        + "\u3013\u301f"
        + "\u302e\u3030"
        + "\u3037\u3037"
        + "\u303e\u303f"
        + "\u30fb\u30fb"
        + "\u3131\u318e"
        + "\u31c0\u31e3"
        + "\u3200\u321e"
        + "\u3220\u3243"
        + "\u3260\u327e"
        + "\u3280\u32b0"
        + "\u32c0\u32cb"
        + "\u3358\u3370"
        + "\u337b\u337f"
        + "\u33e0\u33fe"
        + "\ua960\ua97c"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\ufe45\ufe46"
        + "\uff61\uff65"
        + "\uffa0\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc",
    // Unicode 7.0 property value: {scriptextensions=hanunoo}
    "\u1720\u1736",
    // Unicode 7.0 property value: {scriptextensions=hebrew}
    "\u0591\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f4"
        + "\ufb1d\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufb4f",
    // Unicode 7.0 property value: {scriptextensions=hiragana}
    "\u3001\u3003"
        + "\u3006\u3006"
        + "\u3008\u3011"
        + "\u3013\u301f"
        + "\u3030\u3035"
        + "\u3037\u3037"
        + "\u303c\u303f"
        + "\u3041\u3096"
        + "\u3099\u30a0"
        + "\u30fb\u30fc"
        + "\u3190\u319f"
        + "\u31c0\u31e3"
        + "\u3220\u3243"
        + "\u3280\u32b0"
        + "\u32c0\u32cb"
        + "\u3358\u3370"
        + "\u337b\u337f"
        + "\u33e0\u33fe"
        + "\ufe45\ufe46"
        + "\uff61\uff65"
        + "\uff70\uff70"
        + "\uff9e\uff9f"
        + "\ud82c\udc01\ud82c\udc01"
        + "\ud83c\ude00\ud83c\ude00",
    // Unicode 7.0 property value: {scriptextensions=imperialaramaic}
    "\ud802\udc40\ud802\udc55" + "\ud802\udc57\ud802\udc5f",
    // Unicode 7.0 property value: {scriptextensions=inherited}
    "\u0300\u0341"
        + "\u0343\u0344"
        + "\u0346\u0362"
        + "\u1ab0\u1abe"
        + "\u1dc2\u1df5"
        + "\u1dfc\u1dff"
        + "\u200c\u200d"
        + "\u20d0\u20f0"
        + "\ufe00\ufe0f"
        + "\ufe20\ufe2d"
        + "\ud800\uddfd\ud800\uddfd"
        + "\ud834\udd67\ud834\udd69"
        + "\ud834\udd7b\ud834\udd82"
        + "\ud834\udd85\ud834\udd8b"
        + "\ud834\uddaa\ud834\uddad"
        + "\udb40\udd00\udb40\uddef",
    // Unicode 7.0 property value: {scriptextensions=inscriptionalpahlavi}
    "\ud802\udf60\ud802\udf72" + "\ud802\udf78\ud802\udf7f",
    // Unicode 7.0 property value: {scriptextensions=inscriptionalparthian}
    "\ud802\udf40\ud802\udf55" + "\ud802\udf58\ud802\udf5f",
    // Unicode 7.0 property value: {scriptextensions=javanese}
    "\ua980\ua9cd" + "\ua9cf\ua9d9" + "\ua9de\ua9df",
    // Unicode 7.0 property value: {scriptextensions=kaithi}
    "\u0966\u096f" + "\ua830\ua839" + "\ud804\udc80\ud804\udcc1",
    // Unicode 7.0 property value: {scriptextensions=kannada}
    "\u0964\u0965"
        + "\u0c81\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2",
    // Unicode 7.0 property value: {scriptextensions=katakana}
    "\u3001\u3003"
        + "\u3006\u3006"
        + "\u3008\u3011"
        + "\u3013\u301f"
        + "\u3030\u3035"
        + "\u3037\u3037"
        + "\u303c\u303f"
        + "\u3099\u309c"
        + "\u30a0\u30ff"
        + "\u3190\u319f"
        + "\u31c0\u31e3"
        + "\u31f0\u31ff"
        + "\u3220\u3243"
        + "\u3280\u32b0"
        + "\u32c0\u32cb"
        + "\u32d0\u32fe"
        + "\u3300\u3370"
        + "\u337b\u337f"
        + "\u33e0\u33fe"
        + "\ufe45\ufe46"
        + "\uff61\uff9f"
        + "\ud82c\udc00\ud82c\udc00",
    // Unicode 7.0 property value: {scriptextensions=kayahli}
    "\ua900\ua92f",
    // Unicode 7.0 property value: {scriptextensions=kharoshthi}
    "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude47"
        + "\ud802\ude50\ud802\ude58",
    // Unicode 7.0 property value: {scriptextensions=khmer}
    "\u1780\u17dd" + "\u17e0\u17e9" + "\u17f0\u17f9" + "\u19e0\u19ff",
    // Unicode 7.0 property value: {scriptextensions=khojki}
    "\u0ae6\u0aef" + "\ud804\ude00\ud804\ude11" + "\ud804\ude13\ud804\ude3d",
    // Unicode 7.0 property value: {scriptextensions=khudawadi}
    "\u0964\u0965" + "\ua830\ua839" + "\ud804\udeb0\ud804\udeea" + "\ud804\udef0\ud804\udef9",
    // Unicode 7.0 property value: {scriptextensions=lao}
    "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edf",
    // Unicode 7.0 property value: {scriptextensions=latin}
    "\u0041\u005a"
        + "\u0061\u007a"
        + "\u00aa\u00aa"
        + "\u00ba\u00ba"
        + "\u00c0\u00d6"
        + "\u00d8\u00f6"
        + "\u00f8\u02b8"
        + "\u02e0\u02e4"
        + "\u0363\u036f"
        + "\u0485\u0486"
        + "\u0951\u0952"
        + "\u1d00\u1d25"
        + "\u1d2c\u1d5c"
        + "\u1d62\u1d65"
        + "\u1d6b\u1d77"
        + "\u1d79\u1dbe"
        + "\u1e00\u1eff"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u212a\u212b"
        + "\u2132\u2132"
        + "\u214e\u214e"
        + "\u2160\u2188"
        + "\u2c60\u2c7f"
        + "\ua722\ua787"
        + "\ua78b\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua7ff"
        + "\ua92e\ua92e"
        + "\uab30\uab5a"
        + "\uab5c\uab5f"
        + "\uab64\uab64"
        + "\ufb00\ufb06"
        + "\uff21\uff3a"
        + "\uff41\uff5a",
    // Unicode 7.0 property value: {scriptextensions=lepcha}
    "\u1c00\u1c37" + "\u1c3b\u1c49" + "\u1c4d\u1c4f",
    // Unicode 7.0 property value: {scriptextensions=limbu}
    "\u0965\u0965"
        + "\u1900\u191e"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1940\u1940"
        + "\u1944\u194f",
    // Unicode 7.0 property value: {scriptextensions=lineara}
    "\ud801\ude00\ud801\udf36" + "\ud801\udf40\ud801\udf55" + "\ud801\udf60\ud801\udf67",
    // Unicode 7.0 property value: {scriptextensions=linearb}
    "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd00\ud800\udd02"
        + "\ud800\udd07\ud800\udd33"
        + "\ud800\udd37\ud800\udd3f",
    // Unicode 7.0 property value: {scriptextensions=lisu}
    "\ua4d0\ua4ff",
    // Unicode 7.0 property value: {scriptextensions=lycian}
    "\ud800\ude80\ud800\ude9c",
    // Unicode 7.0 property value: {scriptextensions=lydian}
    "\ud802\udd20\ud802\udd39" + "\ud802\udd3f\ud802\udd3f",
    // Unicode 7.0 property value: {scriptextensions=mahajani}
    "\u0964\u096f" + "\ua830\ua839" + "\ud804\udd50\ud804\udd76",
    // Unicode 7.0 property value: {scriptextensions=malayalam}
    "\u0964\u0965"
        + "\u0d01\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d75"
        + "\u0d79\u0d7f",
    // Unicode 7.0 property value: {scriptextensions=mandaic}
    "\u0640\u0640" + "\u0840\u085b" + "\u085e\u085e",
    // Unicode 7.0 property value: {scriptextensions=manichaean}
    "\u0640\u0640" + "\ud802\udec0\ud802\udee6" + "\ud802\udeeb\ud802\udef6",
    // Unicode 7.0 property value: {scriptextensions=meeteimayek}
    "\uaae0\uaaf6" + "\uabc0\uabed" + "\uabf0\uabf9",
    // Unicode 7.0 property value: {scriptextensions=mendekikakui}
    "\ud83a\udc00\ud83a\udcc4" + "\ud83a\udcc7\ud83a\udcd6",
    // Unicode 7.0 property value: {scriptextensions=meroiticcursive}
    "\ud802\udda0\ud802\uddb7" + "\ud802\uddbe\ud802\uddbf",
    // Unicode 7.0 property value: {scriptextensions=meroitichieroglyphs}
    "\ud802\udd80\ud802\udd9f",
    // Unicode 7.0 property value: {scriptextensions=miao}
    "\ud81b\udf00\ud81b\udf44" + "\ud81b\udf50\ud81b\udf7e" + "\ud81b\udf8f\ud81b\udf9f",
    // Unicode 7.0 property value: {scriptextensions=modi}
    "\ua830\ua839" + "\ud805\ude00\ud805\ude44" + "\ud805\ude50\ud805\ude59",
    // Unicode 7.0 property value: {scriptextensions=mongolian}
    "\u1800\u180e" + "\u1810\u1819" + "\u1820\u1877" + "\u1880\u18aa",
    // Unicode 7.0 property value: {scriptextensions=mro}
    "\ud81a\ude40\ud81a\ude5e" + "\ud81a\ude60\ud81a\ude69" + "\ud81a\ude6e\ud81a\ude6f",
    // Unicode 7.0 property value: {scriptextensions=myanmar}
    "\u1000\u109f" + "\ua92e\ua92e" + "\ua9e0\ua9fe" + "\uaa60\uaa7f",
    // Unicode 7.0 property value: {scriptextensions=nabataean}
    "\ud802\udc80\ud802\udc9e" + "\ud802\udca7\ud802\udcaf",
    // Unicode 7.0 property value: {scriptextensions=newtailue}
    "\u1980\u19ab" + "\u19b0\u19c9" + "\u19d0\u19da" + "\u19de\u19df",
    // Unicode 7.0 property value: {scriptextensions=nko}
    "\u07c0\u07fa",
    // Unicode 7.0 property value: {scriptextensions=ogham}
    "\u1680\u169c",
    // Unicode 7.0 property value: {scriptextensions=olchiki}
    "\u1c50\u1c7f",
    // Unicode 7.0 property value: {scriptextensions=olditalic}
    "\ud800\udf00\ud800\udf23",
    // Unicode 7.0 property value: {scriptextensions=oldnortharabian}
    "\ud802\ude80\ud802\ude9f",
    // Unicode 7.0 property value: {scriptextensions=oldpermic}
    "\ud800\udf50\ud800\udf7a",
    // Unicode 7.0 property value: {scriptextensions=oldpersian}
    "\ud800\udfa0\ud800\udfc3" + "\ud800\udfc8\ud800\udfd5",
    // Unicode 7.0 property value: {scriptextensions=oldsoutharabian}
    "\ud802\ude60\ud802\ude7f",
    // Unicode 7.0 property value: {scriptextensions=oldturkic}
    "\ud803\udc00\ud803\udc48",
    // Unicode 7.0 property value: {scriptextensions=oriya}
    "\u0964\u0965"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b77",
    // Unicode 7.0 property value: {scriptextensions=osmanya}
    "\ud801\udc80\ud801\udc9d" + "\ud801\udca0\ud801\udca9",
    // Unicode 7.0 property value: {scriptextensions=pahawhhmong}
    "\ud81a\udf00\ud81a\udf45"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud81a\udf5b\ud81a\udf61"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f",
    // Unicode 7.0 property value: {scriptextensions=palmyrene}
    "\ud802\udc60\ud802\udc7f",
    // Unicode 7.0 property value: {scriptextensions=paucinhau}
    "\ud806\udec0\ud806\udef8",
    // Unicode 7.0 property value: {scriptextensions=phagspa}
    "\u1802\u1803" + "\u1805\u1805" + "\ua840\ua877",
    // Unicode 7.0 property value: {scriptextensions=phoenician}
    "\ud802\udd00\ud802\udd1b" + "\ud802\udd1f\ud802\udd1f",
    // Unicode 7.0 property value: {scriptextensions=psalterpahlavi}
    "\u0640\u0640"
        + "\ud802\udf80\ud802\udf91"
        + "\ud802\udf99\ud802\udf9c"
        + "\ud802\udfa9\ud802\udfaf",
    // Unicode 7.0 property value: {scriptextensions=rejang}
    "\ua930\ua953" + "\ua95f\ua95f",
    // Unicode 7.0 property value: {scriptextensions=runic}
    "\u16a0\u16ea" + "\u16ee\u16f8",
    // Unicode 7.0 property value: {scriptextensions=samaritan}
    "\u0800\u082d" + "\u0830\u083e",
    // Unicode 7.0 property value: {scriptextensions=saurashtra}
    "\ua880\ua8c4" + "\ua8ce\ua8d9",
    // Unicode 7.0 property value: {scriptextensions=sharada}
    "\ud804\udd80\ud804\uddc8" + "\ud804\uddcd\ud804\uddcd" + "\ud804\uddd0\ud804\uddda",
    // Unicode 7.0 property value: {scriptextensions=shavian}
    "\ud801\udc50\ud801\udc7f",
    // Unicode 7.0 property value: {scriptextensions=siddham}
    "\ud805\udd80\ud805\uddb5" + "\ud805\uddb8\ud805\uddc9",
    // Unicode 7.0 property value: {scriptextensions=sinhala}
    "\u0964\u0965"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0de6\u0def"
        + "\u0df2\u0df4"
        + "\ud804\udde1\ud804\uddf4",
    // Unicode 7.0 property value: {scriptextensions=sorasompeng}
    "\ud804\udcd0\ud804\udce8" + "\ud804\udcf0\ud804\udcf9",
    // Unicode 7.0 property value: {scriptextensions=sundanese}
    "\u1b80\u1bbf" + "\u1cc0\u1cc7",
    // Unicode 7.0 property value: {scriptextensions=sylotinagri}
    "\u0964\u0965" + "\u09e6\u09ef" + "\ua800\ua82b",
    // Unicode 7.0 property value: {scriptextensions=syriac}
    "\u060c\u060c"
        + "\u061b\u061b"
        + "\u061f\u061f"
        + "\u0640\u0640"
        + "\u064b\u0655"
        + "\u0670\u0670"
        + "\u0700\u070d"
        + "\u070f\u074a"
        + "\u074d\u074f",
    // Unicode 7.0 property value: {scriptextensions=tagalog}
    "\u1700\u170c" + "\u170e\u1714" + "\u1735\u1736",
    // Unicode 7.0 property value: {scriptextensions=tagbanwa}
    "\u1735\u1736" + "\u1760\u176c" + "\u176e\u1770" + "\u1772\u1773",
    // Unicode 7.0 property value: {scriptextensions=taile}
    "\u1040\u1049" + "\u1950\u196d" + "\u1970\u1974",
    // Unicode 7.0 property value: {scriptextensions=taitham}
    "\u1a20\u1a5e" + "\u1a60\u1a7c" + "\u1a7f\u1a89" + "\u1a90\u1a99" + "\u1aa0\u1aad",
    // Unicode 7.0 property value: {scriptextensions=taiviet}
    "\uaa80\uaac2" + "\uaadb\uaadf",
    // Unicode 7.0 property value: {scriptextensions=takri}
    "\u0964\u0965" + "\ua830\ua839" + "\ud805\ude80\ud805\udeb7" + "\ud805\udec0\ud805\udec9",
    // Unicode 7.0 property value: {scriptextensions=tamil}
    "\u0964\u0965"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa",
    // Unicode 7.0 property value: {scriptextensions=telugu}
    "\u0964\u0965"
        + "\u0c00\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c78\u0c7f",
    // Unicode 7.0 property value: {scriptextensions=thaana}
    "\u060c\u060c"
        + "\u061b\u061b"
        + "\u061f\u061f"
        + "\u0660\u0669"
        + "\u0780\u07b1"
        + "\ufdf2\ufdf2"
        + "\ufdfd\ufdfd",
    // Unicode 7.0 property value: {scriptextensions=thai}
    "\u0e01\u0e3a" + "\u0e40\u0e5b",
    // Unicode 7.0 property value: {scriptextensions=tibetan}
    "\u0f00\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fce\u0fd4"
        + "\u0fd9\u0fda",
    // Unicode 7.0 property value: {scriptextensions=tifinagh}
    "\u2d30\u2d67" + "\u2d6f\u2d70" + "\u2d7f\u2d7f",
    // Unicode 7.0 property value: {scriptextensions=tirhuta}
    "\u0964\u0965" + "\ua830\ua839" + "\ud805\udc80\ud805\udcc7" + "\ud805\udcd0\ud805\udcd9",
    // Unicode 7.0 property value: {scriptextensions=ugaritic}
    "\ud800\udf80\ud800\udf9d" + "\ud800\udf9f\ud800\udf9f",
    // Unicode 7.0 property value: {scriptextensions=unknown}
    "\u0378\u0379"
        + "\u0380\u0383"
        + "\u038b\u038b"
        + "\u038d\u038d"
        + "\u03a2\u03a2"
        + "\u0530\u0530"
        + "\u0557\u0558"
        + "\u0560\u0560"
        + "\u0588\u0588"
        + "\u058b\u058c"
        + "\u0590\u0590"
        + "\u05c8\u05cf"
        + "\u05eb\u05ef"
        + "\u05f5\u05ff"
        + "\u061d\u061d"
        + "\u070e\u070e"
        + "\u074b\u074c"
        + "\u07b2\u07bf"
        + "\u07fb\u07ff"
        + "\u082e\u082f"
        + "\u083f\u083f"
        + "\u085c\u085d"
        + "\u085f\u089f"
        + "\u08b3\u08e3"
        + "\u0984\u0984"
        + "\u098d\u098e"
        + "\u0991\u0992"
        + "\u09a9\u09a9"
        + "\u09b1\u09b1"
        + "\u09b3\u09b5"
        + "\u09ba\u09bb"
        + "\u09c5\u09c6"
        + "\u09c9\u09ca"
        + "\u09cf\u09d6"
        + "\u09d8\u09db"
        + "\u09de\u09de"
        + "\u09e4\u09e5"
        + "\u09fc\u0a00"
        + "\u0a04\u0a04"
        + "\u0a0b\u0a0e"
        + "\u0a11\u0a12"
        + "\u0a29\u0a29"
        + "\u0a31\u0a31"
        + "\u0a34\u0a34"
        + "\u0a37\u0a37"
        + "\u0a3a\u0a3b"
        + "\u0a3d\u0a3d"
        + "\u0a43\u0a46"
        + "\u0a49\u0a4a"
        + "\u0a4e\u0a50"
        + "\u0a52\u0a58"
        + "\u0a5d\u0a5d"
        + "\u0a5f\u0a65"
        + "\u0a76\u0a80"
        + "\u0a84\u0a84"
        + "\u0a8e\u0a8e"
        + "\u0a92\u0a92"
        + "\u0aa9\u0aa9"
        + "\u0ab1\u0ab1"
        + "\u0ab4\u0ab4"
        + "\u0aba\u0abb"
        + "\u0ac6\u0ac6"
        + "\u0aca\u0aca"
        + "\u0ace\u0acf"
        + "\u0ad1\u0adf"
        + "\u0ae4\u0ae5"
        + "\u0af2\u0b00"
        + "\u0b04\u0b04"
        + "\u0b0d\u0b0e"
        + "\u0b11\u0b12"
        + "\u0b29\u0b29"
        + "\u0b31\u0b31"
        + "\u0b34\u0b34"
        + "\u0b3a\u0b3b"
        + "\u0b45\u0b46"
        + "\u0b49\u0b4a"
        + "\u0b4e\u0b55"
        + "\u0b58\u0b5b"
        + "\u0b5e\u0b5e"
        + "\u0b64\u0b65"
        + "\u0b78\u0b81"
        + "\u0b84\u0b84"
        + "\u0b8b\u0b8d"
        + "\u0b91\u0b91"
        + "\u0b96\u0b98"
        + "\u0b9b\u0b9b"
        + "\u0b9d\u0b9d"
        + "\u0ba0\u0ba2"
        + "\u0ba5\u0ba7"
        + "\u0bab\u0bad"
        + "\u0bba\u0bbd"
        + "\u0bc3\u0bc5"
        + "\u0bc9\u0bc9"
        + "\u0bce\u0bcf"
        + "\u0bd1\u0bd6"
        + "\u0bd8\u0be5"
        + "\u0bfb\u0bff"
        + "\u0c04\u0c04"
        + "\u0c0d\u0c0d"
        + "\u0c11\u0c11"
        + "\u0c29\u0c29"
        + "\u0c3a\u0c3c"
        + "\u0c45\u0c45"
        + "\u0c49\u0c49"
        + "\u0c4e\u0c54"
        + "\u0c57\u0c57"
        + "\u0c5a\u0c5f"
        + "\u0c64\u0c65"
        + "\u0c70\u0c77"
        + "\u0c80\u0c80"
        + "\u0c84\u0c84"
        + "\u0c8d\u0c8d"
        + "\u0c91\u0c91"
        + "\u0ca9\u0ca9"
        + "\u0cb4\u0cb4"
        + "\u0cba\u0cbb"
        + "\u0cc5\u0cc5"
        + "\u0cc9\u0cc9"
        + "\u0cce\u0cd4"
        + "\u0cd7\u0cdd"
        + "\u0cdf\u0cdf"
        + "\u0ce4\u0ce5"
        + "\u0cf0\u0cf0"
        + "\u0cf3\u0d00"
        + "\u0d04\u0d04"
        + "\u0d0d\u0d0d"
        + "\u0d11\u0d11"
        + "\u0d3b\u0d3c"
        + "\u0d45\u0d45"
        + "\u0d49\u0d49"
        + "\u0d4f\u0d56"
        + "\u0d58\u0d5f"
        + "\u0d64\u0d65"
        + "\u0d76\u0d78"
        + "\u0d80\u0d81"
        + "\u0d84\u0d84"
        + "\u0d97\u0d99"
        + "\u0db2\u0db2"
        + "\u0dbc\u0dbc"
        + "\u0dbe\u0dbf"
        + "\u0dc7\u0dc9"
        + "\u0dcb\u0dce"
        + "\u0dd5\u0dd5"
        + "\u0dd7\u0dd7"
        + "\u0de0\u0de5"
        + "\u0df0\u0df1"
        + "\u0df5\u0e00"
        + "\u0e3b\u0e3e"
        + "\u0e5c\u0e80"
        + "\u0e83\u0e83"
        + "\u0e85\u0e86"
        + "\u0e89\u0e89"
        + "\u0e8b\u0e8c"
        + "\u0e8e\u0e93"
        + "\u0e98\u0e98"
        + "\u0ea0\u0ea0"
        + "\u0ea4\u0ea4"
        + "\u0ea6\u0ea6"
        + "\u0ea8\u0ea9"
        + "\u0eac\u0eac"
        + "\u0eba\u0eba"
        + "\u0ebe\u0ebf"
        + "\u0ec5\u0ec5"
        + "\u0ec7\u0ec7"
        + "\u0ece\u0ecf"
        + "\u0eda\u0edb"
        + "\u0ee0\u0eff"
        + "\u0f48\u0f48"
        + "\u0f6d\u0f70"
        + "\u0f98\u0f98"
        + "\u0fbd\u0fbd"
        + "\u0fcd\u0fcd"
        + "\u0fdb\u0fff"
        + "\u10c6\u10c6"
        + "\u10c8\u10cc"
        + "\u10ce\u10cf"
        + "\u1249\u1249"
        + "\u124e\u124f"
        + "\u1257\u1257"
        + "\u1259\u1259"
        + "\u125e\u125f"
        + "\u1289\u1289"
        + "\u128e\u128f"
        + "\u12b1\u12b1"
        + "\u12b6\u12b7"
        + "\u12bf\u12bf"
        + "\u12c1\u12c1"
        + "\u12c6\u12c7"
        + "\u12d7\u12d7"
        + "\u1311\u1311"
        + "\u1316\u1317"
        + "\u135b\u135c"
        + "\u137d\u137f"
        + "\u139a\u139f"
        + "\u13f5\u13ff"
        + "\u169d\u169f"
        + "\u16f9\u16ff"
        + "\u170d\u170d"
        + "\u1715\u171f"
        + "\u1737\u173f"
        + "\u1754\u175f"
        + "\u176d\u176d"
        + "\u1771\u1771"
        + "\u1774\u177f"
        + "\u17de\u17df"
        + "\u17ea\u17ef"
        + "\u17fa\u17ff"
        + "\u180f\u180f"
        + "\u181a\u181f"
        + "\u1878\u187f"
        + "\u18ab\u18af"
        + "\u18f6\u18ff"
        + "\u191f\u191f"
        + "\u192c\u192f"
        + "\u193c\u193f"
        + "\u1941\u1943"
        + "\u196e\u196f"
        + "\u1975\u197f"
        + "\u19ac\u19af"
        + "\u19ca\u19cf"
        + "\u19db\u19dd"
        + "\u1a1c\u1a1d"
        + "\u1a5f\u1a5f"
        + "\u1a7d\u1a7e"
        + "\u1a8a\u1a8f"
        + "\u1a9a\u1a9f"
        + "\u1aae\u1aaf"
        + "\u1abf\u1aff"
        + "\u1b4c\u1b4f"
        + "\u1b7d\u1b7f"
        + "\u1bf4\u1bfb"
        + "\u1c38\u1c3a"
        + "\u1c4a\u1c4c"
        + "\u1c80\u1cbf"
        + "\u1cc8\u1ccf"
        + "\u1cf7\u1cf7"
        + "\u1cfa\u1cff"
        + "\u1df6\u1dfb"
        + "\u1f16\u1f17"
        + "\u1f1e\u1f1f"
        + "\u1f46\u1f47"
        + "\u1f4e\u1f4f"
        + "\u1f58\u1f58"
        + "\u1f5a\u1f5a"
        + "\u1f5c\u1f5c"
        + "\u1f5e\u1f5e"
        + "\u1f7e\u1f7f"
        + "\u1fb5\u1fb5"
        + "\u1fc5\u1fc5"
        + "\u1fd4\u1fd5"
        + "\u1fdc\u1fdc"
        + "\u1ff0\u1ff1"
        + "\u1ff5\u1ff5"
        + "\u1fff\u1fff"
        + "\u2065\u2065"
        + "\u2072\u2073"
        + "\u208f\u208f"
        + "\u209d\u209f"
        + "\u20be\u20cf"
        + "\u20f1\u20ff"
        + "\u218a\u218f"
        + "\u23fb\u23ff"
        + "\u2427\u243f"
        + "\u244b\u245f"
        + "\u2b74\u2b75"
        + "\u2b96\u2b97"
        + "\u2bba\u2bbc"
        + "\u2bc9\u2bc9"
        + "\u2bd2\u2bff"
        + "\u2c2f\u2c2f"
        + "\u2c5f\u2c5f"
        + "\u2cf4\u2cf8"
        + "\u2d26\u2d26"
        + "\u2d28\u2d2c"
        + "\u2d2e\u2d2f"
        + "\u2d68\u2d6e"
        + "\u2d71\u2d7e"
        + "\u2d97\u2d9f"
        + "\u2da7\u2da7"
        + "\u2daf\u2daf"
        + "\u2db7\u2db7"
        + "\u2dbf\u2dbf"
        + "\u2dc7\u2dc7"
        + "\u2dcf\u2dcf"
        + "\u2dd7\u2dd7"
        + "\u2ddf\u2ddf"
        + "\u2e43\u2e7f"
        + "\u2e9a\u2e9a"
        + "\u2ef4\u2eff"
        + "\u2fd6\u2fef"
        + "\u2ffc\u2fff"
        + "\u3040\u3040"
        + "\u3097\u3098"
        + "\u3100\u3104"
        + "\u312e\u3130"
        + "\u318f\u318f"
        + "\u31bb\u31bf"
        + "\u31e4\u31ef"
        + "\u321f\u321f"
        + "\u32ff\u32ff"
        + "\u4db6\u4dbf"
        + "\u9fcd\u9fff"
        + "\ua48d\ua48f"
        + "\ua4c7\ua4cf"
        + "\ua62c\ua63f"
        + "\ua69e\ua69e"
        + "\ua6f8\ua6ff"
        + "\ua78f\ua78f"
        + "\ua7ae\ua7af"
        + "\ua7b2\ua7f6"
        + "\ua82c\ua82f"
        + "\ua83a\ua83f"
        + "\ua878\ua87f"
        + "\ua8c5\ua8cd"
        + "\ua8da\ua8df"
        + "\ua8fc\ua8ff"
        + "\ua954\ua95e"
        + "\ua97d\ua97f"
        + "\ua9ce\ua9ce"
        + "\ua9da\ua9dd"
        + "\ua9ff\ua9ff"
        + "\uaa37\uaa3f"
        + "\uaa4e\uaa4f"
        + "\uaa5a\uaa5b"
        + "\uaac3\uaada"
        + "\uaaf7\uab00"
        + "\uab07\uab08"
        + "\uab0f\uab10"
        + "\uab17\uab1f"
        + "\uab27\uab27"
        + "\uab2f\uab2f"
        + "\uab60\uab63"
        + "\uab66\uabbf"
        + "\uabee\uabef"
        + "\uabfa\uabff"
        + "\ud7a4\ud7af"
        + "\ud7c7\ud7ca"
        + "\ud7fc\ud7ff"
        + "\ue000\uf8ff"
        + "\ufa6e\ufa6f"
        + "\ufada\ufaff"
        + "\ufb07\ufb12"
        + "\ufb18\ufb1c"
        + "\ufb37\ufb37"
        + "\ufb3d\ufb3d"
        + "\ufb3f\ufb3f"
        + "\ufb42\ufb42"
        + "\ufb45\ufb45"
        + "\ufbc2\ufbd2"
        + "\ufd40\ufd4f"
        + "\ufd90\ufd91"
        + "\ufdc8\ufdef"
        + "\ufdfe\ufdff"
        + "\ufe1a\ufe1f"
        + "\ufe2e\ufe2f"
        + "\ufe53\ufe53"
        + "\ufe67\ufe67"
        + "\ufe6c\ufe6f"
        + "\ufe75\ufe75"
        + "\ufefd\ufefe"
        + "\uff00\uff00"
        + "\uffbf\uffc1"
        + "\uffc8\uffc9"
        + "\uffd0\uffd1"
        + "\uffd8\uffd9"
        + "\uffdd\uffdf"
        + "\uffe7\uffe7"
        + "\uffef\ufff8"
        + "\ufffe\uffff"
        + "\ud800\udc0c\ud800\udc0c"
        + "\ud800\udc27\ud800\udc27"
        + "\ud800\udc3b\ud800\udc3b"
        + "\ud800\udc3e\ud800\udc3e"
        + "\ud800\udc4e\ud800\udc4f"
        + "\ud800\udc5e\ud800\udc7f"
        + "\ud800\udcfb\ud800\udcff"
        + "\ud800\udd03\ud800\udd06"
        + "\ud800\udd34\ud800\udd36"
        + "\ud800\udd8d\ud800\udd8f"
        + "\ud800\udd9c\ud800\udd9f"
        + "\ud800\udda1\ud800\uddcf"
        + "\ud800\uddfe\ud800\ude7f"
        + "\ud800\ude9d\ud800\ude9f"
        + "\ud800\uded1\ud800\udedf"
        + "\ud800\udefc\ud800\udeff"
        + "\ud800\udf24\ud800\udf2f"
        + "\ud800\udf4b\ud800\udf4f"
        + "\ud800\udf7b\ud800\udf7f"
        + "\ud800\udf9e\ud800\udf9e"
        + "\ud800\udfc4\ud800\udfc7"
        + "\ud800\udfd6\ud800\udfff"
        + "\ud801\udc9e\ud801\udc9f"
        + "\ud801\udcaa\ud801\udcff"
        + "\ud801\udd28\ud801\udd2f"
        + "\ud801\udd64\ud801\udd6e"
        + "\ud801\udd70\ud801\uddff"
        + "\ud801\udf37\ud801\udf3f"
        + "\ud801\udf56\ud801\udf5f"
        + "\ud801\udf68\ud801\udfff"
        + "\ud802\udc06\ud802\udc07"
        + "\ud802\udc09\ud802\udc09"
        + "\ud802\udc36\ud802\udc36"
        + "\ud802\udc39\ud802\udc3b"
        + "\ud802\udc3d\ud802\udc3e"
        + "\ud802\udc56\ud802\udc56"
        + "\ud802\udc9f\ud802\udca6"
        + "\ud802\udcb0\ud802\udcff"
        + "\ud802\udd1c\ud802\udd1e"
        + "\ud802\udd3a\ud802\udd3e"
        + "\ud802\udd40\ud802\udd7f"
        + "\ud802\uddb8\ud802\uddbd"
        + "\ud802\uddc0\ud802\uddff"
        + "\ud802\ude04\ud802\ude04"
        + "\ud802\ude07\ud802\ude0b"
        + "\ud802\ude14\ud802\ude14"
        + "\ud802\ude18\ud802\ude18"
        + "\ud802\ude34\ud802\ude37"
        + "\ud802\ude3b\ud802\ude3e"
        + "\ud802\ude48\ud802\ude4f"
        + "\ud802\ude59\ud802\ude5f"
        + "\ud802\udea0\ud802\udebf"
        + "\ud802\udee7\ud802\udeea"
        + "\ud802\udef7\ud802\udeff"
        + "\ud802\udf36\ud802\udf38"
        + "\ud802\udf56\ud802\udf57"
        + "\ud802\udf73\ud802\udf77"
        + "\ud802\udf92\ud802\udf98"
        + "\ud802\udf9d\ud802\udfa8"
        + "\ud802\udfb0\ud802\udfff"
        + "\ud803\udc49\ud803\ude5f"
        + "\ud803\ude7f\ud803\udfff"
        + "\ud804\udc4e\ud804\udc51"
        + "\ud804\udc70\ud804\udc7e"
        + "\ud804\udcc2\ud804\udccf"
        + "\ud804\udce9\ud804\udcef"
        + "\ud804\udcfa\ud804\udcff"
        + "\ud804\udd35\ud804\udd35"
        + "\ud804\udd44\ud804\udd4f"
        + "\ud804\udd77\ud804\udd7f"
        + "\ud804\uddc9\ud804\uddcc"
        + "\ud804\uddce\ud804\uddcf"
        + "\ud804\udddb\ud804\udde0"
        + "\ud804\uddf5\ud804\uddff"
        + "\ud804\ude12\ud804\ude12"
        + "\ud804\ude3e\ud804\udeaf"
        + "\ud804\udeeb\ud804\udeef"
        + "\ud804\udefa\ud804\udf00"
        + "\ud804\udf04\ud804\udf04"
        + "\ud804\udf0d\ud804\udf0e"
        + "\ud804\udf11\ud804\udf12"
        + "\ud804\udf29\ud804\udf29"
        + "\ud804\udf31\ud804\udf31"
        + "\ud804\udf34\ud804\udf34"
        + "\ud804\udf3a\ud804\udf3b"
        + "\ud804\udf45\ud804\udf46"
        + "\ud804\udf49\ud804\udf4a"
        + "\ud804\udf4e\ud804\udf56"
        + "\ud804\udf58\ud804\udf5c"
        + "\ud804\udf64\ud804\udf65"
        + "\ud804\udf6d\ud804\udf6f"
        + "\ud804\udf75\ud805\udc7f"
        + "\ud805\udcc8\ud805\udccf"
        + "\ud805\udcda\ud805\udd7f"
        + "\ud805\uddb6\ud805\uddb7"
        + "\ud805\uddca\ud805\uddff"
        + "\ud805\ude45\ud805\ude4f"
        + "\ud805\ude5a\ud805\ude7f"
        + "\ud805\udeb8\ud805\udebf"
        + "\ud805\udeca\ud806\udc9f"
        + "\ud806\udcf3\ud806\udcfe"
        + "\ud806\udd00\ud806\udebf"
        + "\ud806\udef9\ud807\udfff"
        + "\ud808\udf99\ud808\udfff"
        + "\ud809\udc6f\ud809\udc6f"
        + "\ud809\udc75\ud80b\udfff"
        + "\ud80d\udc2f\ud819\udfff"
        + "\ud81a\ude39\ud81a\ude3f"
        + "\ud81a\ude5f\ud81a\ude5f"
        + "\ud81a\ude6a\ud81a\ude6d"
        + "\ud81a\ude70\ud81a\udecf"
        + "\ud81a\udeee\ud81a\udeef"
        + "\ud81a\udef6\ud81a\udeff"
        + "\ud81a\udf46\ud81a\udf4f"
        + "\ud81a\udf5a\ud81a\udf5a"
        + "\ud81a\udf62\ud81a\udf62"
        + "\ud81a\udf78\ud81a\udf7c"
        + "\ud81a\udf90\ud81b\udeff"
        + "\ud81b\udf45\ud81b\udf4f"
        + "\ud81b\udf7f\ud81b\udf8e"
        + "\ud81b\udfa0\ud82b\udfff"
        + "\ud82c\udc02\ud82e\udfff"
        + "\ud82f\udc6b\ud82f\udc6f"
        + "\ud82f\udc7d\ud82f\udc7f"
        + "\ud82f\udc89\ud82f\udc8f"
        + "\ud82f\udc9a\ud82f\udc9b"
        + "\ud82f\udca4\ud833\udfff"
        + "\ud834\udcf6\ud834\udcff"
        + "\ud834\udd27\ud834\udd28"
        + "\ud834\uddde\ud834\uddff"
        + "\ud834\ude46\ud834\udeff"
        + "\ud834\udf57\ud834\udf5f"
        + "\ud834\udf72\ud834\udfff"
        + "\ud835\udc55\ud835\udc55"
        + "\ud835\udc9d\ud835\udc9d"
        + "\ud835\udca0\ud835\udca1"
        + "\ud835\udca3\ud835\udca4"
        + "\ud835\udca7\ud835\udca8"
        + "\ud835\udcad\ud835\udcad"
        + "\ud835\udcba\ud835\udcba"
        + "\ud835\udcbc\ud835\udcbc"
        + "\ud835\udcc4\ud835\udcc4"
        + "\ud835\udd06\ud835\udd06"
        + "\ud835\udd0b\ud835\udd0c"
        + "\ud835\udd15\ud835\udd15"
        + "\ud835\udd1d\ud835\udd1d"
        + "\ud835\udd3a\ud835\udd3a"
        + "\ud835\udd3f\ud835\udd3f"
        + "\ud835\udd45\ud835\udd45"
        + "\ud835\udd47\ud835\udd49"
        + "\ud835\udd51\ud835\udd51"
        + "\ud835\udea6\ud835\udea7"
        + "\ud835\udfcc\ud835\udfcd"
        + "\ud836\udc00\ud839\udfff"
        + "\ud83a\udcc5\ud83a\udcc6"
        + "\ud83a\udcd7\ud83b\uddff"
        + "\ud83b\ude04\ud83b\ude04"
        + "\ud83b\ude20\ud83b\ude20"
        + "\ud83b\ude23\ud83b\ude23"
        + "\ud83b\ude25\ud83b\ude26"
        + "\ud83b\ude28\ud83b\ude28"
        + "\ud83b\ude33\ud83b\ude33"
        + "\ud83b\ude38\ud83b\ude38"
        + "\ud83b\ude3a\ud83b\ude3a"
        + "\ud83b\ude3c\ud83b\ude41"
        + "\ud83b\ude43\ud83b\ude46"
        + "\ud83b\ude48\ud83b\ude48"
        + "\ud83b\ude4a\ud83b\ude4a"
        + "\ud83b\ude4c\ud83b\ude4c"
        + "\ud83b\ude50\ud83b\ude50"
        + "\ud83b\ude53\ud83b\ude53"
        + "\ud83b\ude55\ud83b\ude56"
        + "\ud83b\ude58\ud83b\ude58"
        + "\ud83b\ude5a\ud83b\ude5a"
        + "\ud83b\ude5c\ud83b\ude5c"
        + "\ud83b\ude5e\ud83b\ude5e"
        + "\ud83b\ude60\ud83b\ude60"
        + "\ud83b\ude63\ud83b\ude63"
        + "\ud83b\ude65\ud83b\ude66"
        + "\ud83b\ude6b\ud83b\ude6b"
        + "\ud83b\ude73\ud83b\ude73"
        + "\ud83b\ude78\ud83b\ude78"
        + "\ud83b\ude7d\ud83b\ude7d"
        + "\ud83b\ude7f\ud83b\ude7f"
        + "\ud83b\ude8a\ud83b\ude8a"
        + "\ud83b\ude9c\ud83b\udea0"
        + "\ud83b\udea4\ud83b\udea4"
        + "\ud83b\udeaa\ud83b\udeaa"
        + "\ud83b\udebc\ud83b\udeef"
        + "\ud83b\udef2\ud83b\udfff"
        + "\ud83c\udc2c\ud83c\udc2f"
        + "\ud83c\udc94\ud83c\udc9f"
        + "\ud83c\udcaf\ud83c\udcb0"
        + "\ud83c\udcc0\ud83c\udcc0"
        + "\ud83c\udcd0\ud83c\udcd0"
        + "\ud83c\udcf6\ud83c\udcff"
        + "\ud83c\udd0d\ud83c\udd0f"
        + "\ud83c\udd2f\ud83c\udd2f"
        + "\ud83c\udd6c\ud83c\udd6f"
        + "\ud83c\udd9b\ud83c\udde5"
        + "\ud83c\ude03\ud83c\ude0f"
        + "\ud83c\ude3b\ud83c\ude3f"
        + "\ud83c\ude49\ud83c\ude4f"
        + "\ud83c\ude52\ud83c\udeff"
        + "\ud83c\udf2d\ud83c\udf2f"
        + "\ud83c\udf7e\ud83c\udf7f"
        + "\ud83c\udfcf\ud83c\udfd3"
        + "\ud83c\udff8\ud83c\udfff"
        + "\ud83d\udcff\ud83d\udcff"
        + "\ud83d\udd4b\ud83d\udd4f"
        + "\ud83d\udd7a\ud83d\udd7a"
        + "\ud83d\udda4\ud83d\udda4"
        + "\ud83d\ude43\ud83d\ude44"
        + "\ud83d\uded0\ud83d\udedf"
        + "\ud83d\udeed\ud83d\udeef"
        + "\ud83d\udef4\ud83d\udeff"
        + "\ud83d\udf74\ud83d\udf7f"
        + "\ud83d\udfd5\ud83d\udfff"
        + "\ud83e\udc0c\ud83e\udc0f"
        + "\ud83e\udc48\ud83e\udc4f"
        + "\ud83e\udc5a\ud83e\udc5f"
        + "\ud83e\udc88\ud83e\udc8f"
        + "\ud83e\udcae\ud83f\udfff"
        + "\ud869\uded7\ud869\udeff"
        + "\ud86d\udf35\ud86d\udf3f"
        + "\ud86e\udc1e\ud87d\udfff"
        + "\ud87e\ude1e\udb40\udc00"
        + "\udb40\udc02\udb40\udc1f"
        + "\udb40\udc80\udb40\udcff"
        + "\udb40\uddf0\udbff\udfff",
    // Unicode 7.0 property value: {scriptextensions=vai}
    "\ua500\ua62b",
    // Unicode 7.0 property value: {scriptextensions=warangciti}
    "\ud806\udca0\ud806\udcf2" + "\ud806\udcff\ud806\udcff",
    // Unicode 7.0 property value: {scriptextensions=yi}
    "\u3001\u3002"
        + "\u3008\u3011"
        + "\u3014\u301b"
        + "\u30fb\u30fb"
        + "\ua000\ua48c"
        + "\ua490\ua4c6"
        + "\uff61\uff65",
    // Unicode 7.0 property value: {sentencebreak=aterm}
    "\u002e\u002e" + "\u2024\u2024" + "\ufe52\ufe52" + "\uff0e\uff0e",
    // Unicode 7.0 property value: {sentencebreak=close}
    "\"\""
        + "\u0027\u0029"
        + "\u005b\u005b"
        + "\u005d\u005d"
        + "\u007b\u007b"
        + "\u007d\u007d"
        + "\u00ab\u00ab"
        + "\u00bb\u00bb"
        + "\u0f3a\u0f3d"
        + "\u169b\u169c"
        + "\u2018\u201f"
        + "\u2039\u203a"
        + "\u2045\u2046"
        + "\u207d\u207e"
        + "\u208d\u208e"
        + "\u2308\u230b"
        + "\u2329\u232a"
        + "\u275b\u2760"
        + "\u2768\u2775"
        + "\u27c5\u27c6"
        + "\u27e6\u27ef"
        + "\u2983\u2998"
        + "\u29d8\u29db"
        + "\u29fc\u29fd"
        + "\u2e00\u2e0d"
        + "\u2e1c\u2e1d"
        + "\u2e20\u2e29"
        + "\u2e42\u2e42"
        + "\u3008\u3011"
        + "\u3014\u301b"
        + "\u301d\u301f"
        + "\ufd3e\ufd3f"
        + "\ufe17\ufe18"
        + "\ufe35\ufe44"
        + "\ufe47\ufe48"
        + "\ufe59\ufe5e"
        + "\uff08\uff09"
        + "\uff3b\uff3b"
        + "\uff3d\uff3d"
        + "\uff5b\uff5b"
        + "\uff5d\uff5d"
        + "\uff5f\uff60"
        + "\uff62\uff63"
        + "\ud83d\ude76\ud83d\ude78",
    // Unicode 7.0 property value: {sentencebreak=cr}
    "\r\r",
    // Unicode 7.0 property value: {sentencebreak=extend}
    "\u0300\u036f"
        + "\u0483\u0489"
        + "\u0591\u05bd"
        + "\u05bf\u05bf"
        + "\u05c1\u05c2"
        + "\u05c4\u05c5"
        + "\u05c7\u05c7"
        + "\u0610\u061a"
        + "\u064b\u065f"
        + "\u0670\u0670"
        + "\u06d6\u06dc"
        + "\u06df\u06e4"
        + "\u06e7\u06e8"
        + "\u06ea\u06ed"
        + "\u0711\u0711"
        + "\u0730\u074a"
        + "\u07a6\u07b0"
        + "\u07eb\u07f3"
        + "\u0816\u0819"
        + "\u081b\u0823"
        + "\u0825\u0827"
        + "\u0829\u082d"
        + "\u0859\u085b"
        + "\u08e4\u0903"
        + "\u093a\u093c"
        + "\u093e\u094f"
        + "\u0951\u0957"
        + "\u0962\u0963"
        + "\u0981\u0983"
        + "\u09bc\u09bc"
        + "\u09be\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09cd"
        + "\u09d7\u09d7"
        + "\u09e2\u09e3"
        + "\u0a01\u0a03"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a70\u0a71"
        + "\u0a75\u0a75"
        + "\u0a81\u0a83"
        + "\u0abc\u0abc"
        + "\u0abe\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ae2\u0ae3"
        + "\u0b01\u0b03"
        + "\u0b3c\u0b3c"
        + "\u0b3e\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b62\u0b63"
        + "\u0b82\u0b82"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0c00\u0c03"
        + "\u0c3e\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c62\u0c63"
        + "\u0c81\u0c83"
        + "\u0cbc\u0cbc"
        + "\u0cbe\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0ce2\u0ce3"
        + "\u0d01\u0d03"
        + "\u0d3e\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d62\u0d63"
        + "\u0d82\u0d83"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df3"
        + "\u0e31\u0e31"
        + "\u0e34\u0e3a"
        + "\u0e47\u0e4e"
        + "\u0eb1\u0eb1"
        + "\u0eb4\u0eb9"
        + "\u0ebb\u0ebc"
        + "\u0ec8\u0ecd"
        + "\u0f18\u0f19"
        + "\u0f35\u0f35"
        + "\u0f37\u0f37"
        + "\u0f39\u0f39"
        + "\u0f3e\u0f3f"
        + "\u0f71\u0f84"
        + "\u0f86\u0f87"
        + "\u0f8d\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fc6\u0fc6"
        + "\u102b\u103e"
        + "\u1056\u1059"
        + "\u105e\u1060"
        + "\u1062\u1064"
        + "\u1067\u106d"
        + "\u1071\u1074"
        + "\u1082\u108d"
        + "\u108f\u108f"
        + "\u109a\u109d"
        + "\u135d\u135f"
        + "\u1712\u1714"
        + "\u1732\u1734"
        + "\u1752\u1753"
        + "\u1772\u1773"
        + "\u17b4\u17d3"
        + "\u17dd\u17dd"
        + "\u180b\u180d"
        + "\u18a9\u18a9"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u19b0\u19c0"
        + "\u19c8\u19c9"
        + "\u1a17\u1a1b"
        + "\u1a55\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1a7f\u1a7f"
        + "\u1ab0\u1abe"
        + "\u1b00\u1b04"
        + "\u1b34\u1b44"
        + "\u1b6b\u1b73"
        + "\u1b80\u1b82"
        + "\u1ba1\u1bad"
        + "\u1be6\u1bf3"
        + "\u1c24\u1c37"
        + "\u1cd0\u1cd2"
        + "\u1cd4\u1ce8"
        + "\u1ced\u1ced"
        + "\u1cf2\u1cf4"
        + "\u1cf8\u1cf9"
        + "\u1dc0\u1df5"
        + "\u1dfc\u1dff"
        + "\u200c\u200d"
        + "\u20d0\u20f0"
        + "\u2cef\u2cf1"
        + "\u2d7f\u2d7f"
        + "\u2de0\u2dff"
        + "\u302a\u302f"
        + "\u3099\u309a"
        + "\ua66f\ua672"
        + "\ua674\ua67d"
        + "\ua69f\ua69f"
        + "\ua6f0\ua6f1"
        + "\ua802\ua802"
        + "\ua806\ua806"
        + "\ua80b\ua80b"
        + "\ua823\ua827"
        + "\ua880\ua881"
        + "\ua8b4\ua8c4"
        + "\ua8e0\ua8f1"
        + "\ua926\ua92d"
        + "\ua947\ua953"
        + "\ua980\ua983"
        + "\ua9b3\ua9c0"
        + "\ua9e5\ua9e5"
        + "\uaa29\uaa36"
        + "\uaa43\uaa43"
        + "\uaa4c\uaa4d"
        + "\uaa7b\uaa7d"
        + "\uaab0\uaab0"
        + "\uaab2\uaab4"
        + "\uaab7\uaab8"
        + "\uaabe\uaabf"
        + "\uaac1\uaac1"
        + "\uaaeb\uaaef"
        + "\uaaf5\uaaf6"
        + "\uabe3\uabea"
        + "\uabec\uabed"
        + "\ufb1e\ufb1e"
        + "\ufe00\ufe0f"
        + "\ufe20\ufe2d"
        + "\uff9e\uff9f"
        + "\ud800\uddfd\ud800\uddfd"
        + "\ud800\udee0\ud800\udee0"
        + "\ud800\udf76\ud800\udf7a"
        + "\ud802\ude01\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude0f"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude3f"
        + "\ud802\udee5\ud802\udee6"
        + "\ud804\udc00\ud804\udc02"
        + "\ud804\udc38\ud804\udc46"
        + "\ud804\udc7f\ud804\udc82"
        + "\ud804\udcb0\ud804\udcba"
        + "\ud804\udd00\ud804\udd02"
        + "\ud804\udd27\ud804\udd34"
        + "\ud804\udd73\ud804\udd73"
        + "\ud804\udd80\ud804\udd82"
        + "\ud804\uddb3\ud804\uddc0"
        + "\ud804\ude2c\ud804\ude37"
        + "\ud804\udedf\ud804\udeea"
        + "\ud804\udf01\ud804\udf03"
        + "\ud804\udf3c\ud804\udf3c"
        + "\ud804\udf3e\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf62\ud804\udf63"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udcb0\ud805\udcc3"
        + "\ud805\uddaf\ud805\uddb5"
        + "\ud805\uddb8\ud805\uddc0"
        + "\ud805\ude30\ud805\ude40"
        + "\ud805\udeab\ud805\udeb7"
        + "\ud81a\udef0\ud81a\udef4"
        + "\ud81a\udf30\ud81a\udf36"
        + "\ud81b\udf51\ud81b\udf7e"
        + "\ud81b\udf8f\ud81b\udf92"
        + "\ud82f\udc9d\ud82f\udc9e"
        + "\ud834\udd65\ud834\udd69"
        + "\ud834\udd6d\ud834\udd72"
        + "\ud834\udd7b\ud834\udd82"
        + "\ud834\udd85\ud834\udd8b"
        + "\ud834\uddaa\ud834\uddad"
        + "\ud834\ude42\ud834\ude44"
        + "\ud83a\udcd0\ud83a\udcd6"
        + "\udb40\udd00\udb40\uddef",
    // Unicode 7.0 property value: {sentencebreak=format}
    "\u00ad\u00ad"
        + "\u0600\u0605"
        + "\u061c\u061c"
        + "\u06dd\u06dd"
        + "\u070f\u070f"
        + "\u180e\u180e"
        + "\u200b\u200b"
        + "\u200e\u200f"
        + "\u202a\u202e"
        + "\u2060\u2064"
        + "\u2066\u206f"
        + "\ufeff\ufeff"
        + "\ufff9\ufffb"
        + "\ud804\udcbd\ud804\udcbd"
        + "\ud82f\udca0\ud82f\udca3"
        + "\ud834\udd73\ud834\udd7a"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f",
    // Unicode 7.0 property value: {sentencebreak=lf}
    "\n\n",
    // Unicode 7.0 property value: {sentencebreak=lower}
    "\u0061\u007a"
        + "\u00aa\u00aa"
        + "\u00b5\u00b5"
        + "\u00ba\u00ba"
        + "\u00df\u00f6"
        + "\u00f8\u00ff"
        + "\u0101\u0101"
        + "\u0103\u0103"
        + "\u0105\u0105"
        + "\u0107\u0107"
        + "\u0109\u0109"
        + "\u010b\u010b"
        + "\u010d\u010d"
        + "\u010f\u010f"
        + "\u0111\u0111"
        + "\u0113\u0113"
        + "\u0115\u0115"
        + "\u0117\u0117"
        + "\u0119\u0119"
        + "\u011b\u011b"
        + "\u011d\u011d"
        + "\u011f\u011f"
        + "\u0121\u0121"
        + "\u0123\u0123"
        + "\u0125\u0125"
        + "\u0127\u0127"
        + "\u0129\u0129"
        + "\u012b\u012b"
        + "\u012d\u012d"
        + "\u012f\u012f"
        + "\u0131\u0131"
        + "\u0133\u0133"
        + "\u0135\u0135"
        + "\u0137\u0138"
        + "\u013a\u013a"
        + "\u013c\u013c"
        + "\u013e\u013e"
        + "\u0140\u0140"
        + "\u0142\u0142"
        + "\u0144\u0144"
        + "\u0146\u0146"
        + "\u0148\u0149"
        + "\u014b\u014b"
        + "\u014d\u014d"
        + "\u014f\u014f"
        + "\u0151\u0151"
        + "\u0153\u0153"
        + "\u0155\u0155"
        + "\u0157\u0157"
        + "\u0159\u0159"
        + "\u015b\u015b"
        + "\u015d\u015d"
        + "\u015f\u015f"
        + "\u0161\u0161"
        + "\u0163\u0163"
        + "\u0165\u0165"
        + "\u0167\u0167"
        + "\u0169\u0169"
        + "\u016b\u016b"
        + "\u016d\u016d"
        + "\u016f\u016f"
        + "\u0171\u0171"
        + "\u0173\u0173"
        + "\u0175\u0175"
        + "\u0177\u0177"
        + "\u017a\u017a"
        + "\u017c\u017c"
        + "\u017e\u0180"
        + "\u0183\u0183"
        + "\u0185\u0185"
        + "\u0188\u0188"
        + "\u018c\u018d"
        + "\u0192\u0192"
        + "\u0195\u0195"
        + "\u0199\u019b"
        + "\u019e\u019e"
        + "\u01a1\u01a1"
        + "\u01a3\u01a3"
        + "\u01a5\u01a5"
        + "\u01a8\u01a8"
        + "\u01aa\u01ab"
        + "\u01ad\u01ad"
        + "\u01b0\u01b0"
        + "\u01b4\u01b4"
        + "\u01b6\u01b6"
        + "\u01b9\u01ba"
        + "\u01bd\u01bf"
        + "\u01c6\u01c6"
        + "\u01c9\u01c9"
        + "\u01cc\u01cc"
        + "\u01ce\u01ce"
        + "\u01d0\u01d0"
        + "\u01d2\u01d2"
        + "\u01d4\u01d4"
        + "\u01d6\u01d6"
        + "\u01d8\u01d8"
        + "\u01da\u01da"
        + "\u01dc\u01dd"
        + "\u01df\u01df"
        + "\u01e1\u01e1"
        + "\u01e3\u01e3"
        + "\u01e5\u01e5"
        + "\u01e7\u01e7"
        + "\u01e9\u01e9"
        + "\u01eb\u01eb"
        + "\u01ed\u01ed"
        + "\u01ef\u01f0"
        + "\u01f3\u01f3"
        + "\u01f5\u01f5"
        + "\u01f9\u01f9"
        + "\u01fb\u01fb"
        + "\u01fd\u01fd"
        + "\u01ff\u01ff"
        + "\u0201\u0201"
        + "\u0203\u0203"
        + "\u0205\u0205"
        + "\u0207\u0207"
        + "\u0209\u0209"
        + "\u020b\u020b"
        + "\u020d\u020d"
        + "\u020f\u020f"
        + "\u0211\u0211"
        + "\u0213\u0213"
        + "\u0215\u0215"
        + "\u0217\u0217"
        + "\u0219\u0219"
        + "\u021b\u021b"
        + "\u021d\u021d"
        + "\u021f\u021f"
        + "\u0221\u0221"
        + "\u0223\u0223"
        + "\u0225\u0225"
        + "\u0227\u0227"
        + "\u0229\u0229"
        + "\u022b\u022b"
        + "\u022d\u022d"
        + "\u022f\u022f"
        + "\u0231\u0231"
        + "\u0233\u0239"
        + "\u023c\u023c"
        + "\u023f\u0240"
        + "\u0242\u0242"
        + "\u0247\u0247"
        + "\u0249\u0249"
        + "\u024b\u024b"
        + "\u024d\u024d"
        + "\u024f\u0293"
        + "\u0295\u02b8"
        + "\u02c0\u02c1"
        + "\u02e0\u02e4"
        + "\u0371\u0371"
        + "\u0373\u0373"
        + "\u0377\u0377"
        + "\u037a\u037d"
        + "\u0390\u0390"
        + "\u03ac\u03ce"
        + "\u03d0\u03d1"
        + "\u03d5\u03d7"
        + "\u03d9\u03d9"
        + "\u03db\u03db"
        + "\u03dd\u03dd"
        + "\u03df\u03df"
        + "\u03e1\u03e1"
        + "\u03e3\u03e3"
        + "\u03e5\u03e5"
        + "\u03e7\u03e7"
        + "\u03e9\u03e9"
        + "\u03eb\u03eb"
        + "\u03ed\u03ed"
        + "\u03ef\u03f3"
        + "\u03f5\u03f5"
        + "\u03f8\u03f8"
        + "\u03fb\u03fc"
        + "\u0430\u045f"
        + "\u0461\u0461"
        + "\u0463\u0463"
        + "\u0465\u0465"
        + "\u0467\u0467"
        + "\u0469\u0469"
        + "\u046b\u046b"
        + "\u046d\u046d"
        + "\u046f\u046f"
        + "\u0471\u0471"
        + "\u0473\u0473"
        + "\u0475\u0475"
        + "\u0477\u0477"
        + "\u0479\u0479"
        + "\u047b\u047b"
        + "\u047d\u047d"
        + "\u047f\u047f"
        + "\u0481\u0481"
        + "\u048b\u048b"
        + "\u048d\u048d"
        + "\u048f\u048f"
        + "\u0491\u0491"
        + "\u0493\u0493"
        + "\u0495\u0495"
        + "\u0497\u0497"
        + "\u0499\u0499"
        + "\u049b\u049b"
        + "\u049d\u049d"
        + "\u049f\u049f"
        + "\u04a1\u04a1"
        + "\u04a3\u04a3"
        + "\u04a5\u04a5"
        + "\u04a7\u04a7"
        + "\u04a9\u04a9"
        + "\u04ab\u04ab"
        + "\u04ad\u04ad"
        + "\u04af\u04af"
        + "\u04b1\u04b1"
        + "\u04b3\u04b3"
        + "\u04b5\u04b5"
        + "\u04b7\u04b7"
        + "\u04b9\u04b9"
        + "\u04bb\u04bb"
        + "\u04bd\u04bd"
        + "\u04bf\u04bf"
        + "\u04c2\u04c2"
        + "\u04c4\u04c4"
        + "\u04c6\u04c6"
        + "\u04c8\u04c8"
        + "\u04ca\u04ca"
        + "\u04cc\u04cc"
        + "\u04ce\u04cf"
        + "\u04d1\u04d1"
        + "\u04d3\u04d3"
        + "\u04d5\u04d5"
        + "\u04d7\u04d7"
        + "\u04d9\u04d9"
        + "\u04db\u04db"
        + "\u04dd\u04dd"
        + "\u04df\u04df"
        + "\u04e1\u04e1"
        + "\u04e3\u04e3"
        + "\u04e5\u04e5"
        + "\u04e7\u04e7"
        + "\u04e9\u04e9"
        + "\u04eb\u04eb"
        + "\u04ed\u04ed"
        + "\u04ef\u04ef"
        + "\u04f1\u04f1"
        + "\u04f3\u04f3"
        + "\u04f5\u04f5"
        + "\u04f7\u04f7"
        + "\u04f9\u04f9"
        + "\u04fb\u04fb"
        + "\u04fd\u04fd"
        + "\u04ff\u04ff"
        + "\u0501\u0501"
        + "\u0503\u0503"
        + "\u0505\u0505"
        + "\u0507\u0507"
        + "\u0509\u0509"
        + "\u050b\u050b"
        + "\u050d\u050d"
        + "\u050f\u050f"
        + "\u0511\u0511"
        + "\u0513\u0513"
        + "\u0515\u0515"
        + "\u0517\u0517"
        + "\u0519\u0519"
        + "\u051b\u051b"
        + "\u051d\u051d"
        + "\u051f\u051f"
        + "\u0521\u0521"
        + "\u0523\u0523"
        + "\u0525\u0525"
        + "\u0527\u0527"
        + "\u0529\u0529"
        + "\u052b\u052b"
        + "\u052d\u052d"
        + "\u052f\u052f"
        + "\u0561\u0587"
        + "\u1d00\u1dbf"
        + "\u1e01\u1e01"
        + "\u1e03\u1e03"
        + "\u1e05\u1e05"
        + "\u1e07\u1e07"
        + "\u1e09\u1e09"
        + "\u1e0b\u1e0b"
        + "\u1e0d\u1e0d"
        + "\u1e0f\u1e0f"
        + "\u1e11\u1e11"
        + "\u1e13\u1e13"
        + "\u1e15\u1e15"
        + "\u1e17\u1e17"
        + "\u1e19\u1e19"
        + "\u1e1b\u1e1b"
        + "\u1e1d\u1e1d"
        + "\u1e1f\u1e1f"
        + "\u1e21\u1e21"
        + "\u1e23\u1e23"
        + "\u1e25\u1e25"
        + "\u1e27\u1e27"
        + "\u1e29\u1e29"
        + "\u1e2b\u1e2b"
        + "\u1e2d\u1e2d"
        + "\u1e2f\u1e2f"
        + "\u1e31\u1e31"
        + "\u1e33\u1e33"
        + "\u1e35\u1e35"
        + "\u1e37\u1e37"
        + "\u1e39\u1e39"
        + "\u1e3b\u1e3b"
        + "\u1e3d\u1e3d"
        + "\u1e3f\u1e3f"
        + "\u1e41\u1e41"
        + "\u1e43\u1e43"
        + "\u1e45\u1e45"
        + "\u1e47\u1e47"
        + "\u1e49\u1e49"
        + "\u1e4b\u1e4b"
        + "\u1e4d\u1e4d"
        + "\u1e4f\u1e4f"
        + "\u1e51\u1e51"
        + "\u1e53\u1e53"
        + "\u1e55\u1e55"
        + "\u1e57\u1e57"
        + "\u1e59\u1e59"
        + "\u1e5b\u1e5b"
        + "\u1e5d\u1e5d"
        + "\u1e5f\u1e5f"
        + "\u1e61\u1e61"
        + "\u1e63\u1e63"
        + "\u1e65\u1e65"
        + "\u1e67\u1e67"
        + "\u1e69\u1e69"
        + "\u1e6b\u1e6b"
        + "\u1e6d\u1e6d"
        + "\u1e6f\u1e6f"
        + "\u1e71\u1e71"
        + "\u1e73\u1e73"
        + "\u1e75\u1e75"
        + "\u1e77\u1e77"
        + "\u1e79\u1e79"
        + "\u1e7b\u1e7b"
        + "\u1e7d\u1e7d"
        + "\u1e7f\u1e7f"
        + "\u1e81\u1e81"
        + "\u1e83\u1e83"
        + "\u1e85\u1e85"
        + "\u1e87\u1e87"
        + "\u1e89\u1e89"
        + "\u1e8b\u1e8b"
        + "\u1e8d\u1e8d"
        + "\u1e8f\u1e8f"
        + "\u1e91\u1e91"
        + "\u1e93\u1e93"
        + "\u1e95\u1e9d"
        + "\u1e9f\u1e9f"
        + "\u1ea1\u1ea1"
        + "\u1ea3\u1ea3"
        + "\u1ea5\u1ea5"
        + "\u1ea7\u1ea7"
        + "\u1ea9\u1ea9"
        + "\u1eab\u1eab"
        + "\u1ead\u1ead"
        + "\u1eaf\u1eaf"
        + "\u1eb1\u1eb1"
        + "\u1eb3\u1eb3"
        + "\u1eb5\u1eb5"
        + "\u1eb7\u1eb7"
        + "\u1eb9\u1eb9"
        + "\u1ebb\u1ebb"
        + "\u1ebd\u1ebd"
        + "\u1ebf\u1ebf"
        + "\u1ec1\u1ec1"
        + "\u1ec3\u1ec3"
        + "\u1ec5\u1ec5"
        + "\u1ec7\u1ec7"
        + "\u1ec9\u1ec9"
        + "\u1ecb\u1ecb"
        + "\u1ecd\u1ecd"
        + "\u1ecf\u1ecf"
        + "\u1ed1\u1ed1"
        + "\u1ed3\u1ed3"
        + "\u1ed5\u1ed5"
        + "\u1ed7\u1ed7"
        + "\u1ed9\u1ed9"
        + "\u1edb\u1edb"
        + "\u1edd\u1edd"
        + "\u1edf\u1edf"
        + "\u1ee1\u1ee1"
        + "\u1ee3\u1ee3"
        + "\u1ee5\u1ee5"
        + "\u1ee7\u1ee7"
        + "\u1ee9\u1ee9"
        + "\u1eeb\u1eeb"
        + "\u1eed\u1eed"
        + "\u1eef\u1eef"
        + "\u1ef1\u1ef1"
        + "\u1ef3\u1ef3"
        + "\u1ef5\u1ef5"
        + "\u1ef7\u1ef7"
        + "\u1ef9\u1ef9"
        + "\u1efb\u1efb"
        + "\u1efd\u1efd"
        + "\u1eff\u1f07"
        + "\u1f10\u1f15"
        + "\u1f20\u1f27"
        + "\u1f30\u1f37"
        + "\u1f40\u1f45"
        + "\u1f50\u1f57"
        + "\u1f60\u1f67"
        + "\u1f70\u1f7d"
        + "\u1f80\u1f87"
        + "\u1f90\u1f97"
        + "\u1fa0\u1fa7"
        + "\u1fb0\u1fb4"
        + "\u1fb6\u1fb7"
        + "\u1fbe\u1fbe"
        + "\u1fc2\u1fc4"
        + "\u1fc6\u1fc7"
        + "\u1fd0\u1fd3"
        + "\u1fd6\u1fd7"
        + "\u1fe0\u1fe7"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ff7"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u210a\u210a"
        + "\u210e\u210f"
        + "\u2113\u2113"
        + "\u212f\u212f"
        + "\u2134\u2134"
        + "\u2139\u2139"
        + "\u213c\u213d"
        + "\u2146\u2149"
        + "\u214e\u214e"
        + "\u2170\u217f"
        + "\u2184\u2184"
        + "\u24d0\u24e9"
        + "\u2c30\u2c5e"
        + "\u2c61\u2c61"
        + "\u2c65\u2c66"
        + "\u2c68\u2c68"
        + "\u2c6a\u2c6a"
        + "\u2c6c\u2c6c"
        + "\u2c71\u2c71"
        + "\u2c73\u2c74"
        + "\u2c76\u2c7d"
        + "\u2c81\u2c81"
        + "\u2c83\u2c83"
        + "\u2c85\u2c85"
        + "\u2c87\u2c87"
        + "\u2c89\u2c89"
        + "\u2c8b\u2c8b"
        + "\u2c8d\u2c8d"
        + "\u2c8f\u2c8f"
        + "\u2c91\u2c91"
        + "\u2c93\u2c93"
        + "\u2c95\u2c95"
        + "\u2c97\u2c97"
        + "\u2c99\u2c99"
        + "\u2c9b\u2c9b"
        + "\u2c9d\u2c9d"
        + "\u2c9f\u2c9f"
        + "\u2ca1\u2ca1"
        + "\u2ca3\u2ca3"
        + "\u2ca5\u2ca5"
        + "\u2ca7\u2ca7"
        + "\u2ca9\u2ca9"
        + "\u2cab\u2cab"
        + "\u2cad\u2cad"
        + "\u2caf\u2caf"
        + "\u2cb1\u2cb1"
        + "\u2cb3\u2cb3"
        + "\u2cb5\u2cb5"
        + "\u2cb7\u2cb7"
        + "\u2cb9\u2cb9"
        + "\u2cbb\u2cbb"
        + "\u2cbd\u2cbd"
        + "\u2cbf\u2cbf"
        + "\u2cc1\u2cc1"
        + "\u2cc3\u2cc3"
        + "\u2cc5\u2cc5"
        + "\u2cc7\u2cc7"
        + "\u2cc9\u2cc9"
        + "\u2ccb\u2ccb"
        + "\u2ccd\u2ccd"
        + "\u2ccf\u2ccf"
        + "\u2cd1\u2cd1"
        + "\u2cd3\u2cd3"
        + "\u2cd5\u2cd5"
        + "\u2cd7\u2cd7"
        + "\u2cd9\u2cd9"
        + "\u2cdb\u2cdb"
        + "\u2cdd\u2cdd"
        + "\u2cdf\u2cdf"
        + "\u2ce1\u2ce1"
        + "\u2ce3\u2ce4"
        + "\u2cec\u2cec"
        + "\u2cee\u2cee"
        + "\u2cf3\u2cf3"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\ua641\ua641"
        + "\ua643\ua643"
        + "\ua645\ua645"
        + "\ua647\ua647"
        + "\ua649\ua649"
        + "\ua64b\ua64b"
        + "\ua64d\ua64d"
        + "\ua64f\ua64f"
        + "\ua651\ua651"
        + "\ua653\ua653"
        + "\ua655\ua655"
        + "\ua657\ua657"
        + "\ua659\ua659"
        + "\ua65b\ua65b"
        + "\ua65d\ua65d"
        + "\ua65f\ua65f"
        + "\ua661\ua661"
        + "\ua663\ua663"
        + "\ua665\ua665"
        + "\ua667\ua667"
        + "\ua669\ua669"
        + "\ua66b\ua66b"
        + "\ua66d\ua66d"
        + "\ua681\ua681"
        + "\ua683\ua683"
        + "\ua685\ua685"
        + "\ua687\ua687"
        + "\ua689\ua689"
        + "\ua68b\ua68b"
        + "\ua68d\ua68d"
        + "\ua68f\ua68f"
        + "\ua691\ua691"
        + "\ua693\ua693"
        + "\ua695\ua695"
        + "\ua697\ua697"
        + "\ua699\ua699"
        + "\ua69b\ua69d"
        + "\ua723\ua723"
        + "\ua725\ua725"
        + "\ua727\ua727"
        + "\ua729\ua729"
        + "\ua72b\ua72b"
        + "\ua72d\ua72d"
        + "\ua72f\ua731"
        + "\ua733\ua733"
        + "\ua735\ua735"
        + "\ua737\ua737"
        + "\ua739\ua739"
        + "\ua73b\ua73b"
        + "\ua73d\ua73d"
        + "\ua73f\ua73f"
        + "\ua741\ua741"
        + "\ua743\ua743"
        + "\ua745\ua745"
        + "\ua747\ua747"
        + "\ua749\ua749"
        + "\ua74b\ua74b"
        + "\ua74d\ua74d"
        + "\ua74f\ua74f"
        + "\ua751\ua751"
        + "\ua753\ua753"
        + "\ua755\ua755"
        + "\ua757\ua757"
        + "\ua759\ua759"
        + "\ua75b\ua75b"
        + "\ua75d\ua75d"
        + "\ua75f\ua75f"
        + "\ua761\ua761"
        + "\ua763\ua763"
        + "\ua765\ua765"
        + "\ua767\ua767"
        + "\ua769\ua769"
        + "\ua76b\ua76b"
        + "\ua76d\ua76d"
        + "\ua76f\ua778"
        + "\ua77a\ua77a"
        + "\ua77c\ua77c"
        + "\ua77f\ua77f"
        + "\ua781\ua781"
        + "\ua783\ua783"
        + "\ua785\ua785"
        + "\ua787\ua787"
        + "\ua78c\ua78c"
        + "\ua78e\ua78e"
        + "\ua791\ua791"
        + "\ua793\ua795"
        + "\ua797\ua797"
        + "\ua799\ua799"
        + "\ua79b\ua79b"
        + "\ua79d\ua79d"
        + "\ua79f\ua79f"
        + "\ua7a1\ua7a1"
        + "\ua7a3\ua7a3"
        + "\ua7a5\ua7a5"
        + "\ua7a7\ua7a7"
        + "\ua7a9\ua7a9"
        + "\ua7f8\ua7fa"
        + "\uab30\uab5a"
        + "\uab5c\uab5f"
        + "\uab64\uab65"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\uff41\uff5a"
        + "\ud801\udc28\ud801\udc4f"
        + "\ud806\udcc0\ud806\udcdf"
        + "\ud835\udc1a\ud835\udc33"
        + "\ud835\udc4e\ud835\udc54"
        + "\ud835\udc56\ud835\udc67"
        + "\ud835\udc82\ud835\udc9b"
        + "\ud835\udcb6\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udccf"
        + "\ud835\udcea\ud835\udd03"
        + "\ud835\udd1e\ud835\udd37"
        + "\ud835\udd52\ud835\udd6b"
        + "\ud835\udd86\ud835\udd9f"
        + "\ud835\uddba\ud835\uddd3"
        + "\ud835\uddee\ud835\ude07"
        + "\ud835\ude22\ud835\ude3b"
        + "\ud835\ude56\ud835\ude6f"
        + "\ud835\ude8a\ud835\udea5"
        + "\ud835\udec2\ud835\udeda"
        + "\ud835\udedc\ud835\udee1"
        + "\ud835\udefc\ud835\udf14"
        + "\ud835\udf16\ud835\udf1b"
        + "\ud835\udf36\ud835\udf4e"
        + "\ud835\udf50\ud835\udf55"
        + "\ud835\udf70\ud835\udf88"
        + "\ud835\udf8a\ud835\udf8f"
        + "\ud835\udfaa\ud835\udfc2"
        + "\ud835\udfc4\ud835\udfc9"
        + "\ud835\udfcb\ud835\udfcb",
    // Unicode 7.0 property value: {sentencebreak=numeric}
    "\u0030\u0039"
        + "\u0660\u0669"
        + "\u066b\u066c"
        + "\u06f0\u06f9"
        + "\u07c0\u07c9"
        + "\u0966\u096f"
        + "\u09e6\u09ef"
        + "\u0a66\u0a6f"
        + "\u0ae6\u0aef"
        + "\u0b66\u0b6f"
        + "\u0be6\u0bef"
        + "\u0c66\u0c6f"
        + "\u0ce6\u0cef"
        + "\u0d66\u0d6f"
        + "\u0de6\u0def"
        + "\u0e50\u0e59"
        + "\u0ed0\u0ed9"
        + "\u0f20\u0f29"
        + "\u1040\u1049"
        + "\u1090\u1099"
        + "\u17e0\u17e9"
        + "\u1810\u1819"
        + "\u1946\u194f"
        + "\u19d0\u19d9"
        + "\u1a80\u1a89"
        + "\u1a90\u1a99"
        + "\u1b50\u1b59"
        + "\u1bb0\u1bb9"
        + "\u1c40\u1c49"
        + "\u1c50\u1c59"
        + "\ua620\ua629"
        + "\ua8d0\ua8d9"
        + "\ua900\ua909"
        + "\ua9d0\ua9d9"
        + "\ua9f0\ua9f9"
        + "\uaa50\uaa59"
        + "\uabf0\uabf9"
        + "\ud801\udca0\ud801\udca9"
        + "\ud804\udc66\ud804\udc6f"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd36\ud804\udd3f"
        + "\ud804\uddd0\ud804\uddd9"
        + "\ud804\udef0\ud804\udef9"
        + "\ud805\udcd0\ud805\udcd9"
        + "\ud805\ude50\ud805\ude59"
        + "\ud805\udec0\ud805\udec9"
        + "\ud806\udce0\ud806\udce9"
        + "\ud81a\ude60\ud81a\ude69"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud835\udfce\ud835\udfff",
    // Unicode 7.0 property value: {sentencebreak=oletter}
    "\u01bb\u01bb"
        + "\u01c0\u01c3"
        + "\u0294\u0294"
        + "\u02b9\u02bf"
        + "\u02c6\u02d1"
        + "\u02ec\u02ec"
        + "\u02ee\u02ee"
        + "\u0374\u0374"
        + "\u0559\u0559"
        + "\u05d0\u05ea"
        + "\u05f0\u05f3"
        + "\u0620\u064a"
        + "\u066e\u066f"
        + "\u0671\u06d3"
        + "\u06d5\u06d5"
        + "\u06e5\u06e6"
        + "\u06ee\u06ef"
        + "\u06fa\u06fc"
        + "\u06ff\u06ff"
        + "\u0710\u0710"
        + "\u0712\u072f"
        + "\u074d\u07a5"
        + "\u07b1\u07b1"
        + "\u07ca\u07ea"
        + "\u07f4\u07f5"
        + "\u07fa\u07fa"
        + "\u0800\u0815"
        + "\u081a\u081a"
        + "\u0824\u0824"
        + "\u0828\u0828"
        + "\u0840\u0858"
        + "\u08a0\u08b2"
        + "\u0904\u0939"
        + "\u093d\u093d"
        + "\u0950\u0950"
        + "\u0958\u0961"
        + "\u0971\u0980"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bd\u09bd"
        + "\u09ce\u09ce"
        + "\u09dc\u09dd"
        + "\u09df\u09e1"
        + "\u09f0\u09f1"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a72\u0a74"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abd\u0abd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae1"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3d\u0b3d"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b71\u0b71"
        + "\u0b83\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bd0\u0bd0"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c3d"
        + "\u0c58\u0c59"
        + "\u0c60\u0c61"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbd\u0cbd"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0cf1\u0cf2"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d3d"
        + "\u0d4e\u0d4e"
        + "\u0d60\u0d61"
        + "\u0d7a\u0d7f"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0e01\u0e30"
        + "\u0e32\u0e33"
        + "\u0e40\u0e46"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb0"
        + "\u0eb2\u0eb3"
        + "\u0ebd\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0edc\u0edf"
        + "\u0f00\u0f00"
        + "\u0f40\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f88\u0f8c"
        + "\u1000\u102a"
        + "\u103f\u103f"
        + "\u1050\u1055"
        + "\u105a\u105d"
        + "\u1061\u1061"
        + "\u1065\u1066"
        + "\u106e\u1070"
        + "\u1075\u1081"
        + "\u108e\u108e"
        + "\u10d0\u10fa"
        + "\u10fc\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u1380\u138f"
        + "\u13a0\u13f4"
        + "\u1401\u166c"
        + "\u166f\u167f"
        + "\u1681\u169a"
        + "\u16a0\u16ea"
        + "\u16ee\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1711"
        + "\u1720\u1731"
        + "\u1740\u1751"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1780\u17b3"
        + "\u17d7\u17d7"
        + "\u17dc\u17dc"
        + "\u1820\u1877"
        + "\u1880\u18a8"
        + "\u18aa\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1950\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19c1\u19c7"
        + "\u1a00\u1a16"
        + "\u1a20\u1a54"
        + "\u1aa7\u1aa7"
        + "\u1b05\u1b33"
        + "\u1b45\u1b4b"
        + "\u1b83\u1ba0"
        + "\u1bae\u1baf"
        + "\u1bba\u1be5"
        + "\u1c00\u1c23"
        + "\u1c4d\u1c4f"
        + "\u1c5a\u1c7d"
        + "\u1ce9\u1cec"
        + "\u1cee\u1cf1"
        + "\u1cf5\u1cf6"
        + "\u2135\u2138"
        + "\u2180\u2182"
        + "\u2185\u2188"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d6f"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2e2f\u2e2f"
        + "\u3005\u3007"
        + "\u3021\u3029"
        + "\u3031\u3035"
        + "\u3038\u303c"
        + "\u3041\u3096"
        + "\u309d\u309f"
        + "\u30a1\u30fa"
        + "\u30fc\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u31a0\u31ba"
        + "\u31f0\u31ff"
        + "\u3400\u4db5"
        + "\u4e00\u9fcc"
        + "\ua000\ua48c"
        + "\ua4d0\ua4fd"
        + "\ua500\ua60c"
        + "\ua610\ua61f"
        + "\ua62a\ua62b"
        + "\ua66e\ua66e"
        + "\ua67f\ua67f"
        + "\ua6a0\ua6ef"
        + "\ua717\ua71f"
        + "\ua788\ua788"
        + "\ua7f7\ua7f7"
        + "\ua7fb\ua801"
        + "\ua803\ua805"
        + "\ua807\ua80a"
        + "\ua80c\ua822"
        + "\ua840\ua873"
        + "\ua882\ua8b3"
        + "\ua8f2\ua8f7"
        + "\ua8fb\ua8fb"
        + "\ua90a\ua925"
        + "\ua930\ua946"
        + "\ua960\ua97c"
        + "\ua984\ua9b2"
        + "\ua9cf\ua9cf"
        + "\ua9e0\ua9e4"
        + "\ua9e6\ua9ef"
        + "\ua9fa\ua9fe"
        + "\uaa00\uaa28"
        + "\uaa40\uaa42"
        + "\uaa44\uaa4b"
        + "\uaa60\uaa76"
        + "\uaa7a\uaa7a"
        + "\uaa7e\uaaaf"
        + "\uaab1\uaab1"
        + "\uaab5\uaab6"
        + "\uaab9\uaabd"
        + "\uaac0\uaac0"
        + "\uaac2\uaac2"
        + "\uaadb\uaadd"
        + "\uaae0\uaaea"
        + "\uaaf2\uaaf4"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uabc0\uabe2"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\uf900\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb1d\ufb1d"
        + "\ufb1f\ufb28"
        + "\ufb2a\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufd3d"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfb"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\uff66\uff9d"
        + "\uffa0\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd40\ud800\udd74"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udf00\ud800\udf1f"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf50\ud800\udf75"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udfa0\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfcf"
        + "\ud800\udfd1\ud800\udfd5"
        + "\ud801\udc50\ud801\udc9d"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc60\ud802\udc76"
        + "\ud802\udc80\ud802\udc9e"
        + "\ud802\udd00\ud802\udd15"
        + "\ud802\udd20\ud802\udd39"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude00"
        + "\ud802\ude10\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude60\ud802\ude7c"
        + "\ud802\ude80\ud802\ude9c"
        + "\ud802\udec0\ud802\udec7"
        + "\ud802\udec9\ud802\udee4"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf40\ud802\udf55"
        + "\ud802\udf60\ud802\udf72"
        + "\ud802\udf80\ud802\udf91"
        + "\ud803\udc00\ud803\udc48"
        + "\ud804\udc03\ud804\udc37"
        + "\ud804\udc83\ud804\udcaf"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udd03\ud804\udd26"
        + "\ud804\udd50\ud804\udd72"
        + "\ud804\udd76\ud804\udd76"
        + "\ud804\udd83\ud804\uddb2"
        + "\ud804\uddc1\ud804\uddc4"
        + "\ud804\uddda\ud804\uddda"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude2b"
        + "\ud804\udeb0\ud804\udede"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3d\ud804\udf3d"
        + "\ud804\udf5d\ud804\udf61"
        + "\ud805\udc80\ud805\udcaf"
        + "\ud805\udcc4\ud805\udcc5"
        + "\ud805\udcc7\ud805\udcc7"
        + "\ud805\udd80\ud805\uddae"
        + "\ud805\ude00\ud805\ude2f"
        + "\ud805\ude44\ud805\ude44"
        + "\ud805\ude80\ud805\udeaa"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud809\udc00\ud809\udc6e"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udf00\ud81a\udf2f"
        + "\ud81a\udf40\ud81a\udf43"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf50"
        + "\ud81b\udf93\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d"
        + "\ud87e\udc00\ud87e\ude1d",
    // Unicode 7.0 property value: {sentencebreak=other}
    "\000\u0008"
        + "\u000e\u001f"
        + "\u0023\u0026"
        + "\u002a\u002b"
        + "\u002f\u002f"
        + "\u003b\u003e"
        + "\u0040\u0040"
        + "\\\\"
        + "\u005e\u0060"
        + "\u007c\u007c"
        + "\u007e\u0084"
        + "\u0086\u009f"
        + "\u00a1\u00a9"
        + "\u00ac\u00ac"
        + "\u00ae\u00b4"
        + "\u00b6\u00b9"
        + "\u00bc\u00bf"
        + "\u00d7\u00d7"
        + "\u00f7\u00f7"
        + "\u02c2\u02c5"
        + "\u02d2\u02df"
        + "\u02e5\u02eb"
        + "\u02ed\u02ed"
        + "\u02ef\u02ff"
        + "\u0375\u0375"
        + "\u0378\u0379"
        + "\u037e\u037e"
        + "\u0380\u0385"
        + "\u0387\u0387"
        + "\u038b\u038b"
        + "\u038d\u038d"
        + "\u03a2\u03a2"
        + "\u03f6\u03f6"
        + "\u0482\u0482"
        + "\u0530\u0530"
        + "\u0557\u0558"
        + "\u055a\u055c"
        + "\u055e\u0560"
        + "\u0588\u0588"
        + "\u058a\u0590"
        + "\u05be\u05be"
        + "\u05c0\u05c0"
        + "\u05c3\u05c3"
        + "\u05c6\u05c6"
        + "\u05c8\u05cf"
        + "\u05eb\u05ef"
        + "\u05f4\u05ff"
        + "\u0606\u060b"
        + "\u060e\u060f"
        + "\u061b\u061b"
        + "\u061d\u061e"
        + "\u066a\u066a"
        + "\u066d\u066d"
        + "\u06de\u06de"
        + "\u06e9\u06e9"
        + "\u06fd\u06fe"
        + "\u0703\u070e"
        + "\u074b\u074c"
        + "\u07b2\u07bf"
        + "\u07f6\u07f7"
        + "\u07fb\u07ff"
        + "\u082e\u083f"
        + "\u085c\u089f"
        + "\u08b3\u08e3"
        + "\u0970\u0970"
        + "\u0984\u0984"
        + "\u098d\u098e"
        + "\u0991\u0992"
        + "\u09a9\u09a9"
        + "\u09b1\u09b1"
        + "\u09b3\u09b5"
        + "\u09ba\u09bb"
        + "\u09c5\u09c6"
        + "\u09c9\u09ca"
        + "\u09cf\u09d6"
        + "\u09d8\u09db"
        + "\u09de\u09de"
        + "\u09e4\u09e5"
        + "\u09f2\u0a00"
        + "\u0a04\u0a04"
        + "\u0a0b\u0a0e"
        + "\u0a11\u0a12"
        + "\u0a29\u0a29"
        + "\u0a31\u0a31"
        + "\u0a34\u0a34"
        + "\u0a37\u0a37"
        + "\u0a3a\u0a3b"
        + "\u0a3d\u0a3d"
        + "\u0a43\u0a46"
        + "\u0a49\u0a4a"
        + "\u0a4e\u0a50"
        + "\u0a52\u0a58"
        + "\u0a5d\u0a5d"
        + "\u0a5f\u0a65"
        + "\u0a76\u0a80"
        + "\u0a84\u0a84"
        + "\u0a8e\u0a8e"
        + "\u0a92\u0a92"
        + "\u0aa9\u0aa9"
        + "\u0ab1\u0ab1"
        + "\u0ab4\u0ab4"
        + "\u0aba\u0abb"
        + "\u0ac6\u0ac6"
        + "\u0aca\u0aca"
        + "\u0ace\u0acf"
        + "\u0ad1\u0adf"
        + "\u0ae4\u0ae5"
        + "\u0af0\u0b00"
        + "\u0b04\u0b04"
        + "\u0b0d\u0b0e"
        + "\u0b11\u0b12"
        + "\u0b29\u0b29"
        + "\u0b31\u0b31"
        + "\u0b34\u0b34"
        + "\u0b3a\u0b3b"
        + "\u0b45\u0b46"
        + "\u0b49\u0b4a"
        + "\u0b4e\u0b55"
        + "\u0b58\u0b5b"
        + "\u0b5e\u0b5e"
        + "\u0b64\u0b65"
        + "\u0b70\u0b70"
        + "\u0b72\u0b81"
        + "\u0b84\u0b84"
        + "\u0b8b\u0b8d"
        + "\u0b91\u0b91"
        + "\u0b96\u0b98"
        + "\u0b9b\u0b9b"
        + "\u0b9d\u0b9d"
        + "\u0ba0\u0ba2"
        + "\u0ba5\u0ba7"
        + "\u0bab\u0bad"
        + "\u0bba\u0bbd"
        + "\u0bc3\u0bc5"
        + "\u0bc9\u0bc9"
        + "\u0bce\u0bcf"
        + "\u0bd1\u0bd6"
        + "\u0bd8\u0be5"
        + "\u0bf0\u0bff"
        + "\u0c04\u0c04"
        + "\u0c0d\u0c0d"
        + "\u0c11\u0c11"
        + "\u0c29\u0c29"
        + "\u0c3a\u0c3c"
        + "\u0c45\u0c45"
        + "\u0c49\u0c49"
        + "\u0c4e\u0c54"
        + "\u0c57\u0c57"
        + "\u0c5a\u0c5f"
        + "\u0c64\u0c65"
        + "\u0c70\u0c80"
        + "\u0c84\u0c84"
        + "\u0c8d\u0c8d"
        + "\u0c91\u0c91"
        + "\u0ca9\u0ca9"
        + "\u0cb4\u0cb4"
        + "\u0cba\u0cbb"
        + "\u0cc5\u0cc5"
        + "\u0cc9\u0cc9"
        + "\u0cce\u0cd4"
        + "\u0cd7\u0cdd"
        + "\u0cdf\u0cdf"
        + "\u0ce4\u0ce5"
        + "\u0cf0\u0cf0"
        + "\u0cf3\u0d00"
        + "\u0d04\u0d04"
        + "\u0d0d\u0d0d"
        + "\u0d11\u0d11"
        + "\u0d3b\u0d3c"
        + "\u0d45\u0d45"
        + "\u0d49\u0d49"
        + "\u0d4f\u0d56"
        + "\u0d58\u0d5f"
        + "\u0d64\u0d65"
        + "\u0d70\u0d79"
        + "\u0d80\u0d81"
        + "\u0d84\u0d84"
        + "\u0d97\u0d99"
        + "\u0db2\u0db2"
        + "\u0dbc\u0dbc"
        + "\u0dbe\u0dbf"
        + "\u0dc7\u0dc9"
        + "\u0dcb\u0dce"
        + "\u0dd5\u0dd5"
        + "\u0dd7\u0dd7"
        + "\u0de0\u0de5"
        + "\u0df0\u0df1"
        + "\u0df4\u0e00"
        + "\u0e3b\u0e3f"
        + "\u0e4f\u0e4f"
        + "\u0e5a\u0e80"
        + "\u0e83\u0e83"
        + "\u0e85\u0e86"
        + "\u0e89\u0e89"
        + "\u0e8b\u0e8c"
        + "\u0e8e\u0e93"
        + "\u0e98\u0e98"
        + "\u0ea0\u0ea0"
        + "\u0ea4\u0ea4"
        + "\u0ea6\u0ea6"
        + "\u0ea8\u0ea9"
        + "\u0eac\u0eac"
        + "\u0eba\u0eba"
        + "\u0ebe\u0ebf"
        + "\u0ec5\u0ec5"
        + "\u0ec7\u0ec7"
        + "\u0ece\u0ecf"
        + "\u0eda\u0edb"
        + "\u0ee0\u0eff"
        + "\u0f01\u0f17"
        + "\u0f1a\u0f1f"
        + "\u0f2a\u0f34"
        + "\u0f36\u0f36"
        + "\u0f38\u0f38"
        + "\u0f48\u0f48"
        + "\u0f6d\u0f70"
        + "\u0f85\u0f85"
        + "\u0f98\u0f98"
        + "\u0fbd\u0fc5"
        + "\u0fc7\u0fff"
        + "\u104c\u104f"
        + "\u109e\u109f"
        + "\u10c6\u10c6"
        + "\u10c8\u10cc"
        + "\u10ce\u10cf"
        + "\u10fb\u10fb"
        + "\u1249\u1249"
        + "\u124e\u124f"
        + "\u1257\u1257"
        + "\u1259\u1259"
        + "\u125e\u125f"
        + "\u1289\u1289"
        + "\u128e\u128f"
        + "\u12b1\u12b1"
        + "\u12b6\u12b7"
        + "\u12bf\u12bf"
        + "\u12c1\u12c1"
        + "\u12c6\u12c7"
        + "\u12d7\u12d7"
        + "\u1311\u1311"
        + "\u1316\u1317"
        + "\u135b\u135c"
        + "\u1360\u1361"
        + "\u1363\u1366"
        + "\u1369\u137f"
        + "\u1390\u139f"
        + "\u13f5\u1400"
        + "\u166d\u166d"
        + "\u169d\u169f"
        + "\u16eb\u16ed"
        + "\u16f9\u16ff"
        + "\u170d\u170d"
        + "\u1715\u171f"
        + "\u1737\u173f"
        + "\u1754\u175f"
        + "\u176d\u176d"
        + "\u1771\u1771"
        + "\u1774\u177f"
        + "\u17d4\u17d6"
        + "\u17d8\u17db"
        + "\u17de\u17df"
        + "\u17ea\u1801"
        + "\u1804\u1807"
        + "\u180a\u180a"
        + "\u180f\u180f"
        + "\u181a\u181f"
        + "\u1878\u187f"
        + "\u18ab\u18af"
        + "\u18f6\u18ff"
        + "\u191f\u191f"
        + "\u192c\u192f"
        + "\u193c\u1943"
        + "\u196e\u196f"
        + "\u1975\u197f"
        + "\u19ac\u19af"
        + "\u19ca\u19cf"
        + "\u19da\u19ff"
        + "\u1a1c\u1a1f"
        + "\u1a5f\u1a5f"
        + "\u1a7d\u1a7e"
        + "\u1a8a\u1a8f"
        + "\u1a9a\u1aa6"
        + "\u1aac\u1aaf"
        + "\u1abf\u1aff"
        + "\u1b4c\u1b4f"
        + "\u1b5c\u1b5d"
        + "\u1b60\u1b6a"
        + "\u1b74\u1b7f"
        + "\u1bf4\u1bff"
        + "\u1c38\u1c3a"
        + "\u1c3d\u1c3f"
        + "\u1c4a\u1c4c"
        + "\u1c80\u1ccf"
        + "\u1cd3\u1cd3"
        + "\u1cf7\u1cf7"
        + "\u1cfa\u1cff"
        + "\u1df6\u1dfb"
        + "\u1f16\u1f17"
        + "\u1f1e\u1f1f"
        + "\u1f46\u1f47"
        + "\u1f4e\u1f4f"
        + "\u1f58\u1f58"
        + "\u1f5a\u1f5a"
        + "\u1f5c\u1f5c"
        + "\u1f5e\u1f5e"
        + "\u1f7e\u1f7f"
        + "\u1fb5\u1fb5"
        + "\u1fbd\u1fbd"
        + "\u1fbf\u1fc1"
        + "\u1fc5\u1fc5"
        + "\u1fcd\u1fcf"
        + "\u1fd4\u1fd5"
        + "\u1fdc\u1fdf"
        + "\u1fed\u1ff1"
        + "\u1ff5\u1ff5"
        + "\u1ffd\u1fff"
        + "\u2010\u2012"
        + "\u2015\u2017"
        + "\u2020\u2023"
        + "\u2025\u2027"
        + "\u2030\u2038"
        + "\u203b\u203b"
        + "\u203e\u2044"
        + "\u204a\u205e"
        + "\u2065\u2065"
        + "\u2070\u2070"
        + "\u2072\u207c"
        + "\u2080\u208c"
        + "\u208f\u208f"
        + "\u209d\u20cf"
        + "\u20f1\u2101"
        + "\u2103\u2106"
        + "\u2108\u2109"
        + "\u2114\u2114"
        + "\u2116\u2118"
        + "\u211e\u2123"
        + "\u2125\u2125"
        + "\u2127\u2127"
        + "\u2129\u2129"
        + "\u212e\u212e"
        + "\u213a\u213b"
        + "\u2140\u2144"
        + "\u214a\u214d"
        + "\u214f\u215f"
        + "\u2189\u2307"
        + "\u230c\u2328"
        + "\u232b\u24b5"
        + "\u24ea\u275a"
        + "\u2761\u2767"
        + "\u2776\u27c4"
        + "\u27c7\u27e5"
        + "\u27f0\u2982"
        + "\u2999\u29d7"
        + "\u29dc\u29fb"
        + "\u29fe\u2bff"
        + "\u2c2f\u2c2f"
        + "\u2c5f\u2c5f"
        + "\u2ce5\u2cea"
        + "\u2cf4\u2cff"
        + "\u2d26\u2d26"
        + "\u2d28\u2d2c"
        + "\u2d2e\u2d2f"
        + "\u2d68\u2d6e"
        + "\u2d70\u2d7e"
        + "\u2d97\u2d9f"
        + "\u2da7\u2da7"
        + "\u2daf\u2daf"
        + "\u2db7\u2db7"
        + "\u2dbf\u2dbf"
        + "\u2dc7\u2dc7"
        + "\u2dcf\u2dcf"
        + "\u2dd7\u2dd7"
        + "\u2ddf\u2ddf"
        + "\u2e0e\u2e1b"
        + "\u2e1e\u2e1f"
        + "\u2e2a\u2e2d"
        + "\u2e30\u2e3b"
        + "\u2e3d\u2e41"
        + "\u2e43\u2fff"
        + "\u3003\u3004"
        + "\u3012\u3013"
        + "\u301c\u301c"
        + "\u3020\u3020"
        + "\u3030\u3030"
        + "\u3036\u3037"
        + "\u303d\u3040"
        + "\u3097\u3098"
        + "\u309b\u309c"
        + "\u30a0\u30a0"
        + "\u30fb\u30fb"
        + "\u3100\u3104"
        + "\u312e\u3130"
        + "\u318f\u319f"
        + "\u31bb\u31ef"
        + "\u3200\u33ff"
        + "\u4db6\u4dff"
        + "\u9fcd\u9fff"
        + "\ua48d\ua4cf"
        + "\ua4fe\ua4fe"
        + "\ua60d\ua60d"
        + "\ua62c\ua63f"
        + "\ua673\ua673"
        + "\ua67e\ua67e"
        + "\ua69e\ua69e"
        + "\ua6f2\ua6f2"
        + "\ua6f4\ua6f6"
        + "\ua6f8\ua716"
        + "\ua720\ua721"
        + "\ua789\ua78a"
        + "\ua78f\ua78f"
        + "\ua7ae\ua7af"
        + "\ua7b2\ua7f6"
        + "\ua828\ua83f"
        + "\ua874\ua875"
        + "\ua878\ua87f"
        + "\ua8c5\ua8cd"
        + "\ua8da\ua8df"
        + "\ua8f8\ua8fa"
        + "\ua8fc\ua8ff"
        + "\ua92e\ua92e"
        + "\ua954\ua95f"
        + "\ua97d\ua97f"
        + "\ua9c1\ua9c7"
        + "\ua9ca\ua9ce"
        + "\ua9da\ua9df"
        + "\ua9ff\ua9ff"
        + "\uaa37\uaa3f"
        + "\uaa4e\uaa4f"
        + "\uaa5a\uaa5c"
        + "\uaa77\uaa79"
        + "\uaac3\uaada"
        + "\uaade\uaadf"
        + "\uaaf7\uab00"
        + "\uab07\uab08"
        + "\uab0f\uab10"
        + "\uab17\uab1f"
        + "\uab27\uab27"
        + "\uab2f\uab2f"
        + "\uab5b\uab5b"
        + "\uab60\uab63"
        + "\uab66\uabbf"
        + "\uabee\uabef"
        + "\uabfa\uabff"
        + "\ud7a4\ud7af"
        + "\ud7c7\ud7ca"
        + "\ud7fc\ud7ff"
        + "\ue000\uf8ff"
        + "\ufa6e\ufa6f"
        + "\ufada\ufaff"
        + "\ufb07\ufb12"
        + "\ufb18\ufb1c"
        + "\ufb29\ufb29"
        + "\ufb37\ufb37"
        + "\ufb3d\ufb3d"
        + "\ufb3f\ufb3f"
        + "\ufb42\ufb42"
        + "\ufb45\ufb45"
        + "\ufbb2\ufbd2"
        + "\ufd40\ufd4f"
        + "\ufd90\ufd91"
        + "\ufdc8\ufdef"
        + "\ufdfc\ufdff"
        + "\ufe12\ufe12"
        + "\ufe14\ufe16"
        + "\ufe19\ufe1f"
        + "\ufe2e\ufe30"
        + "\ufe33\ufe34"
        + "\ufe45\ufe46"
        + "\ufe49\ufe4f"
        + "\ufe53\ufe54"
        + "\ufe5f\ufe62"
        + "\ufe64\ufe6f"
        + "\ufe75\ufe75"
        + "\ufefd\ufefe"
        + "\uff00\uff00"
        + "\uff02\uff07"
        + "\uff0a\uff0b"
        + "\uff0f\uff19"
        + "\uff1b\uff1e"
        + "\uff20\uff20"
        + "\uff3c\uff3c"
        + "\uff3e\uff40"
        + "\uff5c\uff5c"
        + "\uff5e\uff5e"
        + "\uff65\uff65"
        + "\uffbf\uffc1"
        + "\uffc8\uffc9"
        + "\uffd0\uffd1"
        + "\uffd8\uffd9"
        + "\uffdd\ufff8"
        + "\ufffc\uffff"
        + "\ud800\udc0c\ud800\udc0c"
        + "\ud800\udc27\ud800\udc27"
        + "\ud800\udc3b\ud800\udc3b"
        + "\ud800\udc3e\ud800\udc3e"
        + "\ud800\udc4e\ud800\udc4f"
        + "\ud800\udc5e\ud800\udc7f"
        + "\ud800\udcfb\ud800\udd3f"
        + "\ud800\udd75\ud800\uddfc"
        + "\ud800\uddfe\ud800\ude7f"
        + "\ud800\ude9d\ud800\ude9f"
        + "\ud800\uded1\ud800\udedf"
        + "\ud800\udee1\ud800\udeff"
        + "\ud800\udf20\ud800\udf2f"
        + "\ud800\udf4b\ud800\udf4f"
        + "\ud800\udf7b\ud800\udf7f"
        + "\ud800\udf9e\ud800\udf9f"
        + "\ud800\udfc4\ud800\udfc7"
        + "\ud800\udfd0\ud800\udfd0"
        + "\ud800\udfd6\ud800\udfff"
        + "\ud801\udc9e\ud801\udc9f"
        + "\ud801\udcaa\ud801\udcff"
        + "\ud801\udd28\ud801\udd2f"
        + "\ud801\udd64\ud801\uddff"
        + "\ud801\udf37\ud801\udf3f"
        + "\ud801\udf56\ud801\udf5f"
        + "\ud801\udf68\ud801\udfff"
        + "\ud802\udc06\ud802\udc07"
        + "\ud802\udc09\ud802\udc09"
        + "\ud802\udc36\ud802\udc36"
        + "\ud802\udc39\ud802\udc3b"
        + "\ud802\udc3d\ud802\udc3e"
        + "\ud802\udc56\ud802\udc5f"
        + "\ud802\udc77\ud802\udc7f"
        + "\ud802\udc9f\ud802\udcff"
        + "\ud802\udd16\ud802\udd1f"
        + "\ud802\udd3a\ud802\udd7f"
        + "\ud802\uddb8\ud802\uddbd"
        + "\ud802\uddc0\ud802\uddff"
        + "\ud802\ude04\ud802\ude04"
        + "\ud802\ude07\ud802\ude0b"
        + "\ud802\ude14\ud802\ude14"
        + "\ud802\ude18\ud802\ude18"
        + "\ud802\ude34\ud802\ude37"
        + "\ud802\ude3b\ud802\ude3e"
        + "\ud802\ude40\ud802\ude55"
        + "\ud802\ude58\ud802\ude5f"
        + "\ud802\ude7d\ud802\ude7f"
        + "\ud802\ude9d\ud802\udebf"
        + "\ud802\udec8\ud802\udec8"
        + "\ud802\udee7\ud802\udeff"
        + "\ud802\udf36\ud802\udf3f"
        + "\ud802\udf56\ud802\udf5f"
        + "\ud802\udf73\ud802\udf7f"
        + "\ud802\udf92\ud802\udfff"
        + "\ud803\udc49\ud803\udfff"
        + "\ud804\udc49\ud804\udc65"
        + "\ud804\udc70\ud804\udc7e"
        + "\ud804\udcbb\ud804\udcbc"
        + "\ud804\udcc2\ud804\udccf"
        + "\ud804\udce9\ud804\udcef"
        + "\ud804\udcfa\ud804\udcff"
        + "\ud804\udd35\ud804\udd35"
        + "\ud804\udd40\ud804\udd40"
        + "\ud804\udd44\ud804\udd4f"
        + "\ud804\udd74\ud804\udd75"
        + "\ud804\udd77\ud804\udd7f"
        + "\ud804\uddc7\ud804\uddcc"
        + "\ud804\uddce\ud804\uddcf"
        + "\ud804\udddb\ud804\uddff"
        + "\ud804\ude12\ud804\ude12"
        + "\ud804\ude3a\ud804\ude3a"
        + "\ud804\ude3d\ud804\udeaf"
        + "\ud804\udeeb\ud804\udeef"
        + "\ud804\udefa\ud804\udf00"
        + "\ud804\udf04\ud804\udf04"
        + "\ud804\udf0d\ud804\udf0e"
        + "\ud804\udf11\ud804\udf12"
        + "\ud804\udf29\ud804\udf29"
        + "\ud804\udf31\ud804\udf31"
        + "\ud804\udf34\ud804\udf34"
        + "\ud804\udf3a\ud804\udf3b"
        + "\ud804\udf45\ud804\udf46"
        + "\ud804\udf49\ud804\udf4a"
        + "\ud804\udf4e\ud804\udf56"
        + "\ud804\udf58\ud804\udf5c"
        + "\ud804\udf64\ud804\udf65"
        + "\ud804\udf6d\ud804\udf6f"
        + "\ud804\udf75\ud805\udc7f"
        + "\ud805\udcc6\ud805\udcc6"
        + "\ud805\udcc8\ud805\udccf"
        + "\ud805\udcda\ud805\udd7f"
        + "\ud805\uddb6\ud805\uddb7"
        + "\ud805\uddc1\ud805\uddc1"
        + "\ud805\uddc4\ud805\uddc8"
        + "\ud805\uddca\ud805\uddff"
        + "\ud805\ude43\ud805\ude43"
        + "\ud805\ude45\ud805\ude4f"
        + "\ud805\ude5a\ud805\ude7f"
        + "\ud805\udeb8\ud805\udebf"
        + "\ud805\udeca\ud806\udc9f"
        + "\ud806\udcea\ud806\udcfe"
        + "\ud806\udd00\ud806\udebf"
        + "\ud806\udef9\ud807\udfff"
        + "\ud808\udf99\ud808\udfff"
        + "\ud809\udc6f\ud80b\udfff"
        + "\ud80d\udc2f\ud819\udfff"
        + "\ud81a\ude39\ud81a\ude3f"
        + "\ud81a\ude5f\ud81a\ude5f"
        + "\ud81a\ude6a\ud81a\ude6d"
        + "\ud81a\ude70\ud81a\udecf"
        + "\ud81a\udeee\ud81a\udeef"
        + "\ud81a\udef6\ud81a\udeff"
        + "\ud81a\udf39\ud81a\udf3f"
        + "\ud81a\udf45\ud81a\udf4f"
        + "\ud81a\udf5a\ud81a\udf62"
        + "\ud81a\udf78\ud81a\udf7c"
        + "\ud81a\udf90\ud81b\udeff"
        + "\ud81b\udf45\ud81b\udf4f"
        + "\ud81b\udf7f\ud81b\udf8e"
        + "\ud81b\udfa0\ud82b\udfff"
        + "\ud82c\udc02\ud82e\udfff"
        + "\ud82f\udc6b\ud82f\udc6f"
        + "\ud82f\udc7d\ud82f\udc7f"
        + "\ud82f\udc89\ud82f\udc8f"
        + "\ud82f\udc9a\ud82f\udc9c"
        + "\ud82f\udca4\ud834\udd64"
        + "\ud834\udd6a\ud834\udd6c"
        + "\ud834\udd83\ud834\udd84"
        + "\ud834\udd8c\ud834\udda9"
        + "\ud834\uddae\ud834\ude41"
        + "\ud834\ude45\ud834\udfff"
        + "\ud835\udc55\ud835\udc55"
        + "\ud835\udc9d\ud835\udc9d"
        + "\ud835\udca0\ud835\udca1"
        + "\ud835\udca3\ud835\udca4"
        + "\ud835\udca7\ud835\udca8"
        + "\ud835\udcad\ud835\udcad"
        + "\ud835\udcba\ud835\udcba"
        + "\ud835\udcbc\ud835\udcbc"
        + "\ud835\udcc4\ud835\udcc4"
        + "\ud835\udd06\ud835\udd06"
        + "\ud835\udd0b\ud835\udd0c"
        + "\ud835\udd15\ud835\udd15"
        + "\ud835\udd1d\ud835\udd1d"
        + "\ud835\udd3a\ud835\udd3a"
        + "\ud835\udd3f\ud835\udd3f"
        + "\ud835\udd45\ud835\udd45"
        + "\ud835\udd47\ud835\udd49"
        + "\ud835\udd51\ud835\udd51"
        + "\ud835\udea6\ud835\udea7"
        + "\ud835\udec1\ud835\udec1"
        + "\ud835\udedb\ud835\udedb"
        + "\ud835\udefb\ud835\udefb"
        + "\ud835\udf15\ud835\udf15"
        + "\ud835\udf35\ud835\udf35"
        + "\ud835\udf4f\ud835\udf4f"
        + "\ud835\udf6f\ud835\udf6f"
        + "\ud835\udf89\ud835\udf89"
        + "\ud835\udfa9\ud835\udfa9"
        + "\ud835\udfc3\ud835\udfc3"
        + "\ud835\udfcc\ud835\udfcd"
        + "\ud836\udc00\ud839\udfff"
        + "\ud83a\udcc5\ud83a\udccf"
        + "\ud83a\udcd7\ud83b\uddff"
        + "\ud83b\ude04\ud83b\ude04"
        + "\ud83b\ude20\ud83b\ude20"
        + "\ud83b\ude23\ud83b\ude23"
        + "\ud83b\ude25\ud83b\ude26"
        + "\ud83b\ude28\ud83b\ude28"
        + "\ud83b\ude33\ud83b\ude33"
        + "\ud83b\ude38\ud83b\ude38"
        + "\ud83b\ude3a\ud83b\ude3a"
        + "\ud83b\ude3c\ud83b\ude41"
        + "\ud83b\ude43\ud83b\ude46"
        + "\ud83b\ude48\ud83b\ude48"
        + "\ud83b\ude4a\ud83b\ude4a"
        + "\ud83b\ude4c\ud83b\ude4c"
        + "\ud83b\ude50\ud83b\ude50"
        + "\ud83b\ude53\ud83b\ude53"
        + "\ud83b\ude55\ud83b\ude56"
        + "\ud83b\ude58\ud83b\ude58"
        + "\ud83b\ude5a\ud83b\ude5a"
        + "\ud83b\ude5c\ud83b\ude5c"
        + "\ud83b\ude5e\ud83b\ude5e"
        + "\ud83b\ude60\ud83b\ude60"
        + "\ud83b\ude63\ud83b\ude63"
        + "\ud83b\ude65\ud83b\ude66"
        + "\ud83b\ude6b\ud83b\ude6b"
        + "\ud83b\ude73\ud83b\ude73"
        + "\ud83b\ude78\ud83b\ude78"
        + "\ud83b\ude7d\ud83b\ude7d"
        + "\ud83b\ude7f\ud83b\ude7f"
        + "\ud83b\ude8a\ud83b\ude8a"
        + "\ud83b\ude9c\ud83b\udea0"
        + "\ud83b\udea4\ud83b\udea4"
        + "\ud83b\udeaa\ud83b\udeaa"
        + "\ud83b\udebc\ud83c\udd2f"
        + "\ud83c\udd4a\ud83c\udd4f"
        + "\ud83c\udd6a\ud83c\udd6f"
        + "\ud83c\udd8a\ud83d\ude75"
        + "\ud83d\ude79\ud83f\udfff"
        + "\ud869\uded7\ud869\udeff"
        + "\ud86d\udf35\ud86d\udf3f"
        + "\ud86e\udc1e\ud87d\udfff"
        + "\ud87e\ude1e\udb40\udc00"
        + "\udb40\udc02\udb40\udc1f"
        + "\udb40\udc80\udb40\udcff"
        + "\udb40\uddf0\udbff\udfff",
    // Unicode 7.0 property value: {sentencebreak=scontinue}
    "\u002c\u002d"
        + "\u003a\u003a"
        + "\u055d\u055d"
        + "\u060c\u060d"
        + "\u07f8\u07f8"
        + "\u1802\u1802"
        + "\u1808\u1808"
        + "\u2013\u2014"
        + "\u3001\u3001"
        + "\ufe10\ufe11"
        + "\ufe13\ufe13"
        + "\ufe31\ufe32"
        + "\ufe50\ufe51"
        + "\ufe55\ufe55"
        + "\ufe58\ufe58"
        + "\ufe63\ufe63"
        + "\uff0c\uff0d"
        + "\uff1a\uff1a"
        + "\uff64\uff64",
    // Unicode 7.0 property value: {sentencebreak=sep}
    "\u0085\u0085" + "\u2028\u2029",
    // Unicode 7.0 property value: {sentencebreak=sp}
    "\t\t"
        + "\u000b\f"
        + "\u0020\u0020"
        + "\u00a0\u00a0"
        + "\u1680\u1680"
        + "\u2000\u200a"
        + "\u202f\u202f"
        + "\u205f\u205f"
        + "\u3000\u3000",
    // Unicode 7.0 property value: {sentencebreak=sterm}
    "\u0021\u0021"
        + "\u003f\u003f"
        + "\u0589\u0589"
        + "\u061f\u061f"
        + "\u06d4\u06d4"
        + "\u0700\u0702"
        + "\u07f9\u07f9"
        + "\u0964\u0965"
        + "\u104a\u104b"
        + "\u1362\u1362"
        + "\u1367\u1368"
        + "\u166e\u166e"
        + "\u1735\u1736"
        + "\u1803\u1803"
        + "\u1809\u1809"
        + "\u1944\u1945"
        + "\u1aa8\u1aab"
        + "\u1b5a\u1b5b"
        + "\u1b5e\u1b5f"
        + "\u1c3b\u1c3c"
        + "\u1c7e\u1c7f"
        + "\u203c\u203d"
        + "\u2047\u2049"
        + "\u2e2e\u2e2e"
        + "\u2e3c\u2e3c"
        + "\u3002\u3002"
        + "\ua4ff\ua4ff"
        + "\ua60e\ua60f"
        + "\ua6f3\ua6f3"
        + "\ua6f7\ua6f7"
        + "\ua876\ua877"
        + "\ua8ce\ua8cf"
        + "\ua92f\ua92f"
        + "\ua9c8\ua9c9"
        + "\uaa5d\uaa5f"
        + "\uaaf0\uaaf1"
        + "\uabeb\uabeb"
        + "\ufe56\ufe57"
        + "\uff01\uff01"
        + "\uff1f\uff1f"
        + "\uff61\uff61"
        + "\ud802\ude56\ud802\ude57"
        + "\ud804\udc47\ud804\udc48"
        + "\ud804\udcbe\ud804\udcc1"
        + "\ud804\udd41\ud804\udd43"
        + "\ud804\uddc5\ud804\uddc6"
        + "\ud804\uddcd\ud804\uddcd"
        + "\ud804\ude38\ud804\ude39"
        + "\ud804\ude3b\ud804\ude3c"
        + "\ud805\uddc2\ud805\uddc3"
        + "\ud805\uddc9\ud805\uddc9"
        + "\ud805\ude41\ud805\ude42"
        + "\ud81a\ude6e\ud81a\ude6f"
        + "\ud81a\udef5\ud81a\udef5"
        + "\ud81a\udf37\ud81a\udf38"
        + "\ud81a\udf44\ud81a\udf44"
        + "\ud82f\udc9f\ud82f\udc9f",
    // Unicode 7.0 property value: {sentencebreak=upper}
    "\u0041\u005a"
        + "\u00c0\u00d6"
        + "\u00d8\u00de"
        + "\u0100\u0100"
        + "\u0102\u0102"
        + "\u0104\u0104"
        + "\u0106\u0106"
        + "\u0108\u0108"
        + "\u010a\u010a"
        + "\u010c\u010c"
        + "\u010e\u010e"
        + "\u0110\u0110"
        + "\u0112\u0112"
        + "\u0114\u0114"
        + "\u0116\u0116"
        + "\u0118\u0118"
        + "\u011a\u011a"
        + "\u011c\u011c"
        + "\u011e\u011e"
        + "\u0120\u0120"
        + "\u0122\u0122"
        + "\u0124\u0124"
        + "\u0126\u0126"
        + "\u0128\u0128"
        + "\u012a\u012a"
        + "\u012c\u012c"
        + "\u012e\u012e"
        + "\u0130\u0130"
        + "\u0132\u0132"
        + "\u0134\u0134"
        + "\u0136\u0136"
        + "\u0139\u0139"
        + "\u013b\u013b"
        + "\u013d\u013d"
        + "\u013f\u013f"
        + "\u0141\u0141"
        + "\u0143\u0143"
        + "\u0145\u0145"
        + "\u0147\u0147"
        + "\u014a\u014a"
        + "\u014c\u014c"
        + "\u014e\u014e"
        + "\u0150\u0150"
        + "\u0152\u0152"
        + "\u0154\u0154"
        + "\u0156\u0156"
        + "\u0158\u0158"
        + "\u015a\u015a"
        + "\u015c\u015c"
        + "\u015e\u015e"
        + "\u0160\u0160"
        + "\u0162\u0162"
        + "\u0164\u0164"
        + "\u0166\u0166"
        + "\u0168\u0168"
        + "\u016a\u016a"
        + "\u016c\u016c"
        + "\u016e\u016e"
        + "\u0170\u0170"
        + "\u0172\u0172"
        + "\u0174\u0174"
        + "\u0176\u0176"
        + "\u0178\u0179"
        + "\u017b\u017b"
        + "\u017d\u017d"
        + "\u0181\u0182"
        + "\u0184\u0184"
        + "\u0186\u0187"
        + "\u0189\u018b"
        + "\u018e\u0191"
        + "\u0193\u0194"
        + "\u0196\u0198"
        + "\u019c\u019d"
        + "\u019f\u01a0"
        + "\u01a2\u01a2"
        + "\u01a4\u01a4"
        + "\u01a6\u01a7"
        + "\u01a9\u01a9"
        + "\u01ac\u01ac"
        + "\u01ae\u01af"
        + "\u01b1\u01b3"
        + "\u01b5\u01b5"
        + "\u01b7\u01b8"
        + "\u01bc\u01bc"
        + "\u01c4\u01c5"
        + "\u01c7\u01c8"
        + "\u01ca\u01cb"
        + "\u01cd\u01cd"
        + "\u01cf\u01cf"
        + "\u01d1\u01d1"
        + "\u01d3\u01d3"
        + "\u01d5\u01d5"
        + "\u01d7\u01d7"
        + "\u01d9\u01d9"
        + "\u01db\u01db"
        + "\u01de\u01de"
        + "\u01e0\u01e0"
        + "\u01e2\u01e2"
        + "\u01e4\u01e4"
        + "\u01e6\u01e6"
        + "\u01e8\u01e8"
        + "\u01ea\u01ea"
        + "\u01ec\u01ec"
        + "\u01ee\u01ee"
        + "\u01f1\u01f2"
        + "\u01f4\u01f4"
        + "\u01f6\u01f8"
        + "\u01fa\u01fa"
        + "\u01fc\u01fc"
        + "\u01fe\u01fe"
        + "\u0200\u0200"
        + "\u0202\u0202"
        + "\u0204\u0204"
        + "\u0206\u0206"
        + "\u0208\u0208"
        + "\u020a\u020a"
        + "\u020c\u020c"
        + "\u020e\u020e"
        + "\u0210\u0210"
        + "\u0212\u0212"
        + "\u0214\u0214"
        + "\u0216\u0216"
        + "\u0218\u0218"
        + "\u021a\u021a"
        + "\u021c\u021c"
        + "\u021e\u021e"
        + "\u0220\u0220"
        + "\u0222\u0222"
        + "\u0224\u0224"
        + "\u0226\u0226"
        + "\u0228\u0228"
        + "\u022a\u022a"
        + "\u022c\u022c"
        + "\u022e\u022e"
        + "\u0230\u0230"
        + "\u0232\u0232"
        + "\u023a\u023b"
        + "\u023d\u023e"
        + "\u0241\u0241"
        + "\u0243\u0246"
        + "\u0248\u0248"
        + "\u024a\u024a"
        + "\u024c\u024c"
        + "\u024e\u024e"
        + "\u0370\u0370"
        + "\u0372\u0372"
        + "\u0376\u0376"
        + "\u037f\u037f"
        + "\u0386\u0386"
        + "\u0388\u038a"
        + "\u038c\u038c"
        + "\u038e\u038f"
        + "\u0391\u03a1"
        + "\u03a3\u03ab"
        + "\u03cf\u03cf"
        + "\u03d2\u03d4"
        + "\u03d8\u03d8"
        + "\u03da\u03da"
        + "\u03dc\u03dc"
        + "\u03de\u03de"
        + "\u03e0\u03e0"
        + "\u03e2\u03e2"
        + "\u03e4\u03e4"
        + "\u03e6\u03e6"
        + "\u03e8\u03e8"
        + "\u03ea\u03ea"
        + "\u03ec\u03ec"
        + "\u03ee\u03ee"
        + "\u03f4\u03f4"
        + "\u03f7\u03f7"
        + "\u03f9\u03fa"
        + "\u03fd\u042f"
        + "\u0460\u0460"
        + "\u0462\u0462"
        + "\u0464\u0464"
        + "\u0466\u0466"
        + "\u0468\u0468"
        + "\u046a\u046a"
        + "\u046c\u046c"
        + "\u046e\u046e"
        + "\u0470\u0470"
        + "\u0472\u0472"
        + "\u0474\u0474"
        + "\u0476\u0476"
        + "\u0478\u0478"
        + "\u047a\u047a"
        + "\u047c\u047c"
        + "\u047e\u047e"
        + "\u0480\u0480"
        + "\u048a\u048a"
        + "\u048c\u048c"
        + "\u048e\u048e"
        + "\u0490\u0490"
        + "\u0492\u0492"
        + "\u0494\u0494"
        + "\u0496\u0496"
        + "\u0498\u0498"
        + "\u049a\u049a"
        + "\u049c\u049c"
        + "\u049e\u049e"
        + "\u04a0\u04a0"
        + "\u04a2\u04a2"
        + "\u04a4\u04a4"
        + "\u04a6\u04a6"
        + "\u04a8\u04a8"
        + "\u04aa\u04aa"
        + "\u04ac\u04ac"
        + "\u04ae\u04ae"
        + "\u04b0\u04b0"
        + "\u04b2\u04b2"
        + "\u04b4\u04b4"
        + "\u04b6\u04b6"
        + "\u04b8\u04b8"
        + "\u04ba\u04ba"
        + "\u04bc\u04bc"
        + "\u04be\u04be"
        + "\u04c0\u04c1"
        + "\u04c3\u04c3"
        + "\u04c5\u04c5"
        + "\u04c7\u04c7"
        + "\u04c9\u04c9"
        + "\u04cb\u04cb"
        + "\u04cd\u04cd"
        + "\u04d0\u04d0"
        + "\u04d2\u04d2"
        + "\u04d4\u04d4"
        + "\u04d6\u04d6"
        + "\u04d8\u04d8"
        + "\u04da\u04da"
        + "\u04dc\u04dc"
        + "\u04de\u04de"
        + "\u04e0\u04e0"
        + "\u04e2\u04e2"
        + "\u04e4\u04e4"
        + "\u04e6\u04e6"
        + "\u04e8\u04e8"
        + "\u04ea\u04ea"
        + "\u04ec\u04ec"
        + "\u04ee\u04ee"
        + "\u04f0\u04f0"
        + "\u04f2\u04f2"
        + "\u04f4\u04f4"
        + "\u04f6\u04f6"
        + "\u04f8\u04f8"
        + "\u04fa\u04fa"
        + "\u04fc\u04fc"
        + "\u04fe\u04fe"
        + "\u0500\u0500"
        + "\u0502\u0502"
        + "\u0504\u0504"
        + "\u0506\u0506"
        + "\u0508\u0508"
        + "\u050a\u050a"
        + "\u050c\u050c"
        + "\u050e\u050e"
        + "\u0510\u0510"
        + "\u0512\u0512"
        + "\u0514\u0514"
        + "\u0516\u0516"
        + "\u0518\u0518"
        + "\u051a\u051a"
        + "\u051c\u051c"
        + "\u051e\u051e"
        + "\u0520\u0520"
        + "\u0522\u0522"
        + "\u0524\u0524"
        + "\u0526\u0526"
        + "\u0528\u0528"
        + "\u052a\u052a"
        + "\u052c\u052c"
        + "\u052e\u052e"
        + "\u0531\u0556"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u1e00\u1e00"
        + "\u1e02\u1e02"
        + "\u1e04\u1e04"
        + "\u1e06\u1e06"
        + "\u1e08\u1e08"
        + "\u1e0a\u1e0a"
        + "\u1e0c\u1e0c"
        + "\u1e0e\u1e0e"
        + "\u1e10\u1e10"
        + "\u1e12\u1e12"
        + "\u1e14\u1e14"
        + "\u1e16\u1e16"
        + "\u1e18\u1e18"
        + "\u1e1a\u1e1a"
        + "\u1e1c\u1e1c"
        + "\u1e1e\u1e1e"
        + "\u1e20\u1e20"
        + "\u1e22\u1e22"
        + "\u1e24\u1e24"
        + "\u1e26\u1e26"
        + "\u1e28\u1e28"
        + "\u1e2a\u1e2a"
        + "\u1e2c\u1e2c"
        + "\u1e2e\u1e2e"
        + "\u1e30\u1e30"
        + "\u1e32\u1e32"
        + "\u1e34\u1e34"
        + "\u1e36\u1e36"
        + "\u1e38\u1e38"
        + "\u1e3a\u1e3a"
        + "\u1e3c\u1e3c"
        + "\u1e3e\u1e3e"
        + "\u1e40\u1e40"
        + "\u1e42\u1e42"
        + "\u1e44\u1e44"
        + "\u1e46\u1e46"
        + "\u1e48\u1e48"
        + "\u1e4a\u1e4a"
        + "\u1e4c\u1e4c"
        + "\u1e4e\u1e4e"
        + "\u1e50\u1e50"
        + "\u1e52\u1e52"
        + "\u1e54\u1e54"
        + "\u1e56\u1e56"
        + "\u1e58\u1e58"
        + "\u1e5a\u1e5a"
        + "\u1e5c\u1e5c"
        + "\u1e5e\u1e5e"
        + "\u1e60\u1e60"
        + "\u1e62\u1e62"
        + "\u1e64\u1e64"
        + "\u1e66\u1e66"
        + "\u1e68\u1e68"
        + "\u1e6a\u1e6a"
        + "\u1e6c\u1e6c"
        + "\u1e6e\u1e6e"
        + "\u1e70\u1e70"
        + "\u1e72\u1e72"
        + "\u1e74\u1e74"
        + "\u1e76\u1e76"
        + "\u1e78\u1e78"
        + "\u1e7a\u1e7a"
        + "\u1e7c\u1e7c"
        + "\u1e7e\u1e7e"
        + "\u1e80\u1e80"
        + "\u1e82\u1e82"
        + "\u1e84\u1e84"
        + "\u1e86\u1e86"
        + "\u1e88\u1e88"
        + "\u1e8a\u1e8a"
        + "\u1e8c\u1e8c"
        + "\u1e8e\u1e8e"
        + "\u1e90\u1e90"
        + "\u1e92\u1e92"
        + "\u1e94\u1e94"
        + "\u1e9e\u1e9e"
        + "\u1ea0\u1ea0"
        + "\u1ea2\u1ea2"
        + "\u1ea4\u1ea4"
        + "\u1ea6\u1ea6"
        + "\u1ea8\u1ea8"
        + "\u1eaa\u1eaa"
        + "\u1eac\u1eac"
        + "\u1eae\u1eae"
        + "\u1eb0\u1eb0"
        + "\u1eb2\u1eb2"
        + "\u1eb4\u1eb4"
        + "\u1eb6\u1eb6"
        + "\u1eb8\u1eb8"
        + "\u1eba\u1eba"
        + "\u1ebc\u1ebc"
        + "\u1ebe\u1ebe"
        + "\u1ec0\u1ec0"
        + "\u1ec2\u1ec2"
        + "\u1ec4\u1ec4"
        + "\u1ec6\u1ec6"
        + "\u1ec8\u1ec8"
        + "\u1eca\u1eca"
        + "\u1ecc\u1ecc"
        + "\u1ece\u1ece"
        + "\u1ed0\u1ed0"
        + "\u1ed2\u1ed2"
        + "\u1ed4\u1ed4"
        + "\u1ed6\u1ed6"
        + "\u1ed8\u1ed8"
        + "\u1eda\u1eda"
        + "\u1edc\u1edc"
        + "\u1ede\u1ede"
        + "\u1ee0\u1ee0"
        + "\u1ee2\u1ee2"
        + "\u1ee4\u1ee4"
        + "\u1ee6\u1ee6"
        + "\u1ee8\u1ee8"
        + "\u1eea\u1eea"
        + "\u1eec\u1eec"
        + "\u1eee\u1eee"
        + "\u1ef0\u1ef0"
        + "\u1ef2\u1ef2"
        + "\u1ef4\u1ef4"
        + "\u1ef6\u1ef6"
        + "\u1ef8\u1ef8"
        + "\u1efa\u1efa"
        + "\u1efc\u1efc"
        + "\u1efe\u1efe"
        + "\u1f08\u1f0f"
        + "\u1f18\u1f1d"
        + "\u1f28\u1f2f"
        + "\u1f38\u1f3f"
        + "\u1f48\u1f4d"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f5f"
        + "\u1f68\u1f6f"
        + "\u1f88\u1f8f"
        + "\u1f98\u1f9f"
        + "\u1fa8\u1faf"
        + "\u1fb8\u1fbc"
        + "\u1fc8\u1fcc"
        + "\u1fd8\u1fdb"
        + "\u1fe8\u1fec"
        + "\u1ff8\u1ffc"
        + "\u2102\u2102"
        + "\u2107\u2107"
        + "\u210b\u210d"
        + "\u2110\u2112"
        + "\u2115\u2115"
        + "\u2119\u211d"
        + "\u2124\u2124"
        + "\u2126\u2126"
        + "\u2128\u2128"
        + "\u212a\u212d"
        + "\u2130\u2133"
        + "\u213e\u213f"
        + "\u2145\u2145"
        + "\u2160\u216f"
        + "\u2183\u2183"
        + "\u24b6\u24cf"
        + "\u2c00\u2c2e"
        + "\u2c60\u2c60"
        + "\u2c62\u2c64"
        + "\u2c67\u2c67"
        + "\u2c69\u2c69"
        + "\u2c6b\u2c6b"
        + "\u2c6d\u2c70"
        + "\u2c72\u2c72"
        + "\u2c75\u2c75"
        + "\u2c7e\u2c80"
        + "\u2c82\u2c82"
        + "\u2c84\u2c84"
        + "\u2c86\u2c86"
        + "\u2c88\u2c88"
        + "\u2c8a\u2c8a"
        + "\u2c8c\u2c8c"
        + "\u2c8e\u2c8e"
        + "\u2c90\u2c90"
        + "\u2c92\u2c92"
        + "\u2c94\u2c94"
        + "\u2c96\u2c96"
        + "\u2c98\u2c98"
        + "\u2c9a\u2c9a"
        + "\u2c9c\u2c9c"
        + "\u2c9e\u2c9e"
        + "\u2ca0\u2ca0"
        + "\u2ca2\u2ca2"
        + "\u2ca4\u2ca4"
        + "\u2ca6\u2ca6"
        + "\u2ca8\u2ca8"
        + "\u2caa\u2caa"
        + "\u2cac\u2cac"
        + "\u2cae\u2cae"
        + "\u2cb0\u2cb0"
        + "\u2cb2\u2cb2"
        + "\u2cb4\u2cb4"
        + "\u2cb6\u2cb6"
        + "\u2cb8\u2cb8"
        + "\u2cba\u2cba"
        + "\u2cbc\u2cbc"
        + "\u2cbe\u2cbe"
        + "\u2cc0\u2cc0"
        + "\u2cc2\u2cc2"
        + "\u2cc4\u2cc4"
        + "\u2cc6\u2cc6"
        + "\u2cc8\u2cc8"
        + "\u2cca\u2cca"
        + "\u2ccc\u2ccc"
        + "\u2cce\u2cce"
        + "\u2cd0\u2cd0"
        + "\u2cd2\u2cd2"
        + "\u2cd4\u2cd4"
        + "\u2cd6\u2cd6"
        + "\u2cd8\u2cd8"
        + "\u2cda\u2cda"
        + "\u2cdc\u2cdc"
        + "\u2cde\u2cde"
        + "\u2ce0\u2ce0"
        + "\u2ce2\u2ce2"
        + "\u2ceb\u2ceb"
        + "\u2ced\u2ced"
        + "\u2cf2\u2cf2"
        + "\ua640\ua640"
        + "\ua642\ua642"
        + "\ua644\ua644"
        + "\ua646\ua646"
        + "\ua648\ua648"
        + "\ua64a\ua64a"
        + "\ua64c\ua64c"
        + "\ua64e\ua64e"
        + "\ua650\ua650"
        + "\ua652\ua652"
        + "\ua654\ua654"
        + "\ua656\ua656"
        + "\ua658\ua658"
        + "\ua65a\ua65a"
        + "\ua65c\ua65c"
        + "\ua65e\ua65e"
        + "\ua660\ua660"
        + "\ua662\ua662"
        + "\ua664\ua664"
        + "\ua666\ua666"
        + "\ua668\ua668"
        + "\ua66a\ua66a"
        + "\ua66c\ua66c"
        + "\ua680\ua680"
        + "\ua682\ua682"
        + "\ua684\ua684"
        + "\ua686\ua686"
        + "\ua688\ua688"
        + "\ua68a\ua68a"
        + "\ua68c\ua68c"
        + "\ua68e\ua68e"
        + "\ua690\ua690"
        + "\ua692\ua692"
        + "\ua694\ua694"
        + "\ua696\ua696"
        + "\ua698\ua698"
        + "\ua69a\ua69a"
        + "\ua722\ua722"
        + "\ua724\ua724"
        + "\ua726\ua726"
        + "\ua728\ua728"
        + "\ua72a\ua72a"
        + "\ua72c\ua72c"
        + "\ua72e\ua72e"
        + "\ua732\ua732"
        + "\ua734\ua734"
        + "\ua736\ua736"
        + "\ua738\ua738"
        + "\ua73a\ua73a"
        + "\ua73c\ua73c"
        + "\ua73e\ua73e"
        + "\ua740\ua740"
        + "\ua742\ua742"
        + "\ua744\ua744"
        + "\ua746\ua746"
        + "\ua748\ua748"
        + "\ua74a\ua74a"
        + "\ua74c\ua74c"
        + "\ua74e\ua74e"
        + "\ua750\ua750"
        + "\ua752\ua752"
        + "\ua754\ua754"
        + "\ua756\ua756"
        + "\ua758\ua758"
        + "\ua75a\ua75a"
        + "\ua75c\ua75c"
        + "\ua75e\ua75e"
        + "\ua760\ua760"
        + "\ua762\ua762"
        + "\ua764\ua764"
        + "\ua766\ua766"
        + "\ua768\ua768"
        + "\ua76a\ua76a"
        + "\ua76c\ua76c"
        + "\ua76e\ua76e"
        + "\ua779\ua779"
        + "\ua77b\ua77b"
        + "\ua77d\ua77e"
        + "\ua780\ua780"
        + "\ua782\ua782"
        + "\ua784\ua784"
        + "\ua786\ua786"
        + "\ua78b\ua78b"
        + "\ua78d\ua78d"
        + "\ua790\ua790"
        + "\ua792\ua792"
        + "\ua796\ua796"
        + "\ua798\ua798"
        + "\ua79a\ua79a"
        + "\ua79c\ua79c"
        + "\ua79e\ua79e"
        + "\ua7a0\ua7a0"
        + "\ua7a2\ua7a2"
        + "\ua7a4\ua7a4"
        + "\ua7a6\ua7a6"
        + "\ua7a8\ua7a8"
        + "\ua7aa\ua7ad"
        + "\ua7b0\ua7b1"
        + "\uff21\uff3a"
        + "\ud801\udc00\ud801\udc27"
        + "\ud806\udca0\ud806\udcbf"
        + "\ud835\udc00\ud835\udc19"
        + "\ud835\udc34\ud835\udc4d"
        + "\ud835\udc68\ud835\udc81"
        + "\ud835\udc9c\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb5"
        + "\ud835\udcd0\ud835\udce9"
        + "\ud835\udd04\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd38\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd6c\ud835\udd85"
        + "\ud835\udda0\ud835\uddb9"
        + "\ud835\uddd4\ud835\udded"
        + "\ud835\ude08\ud835\ude21"
        + "\ud835\ude3c\ud835\ude55"
        + "\ud835\ude70\ud835\ude89"
        + "\ud835\udea8\ud835\udec0"
        + "\ud835\udee2\ud835\udefa"
        + "\ud835\udf1c\ud835\udf34"
        + "\ud835\udf56\ud835\udf6e"
        + "\ud835\udf90\ud835\udfa8"
        + "\ud835\udfca\ud835\udfca"
        + "\ud83c\udd30\ud83c\udd49"
        + "\ud83c\udd50\ud83c\udd69"
        + "\ud83c\udd70\ud83c\udd89",
    // Unicode 7.0 property value: {sharada}
    "\ud804\udd80\ud804\uddc8" + "\ud804\uddcd\ud804\uddcd" + "\ud804\uddd0\ud804\uddda",
    // Unicode 7.0 property value: {shavian}
    "\ud801\udc50\ud801\udc7f",
    // Unicode 7.0 property value: {siddham}
    "\ud805\udd80\ud805\uddb5" + "\ud805\uddb8\ud805\uddc9",
    // Unicode 7.0 property value: {sinhala}
    "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0de6\u0def"
        + "\u0df2\u0df4"
        + "\ud804\udde1\ud804\uddf4",
    // Unicode 7.0 property value: {sk}
    "\u005e\u005e"
        + "\u0060\u0060"
        + "\u00a8\u00a8"
        + "\u00af\u00af"
        + "\u00b4\u00b4"
        + "\u00b8\u00b8"
        + "\u02c2\u02c5"
        + "\u02d2\u02df"
        + "\u02e5\u02eb"
        + "\u02ed\u02ed"
        + "\u02ef\u02ff"
        + "\u0375\u0375"
        + "\u0384\u0385"
        + "\u1fbd\u1fbd"
        + "\u1fbf\u1fc1"
        + "\u1fcd\u1fcf"
        + "\u1fdd\u1fdf"
        + "\u1fed\u1fef"
        + "\u1ffd\u1ffe"
        + "\u309b\u309c"
        + "\ua700\ua716"
        + "\ua720\ua721"
        + "\ua789\ua78a"
        + "\uab5b\uab5b"
        + "\ufbb2\ufbc1"
        + "\uff3e\uff3e"
        + "\uff40\uff40"
        + "\uffe3\uffe3",
    // Unicode 7.0 property value: {sm}
    "\u002b\u002b"
        + "\u003c\u003e"
        + "\u007c\u007c"
        + "\u007e\u007e"
        + "\u00ac\u00ac"
        + "\u00b1\u00b1"
        + "\u00d7\u00d7"
        + "\u00f7\u00f7"
        + "\u03f6\u03f6"
        + "\u0606\u0608"
        + "\u2044\u2044"
        + "\u2052\u2052"
        + "\u207a\u207c"
        + "\u208a\u208c"
        + "\u2118\u2118"
        + "\u2140\u2144"
        + "\u214b\u214b"
        + "\u2190\u2194"
        + "\u219a\u219b"
        + "\u21a0\u21a0"
        + "\u21a3\u21a3"
        + "\u21a6\u21a6"
        + "\u21ae\u21ae"
        + "\u21ce\u21cf"
        + "\u21d2\u21d2"
        + "\u21d4\u21d4"
        + "\u21f4\u22ff"
        + "\u2320\u2321"
        + "\u237c\u237c"
        + "\u239b\u23b3"
        + "\u23dc\u23e1"
        + "\u25b7\u25b7"
        + "\u25c1\u25c1"
        + "\u25f8\u25ff"
        + "\u266f\u266f"
        + "\u27c0\u27c4"
        + "\u27c7\u27e5"
        + "\u27f0\u27ff"
        + "\u2900\u2982"
        + "\u2999\u29d7"
        + "\u29dc\u29fb"
        + "\u29fe\u2aff"
        + "\u2b30\u2b44"
        + "\u2b47\u2b4c"
        + "\ufb29\ufb29"
        + "\ufe62\ufe62"
        + "\ufe64\ufe66"
        + "\uff0b\uff0b"
        + "\uff1c\uff1e"
        + "\uff5c\uff5c"
        + "\uff5e\uff5e"
        + "\uffe2\uffe2"
        + "\uffe9\uffec"
        + "\ud835\udec1\ud835\udec1"
        + "\ud835\udedb\ud835\udedb"
        + "\ud835\udefb\ud835\udefb"
        + "\ud835\udf15\ud835\udf15"
        + "\ud835\udf35\ud835\udf35"
        + "\ud835\udf4f\ud835\udf4f"
        + "\ud835\udf6f\ud835\udf6f"
        + "\ud835\udf89\ud835\udf89"
        + "\ud835\udfa9\ud835\udfa9"
        + "\ud835\udfc3\ud835\udfc3"
        + "\ud83b\udef0\ud83b\udef1",
    // Unicode 7.0 property value: {so}
    "\u00a6\u00a6"
        + "\u00a9\u00a9"
        + "\u00ae\u00ae"
        + "\u00b0\u00b0"
        + "\u0482\u0482"
        + "\u058d\u058e"
        + "\u060e\u060f"
        + "\u06de\u06de"
        + "\u06e9\u06e9"
        + "\u06fd\u06fe"
        + "\u07f6\u07f6"
        + "\u09fa\u09fa"
        + "\u0b70\u0b70"
        + "\u0bf3\u0bf8"
        + "\u0bfa\u0bfa"
        + "\u0c7f\u0c7f"
        + "\u0d79\u0d79"
        + "\u0f01\u0f03"
        + "\u0f13\u0f13"
        + "\u0f15\u0f17"
        + "\u0f1a\u0f1f"
        + "\u0f34\u0f34"
        + "\u0f36\u0f36"
        + "\u0f38\u0f38"
        + "\u0fbe\u0fc5"
        + "\u0fc7\u0fcc"
        + "\u0fce\u0fcf"
        + "\u0fd5\u0fd8"
        + "\u109e\u109f"
        + "\u1390\u1399"
        + "\u1940\u1940"
        + "\u19de\u19ff"
        + "\u1b61\u1b6a"
        + "\u1b74\u1b7c"
        + "\u2100\u2101"
        + "\u2103\u2106"
        + "\u2108\u2109"
        + "\u2114\u2114"
        + "\u2116\u2117"
        + "\u211e\u2123"
        + "\u2125\u2125"
        + "\u2127\u2127"
        + "\u2129\u2129"
        + "\u212e\u212e"
        + "\u213a\u213b"
        + "\u214a\u214a"
        + "\u214c\u214d"
        + "\u214f\u214f"
        + "\u2195\u2199"
        + "\u219c\u219f"
        + "\u21a1\u21a2"
        + "\u21a4\u21a5"
        + "\u21a7\u21ad"
        + "\u21af\u21cd"
        + "\u21d0\u21d1"
        + "\u21d3\u21d3"
        + "\u21d5\u21f3"
        + "\u2300\u2307"
        + "\u230c\u231f"
        + "\u2322\u2328"
        + "\u232b\u237b"
        + "\u237d\u239a"
        + "\u23b4\u23db"
        + "\u23e2\u23fa"
        + "\u2400\u2426"
        + "\u2440\u244a"
        + "\u249c\u24e9"
        + "\u2500\u25b6"
        + "\u25b8\u25c0"
        + "\u25c2\u25f7"
        + "\u2600\u266e"
        + "\u2670\u2767"
        + "\u2794\u27bf"
        + "\u2800\u28ff"
        + "\u2b00\u2b2f"
        + "\u2b45\u2b46"
        + "\u2b4d\u2b73"
        + "\u2b76\u2b95"
        + "\u2b98\u2bb9"
        + "\u2bbd\u2bc8"
        + "\u2bca\u2bd1"
        + "\u2ce5\u2cea"
        + "\u2e80\u2e99"
        + "\u2e9b\u2ef3"
        + "\u2f00\u2fd5"
        + "\u2ff0\u2ffb"
        + "\u3004\u3004"
        + "\u3012\u3013"
        + "\u3020\u3020"
        + "\u3036\u3037"
        + "\u303e\u303f"
        + "\u3190\u3191"
        + "\u3196\u319f"
        + "\u31c0\u31e3"
        + "\u3200\u321e"
        + "\u322a\u3247"
        + "\u3250\u3250"
        + "\u3260\u327f"
        + "\u328a\u32b0"
        + "\u32c0\u32fe"
        + "\u3300\u33ff"
        + "\u4dc0\u4dff"
        + "\ua490\ua4c6"
        + "\ua828\ua82b"
        + "\ua836\ua837"
        + "\ua839\ua839"
        + "\uaa77\uaa79"
        + "\ufdfd\ufdfd"
        + "\uffe4\uffe4"
        + "\uffe8\uffe8"
        + "\uffed\uffee"
        + "\ufffc\ufffd"
        + "\ud800\udd37\ud800\udd3f"
        + "\ud800\udd79\ud800\udd89"
        + "\ud800\udd8c\ud800\udd8c"
        + "\ud800\udd90\ud800\udd9b"
        + "\ud800\udda0\ud800\udda0"
        + "\ud800\uddd0\ud800\uddfc"
        + "\ud802\udc77\ud802\udc78"
        + "\ud802\udec8\ud802\udec8"
        + "\ud81a\udf3c\ud81a\udf3f"
        + "\ud81a\udf45\ud81a\udf45"
        + "\ud82f\udc9c\ud82f\udc9c"
        + "\ud834\udc00\ud834\udcf5"
        + "\ud834\udd00\ud834\udd26"
        + "\ud834\udd29\ud834\udd64"
        + "\ud834\udd6a\ud834\udd6c"
        + "\ud834\udd83\ud834\udd84"
        + "\ud834\udd8c\ud834\udda9"
        + "\ud834\uddae\ud834\udddd"
        + "\ud834\ude00\ud834\ude41"
        + "\ud834\ude45\ud834\ude45"
        + "\ud834\udf00\ud834\udf56"
        + "\ud83c\udc00\ud83c\udc2b"
        + "\ud83c\udc30\ud83c\udc93"
        + "\ud83c\udca0\ud83c\udcae"
        + "\ud83c\udcb1\ud83c\udcbf"
        + "\ud83c\udcc1\ud83c\udccf"
        + "\ud83c\udcd1\ud83c\udcf5"
        + "\ud83c\udd10\ud83c\udd2e"
        + "\ud83c\udd30\ud83c\udd6b"
        + "\ud83c\udd70\ud83c\udd9a"
        + "\ud83c\udde6\ud83c\ude02"
        + "\ud83c\ude10\ud83c\ude3a"
        + "\ud83c\ude40\ud83c\ude48"
        + "\ud83c\ude50\ud83c\ude51"
        + "\ud83c\udf00\ud83c\udf2c"
        + "\ud83c\udf30\ud83c\udf7d"
        + "\ud83c\udf80\ud83c\udfce"
        + "\ud83c\udfd4\ud83c\udff7"
        + "\ud83d\udc00\ud83d\udcfe"
        + "\ud83d\udd00\ud83d\udd4a"
        + "\ud83d\udd50\ud83d\udd79"
        + "\ud83d\udd7b\ud83d\udda3"
        + "\ud83d\udda5\ud83d\ude42"
        + "\ud83d\ude45\ud83d\udecf"
        + "\ud83d\udee0\ud83d\udeec"
        + "\ud83d\udef0\ud83d\udef3"
        + "\ud83d\udf00\ud83d\udf73"
        + "\ud83d\udf80\ud83d\udfd4"
        + "\ud83e\udc00\ud83e\udc0b"
        + "\ud83e\udc10\ud83e\udc47"
        + "\ud83e\udc50\ud83e\udc59"
        + "\ud83e\udc60\ud83e\udc87"
        + "\ud83e\udc90\ud83e\udcad",
    // Unicode 7.0 property value: {softdotted}
    "\u0069\u006a"
        + "\u012f\u012f"
        + "\u0249\u0249"
        + "\u0268\u0268"
        + "\u029d\u029d"
        + "\u02b2\u02b2"
        + "\u03f3\u03f3"
        + "\u0456\u0456"
        + "\u0458\u0458"
        + "\u1d62\u1d62"
        + "\u1d96\u1d96"
        + "\u1da4\u1da4"
        + "\u1da8\u1da8"
        + "\u1e2d\u1e2d"
        + "\u1ecb\u1ecb"
        + "\u2071\u2071"
        + "\u2148\u2149"
        + "\u2c7c\u2c7c"
        + "\ud835\udc22\ud835\udc23"
        + "\ud835\udc56\ud835\udc57"
        + "\ud835\udc8a\ud835\udc8b"
        + "\ud835\udcbe\ud835\udcbf"
        + "\ud835\udcf2\ud835\udcf3"
        + "\ud835\udd26\ud835\udd27"
        + "\ud835\udd5a\ud835\udd5b"
        + "\ud835\udd8e\ud835\udd8f"
        + "\ud835\uddc2\ud835\uddc3"
        + "\ud835\uddf6\ud835\uddf7"
        + "\ud835\ude2a\ud835\ude2b"
        + "\ud835\ude5e\ud835\ude5f"
        + "\ud835\ude92\ud835\ude93",
    // Unicode 7.0 property value: {sorasompeng}
    "\ud804\udcd0\ud804\udce8" + "\ud804\udcf0\ud804\udcf9",
    // Unicode 7.0 property value: {sterm}
    "\u0021\u0021"
        + "\u002e\u002e"
        + "\u003f\u003f"
        + "\u0589\u0589"
        + "\u061f\u061f"
        + "\u06d4\u06d4"
        + "\u0700\u0702"
        + "\u07f9\u07f9"
        + "\u0964\u0965"
        + "\u104a\u104b"
        + "\u1362\u1362"
        + "\u1367\u1368"
        + "\u166e\u166e"
        + "\u1735\u1736"
        + "\u1803\u1803"
        + "\u1809\u1809"
        + "\u1944\u1945"
        + "\u1aa8\u1aab"
        + "\u1b5a\u1b5b"
        + "\u1b5e\u1b5f"
        + "\u1c3b\u1c3c"
        + "\u1c7e\u1c7f"
        + "\u203c\u203d"
        + "\u2047\u2049"
        + "\u2e2e\u2e2e"
        + "\u2e3c\u2e3c"
        + "\u3002\u3002"
        + "\ua4ff\ua4ff"
        + "\ua60e\ua60f"
        + "\ua6f3\ua6f3"
        + "\ua6f7\ua6f7"
        + "\ua876\ua877"
        + "\ua8ce\ua8cf"
        + "\ua92f\ua92f"
        + "\ua9c8\ua9c9"
        + "\uaa5d\uaa5f"
        + "\uaaf0\uaaf1"
        + "\uabeb\uabeb"
        + "\ufe52\ufe52"
        + "\ufe56\ufe57"
        + "\uff01\uff01"
        + "\uff0e\uff0e"
        + "\uff1f\uff1f"
        + "\uff61\uff61"
        + "\ud802\ude56\ud802\ude57"
        + "\ud804\udc47\ud804\udc48"
        + "\ud804\udcbe\ud804\udcc1"
        + "\ud804\udd41\ud804\udd43"
        + "\ud804\uddc5\ud804\uddc6"
        + "\ud804\uddcd\ud804\uddcd"
        + "\ud804\ude38\ud804\ude39"
        + "\ud804\ude3b\ud804\ude3c"
        + "\ud805\uddc2\ud805\uddc3"
        + "\ud805\uddc9\ud805\uddc9"
        + "\ud805\ude41\ud805\ude42"
        + "\ud81a\ude6e\ud81a\ude6f"
        + "\ud81a\udef5\ud81a\udef5"
        + "\ud81a\udf37\ud81a\udf38"
        + "\ud81a\udf44\ud81a\udf44"
        + "\ud82f\udc9f\ud82f\udc9f",
    // Unicode 7.0 property value: {sundanese}
    "\u1b80\u1bbf" + "\u1cc0\u1cc7",
    // Unicode 7.0 property value: {sylotinagri}
    "\ua800\ua82b",
    // Unicode 7.0 property value: {syriac}
    "\u0700\u070d" + "\u070f\u074a" + "\u074d\u074f",
    // Unicode 7.0 property value: {tagalog}
    "\u1700\u170c" + "\u170e\u1714",
    // Unicode 7.0 property value: {tagbanwa}
    "\u1760\u176c" + "\u176e\u1770" + "\u1772\u1773",
    // Unicode 7.0 property value: {taile}
    "\u1950\u196d" + "\u1970\u1974",
    // Unicode 7.0 property value: {taitham}
    "\u1a20\u1a5e" + "\u1a60\u1a7c" + "\u1a7f\u1a89" + "\u1a90\u1a99" + "\u1aa0\u1aad",
    // Unicode 7.0 property value: {taiviet}
    "\uaa80\uaac2" + "\uaadb\uaadf",
    // Unicode 7.0 property value: {takri}
    "\ud805\ude80\ud805\udeb7" + "\ud805\udec0\ud805\udec9",
    // Unicode 7.0 property value: {tamil}
    "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bfa",
    // Unicode 7.0 property value: {telugu}
    "\u0c00\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c78\u0c7f",
    // Unicode 7.0 property value: {terminalpunctuation}
    "\u0021\u0021"
        + "\u002c\u002c"
        + "\u002e\u002e"
        + "\u003a\u003b"
        + "\u003f\u003f"
        + "\u037e\u037e"
        + "\u0387\u0387"
        + "\u0589\u0589"
        + "\u05c3\u05c3"
        + "\u060c\u060c"
        + "\u061b\u061b"
        + "\u061f\u061f"
        + "\u06d4\u06d4"
        + "\u0700\u070a"
        + "\u070c\u070c"
        + "\u07f8\u07f9"
        + "\u0830\u083e"
        + "\u085e\u085e"
        + "\u0964\u0965"
        + "\u0e5a\u0e5b"
        + "\u0f08\u0f08"
        + "\u0f0d\u0f12"
        + "\u104a\u104b"
        + "\u1361\u1368"
        + "\u166d\u166e"
        + "\u16eb\u16ed"
        + "\u1735\u1736"
        + "\u17d4\u17d6"
        + "\u17da\u17da"
        + "\u1802\u1805"
        + "\u1808\u1809"
        + "\u1944\u1945"
        + "\u1aa8\u1aab"
        + "\u1b5a\u1b5b"
        + "\u1b5d\u1b5f"
        + "\u1c3b\u1c3f"
        + "\u1c7e\u1c7f"
        + "\u203c\u203d"
        + "\u2047\u2049"
        + "\u2e2e\u2e2e"
        + "\u2e3c\u2e3c"
        + "\u2e41\u2e41"
        + "\u3001\u3002"
        + "\ua4fe\ua4ff"
        + "\ua60d\ua60f"
        + "\ua6f3\ua6f7"
        + "\ua876\ua877"
        + "\ua8ce\ua8cf"
        + "\ua92f\ua92f"
        + "\ua9c7\ua9c9"
        + "\uaa5d\uaa5f"
        + "\uaadf\uaadf"
        + "\uaaf0\uaaf1"
        + "\uabeb\uabeb"
        + "\ufe50\ufe52"
        + "\ufe54\ufe57"
        + "\uff01\uff01"
        + "\uff0c\uff0c"
        + "\uff0e\uff0e"
        + "\uff1a\uff1b"
        + "\uff1f\uff1f"
        + "\uff61\uff61"
        + "\uff64\uff64"
        + "\ud800\udf9f\ud800\udf9f"
        + "\ud800\udfd0\ud800\udfd0"
        + "\ud802\udc57\ud802\udc57"
        + "\ud802\udd1f\ud802\udd1f"
        + "\ud802\ude56\ud802\ude57"
        + "\ud802\udef0\ud802\udef5"
        + "\ud802\udf3a\ud802\udf3f"
        + "\ud802\udf99\ud802\udf9c"
        + "\ud804\udc47\ud804\udc4d"
        + "\ud804\udcbe\ud804\udcc1"
        + "\ud804\udd41\ud804\udd43"
        + "\ud804\uddc5\ud804\uddc6"
        + "\ud804\uddcd\ud804\uddcd"
        + "\ud804\ude38\ud804\ude3c"
        + "\ud805\uddc2\ud805\uddc5"
        + "\ud805\uddc9\ud805\uddc9"
        + "\ud805\ude41\ud805\ude42"
        + "\ud809\udc70\ud809\udc74"
        + "\ud81a\ude6e\ud81a\ude6f"
        + "\ud81a\udef5\ud81a\udef5"
        + "\ud81a\udf37\ud81a\udf39"
        + "\ud81a\udf44\ud81a\udf44"
        + "\ud82f\udc9f\ud82f\udc9f",
    // Unicode 7.0 property value: {thaana}
    "\u0780\u07b1",
    // Unicode 7.0 property value: {thai}
    "\u0e01\u0e3a" + "\u0e40\u0e5b",
    // Unicode 7.0 property value: {tibetan}
    "\u0f00\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fbe\u0fcc"
        + "\u0fce\u0fd4"
        + "\u0fd9\u0fda",
    // Unicode 7.0 property value: {tifinagh}
    "\u2d30\u2d67" + "\u2d6f\u2d70" + "\u2d7f\u2d7f",
    // Unicode 7.0 property value: {tirhuta}
    "\ud805\udc80\ud805\udcc7" + "\ud805\udcd0\ud805\udcd9",
    // Unicode 7.0 property value: {ugaritic}
    "\ud800\udf80\ud800\udf9d" + "\ud800\udf9f\ud800\udf9f",
    // Unicode 7.0 property value: {unifiedideograph}
    "\u3400\u4db5"
        + "\u4e00\u9fcc"
        + "\ufa0e\ufa0f"
        + "\ufa11\ufa11"
        + "\ufa13\ufa14"
        + "\ufa1f\ufa1f"
        + "\ufa21\ufa21"
        + "\ufa23\ufa24"
        + "\ufa27\ufa29"
        + "\ud840\udc00\ud869\uded6"
        + "\ud869\udf00\ud86d\udf34"
        + "\ud86d\udf40\ud86e\udc1d",
    // Unicode 7.0 property value: {unknown}
    "\u0378\u0379"
        + "\u0380\u0383"
        + "\u038b\u038b"
        + "\u038d\u038d"
        + "\u03a2\u03a2"
        + "\u0530\u0530"
        + "\u0557\u0558"
        + "\u0560\u0560"
        + "\u0588\u0588"
        + "\u058b\u058c"
        + "\u0590\u0590"
        + "\u05c8\u05cf"
        + "\u05eb\u05ef"
        + "\u05f5\u05ff"
        + "\u061d\u061d"
        + "\u070e\u070e"
        + "\u074b\u074c"
        + "\u07b2\u07bf"
        + "\u07fb\u07ff"
        + "\u082e\u082f"
        + "\u083f\u083f"
        + "\u085c\u085d"
        + "\u085f\u089f"
        + "\u08b3\u08e3"
        + "\u0984\u0984"
        + "\u098d\u098e"
        + "\u0991\u0992"
        + "\u09a9\u09a9"
        + "\u09b1\u09b1"
        + "\u09b3\u09b5"
        + "\u09ba\u09bb"
        + "\u09c5\u09c6"
        + "\u09c9\u09ca"
        + "\u09cf\u09d6"
        + "\u09d8\u09db"
        + "\u09de\u09de"
        + "\u09e4\u09e5"
        + "\u09fc\u0a00"
        + "\u0a04\u0a04"
        + "\u0a0b\u0a0e"
        + "\u0a11\u0a12"
        + "\u0a29\u0a29"
        + "\u0a31\u0a31"
        + "\u0a34\u0a34"
        + "\u0a37\u0a37"
        + "\u0a3a\u0a3b"
        + "\u0a3d\u0a3d"
        + "\u0a43\u0a46"
        + "\u0a49\u0a4a"
        + "\u0a4e\u0a50"
        + "\u0a52\u0a58"
        + "\u0a5d\u0a5d"
        + "\u0a5f\u0a65"
        + "\u0a76\u0a80"
        + "\u0a84\u0a84"
        + "\u0a8e\u0a8e"
        + "\u0a92\u0a92"
        + "\u0aa9\u0aa9"
        + "\u0ab1\u0ab1"
        + "\u0ab4\u0ab4"
        + "\u0aba\u0abb"
        + "\u0ac6\u0ac6"
        + "\u0aca\u0aca"
        + "\u0ace\u0acf"
        + "\u0ad1\u0adf"
        + "\u0ae4\u0ae5"
        + "\u0af2\u0b00"
        + "\u0b04\u0b04"
        + "\u0b0d\u0b0e"
        + "\u0b11\u0b12"
        + "\u0b29\u0b29"
        + "\u0b31\u0b31"
        + "\u0b34\u0b34"
        + "\u0b3a\u0b3b"
        + "\u0b45\u0b46"
        + "\u0b49\u0b4a"
        + "\u0b4e\u0b55"
        + "\u0b58\u0b5b"
        + "\u0b5e\u0b5e"
        + "\u0b64\u0b65"
        + "\u0b78\u0b81"
        + "\u0b84\u0b84"
        + "\u0b8b\u0b8d"
        + "\u0b91\u0b91"
        + "\u0b96\u0b98"
        + "\u0b9b\u0b9b"
        + "\u0b9d\u0b9d"
        + "\u0ba0\u0ba2"
        + "\u0ba5\u0ba7"
        + "\u0bab\u0bad"
        + "\u0bba\u0bbd"
        + "\u0bc3\u0bc5"
        + "\u0bc9\u0bc9"
        + "\u0bce\u0bcf"
        + "\u0bd1\u0bd6"
        + "\u0bd8\u0be5"
        + "\u0bfb\u0bff"
        + "\u0c04\u0c04"
        + "\u0c0d\u0c0d"
        + "\u0c11\u0c11"
        + "\u0c29\u0c29"
        + "\u0c3a\u0c3c"
        + "\u0c45\u0c45"
        + "\u0c49\u0c49"
        + "\u0c4e\u0c54"
        + "\u0c57\u0c57"
        + "\u0c5a\u0c5f"
        + "\u0c64\u0c65"
        + "\u0c70\u0c77"
        + "\u0c80\u0c80"
        + "\u0c84\u0c84"
        + "\u0c8d\u0c8d"
        + "\u0c91\u0c91"
        + "\u0ca9\u0ca9"
        + "\u0cb4\u0cb4"
        + "\u0cba\u0cbb"
        + "\u0cc5\u0cc5"
        + "\u0cc9\u0cc9"
        + "\u0cce\u0cd4"
        + "\u0cd7\u0cdd"
        + "\u0cdf\u0cdf"
        + "\u0ce4\u0ce5"
        + "\u0cf0\u0cf0"
        + "\u0cf3\u0d00"
        + "\u0d04\u0d04"
        + "\u0d0d\u0d0d"
        + "\u0d11\u0d11"
        + "\u0d3b\u0d3c"
        + "\u0d45\u0d45"
        + "\u0d49\u0d49"
        + "\u0d4f\u0d56"
        + "\u0d58\u0d5f"
        + "\u0d64\u0d65"
        + "\u0d76\u0d78"
        + "\u0d80\u0d81"
        + "\u0d84\u0d84"
        + "\u0d97\u0d99"
        + "\u0db2\u0db2"
        + "\u0dbc\u0dbc"
        + "\u0dbe\u0dbf"
        + "\u0dc7\u0dc9"
        + "\u0dcb\u0dce"
        + "\u0dd5\u0dd5"
        + "\u0dd7\u0dd7"
        + "\u0de0\u0de5"
        + "\u0df0\u0df1"
        + "\u0df5\u0e00"
        + "\u0e3b\u0e3e"
        + "\u0e5c\u0e80"
        + "\u0e83\u0e83"
        + "\u0e85\u0e86"
        + "\u0e89\u0e89"
        + "\u0e8b\u0e8c"
        + "\u0e8e\u0e93"
        + "\u0e98\u0e98"
        + "\u0ea0\u0ea0"
        + "\u0ea4\u0ea4"
        + "\u0ea6\u0ea6"
        + "\u0ea8\u0ea9"
        + "\u0eac\u0eac"
        + "\u0eba\u0eba"
        + "\u0ebe\u0ebf"
        + "\u0ec5\u0ec5"
        + "\u0ec7\u0ec7"
        + "\u0ece\u0ecf"
        + "\u0eda\u0edb"
        + "\u0ee0\u0eff"
        + "\u0f48\u0f48"
        + "\u0f6d\u0f70"
        + "\u0f98\u0f98"
        + "\u0fbd\u0fbd"
        + "\u0fcd\u0fcd"
        + "\u0fdb\u0fff"
        + "\u10c6\u10c6"
        + "\u10c8\u10cc"
        + "\u10ce\u10cf"
        + "\u1249\u1249"
        + "\u124e\u124f"
        + "\u1257\u1257"
        + "\u1259\u1259"
        + "\u125e\u125f"
        + "\u1289\u1289"
        + "\u128e\u128f"
        + "\u12b1\u12b1"
        + "\u12b6\u12b7"
        + "\u12bf\u12bf"
        + "\u12c1\u12c1"
        + "\u12c6\u12c7"
        + "\u12d7\u12d7"
        + "\u1311\u1311"
        + "\u1316\u1317"
        + "\u135b\u135c"
        + "\u137d\u137f"
        + "\u139a\u139f"
        + "\u13f5\u13ff"
        + "\u169d\u169f"
        + "\u16f9\u16ff"
        + "\u170d\u170d"
        + "\u1715\u171f"
        + "\u1737\u173f"
        + "\u1754\u175f"
        + "\u176d\u176d"
        + "\u1771\u1771"
        + "\u1774\u177f"
        + "\u17de\u17df"
        + "\u17ea\u17ef"
        + "\u17fa\u17ff"
        + "\u180f\u180f"
        + "\u181a\u181f"
        + "\u1878\u187f"
        + "\u18ab\u18af"
        + "\u18f6\u18ff"
        + "\u191f\u191f"
        + "\u192c\u192f"
        + "\u193c\u193f"
        + "\u1941\u1943"
        + "\u196e\u196f"
        + "\u1975\u197f"
        + "\u19ac\u19af"
        + "\u19ca\u19cf"
        + "\u19db\u19dd"
        + "\u1a1c\u1a1d"
        + "\u1a5f\u1a5f"
        + "\u1a7d\u1a7e"
        + "\u1a8a\u1a8f"
        + "\u1a9a\u1a9f"
        + "\u1aae\u1aaf"
        + "\u1abf\u1aff"
        + "\u1b4c\u1b4f"
        + "\u1b7d\u1b7f"
        + "\u1bf4\u1bfb"
        + "\u1c38\u1c3a"
        + "\u1c4a\u1c4c"
        + "\u1c80\u1cbf"
        + "\u1cc8\u1ccf"
        + "\u1cf7\u1cf7"
        + "\u1cfa\u1cff"
        + "\u1df6\u1dfb"
        + "\u1f16\u1f17"
        + "\u1f1e\u1f1f"
        + "\u1f46\u1f47"
        + "\u1f4e\u1f4f"
        + "\u1f58\u1f58"
        + "\u1f5a\u1f5a"
        + "\u1f5c\u1f5c"
        + "\u1f5e\u1f5e"
        + "\u1f7e\u1f7f"
        + "\u1fb5\u1fb5"
        + "\u1fc5\u1fc5"
        + "\u1fd4\u1fd5"
        + "\u1fdc\u1fdc"
        + "\u1ff0\u1ff1"
        + "\u1ff5\u1ff5"
        + "\u1fff\u1fff"
        + "\u2065\u2065"
        + "\u2072\u2073"
        + "\u208f\u208f"
        + "\u209d\u209f"
        + "\u20be\u20cf"
        + "\u20f1\u20ff"
        + "\u218a\u218f"
        + "\u23fb\u23ff"
        + "\u2427\u243f"
        + "\u244b\u245f"
        + "\u2b74\u2b75"
        + "\u2b96\u2b97"
        + "\u2bba\u2bbc"
        + "\u2bc9\u2bc9"
        + "\u2bd2\u2bff"
        + "\u2c2f\u2c2f"
        + "\u2c5f\u2c5f"
        + "\u2cf4\u2cf8"
        + "\u2d26\u2d26"
        + "\u2d28\u2d2c"
        + "\u2d2e\u2d2f"
        + "\u2d68\u2d6e"
        + "\u2d71\u2d7e"
        + "\u2d97\u2d9f"
        + "\u2da7\u2da7"
        + "\u2daf\u2daf"
        + "\u2db7\u2db7"
        + "\u2dbf\u2dbf"
        + "\u2dc7\u2dc7"
        + "\u2dcf\u2dcf"
        + "\u2dd7\u2dd7"
        + "\u2ddf\u2ddf"
        + "\u2e43\u2e7f"
        + "\u2e9a\u2e9a"
        + "\u2ef4\u2eff"
        + "\u2fd6\u2fef"
        + "\u2ffc\u2fff"
        + "\u3040\u3040"
        + "\u3097\u3098"
        + "\u3100\u3104"
        + "\u312e\u3130"
        + "\u318f\u318f"
        + "\u31bb\u31bf"
        + "\u31e4\u31ef"
        + "\u321f\u321f"
        + "\u32ff\u32ff"
        + "\u4db6\u4dbf"
        + "\u9fcd\u9fff"
        + "\ua48d\ua48f"
        + "\ua4c7\ua4cf"
        + "\ua62c\ua63f"
        + "\ua69e\ua69e"
        + "\ua6f8\ua6ff"
        + "\ua78f\ua78f"
        + "\ua7ae\ua7af"
        + "\ua7b2\ua7f6"
        + "\ua82c\ua82f"
        + "\ua83a\ua83f"
        + "\ua878\ua87f"
        + "\ua8c5\ua8cd"
        + "\ua8da\ua8df"
        + "\ua8fc\ua8ff"
        + "\ua954\ua95e"
        + "\ua97d\ua97f"
        + "\ua9ce\ua9ce"
        + "\ua9da\ua9dd"
        + "\ua9ff\ua9ff"
        + "\uaa37\uaa3f"
        + "\uaa4e\uaa4f"
        + "\uaa5a\uaa5b"
        + "\uaac3\uaada"
        + "\uaaf7\uab00"
        + "\uab07\uab08"
        + "\uab0f\uab10"
        + "\uab17\uab1f"
        + "\uab27\uab27"
        + "\uab2f\uab2f"
        + "\uab60\uab63"
        + "\uab66\uabbf"
        + "\uabee\uabef"
        + "\uabfa\uabff"
        + "\ud7a4\ud7af"
        + "\ud7c7\ud7ca"
        + "\ud7fc\ud7ff"
        + "\ue000\uf8ff"
        + "\ufa6e\ufa6f"
        + "\ufada\ufaff"
        + "\ufb07\ufb12"
        + "\ufb18\ufb1c"
        + "\ufb37\ufb37"
        + "\ufb3d\ufb3d"
        + "\ufb3f\ufb3f"
        + "\ufb42\ufb42"
        + "\ufb45\ufb45"
        + "\ufbc2\ufbd2"
        + "\ufd40\ufd4f"
        + "\ufd90\ufd91"
        + "\ufdc8\ufdef"
        + "\ufdfe\ufdff"
        + "\ufe1a\ufe1f"
        + "\ufe2e\ufe2f"
        + "\ufe53\ufe53"
        + "\ufe67\ufe67"
        + "\ufe6c\ufe6f"
        + "\ufe75\ufe75"
        + "\ufefd\ufefe"
        + "\uff00\uff00"
        + "\uffbf\uffc1"
        + "\uffc8\uffc9"
        + "\uffd0\uffd1"
        + "\uffd8\uffd9"
        + "\uffdd\uffdf"
        + "\uffe7\uffe7"
        + "\uffef\ufff8"
        + "\ufffe\uffff"
        + "\ud800\udc0c\ud800\udc0c"
        + "\ud800\udc27\ud800\udc27"
        + "\ud800\udc3b\ud800\udc3b"
        + "\ud800\udc3e\ud800\udc3e"
        + "\ud800\udc4e\ud800\udc4f"
        + "\ud800\udc5e\ud800\udc7f"
        + "\ud800\udcfb\ud800\udcff"
        + "\ud800\udd03\ud800\udd06"
        + "\ud800\udd34\ud800\udd36"
        + "\ud800\udd8d\ud800\udd8f"
        + "\ud800\udd9c\ud800\udd9f"
        + "\ud800\udda1\ud800\uddcf"
        + "\ud800\uddfe\ud800\ude7f"
        + "\ud800\ude9d\ud800\ude9f"
        + "\ud800\uded1\ud800\udedf"
        + "\ud800\udefc\ud800\udeff"
        + "\ud800\udf24\ud800\udf2f"
        + "\ud800\udf4b\ud800\udf4f"
        + "\ud800\udf7b\ud800\udf7f"
        + "\ud800\udf9e\ud800\udf9e"
        + "\ud800\udfc4\ud800\udfc7"
        + "\ud800\udfd6\ud800\udfff"
        + "\ud801\udc9e\ud801\udc9f"
        + "\ud801\udcaa\ud801\udcff"
        + "\ud801\udd28\ud801\udd2f"
        + "\ud801\udd64\ud801\udd6e"
        + "\ud801\udd70\ud801\uddff"
        + "\ud801\udf37\ud801\udf3f"
        + "\ud801\udf56\ud801\udf5f"
        + "\ud801\udf68\ud801\udfff"
        + "\ud802\udc06\ud802\udc07"
        + "\ud802\udc09\ud802\udc09"
        + "\ud802\udc36\ud802\udc36"
        + "\ud802\udc39\ud802\udc3b"
        + "\ud802\udc3d\ud802\udc3e"
        + "\ud802\udc56\ud802\udc56"
        + "\ud802\udc9f\ud802\udca6"
        + "\ud802\udcb0\ud802\udcff"
        + "\ud802\udd1c\ud802\udd1e"
        + "\ud802\udd3a\ud802\udd3e"
        + "\ud802\udd40\ud802\udd7f"
        + "\ud802\uddb8\ud802\uddbd"
        + "\ud802\uddc0\ud802\uddff"
        + "\ud802\ude04\ud802\ude04"
        + "\ud802\ude07\ud802\ude0b"
        + "\ud802\ude14\ud802\ude14"
        + "\ud802\ude18\ud802\ude18"
        + "\ud802\ude34\ud802\ude37"
        + "\ud802\ude3b\ud802\ude3e"
        + "\ud802\ude48\ud802\ude4f"
        + "\ud802\ude59\ud802\ude5f"
        + "\ud802\udea0\ud802\udebf"
        + "\ud802\udee7\ud802\udeea"
        + "\ud802\udef7\ud802\udeff"
        + "\ud802\udf36\ud802\udf38"
        + "\ud802\udf56\ud802\udf57"
        + "\ud802\udf73\ud802\udf77"
        + "\ud802\udf92\ud802\udf98"
        + "\ud802\udf9d\ud802\udfa8"
        + "\ud802\udfb0\ud802\udfff"
        + "\ud803\udc49\ud803\ude5f"
        + "\ud803\ude7f\ud803\udfff"
        + "\ud804\udc4e\ud804\udc51"
        + "\ud804\udc70\ud804\udc7e"
        + "\ud804\udcc2\ud804\udccf"
        + "\ud804\udce9\ud804\udcef"
        + "\ud804\udcfa\ud804\udcff"
        + "\ud804\udd35\ud804\udd35"
        + "\ud804\udd44\ud804\udd4f"
        + "\ud804\udd77\ud804\udd7f"
        + "\ud804\uddc9\ud804\uddcc"
        + "\ud804\uddce\ud804\uddcf"
        + "\ud804\udddb\ud804\udde0"
        + "\ud804\uddf5\ud804\uddff"
        + "\ud804\ude12\ud804\ude12"
        + "\ud804\ude3e\ud804\udeaf"
        + "\ud804\udeeb\ud804\udeef"
        + "\ud804\udefa\ud804\udf00"
        + "\ud804\udf04\ud804\udf04"
        + "\ud804\udf0d\ud804\udf0e"
        + "\ud804\udf11\ud804\udf12"
        + "\ud804\udf29\ud804\udf29"
        + "\ud804\udf31\ud804\udf31"
        + "\ud804\udf34\ud804\udf34"
        + "\ud804\udf3a\ud804\udf3b"
        + "\ud804\udf45\ud804\udf46"
        + "\ud804\udf49\ud804\udf4a"
        + "\ud804\udf4e\ud804\udf56"
        + "\ud804\udf58\ud804\udf5c"
        + "\ud804\udf64\ud804\udf65"
        + "\ud804\udf6d\ud804\udf6f"
        + "\ud804\udf75\ud805\udc7f"
        + "\ud805\udcc8\ud805\udccf"
        + "\ud805\udcda\ud805\udd7f"
        + "\ud805\uddb6\ud805\uddb7"
        + "\ud805\uddca\ud805\uddff"
        + "\ud805\ude45\ud805\ude4f"
        + "\ud805\ude5a\ud805\ude7f"
        + "\ud805\udeb8\ud805\udebf"
        + "\ud805\udeca\ud806\udc9f"
        + "\ud806\udcf3\ud806\udcfe"
        + "\ud806\udd00\ud806\udebf"
        + "\ud806\udef9\ud807\udfff"
        + "\ud808\udf99\ud808\udfff"
        + "\ud809\udc6f\ud809\udc6f"
        + "\ud809\udc75\ud80b\udfff"
        + "\ud80d\udc2f\ud819\udfff"
        + "\ud81a\ude39\ud81a\ude3f"
        + "\ud81a\ude5f\ud81a\ude5f"
        + "\ud81a\ude6a\ud81a\ude6d"
        + "\ud81a\ude70\ud81a\udecf"
        + "\ud81a\udeee\ud81a\udeef"
        + "\ud81a\udef6\ud81a\udeff"
        + "\ud81a\udf46\ud81a\udf4f"
        + "\ud81a\udf5a\ud81a\udf5a"
        + "\ud81a\udf62\ud81a\udf62"
        + "\ud81a\udf78\ud81a\udf7c"
        + "\ud81a\udf90\ud81b\udeff"
        + "\ud81b\udf45\ud81b\udf4f"
        + "\ud81b\udf7f\ud81b\udf8e"
        + "\ud81b\udfa0\ud82b\udfff"
        + "\ud82c\udc02\ud82e\udfff"
        + "\ud82f\udc6b\ud82f\udc6f"
        + "\ud82f\udc7d\ud82f\udc7f"
        + "\ud82f\udc89\ud82f\udc8f"
        + "\ud82f\udc9a\ud82f\udc9b"
        + "\ud82f\udca4\ud833\udfff"
        + "\ud834\udcf6\ud834\udcff"
        + "\ud834\udd27\ud834\udd28"
        + "\ud834\uddde\ud834\uddff"
        + "\ud834\ude46\ud834\udeff"
        + "\ud834\udf57\ud834\udf5f"
        + "\ud834\udf72\ud834\udfff"
        + "\ud835\udc55\ud835\udc55"
        + "\ud835\udc9d\ud835\udc9d"
        + "\ud835\udca0\ud835\udca1"
        + "\ud835\udca3\ud835\udca4"
        + "\ud835\udca7\ud835\udca8"
        + "\ud835\udcad\ud835\udcad"
        + "\ud835\udcba\ud835\udcba"
        + "\ud835\udcbc\ud835\udcbc"
        + "\ud835\udcc4\ud835\udcc4"
        + "\ud835\udd06\ud835\udd06"
        + "\ud835\udd0b\ud835\udd0c"
        + "\ud835\udd15\ud835\udd15"
        + "\ud835\udd1d\ud835\udd1d"
        + "\ud835\udd3a\ud835\udd3a"
        + "\ud835\udd3f\ud835\udd3f"
        + "\ud835\udd45\ud835\udd45"
        + "\ud835\udd47\ud835\udd49"
        + "\ud835\udd51\ud835\udd51"
        + "\ud835\udea6\ud835\udea7"
        + "\ud835\udfcc\ud835\udfcd"
        + "\ud836\udc00\ud839\udfff"
        + "\ud83a\udcc5\ud83a\udcc6"
        + "\ud83a\udcd7\ud83b\uddff"
        + "\ud83b\ude04\ud83b\ude04"
        + "\ud83b\ude20\ud83b\ude20"
        + "\ud83b\ude23\ud83b\ude23"
        + "\ud83b\ude25\ud83b\ude26"
        + "\ud83b\ude28\ud83b\ude28"
        + "\ud83b\ude33\ud83b\ude33"
        + "\ud83b\ude38\ud83b\ude38"
        + "\ud83b\ude3a\ud83b\ude3a"
        + "\ud83b\ude3c\ud83b\ude41"
        + "\ud83b\ude43\ud83b\ude46"
        + "\ud83b\ude48\ud83b\ude48"
        + "\ud83b\ude4a\ud83b\ude4a"
        + "\ud83b\ude4c\ud83b\ude4c"
        + "\ud83b\ude50\ud83b\ude50"
        + "\ud83b\ude53\ud83b\ude53"
        + "\ud83b\ude55\ud83b\ude56"
        + "\ud83b\ude58\ud83b\ude58"
        + "\ud83b\ude5a\ud83b\ude5a"
        + "\ud83b\ude5c\ud83b\ude5c"
        + "\ud83b\ude5e\ud83b\ude5e"
        + "\ud83b\ude60\ud83b\ude60"
        + "\ud83b\ude63\ud83b\ude63"
        + "\ud83b\ude65\ud83b\ude66"
        + "\ud83b\ude6b\ud83b\ude6b"
        + "\ud83b\ude73\ud83b\ude73"
        + "\ud83b\ude78\ud83b\ude78"
        + "\ud83b\ude7d\ud83b\ude7d"
        + "\ud83b\ude7f\ud83b\ude7f"
        + "\ud83b\ude8a\ud83b\ude8a"
        + "\ud83b\ude9c\ud83b\udea0"
        + "\ud83b\udea4\ud83b\udea4"
        + "\ud83b\udeaa\ud83b\udeaa"
        + "\ud83b\udebc\ud83b\udeef"
        + "\ud83b\udef2\ud83b\udfff"
        + "\ud83c\udc2c\ud83c\udc2f"
        + "\ud83c\udc94\ud83c\udc9f"
        + "\ud83c\udcaf\ud83c\udcb0"
        + "\ud83c\udcc0\ud83c\udcc0"
        + "\ud83c\udcd0\ud83c\udcd0"
        + "\ud83c\udcf6\ud83c\udcff"
        + "\ud83c\udd0d\ud83c\udd0f"
        + "\ud83c\udd2f\ud83c\udd2f"
        + "\ud83c\udd6c\ud83c\udd6f"
        + "\ud83c\udd9b\ud83c\udde5"
        + "\ud83c\ude03\ud83c\ude0f"
        + "\ud83c\ude3b\ud83c\ude3f"
        + "\ud83c\ude49\ud83c\ude4f"
        + "\ud83c\ude52\ud83c\udeff"
        + "\ud83c\udf2d\ud83c\udf2f"
        + "\ud83c\udf7e\ud83c\udf7f"
        + "\ud83c\udfcf\ud83c\udfd3"
        + "\ud83c\udff8\ud83c\udfff"
        + "\ud83d\udcff\ud83d\udcff"
        + "\ud83d\udd4b\ud83d\udd4f"
        + "\ud83d\udd7a\ud83d\udd7a"
        + "\ud83d\udda4\ud83d\udda4"
        + "\ud83d\ude43\ud83d\ude44"
        + "\ud83d\uded0\ud83d\udedf"
        + "\ud83d\udeed\ud83d\udeef"
        + "\ud83d\udef4\ud83d\udeff"
        + "\ud83d\udf74\ud83d\udf7f"
        + "\ud83d\udfd5\ud83d\udfff"
        + "\ud83e\udc0c\ud83e\udc0f"
        + "\ud83e\udc48\ud83e\udc4f"
        + "\ud83e\udc5a\ud83e\udc5f"
        + "\ud83e\udc88\ud83e\udc8f"
        + "\ud83e\udcae\ud83f\udfff"
        + "\ud869\uded7\ud869\udeff"
        + "\ud86d\udf35\ud86d\udf3f"
        + "\ud86e\udc1e\ud87d\udfff"
        + "\ud87e\ude1e\udb40\udc00"
        + "\udb40\udc02\udb40\udc1f"
        + "\udb40\udc80\udb40\udcff"
        + "\udb40\uddf0\udbff\udfff",
    // Unicode 7.0 property value: {uppercase}
    "\u0041\u005a"
        + "\u00c0\u00d6"
        + "\u00d8\u00de"
        + "\u0100\u0100"
        + "\u0102\u0102"
        + "\u0104\u0104"
        + "\u0106\u0106"
        + "\u0108\u0108"
        + "\u010a\u010a"
        + "\u010c\u010c"
        + "\u010e\u010e"
        + "\u0110\u0110"
        + "\u0112\u0112"
        + "\u0114\u0114"
        + "\u0116\u0116"
        + "\u0118\u0118"
        + "\u011a\u011a"
        + "\u011c\u011c"
        + "\u011e\u011e"
        + "\u0120\u0120"
        + "\u0122\u0122"
        + "\u0124\u0124"
        + "\u0126\u0126"
        + "\u0128\u0128"
        + "\u012a\u012a"
        + "\u012c\u012c"
        + "\u012e\u012e"
        + "\u0130\u0130"
        + "\u0132\u0132"
        + "\u0134\u0134"
        + "\u0136\u0136"
        + "\u0139\u0139"
        + "\u013b\u013b"
        + "\u013d\u013d"
        + "\u013f\u013f"
        + "\u0141\u0141"
        + "\u0143\u0143"
        + "\u0145\u0145"
        + "\u0147\u0147"
        + "\u014a\u014a"
        + "\u014c\u014c"
        + "\u014e\u014e"
        + "\u0150\u0150"
        + "\u0152\u0152"
        + "\u0154\u0154"
        + "\u0156\u0156"
        + "\u0158\u0158"
        + "\u015a\u015a"
        + "\u015c\u015c"
        + "\u015e\u015e"
        + "\u0160\u0160"
        + "\u0162\u0162"
        + "\u0164\u0164"
        + "\u0166\u0166"
        + "\u0168\u0168"
        + "\u016a\u016a"
        + "\u016c\u016c"
        + "\u016e\u016e"
        + "\u0170\u0170"
        + "\u0172\u0172"
        + "\u0174\u0174"
        + "\u0176\u0176"
        + "\u0178\u0179"
        + "\u017b\u017b"
        + "\u017d\u017d"
        + "\u0181\u0182"
        + "\u0184\u0184"
        + "\u0186\u0187"
        + "\u0189\u018b"
        + "\u018e\u0191"
        + "\u0193\u0194"
        + "\u0196\u0198"
        + "\u019c\u019d"
        + "\u019f\u01a0"
        + "\u01a2\u01a2"
        + "\u01a4\u01a4"
        + "\u01a6\u01a7"
        + "\u01a9\u01a9"
        + "\u01ac\u01ac"
        + "\u01ae\u01af"
        + "\u01b1\u01b3"
        + "\u01b5\u01b5"
        + "\u01b7\u01b8"
        + "\u01bc\u01bc"
        + "\u01c4\u01c4"
        + "\u01c7\u01c7"
        + "\u01ca\u01ca"
        + "\u01cd\u01cd"
        + "\u01cf\u01cf"
        + "\u01d1\u01d1"
        + "\u01d3\u01d3"
        + "\u01d5\u01d5"
        + "\u01d7\u01d7"
        + "\u01d9\u01d9"
        + "\u01db\u01db"
        + "\u01de\u01de"
        + "\u01e0\u01e0"
        + "\u01e2\u01e2"
        + "\u01e4\u01e4"
        + "\u01e6\u01e6"
        + "\u01e8\u01e8"
        + "\u01ea\u01ea"
        + "\u01ec\u01ec"
        + "\u01ee\u01ee"
        + "\u01f1\u01f1"
        + "\u01f4\u01f4"
        + "\u01f6\u01f8"
        + "\u01fa\u01fa"
        + "\u01fc\u01fc"
        + "\u01fe\u01fe"
        + "\u0200\u0200"
        + "\u0202\u0202"
        + "\u0204\u0204"
        + "\u0206\u0206"
        + "\u0208\u0208"
        + "\u020a\u020a"
        + "\u020c\u020c"
        + "\u020e\u020e"
        + "\u0210\u0210"
        + "\u0212\u0212"
        + "\u0214\u0214"
        + "\u0216\u0216"
        + "\u0218\u0218"
        + "\u021a\u021a"
        + "\u021c\u021c"
        + "\u021e\u021e"
        + "\u0220\u0220"
        + "\u0222\u0222"
        + "\u0224\u0224"
        + "\u0226\u0226"
        + "\u0228\u0228"
        + "\u022a\u022a"
        + "\u022c\u022c"
        + "\u022e\u022e"
        + "\u0230\u0230"
        + "\u0232\u0232"
        + "\u023a\u023b"
        + "\u023d\u023e"
        + "\u0241\u0241"
        + "\u0243\u0246"
        + "\u0248\u0248"
        + "\u024a\u024a"
        + "\u024c\u024c"
        + "\u024e\u024e"
        + "\u0370\u0370"
        + "\u0372\u0372"
        + "\u0376\u0376"
        + "\u037f\u037f"
        + "\u0386\u0386"
        + "\u0388\u038a"
        + "\u038c\u038c"
        + "\u038e\u038f"
        + "\u0391\u03a1"
        + "\u03a3\u03ab"
        + "\u03cf\u03cf"
        + "\u03d2\u03d4"
        + "\u03d8\u03d8"
        + "\u03da\u03da"
        + "\u03dc\u03dc"
        + "\u03de\u03de"
        + "\u03e0\u03e0"
        + "\u03e2\u03e2"
        + "\u03e4\u03e4"
        + "\u03e6\u03e6"
        + "\u03e8\u03e8"
        + "\u03ea\u03ea"
        + "\u03ec\u03ec"
        + "\u03ee\u03ee"
        + "\u03f4\u03f4"
        + "\u03f7\u03f7"
        + "\u03f9\u03fa"
        + "\u03fd\u042f"
        + "\u0460\u0460"
        + "\u0462\u0462"
        + "\u0464\u0464"
        + "\u0466\u0466"
        + "\u0468\u0468"
        + "\u046a\u046a"
        + "\u046c\u046c"
        + "\u046e\u046e"
        + "\u0470\u0470"
        + "\u0472\u0472"
        + "\u0474\u0474"
        + "\u0476\u0476"
        + "\u0478\u0478"
        + "\u047a\u047a"
        + "\u047c\u047c"
        + "\u047e\u047e"
        + "\u0480\u0480"
        + "\u048a\u048a"
        + "\u048c\u048c"
        + "\u048e\u048e"
        + "\u0490\u0490"
        + "\u0492\u0492"
        + "\u0494\u0494"
        + "\u0496\u0496"
        + "\u0498\u0498"
        + "\u049a\u049a"
        + "\u049c\u049c"
        + "\u049e\u049e"
        + "\u04a0\u04a0"
        + "\u04a2\u04a2"
        + "\u04a4\u04a4"
        + "\u04a6\u04a6"
        + "\u04a8\u04a8"
        + "\u04aa\u04aa"
        + "\u04ac\u04ac"
        + "\u04ae\u04ae"
        + "\u04b0\u04b0"
        + "\u04b2\u04b2"
        + "\u04b4\u04b4"
        + "\u04b6\u04b6"
        + "\u04b8\u04b8"
        + "\u04ba\u04ba"
        + "\u04bc\u04bc"
        + "\u04be\u04be"
        + "\u04c0\u04c1"
        + "\u04c3\u04c3"
        + "\u04c5\u04c5"
        + "\u04c7\u04c7"
        + "\u04c9\u04c9"
        + "\u04cb\u04cb"
        + "\u04cd\u04cd"
        + "\u04d0\u04d0"
        + "\u04d2\u04d2"
        + "\u04d4\u04d4"
        + "\u04d6\u04d6"
        + "\u04d8\u04d8"
        + "\u04da\u04da"
        + "\u04dc\u04dc"
        + "\u04de\u04de"
        + "\u04e0\u04e0"
        + "\u04e2\u04e2"
        + "\u04e4\u04e4"
        + "\u04e6\u04e6"
        + "\u04e8\u04e8"
        + "\u04ea\u04ea"
        + "\u04ec\u04ec"
        + "\u04ee\u04ee"
        + "\u04f0\u04f0"
        + "\u04f2\u04f2"
        + "\u04f4\u04f4"
        + "\u04f6\u04f6"
        + "\u04f8\u04f8"
        + "\u04fa\u04fa"
        + "\u04fc\u04fc"
        + "\u04fe\u04fe"
        + "\u0500\u0500"
        + "\u0502\u0502"
        + "\u0504\u0504"
        + "\u0506\u0506"
        + "\u0508\u0508"
        + "\u050a\u050a"
        + "\u050c\u050c"
        + "\u050e\u050e"
        + "\u0510\u0510"
        + "\u0512\u0512"
        + "\u0514\u0514"
        + "\u0516\u0516"
        + "\u0518\u0518"
        + "\u051a\u051a"
        + "\u051c\u051c"
        + "\u051e\u051e"
        + "\u0520\u0520"
        + "\u0522\u0522"
        + "\u0524\u0524"
        + "\u0526\u0526"
        + "\u0528\u0528"
        + "\u052a\u052a"
        + "\u052c\u052c"
        + "\u052e\u052e"
        + "\u0531\u0556"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u1e00\u1e00"
        + "\u1e02\u1e02"
        + "\u1e04\u1e04"
        + "\u1e06\u1e06"
        + "\u1e08\u1e08"
        + "\u1e0a\u1e0a"
        + "\u1e0c\u1e0c"
        + "\u1e0e\u1e0e"
        + "\u1e10\u1e10"
        + "\u1e12\u1e12"
        + "\u1e14\u1e14"
        + "\u1e16\u1e16"
        + "\u1e18\u1e18"
        + "\u1e1a\u1e1a"
        + "\u1e1c\u1e1c"
        + "\u1e1e\u1e1e"
        + "\u1e20\u1e20"
        + "\u1e22\u1e22"
        + "\u1e24\u1e24"
        + "\u1e26\u1e26"
        + "\u1e28\u1e28"
        + "\u1e2a\u1e2a"
        + "\u1e2c\u1e2c"
        + "\u1e2e\u1e2e"
        + "\u1e30\u1e30"
        + "\u1e32\u1e32"
        + "\u1e34\u1e34"
        + "\u1e36\u1e36"
        + "\u1e38\u1e38"
        + "\u1e3a\u1e3a"
        + "\u1e3c\u1e3c"
        + "\u1e3e\u1e3e"
        + "\u1e40\u1e40"
        + "\u1e42\u1e42"
        + "\u1e44\u1e44"
        + "\u1e46\u1e46"
        + "\u1e48\u1e48"
        + "\u1e4a\u1e4a"
        + "\u1e4c\u1e4c"
        + "\u1e4e\u1e4e"
        + "\u1e50\u1e50"
        + "\u1e52\u1e52"
        + "\u1e54\u1e54"
        + "\u1e56\u1e56"
        + "\u1e58\u1e58"
        + "\u1e5a\u1e5a"
        + "\u1e5c\u1e5c"
        + "\u1e5e\u1e5e"
        + "\u1e60\u1e60"
        + "\u1e62\u1e62"
        + "\u1e64\u1e64"
        + "\u1e66\u1e66"
        + "\u1e68\u1e68"
        + "\u1e6a\u1e6a"
        + "\u1e6c\u1e6c"
        + "\u1e6e\u1e6e"
        + "\u1e70\u1e70"
        + "\u1e72\u1e72"
        + "\u1e74\u1e74"
        + "\u1e76\u1e76"
        + "\u1e78\u1e78"
        + "\u1e7a\u1e7a"
        + "\u1e7c\u1e7c"
        + "\u1e7e\u1e7e"
        + "\u1e80\u1e80"
        + "\u1e82\u1e82"
        + "\u1e84\u1e84"
        + "\u1e86\u1e86"
        + "\u1e88\u1e88"
        + "\u1e8a\u1e8a"
        + "\u1e8c\u1e8c"
        + "\u1e8e\u1e8e"
        + "\u1e90\u1e90"
        + "\u1e92\u1e92"
        + "\u1e94\u1e94"
        + "\u1e9e\u1e9e"
        + "\u1ea0\u1ea0"
        + "\u1ea2\u1ea2"
        + "\u1ea4\u1ea4"
        + "\u1ea6\u1ea6"
        + "\u1ea8\u1ea8"
        + "\u1eaa\u1eaa"
        + "\u1eac\u1eac"
        + "\u1eae\u1eae"
        + "\u1eb0\u1eb0"
        + "\u1eb2\u1eb2"
        + "\u1eb4\u1eb4"
        + "\u1eb6\u1eb6"
        + "\u1eb8\u1eb8"
        + "\u1eba\u1eba"
        + "\u1ebc\u1ebc"
        + "\u1ebe\u1ebe"
        + "\u1ec0\u1ec0"
        + "\u1ec2\u1ec2"
        + "\u1ec4\u1ec4"
        + "\u1ec6\u1ec6"
        + "\u1ec8\u1ec8"
        + "\u1eca\u1eca"
        + "\u1ecc\u1ecc"
        + "\u1ece\u1ece"
        + "\u1ed0\u1ed0"
        + "\u1ed2\u1ed2"
        + "\u1ed4\u1ed4"
        + "\u1ed6\u1ed6"
        + "\u1ed8\u1ed8"
        + "\u1eda\u1eda"
        + "\u1edc\u1edc"
        + "\u1ede\u1ede"
        + "\u1ee0\u1ee0"
        + "\u1ee2\u1ee2"
        + "\u1ee4\u1ee4"
        + "\u1ee6\u1ee6"
        + "\u1ee8\u1ee8"
        + "\u1eea\u1eea"
        + "\u1eec\u1eec"
        + "\u1eee\u1eee"
        + "\u1ef0\u1ef0"
        + "\u1ef2\u1ef2"
        + "\u1ef4\u1ef4"
        + "\u1ef6\u1ef6"
        + "\u1ef8\u1ef8"
        + "\u1efa\u1efa"
        + "\u1efc\u1efc"
        + "\u1efe\u1efe"
        + "\u1f08\u1f0f"
        + "\u1f18\u1f1d"
        + "\u1f28\u1f2f"
        + "\u1f38\u1f3f"
        + "\u1f48\u1f4d"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f5f"
        + "\u1f68\u1f6f"
        + "\u1fb8\u1fbb"
        + "\u1fc8\u1fcb"
        + "\u1fd8\u1fdb"
        + "\u1fe8\u1fec"
        + "\u1ff8\u1ffb"
        + "\u2102\u2102"
        + "\u2107\u2107"
        + "\u210b\u210d"
        + "\u2110\u2112"
        + "\u2115\u2115"
        + "\u2119\u211d"
        + "\u2124\u2124"
        + "\u2126\u2126"
        + "\u2128\u2128"
        + "\u212a\u212d"
        + "\u2130\u2133"
        + "\u213e\u213f"
        + "\u2145\u2145"
        + "\u2160\u216f"
        + "\u2183\u2183"
        + "\u24b6\u24cf"
        + "\u2c00\u2c2e"
        + "\u2c60\u2c60"
        + "\u2c62\u2c64"
        + "\u2c67\u2c67"
        + "\u2c69\u2c69"
        + "\u2c6b\u2c6b"
        + "\u2c6d\u2c70"
        + "\u2c72\u2c72"
        + "\u2c75\u2c75"
        + "\u2c7e\u2c80"
        + "\u2c82\u2c82"
        + "\u2c84\u2c84"
        + "\u2c86\u2c86"
        + "\u2c88\u2c88"
        + "\u2c8a\u2c8a"
        + "\u2c8c\u2c8c"
        + "\u2c8e\u2c8e"
        + "\u2c90\u2c90"
        + "\u2c92\u2c92"
        + "\u2c94\u2c94"
        + "\u2c96\u2c96"
        + "\u2c98\u2c98"
        + "\u2c9a\u2c9a"
        + "\u2c9c\u2c9c"
        + "\u2c9e\u2c9e"
        + "\u2ca0\u2ca0"
        + "\u2ca2\u2ca2"
        + "\u2ca4\u2ca4"
        + "\u2ca6\u2ca6"
        + "\u2ca8\u2ca8"
        + "\u2caa\u2caa"
        + "\u2cac\u2cac"
        + "\u2cae\u2cae"
        + "\u2cb0\u2cb0"
        + "\u2cb2\u2cb2"
        + "\u2cb4\u2cb4"
        + "\u2cb6\u2cb6"
        + "\u2cb8\u2cb8"
        + "\u2cba\u2cba"
        + "\u2cbc\u2cbc"
        + "\u2cbe\u2cbe"
        + "\u2cc0\u2cc0"
        + "\u2cc2\u2cc2"
        + "\u2cc4\u2cc4"
        + "\u2cc6\u2cc6"
        + "\u2cc8\u2cc8"
        + "\u2cca\u2cca"
        + "\u2ccc\u2ccc"
        + "\u2cce\u2cce"
        + "\u2cd0\u2cd0"
        + "\u2cd2\u2cd2"
        + "\u2cd4\u2cd4"
        + "\u2cd6\u2cd6"
        + "\u2cd8\u2cd8"
        + "\u2cda\u2cda"
        + "\u2cdc\u2cdc"
        + "\u2cde\u2cde"
        + "\u2ce0\u2ce0"
        + "\u2ce2\u2ce2"
        + "\u2ceb\u2ceb"
        + "\u2ced\u2ced"
        + "\u2cf2\u2cf2"
        + "\ua640\ua640"
        + "\ua642\ua642"
        + "\ua644\ua644"
        + "\ua646\ua646"
        + "\ua648\ua648"
        + "\ua64a\ua64a"
        + "\ua64c\ua64c"
        + "\ua64e\ua64e"
        + "\ua650\ua650"
        + "\ua652\ua652"
        + "\ua654\ua654"
        + "\ua656\ua656"
        + "\ua658\ua658"
        + "\ua65a\ua65a"
        + "\ua65c\ua65c"
        + "\ua65e\ua65e"
        + "\ua660\ua660"
        + "\ua662\ua662"
        + "\ua664\ua664"
        + "\ua666\ua666"
        + "\ua668\ua668"
        + "\ua66a\ua66a"
        + "\ua66c\ua66c"
        + "\ua680\ua680"
        + "\ua682\ua682"
        + "\ua684\ua684"
        + "\ua686\ua686"
        + "\ua688\ua688"
        + "\ua68a\ua68a"
        + "\ua68c\ua68c"
        + "\ua68e\ua68e"
        + "\ua690\ua690"
        + "\ua692\ua692"
        + "\ua694\ua694"
        + "\ua696\ua696"
        + "\ua698\ua698"
        + "\ua69a\ua69a"
        + "\ua722\ua722"
        + "\ua724\ua724"
        + "\ua726\ua726"
        + "\ua728\ua728"
        + "\ua72a\ua72a"
        + "\ua72c\ua72c"
        + "\ua72e\ua72e"
        + "\ua732\ua732"
        + "\ua734\ua734"
        + "\ua736\ua736"
        + "\ua738\ua738"
        + "\ua73a\ua73a"
        + "\ua73c\ua73c"
        + "\ua73e\ua73e"
        + "\ua740\ua740"
        + "\ua742\ua742"
        + "\ua744\ua744"
        + "\ua746\ua746"
        + "\ua748\ua748"
        + "\ua74a\ua74a"
        + "\ua74c\ua74c"
        + "\ua74e\ua74e"
        + "\ua750\ua750"
        + "\ua752\ua752"
        + "\ua754\ua754"
        + "\ua756\ua756"
        + "\ua758\ua758"
        + "\ua75a\ua75a"
        + "\ua75c\ua75c"
        + "\ua75e\ua75e"
        + "\ua760\ua760"
        + "\ua762\ua762"
        + "\ua764\ua764"
        + "\ua766\ua766"
        + "\ua768\ua768"
        + "\ua76a\ua76a"
        + "\ua76c\ua76c"
        + "\ua76e\ua76e"
        + "\ua779\ua779"
        + "\ua77b\ua77b"
        + "\ua77d\ua77e"
        + "\ua780\ua780"
        + "\ua782\ua782"
        + "\ua784\ua784"
        + "\ua786\ua786"
        + "\ua78b\ua78b"
        + "\ua78d\ua78d"
        + "\ua790\ua790"
        + "\ua792\ua792"
        + "\ua796\ua796"
        + "\ua798\ua798"
        + "\ua79a\ua79a"
        + "\ua79c\ua79c"
        + "\ua79e\ua79e"
        + "\ua7a0\ua7a0"
        + "\ua7a2\ua7a2"
        + "\ua7a4\ua7a4"
        + "\ua7a6\ua7a6"
        + "\ua7a8\ua7a8"
        + "\ua7aa\ua7ad"
        + "\ua7b0\ua7b1"
        + "\uff21\uff3a"
        + "\ud801\udc00\ud801\udc27"
        + "\ud806\udca0\ud806\udcbf"
        + "\ud835\udc00\ud835\udc19"
        + "\ud835\udc34\ud835\udc4d"
        + "\ud835\udc68\ud835\udc81"
        + "\ud835\udc9c\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb5"
        + "\ud835\udcd0\ud835\udce9"
        + "\ud835\udd04\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd38\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd6c\ud835\udd85"
        + "\ud835\udda0\ud835\uddb9"
        + "\ud835\uddd4\ud835\udded"
        + "\ud835\ude08\ud835\ude21"
        + "\ud835\ude3c\ud835\ude55"
        + "\ud835\ude70\ud835\ude89"
        + "\ud835\udea8\ud835\udec0"
        + "\ud835\udee2\ud835\udefa"
        + "\ud835\udf1c\ud835\udf34"
        + "\ud835\udf56\ud835\udf6e"
        + "\ud835\udf90\ud835\udfa8"
        + "\ud835\udfca\ud835\udfca"
        + "\ud83c\udd30\ud83c\udd49"
        + "\ud83c\udd50\ud83c\udd69"
        + "\ud83c\udd70\ud83c\udd89",
    // Unicode 7.0 property value: {vai}
    "\ua500\ua62b",
    // Unicode 7.0 property value: {variationselector}
    "\u180b\u180d" + "\ufe00\ufe0f" + "\udb40\udd00\udb40\uddef",
    // Unicode 7.0 property value: {warangciti}
    "\ud806\udca0\ud806\udcf2" + "\ud806\udcff\ud806\udcff",
    // Unicode 7.0 property value: {whitespace}
    "\t\r"
        + "\u0020\u0020"
        + "\u0085\u0085"
        + "\u00a0\u00a0"
        + "\u1680\u1680"
        + "\u2000\u200a"
        + "\u2028\u2029"
        + "\u202f\u202f"
        + "\u205f\u205f"
        + "\u3000\u3000",
    // Unicode 7.0 property value: {wordbreak=aletter}
    "\u0041\u005a"
        + "\u0061\u007a"
        + "\u00aa\u00aa"
        + "\u00b5\u00b5"
        + "\u00ba\u00ba"
        + "\u00c0\u00d6"
        + "\u00d8\u00f6"
        + "\u00f8\u02c1"
        + "\u02c6\u02d1"
        + "\u02e0\u02e4"
        + "\u02ec\u02ec"
        + "\u02ee\u02ee"
        + "\u0370\u0374"
        + "\u0376\u0377"
        + "\u037a\u037d"
        + "\u037f\u037f"
        + "\u0386\u0386"
        + "\u0388\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03f5"
        + "\u03f7\u0481"
        + "\u048a\u052f"
        + "\u0531\u0556"
        + "\u0559\u0559"
        + "\u0561\u0587"
        + "\u05f3\u05f3"
        + "\u0620\u064a"
        + "\u066e\u066f"
        + "\u0671\u06d3"
        + "\u06d5\u06d5"
        + "\u06e5\u06e6"
        + "\u06ee\u06ef"
        + "\u06fa\u06fc"
        + "\u06ff\u06ff"
        + "\u0710\u0710"
        + "\u0712\u072f"
        + "\u074d\u07a5"
        + "\u07b1\u07b1"
        + "\u07ca\u07ea"
        + "\u07f4\u07f5"
        + "\u07fa\u07fa"
        + "\u0800\u0815"
        + "\u081a\u081a"
        + "\u0824\u0824"
        + "\u0828\u0828"
        + "\u0840\u0858"
        + "\u08a0\u08b2"
        + "\u0904\u0939"
        + "\u093d\u093d"
        + "\u0950\u0950"
        + "\u0958\u0961"
        + "\u0971\u0980"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bd\u09bd"
        + "\u09ce\u09ce"
        + "\u09dc\u09dd"
        + "\u09df\u09e1"
        + "\u09f0\u09f1"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a72\u0a74"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abd\u0abd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae1"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3d\u0b3d"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b61"
        + "\u0b71\u0b71"
        + "\u0b83\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bd0\u0bd0"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c3d"
        + "\u0c58\u0c59"
        + "\u0c60\u0c61"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbd\u0cbd"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce1"
        + "\u0cf1\u0cf2"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d3d"
        + "\u0d4e\u0d4e"
        + "\u0d60\u0d61"
        + "\u0d7a\u0d7f"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0f00\u0f00"
        + "\u0f40\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f88\u0f8c"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u10fa"
        + "\u10fc\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u1380\u138f"
        + "\u13a0\u13f4"
        + "\u1401\u166c"
        + "\u166f\u167f"
        + "\u1681\u169a"
        + "\u16a0\u16ea"
        + "\u16ee\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1711"
        + "\u1720\u1731"
        + "\u1740\u1751"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1820\u1877"
        + "\u1880\u18a8"
        + "\u18aa\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1a00\u1a16"
        + "\u1b05\u1b33"
        + "\u1b45\u1b4b"
        + "\u1b83\u1ba0"
        + "\u1bae\u1baf"
        + "\u1bba\u1be5"
        + "\u1c00\u1c23"
        + "\u1c4d\u1c4f"
        + "\u1c5a\u1c7d"
        + "\u1ce9\u1cec"
        + "\u1cee\u1cf1"
        + "\u1cf5\u1cf6"
        + "\u1d00\u1dbf"
        + "\u1e00\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fbc"
        + "\u1fbe\u1fbe"
        + "\u1fc2\u1fc4"
        + "\u1fc6\u1fcc"
        + "\u1fd0\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fe0\u1fec"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffc"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u2102\u2102"
        + "\u2107\u2107"
        + "\u210a\u2113"
        + "\u2115\u2115"
        + "\u2119\u211d"
        + "\u2124\u2124"
        + "\u2126\u2126"
        + "\u2128\u2128"
        + "\u212a\u212d"
        + "\u212f\u2139"
        + "\u213c\u213f"
        + "\u2145\u2149"
        + "\u214e\u214e"
        + "\u2160\u2188"
        + "\u24b6\u24e9"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2ce4"
        + "\u2ceb\u2cee"
        + "\u2cf2\u2cf3"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d6f"
        + "\u2d80\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2e2f\u2e2f"
        + "\u3005\u3005"
        + "\u303b\u303c"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u31a0\u31ba"
        + "\ua000\ua48c"
        + "\ua4d0\ua4fd"
        + "\ua500\ua60c"
        + "\ua610\ua61f"
        + "\ua62a\ua62b"
        + "\ua640\ua66e"
        + "\ua67f\ua69d"
        + "\ua6a0\ua6ef"
        + "\ua717\ua71f"
        + "\ua722\ua788"
        + "\ua78b\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua801"
        + "\ua803\ua805"
        + "\ua807\ua80a"
        + "\ua80c\ua822"
        + "\ua840\ua873"
        + "\ua882\ua8b3"
        + "\ua8f2\ua8f7"
        + "\ua8fb\ua8fb"
        + "\ua90a\ua925"
        + "\ua930\ua946"
        + "\ua960\ua97c"
        + "\ua984\ua9b2"
        + "\ua9cf\ua9cf"
        + "\uaa00\uaa28"
        + "\uaa40\uaa42"
        + "\uaa44\uaa4b"
        + "\uaae0\uaaea"
        + "\uaaf2\uaaf4"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uab30\uab5a"
        + "\uab5c\uab5f"
        + "\uab64\uab65"
        + "\uabc0\uabe2"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb50\ufbb1"
        + "\ufbd3\ufd3d"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdfb"
        + "\ufe70\ufe74"
        + "\ufe76\ufefc"
        + "\uff21\uff3a"
        + "\uff41\uff5a"
        + "\uffa0\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd40\ud800\udd74"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udf00\ud800\udf1f"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf50\ud800\udf75"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udfa0\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfcf"
        + "\ud800\udfd1\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc60\ud802\udc76"
        + "\ud802\udc80\ud802\udc9e"
        + "\ud802\udd00\ud802\udd15"
        + "\ud802\udd20\ud802\udd39"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude00"
        + "\ud802\ude10\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude60\ud802\ude7c"
        + "\ud802\ude80\ud802\ude9c"
        + "\ud802\udec0\ud802\udec7"
        + "\ud802\udec9\ud802\udee4"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf40\ud802\udf55"
        + "\ud802\udf60\ud802\udf72"
        + "\ud802\udf80\ud802\udf91"
        + "\ud803\udc00\ud803\udc48"
        + "\ud804\udc03\ud804\udc37"
        + "\ud804\udc83\ud804\udcaf"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udd03\ud804\udd26"
        + "\ud804\udd50\ud804\udd72"
        + "\ud804\udd76\ud804\udd76"
        + "\ud804\udd83\ud804\uddb2"
        + "\ud804\uddc1\ud804\uddc4"
        + "\ud804\uddda\ud804\uddda"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude2b"
        + "\ud804\udeb0\ud804\udede"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3d\ud804\udf3d"
        + "\ud804\udf5d\ud804\udf61"
        + "\ud805\udc80\ud805\udcaf"
        + "\ud805\udcc4\ud805\udcc5"
        + "\ud805\udcc7\ud805\udcc7"
        + "\ud805\udd80\ud805\uddae"
        + "\ud805\ude00\ud805\ude2f"
        + "\ud805\ude44\ud805\ude44"
        + "\ud805\ude80\ud805\udeaa"
        + "\ud806\udca0\ud806\udcdf"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud809\udc00\ud809\udc6e"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udf00\ud81a\udf2f"
        + "\ud81a\udf40\ud81a\udf43"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf50"
        + "\ud81b\udf93\ud81b\udf9f"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udec0"
        + "\ud835\udec2\ud835\udeda"
        + "\ud835\udedc\ud835\udefa"
        + "\ud835\udefc\ud835\udf14"
        + "\ud835\udf16\ud835\udf34"
        + "\ud835\udf36\ud835\udf4e"
        + "\ud835\udf50\ud835\udf6e"
        + "\ud835\udf70\ud835\udf88"
        + "\ud835\udf8a\ud835\udfa8"
        + "\ud835\udfaa\ud835\udfc2"
        + "\ud835\udfc4\ud835\udfcb"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83b\ude4f"
        + "\ud83b\ude51\ud83b\ude52"
        + "\ud83b\ude54\ud83b\ude54"
        + "\ud83b\ude57\ud83b\ude57"
        + "\ud83b\ude59\ud83b\ude59"
        + "\ud83b\ude5b\ud83b\ude5b"
        + "\ud83b\ude5d\ud83b\ude5d"
        + "\ud83b\ude5f\ud83b\ude5f"
        + "\ud83b\ude61\ud83b\ude62"
        + "\ud83b\ude64\ud83b\ude64"
        + "\ud83b\ude67\ud83b\ude6a"
        + "\ud83b\ude6c\ud83b\ude72"
        + "\ud83b\ude74\ud83b\ude77"
        + "\ud83b\ude79\ud83b\ude7c"
        + "\ud83b\ude7e\ud83b\ude7e"
        + "\ud83b\ude80\ud83b\ude89"
        + "\ud83b\ude8b\ud83b\ude9b"
        + "\ud83b\udea1\ud83b\udea3"
        + "\ud83b\udea5\ud83b\udea9"
        + "\ud83b\udeab\ud83b\udebb"
        + "\ud83c\udd30\ud83c\udd49"
        + "\ud83c\udd50\ud83c\udd69"
        + "\ud83c\udd70\ud83c\udd89",
    // Unicode 7.0 property value: {wordbreak=cr}
    "\r\r",
    // Unicode 7.0 property value: {wordbreak=doublequote}
    "\"\"",
    // Unicode 7.0 property value: {wordbreak=extend}
    "\u0300\u036f"
        + "\u0483\u0489"
        + "\u0591\u05bd"
        + "\u05bf\u05bf"
        + "\u05c1\u05c2"
        + "\u05c4\u05c5"
        + "\u05c7\u05c7"
        + "\u0610\u061a"
        + "\u064b\u065f"
        + "\u0670\u0670"
        + "\u06d6\u06dc"
        + "\u06df\u06e4"
        + "\u06e7\u06e8"
        + "\u06ea\u06ed"
        + "\u0711\u0711"
        + "\u0730\u074a"
        + "\u07a6\u07b0"
        + "\u07eb\u07f3"
        + "\u0816\u0819"
        + "\u081b\u0823"
        + "\u0825\u0827"
        + "\u0829\u082d"
        + "\u0859\u085b"
        + "\u08e4\u0903"
        + "\u093a\u093c"
        + "\u093e\u094f"
        + "\u0951\u0957"
        + "\u0962\u0963"
        + "\u0981\u0983"
        + "\u09bc\u09bc"
        + "\u09be\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09cd"
        + "\u09d7\u09d7"
        + "\u09e2\u09e3"
        + "\u0a01\u0a03"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a70\u0a71"
        + "\u0a75\u0a75"
        + "\u0a81\u0a83"
        + "\u0abc\u0abc"
        + "\u0abe\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ae2\u0ae3"
        + "\u0b01\u0b03"
        + "\u0b3c\u0b3c"
        + "\u0b3e\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b62\u0b63"
        + "\u0b82\u0b82"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd7\u0bd7"
        + "\u0c00\u0c03"
        + "\u0c3e\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c62\u0c63"
        + "\u0c81\u0c83"
        + "\u0cbc\u0cbc"
        + "\u0cbe\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0ce2\u0ce3"
        + "\u0d01\u0d03"
        + "\u0d3e\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4d"
        + "\u0d57\u0d57"
        + "\u0d62\u0d63"
        + "\u0d82\u0d83"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0df2\u0df3"
        + "\u0e31\u0e31"
        + "\u0e34\u0e3a"
        + "\u0e47\u0e4e"
        + "\u0eb1\u0eb1"
        + "\u0eb4\u0eb9"
        + "\u0ebb\u0ebc"
        + "\u0ec8\u0ecd"
        + "\u0f18\u0f19"
        + "\u0f35\u0f35"
        + "\u0f37\u0f37"
        + "\u0f39\u0f39"
        + "\u0f3e\u0f3f"
        + "\u0f71\u0f84"
        + "\u0f86\u0f87"
        + "\u0f8d\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fc6\u0fc6"
        + "\u102b\u103e"
        + "\u1056\u1059"
        + "\u105e\u1060"
        + "\u1062\u1064"
        + "\u1067\u106d"
        + "\u1071\u1074"
        + "\u1082\u108d"
        + "\u108f\u108f"
        + "\u109a\u109d"
        + "\u135d\u135f"
        + "\u1712\u1714"
        + "\u1732\u1734"
        + "\u1752\u1753"
        + "\u1772\u1773"
        + "\u17b4\u17d3"
        + "\u17dd\u17dd"
        + "\u180b\u180d"
        + "\u18a9\u18a9"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u19b0\u19c0"
        + "\u19c8\u19c9"
        + "\u1a17\u1a1b"
        + "\u1a55\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1a7f\u1a7f"
        + "\u1ab0\u1abe"
        + "\u1b00\u1b04"
        + "\u1b34\u1b44"
        + "\u1b6b\u1b73"
        + "\u1b80\u1b82"
        + "\u1ba1\u1bad"
        + "\u1be6\u1bf3"
        + "\u1c24\u1c37"
        + "\u1cd0\u1cd2"
        + "\u1cd4\u1ce8"
        + "\u1ced\u1ced"
        + "\u1cf2\u1cf4"
        + "\u1cf8\u1cf9"
        + "\u1dc0\u1df5"
        + "\u1dfc\u1dff"
        + "\u200c\u200d"
        + "\u20d0\u20f0"
        + "\u2cef\u2cf1"
        + "\u2d7f\u2d7f"
        + "\u2de0\u2dff"
        + "\u302a\u302f"
        + "\u3099\u309a"
        + "\ua66f\ua672"
        + "\ua674\ua67d"
        + "\ua69f\ua69f"
        + "\ua6f0\ua6f1"
        + "\ua802\ua802"
        + "\ua806\ua806"
        + "\ua80b\ua80b"
        + "\ua823\ua827"
        + "\ua880\ua881"
        + "\ua8b4\ua8c4"
        + "\ua8e0\ua8f1"
        + "\ua926\ua92d"
        + "\ua947\ua953"
        + "\ua980\ua983"
        + "\ua9b3\ua9c0"
        + "\ua9e5\ua9e5"
        + "\uaa29\uaa36"
        + "\uaa43\uaa43"
        + "\uaa4c\uaa4d"
        + "\uaa7b\uaa7d"
        + "\uaab0\uaab0"
        + "\uaab2\uaab4"
        + "\uaab7\uaab8"
        + "\uaabe\uaabf"
        + "\uaac1\uaac1"
        + "\uaaeb\uaaef"
        + "\uaaf5\uaaf6"
        + "\uabe3\uabea"
        + "\uabec\uabed"
        + "\ufb1e\ufb1e"
        + "\ufe00\ufe0f"
        + "\ufe20\ufe2d"
        + "\uff9e\uff9f"
        + "\ud800\uddfd\ud800\uddfd"
        + "\ud800\udee0\ud800\udee0"
        + "\ud800\udf76\ud800\udf7a"
        + "\ud802\ude01\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude0f"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude3f"
        + "\ud802\udee5\ud802\udee6"
        + "\ud804\udc00\ud804\udc02"
        + "\ud804\udc38\ud804\udc46"
        + "\ud804\udc7f\ud804\udc82"
        + "\ud804\udcb0\ud804\udcba"
        + "\ud804\udd00\ud804\udd02"
        + "\ud804\udd27\ud804\udd34"
        + "\ud804\udd73\ud804\udd73"
        + "\ud804\udd80\ud804\udd82"
        + "\ud804\uddb3\ud804\uddc0"
        + "\ud804\ude2c\ud804\ude37"
        + "\ud804\udedf\ud804\udeea"
        + "\ud804\udf01\ud804\udf03"
        + "\ud804\udf3c\ud804\udf3c"
        + "\ud804\udf3e\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf62\ud804\udf63"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udcb0\ud805\udcc3"
        + "\ud805\uddaf\ud805\uddb5"
        + "\ud805\uddb8\ud805\uddc0"
        + "\ud805\ude30\ud805\ude40"
        + "\ud805\udeab\ud805\udeb7"
        + "\ud81a\udef0\ud81a\udef4"
        + "\ud81a\udf30\ud81a\udf36"
        + "\ud81b\udf51\ud81b\udf7e"
        + "\ud81b\udf8f\ud81b\udf92"
        + "\ud82f\udc9d\ud82f\udc9e"
        + "\ud834\udd65\ud834\udd69"
        + "\ud834\udd6d\ud834\udd72"
        + "\ud834\udd7b\ud834\udd82"
        + "\ud834\udd85\ud834\udd8b"
        + "\ud834\uddaa\ud834\uddad"
        + "\ud834\ude42\ud834\ude44"
        + "\ud83a\udcd0\ud83a\udcd6"
        + "\udb40\udd00\udb40\uddef",
    // Unicode 7.0 property value: {wordbreak=extendnumlet}
    "\u005f\u005f"
        + "\u203f\u2040"
        + "\u2054\u2054"
        + "\ufe33\ufe34"
        + "\ufe4d\ufe4f"
        + "\uff3f\uff3f",
    // Unicode 7.0 property value: {wordbreak=format}
    "\u00ad\u00ad"
        + "\u0600\u0605"
        + "\u061c\u061c"
        + "\u06dd\u06dd"
        + "\u070f\u070f"
        + "\u180e\u180e"
        + "\u200e\u200f"
        + "\u202a\u202e"
        + "\u2060\u2064"
        + "\u2066\u206f"
        + "\ufeff\ufeff"
        + "\ufff9\ufffb"
        + "\ud804\udcbd\ud804\udcbd"
        + "\ud82f\udca0\ud82f\udca3"
        + "\ud834\udd73\ud834\udd7a"
        + "\udb40\udc01\udb40\udc01"
        + "\udb40\udc20\udb40\udc7f",
    // Unicode 7.0 property value: {wordbreak=hebrewletter}
    "\u05d0\u05ea"
        + "\u05f0\u05f2"
        + "\ufb1d\ufb1d"
        + "\ufb1f\ufb28"
        + "\ufb2a\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufb4f",
    // Unicode 7.0 property value: {wordbreak=katakana}
    "\u3031\u3035"
        + "\u309b\u309c"
        + "\u30a0\u30fa"
        + "\u30fc\u30ff"
        + "\u31f0\u31ff"
        + "\u32d0\u32fe"
        + "\u3300\u3357"
        + "\uff66\uff9d"
        + "\ud82c\udc00\ud82c\udc00",
    // Unicode 7.0 property value: {wordbreak=lf}
    "\n\n",
    // Unicode 7.0 property value: {wordbreak=midletter}
    "\u003a\u003a"
        + "\u00b7\u00b7"
        + "\u02d7\u02d7"
        + "\u0387\u0387"
        + "\u05f4\u05f4"
        + "\u2027\u2027"
        + "\ufe13\ufe13"
        + "\ufe55\ufe55"
        + "\uff1a\uff1a",
    // Unicode 7.0 property value: {wordbreak=midnum}
    "\u002c\u002c"
        + "\u003b\u003b"
        + "\u037e\u037e"
        + "\u0589\u0589"
        + "\u060c\u060d"
        + "\u066c\u066c"
        + "\u07f8\u07f8"
        + "\u2044\u2044"
        + "\ufe10\ufe10"
        + "\ufe14\ufe14"
        + "\ufe50\ufe50"
        + "\ufe54\ufe54"
        + "\uff0c\uff0c"
        + "\uff1b\uff1b",
    // Unicode 7.0 property value: {wordbreak=midnumlet}
    "\u002e\u002e"
        + "\u2018\u2019"
        + "\u2024\u2024"
        + "\ufe52\ufe52"
        + "\uff07\uff07"
        + "\uff0e\uff0e",
    // Unicode 7.0 property value: {wordbreak=newline}
    "\u000b\f" + "\u0085\u0085" + "\u2028\u2029",
    // Unicode 7.0 property value: {wordbreak=numeric}
    "\u0030\u0039"
        + "\u0660\u0669"
        + "\u066b\u066b"
        + "\u06f0\u06f9"
        + "\u07c0\u07c9"
        + "\u0966\u096f"
        + "\u09e6\u09ef"
        + "\u0a66\u0a6f"
        + "\u0ae6\u0aef"
        + "\u0b66\u0b6f"
        + "\u0be6\u0bef"
        + "\u0c66\u0c6f"
        + "\u0ce6\u0cef"
        + "\u0d66\u0d6f"
        + "\u0de6\u0def"
        + "\u0e50\u0e59"
        + "\u0ed0\u0ed9"
        + "\u0f20\u0f29"
        + "\u1040\u1049"
        + "\u1090\u1099"
        + "\u17e0\u17e9"
        + "\u1810\u1819"
        + "\u1946\u194f"
        + "\u19d0\u19d9"
        + "\u1a80\u1a89"
        + "\u1a90\u1a99"
        + "\u1b50\u1b59"
        + "\u1bb0\u1bb9"
        + "\u1c40\u1c49"
        + "\u1c50\u1c59"
        + "\ua620\ua629"
        + "\ua8d0\ua8d9"
        + "\ua900\ua909"
        + "\ua9d0\ua9d9"
        + "\ua9f0\ua9f9"
        + "\uaa50\uaa59"
        + "\uabf0\uabf9"
        + "\ud801\udca0\ud801\udca9"
        + "\ud804\udc66\ud804\udc6f"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd36\ud804\udd3f"
        + "\ud804\uddd0\ud804\uddd9"
        + "\ud804\udef0\ud804\udef9"
        + "\ud805\udcd0\ud805\udcd9"
        + "\ud805\ude50\ud805\ude59"
        + "\ud805\udec0\ud805\udec9"
        + "\ud806\udce0\ud806\udce9"
        + "\ud81a\ude60\ud81a\ude69"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud835\udfce\ud835\udfff",
    // Unicode 7.0 property value: {wordbreak=other}
    "\000\t"
        + "\u000e\u0021"
        + "\u0023\u0026"
        + "\u0028\u002b"
        + "\u002d\u002d"
        + "\u002f\u002f"
        + "\u003c\u0040"
        + "\u005b\u005e"
        + "\u0060\u0060"
        + "\u007b\u0084"
        + "\u0086\u00a9"
        + "\u00ab\u00ac"
        + "\u00ae\u00b4"
        + "\u00b6\u00b6"
        + "\u00b8\u00b9"
        + "\u00bb\u00bf"
        + "\u00d7\u00d7"
        + "\u00f7\u00f7"
        + "\u02c2\u02c5"
        + "\u02d2\u02d6"
        + "\u02d8\u02df"
        + "\u02e5\u02eb"
        + "\u02ed\u02ed"
        + "\u02ef\u02ff"
        + "\u0375\u0375"
        + "\u0378\u0379"
        + "\u0380\u0385"
        + "\u038b\u038b"
        + "\u038d\u038d"
        + "\u03a2\u03a2"
        + "\u03f6\u03f6"
        + "\u0482\u0482"
        + "\u0530\u0530"
        + "\u0557\u0558"
        + "\u055a\u0560"
        + "\u0588\u0588"
        + "\u058a\u0590"
        + "\u05be\u05be"
        + "\u05c0\u05c0"
        + "\u05c3\u05c3"
        + "\u05c6\u05c6"
        + "\u05c8\u05cf"
        + "\u05eb\u05ef"
        + "\u05f5\u05ff"
        + "\u0606\u060b"
        + "\u060e\u060f"
        + "\u061b\u061b"
        + "\u061d\u061f"
        + "\u066a\u066a"
        + "\u066d\u066d"
        + "\u06d4\u06d4"
        + "\u06de\u06de"
        + "\u06e9\u06e9"
        + "\u06fd\u06fe"
        + "\u0700\u070e"
        + "\u074b\u074c"
        + "\u07b2\u07bf"
        + "\u07f6\u07f7"
        + "\u07f9\u07f9"
        + "\u07fb\u07ff"
        + "\u082e\u083f"
        + "\u085c\u089f"
        + "\u08b3\u08e3"
        + "\u0964\u0965"
        + "\u0970\u0970"
        + "\u0984\u0984"
        + "\u098d\u098e"
        + "\u0991\u0992"
        + "\u09a9\u09a9"
        + "\u09b1\u09b1"
        + "\u09b3\u09b5"
        + "\u09ba\u09bb"
        + "\u09c5\u09c6"
        + "\u09c9\u09ca"
        + "\u09cf\u09d6"
        + "\u09d8\u09db"
        + "\u09de\u09de"
        + "\u09e4\u09e5"
        + "\u09f2\u0a00"
        + "\u0a04\u0a04"
        + "\u0a0b\u0a0e"
        + "\u0a11\u0a12"
        + "\u0a29\u0a29"
        + "\u0a31\u0a31"
        + "\u0a34\u0a34"
        + "\u0a37\u0a37"
        + "\u0a3a\u0a3b"
        + "\u0a3d\u0a3d"
        + "\u0a43\u0a46"
        + "\u0a49\u0a4a"
        + "\u0a4e\u0a50"
        + "\u0a52\u0a58"
        + "\u0a5d\u0a5d"
        + "\u0a5f\u0a65"
        + "\u0a76\u0a80"
        + "\u0a84\u0a84"
        + "\u0a8e\u0a8e"
        + "\u0a92\u0a92"
        + "\u0aa9\u0aa9"
        + "\u0ab1\u0ab1"
        + "\u0ab4\u0ab4"
        + "\u0aba\u0abb"
        + "\u0ac6\u0ac6"
        + "\u0aca\u0aca"
        + "\u0ace\u0acf"
        + "\u0ad1\u0adf"
        + "\u0ae4\u0ae5"
        + "\u0af0\u0b00"
        + "\u0b04\u0b04"
        + "\u0b0d\u0b0e"
        + "\u0b11\u0b12"
        + "\u0b29\u0b29"
        + "\u0b31\u0b31"
        + "\u0b34\u0b34"
        + "\u0b3a\u0b3b"
        + "\u0b45\u0b46"
        + "\u0b49\u0b4a"
        + "\u0b4e\u0b55"
        + "\u0b58\u0b5b"
        + "\u0b5e\u0b5e"
        + "\u0b64\u0b65"
        + "\u0b70\u0b70"
        + "\u0b72\u0b81"
        + "\u0b84\u0b84"
        + "\u0b8b\u0b8d"
        + "\u0b91\u0b91"
        + "\u0b96\u0b98"
        + "\u0b9b\u0b9b"
        + "\u0b9d\u0b9d"
        + "\u0ba0\u0ba2"
        + "\u0ba5\u0ba7"
        + "\u0bab\u0bad"
        + "\u0bba\u0bbd"
        + "\u0bc3\u0bc5"
        + "\u0bc9\u0bc9"
        + "\u0bce\u0bcf"
        + "\u0bd1\u0bd6"
        + "\u0bd8\u0be5"
        + "\u0bf0\u0bff"
        + "\u0c04\u0c04"
        + "\u0c0d\u0c0d"
        + "\u0c11\u0c11"
        + "\u0c29\u0c29"
        + "\u0c3a\u0c3c"
        + "\u0c45\u0c45"
        + "\u0c49\u0c49"
        + "\u0c4e\u0c54"
        + "\u0c57\u0c57"
        + "\u0c5a\u0c5f"
        + "\u0c64\u0c65"
        + "\u0c70\u0c80"
        + "\u0c84\u0c84"
        + "\u0c8d\u0c8d"
        + "\u0c91\u0c91"
        + "\u0ca9\u0ca9"
        + "\u0cb4\u0cb4"
        + "\u0cba\u0cbb"
        + "\u0cc5\u0cc5"
        + "\u0cc9\u0cc9"
        + "\u0cce\u0cd4"
        + "\u0cd7\u0cdd"
        + "\u0cdf\u0cdf"
        + "\u0ce4\u0ce5"
        + "\u0cf0\u0cf0"
        + "\u0cf3\u0d00"
        + "\u0d04\u0d04"
        + "\u0d0d\u0d0d"
        + "\u0d11\u0d11"
        + "\u0d3b\u0d3c"
        + "\u0d45\u0d45"
        + "\u0d49\u0d49"
        + "\u0d4f\u0d56"
        + "\u0d58\u0d5f"
        + "\u0d64\u0d65"
        + "\u0d70\u0d79"
        + "\u0d80\u0d81"
        + "\u0d84\u0d84"
        + "\u0d97\u0d99"
        + "\u0db2\u0db2"
        + "\u0dbc\u0dbc"
        + "\u0dbe\u0dbf"
        + "\u0dc7\u0dc9"
        + "\u0dcb\u0dce"
        + "\u0dd5\u0dd5"
        + "\u0dd7\u0dd7"
        + "\u0de0\u0de5"
        + "\u0df0\u0df1"
        + "\u0df4\u0e30"
        + "\u0e32\u0e33"
        + "\u0e3b\u0e46"
        + "\u0e4f\u0e4f"
        + "\u0e5a\u0eb0"
        + "\u0eb2\u0eb3"
        + "\u0eba\u0eba"
        + "\u0ebd\u0ec7"
        + "\u0ece\u0ecf"
        + "\u0eda\u0eff"
        + "\u0f01\u0f17"
        + "\u0f1a\u0f1f"
        + "\u0f2a\u0f34"
        + "\u0f36\u0f36"
        + "\u0f38\u0f38"
        + "\u0f3a\u0f3d"
        + "\u0f48\u0f48"
        + "\u0f6d\u0f70"
        + "\u0f85\u0f85"
        + "\u0f98\u0f98"
        + "\u0fbd\u0fc5"
        + "\u0fc7\u102a"
        + "\u103f\u103f"
        + "\u104a\u1055"
        + "\u105a\u105d"
        + "\u1061\u1061"
        + "\u1065\u1066"
        + "\u106e\u1070"
        + "\u1075\u1081"
        + "\u108e\u108e"
        + "\u109e\u109f"
        + "\u10c6\u10c6"
        + "\u10c8\u10cc"
        + "\u10ce\u10cf"
        + "\u10fb\u10fb"
        + "\u1249\u1249"
        + "\u124e\u124f"
        + "\u1257\u1257"
        + "\u1259\u1259"
        + "\u125e\u125f"
        + "\u1289\u1289"
        + "\u128e\u128f"
        + "\u12b1\u12b1"
        + "\u12b6\u12b7"
        + "\u12bf\u12bf"
        + "\u12c1\u12c1"
        + "\u12c6\u12c7"
        + "\u12d7\u12d7"
        + "\u1311\u1311"
        + "\u1316\u1317"
        + "\u135b\u135c"
        + "\u1360\u137f"
        + "\u1390\u139f"
        + "\u13f5\u1400"
        + "\u166d\u166e"
        + "\u1680\u1680"
        + "\u169b\u169f"
        + "\u16eb\u16ed"
        + "\u16f9\u16ff"
        + "\u170d\u170d"
        + "\u1715\u171f"
        + "\u1735\u173f"
        + "\u1754\u175f"
        + "\u176d\u176d"
        + "\u1771\u1771"
        + "\u1774\u17b3"
        + "\u17d4\u17dc"
        + "\u17de\u17df"
        + "\u17ea\u180a"
        + "\u180f\u180f"
        + "\u181a\u181f"
        + "\u1878\u187f"
        + "\u18ab\u18af"
        + "\u18f6\u18ff"
        + "\u191f\u191f"
        + "\u192c\u192f"
        + "\u193c\u1945"
        + "\u1950\u19af"
        + "\u19c1\u19c7"
        + "\u19ca\u19cf"
        + "\u19da\u19ff"
        + "\u1a1c\u1a54"
        + "\u1a5f\u1a5f"
        + "\u1a7d\u1a7e"
        + "\u1a8a\u1a8f"
        + "\u1a9a\u1aaf"
        + "\u1abf\u1aff"
        + "\u1b4c\u1b4f"
        + "\u1b5a\u1b6a"
        + "\u1b74\u1b7f"
        + "\u1bf4\u1bff"
        + "\u1c38\u1c3f"
        + "\u1c4a\u1c4c"
        + "\u1c7e\u1ccf"
        + "\u1cd3\u1cd3"
        + "\u1cf7\u1cf7"
        + "\u1cfa\u1cff"
        + "\u1df6\u1dfb"
        + "\u1f16\u1f17"
        + "\u1f1e\u1f1f"
        + "\u1f46\u1f47"
        + "\u1f4e\u1f4f"
        + "\u1f58\u1f58"
        + "\u1f5a\u1f5a"
        + "\u1f5c\u1f5c"
        + "\u1f5e\u1f5e"
        + "\u1f7e\u1f7f"
        + "\u1fb5\u1fb5"
        + "\u1fbd\u1fbd"
        + "\u1fbf\u1fc1"
        + "\u1fc5\u1fc5"
        + "\u1fcd\u1fcf"
        + "\u1fd4\u1fd5"
        + "\u1fdc\u1fdf"
        + "\u1fed\u1ff1"
        + "\u1ff5\u1ff5"
        + "\u1ffd\u200b"
        + "\u2010\u2017"
        + "\u201a\u2023"
        + "\u2025\u2026"
        + "\u202f\u203e"
        + "\u2041\u2043"
        + "\u2045\u2053"
        + "\u2055\u205f"
        + "\u2065\u2065"
        + "\u2070\u2070"
        + "\u2072\u207e"
        + "\u2080\u208f"
        + "\u209d\u20cf"
        + "\u20f1\u2101"
        + "\u2103\u2106"
        + "\u2108\u2109"
        + "\u2114\u2114"
        + "\u2116\u2118"
        + "\u211e\u2123"
        + "\u2125\u2125"
        + "\u2127\u2127"
        + "\u2129\u2129"
        + "\u212e\u212e"
        + "\u213a\u213b"
        + "\u2140\u2144"
        + "\u214a\u214d"
        + "\u214f\u215f"
        + "\u2189\u24b5"
        + "\u24ea\u2bff"
        + "\u2c2f\u2c2f"
        + "\u2c5f\u2c5f"
        + "\u2ce5\u2cea"
        + "\u2cf4\u2cff"
        + "\u2d26\u2d26"
        + "\u2d28\u2d2c"
        + "\u2d2e\u2d2f"
        + "\u2d68\u2d6e"
        + "\u2d70\u2d7e"
        + "\u2d97\u2d9f"
        + "\u2da7\u2da7"
        + "\u2daf\u2daf"
        + "\u2db7\u2db7"
        + "\u2dbf\u2dbf"
        + "\u2dc7\u2dc7"
        + "\u2dcf\u2dcf"
        + "\u2dd7\u2dd7"
        + "\u2ddf\u2ddf"
        + "\u2e00\u2e2e"
        + "\u2e30\u3004"
        + "\u3006\u3029"
        + "\u3030\u3030"
        + "\u3036\u303a"
        + "\u303d\u3098"
        + "\u309d\u309f"
        + "\u30fb\u30fb"
        + "\u3100\u3104"
        + "\u312e\u3130"
        + "\u318f\u319f"
        + "\u31bb\u31ef"
        + "\u3200\u32cf"
        + "\u32ff\u32ff"
        + "\u3358\u9fff"
        + "\ua48d\ua4cf"
        + "\ua4fe\ua4ff"
        + "\ua60d\ua60f"
        + "\ua62c\ua63f"
        + "\ua673\ua673"
        + "\ua67e\ua67e"
        + "\ua69e\ua69e"
        + "\ua6f2\ua716"
        + "\ua720\ua721"
        + "\ua789\ua78a"
        + "\ua78f\ua78f"
        + "\ua7ae\ua7af"
        + "\ua7b2\ua7f6"
        + "\ua828\ua83f"
        + "\ua874\ua87f"
        + "\ua8c5\ua8cf"
        + "\ua8da\ua8df"
        + "\ua8f8\ua8fa"
        + "\ua8fc\ua8ff"
        + "\ua92e\ua92f"
        + "\ua954\ua95f"
        + "\ua97d\ua97f"
        + "\ua9c1\ua9ce"
        + "\ua9da\ua9e4"
        + "\ua9e6\ua9ef"
        + "\ua9fa\ua9ff"
        + "\uaa37\uaa3f"
        + "\uaa4e\uaa4f"
        + "\uaa5a\uaa7a"
        + "\uaa7e\uaaaf"
        + "\uaab1\uaab1"
        + "\uaab5\uaab6"
        + "\uaab9\uaabd"
        + "\uaac0\uaac0"
        + "\uaac2\uaadf"
        + "\uaaf0\uaaf1"
        + "\uaaf7\uab00"
        + "\uab07\uab08"
        + "\uab0f\uab10"
        + "\uab17\uab1f"
        + "\uab27\uab27"
        + "\uab2f\uab2f"
        + "\uab5b\uab5b"
        + "\uab60\uab63"
        + "\uab66\uabbf"
        + "\uabeb\uabeb"
        + "\uabee\uabef"
        + "\uabfa\uabff"
        + "\ud7a4\ud7af"
        + "\ud7c7\ud7ca"
        + "\ud7fc\ud7ff"
        + "\ue000\ufaff"
        + "\ufb07\ufb12"
        + "\ufb18\ufb1c"
        + "\ufb29\ufb29"
        + "\ufb37\ufb37"
        + "\ufb3d\ufb3d"
        + "\ufb3f\ufb3f"
        + "\ufb42\ufb42"
        + "\ufb45\ufb45"
        + "\ufbb2\ufbd2"
        + "\ufd3e\ufd4f"
        + "\ufd90\ufd91"
        + "\ufdc8\ufdef"
        + "\ufdfc\ufdff"
        + "\ufe11\ufe12"
        + "\ufe15\ufe1f"
        + "\ufe2e\ufe32"
        + "\ufe35\ufe4c"
        + "\ufe51\ufe51"
        + "\ufe53\ufe53"
        + "\ufe56\ufe6f"
        + "\ufe75\ufe75"
        + "\ufefd\ufefe"
        + "\uff00\uff06"
        + "\uff08\uff0b"
        + "\uff0d\uff0d"
        + "\uff0f\uff19"
        + "\uff1c\uff20"
        + "\uff3b\uff3e"
        + "\uff40\uff40"
        + "\uff5b\uff65"
        + "\uffbf\uffc1"
        + "\uffc8\uffc9"
        + "\uffd0\uffd1"
        + "\uffd8\uffd9"
        + "\uffdd\ufff8"
        + "\ufffc\uffff"
        + "\ud800\udc0c\ud800\udc0c"
        + "\ud800\udc27\ud800\udc27"
        + "\ud800\udc3b\ud800\udc3b"
        + "\ud800\udc3e\ud800\udc3e"
        + "\ud800\udc4e\ud800\udc4f"
        + "\ud800\udc5e\ud800\udc7f"
        + "\ud800\udcfb\ud800\udd3f"
        + "\ud800\udd75\ud800\uddfc"
        + "\ud800\uddfe\ud800\ude7f"
        + "\ud800\ude9d\ud800\ude9f"
        + "\ud800\uded1\ud800\udedf"
        + "\ud800\udee1\ud800\udeff"
        + "\ud800\udf20\ud800\udf2f"
        + "\ud800\udf4b\ud800\udf4f"
        + "\ud800\udf7b\ud800\udf7f"
        + "\ud800\udf9e\ud800\udf9f"
        + "\ud800\udfc4\ud800\udfc7"
        + "\ud800\udfd0\ud800\udfd0"
        + "\ud800\udfd6\ud800\udfff"
        + "\ud801\udc9e\ud801\udc9f"
        + "\ud801\udcaa\ud801\udcff"
        + "\ud801\udd28\ud801\udd2f"
        + "\ud801\udd64\ud801\uddff"
        + "\ud801\udf37\ud801\udf3f"
        + "\ud801\udf56\ud801\udf5f"
        + "\ud801\udf68\ud801\udfff"
        + "\ud802\udc06\ud802\udc07"
        + "\ud802\udc09\ud802\udc09"
        + "\ud802\udc36\ud802\udc36"
        + "\ud802\udc39\ud802\udc3b"
        + "\ud802\udc3d\ud802\udc3e"
        + "\ud802\udc56\ud802\udc5f"
        + "\ud802\udc77\ud802\udc7f"
        + "\ud802\udc9f\ud802\udcff"
        + "\ud802\udd16\ud802\udd1f"
        + "\ud802\udd3a\ud802\udd7f"
        + "\ud802\uddb8\ud802\uddbd"
        + "\ud802\uddc0\ud802\uddff"
        + "\ud802\ude04\ud802\ude04"
        + "\ud802\ude07\ud802\ude0b"
        + "\ud802\ude14\ud802\ude14"
        + "\ud802\ude18\ud802\ude18"
        + "\ud802\ude34\ud802\ude37"
        + "\ud802\ude3b\ud802\ude3e"
        + "\ud802\ude40\ud802\ude5f"
        + "\ud802\ude7d\ud802\ude7f"
        + "\ud802\ude9d\ud802\udebf"
        + "\ud802\udec8\ud802\udec8"
        + "\ud802\udee7\ud802\udeff"
        + "\ud802\udf36\ud802\udf3f"
        + "\ud802\udf56\ud802\udf5f"
        + "\ud802\udf73\ud802\udf7f"
        + "\ud802\udf92\ud802\udfff"
        + "\ud803\udc49\ud803\udfff"
        + "\ud804\udc47\ud804\udc65"
        + "\ud804\udc70\ud804\udc7e"
        + "\ud804\udcbb\ud804\udcbc"
        + "\ud804\udcbe\ud804\udccf"
        + "\ud804\udce9\ud804\udcef"
        + "\ud804\udcfa\ud804\udcff"
        + "\ud804\udd35\ud804\udd35"
        + "\ud804\udd40\ud804\udd4f"
        + "\ud804\udd74\ud804\udd75"
        + "\ud804\udd77\ud804\udd7f"
        + "\ud804\uddc5\ud804\uddcf"
        + "\ud804\udddb\ud804\uddff"
        + "\ud804\ude12\ud804\ude12"
        + "\ud804\ude38\ud804\udeaf"
        + "\ud804\udeeb\ud804\udeef"
        + "\ud804\udefa\ud804\udf00"
        + "\ud804\udf04\ud804\udf04"
        + "\ud804\udf0d\ud804\udf0e"
        + "\ud804\udf11\ud804\udf12"
        + "\ud804\udf29\ud804\udf29"
        + "\ud804\udf31\ud804\udf31"
        + "\ud804\udf34\ud804\udf34"
        + "\ud804\udf3a\ud804\udf3b"
        + "\ud804\udf45\ud804\udf46"
        + "\ud804\udf49\ud804\udf4a"
        + "\ud804\udf4e\ud804\udf56"
        + "\ud804\udf58\ud804\udf5c"
        + "\ud804\udf64\ud804\udf65"
        + "\ud804\udf6d\ud804\udf6f"
        + "\ud804\udf75\ud805\udc7f"
        + "\ud805\udcc6\ud805\udcc6"
        + "\ud805\udcc8\ud805\udccf"
        + "\ud805\udcda\ud805\udd7f"
        + "\ud805\uddb6\ud805\uddb7"
        + "\ud805\uddc1\ud805\uddff"
        + "\ud805\ude41\ud805\ude43"
        + "\ud805\ude45\ud805\ude4f"
        + "\ud805\ude5a\ud805\ude7f"
        + "\ud805\udeb8\ud805\udebf"
        + "\ud805\udeca\ud806\udc9f"
        + "\ud806\udcea\ud806\udcfe"
        + "\ud806\udd00\ud806\udebf"
        + "\ud806\udef9\ud807\udfff"
        + "\ud808\udf99\ud808\udfff"
        + "\ud809\udc6f\ud80b\udfff"
        + "\ud80d\udc2f\ud819\udfff"
        + "\ud81a\ude39\ud81a\ude3f"
        + "\ud81a\ude5f\ud81a\ude5f"
        + "\ud81a\ude6a\ud81a\udecf"
        + "\ud81a\udeee\ud81a\udeef"
        + "\ud81a\udef5\ud81a\udeff"
        + "\ud81a\udf37\ud81a\udf3f"
        + "\ud81a\udf44\ud81a\udf4f"
        + "\ud81a\udf5a\ud81a\udf62"
        + "\ud81a\udf78\ud81a\udf7c"
        + "\ud81a\udf90\ud81b\udeff"
        + "\ud81b\udf45\ud81b\udf4f"
        + "\ud81b\udf7f\ud81b\udf8e"
        + "\ud81b\udfa0\ud82b\udfff"
        + "\ud82c\udc01\ud82e\udfff"
        + "\ud82f\udc6b\ud82f\udc6f"
        + "\ud82f\udc7d\ud82f\udc7f"
        + "\ud82f\udc89\ud82f\udc8f"
        + "\ud82f\udc9a\ud82f\udc9c"
        + "\ud82f\udc9f\ud82f\udc9f"
        + "\ud82f\udca4\ud834\udd64"
        + "\ud834\udd6a\ud834\udd6c"
        + "\ud834\udd83\ud834\udd84"
        + "\ud834\udd8c\ud834\udda9"
        + "\ud834\uddae\ud834\ude41"
        + "\ud834\ude45\ud834\udfff"
        + "\ud835\udc55\ud835\udc55"
        + "\ud835\udc9d\ud835\udc9d"
        + "\ud835\udca0\ud835\udca1"
        + "\ud835\udca3\ud835\udca4"
        + "\ud835\udca7\ud835\udca8"
        + "\ud835\udcad\ud835\udcad"
        + "\ud835\udcba\ud835\udcba"
        + "\ud835\udcbc\ud835\udcbc"
        + "\ud835\udcc4\ud835\udcc4"
        + "\ud835\udd06\ud835\udd06"
        + "\ud835\udd0b\ud835\udd0c"
        + "\ud835\udd15\ud835\udd15"
        + "\ud835\udd1d\ud835\udd1d"
        + "\ud835\udd3a\ud835\udd3a"
        + "\ud835\udd3f\ud835\udd3f"
        + "\ud835\udd45\ud835\udd45"
        + "\ud835\udd47\ud835\udd49"
        + "\ud835\udd51\ud835\udd51"
        + "\ud835\udea6\ud835\udea7"
        + "\ud835\udec1\ud835\udec1"
        + "\ud835\udedb\ud835\udedb"
        + "\ud835\udefb\ud835\udefb"
        + "\ud835\udf15\ud835\udf15"
        + "\ud835\udf35\ud835\udf35"
        + "\ud835\udf4f\ud835\udf4f"
        + "\ud835\udf6f\ud835\udf6f"
        + "\ud835\udf89\ud835\udf89"
        + "\ud835\udfa9\ud835\udfa9"
        + "\ud835\udfc3\ud835\udfc3"
        + "\ud835\udfcc\ud835\udfcd"
        + "\ud836\udc00\ud839\udfff"
        + "\ud83a\udcc5\ud83a\udccf"
        + "\ud83a\udcd7\ud83b\uddff"
        + "\ud83b\ude04\ud83b\ude04"
        + "\ud83b\ude20\ud83b\ude20"
        + "\ud83b\ude23\ud83b\ude23"
        + "\ud83b\ude25\ud83b\ude26"
        + "\ud83b\ude28\ud83b\ude28"
        + "\ud83b\ude33\ud83b\ude33"
        + "\ud83b\ude38\ud83b\ude38"
        + "\ud83b\ude3a\ud83b\ude3a"
        + "\ud83b\ude3c\ud83b\ude41"
        + "\ud83b\ude43\ud83b\ude46"
        + "\ud83b\ude48\ud83b\ude48"
        + "\ud83b\ude4a\ud83b\ude4a"
        + "\ud83b\ude4c\ud83b\ude4c"
        + "\ud83b\ude50\ud83b\ude50"
        + "\ud83b\ude53\ud83b\ude53"
        + "\ud83b\ude55\ud83b\ude56"
        + "\ud83b\ude58\ud83b\ude58"
        + "\ud83b\ude5a\ud83b\ude5a"
        + "\ud83b\ude5c\ud83b\ude5c"
        + "\ud83b\ude5e\ud83b\ude5e"
        + "\ud83b\ude60\ud83b\ude60"
        + "\ud83b\ude63\ud83b\ude63"
        + "\ud83b\ude65\ud83b\ude66"
        + "\ud83b\ude6b\ud83b\ude6b"
        + "\ud83b\ude73\ud83b\ude73"
        + "\ud83b\ude78\ud83b\ude78"
        + "\ud83b\ude7d\ud83b\ude7d"
        + "\ud83b\ude7f\ud83b\ude7f"
        + "\ud83b\ude8a\ud83b\ude8a"
        + "\ud83b\ude9c\ud83b\udea0"
        + "\ud83b\udea4\ud83b\udea4"
        + "\ud83b\udeaa\ud83b\udeaa"
        + "\ud83b\udebc\ud83c\udd2f"
        + "\ud83c\udd4a\ud83c\udd4f"
        + "\ud83c\udd6a\ud83c\udd6f"
        + "\ud83c\udd8a\ud83c\udde5"
        + "\ud83c\ude00\udb40\udc00"
        + "\udb40\udc02\udb40\udc1f"
        + "\udb40\udc80\udb40\udcff"
        + "\udb40\uddf0\udbff\udfff",
    // Unicode 7.0 property value: {wordbreak=regionalindicator}
    "\ud83c\udde6\ud83c\uddff",
    // Unicode 7.0 property value: {wordbreak=singlequote}
    "\u0027\u0027",
    // Unicode 7.0 property value: {xdigit}
    "\u0030\u0039"
        + "\u0041\u0046"
        + "\u0061\u0066"
        + "\u0660\u0669"
        + "\u06f0\u06f9"
        + "\u07c0\u07c9"
        + "\u0966\u096f"
        + "\u09e6\u09ef"
        + "\u0a66\u0a6f"
        + "\u0ae6\u0aef"
        + "\u0b66\u0b6f"
        + "\u0be6\u0bef"
        + "\u0c66\u0c6f"
        + "\u0ce6\u0cef"
        + "\u0d66\u0d6f"
        + "\u0de6\u0def"
        + "\u0e50\u0e59"
        + "\u0ed0\u0ed9"
        + "\u0f20\u0f29"
        + "\u1040\u1049"
        + "\u1090\u1099"
        + "\u17e0\u17e9"
        + "\u1810\u1819"
        + "\u1946\u194f"
        + "\u19d0\u19d9"
        + "\u1a80\u1a89"
        + "\u1a90\u1a99"
        + "\u1b50\u1b59"
        + "\u1bb0\u1bb9"
        + "\u1c40\u1c49"
        + "\u1c50\u1c59"
        + "\ua620\ua629"
        + "\ua8d0\ua8d9"
        + "\ua900\ua909"
        + "\ua9d0\ua9d9"
        + "\ua9f0\ua9f9"
        + "\uaa50\uaa59"
        + "\uabf0\uabf9"
        + "\uff10\uff19"
        + "\uff21\uff26"
        + "\uff41\uff46"
        + "\ud801\udca0\ud801\udca9"
        + "\ud804\udc66\ud804\udc6f"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd36\ud804\udd3f"
        + "\ud804\uddd0\ud804\uddd9"
        + "\ud804\udef0\ud804\udef9"
        + "\ud805\udcd0\ud805\udcd9"
        + "\ud805\ude50\ud805\ude59"
        + "\ud805\udec0\ud805\udec9"
        + "\ud806\udce0\ud806\udce9"
        + "\ud81a\ude60\ud81a\ude69"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud835\udfce\ud835\udfff",
    // Unicode 7.0 property value: {xidcontinue}
    "\u0030\u0039"
        + "\u0041\u005a"
        + "\u005f\u005f"
        + "\u0061\u007a"
        + "\u00aa\u00aa"
        + "\u00b5\u00b5"
        + "\u00b7\u00b7"
        + "\u00ba\u00ba"
        + "\u00c0\u00d6"
        + "\u00d8\u00f6"
        + "\u00f8\u02c1"
        + "\u02c6\u02d1"
        + "\u02e0\u02e4"
        + "\u02ec\u02ec"
        + "\u02ee\u02ee"
        + "\u0300\u0374"
        + "\u0376\u0377"
        + "\u037b\u037d"
        + "\u037f\u037f"
        + "\u0386\u038a"
        + "\u038c\u038c"
        + "\u038e\u03a1"
        + "\u03a3\u03f5"
        + "\u03f7\u0481"
        + "\u0483\u0487"
        + "\u048a\u052f"
        + "\u0531\u0556"
        + "\u0559\u0559"
        + "\u0561\u0587"
        + "\u0591\u05bd"
        + "\u05bf\u05bf"
        + "\u05c1\u05c2"
        + "\u05c4\u05c5"
        + "\u05c7\u05c7"
        + "\u05d0\u05ea"
        + "\u05f0\u05f2"
        + "\u0610\u061a"
        + "\u0620\u0669"
        + "\u066e\u06d3"
        + "\u06d5\u06dc"
        + "\u06df\u06e8"
        + "\u06ea\u06fc"
        + "\u06ff\u06ff"
        + "\u0710\u074a"
        + "\u074d\u07b1"
        + "\u07c0\u07f5"
        + "\u07fa\u07fa"
        + "\u0800\u082d"
        + "\u0840\u085b"
        + "\u08a0\u08b2"
        + "\u08e4\u0963"
        + "\u0966\u096f"
        + "\u0971\u0983"
        + "\u0985\u098c"
        + "\u098f\u0990"
        + "\u0993\u09a8"
        + "\u09aa\u09b0"
        + "\u09b2\u09b2"
        + "\u09b6\u09b9"
        + "\u09bc\u09c4"
        + "\u09c7\u09c8"
        + "\u09cb\u09ce"
        + "\u09d7\u09d7"
        + "\u09dc\u09dd"
        + "\u09df\u09e3"
        + "\u09e6\u09f1"
        + "\u0a01\u0a03"
        + "\u0a05\u0a0a"
        + "\u0a0f\u0a10"
        + "\u0a13\u0a28"
        + "\u0a2a\u0a30"
        + "\u0a32\u0a33"
        + "\u0a35\u0a36"
        + "\u0a38\u0a39"
        + "\u0a3c\u0a3c"
        + "\u0a3e\u0a42"
        + "\u0a47\u0a48"
        + "\u0a4b\u0a4d"
        + "\u0a51\u0a51"
        + "\u0a59\u0a5c"
        + "\u0a5e\u0a5e"
        + "\u0a66\u0a75"
        + "\u0a81\u0a83"
        + "\u0a85\u0a8d"
        + "\u0a8f\u0a91"
        + "\u0a93\u0aa8"
        + "\u0aaa\u0ab0"
        + "\u0ab2\u0ab3"
        + "\u0ab5\u0ab9"
        + "\u0abc\u0ac5"
        + "\u0ac7\u0ac9"
        + "\u0acb\u0acd"
        + "\u0ad0\u0ad0"
        + "\u0ae0\u0ae3"
        + "\u0ae6\u0aef"
        + "\u0b01\u0b03"
        + "\u0b05\u0b0c"
        + "\u0b0f\u0b10"
        + "\u0b13\u0b28"
        + "\u0b2a\u0b30"
        + "\u0b32\u0b33"
        + "\u0b35\u0b39"
        + "\u0b3c\u0b44"
        + "\u0b47\u0b48"
        + "\u0b4b\u0b4d"
        + "\u0b56\u0b57"
        + "\u0b5c\u0b5d"
        + "\u0b5f\u0b63"
        + "\u0b66\u0b6f"
        + "\u0b71\u0b71"
        + "\u0b82\u0b83"
        + "\u0b85\u0b8a"
        + "\u0b8e\u0b90"
        + "\u0b92\u0b95"
        + "\u0b99\u0b9a"
        + "\u0b9c\u0b9c"
        + "\u0b9e\u0b9f"
        + "\u0ba3\u0ba4"
        + "\u0ba8\u0baa"
        + "\u0bae\u0bb9"
        + "\u0bbe\u0bc2"
        + "\u0bc6\u0bc8"
        + "\u0bca\u0bcd"
        + "\u0bd0\u0bd0"
        + "\u0bd7\u0bd7"
        + "\u0be6\u0bef"
        + "\u0c00\u0c03"
        + "\u0c05\u0c0c"
        + "\u0c0e\u0c10"
        + "\u0c12\u0c28"
        + "\u0c2a\u0c39"
        + "\u0c3d\u0c44"
        + "\u0c46\u0c48"
        + "\u0c4a\u0c4d"
        + "\u0c55\u0c56"
        + "\u0c58\u0c59"
        + "\u0c60\u0c63"
        + "\u0c66\u0c6f"
        + "\u0c81\u0c83"
        + "\u0c85\u0c8c"
        + "\u0c8e\u0c90"
        + "\u0c92\u0ca8"
        + "\u0caa\u0cb3"
        + "\u0cb5\u0cb9"
        + "\u0cbc\u0cc4"
        + "\u0cc6\u0cc8"
        + "\u0cca\u0ccd"
        + "\u0cd5\u0cd6"
        + "\u0cde\u0cde"
        + "\u0ce0\u0ce3"
        + "\u0ce6\u0cef"
        + "\u0cf1\u0cf2"
        + "\u0d01\u0d03"
        + "\u0d05\u0d0c"
        + "\u0d0e\u0d10"
        + "\u0d12\u0d3a"
        + "\u0d3d\u0d44"
        + "\u0d46\u0d48"
        + "\u0d4a\u0d4e"
        + "\u0d57\u0d57"
        + "\u0d60\u0d63"
        + "\u0d66\u0d6f"
        + "\u0d7a\u0d7f"
        + "\u0d82\u0d83"
        + "\u0d85\u0d96"
        + "\u0d9a\u0db1"
        + "\u0db3\u0dbb"
        + "\u0dbd\u0dbd"
        + "\u0dc0\u0dc6"
        + "\u0dca\u0dca"
        + "\u0dcf\u0dd4"
        + "\u0dd6\u0dd6"
        + "\u0dd8\u0ddf"
        + "\u0de6\u0def"
        + "\u0df2\u0df3"
        + "\u0e01\u0e3a"
        + "\u0e40\u0e4e"
        + "\u0e50\u0e59"
        + "\u0e81\u0e82"
        + "\u0e84\u0e84"
        + "\u0e87\u0e88"
        + "\u0e8a\u0e8a"
        + "\u0e8d\u0e8d"
        + "\u0e94\u0e97"
        + "\u0e99\u0e9f"
        + "\u0ea1\u0ea3"
        + "\u0ea5\u0ea5"
        + "\u0ea7\u0ea7"
        + "\u0eaa\u0eab"
        + "\u0ead\u0eb9"
        + "\u0ebb\u0ebd"
        + "\u0ec0\u0ec4"
        + "\u0ec6\u0ec6"
        + "\u0ec8\u0ecd"
        + "\u0ed0\u0ed9"
        + "\u0edc\u0edf"
        + "\u0f00\u0f00"
        + "\u0f18\u0f19"
        + "\u0f20\u0f29"
        + "\u0f35\u0f35"
        + "\u0f37\u0f37"
        + "\u0f39\u0f39"
        + "\u0f3e\u0f47"
        + "\u0f49\u0f6c"
        + "\u0f71\u0f84"
        + "\u0f86\u0f97"
        + "\u0f99\u0fbc"
        + "\u0fc6\u0fc6"
        + "\u1000\u1049"
        + "\u1050\u109d"
        + "\u10a0\u10c5"
        + "\u10c7\u10c7"
        + "\u10cd\u10cd"
        + "\u10d0\u10fa"
        + "\u10fc\u1248"
        + "\u124a\u124d"
        + "\u1250\u1256"
        + "\u1258\u1258"
        + "\u125a\u125d"
        + "\u1260\u1288"
        + "\u128a\u128d"
        + "\u1290\u12b0"
        + "\u12b2\u12b5"
        + "\u12b8\u12be"
        + "\u12c0\u12c0"
        + "\u12c2\u12c5"
        + "\u12c8\u12d6"
        + "\u12d8\u1310"
        + "\u1312\u1315"
        + "\u1318\u135a"
        + "\u135d\u135f"
        + "\u1369\u1371"
        + "\u1380\u138f"
        + "\u13a0\u13f4"
        + "\u1401\u166c"
        + "\u166f\u167f"
        + "\u1681\u169a"
        + "\u16a0\u16ea"
        + "\u16ee\u16f8"
        + "\u1700\u170c"
        + "\u170e\u1714"
        + "\u1720\u1734"
        + "\u1740\u1753"
        + "\u1760\u176c"
        + "\u176e\u1770"
        + "\u1772\u1773"
        + "\u1780\u17d3"
        + "\u17d7\u17d7"
        + "\u17dc\u17dd"
        + "\u17e0\u17e9"
        + "\u180b\u180d"
        + "\u1810\u1819"
        + "\u1820\u1877"
        + "\u1880\u18aa"
        + "\u18b0\u18f5"
        + "\u1900\u191e"
        + "\u1920\u192b"
        + "\u1930\u193b"
        + "\u1946\u196d"
        + "\u1970\u1974"
        + "\u1980\u19ab"
        + "\u19b0\u19c9"
        + "\u19d0\u19da"
        + "\u1a00\u1a1b"
        + "\u1a20\u1a5e"
        + "\u1a60\u1a7c"
        + "\u1a7f\u1a89"
        + "\u1a90\u1a99"
        + "\u1aa7\u1aa7"
        + "\u1ab0\u1abd"
        + "\u1b00\u1b4b"
        + "\u1b50\u1b59"
        + "\u1b6b\u1b73"
        + "\u1b80\u1bf3"
        + "\u1c00\u1c37"
        + "\u1c40\u1c49"
        + "\u1c4d\u1c7d"
        + "\u1cd0\u1cd2"
        + "\u1cd4\u1cf6"
        + "\u1cf8\u1cf9"
        + "\u1d00\u1df5"
        + "\u1dfc\u1f15"
        + "\u1f18\u1f1d"
        + "\u1f20\u1f45"
        + "\u1f48\u1f4d"
        + "\u1f50\u1f57"
        + "\u1f59\u1f59"
        + "\u1f5b\u1f5b"
        + "\u1f5d\u1f5d"
        + "\u1f5f\u1f7d"
        + "\u1f80\u1fb4"
        + "\u1fb6\u1fbc"
        + "\u1fbe\u1fbe"
        + "\u1fc2\u1fc4"
        + "\u1fc6\u1fcc"
        + "\u1fd0\u1fd3"
        + "\u1fd6\u1fdb"
        + "\u1fe0\u1fec"
        + "\u1ff2\u1ff4"
        + "\u1ff6\u1ffc"
        + "\u203f\u2040"
        + "\u2054\u2054"
        + "\u2071\u2071"
        + "\u207f\u207f"
        + "\u2090\u209c"
        + "\u20d0\u20dc"
        + "\u20e1\u20e1"
        + "\u20e5\u20f0"
        + "\u2102\u2102"
        + "\u2107\u2107"
        + "\u210a\u2113"
        + "\u2115\u2115"
        + "\u2118\u211d"
        + "\u2124\u2124"
        + "\u2126\u2126"
        + "\u2128\u2128"
        + "\u212a\u2139"
        + "\u213c\u213f"
        + "\u2145\u2149"
        + "\u214e\u214e"
        + "\u2160\u2188"
        + "\u2c00\u2c2e"
        + "\u2c30\u2c5e"
        + "\u2c60\u2ce4"
        + "\u2ceb\u2cf3"
        + "\u2d00\u2d25"
        + "\u2d27\u2d27"
        + "\u2d2d\u2d2d"
        + "\u2d30\u2d67"
        + "\u2d6f\u2d6f"
        + "\u2d7f\u2d96"
        + "\u2da0\u2da6"
        + "\u2da8\u2dae"
        + "\u2db0\u2db6"
        + "\u2db8\u2dbe"
        + "\u2dc0\u2dc6"
        + "\u2dc8\u2dce"
        + "\u2dd0\u2dd6"
        + "\u2dd8\u2dde"
        + "\u2de0\u2dff"
        + "\u3005\u3007"
        + "\u3021\u302f"
        + "\u3031\u3035"
        + "\u3038\u303c"
        + "\u3041\u3096"
        + "\u3099\u309a"
        + "\u309d\u309f"
        + "\u30a1\u30fa"
        + "\u30fc\u30ff"
        + "\u3105\u312d"
        + "\u3131\u318e"
        + "\u31a0\u31ba"
        + "\u31f0\u31ff"
        + "\u3400\u4db5"
        + "\u4e00\u9fcc"
        + "\ua000\ua48c"
        + "\ua4d0\ua4fd"
        + "\ua500\ua60c"
        + "\ua610\ua62b"
        + "\ua640\ua66f"
        + "\ua674\ua67d"
        + "\ua67f\ua69d"
        + "\ua69f\ua6f1"
        + "\ua717\ua71f"
        + "\ua722\ua788"
        + "\ua78b\ua78e"
        + "\ua790\ua7ad"
        + "\ua7b0\ua7b1"
        + "\ua7f7\ua827"
        + "\ua840\ua873"
        + "\ua880\ua8c4"
        + "\ua8d0\ua8d9"
        + "\ua8e0\ua8f7"
        + "\ua8fb\ua8fb"
        + "\ua900\ua92d"
        + "\ua930\ua953"
        + "\ua960\ua97c"
        + "\ua980\ua9c0"
        + "\ua9cf\ua9d9"
        + "\ua9e0\ua9fe"
        + "\uaa00\uaa36"
        + "\uaa40\uaa4d"
        + "\uaa50\uaa59"
        + "\uaa60\uaa76"
        + "\uaa7a\uaac2"
        + "\uaadb\uaadd"
        + "\uaae0\uaaef"
        + "\uaaf2\uaaf6"
        + "\uab01\uab06"
        + "\uab09\uab0e"
        + "\uab11\uab16"
        + "\uab20\uab26"
        + "\uab28\uab2e"
        + "\uab30\uab5a"
        + "\uab5c\uab5f"
        + "\uab64\uab65"
        + "\uabc0\uabea"
        + "\uabec\uabed"
        + "\uabf0\uabf9"
        + "\uac00\ud7a3"
        + "\ud7b0\ud7c6"
        + "\ud7cb\ud7fb"
        + "\uf900\ufa6d"
        + "\ufa70\ufad9"
        + "\ufb00\ufb06"
        + "\ufb13\ufb17"
        + "\ufb1d\ufb28"
        + "\ufb2a\ufb36"
        + "\ufb38\ufb3c"
        + "\ufb3e\ufb3e"
        + "\ufb40\ufb41"
        + "\ufb43\ufb44"
        + "\ufb46\ufbb1"
        + "\ufbd3\ufc5d"
        + "\ufc64\ufd3d"
        + "\ufd50\ufd8f"
        + "\ufd92\ufdc7"
        + "\ufdf0\ufdf9"
        + "\ufe00\ufe0f"
        + "\ufe20\ufe2d"
        + "\ufe33\ufe34"
        + "\ufe4d\ufe4f"
        + "\ufe71\ufe71"
        + "\ufe73\ufe73"
        + "\ufe77\ufe77"
        + "\ufe79\ufe79"
        + "\ufe7b\ufe7b"
        + "\ufe7d\ufe7d"
        + "\ufe7f\ufefc"
        + "\uff10\uff19"
        + "\uff21\uff3a"
        + "\uff3f\uff3f"
        + "\uff41\uff5a"
        + "\uff66\uffbe"
        + "\uffc2\uffc7"
        + "\uffca\uffcf"
        + "\uffd2\uffd7"
        + "\uffda\uffdc"
        + "\ud800\udc00\ud800\udc0b"
        + "\ud800\udc0d\ud800\udc26"
        + "\ud800\udc28\ud800\udc3a"
        + "\ud800\udc3c\ud800\udc3d"
        + "\ud800\udc3f\ud800\udc4d"
        + "\ud800\udc50\ud800\udc5d"
        + "\ud800\udc80\ud800\udcfa"
        + "\ud800\udd40\ud800\udd74"
        + "\ud800\uddfd\ud800\uddfd"
        + "\ud800\ude80\ud800\ude9c"
        + "\ud800\udea0\ud800\uded0"
        + "\ud800\udee0\ud800\udee0"
        + "\ud800\udf00\ud800\udf1f"
        + "\ud800\udf30\ud800\udf4a"
        + "\ud800\udf50\ud800\udf7a"
        + "\ud800\udf80\ud800\udf9d"
        + "\ud800\udfa0\ud800\udfc3"
        + "\ud800\udfc8\ud800\udfcf"
        + "\ud800\udfd1\ud800\udfd5"
        + "\ud801\udc00\ud801\udc9d"
        + "\ud801\udca0\ud801\udca9"
        + "\ud801\udd00\ud801\udd27"
        + "\ud801\udd30\ud801\udd63"
        + "\ud801\ude00\ud801\udf36"
        + "\ud801\udf40\ud801\udf55"
        + "\ud801\udf60\ud801\udf67"
        + "\ud802\udc00\ud802\udc05"
        + "\ud802\udc08\ud802\udc08"
        + "\ud802\udc0a\ud802\udc35"
        + "\ud802\udc37\ud802\udc38"
        + "\ud802\udc3c\ud802\udc3c"
        + "\ud802\udc3f\ud802\udc55"
        + "\ud802\udc60\ud802\udc76"
        + "\ud802\udc80\ud802\udc9e"
        + "\ud802\udd00\ud802\udd15"
        + "\ud802\udd20\ud802\udd39"
        + "\ud802\udd80\ud802\uddb7"
        + "\ud802\uddbe\ud802\uddbf"
        + "\ud802\ude00\ud802\ude03"
        + "\ud802\ude05\ud802\ude06"
        + "\ud802\ude0c\ud802\ude13"
        + "\ud802\ude15\ud802\ude17"
        + "\ud802\ude19\ud802\ude33"
        + "\ud802\ude38\ud802\ude3a"
        + "\ud802\ude3f\ud802\ude3f"
        + "\ud802\ude60\ud802\ude7c"
        + "\ud802\ude80\ud802\ude9c"
        + "\ud802\udec0\ud802\udec7"
        + "\ud802\udec9\ud802\udee6"
        + "\ud802\udf00\ud802\udf35"
        + "\ud802\udf40\ud802\udf55"
        + "\ud802\udf60\ud802\udf72"
        + "\ud802\udf80\ud802\udf91"
        + "\ud803\udc00\ud803\udc48"
        + "\ud804\udc00\ud804\udc46"
        + "\ud804\udc66\ud804\udc6f"
        + "\ud804\udc7f\ud804\udcba"
        + "\ud804\udcd0\ud804\udce8"
        + "\ud804\udcf0\ud804\udcf9"
        + "\ud804\udd00\ud804\udd34"
        + "\ud804\udd36\ud804\udd3f"
        + "\ud804\udd50\ud804\udd73"
        + "\ud804\udd76\ud804\udd76"
        + "\ud804\udd80\ud804\uddc4"
        + "\ud804\uddd0\ud804\uddda"
        + "\ud804\ude00\ud804\ude11"
        + "\ud804\ude13\ud804\ude37"
        + "\ud804\udeb0\ud804\udeea"
        + "\ud804\udef0\ud804\udef9"
        + "\ud804\udf01\ud804\udf03"
        + "\ud804\udf05\ud804\udf0c"
        + "\ud804\udf0f\ud804\udf10"
        + "\ud804\udf13\ud804\udf28"
        + "\ud804\udf2a\ud804\udf30"
        + "\ud804\udf32\ud804\udf33"
        + "\ud804\udf35\ud804\udf39"
        + "\ud804\udf3c\ud804\udf44"
        + "\ud804\udf47\ud804\udf48"
        + "\ud804\udf4b\ud804\udf4d"
        + "\ud804\udf57\ud804\udf57"
        + "\ud804\udf5d\ud804\udf63"
        + "\ud804\udf66\ud804\udf6c"
        + "\ud804\udf70\ud804\udf74"
        + "\ud805\udc80\ud805\udcc5"
        + "\ud805\udcc7\ud805\udcc7"
        + "\ud805\udcd0\ud805\udcd9"
        + "\ud805\udd80\ud805\uddb5"
        + "\ud805\uddb8\ud805\uddc0"
        + "\ud805\ude00\ud805\ude40"
        + "\ud805\ude44\ud805\ude44"
        + "\ud805\ude50\ud805\ude59"
        + "\ud805\ude80\ud805\udeb7"
        + "\ud805\udec0\ud805\udec9"
        + "\ud806\udca0\ud806\udce9"
        + "\ud806\udcff\ud806\udcff"
        + "\ud806\udec0\ud806\udef8"
        + "\ud808\udc00\ud808\udf98"
        + "\ud809\udc00\ud809\udc6e"
        + "\ud80c\udc00\ud80d\udc2e"
        + "\ud81a\udc00\ud81a\ude38"
        + "\ud81a\ude40\ud81a\ude5e"
        + "\ud81a\ude60\ud81a\ude69"
        + "\ud81a\uded0\ud81a\udeed"
        + "\ud81a\udef0\ud81a\udef4"
        + "\ud81a\udf00\ud81a\udf36"
        + "\ud81a\udf40\ud81a\udf43"
        + "\ud81a\udf50\ud81a\udf59"
        + "\ud81a\udf63\ud81a\udf77"
        + "\ud81a\udf7d\ud81a\udf8f"
        + "\ud81b\udf00\ud81b\udf44"
        + "\ud81b\udf50\ud81b\udf7e"
        + "\ud81b\udf8f\ud81b\udf9f"
        + "\ud82c\udc00\ud82c\udc01"
        + "\ud82f\udc00\ud82f\udc6a"
        + "\ud82f\udc70\ud82f\udc7c"
        + "\ud82f\udc80\ud82f\udc88"
        + "\ud82f\udc90\ud82f\udc99"
        + "\ud82f\udc9d\ud82f\udc9e"
        + "\ud834\udd65\ud834\udd69"
        + "\ud834\udd6d\ud834\udd72"
        + "\ud834\udd7b\ud834\udd82"
        + "\ud834\udd85\ud834\udd8b"
        + "\ud834\uddaa\ud834\uddad"
        + "\ud834\ude42\ud834\ude44"
        + "\ud835\udc00\ud835\udc54"
        + "\ud835\udc56\ud835\udc9c"
        + "\ud835\udc9e\ud835\udc9f"
        + "\ud835\udca2\ud835\udca2"
        + "\ud835\udca5\ud835\udca6"
        + "\ud835\udca9\ud835\udcac"
        + "\ud835\udcae\ud835\udcb9"
        + "\ud835\udcbb\ud835\udcbb"
        + "\ud835\udcbd\ud835\udcc3"
        + "\ud835\udcc5\ud835\udd05"
        + "\ud835\udd07\ud835\udd0a"
        + "\ud835\udd0d\ud835\udd14"
        + "\ud835\udd16\ud835\udd1c"
        + "\ud835\udd1e\ud835\udd39"
        + "\ud835\udd3b\ud835\udd3e"
        + "\ud835\udd40\ud835\udd44"
        + "\ud835\udd46\ud835\udd46"
        + "\ud835\udd4a\ud835\udd50"
        + "\ud835\udd52\ud835\udea5"
        + "\ud835\udea8\ud835\udec0"
        + "\ud835\udec2\ud835\udeda"
        + "\ud835\udedc\ud835\udefa"
        + "\ud835\udefc\ud835\udf14"
        + "\ud835\udf16\ud835\udf34"
        + "\ud835\udf36\ud835\udf4e"
        + "\ud835\udf50\ud835\udf6e"
        + "\ud835\udf70\ud835\udf88"
        + "\ud835\udf8a\ud835\udfa8"
        + "\ud835\udfaa\ud835\udfc2"
        + "\ud835\udfc4\ud835\udfcb"
        + "\ud835\udfce\ud835\udfff"
        + "\ud83a\udc00\ud83a\udcc4"
        + "\ud83a\udcd0\ud83a\udcd6"
        + "\ud83b\ude00\ud83b\ude03"
        + "\ud83b\ude05\ud83b\ude1f"
        + "\ud83b\ude21\ud83b\ude22"
        + "\ud83b\ude24\ud83b\ude24"
        + "\ud83b\ude27\ud83b\ude27"
        + "\ud83b\ude29\ud83b\ude32"
        + "\ud83b\ude34\ud83b\ude37"
        + "\ud83b\ude39\ud83b\ude39"
        + "\ud83b\ude3b\ud83b\ude3b"
        + "\ud83b\ude42\ud83b\ude42"
        + "\ud83b\ude47\ud83b\ude47"
        + "\ud83b\ude49\ud83b\ude49"
        + "\ud83b\ude4b\ud83b\ude4b"
        + "\ud83b\ude4d\ud83