//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-audio-types")]
use objc2_core_audio_types::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarerunloopmode?language=objc)
pub const kAudioHardwareRunLoopMode: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"com.apple.audio.CoreAudio\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicemastersubdevicekey?language=objc)
pub const kAudioAggregateDeviceMasterSubDeviceKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"master\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyscopeinput?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyScopeInput: AudioObjectPropertyScope = kAudioObjectPropertyScopeInput;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyscopeoutput?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyScopeOutput: AudioObjectPropertyScope =
    kAudioObjectPropertyScopeOutput;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyscopeplaythrough?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyScopePlayThrough: AudioObjectPropertyScope =
    kAudioObjectPropertyScopePlayThrough;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiopropertywildcardpropertyid?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioPropertyWildcardPropertyID: AudioObjectPropertySelector =
    kAudioObjectPropertySelectorWildcard;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiopropertywildcardsection?language=objc)
pub const kAudioPropertyWildcardSection: c_uchar = 0xFF;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiopropertywildcardchannel?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioPropertyWildcardChannel: AudioObjectPropertyElement =
    kAudioObjectPropertyElementWildcard;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioisubownercontrolclassid?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioISubOwnerControlClassID: AudioClassID = 0x61746368;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiolevelcontrolpropertydecibelstoscalartransferfunction?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioLevelControlPropertyDecibelsToScalarTransferFunction: AudioObjectPropertySelector =
    0x6c637466;

/// The following constants are the only supported values for a volume control's
/// transfer function.
///
/// The transfer function implemented in the volume control works by raising the
/// scalar value to an exponent to map it into the decibel range. The constants
/// in this enum express the exponent used in the name as a quotient. For example,
/// kAudioLevelControlTranferFunction3Over4 represents the exponent 0.75.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiolevelcontroltransferfunction?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioLevelControlTransferFunction(pub u32);
impl AudioLevelControlTransferFunction {
    #[doc(alias = "kAudioLevelControlTranferFunctionLinear")]
    pub const TranferFunctionLinear: Self = Self(0);
    #[doc(alias = "kAudioLevelControlTranferFunction1Over3")]
    pub const TranferFunction1Over3: Self = Self(1);
    #[doc(alias = "kAudioLevelControlTranferFunction1Over2")]
    pub const TranferFunction1Over2: Self = Self(2);
    #[doc(alias = "kAudioLevelControlTranferFunction3Over4")]
    pub const TranferFunction3Over4: Self = Self(3);
    #[doc(alias = "kAudioLevelControlTranferFunction3Over2")]
    pub const TranferFunction3Over2: Self = Self(4);
    #[doc(alias = "kAudioLevelControlTranferFunction2Over1")]
    pub const TranferFunction2Over1: Self = Self(5);
    #[doc(alias = "kAudioLevelControlTranferFunction3Over1")]
    pub const TranferFunction3Over1: Self = Self(6);
    #[doc(alias = "kAudioLevelControlTranferFunction4Over1")]
    pub const TranferFunction4Over1: Self = Self(7);
    #[doc(alias = "kAudioLevelControlTranferFunction5Over1")]
    pub const TranferFunction5Over1: Self = Self(8);
    #[doc(alias = "kAudioLevelControlTranferFunction6Over1")]
    pub const TranferFunction6Over1: Self = Self(9);
    #[doc(alias = "kAudioLevelControlTranferFunction7Over1")]
    pub const TranferFunction7Over1: Self = Self(10);
    #[doc(alias = "kAudioLevelControlTranferFunction8Over1")]
    pub const TranferFunction8Over1: Self = Self(11);
    #[doc(alias = "kAudioLevelControlTranferFunction9Over1")]
    pub const TranferFunction9Over1: Self = Self(12);
    #[doc(alias = "kAudioLevelControlTranferFunction10Over1")]
    pub const TranferFunction10Over1: Self = Self(13);
    #[doc(alias = "kAudioLevelControlTranferFunction11Over1")]
    pub const TranferFunction11Over1: Self = Self(14);
    #[doc(alias = "kAudioLevelControlTranferFunction12Over1")]
    pub const TranferFunction12Over1: Self = Self(15);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioLevelControlTransferFunction {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioLevelControlTransferFunction {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// An AudioHardwarePropertyID is a integer that identifies a specific piece of
/// information about the AudioSystemObject.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiohardwarepropertyid?language=objc)
#[cfg(feature = "AudioHardware")]
pub type AudioHardwarePropertyID = AudioObjectPropertySelector;

/// Clients register an AudioHardwarePropertyListenerProc with the AudioSystemObject
/// in order to receive notifications when the properties of the object change.
///
/// Note that the same functionality is provided by AudioObjectPropertyListenerProc.
///
/// Parameter `inPropertyID`: The AudioHardwarePropertyID of the property that changed.
///
/// Parameter `inClientData`: A pointer to client data established when the listener proc was registered
/// with the AudioSystemObject.
///
/// Returns: The return value is currently unused and should always be 0.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiohardwarepropertylistenerproc?language=objc)
#[cfg(feature = "AudioHardware")]
pub type AudioHardwarePropertyListenerProc =
    Option<unsafe extern "C-unwind" fn(AudioHardwarePropertyID, *mut c_void) -> OSStatus>;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyrunloop?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioHardwarePropertyRunLoop: AudioObjectPropertySelector = 0x726e6c70;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertydeviceforuid?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioHardwarePropertyDeviceForUID: AudioObjectPropertySelector = 0x64756964;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertypluginforbundleid?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioHardwarePropertyPlugInForBundleID: AudioObjectPropertySelector = 0x70696269;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyprocessismaster?language=objc)
#[cfg(feature = "AudioHardware")]
#[deprecated]
pub const kAudioHardwarePropertyProcessIsMaster: AudioObjectPropertySelector = 0x6d617374;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertybootchimevolumescalar?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioHardwarePropertyBootChimeVolumeScalar: AudioObjectPropertySelector = 0x62627673;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertybootchimevolumedecibels?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioHardwarePropertyBootChimeVolumeDecibels: AudioObjectPropertySelector = 0x62627664;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertybootchimevolumerangedecibels?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioHardwarePropertyBootChimeVolumeRangeDecibels: AudioObjectPropertySelector =
    0x62626423;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertybootchimevolumescalartodecibels?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioHardwarePropertyBootChimeVolumeScalarToDecibels: AudioObjectPropertySelector =
    0x62763264;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertybootchimevolumedecibelstoscalar?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioHardwarePropertyBootChimeVolumeDecibelsToScalar: AudioObjectPropertySelector =
    0x62643276;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertybootchimevolumedecibelstoscalartransferfunction?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioHardwarePropertyBootChimeVolumeDecibelsToScalarTransferFunction:
    AudioObjectPropertySelector = 0x62767466;

extern "C-unwind" {
    /// Add the given CFRunLoopSource to the the HAL's notification CFRunLoop.
    ///
    /// The CFRunLoop the HAL uses for notifications is specified by
    /// kAudioHardwarePropertyRunLoop. If kAudioHardwarePropertyRunLoop changes,
    /// CFRunLoopSources added with this function will automatically be transferred to
    /// the new CFRunLoop.
    /// Usage of the HAL's notification run loop is deprecated. Please use libdispatch
    /// instead.
    ///
    /// Parameter `inRunLoopSource`: The CFRunLoopSource to add.
    ///
    /// Returns: An OSStatus indicating success or failure.
    #[deprecated]
    pub fn AudioHardwareAddRunLoopSource(in_run_loop_source: &CFRunLoopSource) -> OSStatus;
}

extern "C-unwind" {
    /// Remove the given CFRunLoopSource from the the HAL's notification CFRunLoop.
    ///
    /// The CFRunLoop the HAL uses for notifications is specified by
    /// kAudioHardwarePropertyRunLoop.
    /// Usage of the HAL's notification run loop is deprecated. Please use libdispatch
    /// instead.
    ///
    /// Parameter `inRunLoopSource`: The CFRunLoopSource to remove.
    ///
    /// Returns: An OSStatus indicating success or failure.
    #[deprecated]
    pub fn AudioHardwareRemoveRunLoopSource(in_run_loop_source: &CFRunLoopSource) -> OSStatus;
}

extern "C-unwind" {
    /// Retrieve information about the given property.
    ///
    /// Note that the same functionality is provided by the functions
    /// AudioObjectHasProperty(), AudioObjectIsPropertySettable(), and
    /// AudioObjectGetPropertyDataSize().
    ///
    /// Parameter `inPropertyID`: The AudioHardwarePropertyID of the property to query.
    ///
    /// Parameter `outSize`: A pointer to a UInt32 that receives the size of the property data in bytes
    /// on exit. This can be NULL if the size information is not being requested.
    ///
    /// Parameter `outWritable`: A pointer to a Boolean that receives indication of whether or not the given
    /// property can be set. This can be NULL if the writability is not being
    /// requested.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `out_size` must be a valid pointer or null.
    /// - `out_writable` must be a valid pointer or null.
    #[cfg(feature = "AudioHardware")]
    #[deprecated]
    pub fn AudioHardwareGetPropertyInfo(
        in_property_id: AudioHardwarePropertyID,
        out_size: *mut u32,
        out_writable: *mut Boolean,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Queries an the AudioSystemObject to get the data of the given property and
    /// places it in the provided buffer.
    ///
    /// Note that the same functionality is provided by the function
    /// AudioObjectGetPropertyData().
    ///
    /// Parameter `inPropertyID`: The AudioHardwarePropertyID of the property to query.
    ///
    /// Parameter `ioPropertyDataSize`: A UInt32 which on entry indicates the size of the buffer pointed to by
    /// outData and on exit indicates how much of the buffer was used.
    ///
    /// Parameter `outPropertyData`: The buffer into which the AudioSystemObject will put the data for the given
    /// property.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `io_property_data_size` must be a valid pointer.
    /// - `out_property_data` must be a valid pointer.
    #[cfg(feature = "AudioHardware")]
    #[deprecated]
    pub fn AudioHardwareGetProperty(
        in_property_id: AudioHardwarePropertyID,
        io_property_data_size: NonNull<u32>,
        out_property_data: NonNull<c_void>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Tells the AudioSystemObject to change the value of the given property using the
    /// provided data.
    ///
    /// Note that the value of the property should not be considered changed until the
    /// HAL has called the listeners as many properties values are changed
    /// asynchronously. Also note that the same functionality is provided by the
    /// function AudioObjectGetPropertyData().
    ///
    /// Parameter `inPropertyID`: The AudioHardwarePropertyID of the property to change.
    ///
    /// Parameter `inPropertyDataSize`: A UInt32 indicating the size of the buffer pointed to by inData.
    ///
    /// Parameter `inPropertyData`: The buffer containing the data to be used to change the property's value.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// `in_property_data` must be a valid pointer.
    #[cfg(feature = "AudioHardware")]
    #[deprecated]
    pub fn AudioHardwareSetProperty(
        in_property_id: AudioHardwarePropertyID,
        in_property_data_size: u32,
        in_property_data: NonNull<c_void>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Registers the given AudioHardwarePropertyListenerProc to receive notifications
    /// when the given property changes.
    ///
    /// Note that the same functionality is provided by AudioObjectAddPropertyListener
    /// in conjunction with AudioObjectPropertyListenerProc.
    ///
    /// Parameter `inPropertyID`: The AudioHardwarePropertyID of the property to listen to.
    ///
    /// Parameter `inProc`: AudioHardwarePropertyListenerProc to call.
    ///
    /// Parameter `inClientData`: A pointer to client data that is passed to the listener when it is called.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_proc` must be implemented correctly.
    /// - `in_client_data` must be a valid pointer or null.
    #[cfg(feature = "AudioHardware")]
    #[deprecated]
    pub fn AudioHardwareAddPropertyListener(
        in_property_id: AudioHardwarePropertyID,
        in_proc: AudioHardwarePropertyListenerProc,
        in_client_data: *mut c_void,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Unregisters the given AudioHardwarePropertyListenerProc from receive
    /// notifications when the given property changes.
    ///
    /// Note that the same functionality is provided by
    /// AudioObjectRemovePropertyListener in conjunction with
    /// AudioObjectPropertyListenerProc.
    ///
    /// Parameter `inPropertyID`: The AudioHardwarePropertyID of the property to stop listening to.
    ///
    /// Parameter `inProc`: AudioHardwarePropertyListenerProc to unregister.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// `in_proc` must be implemented correctly.
    #[cfg(feature = "AudioHardware")]
    #[deprecated]
    pub fn AudioHardwareRemovePropertyListener(
        in_property_id: AudioHardwarePropertyID,
        in_proc: AudioHardwarePropertyListenerProc,
    ) -> OSStatus;
}

/// AudioDevice is the base class for all objects that represent an audio device.
///
/// AudioDevice is a subclass of AudioObject. AudioDevices normally contain
/// AudioStreams and AudioControls, but may contain other things depending on the
/// kind of AudioDevice (e.g. aggregate devices contain other AudioDevices).
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiodeviceid?language=objc)
#[cfg(feature = "AudioHardware")]
pub type AudioDeviceID = AudioObjectID;

/// An AudioDevicePropertyID is an integer that identifies a specific piece of
/// information about the object.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiodevicepropertyid?language=objc)
#[cfg(feature = "AudioHardware")]
pub type AudioDevicePropertyID = AudioObjectPropertySelector;

/// Clients register an AudioDevicePropertyListenerProc with the AudioDevice object
/// in order to receive notifications when the properties of the object change.
///
/// Note that the same functionality is provided by AudioObjectPropertyListenerProc.
///
/// Parameter `inDevice`: The AudioDevice whose property has changed.
///
/// Parameter `inChannel`: The channel of the property that changed where 0 is the main channel.
///
/// Parameter `isInput`: Which section of the AudioDevice changed.
///
/// Parameter `inPropertyID`: The AudioDevicePropertyID of the property that changed.
///
/// Parameter `inClientData`: A pointer to client data established when the listener proc was registered
/// with the object.
///
/// Returns: The return value is currently unused and should always be 0.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiodevicepropertylistenerproc?language=objc)
#[cfg(feature = "AudioHardware")]
pub type AudioDevicePropertyListenerProc = Option<
    unsafe extern "C-unwind" fn(
        AudioDeviceID,
        u32,
        Boolean,
        AudioDevicePropertyID,
        *mut c_void,
    ) -> OSStatus,
>;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodeviceunknown?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDeviceUnknown: AudioObjectID = kAudioObjectUnknown;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypeautoaggregate?language=objc)
pub const kAudioDeviceTransportTypeAutoAggregate: u32 = 0x66677270;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyvolumedecibelstoscalartransferfunction?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyVolumeDecibelsToScalarTransferFunction: AudioObjectPropertySelector =
    0x76637466;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythruvolumedecibelstoscalartransferfunction?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyPlayThruVolumeDecibelsToScalarTransferFunction:
    AudioObjectPropertySelector = 0x6d767466;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydrivershouldownisub?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyDriverShouldOwniSub: AudioObjectPropertySelector = 0x69737562;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertysubvolumedecibelstoscalartransferfunction?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertySubVolumeDecibelsToScalarTransferFunction:
    AudioObjectPropertySelector = 0x73767466;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydevicename?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyDeviceName: AudioObjectPropertySelector = 0x6e616d65;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydevicenamecfstring?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyDeviceNameCFString: AudioObjectPropertySelector =
    kAudioObjectPropertyName;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydevicemanufacturer?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyDeviceManufacturer: AudioObjectPropertySelector = 0x6d616b72;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydevicemanufacturercfstring?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyDeviceManufacturerCFString: AudioObjectPropertySelector =
    kAudioObjectPropertyManufacturer;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyregisterbufferlist?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyRegisterBufferList: AudioObjectPropertySelector = 0x72627566;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertybuffersize?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyBufferSize: AudioObjectPropertySelector = 0x6273697a;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertybuffersizerange?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyBufferSizeRange: AudioObjectPropertySelector = 0x62737a23;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertychannelname?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyChannelName: AudioObjectPropertySelector = 0x63686e6d;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertychannelnamecfstring?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyChannelNameCFString: AudioObjectPropertySelector =
    kAudioObjectPropertyElementName;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertychannelcategoryname?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyChannelCategoryName: AudioObjectPropertySelector = 0x63636e6d;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertychannelcategorynamecfstring?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyChannelCategoryNameCFString: AudioObjectPropertySelector =
    kAudioObjectPropertyElementCategoryName;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertychannelnumbername?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyChannelNumberName: AudioObjectPropertySelector = 0x636e6e6d;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertychannelnumbernamecfstring?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyChannelNumberNameCFString: AudioObjectPropertySelector =
    kAudioObjectPropertyElementNumberName;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertysupportsmixing?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertySupportsMixing: AudioObjectPropertySelector = 0x6d69783f;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertystreamformat?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyStreamFormat: AudioObjectPropertySelector = 0x73666d74;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertystreamformats?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyStreamFormats: AudioObjectPropertySelector = 0x73666d23;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertystreamformatsupported?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyStreamFormatSupported: AudioObjectPropertySelector = 0x73666d3f;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertystreamformatmatch?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyStreamFormatMatch: AudioObjectPropertySelector = 0x73666d6d;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydatasourcenameforid?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyDataSourceNameForID: AudioObjectPropertySelector = 0x7373636e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyclocksourcenameforid?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyClockSourceNameForID: AudioObjectPropertySelector = 0x6373636e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythrudestinationnameforid?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyPlayThruDestinationNameForID: AudioObjectPropertySelector =
    0x6d64646e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertychannelnominallinelevelnameforid?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyChannelNominalLineLevelNameForID: AudioObjectPropertySelector =
    0x636e6c76;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyhighpassfiltersettingnameforid?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioDevicePropertyHighPassFilterSettingNameForID: AudioObjectPropertySelector =
    0x63686970;

extern "C-unwind" {
    /// Registers the given AudioDeviceIOProc with the AudioDevice.
    ///
    /// A client may have multiple IOProcs for a given device, but the device is free to
    /// only accept as many as it can handle. Note that it is not recommended for
    /// clients to have more than a single IOProc registered at a time as this can be
    /// wasteful of system resources. Rather, it is recommended that the client do any
    /// necessary mixing itself so that only one IOProc is necessary.
    /// This routine has been deprecated in favor of AudioDeviceCreateIOProcID().
    ///
    /// Parameter `inDevice`: The AudioDevice to register the IOProc with.
    ///
    /// Parameter `inProc`: The AudioDeviceIOProc to register.
    ///
    /// Parameter `inClientData`: A pointer to client data that is passed back to the IOProc when it is
    /// called.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_proc` must be implemented correctly.
    /// - `in_client_data` must be a valid pointer or null.
    #[cfg(all(feature = "AudioHardware", feature = "objc2-core-audio-types"))]
    #[deprecated]
    pub fn AudioDeviceAddIOProc(
        in_device: AudioDeviceID,
        in_proc: AudioDeviceIOProc,
        in_client_data: *mut c_void,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Unregisters the given AudioDeviceIOProc from the AudioDevice.
    /// This routine has been deprecated in favor of AudioDeviceDestroyIOProcID().
    ///
    /// Parameter `inDevice`: The AudioDevice to unregister the IOProc from.
    ///
    /// Parameter `inProc`: The AudioDeviceIOProc to unregister.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// `in_proc` must be implemented correctly.
    #[cfg(all(feature = "AudioHardware", feature = "objc2-core-audio-types"))]
    #[deprecated]
    pub fn AudioDeviceRemoveIOProc(
        in_device: AudioDeviceID,
        in_proc: AudioDeviceIOProc,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Read some data from an AudioDevice starting at the given time.
    ///
    /// With the advent of aggregate devices, the need for AudioDeviceRead has gone
    /// away. Consequently, this function is now deprecated.
    ///
    /// Parameter `inDevice`: The AudioDevice to read from.
    ///
    /// Parameter `inStartTime`: An AudioTimeStamp indicating the time from which to read the data. In
    /// general, the valid range of time (in frames) is from the current time minus
    /// the maximum IO buffer size to the current time minus the safety offset.
    ///
    /// Parameter `outData`: An AudioBufferList that must be the same size and shape as that returned by
    /// kAudioDevicePropertyStreamConfiguration. Further, the AudioBufferList must
    /// have been previously registered with the device via
    /// kAudioDevicePropertyRegisterBufferList. On exit, the mDataSize fields will
    /// be updated with the amount of data read.
    ///
    /// Returns: An OSStatus indicating success or failure.
    /// kAudioHardwareUnsupportedOperationError will be returned if the AudioDevice does
    /// not support direct reading.
    ///
    /// # Safety
    ///
    /// - `in_start_time` must be a valid pointer.
    /// - `out_data` must be a valid pointer.
    #[cfg(all(feature = "AudioHardware", feature = "objc2-core-audio-types"))]
    #[deprecated]
    pub fn AudioDeviceRead(
        in_device: AudioDeviceID,
        in_start_time: NonNull<AudioTimeStamp>,
        out_data: NonNull<AudioBufferList>,
    ) -> OSStatus;
}

/// Retrieve information about the given property of an AudioDevice.
///
/// Note that the same functionality is provided by the functions
/// AudioObjectHasProperty(), AudioObjectIsPropertySettable(), and
/// AudioObjectGetPropertyDataSize().
///
/// Parameter `inDevice`: The AudioDevice to query.
///
/// Parameter `inChannel`: The channel of the property to query where 0 is the main channel.
///
/// Parameter `isInput`: Which section of the AudioDevice to query.
///
/// Parameter `inPropertyID`: The AudioDevicePropertyID of the property to query.
///
/// Parameter `outSize`: A pointer to a UInt32 that receives the size of the property data in bytes
/// on exit. This can be NULL if the size information is not being requested.
///
/// Parameter `outWritable`: A pointer to a Boolean that receives indication of whether or not the given
/// property can be set. This can be NULL if the writability is not being
/// requested.
///
/// Returns: An OSStatus indicating success or failure.
///
/// # Safety
///
/// - `out_size` must be a valid pointer or null.
/// - `out_writable` must be a valid pointer or null.
#[cfg(feature = "AudioHardware")]
#[deprecated]
#[inline]
pub unsafe extern "C-unwind" fn AudioDeviceGetPropertyInfo(
    in_device: AudioDeviceID,
    in_channel: u32,
    is_input: bool,
    in_property_id: AudioDevicePropertyID,
    out_size: *mut u32,
    out_writable: *mut Boolean,
) -> OSStatus {
    extern "C-unwind" {
        fn AudioDeviceGetPropertyInfo(
            in_device: AudioDeviceID,
            in_channel: u32,
            is_input: Boolean,
            in_property_id: AudioDevicePropertyID,
            out_size: *mut u32,
            out_writable: *mut Boolean,
        ) -> OSStatus;
    }
    unsafe {
        AudioDeviceGetPropertyInfo(
            in_device,
            in_channel,
            is_input as _,
            in_property_id,
            out_size,
            out_writable,
        )
    }
}

/// Queries an the AudioDevice object to get the data of the given property and
/// places it in the provided buffer.
///
/// Note that the same functionality is provided by the function
/// AudioObjectGetPropertyData().
///
/// Parameter `inDevice`: The AudioDevice to query.
///
/// Parameter `inChannel`: The channel of the property to query where 0 is the main channel.
///
/// Parameter `isInput`: Which section of the AudioDevice to query.
///
/// Parameter `inPropertyID`: The AudioDevicePropertyID of the property to query.
///
/// Parameter `ioPropertyDataSize`: A UInt32 which on entry indicates the size of the buffer pointed to by
/// outData and on exit indicates how much of the buffer was used.
///
/// Parameter `outPropertyData`: The buffer into which the object will put the data for the given property.
///
/// Returns: An OSStatus indicating success or failure.
///
/// # Safety
///
/// - `io_property_data_size` must be a valid pointer.
/// - `out_property_data` must be a valid pointer.
#[cfg(feature = "AudioHardware")]
#[deprecated]
#[inline]
pub unsafe extern "C-unwind" fn AudioDeviceGetProperty(
    in_device: AudioDeviceID,
    in_channel: u32,
    is_input: bool,
    in_property_id: AudioDevicePropertyID,
    io_property_data_size: NonNull<u32>,
    out_property_data: NonNull<c_void>,
) -> OSStatus {
    extern "C-unwind" {
        fn AudioDeviceGetProperty(
            in_device: AudioDeviceID,
            in_channel: u32,
            is_input: Boolean,
            in_property_id: AudioDevicePropertyID,
            io_property_data_size: NonNull<u32>,
            out_property_data: NonNull<c_void>,
        ) -> OSStatus;
    }
    unsafe {
        AudioDeviceGetProperty(
            in_device,
            in_channel,
            is_input as _,
            in_property_id,
            io_property_data_size,
            out_property_data,
        )
    }
}

/// Tells the AudioDevice object to change the value of the given property using the
/// provided data.
///
/// Note that the value of the property should not be considered changed until the
/// HAL has called the listeners as many properties values are changed
/// asynchronously. Also note that the same functionality is provided by the
/// function AudioObjectSetPropertyData().
///
/// Parameter `inDevice`: The AudioDevice to change.
///
/// Parameter `inWhen`: A pointer to an AudioTimeStamp that says when to change the property's value
/// relative to the device's time base. NULL means execute the change
/// immediately.
///
/// Parameter `inChannel`: The channel of the property to change where 0 is the main channel.
///
/// Parameter `isInput`: Which section of the AudioDevice to change.
///
/// Parameter `inPropertyID`: The AudioDevicePropertyID of the property to change.
///
/// Parameter `inPropertyDataSize`: A UInt32 indicating the size of the buffer pointed to by inData.
///
/// Parameter `inPropertyData`: The buffer containing the data to be used to change the property's value.
///
/// Returns: An OSStatus indicating success or failure.
///
/// # Safety
///
/// - `in_when` must be a valid pointer or null.
/// - `in_property_data` must be a valid pointer.
#[cfg(all(feature = "AudioHardware", feature = "objc2-core-audio-types"))]
#[deprecated]
#[inline]
pub unsafe extern "C-unwind" fn AudioDeviceSetProperty(
    in_device: AudioDeviceID,
    in_when: *const AudioTimeStamp,
    in_channel: u32,
    is_input: bool,
    in_property_id: AudioDevicePropertyID,
    in_property_data_size: u32,
    in_property_data: NonNull<c_void>,
) -> OSStatus {
    extern "C-unwind" {
        fn AudioDeviceSetProperty(
            in_device: AudioDeviceID,
            in_when: *const AudioTimeStamp,
            in_channel: u32,
            is_input: Boolean,
            in_property_id: AudioDevicePropertyID,
            in_property_data_size: u32,
            in_property_data: NonNull<c_void>,
        ) -> OSStatus;
    }
    unsafe {
        AudioDeviceSetProperty(
            in_device,
            in_when,
            in_channel,
            is_input as _,
            in_property_id,
            in_property_data_size,
            in_property_data,
        )
    }
}

/// Registers the given AudioDevicePropertyListenerProc to receive notifications
/// when the given property changes.
///
/// Note that the same functionality is provided by AudioObjectAddPropertyListener
/// in conjunction with AudioObjectPropertyListenerProc.
///
/// Parameter `inDevice`: The AudioDevice with whom to register the listener.
///
/// Parameter `inChannel`: The channel of the property to listen to.
///
/// Parameter `isInput`: Which section of the AudioDevice to listen to.
///
/// Parameter `inPropertyID`: The AudioDevicePropertyID of the property to listen to.
///
/// Parameter `inProc`: AudioDevicePropertyListenerProc to call.
///
/// Parameter `inClientData`: A pointer to client data that is passed to the listener when it is called.
///
/// Returns: An OSStatus indicating success or failure.
///
/// # Safety
///
/// - `in_proc` must be implemented correctly.
/// - `in_client_data` must be a valid pointer or null.
#[cfg(feature = "AudioHardware")]
#[deprecated]
#[inline]
pub unsafe extern "C-unwind" fn AudioDeviceAddPropertyListener(
    in_device: AudioDeviceID,
    in_channel: u32,
    is_input: bool,
    in_property_id: AudioDevicePropertyID,
    in_proc: AudioDevicePropertyListenerProc,
    in_client_data: *mut c_void,
) -> OSStatus {
    extern "C-unwind" {
        fn AudioDeviceAddPropertyListener(
            in_device: AudioDeviceID,
            in_channel: u32,
            is_input: Boolean,
            in_property_id: AudioDevicePropertyID,
            in_proc: AudioDevicePropertyListenerProc,
            in_client_data: *mut c_void,
        ) -> OSStatus;
    }
    unsafe {
        AudioDeviceAddPropertyListener(
            in_device,
            in_channel,
            is_input as _,
            in_property_id,
            in_proc,
            in_client_data,
        )
    }
}

/// Unregisters the given AudioDevicePropertyListenerProc from receiving
/// notifications when the given property changes.
///
/// Note that the same functionality is provided by
/// AudioObjectRemovePropertyListener in conjunction with
/// AudioObjectPropertyListenerProc.
///
/// Parameter `inDevice`: The AudioDevice with whom to unregister the listener.
///
/// Parameter `inChannel`: The channel of the property to unregister from.
///
/// Parameter `isInput`: Which section of the AudioDevice to unregister from.
///
/// Parameter `inPropertyID`: The AudioDevicePropertyID of the property to stop listening to.
///
/// Parameter `inProc`: AudioDevicePropertyListenerProc to unregister.
///
/// Returns: An OSStatus indicating success or failure.
///
/// # Safety
///
/// `in_proc` must be implemented correctly.
#[cfg(feature = "AudioHardware")]
#[deprecated]
#[inline]
pub unsafe extern "C-unwind" fn AudioDeviceRemovePropertyListener(
    in_device: AudioDeviceID,
    in_channel: u32,
    is_input: bool,
    in_property_id: AudioDevicePropertyID,
    in_proc: AudioDevicePropertyListenerProc,
) -> OSStatus {
    extern "C-unwind" {
        fn AudioDeviceRemovePropertyListener(
            in_device: AudioDeviceID,
            in_channel: u32,
            is_input: Boolean,
            in_property_id: AudioDevicePropertyID,
            in_proc: AudioDevicePropertyListenerProc,
        ) -> OSStatus;
    }
    unsafe {
        AudioDeviceRemovePropertyListener(
            in_device,
            in_channel,
            is_input as _,
            in_property_id,
            in_proc,
        )
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicepropertymastersubdevice?language=objc)
#[cfg(feature = "AudioHardware")]
#[deprecated]
pub const kAudioAggregateDevicePropertyMasterSubDevice: AudioObjectPropertySelector =
    kAudioAggregateDevicePropertyMainSubDevice;

/// AudioStream is the base class for all objects that represent a stream of data on
/// an audio device.
///
/// AudioStream is a subclass of AudioObject and can contain AudioControls.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiostreamid?language=objc)
#[cfg(feature = "AudioHardware")]
pub type AudioStreamID = AudioObjectID;

/// Clients register an AudioStreamPropertyListenerProc with the AudioStream object
/// in order to receive notifications when the properties of the object change.
///
/// Note that the same functionality is provided by AudioObjectPropertyListenerProc.
///
/// Parameter `inStream`: The AudioStream whose property has changed.
///
/// Parameter `inChannel`: The channel of the property that changed where 0 is the main channel.
///
/// Parameter `inPropertyID`: The AudioDevicePropertyID of the property that changed.
///
/// Parameter `inClientData`: A pointer to client data established when the listener proc was registered
/// with the object.
///
/// Returns: The return value is currently unused and should always be 0.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiostreampropertylistenerproc?language=objc)
#[cfg(feature = "AudioHardware")]
pub type AudioStreamPropertyListenerProc = Option<
    unsafe extern "C-unwind" fn(AudioStreamID, u32, AudioDevicePropertyID, *mut c_void) -> OSStatus,
>;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamunknown?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioStreamUnknown: AudioObjectID = kAudioObjectUnknown;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreampropertyowningdevice?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioStreamPropertyOwningDevice: AudioObjectPropertySelector = kAudioObjectPropertyOwner;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreampropertyphysicalformats?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioStreamPropertyPhysicalFormats: AudioObjectPropertySelector = 0x70667423;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreampropertyphysicalformatsupported?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioStreamPropertyPhysicalFormatSupported: AudioObjectPropertySelector = 0x7066743f;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreampropertyphysicalformatmatch?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioStreamPropertyPhysicalFormatMatch: AudioObjectPropertySelector = 0x7066746d;

extern "C-unwind" {
    /// Retrieve information about the given property of an AudioStream.
    ///
    /// Parameter `inStream`: The AudioStream to query.
    ///
    /// Parameter `inChannel`: The channel of the property to query where 0 is the main channel.
    ///
    /// Parameter `inPropertyID`: The AudioDevicePropertyID of the property to query.
    ///
    /// Parameter `outSize`: A pointer to a UInt32 that receives the size of the property data in bytes
    /// on exit. This can be NULL if the size information is not being requested.
    ///
    /// Parameter `outWritable`: A pointer to a Boolean that receives indication of whether or not the given
    /// property can be set. This can be NULL if the writability is not being
    /// requested.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `out_size` must be a valid pointer or null.
    /// - `out_writable` must be a valid pointer or null.
    #[cfg(feature = "AudioHardware")]
    #[deprecated]
    pub fn AudioStreamGetPropertyInfo(
        in_stream: AudioStreamID,
        in_channel: u32,
        in_property_id: AudioDevicePropertyID,
        out_size: *mut u32,
        out_writable: *mut Boolean,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Queries an the AudioStream object to get the data of the given property and
    /// places it in the provided buffer.
    ///
    /// Note that the same functionality is provided by the function
    /// AudioObjectGetPropertyData().
    ///
    /// Parameter `inStream`: The AudioStream to query.
    ///
    /// Parameter `inChannel`: The channel of the property to query where 0 is the main channel.
    ///
    /// Parameter `inPropertyID`: The AudioDevicePropertyID of the property to query.
    ///
    /// Parameter `ioPropertyDataSize`: A UInt32 which on entry indicates the size of the buffer pointed to by
    /// outData and on exit indicates how much of the buffer was used.
    ///
    /// Parameter `outPropertyData`: The buffer into which the object will put the data for the given property.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `io_property_data_size` must be a valid pointer.
    /// - `out_property_data` must be a valid pointer.
    #[cfg(feature = "AudioHardware")]
    #[deprecated]
    pub fn AudioStreamGetProperty(
        in_stream: AudioStreamID,
        in_channel: u32,
        in_property_id: AudioDevicePropertyID,
        io_property_data_size: NonNull<u32>,
        out_property_data: NonNull<c_void>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Tells the AudioStream object to change the value of the given property using the
    /// provided data.
    ///
    /// Note that the value of the property should not be considered changed until the
    /// HAL has called the listeners as many properties values are changed
    /// asynchronously. Also note that the same functionality is provided by the
    /// function AudioObjectSetPropertyData().
    ///
    /// Parameter `inStream`: The AudioStream to change.
    ///
    /// Parameter `inWhen`: A pointer to an AudioTimeStamp that says when to change the property's value
    /// relative to the device's time base. NULL means execute the change
    /// immediately.
    ///
    /// Parameter `inChannel`: The channel of the property to change where 0 is the main channel.
    ///
    /// Parameter `inPropertyID`: The AudioDevicePropertyID of the property to change.
    ///
    /// Parameter `inPropertyDataSize`: A UInt32 indicating the size of the buffer pointed to by inData.
    ///
    /// Parameter `inPropertyData`: The buffer containing the data to be used to change the property's value.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_when` must be a valid pointer or null.
    /// - `in_property_data` must be a valid pointer.
    #[cfg(all(feature = "AudioHardware", feature = "objc2-core-audio-types"))]
    #[deprecated]
    pub fn AudioStreamSetProperty(
        in_stream: AudioStreamID,
        in_when: *const AudioTimeStamp,
        in_channel: u32,
        in_property_id: AudioDevicePropertyID,
        in_property_data_size: u32,
        in_property_data: NonNull<c_void>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Registers the given AudioStreamPropertyListenerProc to receive notifications
    /// when the given property changes.
    ///
    /// Note that the same functionality is provided by AudioObjectAddPropertyListener
    /// in conjunction with AudioObjectPropertyListenerProc.
    ///
    /// Parameter `inStream`: The AudioStream with whom to register the listener.
    ///
    /// Parameter `inChannel`: The channel of the property to listen to.
    ///
    /// Parameter `inPropertyID`: The AudioDevicePropertyID of the property to listen to.
    ///
    /// Parameter `inProc`: AudioStreamPropertyListenerProc to call.
    ///
    /// Parameter `inClientData`: A pointer to client data that is passed to the listener when it is called.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_proc` must be implemented correctly.
    /// - `in_client_data` must be a valid pointer or null.
    #[cfg(feature = "AudioHardware")]
    #[deprecated]
    pub fn AudioStreamAddPropertyListener(
        in_stream: AudioStreamID,
        in_channel: u32,
        in_property_id: AudioDevicePropertyID,
        in_proc: AudioStreamPropertyListenerProc,
        in_client_data: *mut c_void,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Unregisters the given AudioStreamPropertyListenerProc from receiving
    /// notifications when the given property changes.
    ///
    /// Note that the same functionality is provided by
    /// AudioObjectRemovePropertyListener in conjunction with
    /// AudioObjectPropertyListenerProc.
    ///
    /// Parameter `inStream`: The AudioStream with whom to unregister the listener.
    ///
    /// Parameter `inChannel`: The channel of the property to unregister from.
    ///
    /// Parameter `inPropertyID`: The AudioDevicePropertyID of the property to stop listening to.
    ///
    /// Parameter `inProc`: AudioStreamPropertyListenerProc to unregister.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// `in_proc` must be implemented correctly.
    #[cfg(feature = "AudioHardware")]
    #[deprecated]
    pub fn AudioStreamRemovePropertyListener(
        in_stream: AudioStreamID,
        in_channel: u32,
        in_property_id: AudioDevicePropertyID,
        in_proc: AudioStreamPropertyListenerProc,
    ) -> OSStatus;
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiobootchimevolumecontrolclassid?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioBootChimeVolumeControlClassID: AudioClassID = 0x7072616d;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiocontrolpropertyvariant?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioControlPropertyVariant: AudioObjectPropertySelector = 0x63766172;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioclocksourcecontrolpropertyitemkind?language=objc)
#[cfg(feature = "AudioHardware")]
pub const kAudioClockSourceControlPropertyItemKind: AudioObjectPropertySelector =
    kAudioSelectorControlPropertyItemKind;
