// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The V1 S3 Metadata configuration for a general purpose bucket. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p><note>
/// <p>If you created your S3 Metadata configuration before July 15, 2025, we recommend that you delete and re-create your configuration by using <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucketMetadataConfiguration.html">CreateBucketMetadataConfiguration</a> so that you can expire journal table records and create a live inventory table.</p>
/// </note>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MetadataTableConfigurationResult {
    /// <p>The destination information for the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub s3_tables_destination_result: ::std::option::Option<crate::types::S3TablesDestinationResult>,
}
impl MetadataTableConfigurationResult {
    /// <p>The destination information for the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub fn s3_tables_destination_result(&self) -> ::std::option::Option<&crate::types::S3TablesDestinationResult> {
        self.s3_tables_destination_result.as_ref()
    }
}
impl MetadataTableConfigurationResult {
    /// Creates a new builder-style object to manufacture [`MetadataTableConfigurationResult`](crate::types::MetadataTableConfigurationResult).
    pub fn builder() -> crate::types::builders::MetadataTableConfigurationResultBuilder {
        crate::types::builders::MetadataTableConfigurationResultBuilder::default()
    }
}

/// A builder for [`MetadataTableConfigurationResult`](crate::types::MetadataTableConfigurationResult).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MetadataTableConfigurationResultBuilder {
    pub(crate) s3_tables_destination_result: ::std::option::Option<crate::types::S3TablesDestinationResult>,
}
impl MetadataTableConfigurationResultBuilder {
    /// <p>The destination information for the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    /// This field is required.
    pub fn s3_tables_destination_result(mut self, input: crate::types::S3TablesDestinationResult) -> Self {
        self.s3_tables_destination_result = ::std::option::Option::Some(input);
        self
    }
    /// <p>The destination information for the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub fn set_s3_tables_destination_result(mut self, input: ::std::option::Option<crate::types::S3TablesDestinationResult>) -> Self {
        self.s3_tables_destination_result = input;
        self
    }
    /// <p>The destination information for the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub fn get_s3_tables_destination_result(&self) -> &::std::option::Option<crate::types::S3TablesDestinationResult> {
        &self.s3_tables_destination_result
    }
    /// Consumes the builder and constructs a [`MetadataTableConfigurationResult`](crate::types::MetadataTableConfigurationResult).
    pub fn build(self) -> crate::types::MetadataTableConfigurationResult {
        crate::types::MetadataTableConfigurationResult {
            s3_tables_destination_result: self.s3_tables_destination_result,
        }
    }
}
