;; R3000 and TX39 pipeline description.
;;   Copyright (C) 2004-2026 Free Software Foundation, Inc.
;;
;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.


;; This file overrides parts of generic.md.  It is derived from the
;; old define_function_unit description.

(define_insn_reservation "r3k_load" 2
  (and (eq_attr "cpu" "r3000,r3900")
       (eq_attr "type" "load,fpload,fpidxload"))
  "alu")

(define_insn_reservation "r3k_imul" 12
  (and (eq_attr "cpu" "r3000,r3900")
       (eq_attr "type" "imul,imul3,imadd"))
  "imuldiv*12")

(define_insn_reservation "r3k_idiv" 35
  (and (eq_attr "cpu" "r3000,r3900")
       (eq_attr "type" "idiv"))
  "imuldiv*35")

(define_insn_reservation "r3k_fmove" 1
  (and (eq_attr "cpu" "r3000,r3900")
       (eq_attr "type" "fabs,fneg,fmove"))
  "alu")

(define_insn_reservation "r3k_fadd" 2
  (and (eq_attr "cpu" "r3000,r3900")
       (eq_attr "type" "fcmp,fadd"))
  "alu")

(define_insn_reservation "r3k_fmul_single" 4
  (and (eq_attr "cpu" "r3000,r3900")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "SF")))
  "alu")

(define_insn_reservation "r3k_fmul_double" 5
  (and (eq_attr "cpu" "r3000,r3900")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "DF")))
  "alu")

(define_insn_reservation "r3k_fdiv_single" 12
  (and (eq_attr "cpu" "r3000,r3900")
       (and (eq_attr "type" "fdiv,frdiv")
	    (eq_attr "mode" "SF")))
  "alu")

(define_insn_reservation "r3k_fdiv_double" 19
  (and (eq_attr "cpu" "r3000,r3900")
       (and (eq_attr "type" "fdiv,frdiv")
	    (eq_attr "mode" "DF")))
  "alu")
