/////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2024 Garmin International, Inc.
// Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
// may not use this file except in compliance with the Flexible and Interoperable Data
// Transfer (FIT) Protocol License.
/////////////////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.158.0Release
// Tag = production/release/21.158.0-0-gc9428aa
/////////////////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_DIVE_ALARM_MESG_HPP)
#define FIT_DIVE_ALARM_MESG_HPP

#include "fit_mesg.hpp"

namespace fit
{

class DiveAlarmMesg : public Mesg
{
public:
    class FieldDefNum final
    {
    public:
       static const FIT_UINT8 MessageIndex = 254;
       static const FIT_UINT8 Depth = 0;
       static const FIT_UINT8 Time = 1;
       static const FIT_UINT8 Enabled = 2;
       static const FIT_UINT8 AlarmType = 3;
       static const FIT_UINT8 Sound = 4;
       static const FIT_UINT8 DiveTypes = 5;
       static const FIT_UINT8 Id = 6;
       static const FIT_UINT8 PopupEnabled = 7;
       static const FIT_UINT8 TriggerOnDescent = 8;
       static const FIT_UINT8 TriggerOnAscent = 9;
       static const FIT_UINT8 Repeating = 10;
       static const FIT_UINT8 Speed = 11;
       static const FIT_UINT8 Invalid = FIT_FIELD_NUM_INVALID;
    };

    DiveAlarmMesg(void) : Mesg(Profile::MESG_DIVE_ALARM)
    {
    }

    DiveAlarmMesg(const Mesg &mesg) : Mesg(mesg)
    {
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of message_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMessageIndexValid() const
    {
        const Field* field = GetField(254);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns message_index field
    // Comment: Index of the alarm
    ///////////////////////////////////////////////////////////////////////
    FIT_MESSAGE_INDEX GetMessageIndex(void) const
    {
        return GetFieldUINT16Value(254, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set message_index field
    // Comment: Index of the alarm
    ///////////////////////////////////////////////////////////////////////
    void SetMessageIndex(FIT_MESSAGE_INDEX messageIndex)
    {
        SetFieldUINT16Value(254, messageIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of depth field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDepthValid() const
    {
        const Field* field = GetField(0);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns depth field
    // Units: m
    // Comment: Depth setting (m) for depth type alarms
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetDepth(void) const
    {
        return GetFieldFLOAT32Value(0, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set depth field
    // Units: m
    // Comment: Depth setting (m) for depth type alarms
    ///////////////////////////////////////////////////////////////////////
    void SetDepth(FIT_FLOAT32 depth)
    {
        SetFieldFLOAT32Value(0, depth, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeValid() const
    {
        const Field* field = GetField(1);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time field
    // Units: s
    // Comment: Time setting (s) for time type alarms
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetTime(void) const
    {
        return GetFieldSINT32Value(1, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time field
    // Units: s
    // Comment: Time setting (s) for time type alarms
    ///////////////////////////////////////////////////////////////////////
    void SetTime(FIT_SINT32 time)
    {
        SetFieldSINT32Value(1, time, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enabled field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnabledValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enabled field
    // Comment: Enablement flag
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL GetEnabled(void) const
    {
        return GetFieldENUMValue(2, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enabled field
    // Comment: Enablement flag
    ///////////////////////////////////////////////////////////////////////
    void SetEnabled(FIT_BOOL enabled)
    {
        SetFieldENUMValue(2, enabled, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of alarm_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAlarmTypeValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns alarm_type field
    // Comment: Alarm type setting
    ///////////////////////////////////////////////////////////////////////
    FIT_DIVE_ALARM_TYPE GetAlarmType(void) const
    {
        return GetFieldENUMValue(3, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set alarm_type field
    // Comment: Alarm type setting
    ///////////////////////////////////////////////////////////////////////
    void SetAlarmType(FIT_DIVE_ALARM_TYPE alarmType)
    {
        SetFieldENUMValue(3, alarmType, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sound field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSoundValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns sound field
    // Comment: Tone and Vibe setting for the alarm
    ///////////////////////////////////////////////////////////////////////
    FIT_TONE GetSound(void) const
    {
        return GetFieldENUMValue(4, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sound field
    // Comment: Tone and Vibe setting for the alarm
    ///////////////////////////////////////////////////////////////////////
    void SetSound(FIT_TONE sound)
    {
        SetFieldENUMValue(4, sound, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of dive_types
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumDiveTypes(void) const
    {
        return GetFieldNumValues(5, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of dive_types field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDiveTypesValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(5);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns dive_types field
    // Comment: Dive types the alarm will trigger on
    ///////////////////////////////////////////////////////////////////////
    FIT_SUB_SPORT GetDiveTypes(FIT_UINT8 index) const
    {
        return GetFieldENUMValue(5, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set dive_types field
    // Comment: Dive types the alarm will trigger on
    ///////////////////////////////////////////////////////////////////////
    void SetDiveTypes(FIT_UINT8 index, FIT_SUB_SPORT diveTypes)
    {
        SetFieldENUMValue(5, diveTypes, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of id field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsIdValid() const
    {
        const Field* field = GetField(6);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns id field
    // Comment: Alarm ID
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetId(void) const
    {
        return GetFieldUINT32Value(6, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set id field
    // Comment: Alarm ID
    ///////////////////////////////////////////////////////////////////////
    void SetId(FIT_UINT32 id)
    {
        SetFieldUINT32Value(6, id, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of popup_enabled field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPopupEnabledValid() const
    {
        const Field* field = GetField(7);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns popup_enabled field
    // Comment: Show a visible pop-up for this alarm
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL GetPopupEnabled(void) const
    {
        return GetFieldENUMValue(7, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set popup_enabled field
    // Comment: Show a visible pop-up for this alarm
    ///////////////////////////////////////////////////////////////////////
    void SetPopupEnabled(FIT_BOOL popupEnabled)
    {
        SetFieldENUMValue(7, popupEnabled, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of trigger_on_descent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTriggerOnDescentValid() const
    {
        const Field* field = GetField(8);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns trigger_on_descent field
    // Comment: Trigger the alarm on descent
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL GetTriggerOnDescent(void) const
    {
        return GetFieldENUMValue(8, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set trigger_on_descent field
    // Comment: Trigger the alarm on descent
    ///////////////////////////////////////////////////////////////////////
    void SetTriggerOnDescent(FIT_BOOL triggerOnDescent)
    {
        SetFieldENUMValue(8, triggerOnDescent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of trigger_on_ascent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTriggerOnAscentValid() const
    {
        const Field* field = GetField(9);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns trigger_on_ascent field
    // Comment: Trigger the alarm on ascent
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL GetTriggerOnAscent(void) const
    {
        return GetFieldENUMValue(9, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set trigger_on_ascent field
    // Comment: Trigger the alarm on ascent
    ///////////////////////////////////////////////////////////////////////
    void SetTriggerOnAscent(FIT_BOOL triggerOnAscent)
    {
        SetFieldENUMValue(9, triggerOnAscent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of repeating field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRepeatingValid() const
    {
        const Field* field = GetField(10);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns repeating field
    // Comment: Repeat alarm each time threshold is crossed?
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL GetRepeating(void) const
    {
        return GetFieldENUMValue(10, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set repeating field
    // Comment: Repeat alarm each time threshold is crossed?
    ///////////////////////////////////////////////////////////////////////
    void SetRepeating(FIT_BOOL repeating)
    {
        SetFieldENUMValue(10, repeating, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSpeedValid() const
    {
        const Field* field = GetField(11);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns speed field
    // Units: mps
    // Comment: Ascent/descent rate (mps) setting for speed type alarms
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetSpeed(void) const
    {
        return GetFieldFLOAT32Value(11, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set speed field
    // Units: mps
    // Comment: Ascent/descent rate (mps) setting for speed type alarms
    ///////////////////////////////////////////////////////////////////////
    void SetSpeed(FIT_FLOAT32 speed)
    {
        SetFieldFLOAT32Value(11, speed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

};

} // namespace fit

#endif // !defined(FIT_DIVE_ALARM_MESG_HPP)
