/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import net.sf.jsqlparser.statement.create.view.AutoRefreshOption;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.create.view.TemporaryOption;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;

public class CreateViewDeParser
extends AbstractDeParser<CreateView> {
    private final SelectVisitor<StringBuilder> selectVisitor;

    public CreateViewDeParser(StringBuilder buffer) {
        super(buffer);
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuilder(buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        this.selectVisitor = selectDeParser;
    }

    public CreateViewDeParser(StringBuilder buffer, SelectVisitor<StringBuilder> selectVisitor) {
        super(buffer);
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(CreateView createView) {
        this.builder.append("CREATE ");
        if (createView.isOrReplace()) {
            this.builder.append("OR REPLACE ");
        }
        switch (createView.getForce()) {
            case FORCE: {
                this.builder.append("FORCE ");
                break;
            }
            case NO_FORCE: {
                this.builder.append("NO FORCE ");
                break;
            }
            case NONE: {
                break;
            }
        }
        if (createView.isSecure()) {
            this.builder.append("SECURE ");
        }
        if (createView.getTemporary() != TemporaryOption.NONE) {
            this.builder.append(createView.getTemporary().name()).append(" ");
        }
        if (createView.isMaterialized()) {
            this.builder.append("MATERIALIZED ");
        }
        this.builder.append("VIEW ").append(createView.getView().getFullyQualifiedName());
        if (createView.isIfNotExists()) {
            this.builder.append(" IF NOT EXISTS");
        }
        if (createView.getAutoRefresh() != AutoRefreshOption.NONE) {
            this.builder.append(" AUTO REFRESH ").append(createView.getAutoRefresh().name());
        }
        if (createView.getColumnNames() != null) {
            this.builder.append("(");
            this.builder.append(createView.getColumnNames());
            this.builder.append(")");
        }
        if (createView.getViewCommentOptions() != null) {
            this.builder.append(PlainSelect.getStringList(createView.getViewCommentOptions(), false, false));
        }
        this.builder.append(" AS ");
        Select select = createView.getSelect();
        select.accept(this.selectVisitor, null);
        if (createView.isWithReadOnly()) {
            this.builder.append(" WITH READ ONLY");
        }
    }
}

