/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateImpl;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.JapaneseChronology;
import java.time.chrono.JapaneseEra;
import java.time.chrono.Ser;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Calendar;
import java.util.Objects;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.Era;
import sun.util.calendar.LocalGregorianCalendar;

public final class JapaneseDate
extends ChronoLocalDateImpl<JapaneseDate>
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = -305327627230580483L;
    private final transient LocalDate isoDate;
    private transient JapaneseEra era;
    private transient int yearOfEra;
    static final LocalDate MEIJI_6_ISODATE = LocalDate.of(1873, 1, 1);

    public static JapaneseDate now() {
        return JapaneseDate.now(Clock.systemDefaultZone());
    }

    public static JapaneseDate now(ZoneId zoneId) {
        return JapaneseDate.now(Clock.system(zoneId));
    }

    public static JapaneseDate now(Clock clock) {
        return new JapaneseDate(LocalDate.now(clock));
    }

    public static JapaneseDate of(JapaneseEra japaneseEra, int n, int n2, int n3) {
        Objects.requireNonNull(japaneseEra, "era");
        LocalGregorianCalendar.Date date = JapaneseChronology.JCAL.newCalendarDate(null);
        date.setEra(japaneseEra.getPrivateEra()).setDate(n, n2, n3);
        if (!JapaneseChronology.JCAL.validate(date)) {
            throw new DateTimeException("year, month, and day not valid for Era");
        }
        LocalDate localDate = LocalDate.of(date.getNormalizedYear(), n2, n3);
        return new JapaneseDate(japaneseEra, n, localDate);
    }

    public static JapaneseDate of(int n, int n2, int n3) {
        return new JapaneseDate(LocalDate.of(n, n2, n3));
    }

    static JapaneseDate ofYearDay(JapaneseEra japaneseEra, int n, int n2) {
        Objects.requireNonNull(japaneseEra, "era");
        CalendarDate calendarDate = japaneseEra.getPrivateEra().getSinceDate();
        LocalGregorianCalendar.Date date = JapaneseChronology.JCAL.newCalendarDate(null);
        date.setEra(japaneseEra.getPrivateEra());
        if (n == 1) {
            date.setDate(n, calendarDate.getMonth(), calendarDate.getDayOfMonth() + n2 - 1);
        } else {
            date.setDate(n, 1, n2);
        }
        JapaneseChronology.JCAL.normalize(date);
        if (japaneseEra.getPrivateEra() != date.getEra() || n != date.getYear()) {
            throw new DateTimeException("Invalid parameters");
        }
        LocalDate localDate = LocalDate.of(date.getNormalizedYear(), date.getMonth(), date.getDayOfMonth());
        return new JapaneseDate(japaneseEra, n, localDate);
    }

    public static JapaneseDate from(TemporalAccessor temporalAccessor) {
        return JapaneseChronology.INSTANCE.date(temporalAccessor);
    }

    JapaneseDate(LocalDate localDate) {
        if (localDate.isBefore(MEIJI_6_ISODATE)) {
            throw new DateTimeException("JapaneseDate before Meiji 6 is not supported");
        }
        LocalGregorianCalendar.Date date = JapaneseDate.toPrivateJapaneseDate(localDate);
        this.era = JapaneseEra.toJapaneseEra(date.getEra());
        this.yearOfEra = date.getYear();
        this.isoDate = localDate;
    }

    JapaneseDate(JapaneseEra japaneseEra, int n, LocalDate localDate) {
        if (localDate.isBefore(MEIJI_6_ISODATE)) {
            throw new DateTimeException("JapaneseDate before Meiji 6 is not supported");
        }
        this.era = japaneseEra;
        this.yearOfEra = n;
        this.isoDate = localDate;
    }

    @Override
    public JapaneseChronology getChronology() {
        return JapaneseChronology.INSTANCE;
    }

    @Override
    public JapaneseEra getEra() {
        return this.era;
    }

    @Override
    public int lengthOfMonth() {
        return this.isoDate.lengthOfMonth();
    }

    @Override
    public int lengthOfYear() {
        Calendar calendar = Calendar.getInstance(JapaneseChronology.LOCALE);
        calendar.set(0, this.era.getValue() + 2);
        calendar.set(this.yearOfEra, this.isoDate.getMonthValue() - 1, this.isoDate.getDayOfMonth());
        return calendar.getActualMaximum(6);
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        if (temporalField == ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH || temporalField == ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR || temporalField == ChronoField.ALIGNED_WEEK_OF_MONTH || temporalField == ChronoField.ALIGNED_WEEK_OF_YEAR) {
            return false;
        }
        return ChronoLocalDate.super.isSupported(temporalField);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (this.isSupported(temporalField)) {
                ChronoField chronoField = (ChronoField)temporalField;
                switch (chronoField) {
                    case DAY_OF_MONTH: {
                        return ValueRange.of(1L, this.lengthOfMonth());
                    }
                    case DAY_OF_YEAR: {
                        return ValueRange.of(1L, this.lengthOfYear());
                    }
                    case YEAR_OF_ERA: {
                        Calendar calendar = Calendar.getInstance(JapaneseChronology.LOCALE);
                        calendar.set(0, this.era.getValue() + 2);
                        calendar.set(this.yearOfEra, this.isoDate.getMonthValue() - 1, this.isoDate.getDayOfMonth());
                        return ValueRange.of(1L, calendar.getActualMaximum(1));
                    }
                }
                return this.getChronology().range(chronoField);
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: 
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: 
                case ALIGNED_WEEK_OF_MONTH: 
                case ALIGNED_WEEK_OF_YEAR: {
                    throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
                }
                case YEAR_OF_ERA: {
                    return this.yearOfEra;
                }
                case ERA: {
                    return this.era.getValue();
                }
                case DAY_OF_YEAR: {
                    Calendar calendar = Calendar.getInstance(JapaneseChronology.LOCALE);
                    calendar.set(0, this.era.getValue() + 2);
                    calendar.set(this.yearOfEra, this.isoDate.getMonthValue() - 1, this.isoDate.getDayOfMonth());
                    return calendar.get(6);
                }
            }
            return this.isoDate.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    private static LocalGregorianCalendar.Date toPrivateJapaneseDate(LocalDate localDate) {
        LocalGregorianCalendar.Date date = JapaneseChronology.JCAL.newCalendarDate(null);
        Era era = JapaneseEra.privateEraFrom(localDate);
        int n = localDate.getYear();
        if (era != null) {
            n -= era.getSinceDate().getYear() - 1;
        }
        date.setEra(era).setYear(n).setMonth(localDate.getMonthValue()).setDayOfMonth(localDate.getDayOfMonth());
        JapaneseChronology.JCAL.normalize(date);
        return date;
    }

    @Override
    public JapaneseDate with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            if (this.getLong(chronoField) == l) {
                return this;
            }
            switch (chronoField) {
                case YEAR_OF_ERA: 
                case ERA: 
                case YEAR: {
                    int n = this.getChronology().range(chronoField).checkValidIntValue(l, chronoField);
                    switch (chronoField) {
                        case YEAR_OF_ERA: {
                            return this.withYear(n);
                        }
                        case YEAR: {
                            return this.with(this.isoDate.withYear(n));
                        }
                        case ERA: {
                            return this.withYear(JapaneseEra.of(n), this.yearOfEra);
                        }
                    }
                }
            }
            return this.with(this.isoDate.with(temporalField, l));
        }
        return (JapaneseDate)super.with(temporalField, l);
    }

    @Override
    public JapaneseDate with(TemporalAdjuster temporalAdjuster) {
        return (JapaneseDate)super.with(temporalAdjuster);
    }

    @Override
    public JapaneseDate plus(TemporalAmount temporalAmount) {
        return (JapaneseDate)super.plus(temporalAmount);
    }

    @Override
    public JapaneseDate minus(TemporalAmount temporalAmount) {
        return (JapaneseDate)super.minus(temporalAmount);
    }

    private JapaneseDate withYear(JapaneseEra japaneseEra, int n) {
        int n2 = JapaneseChronology.INSTANCE.prolepticYear(japaneseEra, n);
        return this.with(this.isoDate.withYear(n2));
    }

    private JapaneseDate withYear(int n) {
        return this.withYear(this.getEra(), n);
    }

    @Override
    JapaneseDate plusYears(long l) {
        return this.with(this.isoDate.plusYears(l));
    }

    @Override
    JapaneseDate plusMonths(long l) {
        return this.with(this.isoDate.plusMonths(l));
    }

    @Override
    JapaneseDate plusWeeks(long l) {
        return this.with(this.isoDate.plusWeeks(l));
    }

    @Override
    JapaneseDate plusDays(long l) {
        return this.with(this.isoDate.plusDays(l));
    }

    @Override
    public JapaneseDate plus(long l, TemporalUnit temporalUnit) {
        return (JapaneseDate)super.plus(l, temporalUnit);
    }

    @Override
    public JapaneseDate minus(long l, TemporalUnit temporalUnit) {
        return (JapaneseDate)super.minus(l, temporalUnit);
    }

    @Override
    JapaneseDate minusYears(long l) {
        return (JapaneseDate)super.minusYears(l);
    }

    @Override
    JapaneseDate minusMonths(long l) {
        return (JapaneseDate)super.minusMonths(l);
    }

    @Override
    JapaneseDate minusWeeks(long l) {
        return (JapaneseDate)super.minusWeeks(l);
    }

    @Override
    JapaneseDate minusDays(long l) {
        return (JapaneseDate)super.minusDays(l);
    }

    private JapaneseDate with(LocalDate localDate) {
        return localDate.equals(this.isoDate) ? this : new JapaneseDate(localDate);
    }

    public final ChronoLocalDateTime<JapaneseDate> atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate chronoLocalDate) {
        Period period = this.isoDate.until(chronoLocalDate);
        return this.getChronology().period(period.getYears(), period.getMonths(), period.getDays());
    }

    @Override
    public long toEpochDay() {
        return this.isoDate.toEpochDay();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JapaneseDate) {
            JapaneseDate japaneseDate = (JapaneseDate)object;
            return this.isoDate.equals(japaneseDate.isoDate);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getChronology().getId().hashCode() ^ this.isoDate.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(4, this);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.get(ChronoField.YEAR));
        dataOutput.writeByte(this.get(ChronoField.MONTH_OF_YEAR));
        dataOutput.writeByte(this.get(ChronoField.DAY_OF_MONTH));
    }

    static JapaneseDate readExternal(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        byte by = dataInput.readByte();
        byte by2 = dataInput.readByte();
        return JapaneseChronology.INSTANCE.date(n, by, by2);
    }
}

