//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// The position along the perimeter of a rectangular frame (its edges and corners) from which it’s resized.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nscursorframeresizeposition?language=objc)
// NS_CLOSED_ENUM
#[repr(usize)] // NSUInteger
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub enum NSCursorFrameResizePosition {
    /// The top edge of the frame.
    #[doc(alias = "NSCursorFrameResizePositionTop")]
    Top = 1 << 0,
    /// The left edge of the frame.
    #[doc(alias = "NSCursorFrameResizePositionLeft")]
    Left = 1 << 1,
    /// The bottom edge of the frame.
    #[doc(alias = "NSCursorFrameResizePositionBottom")]
    Bottom = 1 << 2,
    /// The right edge of the frame.
    #[doc(alias = "NSCursorFrameResizePositionRight")]
    Right = 1 << 3,
    /// The top left corner of the frame.
    #[doc(alias = "NSCursorFrameResizePositionTopLeft")]
    TopLeft = NSCursorFrameResizePosition::Top as NSUInteger
        | NSCursorFrameResizePosition::Left as NSUInteger,
    /// The top right corner of the frame.
    #[doc(alias = "NSCursorFrameResizePositionTopRight")]
    TopRight = NSCursorFrameResizePosition::Top as NSUInteger
        | NSCursorFrameResizePosition::Right as NSUInteger,
    /// The bottom left corner of the frame.
    #[doc(alias = "NSCursorFrameResizePositionBottomLeft")]
    BottomLeft = NSCursorFrameResizePosition::Bottom as NSUInteger
        | NSCursorFrameResizePosition::Left as NSUInteger,
    /// The bottom right corner of the frame.
    #[doc(alias = "NSCursorFrameResizePositionBottomRight")]
    BottomRight = NSCursorFrameResizePosition::Bottom as NSUInteger
        | NSCursorFrameResizePosition::Right as NSUInteger,
}

unsafe impl Encode for NSCursorFrameResizePosition {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCursorFrameResizePosition {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The directions in which a rectangular frame can be resized.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nscursorframeresizedirections?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCursorFrameResizeDirections(pub NSUInteger);
bitflags::bitflags! {
    impl NSCursorFrameResizeDirections: NSUInteger {
/// Indicates that the shape can be resized inwards to be smaller.
        #[doc(alias = "NSCursorFrameResizeDirectionsInward")]
        const Inward = 1<<0;
/// Indicates that the shape can be resized outwards to be larger.
        #[doc(alias = "NSCursorFrameResizeDirectionsOutward")]
        const Outward = 1<<1;
/// Indicates that the shape can be resized inwards or wards to be either smaller or larger, respectively.
        #[doc(alias = "NSCursorFrameResizeDirectionsAll")]
        const All = NSCursorFrameResizeDirections::Inward.0|NSCursorFrameResizeDirections::Outward.0;
    }
}

unsafe impl Encode for NSCursorFrameResizeDirections {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCursorFrameResizeDirections {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscursor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCursor;
);

extern_conformance!(
    unsafe impl NSCoding for NSCursor {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCursor {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for NSCursor {}
);

impl NSCursor {
    extern_methods!(
        #[cfg(feature = "NSImage")]
        #[unsafe(method(initWithImage:hotSpot:))]
        #[unsafe(method_family = init)]
        pub fn initWithImage_hotSpot(
            this: Allocated<Self>,
            new_image: &NSImage,
            point: NSPoint,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;

        #[cfg(feature = "NSImage")]
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub fn image(&self) -> Retained<NSImage>;

        #[unsafe(method(hotSpot))]
        #[unsafe(method_family = none)]
        pub fn hotSpot(&self) -> NSPoint;

        #[unsafe(method(hide))]
        #[unsafe(method_family = none)]
        pub fn hide();

        #[unsafe(method(unhide))]
        #[unsafe(method_family = none)]
        pub fn unhide();

        #[unsafe(method(setHiddenUntilMouseMoves:))]
        #[unsafe(method_family = none)]
        pub fn setHiddenUntilMouseMoves(flag: bool);

        #[unsafe(method(pop))]
        #[unsafe(method_family = none)]
        pub fn pop_class();

        #[unsafe(method(pop))]
        #[unsafe(method_family = none)]
        pub fn pop(&self);

        #[unsafe(method(push))]
        #[unsafe(method_family = none)]
        pub fn push(&self);

        #[unsafe(method(set))]
        #[unsafe(method_family = none)]
        pub fn set(&self);

        /// Returns the application’s current cursor.
        /// - Note: This isn’t necessarily the cursor that is currently being displayed, as the system may be showing the cursor for another running application.
        #[unsafe(method(currentCursor))]
        #[unsafe(method_family = none)]
        pub fn currentCursor() -> Retained<NSCursor>;

        /// Returns the default cursor, the arrow cursor.
        /// - Discussion: The default cursor, a slanted arrow with its hot spot at the tip. The arrow cursor is the one you’re used to seeing over buttons, scrollers, and many other objects in the window system.
        #[unsafe(method(arrowCursor))]
        #[unsafe(method_family = none)]
        pub fn arrowCursor() -> Retained<NSCursor>;

        #[unsafe(method(crosshairCursor))]
        #[unsafe(method_family = none)]
        pub fn crosshairCursor() -> Retained<NSCursor>;

        #[unsafe(method(disappearingItemCursor))]
        #[unsafe(method_family = none)]
        pub fn disappearingItemCursor() -> Retained<NSCursor>;

        #[unsafe(method(operationNotAllowedCursor))]
        #[unsafe(method_family = none)]
        pub fn operationNotAllowedCursor() -> Retained<NSCursor>;

        #[unsafe(method(dragLinkCursor))]
        #[unsafe(method_family = none)]
        pub fn dragLinkCursor() -> Retained<NSCursor>;

        #[unsafe(method(dragCopyCursor))]
        #[unsafe(method_family = none)]
        pub fn dragCopyCursor() -> Retained<NSCursor>;

        #[unsafe(method(contextualMenuCursor))]
        #[unsafe(method_family = none)]
        pub fn contextualMenuCursor() -> Retained<NSCursor>;

        #[unsafe(method(pointingHandCursor))]
        #[unsafe(method_family = none)]
        pub fn pointingHandCursor() -> Retained<NSCursor>;

        #[unsafe(method(closedHandCursor))]
        #[unsafe(method_family = none)]
        pub fn closedHandCursor() -> Retained<NSCursor>;

        #[unsafe(method(openHandCursor))]
        #[unsafe(method_family = none)]
        pub fn openHandCursor() -> Retained<NSCursor>;

        #[unsafe(method(IBeamCursor))]
        #[unsafe(method_family = none)]
        pub fn IBeamCursor() -> Retained<NSCursor>;

        #[unsafe(method(IBeamCursorForVerticalLayout))]
        #[unsafe(method_family = none)]
        pub fn IBeamCursorForVerticalLayout() -> Retained<NSCursor>;

        /// Returns the zoom-in cursor.
        /// - Note: This cursor is used to indicate zooming in on (magnifying) a canvas or object.
        #[unsafe(method(zoomInCursor))]
        #[unsafe(method_family = none)]
        pub fn zoomInCursor() -> Retained<NSCursor>;

        /// Returns the zoom-out cursor.
        /// - Note: This cursor is used to indicate zooming out of a canvas or object.
        #[unsafe(method(zoomOutCursor))]
        #[unsafe(method_family = none)]
        pub fn zoomOutCursor() -> Retained<NSCursor>;

        /// Returns the cursor for resizing a column (vertical divider) in either direction.
        #[unsafe(method(columnResizeCursor))]
        #[unsafe(method_family = none)]
        pub fn columnResizeCursor() -> Retained<NSCursor>;

        #[cfg(feature = "NSDirection")]
        /// Returns the cursor for resizing a column (vertical divider) in the specified directions.
        /// - Parameter directions: The direction in which a column can be resized.
        #[unsafe(method(columnResizeCursorInDirections:))]
        #[unsafe(method_family = none)]
        pub fn columnResizeCursorInDirections(
            directions: NSHorizontalDirections,
        ) -> Retained<NSCursor>;

        /// Returns the cursor for resizing a row (horizontal divider) in either direction.
        #[unsafe(method(rowResizeCursor))]
        #[unsafe(method_family = none)]
        pub fn rowResizeCursor() -> Retained<NSCursor>;

        #[cfg(feature = "NSDirection")]
        /// Returns the cursor for resizing a row (horizontal divider) in the specified directions.
        /// - Parameter directions: The direction in which a row can be resized.
        #[unsafe(method(rowResizeCursorInDirections:))]
        #[unsafe(method_family = none)]
        pub fn rowResizeCursorInDirections(directions: NSVerticalDirections) -> Retained<NSCursor>;

        /// Returns the cursor for resizing a rectangular frame from the specified edge or corner.
        /// - Parameters:
        /// - position: The position along the perimeter of a rectangular frame (its edges and corners) from which it’s resized.
        /// - directions: The directions in which a rectangular frame can be resized.
        #[unsafe(method(frameResizeCursorFromPosition:inDirections:))]
        #[unsafe(method_family = none)]
        pub fn frameResizeCursorFromPosition_inDirections(
            position: NSCursorFrameResizePosition,
            directions: NSCursorFrameResizeDirections,
        ) -> Retained<NSCursor>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSCursor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSCursor {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsappkitversionnumberwithcursorsizesupport?language=objc)
#[cfg(feature = "NSApplication")]
pub static NSAppKitVersionNumberWithCursorSizeSupport: NSAppKitVersion = 682.0 as _;

/// Deprecated.
impl NSCursor {
    extern_methods!(
        /// This property will always be `nil` in a future version of macOS.
        #[deprecated = "No longer recommended. Use ScreenCaptureKit to capture the screen. Use the `showsCursor` property on `SCStreamConfiguration` to control whether or not to include the cursor in the capture. Or, use `NSCursor.currentCursor` if needing to just get the current cursor for this application."]
        #[unsafe(method(currentSystemCursor))]
        #[unsafe(method_family = none)]
        pub fn currentSystemCursor() -> Option<Retained<NSCursor>>;

        #[deprecated = "Use either `+[NSCursor columnResizeCursorInDirections:]` or `+[NSCursor frameResizeCursorFromPosition:inDirections:]` instead, depending on whether a divider is being re-positioned or a rectangular frame is being resized."]
        #[unsafe(method(resizeLeftCursor))]
        #[unsafe(method_family = none)]
        pub fn resizeLeftCursor() -> Retained<NSCursor>;

        #[deprecated = "Use either `+[NSCursor columnResizeCursorInDirections:]` or `+[NSCursor frameResizeCursorFromPosition:inDirections:]` instead, depending on whether a divider is being re-positioned or a rectangular frame is being resized."]
        #[unsafe(method(resizeRightCursor))]
        #[unsafe(method_family = none)]
        pub fn resizeRightCursor() -> Retained<NSCursor>;

        #[deprecated = "Use either `+[NSCursor columnResizeCursorInDirections:]` or `+[NSCursor frameResizeCursorFromPosition:inDirections:]` instead, depending on whether a divider is being re-positioned or a rectangular frame is being resized."]
        #[unsafe(method(resizeLeftRightCursor))]
        #[unsafe(method_family = none)]
        pub fn resizeLeftRightCursor() -> Retained<NSCursor>;

        #[deprecated = "Use either `+[NSCursor rowResizeCursorInDirections:]` or `+[NSCursor frameResizeCursorFromPosition:inDirections:]` instead, depending on whether a divider is being re-positioned or a rectangular frame is being resized."]
        #[unsafe(method(resizeUpCursor))]
        #[unsafe(method_family = none)]
        pub fn resizeUpCursor() -> Retained<NSCursor>;

        #[deprecated = "Use either `+[NSCursor rowResizeCursorInDirections:]` or `+[NSCursor frameResizeCursorFromPosition:inDirections:]` instead, depending on whether a divider is being re-positioned or a rectangular frame is being resized."]
        #[unsafe(method(resizeDownCursor))]
        #[unsafe(method_family = none)]
        pub fn resizeDownCursor() -> Retained<NSCursor>;

        #[deprecated = "Use either `+[NSCursor rowResizeCursorInDirections:]` or `+[NSCursor frameResizeCursorFromPosition:inDirections:]` instead, depending on whether a divider is being re-positioned or a rectangular frame is being resized."]
        #[unsafe(method(resizeUpDownCursor))]
        #[unsafe(method_family = none)]
        pub fn resizeUpDownCursor() -> Retained<NSCursor>;
    );
}

/// NSDeprecated.
impl NSCursor {
    extern_methods!(
        #[cfg(all(feature = "NSColor", feature = "NSImage"))]
        #[deprecated = "Color hints are ignored. Use -initWithImage:hotSpot: instead"]
        #[unsafe(method(initWithImage:foregroundColorHint:backgroundColorHint:hotSpot:))]
        #[unsafe(method_family = init)]
        pub fn initWithImage_foregroundColorHint_backgroundColorHint_hotSpot(
            this: Allocated<Self>,
            new_image: &NSImage,
            fg: Option<&NSColor>,
            bg: Option<&NSColor>,
            hot_spot: NSPoint,
        ) -> Retained<Self>;

        #[deprecated = "setOnMouseExited is unused and should not be called"]
        #[unsafe(method(setOnMouseExited:))]
        #[unsafe(method_family = none)]
        pub fn setOnMouseExited(&self, flag: bool);

        #[deprecated = "setOnMouseEntered is unused and should not be called"]
        #[unsafe(method(setOnMouseEntered:))]
        #[unsafe(method_family = none)]
        pub fn setOnMouseEntered(&self, flag: bool);

        #[deprecated = "isSetOnMouseExited is unused"]
        #[unsafe(method(isSetOnMouseExited))]
        #[unsafe(method_family = none)]
        pub fn isSetOnMouseExited(&self) -> bool;

        #[deprecated = "isSetOnMouseEntered is unused"]
        #[unsafe(method(isSetOnMouseEntered))]
        #[unsafe(method_family = none)]
        pub fn isSetOnMouseEntered(&self) -> bool;

        #[cfg(feature = "NSEvent")]
        #[deprecated = "mouseEntered: is unused and should not be called"]
        #[unsafe(method(mouseEntered:))]
        #[unsafe(method_family = none)]
        pub fn mouseEntered(&self, event: &NSEvent);

        #[cfg(feature = "NSEvent")]
        #[deprecated = "mouseExited: is unused and should not be called"]
        #[unsafe(method(mouseExited:))]
        #[unsafe(method_family = none)]
        pub fn mouseExited(&self, event: &NSEvent);
    );
}
