//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfxmlnodecurrentversion?language=objc)
pub const kCFXMLNodeCurrentVersion: CFIndex = 1;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlnode?language=objc)
#[doc(alias = "CFXMLNodeRef")]
#[repr(C)]
pub struct CFXMLNode {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFXMLNode {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFXMLNode"> for CFXMLNode {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmltree?language=objc)
#[doc(alias = "CFXMLTreeRef")]
#[cfg(feature = "CFTree")]
pub type CFXMLTree = CFTree;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlnodetypecode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFXMLNodeTypeCode(pub CFIndex);
impl CFXMLNodeTypeCode {
    #[doc(alias = "kCFXMLNodeTypeDocument")]
    pub const Document: Self = Self(1);
    #[doc(alias = "kCFXMLNodeTypeElement")]
    pub const Element: Self = Self(2);
    #[doc(alias = "kCFXMLNodeTypeAttribute")]
    pub const Attribute: Self = Self(3);
    #[doc(alias = "kCFXMLNodeTypeProcessingInstruction")]
    pub const ProcessingInstruction: Self = Self(4);
    #[doc(alias = "kCFXMLNodeTypeComment")]
    pub const Comment: Self = Self(5);
    #[doc(alias = "kCFXMLNodeTypeText")]
    pub const Text: Self = Self(6);
    #[doc(alias = "kCFXMLNodeTypeCDATASection")]
    pub const CDATASection: Self = Self(7);
    #[doc(alias = "kCFXMLNodeTypeDocumentFragment")]
    pub const DocumentFragment: Self = Self(8);
    #[doc(alias = "kCFXMLNodeTypeEntity")]
    pub const Entity: Self = Self(9);
    #[doc(alias = "kCFXMLNodeTypeEntityReference")]
    pub const EntityReference: Self = Self(10);
    #[doc(alias = "kCFXMLNodeTypeDocumentType")]
    pub const DocumentType: Self = Self(11);
    #[doc(alias = "kCFXMLNodeTypeWhitespace")]
    pub const Whitespace: Self = Self(12);
    #[doc(alias = "kCFXMLNodeTypeNotation")]
    pub const Notation: Self = Self(13);
    #[doc(alias = "kCFXMLNodeTypeElementTypeDeclaration")]
    pub const ElementTypeDeclaration: Self = Self(14);
    #[doc(alias = "kCFXMLNodeTypeAttributeListDeclaration")]
    pub const AttributeListDeclaration: Self = Self(15);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFXMLNodeTypeCode {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFXMLNodeTypeCode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlelementinfo?language=objc)
#[cfg(all(feature = "CFArray", feature = "CFDictionary"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFXMLElementInfo {
    pub attributes: *const CFDictionary,
    pub attributeOrder: *const CFArray,
    pub isEmpty: Boolean,
    pub(crate) _reserved: [c_char; 3],
}

#[cfg(all(feature = "CFArray", feature = "CFDictionary", feature = "objc2"))]
unsafe impl Encode for CFXMLElementInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <*const CFDictionary>::ENCODING,
            <*const CFArray>::ENCODING,
            <Boolean>::ENCODING,
            <[c_char; 3]>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "CFArray", feature = "CFDictionary", feature = "objc2"))]
unsafe impl RefEncode for CFXMLElementInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlprocessinginstructioninfo?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFXMLProcessingInstructionInfo {
    pub dataString: *const CFString,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFXMLProcessingInstructionInfo {
    const ENCODING: Encoding = Encoding::Struct("?", &[<*const CFString>::ENCODING]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFXMLProcessingInstructionInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmldocumentinfo?language=objc)
#[cfg(all(feature = "CFString", feature = "CFURL"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFXMLDocumentInfo {
    pub sourceURL: *const CFURL,
    pub encoding: CFStringEncoding,
}

#[cfg(all(feature = "CFString", feature = "CFURL", feature = "objc2"))]
unsafe impl Encode for CFXMLDocumentInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[<*const CFURL>::ENCODING, <CFStringEncoding>::ENCODING],
    );
}

#[cfg(all(feature = "CFString", feature = "CFURL", feature = "objc2"))]
unsafe impl RefEncode for CFXMLDocumentInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlexternalid?language=objc)
#[cfg(feature = "CFURL")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFXMLExternalID {
    pub systemID: *const CFURL,
    pub publicID: *const CFString,
}

#[cfg(all(feature = "CFURL", feature = "objc2"))]
unsafe impl Encode for CFXMLExternalID {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[<*const CFURL>::ENCODING, <*const CFString>::ENCODING],
    );
}

#[cfg(all(feature = "CFURL", feature = "objc2"))]
unsafe impl RefEncode for CFXMLExternalID {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmldocumenttypeinfo?language=objc)
#[cfg(feature = "CFURL")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFXMLDocumentTypeInfo {
    pub externalID: CFXMLExternalID,
}

#[cfg(all(feature = "CFURL", feature = "objc2"))]
unsafe impl Encode for CFXMLDocumentTypeInfo {
    const ENCODING: Encoding = Encoding::Struct("?", &[<CFXMLExternalID>::ENCODING]);
}

#[cfg(all(feature = "CFURL", feature = "objc2"))]
unsafe impl RefEncode for CFXMLDocumentTypeInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlnotationinfo?language=objc)
#[cfg(feature = "CFURL")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFXMLNotationInfo {
    pub externalID: CFXMLExternalID,
}

#[cfg(all(feature = "CFURL", feature = "objc2"))]
unsafe impl Encode for CFXMLNotationInfo {
    const ENCODING: Encoding = Encoding::Struct("?", &[<CFXMLExternalID>::ENCODING]);
}

#[cfg(all(feature = "CFURL", feature = "objc2"))]
unsafe impl RefEncode for CFXMLNotationInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlelementtypedeclarationinfo?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFXMLElementTypeDeclarationInfo {
    pub contentDescription: *const CFString,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFXMLElementTypeDeclarationInfo {
    const ENCODING: Encoding = Encoding::Struct("?", &[<*const CFString>::ENCODING]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFXMLElementTypeDeclarationInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlattributedeclarationinfo?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFXMLAttributeDeclarationInfo {
    pub attributeName: *const CFString,
    pub typeString: *const CFString,
    pub defaultString: *const CFString,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFXMLAttributeDeclarationInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <*const CFString>::ENCODING,
            <*const CFString>::ENCODING,
            <*const CFString>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFXMLAttributeDeclarationInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlattributelistdeclarationinfo?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFXMLAttributeListDeclarationInfo {
    pub numberOfAttributes: CFIndex,
    pub attributes: *mut CFXMLAttributeDeclarationInfo,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFXMLAttributeListDeclarationInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut CFXMLAttributeDeclarationInfo>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFXMLAttributeListDeclarationInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlentitytypecode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFXMLEntityTypeCode(pub CFIndex);
impl CFXMLEntityTypeCode {
    #[doc(alias = "kCFXMLEntityTypeParameter")]
    pub const Parameter: Self = Self(0);
    #[doc(alias = "kCFXMLEntityTypeParsedInternal")]
    pub const ParsedInternal: Self = Self(1);
    #[doc(alias = "kCFXMLEntityTypeParsedExternal")]
    pub const ParsedExternal: Self = Self(2);
    #[doc(alias = "kCFXMLEntityTypeUnparsed")]
    pub const Unparsed: Self = Self(3);
    #[doc(alias = "kCFXMLEntityTypeCharacter")]
    pub const Character: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFXMLEntityTypeCode {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFXMLEntityTypeCode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlentityinfo?language=objc)
#[cfg(feature = "CFURL")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFXMLEntityInfo {
    pub entityType: CFXMLEntityTypeCode,
    pub replacementText: *const CFString,
    pub entityID: CFXMLExternalID,
    pub notationName: *const CFString,
}

#[cfg(all(feature = "CFURL", feature = "objc2"))]
unsafe impl Encode for CFXMLEntityInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFXMLEntityTypeCode>::ENCODING,
            <*const CFString>::ENCODING,
            <CFXMLExternalID>::ENCODING,
            <*const CFString>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "CFURL", feature = "objc2"))]
unsafe impl RefEncode for CFXMLEntityInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfxmlentityreferenceinfo?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFXMLEntityReferenceInfo {
    pub entityType: CFXMLEntityTypeCode,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFXMLEntityReferenceInfo {
    const ENCODING: Encoding = Encoding::Struct("?", &[<CFXMLEntityTypeCode>::ENCODING]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFXMLEntityReferenceInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CFXMLNode {
    #[doc(alias = "CFXMLNodeGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFXMLNodeGetTypeID() -> CFTypeID;
        }
        unsafe { CFXMLNodeGetTypeID() }
    }
}

impl CFXMLNode {
    /// # Safety
    ///
    /// - `alloc` might not allow `None`.
    /// - `data_string` might not allow `None`.
    /// - `additional_info_ptr` must be a valid pointer.
    #[doc(alias = "CFXMLNodeCreate")]
    #[deprecated = "CFXMLNode is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub unsafe fn new(
        alloc: Option<&CFAllocator>,
        xml_type: CFXMLNodeTypeCode,
        data_string: Option<&CFString>,
        additional_info_ptr: *const c_void,
        version: CFIndex,
    ) -> Option<CFRetained<CFXMLNode>> {
        extern "C-unwind" {
            fn CFXMLNodeCreate(
                alloc: Option<&CFAllocator>,
                xml_type: CFXMLNodeTypeCode,
                data_string: Option<&CFString>,
                additional_info_ptr: *const c_void,
                version: CFIndex,
            ) -> Option<NonNull<CFXMLNode>>;
        }
        let ret =
            unsafe { CFXMLNodeCreate(alloc, xml_type, data_string, additional_info_ptr, version) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `alloc` might not allow `None`.
    /// - `orig_node` might not allow `None`.
    #[doc(alias = "CFXMLNodeCreateCopy")]
    #[deprecated = "CFXMLNode is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub unsafe fn new_copy(
        alloc: Option<&CFAllocator>,
        orig_node: Option<&CFXMLNode>,
    ) -> Option<CFRetained<CFXMLNode>> {
        extern "C-unwind" {
            fn CFXMLNodeCreateCopy(
                alloc: Option<&CFAllocator>,
                orig_node: Option<&CFXMLNode>,
            ) -> Option<NonNull<CFXMLNode>>;
        }
        let ret = unsafe { CFXMLNodeCreateCopy(alloc, orig_node) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFXMLNodeGetTypeCode")]
    #[deprecated = "CFXMLNode is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub fn type_code(&self) -> CFXMLNodeTypeCode {
        extern "C-unwind" {
            fn CFXMLNodeGetTypeCode(node: &CFXMLNode) -> CFXMLNodeTypeCode;
        }
        unsafe { CFXMLNodeGetTypeCode(self) }
    }

    #[doc(alias = "CFXMLNodeGetString")]
    #[deprecated = "CFXMLNode is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub fn string(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFXMLNodeGetString(node: &CFXMLNode) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFXMLNodeGetString(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFXMLNodeGetInfoPtr")]
    #[deprecated = "CFXMLNode is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub fn info_ptr(&self) -> *const c_void {
        extern "C-unwind" {
            fn CFXMLNodeGetInfoPtr(node: &CFXMLNode) -> *const c_void;
        }
        unsafe { CFXMLNodeGetInfoPtr(self) }
    }

    #[doc(alias = "CFXMLNodeGetVersion")]
    #[deprecated = "CFXMLNode is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
    #[inline]
    pub fn version(&self) -> CFIndex {
        extern "C-unwind" {
            fn CFXMLNodeGetVersion(node: &CFXMLNode) -> CFIndex;
        }
        unsafe { CFXMLNodeGetVersion(self) }
    }
}

/// # Safety
///
/// - `allocator` might not allow `None`.
/// - `node` might not allow `None`.
#[cfg(feature = "CFTree")]
#[deprecated = "CFXMLNode is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
#[inline]
pub unsafe extern "C-unwind" fn CFXMLTreeCreateWithNode(
    allocator: Option<&CFAllocator>,
    node: Option<&CFXMLNode>,
) -> Option<CFRetained<CFXMLTree>> {
    extern "C-unwind" {
        fn CFXMLTreeCreateWithNode(
            allocator: Option<&CFAllocator>,
            node: Option<&CFXMLNode>,
        ) -> Option<NonNull<CFXMLTree>>;
    }
    let ret = unsafe { CFXMLTreeCreateWithNode(allocator, node) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFTree")]
#[deprecated = "CFXMLNode is deprecated, use NSXMLParser, NSXMLDocument or libxml2 library instead"]
#[inline]
pub extern "C-unwind" fn CFXMLTreeGetNode(xml_tree: &CFXMLTree) -> Option<CFRetained<CFXMLNode>> {
    extern "C-unwind" {
        fn CFXMLTreeGetNode(xml_tree: &CFXMLTree) -> Option<NonNull<CFXMLNode>>;
    }
    let ret = unsafe { CFXMLTreeGetNode(xml_tree) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFXMLNode::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFXMLNodeCreate(
    alloc: Option<&CFAllocator>,
    xml_type: CFXMLNodeTypeCode,
    data_string: Option<&CFString>,
    additional_info_ptr: *const c_void,
    version: CFIndex,
) -> Option<CFRetained<CFXMLNode>> {
    extern "C-unwind" {
        fn CFXMLNodeCreate(
            alloc: Option<&CFAllocator>,
            xml_type: CFXMLNodeTypeCode,
            data_string: Option<&CFString>,
            additional_info_ptr: *const c_void,
            version: CFIndex,
        ) -> Option<NonNull<CFXMLNode>>;
    }
    let ret =
        unsafe { CFXMLNodeCreate(alloc, xml_type, data_string, additional_info_ptr, version) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFXMLNode::new_copy`"]
#[inline]
pub unsafe extern "C-unwind" fn CFXMLNodeCreateCopy(
    alloc: Option<&CFAllocator>,
    orig_node: Option<&CFXMLNode>,
) -> Option<CFRetained<CFXMLNode>> {
    extern "C-unwind" {
        fn CFXMLNodeCreateCopy(
            alloc: Option<&CFAllocator>,
            orig_node: Option<&CFXMLNode>,
        ) -> Option<NonNull<CFXMLNode>>;
    }
    let ret = unsafe { CFXMLNodeCreateCopy(alloc, orig_node) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFXMLNode::type_code`"]
#[inline]
pub extern "C-unwind" fn CFXMLNodeGetTypeCode(node: &CFXMLNode) -> CFXMLNodeTypeCode {
    extern "C-unwind" {
        fn CFXMLNodeGetTypeCode(node: &CFXMLNode) -> CFXMLNodeTypeCode;
    }
    unsafe { CFXMLNodeGetTypeCode(node) }
}

#[deprecated = "renamed to `CFXMLNode::string`"]
#[inline]
pub extern "C-unwind" fn CFXMLNodeGetString(node: &CFXMLNode) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFXMLNodeGetString(node: &CFXMLNode) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFXMLNodeGetString(node) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFXMLNode::info_ptr`"]
#[inline]
pub extern "C-unwind" fn CFXMLNodeGetInfoPtr(node: &CFXMLNode) -> *const c_void {
    extern "C-unwind" {
        fn CFXMLNodeGetInfoPtr(node: &CFXMLNode) -> *const c_void;
    }
    unsafe { CFXMLNodeGetInfoPtr(node) }
}

#[deprecated = "renamed to `CFXMLNode::version`"]
#[inline]
pub extern "C-unwind" fn CFXMLNodeGetVersion(node: &CFXMLNode) -> CFIndex {
    extern "C-unwind" {
        fn CFXMLNodeGetVersion(node: &CFXMLNode) -> CFIndex;
    }
    unsafe { CFXMLNodeGetVersion(node) }
}
