/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaComboBoxRendererInternal;
import com.apple.laf.AquaFileSystemModel;
import com.apple.laf.AquaFileView;
import com.apple.laf.AquaGroupBorder;
import com.apple.laf.AquaTableHeaderBorder;
import com.apple.laf.AquaUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.swing.SwingUtilities2;

public class AquaFileChooserUI
extends FileChooserUI {
    protected Icon directoryIcon = null;
    protected Icon fileIcon = null;
    protected Icon computerIcon = null;
    protected Icon hardDriveIcon = null;
    protected Icon floppyDriveIcon = null;
    protected Icon upFolderIcon = null;
    protected Icon homeFolderIcon = null;
    protected Icon listViewIcon = null;
    protected Icon detailsViewIcon = null;
    protected int saveButtonMnemonic = 0;
    protected int openButtonMnemonic = 0;
    protected int cancelButtonMnemonic = 0;
    protected int updateButtonMnemonic = 0;
    protected int helpButtonMnemonic = 0;
    protected int chooseButtonMnemonic = 0;
    private String saveTitleText = null;
    private String openTitleText = null;
    String newFolderTitleText = null;
    protected String saveButtonText = null;
    protected String openButtonText = null;
    protected String cancelButtonText = null;
    protected String updateButtonText = null;
    protected String helpButtonText = null;
    protected String newFolderButtonText = null;
    protected String chooseButtonText = null;
    String newFolderErrorText = null;
    String newFolderExistsErrorText = null;
    protected String fileDescriptionText = null;
    protected String directoryDescriptionText = null;
    protected String saveButtonToolTipText = null;
    protected String openButtonToolTipText = null;
    protected String cancelButtonToolTipText = null;
    protected String updateButtonToolTipText = null;
    protected String helpButtonToolTipText = null;
    protected String chooseItemButtonToolTipText = null;
    protected String chooseFolderButtonToolTipText = null;
    protected String directoryComboBoxToolTipText = null;
    protected String filenameTextFieldToolTipText = null;
    protected String filterComboBoxToolTipText = null;
    protected String openDirectoryButtonToolTipText = null;
    protected String cancelOpenButtonToolTipText = null;
    protected String cancelSaveButtonToolTipText = null;
    protected String cancelChooseButtonToolTipText = null;
    protected String cancelNewFolderButtonToolTipText = null;
    protected String desktopName = null;
    String newFolderDialogPrompt = null;
    String newFolderDefaultName = null;
    private String newFileDefaultName = null;
    String createButtonText = null;
    JFileChooser filechooser = null;
    private MouseListener doubleClickListener = null;
    private PropertyChangeListener propertyChangeListener = null;
    private AncestorListener ancestorListener = null;
    private DropTarget dragAndDropTarget = null;
    private final AcceptAllFileFilter acceptAllFileFilter = new AcceptAllFileFilter();
    private AquaFileSystemModel model;
    final AquaFileView fileView = new AquaFileView(this);
    boolean selectionInProgress = false;
    private JPanel accessoryPanel = null;
    JComboBox directoryComboBox;
    DirectoryComboBoxModel fDirectoryComboBoxModel;
    private final Action directoryComboBoxAction = new DirectoryComboBoxAction();
    JTextField filenameTextField;
    JTableExtension fFileList;
    private FilterComboBoxModel filterComboBoxModel;
    JComboBox filterComboBox;
    private final Action filterComboBoxAction = new FilterComboBoxAction();
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static final int PREF_WIDTH = 550;
    private static final int PREF_HEIGHT = 400;
    private static final int MIN_WIDTH = 400;
    private static final int MIN_HEIGHT = 250;
    private static final int LIST_MIN_WIDTH = 400;
    private static final int LIST_MIN_HEIGHT = 100;
    private static final Dimension LIST_MIN_SIZE = new Dimension(400, 100);
    static String fileNameLabelText = null;
    JLabel fTextFieldLabel = null;
    private static String filesOfTypeLabelText = null;
    private static String newFolderToolTipText = null;
    static String newFolderAccessibleName = null;
    private static final String[] fColumnNames = new String[2];
    JPanel fTextfieldPanel;
    private JPanel fDirectoryPanel;
    private Component fDirectoryPanelSpacer;
    private JPanel fBottomPanel;
    private FCSubpanel fSaveFilePanel = null;
    private FCSubpanel fOpenFilePanel = null;
    private FCSubpanel fOpenDirOrAnyPanel = null;
    private FCSubpanel fCustomFilePanel = null;
    private FCSubpanel fCustomDirOrAnyPanel = null;
    FCSubpanel fSubPanel = null;
    JButton fApproveButton;
    JButton fOpenButton;
    JButton fNewFolderButton;
    private JButton fCancelButton;
    private final ApproveSelectionAction fApproveSelectionAction = new ApproveSelectionAction();
    protected int fSortColumn = 0;
    protected int fPackageIsTraversable = -1;
    protected int fApplicationIsTraversable = -1;
    protected static final int sGlobalPackageIsTraversable;
    protected static final int sGlobalApplicationIsTraversable;
    protected static final String PACKAGE_TRAVERSABLE_PROPERTY = "JFileChooser.packageIsTraversable";
    protected static final String APPLICATION_TRAVERSABLE_PROPERTY = "JFileChooser.appBundleIsTraversable";
    protected static final String[] sTraversableProperties;
    protected static final int kOpenAlways = 0;
    protected static final int kOpenNever = 1;
    protected static final int kOpenConditional = 2;
    AbstractAction[] fButtonActions = new AbstractAction[]{this.fApproveSelectionAction, this.fApproveSelectionAction, new CancelSelectionAction(), new OpenSelectionAction(), null, new NewFolderAction()};
    static final String sDataPrefix = "FileChooser.";
    static final String[] sButtonKinds;
    static final String[] sButtonData;
    static final int kOpen = 0;
    static final int kSave = 1;
    static final int kCancel = 2;
    static final int kOpenDirectory = 3;
    static final int kHelp = 4;
    static final int kNewFolder = 5;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaFileChooserUI((JFileChooser)jComponent);
    }

    public AquaFileChooserUI(JFileChooser jFileChooser) {
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.accessoryPanel = new JPanel(new BorderLayout());
        this.filechooser = (JFileChooser)jComponent;
        this.createModel();
        this.installDefaults(this.filechooser);
        this.installComponents(this.filechooser);
        this.installListeners(this.filechooser);
        AquaUtils.enforceComponentOrientation(this.filechooser, ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.accessoryPanel = null;
        this.getFileChooser().removeAll();
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.doubleClickListener = this.createDoubleClickListener(jFileChooser, this.fFileList);
        this.fFileList.addMouseListener(this.doubleClickListener);
        this.propertyChangeListener = this.createPropertyChangeListener(jFileChooser);
        if (this.propertyChangeListener != null) {
            jFileChooser.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.ancestorListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                AquaFileChooserUI.this.setFocusForMode(AquaFileChooserUI.this.getFileChooser());
                AquaFileChooserUI.this.setDefaultButtonForMode(AquaFileChooserUI.this.getFileChooser());
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        };
        jFileChooser.addAncestorListener(this.ancestorListener);
        jFileChooser.registerKeyboardAction(new CancelSelectionAction(), KeyStroke.getKeyStroke(27, 0), 1);
        this.dragAndDropTarget = new DropTarget(jFileChooser, 1, new DnDHandler(), true);
        jFileChooser.setDropTarget(this.dragAndDropTarget);
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        if (this.propertyChangeListener != null) {
            jFileChooser.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.fFileList.removeMouseListener(this.doubleClickListener);
        jFileChooser.removePropertyChangeListener(this.filterComboBoxModel);
        jFileChooser.removePropertyChangeListener(this.model);
        jFileChooser.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        jFileChooser.removeAncestorListener(this.ancestorListener);
        jFileChooser.setDropTarget(null);
        this.ancestorListener = null;
    }

    protected void installDefaults(JFileChooser jFileChooser) {
        this.installIcons(jFileChooser);
        this.installStrings(jFileChooser);
        this.setPackageIsTraversable(jFileChooser.getClientProperty(PACKAGE_TRAVERSABLE_PROPERTY));
        this.setApplicationIsTraversable(jFileChooser.getClientProperty(APPLICATION_TRAVERSABLE_PROPERTY));
    }

    protected void installIcons(JFileChooser jFileChooser) {
        this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.fileIcon = UIManager.getIcon("FileView.fileIcon");
        this.computerIcon = UIManager.getIcon("FileView.computerIcon");
        this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
    }

    String getString(String string, String string2) {
        String string3 = UIManager.getString(string);
        return string3 == null ? string2 : string3;
    }

    protected void installStrings(JFileChooser jFileChooser) {
        this.fileDescriptionText = UIManager.getString("FileChooser.fileDescriptionText");
        this.directoryDescriptionText = UIManager.getString("FileChooser.directoryDescriptionText");
        this.newFolderErrorText = this.getString("FileChooser.newFolderErrorText", "Error occurred during folder creation");
        this.saveButtonText = UIManager.getString("FileChooser.saveButtonText");
        this.openButtonText = UIManager.getString("FileChooser.openButtonText");
        this.cancelButtonText = UIManager.getString("FileChooser.cancelButtonText");
        this.updateButtonText = UIManager.getString("FileChooser.updateButtonText");
        this.helpButtonText = UIManager.getString("FileChooser.helpButtonText");
        this.saveButtonMnemonic = UIManager.getInt("FileChooser.saveButtonMnemonic");
        this.openButtonMnemonic = UIManager.getInt("FileChooser.openButtonMnemonic");
        this.cancelButtonMnemonic = UIManager.getInt("FileChooser.cancelButtonMnemonic");
        this.updateButtonMnemonic = UIManager.getInt("FileChooser.updateButtonMnemonic");
        this.helpButtonMnemonic = UIManager.getInt("FileChooser.helpButtonMnemonic");
        this.chooseButtonMnemonic = UIManager.getInt("FileChooser.chooseButtonMnemonic");
        this.saveButtonToolTipText = UIManager.getString("FileChooser.saveButtonToolTipText");
        this.openButtonToolTipText = UIManager.getString("FileChooser.openButtonToolTipText");
        this.cancelButtonToolTipText = UIManager.getString("FileChooser.cancelButtonToolTipText");
        this.updateButtonToolTipText = UIManager.getString("FileChooser.updateButtonToolTipText");
        this.helpButtonToolTipText = UIManager.getString("FileChooser.helpButtonToolTipText");
        this.saveTitleText = this.getString("FileChooser.saveTitleText", this.saveButtonText);
        this.openTitleText = this.getString("FileChooser.openTitleText", this.openButtonText);
        this.newFolderExistsErrorText = this.getString("FileChooser.newFolderExistsErrorText", "That name is already taken");
        this.chooseButtonText = this.getString("FileChooser.chooseButtonText", "Choose");
        this.newFolderButtonText = this.getString("FileChooser.newFolderButtonText", "New");
        this.newFolderTitleText = this.getString("FileChooser.newFolderTitleText", "New Folder");
        fileNameLabelText = jFileChooser.getDialogType() == 1 ? this.getString("FileChooser.saveDialogFileNameLabelText", "Save As:") : this.getString("FileChooser.fileNameLabelText", "Name:");
        filesOfTypeLabelText = this.getString("FileChooser.filesOfTypeLabelText", "Format:");
        this.desktopName = this.getString("FileChooser.desktopName", "Desktop");
        this.newFolderDialogPrompt = this.getString("FileChooser.newFolderPromptText", "Name of new folder:");
        this.newFolderDefaultName = this.getString("FileChooser.untitledFolderName", "untitled folder");
        this.newFileDefaultName = this.getString("FileChooser.untitledFileName", "untitled");
        this.createButtonText = this.getString("FileChooser.createButtonText", "Create");
        AquaFileChooserUI.fColumnNames[1] = this.getString("FileChooser.byDateText", "Date Modified");
        AquaFileChooserUI.fColumnNames[0] = this.getString("FileChooser.byNameText", "Name");
        this.chooseItemButtonToolTipText = UIManager.getString("FileChooser.chooseItemButtonToolTipText");
        this.chooseFolderButtonToolTipText = UIManager.getString("FileChooser.chooseFolderButtonToolTipText");
        this.openDirectoryButtonToolTipText = UIManager.getString("FileChooser.openDirectoryButtonToolTipText");
        this.directoryComboBoxToolTipText = UIManager.getString("FileChooser.directoryComboBoxToolTipText");
        this.filenameTextFieldToolTipText = UIManager.getString("FileChooser.filenameTextFieldToolTipText");
        this.filterComboBoxToolTipText = UIManager.getString("FileChooser.filterComboBoxToolTipText");
        this.cancelOpenButtonToolTipText = UIManager.getString("FileChooser.cancelOpenButtonToolTipText");
        this.cancelSaveButtonToolTipText = UIManager.getString("FileChooser.cancelSaveButtonToolTipText");
        this.cancelChooseButtonToolTipText = UIManager.getString("FileChooser.cancelChooseButtonToolTipText");
        this.cancelNewFolderButtonToolTipText = UIManager.getString("FileChooser.cancelNewFolderButtonToolTipText");
        this.newFolderTitleText = UIManager.getString("FileChooser.newFolderTitleText");
        newFolderToolTipText = UIManager.getString("FileChooser.newFolderToolTipText");
        newFolderAccessibleName = this.getString("FileChooser.newFolderAccessibleName", this.newFolderTitleText);
    }

    protected void uninstallDefaults(JFileChooser jFileChooser) {
        this.uninstallIcons(jFileChooser);
        this.uninstallStrings(jFileChooser);
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
        this.directoryIcon = null;
        this.fileIcon = null;
        this.computerIcon = null;
        this.hardDriveIcon = null;
        this.floppyDriveIcon = null;
        this.upFolderIcon = null;
        this.homeFolderIcon = null;
        this.detailsViewIcon = null;
        this.listViewIcon = null;
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
        this.saveTitleText = null;
        this.openTitleText = null;
        this.newFolderTitleText = null;
        this.saveButtonText = null;
        this.openButtonText = null;
        this.cancelButtonText = null;
        this.updateButtonText = null;
        this.helpButtonText = null;
        this.newFolderButtonText = null;
        this.chooseButtonText = null;
        this.cancelOpenButtonToolTipText = null;
        this.cancelSaveButtonToolTipText = null;
        this.cancelChooseButtonToolTipText = null;
        this.cancelNewFolderButtonToolTipText = null;
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
        this.updateButtonToolTipText = null;
        this.helpButtonToolTipText = null;
        this.chooseItemButtonToolTipText = null;
        this.chooseFolderButtonToolTipText = null;
        this.openDirectoryButtonToolTipText = null;
        this.directoryComboBoxToolTipText = null;
        this.filenameTextFieldToolTipText = null;
        this.filterComboBoxToolTipText = null;
        this.newFolderDefaultName = null;
        this.newFileDefaultName = null;
        this.desktopName = null;
    }

    protected void createModel() {
    }

    AquaFileSystemModel getModel() {
        return this.model;
    }

    protected PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    File file = (File)propertyChangeEvent.getNewValue();
                    if (file != null) {
                        if (!AquaFileChooserUI.this.selectionInProgress && AquaFileChooserUI.this.getModel().contains(file)) {
                            AquaFileChooserUI.this.fFileList.setSelectedIndex(AquaFileChooserUI.this.getModel().indexOf(file));
                        }
                        if (!file.isDirectory()) {
                            AquaFileChooserUI.this.setFileName(AquaFileChooserUI.this.getFileChooser().getName(file));
                        }
                    }
                    AquaFileChooserUI.this.updateButtonState(AquaFileChooserUI.this.getFileChooser());
                } else if (string.equals("SelectedFilesChangedProperty")) {
                    File[] fileArray;
                    JFileChooser jFileChooser = AquaFileChooserUI.this.getFileChooser();
                    if (!jFileChooser.isDirectorySelectionEnabled() && (fileArray = (File[])propertyChangeEvent.getNewValue()) != null) {
                        for (int n : AquaFileChooserUI.this.fFileList.getSelectedRows()) {
                            File file = (File)AquaFileChooserUI.this.fFileList.getValueAt(n, 0);
                            if (!jFileChooser.isTraversable(file)) continue;
                            AquaFileChooserUI.this.fFileList.removeSelectedIndex(n);
                        }
                    }
                } else if (string.equals("directoryChanged")) {
                    AquaFileChooserUI.this.fFileList.clearSelection();
                    File file = AquaFileChooserUI.this.getFileChooser().getCurrentDirectory();
                    if (file != null) {
                        AquaFileChooserUI.this.fDirectoryComboBoxModel.addItem(file);
                        AquaFileChooserUI.this.getAction(5).setEnabled(file.canWrite());
                    }
                    AquaFileChooserUI.this.updateButtonState(AquaFileChooserUI.this.getFileChooser());
                } else if (string.equals("fileSelectionChanged")) {
                    AquaFileChooserUI.this.fFileList.clearSelection();
                    AquaFileChooserUI.this.setBottomPanelForMode(AquaFileChooserUI.this.getFileChooser());
                } else if (string == "AccessoryChangedProperty") {
                    if (AquaFileChooserUI.this.getAccessoryPanel() != null) {
                        JComponent jComponent;
                        if (propertyChangeEvent.getOldValue() != null) {
                            AquaFileChooserUI.this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
                        }
                        if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                            AquaFileChooserUI.this.getAccessoryPanel().add((Component)jComponent, "Center");
                        }
                    }
                } else if (string == "ApproveButtonTextChangedProperty") {
                    AquaFileChooserUI.this.updateApproveButton(AquaFileChooserUI.this.getFileChooser());
                    AquaFileChooserUI.this.getFileChooser().invalidate();
                } else if (string == "DialogTypeChangedProperty") {
                    fileNameLabelText = AquaFileChooserUI.this.getFileChooser().getDialogType() == 1 ? AquaFileChooserUI.this.getString("FileChooser.saveDialogFileNameLabelText", "Save As:") : AquaFileChooserUI.this.getString("FileChooser.fileNameLabelText", "Name:");
                    AquaFileChooserUI.this.fTextFieldLabel.setText(fileNameLabelText);
                    AquaFileChooserUI.this.setBottomPanelForMode(AquaFileChooserUI.this.getFileChooser());
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    AquaFileChooserUI.this.getApproveButton(AquaFileChooserUI.this.getFileChooser()).setMnemonic(AquaFileChooserUI.this.getApproveButtonMnemonic(AquaFileChooserUI.this.getFileChooser()));
                } else if (string.equals(AquaFileChooserUI.PACKAGE_TRAVERSABLE_PROPERTY)) {
                    AquaFileChooserUI.this.setPackageIsTraversable(propertyChangeEvent.getNewValue());
                } else if (string.equals(AquaFileChooserUI.APPLICATION_TRAVERSABLE_PROPERTY)) {
                    AquaFileChooserUI.this.setApplicationIsTraversable(propertyChangeEvent.getNewValue());
                } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
                    if (AquaFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                        AquaFileChooserUI.this.fFileList.getSelectionModel().setSelectionMode(2);
                    } else {
                        AquaFileChooserUI.this.fFileList.getSelectionModel().setSelectionMode(0);
                    }
                } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                    AquaFileChooserUI.this.doControlButtonsChanged(propertyChangeEvent);
                }
            }
        };
    }

    void setPackageIsTraversable(Object object) {
        int n = -1;
        if (object != null && object instanceof String) {
            n = AquaFileChooserUI.parseTraversableProperty((String)object);
        }
        this.fPackageIsTraversable = n != -1 ? n : sGlobalPackageIsTraversable;
    }

    void setApplicationIsTraversable(Object object) {
        int n = -1;
        if (object != null && object instanceof String) {
            n = AquaFileChooserUI.parseTraversableProperty((String)object);
        }
        this.fApplicationIsTraversable = n != -1 ? n : sGlobalApplicationIsTraversable;
    }

    void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.fBottomPanel.add(this.fDirectoryPanelSpacer);
            this.fBottomPanel.add(this.fDirectoryPanel);
        } else {
            this.fBottomPanel.remove(this.fDirectoryPanelSpacer);
            this.fBottomPanel.remove(this.fDirectoryPanel);
        }
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public String getDirectoryName() {
        return null;
    }

    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    public void setDirectoryName(String string) {
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().invalidateFileCache();
        this.getModel().validateFileCache();
    }

    @Override
    public void ensureFileIsVisible(JFileChooser jFileChooser, final File file) {
        if (file == null) {
            this.fFileList.requestFocusInWindow();
            this.fFileList.ensureIndexIsVisible(-1);
            return;
        }
        this.getModel().runWhenDone(new Runnable(){

            @Override
            public void run() {
                AquaFileChooserUI.this.fFileList.requestFocusInWindow();
                AquaFileChooserUI.this.fFileList.ensureIndexIsVisible(AquaFileChooserUI.this.getModel().indexOf(file));
            }
        });
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.fApproveButton;
    }

    public int getApproveButtonMnemonic(JFileChooser jFileChooser) {
        return this.fSubPanel.getApproveButtonMnemonic(jFileChooser);
    }

    public String getApproveButtonToolTipText(JFileChooser jFileChooser) {
        return this.fSubPanel.getApproveButtonToolTipText(jFileChooser);
    }

    @Override
    public String getApproveButtonText(JFileChooser jFileChooser) {
        return this.fSubPanel.getApproveButtonText(jFileChooser);
    }

    protected String getCancelButtonToolTipText(JFileChooser jFileChooser) {
        return this.fSubPanel.getCancelButtonToolTipText(jFileChooser);
    }

    boolean isSelectableInList(File file) {
        return this.fSubPanel.isSelectableInList(this.getFileChooser(), file);
    }

    boolean isSelectableForMode(JFileChooser jFileChooser, File file) {
        if (file == null) {
            return false;
        }
        int n = jFileChooser.getFileSelectionMode();
        if (n == 2) {
            return true;
        }
        boolean bl = jFileChooser.isTraversable(file);
        if (n == 1) {
            return bl;
        }
        return !bl;
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new SelectionListener();
    }

    protected boolean openDirectory(File file) {
        if (this.getFileChooser().isTraversable(file)) {
            this.fFileList.clearSelection();
            File file2 = this.fileView.resolveAlias(file);
            this.getFileChooser().setCurrentDirectory(file2);
            this.updateButtonState(this.getFileChooser());
            return true;
        }
        return false;
    }

    protected MouseListener createDoubleClickListener(JFileChooser jFileChooser, JTableExtension jTableExtension) {
        return new DoubleClickListener(jTableExtension);
    }

    @Override
    public FileFilter getAcceptAllFileFilter(JFileChooser jFileChooser) {
        return this.acceptAllFileFilter;
    }

    @Override
    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    @Override
    public String getDialogTitle(JFileChooser jFileChooser) {
        if (jFileChooser.getDialogTitle() == null) {
            if (this.getFileChooser().getDialogType() == 0) {
                return this.openTitleText;
            }
            if (this.getFileChooser().getDialogType() == 1) {
                return this.saveTitleText;
            }
        }
        return jFileChooser.getDialogTitle();
    }

    File getFirstSelectedItem() {
        File file = null;
        int n = this.fFileList.getSelectedRow();
        if (n >= 0) {
            file = (File)((AquaFileSystemModel)this.fFileList.getModel()).getElementAt(n);
        }
        return file;
    }

    File makeFile(JFileChooser jFileChooser, String string) {
        FileSystemView fileSystemView;
        File file = null;
        if (string != null && !string.equals("") && !(file = (fileSystemView = jFileChooser.getFileSystemView()).createFileObject(string)).isAbsolute()) {
            file = fileSystemView.createFileObject(jFileChooser.getCurrentDirectory(), string);
        }
        return file;
    }

    boolean textfieldIsValid() {
        String string = this.getFileName();
        return string != null && !string.equals("");
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(550, 400);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(400, 250);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected ListCellRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new AquaComboBoxRendererInternal(this.directoryComboBox){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                File file = (File)object;
                if (file == null) {
                    this.setText("");
                    return this;
                }
                JFileChooser jFileChooser = AquaFileChooserUI.this.getFileChooser();
                this.setText(jFileChooser.getName(file));
                this.setIcon(jFileChooser.getIcon(file));
                return this;
            }
        };
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected ListCellRenderer createFilterComboBoxRenderer() {
        return new AquaComboBoxRendererInternal(this.filterComboBox){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                FileFilter fileFilter = (FileFilter)object;
                if (fileFilter != null) {
                    this.setText(fileFilter.getDescription());
                }
                return this;
            }
        };
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    private boolean containsFileFilter(Object object) {
        return Objects.equals(object, this.getFileChooser().getFileFilter());
    }

    public void installComponents(JFileChooser jFileChooser) {
        jFileChooser.setLayout(new BoxLayout(jFileChooser, 1));
        jFileChooser.add(Box.createRigidArea(vstrut10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jFileChooser.add(jPanel);
        jFileChooser.add(Box.createRigidArea(vstrut10));
        this.fTextfieldPanel = new JPanel();
        this.fTextfieldPanel.setLayout(new BorderLayout());
        this.fTextfieldPanel.setVisible(false);
        jPanel.add(this.fTextfieldPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1));
        this.fTextFieldLabel = new JLabel(fileNameLabelText);
        jPanel3.add(this.fTextFieldLabel);
        this.filenameTextField = new JTextField();
        this.fTextFieldLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.addActionListener(this.getAction(0));
        this.filenameTextField.addFocusListener(new SaveTextFocusListener());
        Dimension dimension = this.filenameTextField.getMinimumSize();
        Dimension dimension2 = new Dimension(250, (int)dimension.getHeight());
        this.filenameTextField.setPreferredSize(dimension2);
        this.filenameTextField.setMaximumSize(dimension2);
        jPanel3.add(this.filenameTextField);
        File file = jFileChooser.getSelectedFile();
        if (file != null) {
            this.setFileName(jFileChooser.getName(file));
        } else if (jFileChooser.getDialogType() == 1) {
            this.setFileName(this.newFileDefaultName);
        }
        jPanel2.add(jPanel3);
        JSeparator jSeparator = new JSeparator(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(((JComponent)this.getParent()).getWidth(), 3);
            }
        };
        jPanel2.add(Box.createRigidArea(new Dimension(1, 8)));
        jPanel2.add(jSeparator);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 7)));
        this.fTextfieldPanel.add((Component)jPanel2, "Center");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.fDirectoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.fDirectoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setToolTipText(this.directoryComboBoxToolTipText);
        dimension2 = new Dimension(250, (int)this.directoryComboBox.getMinimumSize().getHeight());
        this.directoryComboBox.setPreferredSize(dimension2);
        this.directoryComboBox.setMaximumSize(dimension2);
        jPanel.add(this.directoryComboBox);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jFileChooser.add(jPanel4);
        JComponent jComponent = jFileChooser.getAccessory();
        if (jComponent != null) {
            this.getAccessoryPanel().add(jComponent);
        }
        jPanel4.add((Component)this.getAccessoryPanel(), "Before");
        JPanel jPanel5 = this.createList(jFileChooser);
        jPanel5.setMinimumSize(LIST_MIN_SIZE);
        jPanel4.add((Component)jPanel5, "Center");
        this.fBottomPanel = new JPanel();
        this.fBottomPanel.setLayout(new BoxLayout(this.fBottomPanel, 1));
        jFileChooser.add(this.fBottomPanel);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        jPanel2.setBorder(AquaGroupBorder.getTitlelessBorder());
        JLabel jLabel = new JLabel(filesOfTypeLabelText);
        jPanel2.add(jLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox<FileFilter>(this.filterComboBoxModel);
        jLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        dimension2 = new Dimension(220, (int)this.filterComboBox.getMinimumSize().getHeight());
        this.filterComboBox.setPreferredSize(dimension2);
        this.filterComboBox.setMaximumSize(dimension2);
        this.filterComboBox.addActionListener(this.filterComboBoxAction);
        this.filterComboBox.setOpaque(false);
        jPanel2.add(this.filterComboBox);
        this.fBottomPanel.add(jPanel2);
        this.fDirectoryPanel = new JPanel();
        this.fDirectoryPanel.setLayout(new BoxLayout(this.fDirectoryPanel, 3));
        JPanel jPanel6 = new JPanel(new BorderLayout());
        JPanel jPanel7 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel7.add(Box.createHorizontalStrut(20));
        this.fNewFolderButton = this.createNewFolderButton();
        jPanel7.add(this.fNewFolderButton);
        jPanel6.add((Component)jPanel7, "Before");
        JPanel jPanel8 = new JPanel(new FlowLayout(4, 0, 0));
        this.fOpenButton = this.createButton(3, this.openButtonText);
        jPanel8.add(this.fOpenButton);
        jPanel8.add(Box.createHorizontalStrut(8));
        this.fCancelButton = this.createButton(2, null);
        jPanel8.add(this.fCancelButton);
        jPanel8.add(Box.createHorizontalStrut(8));
        this.fApproveButton = new JButton();
        this.fApproveButton.addActionListener(this.fApproveSelectionAction);
        jPanel8.add(this.fApproveButton);
        jPanel8.add(Box.createHorizontalStrut(20));
        jPanel6.add((Component)jPanel8, "After");
        this.fDirectoryPanel.add(Box.createVerticalStrut(5));
        this.fDirectoryPanel.add(jPanel6);
        this.fDirectoryPanel.add(Box.createVerticalStrut(12));
        this.fDirectoryPanelSpacer = Box.createRigidArea(hstrut10);
        if (jFileChooser.getControlButtonsAreShown()) {
            this.fBottomPanel.add(this.fDirectoryPanelSpacer);
            this.fBottomPanel.add(this.fDirectoryPanel);
        }
        this.setBottomPanelForMode(jFileChooser);
        this.filenameTextField.getDocument().addDocumentListener(new SaveTextDocumentListener());
    }

    void setDefaultButtonForMode(JFileChooser jFileChooser) {
        JButton jButton = this.fSubPanel.getDefaultButton(jFileChooser);
        JRootPane jRootPane = jButton.getRootPane();
        if (jRootPane != null) {
            jRootPane.setDefaultButton(jButton);
        }
    }

    void setFocusForMode(JFileChooser jFileChooser) {
        JComponent jComponent = this.fSubPanel.getFocusComponent(jFileChooser);
        if (jComponent != null) {
            jComponent.requestFocus();
        }
    }

    void updateButtonState(JFileChooser jFileChooser) {
        this.fSubPanel.updateButtonState(jFileChooser, this.getFirstSelectedItem());
        this.updateApproveButton(jFileChooser);
    }

    void updateApproveButton(JFileChooser jFileChooser) {
        this.fApproveButton.setText(this.getApproveButtonText(jFileChooser));
        this.fApproveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.fApproveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.fCancelButton.setToolTipText(this.getCancelButtonToolTipText(jFileChooser));
    }

    synchronized FCSubpanel getSaveFilePanel() {
        if (this.fSaveFilePanel == null) {
            this.fSaveFilePanel = new SaveFilePanel();
        }
        return this.fSaveFilePanel;
    }

    synchronized FCSubpanel getOpenFilePanel() {
        if (this.fOpenFilePanel == null) {
            this.fOpenFilePanel = new OpenFilePanel();
        }
        return this.fOpenFilePanel;
    }

    synchronized FCSubpanel getOpenDirOrAnyPanel() {
        if (this.fOpenDirOrAnyPanel == null) {
            this.fOpenDirOrAnyPanel = new OpenDirOrAnyPanel();
        }
        return this.fOpenDirOrAnyPanel;
    }

    synchronized FCSubpanel getCustomFilePanel() {
        if (this.fCustomFilePanel == null) {
            this.fCustomFilePanel = new CustomFilePanel();
        }
        return this.fCustomFilePanel;
    }

    synchronized FCSubpanel getCustomDirOrAnyPanel() {
        if (this.fCustomDirOrAnyPanel == null) {
            this.fCustomDirOrAnyPanel = new CustomDirOrAnyPanel();
        }
        return this.fCustomDirOrAnyPanel;
    }

    void setBottomPanelForMode(JFileChooser jFileChooser) {
        if (jFileChooser.getDialogType() == 1) {
            this.fSubPanel = this.getSaveFilePanel();
        } else if (jFileChooser.getDialogType() == 0) {
            this.fSubPanel = jFileChooser.getFileSelectionMode() == 0 ? this.getOpenFilePanel() : this.getOpenDirOrAnyPanel();
        } else if (jFileChooser.getDialogType() == 2) {
            this.fSubPanel = jFileChooser.getFileSelectionMode() == 0 ? this.getCustomFilePanel() : this.getCustomDirOrAnyPanel();
        }
        this.fSubPanel.installPanel(jFileChooser, true);
        this.updateApproveButton(jFileChooser);
        this.updateButtonState(jFileChooser);
        this.setDefaultButtonForMode(jFileChooser);
        this.setFocusForMode(jFileChooser);
        jFileChooser.invalidate();
    }

    JButton createNewFolderButton() {
        JButton jButton = new JButton(this.newFolderButtonText);
        jButton.setToolTipText(newFolderToolTipText);
        jButton.getAccessibleContext().setAccessibleName(newFolderAccessibleName);
        jButton.setHorizontalTextPosition(2);
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.addActionListener(this.getAction(5));
        return jButton;
    }

    JButton createButton(int n, String string) {
        if (string == null) {
            string = UIManager.getString(sDataPrefix + sButtonKinds[n] + sButtonData[0]);
        }
        int n2 = UIManager.getInt(sDataPrefix + sButtonKinds[n] + sButtonData[1]);
        String string2 = UIManager.getString(sDataPrefix + sButtonKinds[n] + sButtonData[2]);
        JButton jButton = new JButton(string);
        jButton.setMnemonic(n2);
        jButton.setToolTipText(string2);
        jButton.addActionListener(this.getAction(n));
        return jButton;
    }

    AbstractAction getAction(int n) {
        return this.fButtonActions[n];
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        this.fApproveButton.getUI().uninstallUI(this.fApproveButton);
        this.fOpenButton.getUI().uninstallUI(this.fOpenButton);
        this.fNewFolderButton.getUI().uninstallUI(this.fNewFolderButton);
        this.fCancelButton.getUI().uninstallUI(this.fCancelButton);
        this.directoryComboBox.getUI().uninstallUI(this.directoryComboBox);
        this.filterComboBox.getUI().uninstallUI(this.filterComboBox);
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.fFileList = new JTableExtension();
        this.fFileList.setToolTipText(null);
        this.fFileList.addMouseListener(new FileListMouseListener());
        this.model = new AquaFileSystemModel(jFileChooser, this.fFileList, fColumnNames);
        MacListSelectionModel macListSelectionModel = new MacListSelectionModel(this.model);
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            macListSelectionModel.setSelectionMode(2);
        } else {
            macListSelectionModel.setSelectionMode(0);
        }
        this.fFileList.setModel(this.model);
        this.fFileList.setSelectionModel(macListSelectionModel);
        this.fFileList.getSelectionModel().addListSelectionListener(this.createListSelectionListener(jFileChooser));
        jFileChooser.addPropertyChangeListener(this.model);
        this.fFileList.addFocusListener(new SaveTextFocusListener());
        JSortingTableHeader jSortingTableHeader = new JSortingTableHeader(this.fFileList.getColumnModel());
        this.fFileList.setTableHeader(jSortingTableHeader);
        this.fFileList.setRowMargin(0);
        this.fFileList.setIntercellSpacing(new Dimension(0, 1));
        this.fFileList.setShowVerticalLines(false);
        this.fFileList.setShowHorizontalLines(false);
        Font font = this.fFileList.getFont();
        this.fFileList.setDefaultRenderer(File.class, new FileRenderer(font));
        this.fFileList.setDefaultRenderer(Date.class, new DateRenderer(font));
        FontMetrics fontMetrics = this.fFileList.getFontMetrics(font);
        this.fFileList.setRowHeight(Math.max(fontMetrics.getHeight(), this.fileIcon.getIconHeight() + 2));
        this.fFileList.registerKeyboardAction(new CancelSelectionAction(), KeyStroke.getKeyStroke(27, 0), 0);
        this.fFileList.registerKeyboardAction(new DefaultButtonAction(), KeyStroke.getKeyStroke(10, 0), 0);
        this.fFileList.setDropTarget(this.dragAndDropTarget);
        JScrollPane jScrollPane = new JScrollPane(this.fFileList, 22, 30);
        jScrollPane.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        jScrollPane.setCorner("UPPER_TRAILING_CORNER", new ScrollPaneCornerPanel());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    static int parseTraversableProperty(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < sTraversableProperties.length; ++i) {
            if (!string.equals(sTraversableProperties[i])) continue;
            return i;
        }
        return -1;
    }

    static {
        sTraversableProperties = new String[]{"always", "never", "conditional"};
        Object object = UIManager.get(PACKAGE_TRAVERSABLE_PROPERTY);
        sGlobalPackageIsTraversable = object != null && object instanceof String ? AquaFileChooserUI.parseTraversableProperty((String)object) : 2;
        object = UIManager.get(APPLICATION_TRAVERSABLE_PROPERTY);
        sGlobalApplicationIsTraversable = object != null && object instanceof String ? AquaFileChooserUI.parseTraversableProperty((String)object) : 2;
        sButtonKinds = new String[]{"openButton", "saveButton", "cancelButton", "openDirectoryButton", "helpButton", "newFolderButton"};
        sButtonData = new String[]{"Text", "Mnemonic", "ToolTipText"};
    }

    class JTableExtension
    extends JTable {
        JTableExtension() {
        }

        public void setSelectedIndex(int n) {
            this.getSelectionModel().setSelectionInterval(n, n);
        }

        public void removeSelectedIndex(int n) {
            this.getSelectionModel().removeSelectionInterval(n, n);
        }

        public void ensureIndexIsVisible(int n) {
            Rectangle rectangle = this.getCellRect(n, 0, false);
            if (rectangle != null) {
                this.scrollRectToVisible(rectangle);
            }
        }

        public int locationToIndex(Point point) {
            return this.rowAtPoint(point);
        }
    }

    class MacListSelectionModel
    extends DefaultListSelectionModel {
        AquaFileSystemModel fModel;

        MacListSelectionModel(AquaFileSystemModel aquaFileSystemModel) {
            this.fModel = aquaFileSystemModel;
        }

        boolean isSelectableInListIndex(int n) {
            File file = (File)this.fModel.getValueAt(n, 0);
            return file != null && AquaFileChooserUI.this.isSelectableInList(file);
        }

        void verifySelectionInterval(int n, int n2, boolean bl) {
            int n3;
            if (n > n2) {
                n3 = n2;
                n2 = n;
                n = n3;
            }
            n3 = n;
            while (true) {
                if (n3 <= n2 && !this.isSelectableInListIndex(n3)) {
                    ++n3;
                    continue;
                }
                int n4 = -1;
                int n5 = n3;
                while (n5 <= n2 && this.isSelectableInListIndex(n5)) {
                    n4 = n5++;
                }
                if (n4 < 0) break;
                if (bl) {
                    super.setSelectionInterval(n3, n4);
                    bl = false;
                } else {
                    super.addSelectionInterval(n3, n4);
                }
                if ((n3 = n4 + 1) > n2) break;
            }
        }

        @Override
        public void setAnchorSelectionIndex(int n) {
            if (this.isSelectableInListIndex(n)) {
                super.setAnchorSelectionIndex(n);
            }
        }

        @Override
        public void setLeadSelectionIndex(int n) {
            if (this.isSelectableInListIndex(n)) {
                super.setLeadSelectionIndex(n);
            }
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return;
            }
            if (this.getSelectionMode() == 0 || n == n2) {
                if (this.isSelectableInListIndex(n2)) {
                    super.setSelectionInterval(n2, n2);
                }
            } else {
                this.verifySelectionInterval(n, n2, true);
            }
        }

        @Override
        public void addSelectionInterval(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return;
            }
            if (n == n2) {
                if (this.isSelectableInListIndex(n2)) {
                    super.addSelectionInterval(n2, n2);
                }
                return;
            }
            if (this.getSelectionMode() != 2) {
                this.setSelectionInterval(n, n2);
                return;
            }
            this.verifySelectionInterval(n, n2, false);
        }
    }

    class CustomDirOrAnyPanel
    extends DirOrAnyPanel {
        CustomDirOrAnyPanel() {
        }

        @Override
        void installPanel(JFileChooser jFileChooser, boolean bl) {
            super.installPanel(jFileChooser, bl);
            AquaFileChooserUI.this.fTextfieldPanel.setVisible(true);
            AquaFileChooserUI.this.fNewFolderButton.setVisible(true);
        }

        @Override
        void approveSelection(JFileChooser jFileChooser) {
            File file = AquaFileChooserUI.this.makeFile(jFileChooser, AquaFileChooserUI.this.getFileName());
            if (file != null) {
                AquaFileChooserUI.this.selectionInProgress = true;
                AquaFileChooserUI.this.getFileChooser().setSelectedFile(file);
                AquaFileChooserUI.this.selectionInProgress = false;
            }
            AquaFileChooserUI.this.getFileChooser().approveSelection();
        }

        @Override
        void updateButtonState(JFileChooser jFileChooser, File file) {
            AquaFileChooserUI.this.getApproveButton(jFileChooser).setEnabled(file != null || AquaFileChooserUI.this.textfieldIsValid());
            super.updateButtonState(jFileChooser, file);
        }
    }

    class OpenDirOrAnyPanel
    extends DirOrAnyPanel {
        OpenDirOrAnyPanel() {
        }

        @Override
        void installPanel(JFileChooser jFileChooser, boolean bl) {
            super.installPanel(jFileChooser, bl);
            AquaFileChooserUI.this.fTextfieldPanel.setVisible(false);
            AquaFileChooserUI.this.fNewFolderButton.setVisible(false);
        }

        @Override
        JComponent getFocusComponent(JFileChooser jFileChooser) {
            return AquaFileChooserUI.this.fFileList;
        }

        @Override
        int getApproveButtonMnemonic(JFileChooser jFileChooser) {
            return AquaFileChooserUI.this.chooseButtonMnemonic;
        }

        @Override
        String getApproveButtonToolTipText(JFileChooser jFileChooser) {
            String string = jFileChooser.getFileSelectionMode() == 1 ? AquaFileChooserUI.this.chooseFolderButtonToolTipText : AquaFileChooserUI.this.chooseItemButtonToolTipText;
            return this.getApproveButtonToolTipText(jFileChooser, string);
        }

        @Override
        void updateButtonState(JFileChooser jFileChooser, File file) {
            AquaFileChooserUI.this.getApproveButton(jFileChooser).setEnabled(file != null);
            super.updateButtonState(jFileChooser, file);
        }
    }

    abstract class DirOrAnyPanel
    extends FCSubpanel {
        DirOrAnyPanel() {
        }

        @Override
        void installPanel(JFileChooser jFileChooser, boolean bl) {
            AquaFileChooserUI.this.fOpenButton.setVisible(false);
        }

        @Override
        JButton getDefaultButton(JFileChooser jFileChooser) {
            return AquaFileChooserUI.this.getApproveButton(jFileChooser);
        }

        @Override
        void updateButtonState(JFileChooser jFileChooser, File file) {
            AquaFileChooserUI.this.fOpenButton.setEnabled(false);
            AquaFileChooserUI.this.setDefaultButtonForMode(jFileChooser);
        }
    }

    class OpenFilePanel
    extends FCSubpanel {
        OpenFilePanel() {
        }

        @Override
        void installPanel(JFileChooser jFileChooser, boolean bl) {
            AquaFileChooserUI.this.fTextfieldPanel.setVisible(false);
            AquaFileChooserUI.this.fOpenButton.setVisible(false);
            AquaFileChooserUI.this.fNewFolderButton.setVisible(false);
            AquaFileChooserUI.this.setDefaultButtonForMode(jFileChooser);
        }

        boolean inOpenDirectoryMode(JFileChooser jFileChooser, File file) {
            return file != null && jFileChooser.isTraversable(file);
        }

        @Override
        JComponent getFocusComponent(JFileChooser jFileChooser) {
            return AquaFileChooserUI.this.fFileList;
        }

        @Override
        void updateButtonState(JFileChooser jFileChooser, File file) {
            boolean bl = file != null && !jFileChooser.isTraversable(file);
            AquaFileChooserUI.this.getApproveButton(jFileChooser).setEnabled(bl);
        }

        @Override
        boolean isSelectableInList(JFileChooser jFileChooser, File file) {
            return file != null && jFileChooser.accept(file);
        }

        @Override
        String getApproveButtonText(JFileChooser jFileChooser) {
            return this.getApproveButtonText(jFileChooser, AquaFileChooserUI.this.openButtonText);
        }

        @Override
        int getApproveButtonMnemonic(JFileChooser jFileChooser) {
            return AquaFileChooserUI.this.openButtonMnemonic;
        }

        @Override
        String getApproveButtonToolTipText(JFileChooser jFileChooser) {
            return this.getApproveButtonToolTipText(jFileChooser, AquaFileChooserUI.this.openButtonToolTipText);
        }

        @Override
        String getCancelButtonToolTipText(JFileChooser jFileChooser) {
            return AquaFileChooserUI.this.cancelOpenButtonToolTipText;
        }
    }

    class SaveFilePanel
    extends CustomFilePanel {
        SaveFilePanel() {
        }

        @Override
        void installPanel(JFileChooser jFileChooser, boolean bl) {
            AquaFileChooserUI.this.fTextfieldPanel.setVisible(true);
            AquaFileChooserUI.this.fOpenButton.setVisible(false);
            AquaFileChooserUI.this.fNewFolderButton.setVisible(true);
        }

        @Override
        boolean isSelectableInList(JFileChooser jFileChooser, File file) {
            return jFileChooser.accept(file) && jFileChooser.isTraversable(file);
        }

        @Override
        void approveSelection(JFileChooser jFileChooser) {
            File file = AquaFileChooserUI.this.makeFile(jFileChooser, AquaFileChooserUI.this.getFileName());
            if (file != null) {
                AquaFileChooserUI.this.selectionInProgress = true;
                AquaFileChooserUI.this.getFileChooser().setSelectedFile(file);
                AquaFileChooserUI.this.selectionInProgress = false;
                AquaFileChooserUI.this.getFileChooser().approveSelection();
            }
        }

        @Override
        void updateButtonState(JFileChooser jFileChooser, File file) {
            boolean bl = AquaFileChooserUI.this.textfieldIsValid();
            AquaFileChooserUI.this.getApproveButton(jFileChooser).setEnabled(bl);
        }

        @Override
        String getApproveButtonText(JFileChooser jFileChooser) {
            return this.getApproveButtonText(jFileChooser, AquaFileChooserUI.this.saveButtonText);
        }

        @Override
        int getApproveButtonMnemonic(JFileChooser jFileChooser) {
            return AquaFileChooserUI.this.saveButtonMnemonic;
        }

        @Override
        String getApproveButtonToolTipText(JFileChooser jFileChooser) {
            if (this.inOpenDirectoryMode(jFileChooser, AquaFileChooserUI.this.getFirstSelectedItem())) {
                return AquaFileChooserUI.this.openDirectoryButtonToolTipText;
            }
            return this.getApproveButtonToolTipText(jFileChooser, AquaFileChooserUI.this.saveButtonToolTipText);
        }

        @Override
        String getCancelButtonToolTipText(JFileChooser jFileChooser) {
            return AquaFileChooserUI.this.cancelSaveButtonToolTipText;
        }
    }

    class CustomFilePanel
    extends FCSubpanel {
        CustomFilePanel() {
        }

        @Override
        void installPanel(JFileChooser jFileChooser, boolean bl) {
            AquaFileChooserUI.this.fTextfieldPanel.setVisible(true);
            AquaFileChooserUI.this.fOpenButton.setVisible(false);
            AquaFileChooserUI.this.fNewFolderButton.setVisible(true);
        }

        boolean inOpenDirectoryMode(JFileChooser jFileChooser, File file) {
            boolean bl;
            boolean bl2 = bl = file != null && jFileChooser.isTraversable(file);
            if (AquaFileChooserUI.this.fFileList.hasFocus()) {
                return bl;
            }
            if (AquaFileChooserUI.this.textfieldIsValid()) {
                return false;
            }
            return bl;
        }

        @Override
        void approveSelection(JFileChooser jFileChooser) {
            File file = AquaFileChooserUI.this.getFirstSelectedItem();
            if (this.inOpenDirectoryMode(jFileChooser, file)) {
                AquaFileChooserUI.this.openDirectory(file);
            } else {
                file = AquaFileChooserUI.this.makeFile(jFileChooser, AquaFileChooserUI.this.getFileName());
                if (file != null) {
                    AquaFileChooserUI.this.selectionInProgress = true;
                    AquaFileChooserUI.this.getFileChooser().setSelectedFile(file);
                    AquaFileChooserUI.this.selectionInProgress = false;
                }
                AquaFileChooserUI.this.getFileChooser().approveSelection();
            }
        }

        @Override
        void updateButtonState(JFileChooser jFileChooser, File file) {
            boolean bl = true;
            if (!this.inOpenDirectoryMode(jFileChooser, file)) {
                bl = file != null || AquaFileChooserUI.this.textfieldIsValid();
            }
            AquaFileChooserUI.this.getApproveButton(jFileChooser).setEnabled(bl);
            AquaFileChooserUI.this.fOpenButton.setEnabled(file != null && jFileChooser.isTraversable(file));
            AquaFileChooserUI.this.setDefaultButtonForMode(jFileChooser);
        }

        @Override
        boolean isSelectableInList(JFileChooser jFileChooser, File file) {
            if (file == null) {
                return false;
            }
            return jFileChooser.accept(file);
        }

        @Override
        String getApproveButtonToolTipText(JFileChooser jFileChooser) {
            if (this.inOpenDirectoryMode(jFileChooser, AquaFileChooserUI.this.getFirstSelectedItem())) {
                return AquaFileChooserUI.this.openDirectoryButtonToolTipText;
            }
            return super.getApproveButtonToolTipText(jFileChooser);
        }
    }

    abstract class FCSubpanel {
        FCSubpanel() {
        }

        abstract void installPanel(JFileChooser var1, boolean var2);

        abstract void updateButtonState(JFileChooser var1, File var2);

        boolean isSelectableInList(JFileChooser jFileChooser, File file) {
            if (file == null) {
                return false;
            }
            if (jFileChooser.getFileSelectionMode() == 1) {
                return jFileChooser.isTraversable(file);
            }
            return jFileChooser.accept(file);
        }

        void approveSelection(JFileChooser jFileChooser) {
            jFileChooser.approveSelection();
        }

        JButton getDefaultButton(JFileChooser jFileChooser) {
            return AquaFileChooserUI.this.fApproveButton;
        }

        JComponent getFocusComponent(JFileChooser jFileChooser) {
            return AquaFileChooserUI.this.filenameTextField;
        }

        String getApproveButtonText(JFileChooser jFileChooser) {
            return this.getApproveButtonText(jFileChooser, AquaFileChooserUI.this.chooseButtonText);
        }

        String getApproveButtonText(JFileChooser jFileChooser, String string) {
            String string2 = jFileChooser.getApproveButtonText();
            if (string2 != null) {
                string2.trim();
                if (!string2.equals("")) {
                    return string2;
                }
            }
            return string;
        }

        int getApproveButtonMnemonic(JFileChooser jFileChooser) {
            return jFileChooser.getApproveButtonMnemonic();
        }

        String getApproveButtonToolTipText(JFileChooser jFileChooser) {
            return this.getApproveButtonToolTipText(jFileChooser, null);
        }

        String getApproveButtonToolTipText(JFileChooser jFileChooser, String string) {
            String string2 = jFileChooser.getApproveButtonToolTipText();
            if (string2 != null) {
                string2.trim();
                if (!string2.equals("")) {
                    return string2;
                }
            }
            return string;
        }

        String getCancelButtonToolTipText(JFileChooser jFileChooser) {
            return AquaFileChooserUI.this.cancelChooseButtonToolTipText;
        }
    }

    protected class ScrollPaneCornerPanel
    extends JPanel {
        final Border border = UIManager.getBorder("TableHeader.cellBorder");

        protected ScrollPaneCornerPanel() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            this.border.paintBorder(this, graphics, 0, 0, this.getWidth() + 1, this.getHeight());
        }
    }

    protected class FileListMouseListener
    extends MouseAdapter {
        protected FileListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = AquaFileChooserUI.this.fFileList.rowAtPoint(point);
            int n2 = AquaFileChooserUI.this.fFileList.columnAtPoint(point);
            if (n2 == -1 || n == -1) {
                return;
            }
            File file = (File)AquaFileChooserUI.this.fFileList.getValueAt(n, 0);
            if (AquaFileChooserUI.this.isSelectableForMode(AquaFileChooserUI.this.getFileChooser(), file)) {
                AquaFileChooserUI.this.setFileName(AquaFileChooserUI.this.fileView.getName(file));
            }
        }
    }

    class JSortingTableHeader
    extends JTableHeader {
        final boolean[] fSortAscending;

        public JSortingTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            this.fSortAscending = new boolean[]{true, true};
            this.setReorderingAllowed(true);
        }

        @Override
        public void setDraggedColumn(TableColumn tableColumn) {
            if (tableColumn != null) {
                int n = tableColumn.getModelIndex();
                if (n != AquaFileChooserUI.this.fSortColumn) {
                    AquaFileChooserUI.this.filechooser.firePropertyChange("sortByChanged", AquaFileChooserUI.this.fSortColumn, n);
                    AquaFileChooserUI.this.fSortColumn = n;
                } else {
                    this.fSortAscending[n] = !this.fSortAscending[n];
                    AquaFileChooserUI.this.filechooser.firePropertyChange("sortAscendingChanged", !this.fSortAscending[n], this.fSortAscending[n]);
                }
                this.repaint();
            }
        }

        @Override
        public TableColumn getDraggedColumn() {
            return null;
        }

        @Override
        protected TableCellRenderer createDefaultRenderer() {
            AquaTableCellRenderer aquaTableCellRenderer = new AquaTableCellRenderer();
            aquaTableCellRenderer.setHorizontalAlignment(2);
            return aquaTableCellRenderer;
        }

        class AquaTableCellRenderer
        extends DefaultTableCellRenderer
        implements UIResource {
            AquaTableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Serializable serializable;
                if (jTable != null && (serializable = jTable.getTableHeader()) != null) {
                    this.setForeground(((Component)serializable).getForeground());
                    this.setBackground(((Component)serializable).getBackground());
                    this.setFont(UIManager.getFont("TableHeader.font"));
                }
                this.setText(object == null ? "" : object.toString());
                serializable = AquaTableHeaderBorder.getListHeaderBorder();
                ((AquaTableHeaderBorder)serializable).setSelected(n2 == AquaFileChooserUI.this.fSortColumn);
                int n3 = n2 == 0 ? 35 : 10;
                ((AquaTableHeaderBorder)serializable).setHorizontalShift(n3);
                if (n2 == AquaFileChooserUI.this.fSortColumn) {
                    ((AquaTableHeaderBorder)serializable).setSortOrder(JSortingTableHeader.this.fSortAscending[n2] ? 1 : -1);
                } else {
                    ((AquaTableHeaderBorder)serializable).setSortOrder(0);
                }
                this.setBorder((Border)((Object)serializable));
                return this;
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AquaFileChooserUI.this.getFileChooser().setCurrentDirectory((File)AquaFileChooserUI.this.directoryComboBox.getSelectedItem());
        }
    }

    protected class FilterComboBoxAction
    extends AbstractAction {
        protected FilterComboBoxAction() {
            super("FilterComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = AquaFileChooserUI.this.filterComboBox.getSelectedItem();
            if (!AquaFileChooserUI.this.containsFileFilter(object)) {
                AquaFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
            }
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel<FileFilter>
    implements ComboBoxModel<FileFilter>,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = AquaFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.setSelectedItem(propertyChangeEvent.getNewValue());
            }
        }

        @Override
        public void setSelectedItem(Object object) {
            if (object != null && !AquaFileChooserUI.this.containsFileFilter(object)) {
                AquaFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter fileFilter = AquaFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                for (FileFilter fileFilter2 : this.filters) {
                    if (fileFilter2 != fileFilter) continue;
                    bl = true;
                }
                if (!bl) {
                    AquaFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return AquaFileChooserUI.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public FileFilter getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return AquaFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector<File> fDirectories = new Vector();
        int topIndex = -1;
        int fPathCount = 0;
        File fSelectedDirectory = null;

        public DirectoryComboBoxModel() {
            this.addItem(AquaFileChooserUI.this.getFileChooser().getCurrentDirectory());
        }

        private void removeSelectedDirectory() {
            this.fDirectories.removeAllElements();
            this.fPathCount = 0;
            this.fSelectedDirectory = null;
        }

        void addItem(File file) {
            File[] fileArray;
            if (file == null) {
                return;
            }
            if (this.fSelectedDirectory != null) {
                this.removeSelectedDirectory();
            }
            File file2 = file.getAbsoluteFile();
            Vector<File> vector = new Vector<File>(10);
            while (file2.getParent() != null) {
                vector.addElement(file2);
                file2 = AquaFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(file2.getParent());
            }
            for (File file3 : fileArray = AquaFileChooserUI.this.getFileChooser().getFileSystemView().getRoots()) {
                vector.addElement(file3);
            }
            this.fPathCount = vector.size();
            for (int i = 0; i < vector.size(); ++i) {
                this.fDirectories.addElement((File)vector.elementAt(i));
            }
            this.setSelectedItem(this.fDirectories.elementAt(0));
        }

        @Override
        public void setSelectedItem(Object object) {
            this.fSelectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.fSelectedDirectory;
        }

        @Override
        public int getSize() {
            return this.fDirectories.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.fDirectories.elementAt(n);
        }
    }

    protected class DateRenderer
    extends MacFCTableCellRenderer {
        public DateRenderer(Font font) {
            super(font);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
            File file = (File)AquaFileChooserUI.this.fFileList.getValueAt(n, 0);
            this.setEnabled(AquaFileChooserUI.this.isSelectableInList(file));
            DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 3);
            Date date = (Date)object;
            if (date != null) {
                this.setText(dateFormat.format(date));
            } else {
                this.setText("");
            }
            return this;
        }
    }

    protected class FileRenderer
    extends MacFCTableCellRenderer {
        public FileRenderer(Font font) {
            super(font);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
            File file = (File)object;
            JFileChooser jFileChooser = AquaFileChooserUI.this.getFileChooser();
            this.setText(jFileChooser.getName(file));
            this.setIcon(jFileChooser.getIcon(file));
            this.setEnabled(AquaFileChooserUI.this.isSelectableInList(file));
            return this;
        }
    }

    protected class MacFCTableCellRenderer
    extends DefaultTableCellRenderer {
        boolean fIsSelected = false;

        public MacFCTableCellRenderer(Font font) {
            this.setFont(font);
            this.setIconTextGap(10);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
            this.fIsSelected = bl;
            return this;
        }

        public boolean isSelected() {
            return this.fIsSelected && this.isEnabled();
        }

        protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
            return SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Object object;
            String string = this.getText();
            Icon icon = this.getIcon();
            if (icon != null && !this.isEnabled() && (object = this.getDisabledIcon()) != null) {
                icon = object;
            }
            if (icon == null && string == null) {
                return;
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            object = graphics.getFontMetrics();
            Insets insets = this.getInsets(null);
            insets.left += 10;
            Rectangle rectangle = new Rectangle(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            String string2 = this.layoutCL(this, (FontMetrics)object, string, icon, rectangle, rectangle2, rectangle3);
            if (icon != null) {
                icon.paintIcon(this, graphics, rectangle2.x + 5, rectangle2.y);
            }
            if (string != null) {
                int n = rectangle3.x;
                int n2 = rectangle3.y + ((FontMetrics)object).getAscent() + 1;
                if (this.isEnabled()) {
                    Color color = this.getBackground();
                    graphics.setColor(color);
                    graphics.fillRect(n - 1, rectangle3.y, rectangle3.width + 2, ((FontMetrics)object).getAscent() + 2);
                    graphics.setColor(this.getForeground());
                    SwingUtilities2.drawString((JComponent)AquaFileChooserUI.this.filechooser, graphics, string2, n, n2);
                } else {
                    Color color = this.getBackground();
                    graphics.setColor(color);
                    graphics.fillRect(n - 1, rectangle3.y, rectangle3.width + 2, ((FontMetrics)object).getAscent() + 2);
                    graphics.setColor(color.brighter());
                    SwingUtilities2.drawString((JComponent)AquaFileChooserUI.this.filechooser, graphics, string2, n, n2);
                    graphics.setColor(color.darker());
                    SwingUtilities2.drawString((JComponent)AquaFileChooserUI.this.filechooser, graphics, string2, n + 1, n2 + 1);
                }
            }
        }
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return true;
        }

        @Override
        public String getDescription() {
            return UIManager.getString("FileChooser.acceptAllFileFilterText");
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        protected UpdateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = AquaFileChooserUI.this.getFileChooser();
            jFileChooser.setCurrentDirectory(jFileChooser.getFileSystemView().createFileObject(AquaFileChooserUI.this.getDirectoryName()));
            jFileChooser.rescanCurrentDirectory();
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        protected CancelSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AquaFileChooserUI.this.getFileChooser().cancelSelection();
        }

        @Override
        public boolean isEnabled() {
            return AquaFileChooserUI.this.getFileChooser().isEnabled();
        }
    }

    protected class OpenSelectionAction
    extends AbstractAction {
        protected OpenSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            int n = AquaFileChooserUI.this.fFileList.getSelectedRow();
            if (n >= 0 && (file = (File)((AquaFileSystemModel)AquaFileChooserUI.this.fFileList.getModel()).getElementAt(n)) != null) {
                AquaFileChooserUI.this.openDirectory(file);
            }
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AquaFileChooserUI.this.fSubPanel.approveSelection(AquaFileChooserUI.this.getFileChooser());
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super(newFolderAccessibleName);
        }

        private Object showNewFolderDialog(Component component, Object object, String string, int n, Icon icon, Object[] objectArray, Object object2) {
            JOptionPane jOptionPane = new JOptionPane(object, n, 2, icon, objectArray, null);
            jOptionPane.setWantsInput(true);
            jOptionPane.setInitialSelectionValue(object2);
            JDialog jDialog = jOptionPane.createDialog(component, string);
            jOptionPane.selectInitialValue();
            jDialog.setVisible(true);
            jDialog.dispose();
            Object object3 = jOptionPane.getValue();
            if (object3 == null || object3.equals(AquaFileChooserUI.this.cancelButtonText)) {
                return null;
            }
            return jOptionPane.getInputValue();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = AquaFileChooserUI.this.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            File file2 = null;
            Object[] objectArray = new String[]{AquaFileChooserUI.this.createButtonText, AquaFileChooserUI.this.cancelButtonText};
            String string = (String)this.showNewFolderDialog(jFileChooser, AquaFileChooserUI.this.newFolderDialogPrompt, AquaFileChooserUI.this.newFolderTitleText, -1, null, objectArray, AquaFileChooserUI.this.newFolderDefaultName);
            if (string != null) {
                try {
                    file2 = jFileChooser.getFileSystemView().createFileObject(file, string);
                    if (file2.exists()) {
                        JOptionPane.showMessageDialog(jFileChooser, AquaFileChooserUI.this.newFolderExistsErrorText, "", 0);
                        return;
                    }
                    file2.mkdirs();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(jFileChooser, AquaFileChooserUI.this.newFolderErrorText, "", 0);
                    return;
                }
                AquaFileChooserUI.this.openDirectory(file2);
            }
        }
    }

    protected class DefaultButtonAction
    extends AbstractAction {
        protected DefaultButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRootPane jRootPane = AquaFileChooserUI.this.getFileChooser().getRootPane();
            JFileChooser jFileChooser = AquaFileChooserUI.this.getFileChooser();
            JButton jButton = jRootPane.getDefaultButton();
            if (jButton != null && SwingUtilities.getRootPane(jButton) == jRootPane && jButton.isEnabled()) {
                jButton.doClick(20);
            } else if (!jFileChooser.getControlButtonsAreShown()) {
                JButton jButton2 = AquaFileChooserUI.this.fSubPanel.getDefaultButton(jFileChooser);
                if (jButton2 != null) {
                    jButton2.doClick(20);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    class DnDHandler
    extends DropTargetAdapter {
        DnDHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this.tryToAcceptDrag(dropTargetDragEvent);
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            this.tryToAcceptDrag(dropTargetDragEvent);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            this.tryToAcceptDrag(dropTargetDragEvent);
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                this.handleFileDropEvent(dropTargetDropEvent);
                return;
            }
            if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                this.handleStringDropEvent(dropTargetDropEvent);
                return;
            }
        }

        protected void tryToAcceptDrag(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dropTargetDragEvent.acceptDrag(1);
                return;
            }
            dropTargetDragEvent.rejectDrag();
        }

        protected void handleFileDropEvent(DropTargetDropEvent dropTargetDropEvent) {
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                this.dropFiles(list.toArray(new File[list.size()]));
                dropTargetDropEvent.dropComplete(true);
            }
            catch (Exception exception) {
                dropTargetDropEvent.dropComplete(false);
            }
        }

        protected void handleStringDropEvent(DropTargetDropEvent dropTargetDropEvent) {
            File file;
            String string;
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            try {
                file = new File(string);
                if (file.exists()) {
                    this.dropFiles(new File[]{file});
                    dropTargetDropEvent.dropComplete(true);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                file = new File(new URI(string));
                if (file.exists()) {
                    this.dropFiles(new File[]{file});
                    dropTargetDropEvent.dropComplete(true);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            dropTargetDropEvent.dropComplete(false);
        }

        protected void dropFiles(final File[] fileArray) {
            JFileChooser jFileChooser = AquaFileChooserUI.this.getFileChooser();
            if (fileArray.length == 1) {
                if (fileArray[0].isDirectory()) {
                    jFileChooser.setCurrentDirectory(fileArray[0]);
                    return;
                }
                if (!AquaFileChooserUI.this.isSelectableForMode(jFileChooser, fileArray[0])) {
                    return;
                }
            }
            jFileChooser.setSelectedFiles(fileArray);
            for (File file : fileArray) {
                jFileChooser.ensureFileIsVisible(file);
            }
            AquaFileChooserUI.this.getModel().runWhenDone(new Runnable(){

                @Override
                public void run() {
                    AquaFileSystemModel aquaFileSystemModel = AquaFileChooserUI.this.getModel();
                    for (File file : fileArray) {
                        int n = aquaFileSystemModel.indexOf(file);
                        if (n < 0) continue;
                        AquaFileChooserUI.this.fFileList.addRowSelectionInterval(n, n);
                    }
                }
            });
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        JTableExtension list;

        public DoubleClickListener(JTableExtension jTableExtension) {
            this.list = jTableExtension;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 2) {
                return;
            }
            int n = this.list.locationToIndex(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            File file = (File)((AquaFileSystemModel)this.list.getModel()).getElementAt(n);
            if (AquaFileChooserUI.this.openDirectory(file)) {
                return;
            }
            if (!AquaFileChooserUI.this.isSelectableInList(file)) {
                return;
            }
            AquaFileChooserUI.this.getFileChooser().approveSelection();
        }
    }

    protected class SaveTextDocumentListener
    implements DocumentListener {
        protected SaveTextDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        void textChanged() {
            AquaFileChooserUI.this.updateButtonState(AquaFileChooserUI.this.getFileChooser());
        }
    }

    protected class SaveTextFocusListener
    implements FocusListener {
        protected SaveTextFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            AquaFileChooserUI.this.updateButtonState(AquaFileChooserUI.this.getFileChooser());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            File file = null;
            int n = AquaFileChooserUI.this.fFileList.getSelectedRow();
            JFileChooser jFileChooser = AquaFileChooserUI.this.getFileChooser();
            boolean bl2 = bl = jFileChooser.getDialogType() == 1;
            if (n >= 0) {
                file = (File)AquaFileChooserUI.this.fFileList.getValueAt(n, 0);
            }
            AquaFileChooserUI.this.selectionInProgress = true;
            if (!bl && jFileChooser.isMultiSelectionEnabled()) {
                int[] nArray = AquaFileChooserUI.this.fFileList.getSelectedRows();
                int n2 = 0;
                if (nArray.length > 0) {
                    for (int n3 : nArray) {
                        if (!AquaFileChooserUI.this.isSelectableForMode(jFileChooser, (File)AquaFileChooserUI.this.fFileList.getValueAt(n3, 0))) continue;
                        ++n2;
                    }
                }
                if (n2 > 0) {
                    File[] fileArray = new File[n2];
                    int n4 = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        file = (File)AquaFileChooserUI.this.fFileList.getValueAt(nArray[i], 0);
                        if (!AquaFileChooserUI.this.isSelectableForMode(jFileChooser, file)) continue;
                        if (AquaFileChooserUI.this.fileView.isAlias(file)) {
                            file = AquaFileChooserUI.this.fileView.resolveAlias(file);
                        }
                        fileArray[n4++] = file;
                    }
                    jFileChooser.setSelectedFiles(fileArray);
                } else {
                    jFileChooser.setSelectedFiles(null);
                }
            } else {
                jFileChooser.setSelectedFiles(null);
                jFileChooser.setSelectedFile(file);
            }
            AquaFileChooserUI.this.selectionInProgress = false;
        }
    }
}

