<script src="https://unpkg.com/mermaid@8.8.4/dist/mermaid.min.js"></script>
<script>
// Our loader looks for `mermaidConfig` and will load the the appropriate
// config based on our current scheme: light, dark, etc.
window.mermaidConfig = {
  dracula: {
    startOnLoad: false,
    theme: "base",
    themeCSS: "\
      {\
        --drac-page-bg: hsl(233, 15%, 23%);\
        --drac-white-fg: hsl(60, 30%, 96%);\
        --drac-purple-fg: hsl(265, 89%, 78%);\
        --drac-purple-bg: hsl(265, 25%, 39%);\
        --drac-yellow-fg: hsl(65, 92%, 76%);\
      }\
      \
      /* General */\
      {\
        background-color: var(--drac-page-bg);\
      }\
      \
      /* Entity Relationship */\
      defs marker#ZERO_OR_MORE_END circle {\
        fill: var(--drac-page-bg) !important;\
        stroke: var(--drac-purple-fg) !important;\
      }\
      defs marker#ZERO_OR_MORE_END path {\
        stroke: var(--drac-purple-fg) !important;\
      }\
      defs marker#ZERO_OR_MORE_START circle{\
        fill: var(--drac-page-bg) !important;\
        stroke: var(--drac-purple-fg) !important;\
      }\
      defs marker#ZERO_OR_MORE_START path {\
        stroke: var(--drac-purple-fg) !important;\
      }\
      defs marker#ONLY_ONE_START path {\
        stroke: var(--drac-purple-fg) !important;\
      }\
      defs marker#ONLY_ONE_END path {\
        stroke: var(--drac-purple-fg) !important;\
      }\
      defs marker#ZERO_OR_ONE_START path {\
        stroke: var(--drac-purple-fg) !important;\
      }\
      defs marker#ZERO_OR_ONE_END path {\
        stroke: var(--drac-purple-fg) !important;\
      }\
      defs marker#ONE_OR_MORE_START path {\
        stroke: var(--drac-purple-fg) !important;\
      }\
      defs marker#ONE_OR_MORE_END path {\
        stroke: var(--drac-purple-fg) !important;\
      }\
      \
      /* Flowchart */\
      .labelText,\
      .label text {\
        fill: var(--drac-purple-fg);\
      }\
      \
      .edgeLabel text {\
        fill: var(--drac-purple-fg) !important;\
      }\
      .edgeLabel rect {\
        opacity: 0.5 !important;\
        fill: var(--drac-purple-bg) !important;\
      }\
      \
      /* Sequence */\
      .noteText {\
        fill: var(--drac-yellow-fg);\
      }\
      \
      /* Gantt */\
      .sectionTitle {\
        fill: var(--drac-purple-fg) !important;\
      }\
      \
      .grid .tick line {\
        stroke: var(--drac-blue-fg) !important;\
      }\
      \
      .grid .tick text {\
        fill: var(--drac-purple-fg);\
      }\
      \
      /* Class Diagram */\
      .statediagram-state rect.divider {\
        fill: transparent !important;\
      }\
      \
      /* State Diagram */\
      .stateGroup circle[style$=\"fill: black;\"] {\
        fill: var(--drac-purple-bg) !important;\
        stroke: var(--drac-purple-bg) !important;\
      }\
      \
      .stateGroup circle[style$=\"fill: white;\"] {\
        fill: var(--drac-purple-bg) !important;\
        stroke: var(--drac-purple-fg) !important;\
      }\
      \
      .stateGroup .composit {\
        fill: var(--drac-page-bg);\
      }\
      /* Pie */\
      text.slice {\
        fill: var(--drac-white-fg) !important;\
      }\
      ",
    themeVariables: {
      darkMode: true,
      background: "#323443",
      mainBkg: "#604b7d",
      textColor: "#bf95f9",
      lineColor: "#bf95f9",
      errorBkgColor: "#802c2c",
      errorTextColor: "#ff5757",
      primaryColor: "#604b7d",
      primaryTextColor: "#bf95f9",
      primaryBorderColor: "#bf95f9",
      secondaryColor: "#297d3e",
      secondaryTextColor: "#52fa7c",
      secondaryBorderColor: "#52fa7c",
      tertiaryColor: "#303952",
      tertiaryTextColor: "#6071a4",
      tertiaryBorderColor: "#6071a4",
      noteBkgColor: "#797d45",
      noteTextColor: "#f1fa89",
      noteBorderColor: "#f1fa89",
      edgeLabelBackground: "#604b7d",
      edgeLabelText: "#604b7d",

      actorLineColor: "#6071a4",

      activeTaskBkgColor: "#803d63",
      activeTaskBorderColor: "#ff7ac6",
      doneTaskBkgColor: "#297d3e",
      doneTaskBorderColor: "#52fa7c",
      critBkgColor: "#802c2c",
      critBorderColor: "#ff5757",
      taskTextColor: "#bf95f9",
      taskTextOutsideColor: "#bf95f9",
      taskTextLightColor: "#bf95f9",
      sectionBkgColor: "#bf95f9b3",
      sectionBkgColor2: "#bf95f966",
      altSectionBkgColor: "#323443",
      todayLineColor: "#ff7ac6",
      gridColor: "#6071a4",
      defaultLinkColor: "#8be8fd",

      altBackground: "#bf95f9",

      classText: "#bf95f9",

      fillType0: "#406080",
      fillType1: "#46747f",
      fillType2: "#297d3e",
      fillType3: "#805c36",
      fillType4: "#803d63",
      fillType5: "#604b7d",
      fillType6: "#802c2c",
      fillType7: "#797d45",
      fillType8: "#7c7c79"
    },
    flowchart: {
      htmlLabels: false
    },
    er: {
      useMaxWidth: false
    },
    sequence: {
      useMaxWidth: false,
      // Mermaid handles Firefox a little different.
      // For some reason, it doesn't attach font sizes to the labels in Firefox.
      // If we specify the documented defaults, font sizes are written to the labels in Firefox.
      noteFontWeight: "14px",
      actorFontSize: "14px",
      messageFontSize: "16px"
    }
  },

  default: {
    startOnLoad: false,
    theme: "default",
    flowchart: {
      htmlLabels: false
    },
    er: {
      useMaxWidth: false
    },
    sequence: {
      useMaxWidth: false,
      noteFontWeight: "14px",
      actorFontSize: "14px",
      messageFontSize: "16px"
    }
  },

  slate: {
    startOnLoad: false,
    theme: "dark",
    flowchart: {
      htmlLabels: false
    },
    er: {
      useMaxWidth: false
    },
    sequence: {
      useMaxWidth: false,
      noteFontWeight: "14px",
      actorFontSize: "14px",
      messageFontSize: "16px"
    }
  }
}
</script>
