//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `info!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn info() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::info!(name: "mog", ident = 3); // DEBUG:info,n,-,-,-,"ident","3"
    tracing::info!(name: "mog", foo = true, ident = 3); // DEBUG:info,n,-,p,-,"ident","3"
    tracing::info!(name: "mog", ident = 3, qux = 3); // DEBUG:info,n,-,f,-,"ident","3"
    tracing::info!(name: "mog", foo = true, ident = 3, qux = 3); // DEBUG:info,n,-,pf,-,"ident","3"
    tracing::info!(name: "mog", ident = 3, "msg without args"); // DEBUG:info,n,-,-,m,"ident","3"
    tracing::info!(name: "mog", foo = true, ident = 3, "msg without args"); // DEBUG:info,n,-,p,m,"ident","3"
    tracing::info!(name: "mog", ident = 3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"ident","3"
    tracing::info!(name: "mog", foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"ident","3"
    tracing::info!(name: "mog", { ident = 3 }, "msg without args"); // DEBUG:info,n,{},-,m,"ident","3"
    tracing::info!(name: "mog", { foo = true, ident = 3 }, "msg without args"); // DEBUG:info,n,{},p,m,"ident","3"
    tracing::info!(name: "mog", { ident = 3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"ident","3"
    tracing::info!(name: "mog", { foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"ident","3"
    tracing::info!(name: "mog", ident = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"ident","3"
    tracing::info!(name: "mog", foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"ident","3"
    tracing::info!(name: "mog", ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"ident","3"
    tracing::info!(name: "mog", foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"ident","3"
    tracing::info!(name: "mog", { ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"ident","3"
    tracing::info!(name: "mog", { foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"ident","3"
    tracing::info!(name: "mog", { ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"ident","3"
    tracing::info!(name: "mog", { foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"ident","3"
    tracing::info!(name: "mog", ident = false); // DEBUG:info,n,-,-,-,"ident","false"
    tracing::info!(name: "mog", foo = true, ident = false); // DEBUG:info,n,-,p,-,"ident","false"
    tracing::info!(name: "mog", ident = false, qux = 3); // DEBUG:info,n,-,f,-,"ident","false"
    tracing::info!(name: "mog", foo = true, ident = false, qux = 3); // DEBUG:info,n,-,pf,-,"ident","false"
    tracing::info!(name: "mog", ident = false, "msg without args"); // DEBUG:info,n,-,-,m,"ident","false"
    tracing::info!(name: "mog", foo = true, ident = false, "msg without args"); // DEBUG:info,n,-,p,m,"ident","false"
    tracing::info!(name: "mog", ident = false, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"ident","false"
    tracing::info!(name: "mog", foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"ident","false"
    tracing::info!(name: "mog", { ident = false }, "msg without args"); // DEBUG:info,n,{},-,m,"ident","false"
    tracing::info!(name: "mog", { foo = true, ident = false }, "msg without args"); // DEBUG:info,n,{},p,m,"ident","false"
    tracing::info!(name: "mog", { ident = false, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"ident","false"
    tracing::info!(name: "mog", { foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"ident","false"
    tracing::info!(name: "mog", ident = false, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"ident","false"
    tracing::info!(name: "mog", foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"ident","false"
    tracing::info!(name: "mog", ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"ident","false"
    tracing::info!(name: "mog", foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"ident","false"
    tracing::info!(name: "mog", { ident = false }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"ident","false"
    tracing::info!(name: "mog", { foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"ident","false"
    tracing::info!(name: "mog", { ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"ident","false"
    tracing::info!(name: "mog", { foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"ident","false"
    tracing::info!(name: "mog", ident = ?3); // DEBUG:info,n,-,-,-,"ident","?3"
    tracing::info!(name: "mog", foo = true, ident = ?3); // DEBUG:info,n,-,p,-,"ident","?3"
    tracing::info!(name: "mog", ident = ?3, qux = 3); // DEBUG:info,n,-,f,-,"ident","?3"
    tracing::info!(name: "mog", foo = true, ident = ?3, qux = 3); // DEBUG:info,n,-,pf,-,"ident","?3"
    tracing::info!(name: "mog", ident = ?3, "msg without args"); // DEBUG:info,n,-,-,m,"ident","?3"
    tracing::info!(name: "mog", foo = true, ident = ?3, "msg without args"); // DEBUG:info,n,-,p,m,"ident","?3"
    tracing::info!(name: "mog", ident = ?3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"ident","?3"
    tracing::info!(name: "mog", foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"ident","?3"
    tracing::info!(name: "mog", { ident = ?3 }, "msg without args"); // DEBUG:info,n,{},-,m,"ident","?3"
    tracing::info!(name: "mog", { foo = true, ident = ?3 }, "msg without args"); // DEBUG:info,n,{},p,m,"ident","?3"
    tracing::info!(name: "mog", { ident = ?3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"ident","?3"
    tracing::info!(name: "mog", { foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"ident","?3"
    tracing::info!(name: "mog", ident = ?3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"ident","?3"
    tracing::info!(name: "mog", foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"ident","?3"
    tracing::info!(name: "mog", ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"ident","?3"
    tracing::info!(name: "mog", foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"ident","?3"
    tracing::info!(name: "mog", { ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"ident","?3"
    tracing::info!(name: "mog", { foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"ident","?3"
    tracing::info!(name: "mog", { ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"ident","?3"
    tracing::info!(name: "mog", { foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"ident","?3"
    tracing::info!(name: "mog", ident = %3); // DEBUG:info,n,-,-,-,"ident","%3"
    tracing::info!(name: "mog", foo = true, ident = %3); // DEBUG:info,n,-,p,-,"ident","%3"
    tracing::info!(name: "mog", ident = %3, qux = 3); // DEBUG:info,n,-,f,-,"ident","%3"
    tracing::info!(name: "mog", foo = true, ident = %3, qux = 3); // DEBUG:info,n,-,pf,-,"ident","%3"
    tracing::info!(name: "mog", ident = %3, "msg without args"); // DEBUG:info,n,-,-,m,"ident","%3"
    tracing::info!(name: "mog", foo = true, ident = %3, "msg without args"); // DEBUG:info,n,-,p,m,"ident","%3"
    tracing::info!(name: "mog", ident = %3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"ident","%3"
    tracing::info!(name: "mog", foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"ident","%3"
    tracing::info!(name: "mog", { ident = %3 }, "msg without args"); // DEBUG:info,n,{},-,m,"ident","%3"
    tracing::info!(name: "mog", { foo = true, ident = %3 }, "msg without args"); // DEBUG:info,n,{},p,m,"ident","%3"
    tracing::info!(name: "mog", { ident = %3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"ident","%3"
    tracing::info!(name: "mog", { foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"ident","%3"
    tracing::info!(name: "mog", ident = %3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"ident","%3"
    tracing::info!(name: "mog", foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"ident","%3"
    tracing::info!(name: "mog", ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"ident","%3"
    tracing::info!(name: "mog", foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"ident","%3"
    tracing::info!(name: "mog", { ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"ident","%3"
    tracing::info!(name: "mog", { foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"ident","%3"
    tracing::info!(name: "mog", { ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"ident","%3"
    tracing::info!(name: "mog", { foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"ident","%3"
    tracing::info!(name: "mog", ident = ?deb); // DEBUG:info,n,-,-,-,"ident","?deb"
    tracing::info!(name: "mog", foo = true, ident = ?deb); // DEBUG:info,n,-,p,-,"ident","?deb"
    tracing::info!(name: "mog", ident = ?deb, qux = 3); // DEBUG:info,n,-,f,-,"ident","?deb"
    tracing::info!(name: "mog", foo = true, ident = ?deb, qux = 3); // DEBUG:info,n,-,pf,-,"ident","?deb"
    tracing::info!(name: "mog", ident = ?deb, "msg without args"); // DEBUG:info,n,-,-,m,"ident","?deb"
    tracing::info!(name: "mog", foo = true, ident = ?deb, "msg without args"); // DEBUG:info,n,-,p,m,"ident","?deb"
    tracing::info!(name: "mog", ident = ?deb, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"ident","?deb"
    tracing::info!(name: "mog", foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"ident","?deb"
    tracing::info!(name: "mog", { ident = ?deb }, "msg without args"); // DEBUG:info,n,{},-,m,"ident","?deb"
    tracing::info!(name: "mog", { foo = true, ident = ?deb }, "msg without args"); // DEBUG:info,n,{},p,m,"ident","?deb"
    tracing::info!(name: "mog", { ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"ident","?deb"
    tracing::info!(name: "mog", { foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"ident","?deb"
    tracing::info!(name: "mog", ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"ident","?deb"
    tracing::info!(name: "mog", foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"ident","?deb"
    tracing::info!(name: "mog", ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"ident","?deb"
    tracing::info!(name: "mog", foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"ident","?deb"
    tracing::info!(name: "mog", { ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"ident","?deb"
    tracing::info!(name: "mog", { foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"ident","?deb"
    tracing::info!(name: "mog", { ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"ident","?deb"
    tracing::info!(name: "mog", { foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"ident","?deb"
    tracing::info!(name: "mog", ident = %disp); // DEBUG:info,n,-,-,-,"ident","%disp"
    tracing::info!(name: "mog", foo = true, ident = %disp); // DEBUG:info,n,-,p,-,"ident","%disp"
    tracing::info!(name: "mog", ident = %disp, qux = 3); // DEBUG:info,n,-,f,-,"ident","%disp"
    tracing::info!(name: "mog", foo = true, ident = %disp, qux = 3); // DEBUG:info,n,-,pf,-,"ident","%disp"
    tracing::info!(name: "mog", ident = %disp, "msg without args"); // DEBUG:info,n,-,-,m,"ident","%disp"
    tracing::info!(name: "mog", foo = true, ident = %disp, "msg without args"); // DEBUG:info,n,-,p,m,"ident","%disp"
    tracing::info!(name: "mog", ident = %disp, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"ident","%disp"
    tracing::info!(name: "mog", foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"ident","%disp"
    tracing::info!(name: "mog", { ident = %disp }, "msg without args"); // DEBUG:info,n,{},-,m,"ident","%disp"
    tracing::info!(name: "mog", { foo = true, ident = %disp }, "msg without args"); // DEBUG:info,n,{},p,m,"ident","%disp"
    tracing::info!(name: "mog", { ident = %disp, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"ident","%disp"
    tracing::info!(name: "mog", { foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"ident","%disp"
    tracing::info!(name: "mog", ident = %disp, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"ident","%disp"
    tracing::info!(name: "mog", foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"ident","%disp"
    tracing::info!(name: "mog", ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"ident","%disp"
    tracing::info!(name: "mog", foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"ident","%disp"
    tracing::info!(name: "mog", { ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"ident","%disp"
    tracing::info!(name: "mog", { foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"ident","%disp"
    tracing::info!(name: "mog", { ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"ident","%disp"
    tracing::info!(name: "mog", { foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"ident","%disp"
    tracing::info!(name: "mog", ident = ?sub.field); // DEBUG:info,n,-,-,-,"ident","?sub.field"
    tracing::info!(name: "mog", foo = true, ident = ?sub.field); // DEBUG:info,n,-,p,-,"ident","?sub.field"
    tracing::info!(name: "mog", ident = ?sub.field, qux = 3); // DEBUG:info,n,-,f,-,"ident","?sub.field"
    tracing::info!(name: "mog", foo = true, ident = ?sub.field, qux = 3); // DEBUG:info,n,-,pf,-,"ident","?sub.field"
    tracing::info!(name: "mog", ident = ?sub.field, "msg without args"); // DEBUG:info,n,-,-,m,"ident","?sub.field"
    tracing::info!(name: "mog", foo = true, ident = ?sub.field, "msg without args"); // DEBUG:info,n,-,p,m,"ident","?sub.field"
    tracing::info!(name: "mog", ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"ident","?sub.field"
    tracing::info!(name: "mog", foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"ident","?sub.field"
    tracing::info!(name: "mog", { ident = ?sub.field }, "msg without args"); // DEBUG:info,n,{},-,m,"ident","?sub.field"
    tracing::info!(name: "mog", { foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:info,n,{},p,m,"ident","?sub.field"
    tracing::info!(name: "mog", { ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"ident","?sub.field"
    tracing::info!(name: "mog", { foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"ident","?sub.field"
    tracing::info!(name: "mog", ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"ident","?sub.field"
    tracing::info!(name: "mog", foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"ident","?sub.field"
    tracing::info!(name: "mog", ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"ident","?sub.field"
    tracing::info!(name: "mog", foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"ident","?sub.field"
    tracing::info!(name: "mog", { ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"ident","?sub.field"
    tracing::info!(name: "mog", { foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"ident","?sub.field"
    tracing::info!(name: "mog", { ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"ident","?sub.field"
    tracing::info!(name: "mog", { foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"ident","?sub.field"
    tracing::info!(name: "mog", ident = %sub.field); // DEBUG:info,n,-,-,-,"ident","%sub.field"
    tracing::info!(name: "mog", foo = true, ident = %sub.field); // DEBUG:info,n,-,p,-,"ident","%sub.field"
    tracing::info!(name: "mog", ident = %sub.field, qux = 3); // DEBUG:info,n,-,f,-,"ident","%sub.field"
    tracing::info!(name: "mog", foo = true, ident = %sub.field, qux = 3); // DEBUG:info,n,-,pf,-,"ident","%sub.field"
    tracing::info!(name: "mog", ident = %sub.field, "msg without args"); // DEBUG:info,n,-,-,m,"ident","%sub.field"
    tracing::info!(name: "mog", foo = true, ident = %sub.field, "msg without args"); // DEBUG:info,n,-,p,m,"ident","%sub.field"
    tracing::info!(name: "mog", ident = %sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"ident","%sub.field"
    tracing::info!(name: "mog", foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"ident","%sub.field"
    tracing::info!(name: "mog", { ident = %sub.field }, "msg without args"); // DEBUG:info,n,{},-,m,"ident","%sub.field"
    tracing::info!(name: "mog", { foo = true, ident = %sub.field }, "msg without args"); // DEBUG:info,n,{},p,m,"ident","%sub.field"
    tracing::info!(name: "mog", { ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"ident","%sub.field"
    tracing::info!(name: "mog", { foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"ident","%sub.field"
    tracing::info!(name: "mog", ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"ident","%sub.field"
    tracing::info!(name: "mog", foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"ident","%sub.field"
    tracing::info!(name: "mog", ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"ident","%sub.field"
    tracing::info!(name: "mog", foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"ident","%sub.field"
    tracing::info!(name: "mog", { ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"ident","%sub.field"
    tracing::info!(name: "mog", { foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"ident","%sub.field"
    tracing::info!(name: "mog", { ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"ident","%sub.field"
    tracing::info!(name: "mog", { foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"ident","%sub.field"
    tracing::info!(name: "mog", ident = debug(&deb)); // DEBUG:info,n,-,-,-,"ident","debug(&deb)"
    tracing::info!(name: "mog", foo = true, ident = debug(&deb)); // DEBUG:info,n,-,p,-,"ident","debug(&deb)"
    tracing::info!(name: "mog", ident = debug(&deb), qux = 3); // DEBUG:info,n,-,f,-,"ident","debug(&deb)"
    tracing::info!(name: "mog", foo = true, ident = debug(&deb), qux = 3); // DEBUG:info,n,-,pf,-,"ident","debug(&deb)"
    tracing::info!(name: "mog", ident = debug(&deb), "msg without args"); // DEBUG:info,n,-,-,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", foo = true, ident = debug(&deb), "msg without args"); // DEBUG:info,n,-,p,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", { ident = debug(&deb) }, "msg without args"); // DEBUG:info,n,{},-,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:info,n,{},p,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", { ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"ident","debug(&deb)"
    tracing::info!(name: "mog", ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", { ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", { ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"ident","debug(&deb)"
    tracing::info!(name: "mog", ident = display(&disp)); // DEBUG:info,n,-,-,-,"ident","display(&disp)"
    tracing::info!(name: "mog", foo = true, ident = display(&disp)); // DEBUG:info,n,-,p,-,"ident","display(&disp)"
    tracing::info!(name: "mog", ident = display(&disp), qux = 3); // DEBUG:info,n,-,f,-,"ident","display(&disp)"
    tracing::info!(name: "mog", foo = true, ident = display(&disp), qux = 3); // DEBUG:info,n,-,pf,-,"ident","display(&disp)"
    tracing::info!(name: "mog", ident = display(&disp), "msg without args"); // DEBUG:info,n,-,-,m,"ident","display(&disp)"
    tracing::info!(name: "mog", foo = true, ident = display(&disp), "msg without args"); // DEBUG:info,n,-,p,m,"ident","display(&disp)"
    tracing::info!(name: "mog", ident = display(&disp), qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"ident","display(&disp)"
    tracing::info!(name: "mog", foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"ident","display(&disp)"
    tracing::info!(name: "mog", { ident = display(&disp) }, "msg without args"); // DEBUG:info,n,{},-,m,"ident","display(&disp)"
    tracing::info!(name: "mog", { foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:info,n,{},p,m,"ident","display(&disp)"
    tracing::info!(name: "mog", { ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"ident","display(&disp)"
    tracing::info!(name: "mog", { foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"ident","display(&disp)"
    tracing::info!(name: "mog", ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", { ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", { foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", { ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", { foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"ident","display(&disp)"
    tracing::info!(name: "mog", ident = tracing::field::Empty); // DEBUG:info,n,-,-,-,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, ident = tracing::field::Empty); // DEBUG:info,n,-,p,-,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", ident = tracing::field::Empty, qux = 3); // DEBUG:info,n,-,f,-,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:info,n,-,pf,-,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", ident = tracing::field::Empty, "msg without args"); // DEBUG:info,n,-,-,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:info,n,-,p,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", { ident = tracing::field::Empty }, "msg without args"); // DEBUG:info,n,{},-,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:info,n,{},p,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", { ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", { ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", { ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"ident","tracing::field::Empty"
    tracing::info!(name: "mog", dotted.ident = 3); // DEBUG:info,n,-,-,-,"dotted.ident","3"
    tracing::info!(name: "mog", foo = true, dotted.ident = 3); // DEBUG:info,n,-,p,-,"dotted.ident","3"
    tracing::info!(name: "mog", dotted.ident = 3, qux = 3); // DEBUG:info,n,-,f,-,"dotted.ident","3"
    tracing::info!(name: "mog", foo = true, dotted.ident = 3, qux = 3); // DEBUG:info,n,-,pf,-,"dotted.ident","3"
    tracing::info!(name: "mog", dotted.ident = 3, "msg without args"); // DEBUG:info,n,-,-,m,"dotted.ident","3"
    tracing::info!(name: "mog", foo = true, dotted.ident = 3, "msg without args"); // DEBUG:info,n,-,p,m,"dotted.ident","3"
    tracing::info!(name: "mog", dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"dotted.ident","3"
    tracing::info!(name: "mog", foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"dotted.ident","3"
    tracing::info!(name: "mog", { dotted.ident = 3 }, "msg without args"); // DEBUG:info,n,{},-,m,"dotted.ident","3"
    tracing::info!(name: "mog", { foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:info,n,{},p,m,"dotted.ident","3"
    tracing::info!(name: "mog", { dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"dotted.ident","3"
    tracing::info!(name: "mog", { foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"dotted.ident","3"
    tracing::info!(name: "mog", dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"dotted.ident","3"
    tracing::info!(name: "mog", foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"dotted.ident","3"
    tracing::info!(name: "mog", dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"dotted.ident","3"
    tracing::info!(name: "mog", foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"dotted.ident","3"
    tracing::info!(name: "mog", { dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"dotted.ident","3"
    tracing::info!(name: "mog", { foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"dotted.ident","3"
    tracing::info!(name: "mog", { dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"dotted.ident","3"
    tracing::info!(name: "mog", { foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"dotted.ident","3"
    tracing::info!(name: "mog", dotted.ident = false); // DEBUG:info,n,-,-,-,"dotted.ident","false"
    tracing::info!(name: "mog", foo = true, dotted.ident = false); // DEBUG:info,n,-,p,-,"dotted.ident","false"
    tracing::info!(name: "mog", dotted.ident = false, qux = 3); // DEBUG:info,n,-,f,-,"dotted.ident","false"
    tracing::info!(name: "mog", foo = true, dotted.ident = false, qux = 3); // DEBUG:info,n,-,pf,-,"dotted.ident","false"
    tracing::info!(name: "mog", dotted.ident = false, "msg without args"); // DEBUG:info,n,-,-,m,"dotted.ident","false"
    tracing::info!(name: "mog", foo = true, dotted.ident = false, "msg without args"); // DEBUG:info,n,-,p,m,"dotted.ident","false"
    tracing::info!(name: "mog", dotted.ident = false, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"dotted.ident","false"
    tracing::info!(name: "mog", foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"dotted.ident","false"
    tracing::info!(name: "mog", { dotted.ident = false }, "msg without args"); // DEBUG:info,n,{},-,m,"dotted.ident","false"
    tracing::info!(name: "mog", { foo = true, dotted.ident = false }, "msg without args"); // DEBUG:info,n,{},p,m,"dotted.ident","false"
    tracing::info!(name: "mog", { dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"dotted.ident","false"
    tracing::info!(name: "mog", { foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"dotted.ident","false"
    tracing::info!(name: "mog", dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"dotted.ident","false"
    tracing::info!(name: "mog", foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"dotted.ident","false"
    tracing::info!(name: "mog", dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"dotted.ident","false"
    tracing::info!(name: "mog", foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"dotted.ident","false"
    tracing::info!(name: "mog", { dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"dotted.ident","false"
    tracing::info!(name: "mog", { foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"dotted.ident","false"
    tracing::info!(name: "mog", { dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"dotted.ident","false"
    tracing::info!(name: "mog", { foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"dotted.ident","false"
    tracing::info!(name: "mog", dotted.ident = ?3); // DEBUG:info,n,-,-,-,"dotted.ident","?3"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?3); // DEBUG:info,n,-,p,-,"dotted.ident","?3"
    tracing::info!(name: "mog", dotted.ident = ?3, qux = 3); // DEBUG:info,n,-,f,-,"dotted.ident","?3"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?3, qux = 3); // DEBUG:info,n,-,pf,-,"dotted.ident","?3"
    tracing::info!(name: "mog", dotted.ident = ?3, "msg without args"); // DEBUG:info,n,-,-,m,"dotted.ident","?3"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:info,n,-,p,m,"dotted.ident","?3"
    tracing::info!(name: "mog", dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"dotted.ident","?3"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"dotted.ident","?3"
    tracing::info!(name: "mog", { dotted.ident = ?3 }, "msg without args"); // DEBUG:info,n,{},-,m,"dotted.ident","?3"
    tracing::info!(name: "mog", { foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:info,n,{},p,m,"dotted.ident","?3"
    tracing::info!(name: "mog", { dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"dotted.ident","?3"
    tracing::info!(name: "mog", { foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"dotted.ident","?3"
    tracing::info!(name: "mog", dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", { dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", { foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", { dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", { foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"dotted.ident","?3"
    tracing::info!(name: "mog", dotted.ident = %3); // DEBUG:info,n,-,-,-,"dotted.ident","%3"
    tracing::info!(name: "mog", foo = true, dotted.ident = %3); // DEBUG:info,n,-,p,-,"dotted.ident","%3"
    tracing::info!(name: "mog", dotted.ident = %3, qux = 3); // DEBUG:info,n,-,f,-,"dotted.ident","%3"
    tracing::info!(name: "mog", foo = true, dotted.ident = %3, qux = 3); // DEBUG:info,n,-,pf,-,"dotted.ident","%3"
    tracing::info!(name: "mog", dotted.ident = %3, "msg without args"); // DEBUG:info,n,-,-,m,"dotted.ident","%3"
    tracing::info!(name: "mog", foo = true, dotted.ident = %3, "msg without args"); // DEBUG:info,n,-,p,m,"dotted.ident","%3"
    tracing::info!(name: "mog", dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"dotted.ident","%3"
    tracing::info!(name: "mog", foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"dotted.ident","%3"
    tracing::info!(name: "mog", { dotted.ident = %3 }, "msg without args"); // DEBUG:info,n,{},-,m,"dotted.ident","%3"
    tracing::info!(name: "mog", { foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:info,n,{},p,m,"dotted.ident","%3"
    tracing::info!(name: "mog", { dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"dotted.ident","%3"
    tracing::info!(name: "mog", { foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"dotted.ident","%3"
    tracing::info!(name: "mog", dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", { dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", { foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", { dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", { foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"dotted.ident","%3"
    tracing::info!(name: "mog", dotted.ident = ?deb); // DEBUG:info,n,-,-,-,"dotted.ident","?deb"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?deb); // DEBUG:info,n,-,p,-,"dotted.ident","?deb"
    tracing::info!(name: "mog", dotted.ident = ?deb, qux = 3); // DEBUG:info,n,-,f,-,"dotted.ident","?deb"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:info,n,-,pf,-,"dotted.ident","?deb"
    tracing::info!(name: "mog", dotted.ident = ?deb, "msg without args"); // DEBUG:info,n,-,-,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:info,n,-,p,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", { dotted.ident = ?deb }, "msg without args"); // DEBUG:info,n,{},-,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", { foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:info,n,{},p,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", { dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", { foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"dotted.ident","?deb"
    tracing::info!(name: "mog", dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", { dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", { foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", { dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", { foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"dotted.ident","?deb"
    tracing::info!(name: "mog", dotted.ident = %disp); // DEBUG:info,n,-,-,-,"dotted.ident","%disp"
    tracing::info!(name: "mog", foo = true, dotted.ident = %disp); // DEBUG:info,n,-,p,-,"dotted.ident","%disp"
    tracing::info!(name: "mog", dotted.ident = %disp, qux = 3); // DEBUG:info,n,-,f,-,"dotted.ident","%disp"
    tracing::info!(name: "mog", foo = true, dotted.ident = %disp, qux = 3); // DEBUG:info,n,-,pf,-,"dotted.ident","%disp"
    tracing::info!(name: "mog", dotted.ident = %disp, "msg without args"); // DEBUG:info,n,-,-,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:info,n,-,p,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", { dotted.ident = %disp }, "msg without args"); // DEBUG:info,n,{},-,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", { foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:info,n,{},p,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", { dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", { foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"dotted.ident","%disp"
    tracing::info!(name: "mog", dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", { dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", { foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", { dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", { foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"dotted.ident","%disp"
    tracing::info!(name: "mog", dotted.ident = ?sub.field); // DEBUG:info,n,-,-,-,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?sub.field); // DEBUG:info,n,-,p,-,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", dotted.ident = ?sub.field, qux = 3); // DEBUG:info,n,-,f,-,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:info,n,-,pf,-,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", dotted.ident = ?sub.field, "msg without args"); // DEBUG:info,n,-,-,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:info,n,-,p,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", { dotted.ident = ?sub.field }, "msg without args"); // DEBUG:info,n,{},-,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", { foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:info,n,{},p,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", { dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", { dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", { foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", { dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"dotted.ident","?sub.field"
    tracing::info!(name: "mog", dotted.ident = %sub.field); // DEBUG:info,n,-,-,-,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", foo = true, dotted.ident = %sub.field); // DEBUG:info,n,-,p,-,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", dotted.ident = %sub.field, qux = 3); // DEBUG:info,n,-,f,-,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:info,n,-,pf,-,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", dotted.ident = %sub.field, "msg without args"); // DEBUG:info,n,-,-,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:info,n,-,p,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", { dotted.ident = %sub.field }, "msg without args"); // DEBUG:info,n,{},-,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", { foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:info,n,{},p,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", { dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", { dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", { foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", { dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"dotted.ident","%sub.field"
    tracing::info!(name: "mog", dotted.ident = debug(&deb)); // DEBUG:info,n,-,-,-,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", foo = true, dotted.ident = debug(&deb)); // DEBUG:info,n,-,p,-,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", dotted.ident = debug(&deb), qux = 3); // DEBUG:info,n,-,f,-,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:info,n,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", dotted.ident = debug(&deb), "msg without args"); // DEBUG:info,n,-,-,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:info,n,-,p,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", { dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:info,n,{},-,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:info,n,{},p,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", { dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", { dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", { dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::info!(name: "mog", dotted.ident = display(&disp)); // DEBUG:info,n,-,-,-,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", foo = true, dotted.ident = display(&disp)); // DEBUG:info,n,-,p,-,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", dotted.ident = display(&disp), qux = 3); // DEBUG:info,n,-,f,-,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:info,n,-,pf,-,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", dotted.ident = display(&disp), "msg without args"); // DEBUG:info,n,-,-,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:info,n,-,p,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", { dotted.ident = display(&disp) }, "msg without args"); // DEBUG:info,n,{},-,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", { foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:info,n,{},p,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", { dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", { dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", { foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", { dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::info!(name: "mog", dotted.ident = tracing::field::Empty); // DEBUG:info,n,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, dotted.ident = tracing::field::Empty); // DEBUG:info,n,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:info,n,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:info,n,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:info,n,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:info,n,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", { dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:info,n,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:info,n,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", { dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", { dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", { dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::info!(name: "mog", "literal" = 3); // DEBUG:info,n,-,-,-,"\"literal\"","3"
    tracing::info!(name: "mog", foo = true, "literal" = 3); // DEBUG:info,n,-,p,-,"\"literal\"","3"
    tracing::info!(name: "mog", "literal" = 3, qux = 3); // DEBUG:info,n,-,f,-,"\"literal\"","3"
    tracing::info!(name: "mog", foo = true, "literal" = 3, qux = 3); // DEBUG:info,n,-,pf,-,"\"literal\"","3"
    tracing::info!(name: "mog", "literal" = 3, "msg without args"); // DEBUG:info,n,-,-,m,"\"literal\"","3"
    tracing::info!(name: "mog", foo = true, "literal" = 3, "msg without args"); // DEBUG:info,n,-,p,m,"\"literal\"","3"
    tracing::info!(name: "mog", "literal" = 3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"\"literal\"","3"
    tracing::info!(name: "mog", foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"\"literal\"","3"
    tracing::info!(name: "mog", { "literal" = 3 }, "msg without args"); // DEBUG:info,n,{},-,m,"\"literal\"","3"
    tracing::info!(name: "mog", { foo = true, "literal" = 3 }, "msg without args"); // DEBUG:info,n,{},p,m,"\"literal\"","3"
    tracing::info!(name: "mog", { "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"\"literal\"","3"
    tracing::info!(name: "mog", { foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"\"literal\"","3"
    tracing::info!(name: "mog", "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"\"literal\"","3"
    tracing::info!(name: "mog", foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"\"literal\"","3"
    tracing::info!(name: "mog", "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"\"literal\"","3"
    tracing::info!(name: "mog", foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"\"literal\"","3"
    tracing::info!(name: "mog", { "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"\"literal\"","3"
    tracing::info!(name: "mog", { foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"\"literal\"","3"
    tracing::info!(name: "mog", { "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"\"literal\"","3"
    tracing::info!(name: "mog", { foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"\"literal\"","3"
    tracing::info!(name: "mog", "literal" = false); // DEBUG:info,n,-,-,-,"\"literal\"","false"
    tracing::info!(name: "mog", foo = true, "literal" = false); // DEBUG:info,n,-,p,-,"\"literal\"","false"
    tracing::info!(name: "mog", "literal" = false, qux = 3); // DEBUG:info,n,-,f,-,"\"literal\"","false"
    tracing::info!(name: "mog", foo = true, "literal" = false, qux = 3); // DEBUG:info,n,-,pf,-,"\"literal\"","false"
    tracing::info!(name: "mog", "literal" = false, "msg without args"); // DEBUG:info,n,-,-,m,"\"literal\"","false"
    tracing::info!(name: "mog", foo = true, "literal" = false, "msg without args"); // DEBUG:info,n,-,p,m,"\"literal\"","false"
    tracing::info!(name: "mog", "literal" = false, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"\"literal\"","false"
    tracing::info!(name: "mog", foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"\"literal\"","false"
    tracing::info!(name: "mog", { "literal" = false }, "msg without args"); // DEBUG:info,n,{},-,m,"\"literal\"","false"
    tracing::info!(name: "mog", { foo = true, "literal" = false }, "msg without args"); // DEBUG:info,n,{},p,m,"\"literal\"","false"
    tracing::info!(name: "mog", { "literal" = false, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"\"literal\"","false"
    tracing::info!(name: "mog", { foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"\"literal\"","false"
    tracing::info!(name: "mog", "literal" = false, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"\"literal\"","false"
    tracing::info!(name: "mog", foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"\"literal\"","false"
    tracing::info!(name: "mog", "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"\"literal\"","false"
    tracing::info!(name: "mog", foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"\"literal\"","false"
    tracing::info!(name: "mog", { "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"\"literal\"","false"
    tracing::info!(name: "mog", { foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"\"literal\"","false"
    tracing::info!(name: "mog", { "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"\"literal\"","false"
    tracing::info!(name: "mog", { foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"\"literal\"","false"
    tracing::info!(name: "mog", "literal" = ?3); // DEBUG:info,n,-,-,-,"\"literal\"","?3"
    tracing::info!(name: "mog", foo = true, "literal" = ?3); // DEBUG:info,n,-,p,-,"\"literal\"","?3"
    tracing::info!(name: "mog", "literal" = ?3, qux = 3); // DEBUG:info,n,-,f,-,"\"literal\"","?3"
    tracing::info!(name: "mog", foo = true, "literal" = ?3, qux = 3); // DEBUG:info,n,-,pf,-,"\"literal\"","?3"
    tracing::info!(name: "mog", "literal" = ?3, "msg without args"); // DEBUG:info,n,-,-,m,"\"literal\"","?3"
    tracing::info!(name: "mog", foo = true, "literal" = ?3, "msg without args"); // DEBUG:info,n,-,p,m,"\"literal\"","?3"
    tracing::info!(name: "mog", "literal" = ?3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"\"literal\"","?3"
    tracing::info!(name: "mog", foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"\"literal\"","?3"
    tracing::info!(name: "mog", { "literal" = ?3 }, "msg without args"); // DEBUG:info,n,{},-,m,"\"literal\"","?3"
    tracing::info!(name: "mog", { foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:info,n,{},p,m,"\"literal\"","?3"
    tracing::info!(name: "mog", { "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"\"literal\"","?3"
    tracing::info!(name: "mog", { foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"\"literal\"","?3"
    tracing::info!(name: "mog", "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", { "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", { foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", { "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", { foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"\"literal\"","?3"
    tracing::info!(name: "mog", "literal" = %3); // DEBUG:info,n,-,-,-,"\"literal\"","%3"
    tracing::info!(name: "mog", foo = true, "literal" = %3); // DEBUG:info,n,-,p,-,"\"literal\"","%3"
    tracing::info!(name: "mog", "literal" = %3, qux = 3); // DEBUG:info,n,-,f,-,"\"literal\"","%3"
    tracing::info!(name: "mog", foo = true, "literal" = %3, qux = 3); // DEBUG:info,n,-,pf,-,"\"literal\"","%3"
    tracing::info!(name: "mog", "literal" = %3, "msg without args"); // DEBUG:info,n,-,-,m,"\"literal\"","%3"
    tracing::info!(name: "mog", foo = true, "literal" = %3, "msg without args"); // DEBUG:info,n,-,p,m,"\"literal\"","%3"
    tracing::info!(name: "mog", "literal" = %3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"\"literal\"","%3"
    tracing::info!(name: "mog", foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"\"literal\"","%3"
    tracing::info!(name: "mog", { "literal" = %3 }, "msg without args"); // DEBUG:info,n,{},-,m,"\"literal\"","%3"
    tracing::info!(name: "mog", { foo = true, "literal" = %3 }, "msg without args"); // DEBUG:info,n,{},p,m,"\"literal\"","%3"
    tracing::info!(name: "mog", { "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"\"literal\"","%3"
    tracing::info!(name: "mog", { foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"\"literal\"","%3"
    tracing::info!(name: "mog", "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", { "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", { foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", { "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", { foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"\"literal\"","%3"
    tracing::info!(name: "mog", "literal" = ?deb); // DEBUG:info,n,-,-,-,"\"literal\"","?deb"
    tracing::info!(name: "mog", foo = true, "literal" = ?deb); // DEBUG:info,n,-,p,-,"\"literal\"","?deb"
    tracing::info!(name: "mog", "literal" = ?deb, qux = 3); // DEBUG:info,n,-,f,-,"\"literal\"","?deb"
    tracing::info!(name: "mog", foo = true, "literal" = ?deb, qux = 3); // DEBUG:info,n,-,pf,-,"\"literal\"","?deb"
    tracing::info!(name: "mog", "literal" = ?deb, "msg without args"); // DEBUG:info,n,-,-,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", foo = true, "literal" = ?deb, "msg without args"); // DEBUG:info,n,-,p,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", { "literal" = ?deb }, "msg without args"); // DEBUG:info,n,{},-,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", { foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:info,n,{},p,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", { "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", { foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"\"literal\"","?deb"
    tracing::info!(name: "mog", "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", { "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", { foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", { "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", { foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"\"literal\"","?deb"
    tracing::info!(name: "mog", "literal" = %disp); // DEBUG:info,n,-,-,-,"\"literal\"","%disp"
    tracing::info!(name: "mog", foo = true, "literal" = %disp); // DEBUG:info,n,-,p,-,"\"literal\"","%disp"
    tracing::info!(name: "mog", "literal" = %disp, qux = 3); // DEBUG:info,n,-,f,-,"\"literal\"","%disp"
    tracing::info!(name: "mog", foo = true, "literal" = %disp, qux = 3); // DEBUG:info,n,-,pf,-,"\"literal\"","%disp"
    tracing::info!(name: "mog", "literal" = %disp, "msg without args"); // DEBUG:info,n,-,-,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", foo = true, "literal" = %disp, "msg without args"); // DEBUG:info,n,-,p,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", "literal" = %disp, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", { "literal" = %disp }, "msg without args"); // DEBUG:info,n,{},-,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", { foo = true, "literal" = %disp }, "msg without args"); // DEBUG:info,n,{},p,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", { "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", { foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"\"literal\"","%disp"
    tracing::info!(name: "mog", "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", { "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", { foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", { "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", { foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"\"literal\"","%disp"
    tracing::info!(name: "mog", "literal" = ?sub.field); // DEBUG:info,n,-,-,-,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", foo = true, "literal" = ?sub.field); // DEBUG:info,n,-,p,-,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", "literal" = ?sub.field, qux = 3); // DEBUG:info,n,-,f,-,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:info,n,-,pf,-,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", "literal" = ?sub.field, "msg without args"); // DEBUG:info,n,-,-,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:info,n,-,p,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", { "literal" = ?sub.field }, "msg without args"); // DEBUG:info,n,{},-,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", { foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:info,n,{},p,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", { "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", { foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", { "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", { foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", { "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", { foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"\"literal\"","?sub.field"
    tracing::info!(name: "mog", "literal" = %sub.field); // DEBUG:info,n,-,-,-,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", foo = true, "literal" = %sub.field); // DEBUG:info,n,-,p,-,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", "literal" = %sub.field, qux = 3); // DEBUG:info,n,-,f,-,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", foo = true, "literal" = %sub.field, qux = 3); // DEBUG:info,n,-,pf,-,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", "literal" = %sub.field, "msg without args"); // DEBUG:info,n,-,-,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:info,n,-,p,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", { "literal" = %sub.field }, "msg without args"); // DEBUG:info,n,{},-,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", { foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:info,n,{},p,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", { "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", { foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", { "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", { foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", { "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", { foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"\"literal\"","%sub.field"
    tracing::info!(name: "mog", "literal" = debug(&deb)); // DEBUG:info,n,-,-,-,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", foo = true, "literal" = debug(&deb)); // DEBUG:info,n,-,p,-,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", "literal" = debug(&deb), qux = 3); // DEBUG:info,n,-,f,-,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:info,n,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", "literal" = debug(&deb), "msg without args"); // DEBUG:info,n,-,-,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:info,n,-,p,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", { "literal" = debug(&deb) }, "msg without args"); // DEBUG:info,n,{},-,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:info,n,{},p,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", { "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", { "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", { "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::info!(name: "mog", "literal" = display(&disp)); // DEBUG:info,n,-,-,-,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", foo = true, "literal" = display(&disp)); // DEBUG:info,n,-,p,-,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", "literal" = display(&disp), qux = 3); // DEBUG:info,n,-,f,-,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", foo = true, "literal" = display(&disp), qux = 3); // DEBUG:info,n,-,pf,-,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", "literal" = display(&disp), "msg without args"); // DEBUG:info,n,-,-,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:info,n,-,p,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", { "literal" = display(&disp) }, "msg without args"); // DEBUG:info,n,{},-,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", { foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:info,n,{},p,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", { "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", { foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", { "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", { foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", { "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", { foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::info!(name: "mog", "literal" = tracing::field::Empty); // DEBUG:info,n,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, "literal" = tracing::field::Empty); // DEBUG:info,n,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", "literal" = tracing::field::Empty, qux = 3); // DEBUG:info,n,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:info,n,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", "literal" = tracing::field::Empty, "msg without args"); // DEBUG:info,n,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:info,n,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", { "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:info,n,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:info,n,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", { "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", { "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", { "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::info!(name: "mog", { CONST_VAR } = 3); // DEBUG:info,n,-,-,-,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = 3); // DEBUG:info,n,-,p,-,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { CONST_VAR } = 3, qux = 3); // DEBUG:info,n,-,f,-,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:info,n,-,pf,-,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { CONST_VAR } = 3, "msg without args"); // DEBUG:info,n,-,-,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:info,n,-,p,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { { CONST_VAR } = 3 }, "msg without args"); // DEBUG:info,n,{},-,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:info,n,{},p,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"{ CONST_VAR }","3"
    tracing::info!(name: "mog", { CONST_VAR } = false); // DEBUG:info,n,-,-,-,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = false); // DEBUG:info,n,-,p,-,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { CONST_VAR } = false, qux = 3); // DEBUG:info,n,-,f,-,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:info,n,-,pf,-,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { CONST_VAR } = false, "msg without args"); // DEBUG:info,n,-,-,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:info,n,-,p,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { { CONST_VAR } = false }, "msg without args"); // DEBUG:info,n,{},-,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:info,n,{},p,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"{ CONST_VAR }","false"
    tracing::info!(name: "mog", { CONST_VAR } = ?3); // DEBUG:info,n,-,-,-,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?3); // DEBUG:info,n,-,p,-,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { CONST_VAR } = ?3, qux = 3); // DEBUG:info,n,-,f,-,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:info,n,-,pf,-,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { CONST_VAR } = ?3, "msg without args"); // DEBUG:info,n,-,-,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:info,n,-,p,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:info,n,{},-,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:info,n,{},p,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::info!(name: "mog", { CONST_VAR } = %3); // DEBUG:info,n,-,-,-,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %3); // DEBUG:info,n,-,p,-,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { CONST_VAR } = %3, qux = 3); // DEBUG:info,n,-,f,-,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:info,n,-,pf,-,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { CONST_VAR } = %3, "msg without args"); // DEBUG:info,n,-,-,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:info,n,-,p,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { { CONST_VAR } = %3 }, "msg without args"); // DEBUG:info,n,{},-,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:info,n,{},p,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::info!(name: "mog", { CONST_VAR } = ?deb); // DEBUG:info,n,-,-,-,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?deb); // DEBUG:info,n,-,p,-,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { CONST_VAR } = ?deb, qux = 3); // DEBUG:info,n,-,f,-,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:info,n,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { CONST_VAR } = ?deb, "msg without args"); // DEBUG:info,n,-,-,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:info,n,-,p,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:info,n,{},-,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:info,n,{},p,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::info!(name: "mog", { CONST_VAR } = %disp); // DEBUG:info,n,-,-,-,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %disp); // DEBUG:info,n,-,p,-,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { CONST_VAR } = %disp, qux = 3); // DEBUG:info,n,-,f,-,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:info,n,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { CONST_VAR } = %disp, "msg without args"); // DEBUG:info,n,-,-,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:info,n,-,p,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { { CONST_VAR } = %disp }, "msg without args"); // DEBUG:info,n,{},-,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:info,n,{},p,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::info!(name: "mog", { CONST_VAR } = ?sub.field); // DEBUG:info,n,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?sub.field); // DEBUG:info,n,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:info,n,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:info,n,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:info,n,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:info,n,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:info,n,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:info,n,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::info!(name: "mog", { CONST_VAR } = %sub.field); // DEBUG:info,n,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %sub.field); // DEBUG:info,n,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { CONST_VAR } = %sub.field, qux = 3); // DEBUG:info,n,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:info,n,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:info,n,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:info,n,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:info,n,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:info,n,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::info!(name: "mog", { CONST_VAR } = debug(&deb)); // DEBUG:info,n,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:info,n,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:info,n,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:info,n,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:info,n,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:info,n,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:info,n,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:info,n,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::info!(name: "mog", { CONST_VAR } = display(&disp)); // DEBUG:info,n,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = display(&disp)); // DEBUG:info,n,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { CONST_VAR } = display(&disp), qux = 3); // DEBUG:info,n,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:info,n,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:info,n,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:info,n,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:info,n,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:info,n,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::info!(name: "mog", { CONST_VAR } = tracing::field::Empty); // DEBUG:info,n,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:info,n,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:info,n,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:info,n,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:info,n,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:info,n,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", { { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:info,n,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:info,n,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", { { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::info!(name: "mog", r#type = 3); // DEBUG:info,n,-,-,-,"r#type","3"
    tracing::info!(name: "mog", foo = true, r#type = 3); // DEBUG:info,n,-,p,-,"r#type","3"
    tracing::info!(name: "mog", r#type = 3, qux = 3); // DEBUG:info,n,-,f,-,"r#type","3"
    tracing::info!(name: "mog", foo = true, r#type = 3, qux = 3); // DEBUG:info,n,-,pf,-,"r#type","3"
    tracing::info!(name: "mog", r#type = 3, "msg without args"); // DEBUG:info,n,-,-,m,"r#type","3"
    tracing::info!(name: "mog", foo = true, r#type = 3, "msg without args"); // DEBUG:info,n,-,p,m,"r#type","3"
    tracing::info!(name: "mog", r#type = 3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"r#type","3"
    tracing::info!(name: "mog", foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"r#type","3"
    tracing::info!(name: "mog", { r#type = 3 }, "msg without args"); // DEBUG:info,n,{},-,m,"r#type","3"
    tracing::info!(name: "mog", { foo = true, r#type = 3 }, "msg without args"); // DEBUG:info,n,{},p,m,"r#type","3"
    tracing::info!(name: "mog", { r#type = 3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"r#type","3"
    tracing::info!(name: "mog", { foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"r#type","3"
    tracing::info!(name: "mog", r#type = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"r#type","3"
    tracing::info!(name: "mog", foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"r#type","3"
    tracing::info!(name: "mog", r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"r#type","3"
    tracing::info!(name: "mog", foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"r#type","3"
    tracing::info!(name: "mog", { r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"r#type","3"
    tracing::info!(name: "mog", { foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"r#type","3"
    tracing::info!(name: "mog", { r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"r#type","3"
    tracing::info!(name: "mog", { foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"r#type","3"
    tracing::info!(name: "mog", r#type = false); // DEBUG:info,n,-,-,-,"r#type","false"
    tracing::info!(name: "mog", foo = true, r#type = false); // DEBUG:info,n,-,p,-,"r#type","false"
    tracing::info!(name: "mog", r#type = false, qux = 3); // DEBUG:info,n,-,f,-,"r#type","false"
    tracing::info!(name: "mog", foo = true, r#type = false, qux = 3); // DEBUG:info,n,-,pf,-,"r#type","false"
    tracing::info!(name: "mog", r#type = false, "msg without args"); // DEBUG:info,n,-,-,m,"r#type","false"
    tracing::info!(name: "mog", foo = true, r#type = false, "msg without args"); // DEBUG:info,n,-,p,m,"r#type","false"
    tracing::info!(name: "mog", r#type = false, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"r#type","false"
    tracing::info!(name: "mog", foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"r#type","false"
    tracing::info!(name: "mog", { r#type = false }, "msg without args"); // DEBUG:info,n,{},-,m,"r#type","false"
    tracing::info!(name: "mog", { foo = true, r#type = false }, "msg without args"); // DEBUG:info,n,{},p,m,"r#type","false"
    tracing::info!(name: "mog", { r#type = false, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"r#type","false"
    tracing::info!(name: "mog", { foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"r#type","false"
    tracing::info!(name: "mog", r#type = false, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"r#type","false"
    tracing::info!(name: "mog", foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"r#type","false"
    tracing::info!(name: "mog", r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"r#type","false"
    tracing::info!(name: "mog", foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"r#type","false"
    tracing::info!(name: "mog", { r#type = false }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"r#type","false"
    tracing::info!(name: "mog", { foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"r#type","false"
    tracing::info!(name: "mog", { r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"r#type","false"
    tracing::info!(name: "mog", { foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"r#type","false"
    tracing::info!(name: "mog", r#type = ?3); // DEBUG:info,n,-,-,-,"r#type","?3"
    tracing::info!(name: "mog", foo = true, r#type = ?3); // DEBUG:info,n,-,p,-,"r#type","?3"
    tracing::info!(name: "mog", r#type = ?3, qux = 3); // DEBUG:info,n,-,f,-,"r#type","?3"
    tracing::info!(name: "mog", foo = true, r#type = ?3, qux = 3); // DEBUG:info,n,-,pf,-,"r#type","?3"
    tracing::info!(name: "mog", r#type = ?3, "msg without args"); // DEBUG:info,n,-,-,m,"r#type","?3"
    tracing::info!(name: "mog", foo = true, r#type = ?3, "msg without args"); // DEBUG:info,n,-,p,m,"r#type","?3"
    tracing::info!(name: "mog", r#type = ?3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"r#type","?3"
    tracing::info!(name: "mog", foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"r#type","?3"
    tracing::info!(name: "mog", { r#type = ?3 }, "msg without args"); // DEBUG:info,n,{},-,m,"r#type","?3"
    tracing::info!(name: "mog", { foo = true, r#type = ?3 }, "msg without args"); // DEBUG:info,n,{},p,m,"r#type","?3"
    tracing::info!(name: "mog", { r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"r#type","?3"
    tracing::info!(name: "mog", { foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"r#type","?3"
    tracing::info!(name: "mog", r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"r#type","?3"
    tracing::info!(name: "mog", foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"r#type","?3"
    tracing::info!(name: "mog", r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"r#type","?3"
    tracing::info!(name: "mog", foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"r#type","?3"
    tracing::info!(name: "mog", { r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"r#type","?3"
    tracing::info!(name: "mog", { foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"r#type","?3"
    tracing::info!(name: "mog", { r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"r#type","?3"
    tracing::info!(name: "mog", { foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"r#type","?3"
    tracing::info!(name: "mog", r#type = %3); // DEBUG:info,n,-,-,-,"r#type","%3"
    tracing::info!(name: "mog", foo = true, r#type = %3); // DEBUG:info,n,-,p,-,"r#type","%3"
    tracing::info!(name: "mog", r#type = %3, qux = 3); // DEBUG:info,n,-,f,-,"r#type","%3"
    tracing::info!(name: "mog", foo = true, r#type = %3, qux = 3); // DEBUG:info,n,-,pf,-,"r#type","%3"
    tracing::info!(name: "mog", r#type = %3, "msg without args"); // DEBUG:info,n,-,-,m,"r#type","%3"
    tracing::info!(name: "mog", foo = true, r#type = %3, "msg without args"); // DEBUG:info,n,-,p,m,"r#type","%3"
    tracing::info!(name: "mog", r#type = %3, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"r#type","%3"
    tracing::info!(name: "mog", foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"r#type","%3"
    tracing::info!(name: "mog", { r#type = %3 }, "msg without args"); // DEBUG:info,n,{},-,m,"r#type","%3"
    tracing::info!(name: "mog", { foo = true, r#type = %3 }, "msg without args"); // DEBUG:info,n,{},p,m,"r#type","%3"
    tracing::info!(name: "mog", { r#type = %3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"r#type","%3"
    tracing::info!(name: "mog", { foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"r#type","%3"
    tracing::info!(name: "mog", r#type = %3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"r#type","%3"
    tracing::info!(name: "mog", foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"r#type","%3"
    tracing::info!(name: "mog", r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"r#type","%3"
    tracing::info!(name: "mog", foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"r#type","%3"
    tracing::info!(name: "mog", { r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"r#type","%3"
    tracing::info!(name: "mog", { foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"r#type","%3"
    tracing::info!(name: "mog", { r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"r#type","%3"
    tracing::info!(name: "mog", { foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"r#type","%3"
    tracing::info!(name: "mog", r#type = ?deb); // DEBUG:info,n,-,-,-,"r#type","?deb"
    tracing::info!(name: "mog", foo = true, r#type = ?deb); // DEBUG:info,n,-,p,-,"r#type","?deb"
    tracing::info!(name: "mog", r#type = ?deb, qux = 3); // DEBUG:info,n,-,f,-,"r#type","?deb"
    tracing::info!(name: "mog", foo = true, r#type = ?deb, qux = 3); // DEBUG:info,n,-,pf,-,"r#type","?deb"
    tracing::info!(name: "mog", r#type = ?deb, "msg without args"); // DEBUG:info,n,-,-,m,"r#type","?deb"
    tracing::info!(name: "mog", foo = true, r#type = ?deb, "msg without args"); // DEBUG:info,n,-,p,m,"r#type","?deb"
    tracing::info!(name: "mog", r#type = ?deb, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"r#type","?deb"
    tracing::info!(name: "mog", foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"r#type","?deb"
    tracing::info!(name: "mog", { r#type = ?deb }, "msg without args"); // DEBUG:info,n,{},-,m,"r#type","?deb"
    tracing::info!(name: "mog", { foo = true, r#type = ?deb }, "msg without args"); // DEBUG:info,n,{},p,m,"r#type","?deb"
    tracing::info!(name: "mog", { r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"r#type","?deb"
    tracing::info!(name: "mog", { foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"r#type","?deb"
    tracing::info!(name: "mog", r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"r#type","?deb"
    tracing::info!(name: "mog", foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"r#type","?deb"
    tracing::info!(name: "mog", r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"r#type","?deb"
    tracing::info!(name: "mog", foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"r#type","?deb"
    tracing::info!(name: "mog", { r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"r#type","?deb"
    tracing::info!(name: "mog", { foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"r#type","?deb"
    tracing::info!(name: "mog", { r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"r#type","?deb"
    tracing::info!(name: "mog", { foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"r#type","?deb"
    tracing::info!(name: "mog", r#type = %disp); // DEBUG:info,n,-,-,-,"r#type","%disp"
    tracing::info!(name: "mog", foo = true, r#type = %disp); // DEBUG:info,n,-,p,-,"r#type","%disp"
    tracing::info!(name: "mog", r#type = %disp, qux = 3); // DEBUG:info,n,-,f,-,"r#type","%disp"
    tracing::info!(name: "mog", foo = true, r#type = %disp, qux = 3); // DEBUG:info,n,-,pf,-,"r#type","%disp"
    tracing::info!(name: "mog", r#type = %disp, "msg without args"); // DEBUG:info,n,-,-,m,"r#type","%disp"
    tracing::info!(name: "mog", foo = true, r#type = %disp, "msg without args"); // DEBUG:info,n,-,p,m,"r#type","%disp"
    tracing::info!(name: "mog", r#type = %disp, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"r#type","%disp"
    tracing::info!(name: "mog", foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"r#type","%disp"
    tracing::info!(name: "mog", { r#type = %disp }, "msg without args"); // DEBUG:info,n,{},-,m,"r#type","%disp"
    tracing::info!(name: "mog", { foo = true, r#type = %disp }, "msg without args"); // DEBUG:info,n,{},p,m,"r#type","%disp"
    tracing::info!(name: "mog", { r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"r#type","%disp"
    tracing::info!(name: "mog", { foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"r#type","%disp"
    tracing::info!(name: "mog", r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"r#type","%disp"
    tracing::info!(name: "mog", foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"r#type","%disp"
    tracing::info!(name: "mog", r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"r#type","%disp"
    tracing::info!(name: "mog", foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"r#type","%disp"
    tracing::info!(name: "mog", { r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"r#type","%disp"
    tracing::info!(name: "mog", { foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"r#type","%disp"
    tracing::info!(name: "mog", { r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"r#type","%disp"
    tracing::info!(name: "mog", { foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"r#type","%disp"
    tracing::info!(name: "mog", r#type = ?sub.field); // DEBUG:info,n,-,-,-,"r#type","?sub.field"
    tracing::info!(name: "mog", foo = true, r#type = ?sub.field); // DEBUG:info,n,-,p,-,"r#type","?sub.field"
    tracing::info!(name: "mog", r#type = ?sub.field, qux = 3); // DEBUG:info,n,-,f,-,"r#type","?sub.field"
    tracing::info!(name: "mog", foo = true, r#type = ?sub.field, qux = 3); // DEBUG:info,n,-,pf,-,"r#type","?sub.field"
    tracing::info!(name: "mog", r#type = ?sub.field, "msg without args"); // DEBUG:info,n,-,-,m,"r#type","?sub.field"
    tracing::info!(name: "mog", foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:info,n,-,p,m,"r#type","?sub.field"
    tracing::info!(name: "mog", r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"r#type","?sub.field"
    tracing::info!(name: "mog", foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"r#type","?sub.field"
    tracing::info!(name: "mog", { r#type = ?sub.field }, "msg without args"); // DEBUG:info,n,{},-,m,"r#type","?sub.field"
    tracing::info!(name: "mog", { foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:info,n,{},p,m,"r#type","?sub.field"
    tracing::info!(name: "mog", { r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"r#type","?sub.field"
    tracing::info!(name: "mog", { foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"r#type","?sub.field"
    tracing::info!(name: "mog", r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", { r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", { foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", { r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", { foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"r#type","?sub.field"
    tracing::info!(name: "mog", r#type = %sub.field); // DEBUG:info,n,-,-,-,"r#type","%sub.field"
    tracing::info!(name: "mog", foo = true, r#type = %sub.field); // DEBUG:info,n,-,p,-,"r#type","%sub.field"
    tracing::info!(name: "mog", r#type = %sub.field, qux = 3); // DEBUG:info,n,-,f,-,"r#type","%sub.field"
    tracing::info!(name: "mog", foo = true, r#type = %sub.field, qux = 3); // DEBUG:info,n,-,pf,-,"r#type","%sub.field"
    tracing::info!(name: "mog", r#type = %sub.field, "msg without args"); // DEBUG:info,n,-,-,m,"r#type","%sub.field"
    tracing::info!(name: "mog", foo = true, r#type = %sub.field, "msg without args"); // DEBUG:info,n,-,p,m,"r#type","%sub.field"
    tracing::info!(name: "mog", r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"r#type","%sub.field"
    tracing::info!(name: "mog", foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"r#type","%sub.field"
    tracing::info!(name: "mog", { r#type = %sub.field }, "msg without args"); // DEBUG:info,n,{},-,m,"r#type","%sub.field"
    tracing::info!(name: "mog", { foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:info,n,{},p,m,"r#type","%sub.field"
    tracing::info!(name: "mog", { r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"r#type","%sub.field"
    tracing::info!(name: "mog", { foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"r#type","%sub.field"
    tracing::info!(name: "mog", r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", { r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", { foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", { r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", { foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"r#type","%sub.field"
    tracing::info!(name: "mog", r#type = debug(&deb)); // DEBUG:info,n,-,-,-,"r#type","debug(&deb)"
    tracing::info!(name: "mog", foo = true, r#type = debug(&deb)); // DEBUG:info,n,-,p,-,"r#type","debug(&deb)"
    tracing::info!(name: "mog", r#type = debug(&deb), qux = 3); // DEBUG:info,n,-,f,-,"r#type","debug(&deb)"
    tracing::info!(name: "mog", foo = true, r#type = debug(&deb), qux = 3); // DEBUG:info,n,-,pf,-,"r#type","debug(&deb)"
    tracing::info!(name: "mog", r#type = debug(&deb), "msg without args"); // DEBUG:info,n,-,-,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:info,n,-,p,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", { r#type = debug(&deb) }, "msg without args"); // DEBUG:info,n,{},-,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:info,n,{},p,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", { r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"r#type","debug(&deb)"
    tracing::info!(name: "mog", r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", { r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", { r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", { foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"r#type","debug(&deb)"
    tracing::info!(name: "mog", r#type = display(&disp)); // DEBUG:info,n,-,-,-,"r#type","display(&disp)"
    tracing::info!(name: "mog", foo = true, r#type = display(&disp)); // DEBUG:info,n,-,p,-,"r#type","display(&disp)"
    tracing::info!(name: "mog", r#type = display(&disp), qux = 3); // DEBUG:info,n,-,f,-,"r#type","display(&disp)"
    tracing::info!(name: "mog", foo = true, r#type = display(&disp), qux = 3); // DEBUG:info,n,-,pf,-,"r#type","display(&disp)"
    tracing::info!(name: "mog", r#type = display(&disp), "msg without args"); // DEBUG:info,n,-,-,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", foo = true, r#type = display(&disp), "msg without args"); // DEBUG:info,n,-,p,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", { r#type = display(&disp) }, "msg without args"); // DEBUG:info,n,{},-,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", { foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:info,n,{},p,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", { r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", { foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"r#type","display(&disp)"
    tracing::info!(name: "mog", r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", { r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", { foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", { r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", { foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"r#type","display(&disp)"
    tracing::info!(name: "mog", r#type = tracing::field::Empty); // DEBUG:info,n,-,-,-,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, r#type = tracing::field::Empty); // DEBUG:info,n,-,p,-,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", r#type = tracing::field::Empty, qux = 3); // DEBUG:info,n,-,f,-,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:info,n,-,pf,-,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", r#type = tracing::field::Empty, "msg without args"); // DEBUG:info,n,-,-,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:info,n,-,p,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", { r#type = tracing::field::Empty }, "msg without args"); // DEBUG:info,n,{},-,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:info,n,{},p,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", { r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", { r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", { r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::info!(name: "mog", var); // DEBUG:info,n,-,-,-,-,"var"
    tracing::info!(name: "mog", foo = true, var); // DEBUG:info,n,-,p,-,-,"var"
    tracing::info!(name: "mog", var, qux = 3); // DEBUG:info,n,-,f,-,-,"var"
    tracing::info!(name: "mog", foo = true, var, qux = 3); // DEBUG:info,n,-,pf,-,-,"var"
    tracing::info!(name: "mog", var, "msg without args"); // DEBUG:info,n,-,-,m,-,"var"
    tracing::info!(name: "mog", foo = true, var, "msg without args"); // DEBUG:info,n,-,p,m,-,"var"
    tracing::info!(name: "mog", var, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,-,"var"
    tracing::info!(name: "mog", foo = true, var, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,-,"var"
    tracing::info!(name: "mog", { var }, "msg without args"); // DEBUG:info,n,{},-,m,-,"var"
    tracing::info!(name: "mog", { foo = true, var }, "msg without args"); // DEBUG:info,n,{},p,m,-,"var"
    tracing::info!(name: "mog", { var, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,-,"var"
    tracing::info!(name: "mog", { foo = true, var, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,-,"var"
    tracing::info!(name: "mog", var, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,-,"var"
    tracing::info!(name: "mog", foo = true, var, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,-,"var"
    tracing::info!(name: "mog", var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,-,"var"
    tracing::info!(name: "mog", foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,-,"var"
    tracing::info!(name: "mog", { var }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,-,"var"
    tracing::info!(name: "mog", { foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,-,"var"
    tracing::info!(name: "mog", { var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,-,"var"
    tracing::info!(name: "mog", { foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,-,"var"
    tracing::info!(name: "mog", sub.field); // DEBUG:info,n,-,-,-,-,"sub.field"
    tracing::info!(name: "mog", foo = true, sub.field); // DEBUG:info,n,-,p,-,-,"sub.field"
    tracing::info!(name: "mog", sub.field, qux = 3); // DEBUG:info,n,-,f,-,-,"sub.field"
    tracing::info!(name: "mog", foo = true, sub.field, qux = 3); // DEBUG:info,n,-,pf,-,-,"sub.field"
    tracing::info!(name: "mog", sub.field, "msg without args"); // DEBUG:info,n,-,-,m,-,"sub.field"
    tracing::info!(name: "mog", foo = true, sub.field, "msg without args"); // DEBUG:info,n,-,p,m,-,"sub.field"
    tracing::info!(name: "mog", sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,-,"sub.field"
    tracing::info!(name: "mog", foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,-,"sub.field"
    tracing::info!(name: "mog", { sub.field }, "msg without args"); // DEBUG:info,n,{},-,m,-,"sub.field"
    tracing::info!(name: "mog", { foo = true, sub.field }, "msg without args"); // DEBUG:info,n,{},p,m,-,"sub.field"
    tracing::info!(name: "mog", { sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,-,"sub.field"
    tracing::info!(name: "mog", { foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,-,"sub.field"
    tracing::info!(name: "mog", sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,-,"sub.field"
    tracing::info!(name: "mog", foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,-,"sub.field"
    tracing::info!(name: "mog", sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,-,"sub.field"
    tracing::info!(name: "mog", foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,-,"sub.field"
    tracing::info!(name: "mog", { sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,-,"sub.field"
    tracing::info!(name: "mog", { foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,-,"sub.field"
    tracing::info!(name: "mog", { sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,-,"sub.field"
    tracing::info!(name: "mog", { foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,-,"sub.field"
    tracing::info!(name: "mog", %disp); // DEBUG:info,n,-,-,-,-,"%disp"
    tracing::info!(name: "mog", foo = true, %disp); // DEBUG:info,n,-,p,-,-,"%disp"
    tracing::info!(name: "mog", %disp, qux = 3); // DEBUG:info,n,-,f,-,-,"%disp"
    tracing::info!(name: "mog", foo = true, %disp, qux = 3); // DEBUG:info,n,-,pf,-,-,"%disp"
    tracing::info!(name: "mog", %disp, "msg without args"); // DEBUG:info,n,-,-,m,-,"%disp"
    tracing::info!(name: "mog", foo = true, %disp, "msg without args"); // DEBUG:info,n,-,p,m,-,"%disp"
    tracing::info!(name: "mog", %disp, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,-,"%disp"
    tracing::info!(name: "mog", foo = true, %disp, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,-,"%disp"
    tracing::info!(name: "mog", { %disp }, "msg without args"); // DEBUG:info,n,{},-,m,-,"%disp"
    tracing::info!(name: "mog", { foo = true, %disp }, "msg without args"); // DEBUG:info,n,{},p,m,-,"%disp"
    tracing::info!(name: "mog", { %disp, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,-,"%disp"
    tracing::info!(name: "mog", { foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,-,"%disp"
    tracing::info!(name: "mog", %disp, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,-,"%disp"
    tracing::info!(name: "mog", foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,-,"%disp"
    tracing::info!(name: "mog", %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,-,"%disp"
    tracing::info!(name: "mog", foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,-,"%disp"
    tracing::info!(name: "mog", { %disp }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,-,"%disp"
    tracing::info!(name: "mog", { foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,-,"%disp"
    tracing::info!(name: "mog", { %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,-,"%disp"
    tracing::info!(name: "mog", { foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,-,"%disp"
    tracing::info!(name: "mog", ?deb); // DEBUG:info,n,-,-,-,-,"?deb"
    tracing::info!(name: "mog", foo = true, ?deb); // DEBUG:info,n,-,p,-,-,"?deb"
    tracing::info!(name: "mog", ?deb, qux = 3); // DEBUG:info,n,-,f,-,-,"?deb"
    tracing::info!(name: "mog", foo = true, ?deb, qux = 3); // DEBUG:info,n,-,pf,-,-,"?deb"
    tracing::info!(name: "mog", ?deb, "msg without args"); // DEBUG:info,n,-,-,m,-,"?deb"
    tracing::info!(name: "mog", foo = true, ?deb, "msg without args"); // DEBUG:info,n,-,p,m,-,"?deb"
    tracing::info!(name: "mog", ?deb, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,-,"?deb"
    tracing::info!(name: "mog", foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,-,"?deb"
    tracing::info!(name: "mog", { ?deb }, "msg without args"); // DEBUG:info,n,{},-,m,-,"?deb"
    tracing::info!(name: "mog", { foo = true, ?deb }, "msg without args"); // DEBUG:info,n,{},p,m,-,"?deb"
    tracing::info!(name: "mog", { ?deb, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,-,"?deb"
    tracing::info!(name: "mog", { foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,-,"?deb"
    tracing::info!(name: "mog", ?deb, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,-,"?deb"
    tracing::info!(name: "mog", foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,-,"?deb"
    tracing::info!(name: "mog", ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,-,"?deb"
    tracing::info!(name: "mog", foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,-,"?deb"
    tracing::info!(name: "mog", { ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,-,"?deb"
    tracing::info!(name: "mog", { foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,-,"?deb"
    tracing::info!(name: "mog", { ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,-,"?deb"
    tracing::info!(name: "mog", { foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,-,"?deb"
    tracing::info!(name: "mog", %sub.field); // DEBUG:info,n,-,-,-,-,"%sub.field"
    tracing::info!(name: "mog", foo = true, %sub.field); // DEBUG:info,n,-,p,-,-,"%sub.field"
    tracing::info!(name: "mog", %sub.field, qux = 3); // DEBUG:info,n,-,f,-,-,"%sub.field"
    tracing::info!(name: "mog", foo = true, %sub.field, qux = 3); // DEBUG:info,n,-,pf,-,-,"%sub.field"
    tracing::info!(name: "mog", %sub.field, "msg without args"); // DEBUG:info,n,-,-,m,-,"%sub.field"
    tracing::info!(name: "mog", foo = true, %sub.field, "msg without args"); // DEBUG:info,n,-,p,m,-,"%sub.field"
    tracing::info!(name: "mog", %sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,-,"%sub.field"
    tracing::info!(name: "mog", foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,-,"%sub.field"
    tracing::info!(name: "mog", { %sub.field }, "msg without args"); // DEBUG:info,n,{},-,m,-,"%sub.field"
    tracing::info!(name: "mog", { foo = true, %sub.field }, "msg without args"); // DEBUG:info,n,{},p,m,-,"%sub.field"
    tracing::info!(name: "mog", { %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,-,"%sub.field"
    tracing::info!(name: "mog", { foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,-,"%sub.field"
    tracing::info!(name: "mog", %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,-,"%sub.field"
    tracing::info!(name: "mog", foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,-,"%sub.field"
    tracing::info!(name: "mog", %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,-,"%sub.field"
    tracing::info!(name: "mog", foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,-,"%sub.field"
    tracing::info!(name: "mog", { %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,-,"%sub.field"
    tracing::info!(name: "mog", { foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,-,"%sub.field"
    tracing::info!(name: "mog", { %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,-,"%sub.field"
    tracing::info!(name: "mog", { foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,-,"%sub.field"
    tracing::info!(name: "mog", ?sub.field); // DEBUG:info,n,-,-,-,-,"?sub.field"
    tracing::info!(name: "mog", foo = true, ?sub.field); // DEBUG:info,n,-,p,-,-,"?sub.field"
    tracing::info!(name: "mog", ?sub.field, qux = 3); // DEBUG:info,n,-,f,-,-,"?sub.field"
    tracing::info!(name: "mog", foo = true, ?sub.field, qux = 3); // DEBUG:info,n,-,pf,-,-,"?sub.field"
    tracing::info!(name: "mog", ?sub.field, "msg without args"); // DEBUG:info,n,-,-,m,-,"?sub.field"
    tracing::info!(name: "mog", foo = true, ?sub.field, "msg without args"); // DEBUG:info,n,-,p,m,-,"?sub.field"
    tracing::info!(name: "mog", ?sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,f,m,-,"?sub.field"
    tracing::info!(name: "mog", foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:info,n,-,pf,m,-,"?sub.field"
    tracing::info!(name: "mog", { ?sub.field }, "msg without args"); // DEBUG:info,n,{},-,m,-,"?sub.field"
    tracing::info!(name: "mog", { foo = true, ?sub.field }, "msg without args"); // DEBUG:info,n,{},p,m,-,"?sub.field"
    tracing::info!(name: "mog", { ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},f,m,-,"?sub.field"
    tracing::info!(name: "mog", { foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:info,n,{},pf,m,-,"?sub.field"
    tracing::info!(name: "mog", ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,-,ma,-,"?sub.field"
    tracing::info!(name: "mog", foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:info,n,-,p,ma,-,"?sub.field"
    tracing::info!(name: "mog", ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,f,ma,-,"?sub.field"
    tracing::info!(name: "mog", foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:info,n,-,pf,ma,-,"?sub.field"
    tracing::info!(name: "mog", { ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},-,ma,-,"?sub.field"
    tracing::info!(name: "mog", { foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},p,ma,-,"?sub.field"
    tracing::info!(name: "mog", { ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},f,ma,-,"?sub.field"
    tracing::info!(name: "mog", { foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:info,n,{},pf,ma,-,"?sub.field"
}
