/* Test data clause diagnostics.  */

/* See also corresponding OpenACC C/C++ variant: '../../c-c++-common/goacc/data-clause-2.c'.  */

/* See also corresponding OpenACC 'cache' directive variant: 'cache-3-2.C'.  */

/* See also corresponding OpenMP variant: '../gomp/map-2.C'.  */

/* Array sections without spaces between [ and : or : and ] are incompatible
   with C++26.  */
/* { dg-skip-if "array sections vs. C++26" { c++26 } } */

template <int N>
void
foo (int *p, int (*q)[10], int r[10], int s[10][10])
{
  int a[10], b[10][10];
  #pragma acc parallel copy (p[-1:2])
  ;
  #pragma acc parallel copy (q[-1:2][0:10])
  ;
  #pragma acc parallel copy (q[-1:2][-2:10]) /* { dg-error "negative low bound in array section in" } */
  ;
  #pragma acc parallel copy (r[-1:2])
  ;
  #pragma acc parallel copy (s[-1:2][:])
  ;
  #pragma acc parallel copy (s[-1:2][-2:10]) /* { dg-error "negative low bound in array section in" } */
  ;
  #pragma acc parallel copy (a[-1:2])	 /* { dg-error "negative low bound in array section in" } */
  ;
  #pragma acc parallel copy (b[-1:2][0:])	 /* { dg-error "negative low bound in array section in" } */
  ;
  #pragma acc parallel copy (b[1:2][-2:10]) /* { dg-error "negative low bound in array section in" } */
  ;
  #pragma acc parallel copy (p[2:-3])	 /* { dg-error "negative length in array section in" } */
  ;
  #pragma acc parallel copy (q[2:-3][:])	 /* { dg-error "negative length in array section in" } */
  ;
  #pragma acc parallel copy (q[2:3][0:-1])	 /* { dg-error "negative length in array section in" } */
  ;
  #pragma acc parallel copy (r[2:-5])	 /* { dg-error "negative length in array section in" } */
  ;
  #pragma acc parallel copy (s[2:-5][:])	 /* { dg-error "negative length in array section in" } */
  ;
  #pragma acc parallel copy (s[2:5][0:-4])	 /* { dg-error "negative length in array section in" } */
  ;
  #pragma acc parallel copy (a[2:-5])	 /* { dg-error "negative length in array section in" } */
  ;
  #pragma acc parallel copy (b[2:-5][0:10]) /* { dg-error "negative length in array section in" } */
  ;
  #pragma acc parallel copy (b[2:5][0:-4]) /* { dg-error "negative length in array section in" } */
  ;
}

static void
instantiate ()
{
  &foo<0>;
}
