/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.keystroke;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.util.Lists;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.keystroke.KeyStrokeMapping;
import org.assertj.swing.util.Platform;

final class KeyStrokeMappings {
    @Nonnull
    static Collection<KeyStrokeMapping> defaultMappings() {
        ArrayList mappings = Lists.newArrayList();
        mappings.add(KeyStrokeMapping.mapping('\b', 8, 0));
        mappings.add(KeyStrokeMapping.mapping('\u007f', 127, 0));
        mappings.add(KeyStrokeMapping.mapping('\n', 10, 0));
        if (Platform.isWindows()) {
            mappings.add(KeyStrokeMapping.mapping('\r', 10, 0));
        }
        mappings.add(KeyStrokeMapping.mapping('\u001b', 27, 0));
        mappings.add(KeyStrokeMapping.mapping('\t', 9, 0));
        return mappings;
    }

    private KeyStrokeMappings() {
    }
}

