/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend;

import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.frontend.FrontendApplicationInfo;
import com.intellij.frontend.FrontendType;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.frontend.FrontendXDebuggerManager;
import com.intellij.platform.debugger.impl.frontend.evaluate.quick.FrontendXValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerProxy;
import com.intellij.xdebugger.impl.frame.XDebugManagerProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.rpc.XDebugSessionId;
import com.intellij.xdebugger.impl.rpc.XValueId;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016JH\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\"\u0010\f\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\rH\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/platform/debugger/impl/frontend/FrontendXDebugManagerProxy;", "Lcom/intellij/xdebugger/impl/frame/XDebugManagerProxy;", "<init>", "()V", "isEnabled", "", "withId", "T", "value", "Lcom/intellij/xdebugger/frame/XValue;", "session", "Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "block", "Lkotlin/Function2;", "Lcom/intellij/xdebugger/impl/rpc/XValueId;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/intellij/xdebugger/frame/XValue;Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCurrentSessionProxy", "project", "Lcom/intellij/openapi/project/Project;", "getSessionIdByContentDescriptor", "Lcom/intellij/xdebugger/impl/rpc/XDebugSessionId;", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "getCurrentSessionFlow", "Lkotlinx/coroutines/flow/Flow;", "getSessions", "", "getBreakpointManagerProxy", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointManagerProxy;", "canUpdateInlineDebuggerFrames", "intellij.platform.debugger.impl.frontend"})
final class FrontendXDebugManagerProxy
implements XDebugManagerProxy {
    public boolean isEnabled() {
        FrontendType frontendType = FrontendApplicationInfo.INSTANCE.getFrontendType();
        return XDebugSessionProxy.Companion.useFeProxy() || frontendType instanceof FrontendType.RemoteDev && !((FrontendType.RemoteDev)frontendType).isLuxSupported();
    }

    @Nullable
    public <T> Object withId(@NotNull XValue value, @NotNull XDebugSessionProxy session, @NotNull Function2<? super XValueId, ? super Continuation<? super T>, ? extends Object> block, @NotNull Continuation<? super T> $completion) {
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.intellij.platform.debugger.impl.frontend.evaluate.quick.FrontendXValue");
        XValueId valueId = ((FrontendXValue)value).getXValueDto().getId();
        return block.invoke((Object)valueId, $completion);
    }

    @Nullable
    public XDebugSessionProxy getCurrentSessionProxy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (XDebugSessionProxy)FrontendXDebuggerManager.Companion.getInstance(project).getCurrentSession().getValue();
    }

    @Nullable
    public XDebugSessionId getSessionIdByContentDescriptor(@NotNull Project project, @NotNull RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return FrontendXDebuggerManager.Companion.getInstance(project).getSessionIdByContentDescriptor$intellij_platform_debugger_impl_frontend(descriptor);
    }

    @NotNull
    public Flow<XDebugSessionProxy> getCurrentSessionFlow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (Flow)FrontendXDebuggerManager.Companion.getInstance(project).getCurrentSession();
    }

    @NotNull
    public List<XDebugSessionProxy> getSessions(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return FrontendXDebuggerManager.Companion.getInstance(project).getSessions$intellij_platform_debugger_impl_frontend();
    }

    @NotNull
    public XBreakpointManagerProxy getBreakpointManagerProxy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return FrontendXDebuggerManager.Companion.getInstance(project).getBreakpointsManager();
    }

    public boolean canUpdateInlineDebuggerFrames() {
        FrontendType frontendType = FrontendApplicationInfo.INSTANCE.getFrontendType();
        boolean isCwm = frontendType instanceof FrontendType.RemoteDev && !((FrontendType.RemoteDev)frontendType).isLuxSupported();
        return !isCwm;
    }
}

