/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.blockmap;

import com.jetbrains.rd.platform.codeWithMe.blockmap.Chunk;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\bH\u0002J*\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\t\u0010\u001e\u001a\u00020\u001fH\u0096\u0002J\t\u0010 \u001a\u00020\u0002H\u0096\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/blockmap/FastCDCImpl;", "", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/Chunk;", "source", "Ljava/io/InputStream;", "algorithm", "", "minSize", "", "maxSize", "normalSize", "<init>", "(Ljava/io/InputStream;Ljava/lang/String;III)V", "maskS", "maskL", "input", "Ljava/io/BufferedInputStream;", "cur", "bytesProcessed", "cut", "sourceOffset", "findChunk", "buffer", "Ljava/io/ByteArrayOutputStream;", "mask", "length", "createChunk", "data", "", "getChunkHash", "hasNext", "", "next", "logarithm2", "value", "bits", "Companion", "intellij.platform.split"})
public final class FastCDCImpl
implements Iterator<Chunk>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String algorithm;
    private final int minSize;
    private final int maxSize;
    private final int normalSize;
    private final int maskS;
    private final int maskL;
    @NotNull
    private final BufferedInputStream input;
    private int cur;
    private int bytesProcessed;
    @NotNull
    private static final Integer[] TABLE;

    public FastCDCImpl(@NotNull InputStream source, @NotNull String algorithm, int minSize, int maxSize, int normalSize) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.algorithm = algorithm;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.normalSize = normalSize;
        this.maskS = this.mask(this.logarithm2(this.normalSize) + 1);
        this.maskL = this.mask(this.logarithm2(this.normalSize) - 1);
        InputStream inputStream = source;
        int n = 8192;
        this.input = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
        this.cur = this.input.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Chunk cut(int sourceOffset) {
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            Chunk chunk;
            ByteArrayOutputStream buffer = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            while (buffer.size() < this.minSize && this.cur != -1) {
                buffer.write(this.cur);
                this.cur = this.input.read();
            }
            if (buffer.size() < this.minSize) {
                byte[] byArray = buffer.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                Chunk chunk2 = this.createChunk(byArray, sourceOffset);
                return chunk2;
            }
            Chunk chunk3 = chunk = this.findChunk(buffer, this.maskS, this.normalSize, sourceOffset);
            if (chunk3 != null) {
                Chunk chunk4 = chunk3;
                return chunk4;
            }
            Chunk chunk5 = chunk = this.findChunk(buffer, this.maskL, this.maxSize, sourceOffset);
            if (chunk5 != null) {
                Chunk chunk6 = chunk5;
                return chunk6;
            }
            byte[] byArray = buffer.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            Chunk chunk7 = this.createChunk(byArray, sourceOffset);
            return chunk7;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Chunk findChunk(ByteArrayOutputStream buffer, int mask, int length, int sourceOffset) {
        int hash = 0;
        while (buffer.size() < length && this.cur != -1) {
            int index = this.cur & 0xFF;
            buffer.write(this.cur);
            hash = (hash >> 1) + TABLE[index];
            this.cur = this.input.read();
            if ((hash & mask) != 0) continue;
            byte[] byArray = buffer.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            return this.createChunk(byArray, sourceOffset);
        }
        if (this.cur == -1) {
            byte[] byArray = buffer.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            return this.createChunk(byArray, sourceOffset);
        }
        return null;
    }

    private final Chunk createChunk(byte[] data, int sourceOffset) {
        return new Chunk(this.getChunkHash(data, this.algorithm), sourceOffset, data.length);
    }

    private final String getChunkHash(byte[] source, String algorithm) {
        String string = Base64.getEncoder().encodeToString(MessageDigest.getInstance(algorithm).digest(source));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    @Override
    public boolean hasNext() {
        return this.cur != -1;
    }

    @Override
    @NotNull
    public Chunk next() {
        if (this.cur == -1) {
            throw new NoSuchElementException();
        }
        Chunk chunk = this.cut(this.bytesProcessed);
        this.bytesProcessed += chunk.getLength();
        return chunk;
    }

    private final int logarithm2(int value) {
        return MathKt.roundToInt((double)(Math.log(value) / Math.log(2.0)));
    }

    private final int mask(int bits) {
        if (bits < 1 || bits > 31) {
            throw new IllegalArgumentException("The bits value must be >=1 and <=31");
        }
        return (int)(Math.pow(2.0, bits) - 1.0);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    static {
        Integer[] integerArray = new Integer[]{1553318008, 574654857, 759734804, 310648967, 1393527547, 1195718329, 694400241, 1154184075, 1319583805, 1298164590, 122602963, 989043992, 1918895050, 933636724, 1369634190, 1963341198, 1565176104, 1296753019, 1105746212, 1191982839, 1195494369, 29065008, 1635524067, 722221599, 1355059059, 564669751, 1620421856, 1100048288, 1018120624, 1087284781, 1723604070, 1415454125, 737834957, 1854265892, 1605418437, 1697446953, 973791659, 674750707, 1669838606, 320299026, 1130545851, 1725494449, 939321396, 748475270, 554975894, 1651665064, 1695413559, 671470969, 992078781, 1935142196, 1062778243, 1901125066, 1935811166, 1644847216, 744420649, 2068980838, 1988851904, 1263854878, 1979320293, 111370182, 817303588, 478553825, 694867320, 685227566, 345022554, 2095989693, 1770739427, 165413158, 1322704750, 46251975, 710520147, 700507188, 2104251000, 1350123687, 1593227923, 1756802846, 1179873910, 1629210470, 358373501, 807118919, 751426983, 172199468, 174707988, 1951167187, 1328704411, 2129871494, 1242495143, 1793093310, 1721521010, 306195915, 1609230749, 1992815783, 1790818204, 234528824, 551692332, 1930351755, 110996527, 378457918, 638641695, 743517326, 368806918, 1583529078, 1767199029, 182158924, 1114175764, 882553770, 552467890, 1366456705, 934589400, 1574008098, 1798094820, 1548210079, 821697741, 601807702, 332526858, 1693310695, 136360183, 1189114632, 506273277, 397438002, 620771032, 676183860, 1747529440, 909035644, 142389739, 1991534368, 272707803, 1905681287, 1210958911, 596176677, 1380009185, 1153270606, 1150188963, 1067903737, 1020928348, 978324723, 962376754, 1368724127, 1133797255, 1367747748, 1458212849, 537933020, 1295159285, 2104731913, 1647629177, 1691336604, 922114202, 170715530, 1608833393, 62657989, 1140989235, 381784875, 928003604, 449509021, 1057208185, 1239816707, 525522922, 476962140, 102897870, 132620570, 419788154, 2095057491, 1240747817, 1271689397, 973007445, 1380110056, 1021668229, 12064370, 1186917580, 1017163094, 597085928, 2018803520, 1795688603, 1722115921, 2015264326, 506263638, 1002517905, 1229603330, 1376031959, 763839898, 1970623926, 1109937345, 524780807, 1976131071, 905940439, 1313298413, 772929676, 1578848328, 1108240025, 577439381, 1293318580, 1512203375, 371003697, 308046041, 320070446, 1252546340, 568098497, 1341794814, 1922466690, 480833267, 1060838440, 969079660, 1836468543, 2049091118, 2023431210, 383830867, 2112679659, 231203270, 1551220541, 1377927987, 275637462, 2110145570, 1700335604, 738389040, 1688841319, 1506456297, 1243730675, 258043479, 599084776, 41093802, 792486733, 1897397356, 28077829, 1520357900, 361516586, 1119263216, 209458355, 45979201, 363681532, 477245280, 2107748241, 601938891, 244572459, 1689418013, 1141711990, 1485744349, 1181066840, 1950794776, 410494836, 1445347454, 2137242950, 852679640, 1014566730, 1999335993, 1871390758, 1736439305, 231222289, 603972436, 783045542, 370384393, 184356284, 709706295, 1453549767, 591603172, 768512391, 854125182};
        TABLE = integerArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/blockmap/FastCDCImpl$Companion;", "", "<init>", "()V", "TABLE", "", "", "[Ljava/lang/Integer;", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

