/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.lang;

import com.intellij.codeInsight.inline.completion.InlineCompletionRequest;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.ml.inline.completion.impl.lang.MLCompletionEditorLanguageResolver;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0003J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000fH\u0002R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/inline/completion/impl/lang/MLCompletionLanguageUtils;", "", "<init>", "()V", "LANGUAGE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/lang/Language;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getMostAccurateLanguage", "request", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;", "getInjectedEditorOrEditor", "Lcom/intellij/openapi/editor/Editor;", "getInjectedFileAt", "Lcom/intellij/psi/PsiFile;", "shouldInjectedLanguageBeChecked", "", "intellij.fullLine.core.completion"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMLCompletionLanguageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionLanguageUtils.kt\ncom/intellij/ml/inline/completion/impl/lang/MLCompletionLanguageUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class MLCompletionLanguageUtils {
    @NotNull
    public static final MLCompletionLanguageUtils INSTANCE = new MLCompletionLanguageUtils();
    @NotNull
    private static final Key<Language> LANGUAGE_KEY;

    private MLCompletionLanguageUtils() {
    }

    @JvmStatic
    @NotNull
    public static final Language getMostAccurateLanguage(@NotNull InlineCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Language language = (Language)request.getUserData(LANGUAGE_KEY);
        if (language != null) {
            Language it = language;
            boolean bl = false;
            return it;
        }
        Language result2 = MLCompletionEditorLanguageResolver.Companion.resolveCustomLanguageOrNull$intellij_fullLine_core_completion(request.getEditor());
        if (result2 == null && (result2 = (Language)ActionsKt.runReadAction(() -> MLCompletionLanguageUtils.getMostAccurateLanguage$lambda$1(request))) == request.getFile().getLanguage()) {
            result2 = MLCompletionLanguageUtils.getInjectedFileAt(request).getLanguage();
        }
        request.putUserData(LANGUAGE_KEY, (Object)result2);
        return result2;
    }

    @JvmStatic
    @NotNull
    public static final Editor getInjectedEditorOrEditor(@NotNull InlineCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Editor editor2 = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)request.getEditor(), (PsiFile)MLCompletionLanguageUtils.getInjectedFileAt(request));
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getInjectedEditorForInjectedFile(...)");
        return editor2;
    }

    @JvmStatic
    private static final PsiFile getInjectedFileAt(InlineCompletionRequest request) {
        if (!INSTANCE.shouldInjectedLanguageBeChecked(request.getFile())) {
            return request.getFile();
        }
        PsiFile originalFile = request.getFile();
        Project project = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        int offset = request.getEndOffset();
        List list = InjectedLanguageManager.getInstance((Project)project2).getCachedInjectedDocumentsInRange(originalFile, (TextRange)ProperTextRange.create((int)offset, (int)offset));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCachedInjectedDocumentsInRange(...)");
        List injectedDocuments = list;
        for (DocumentWindow injectedDocument : injectedDocuments) {
            if (!injectedDocument.isValid() || !injectedDocument.containsRange(offset, offset)) continue;
            PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile((Document)injectedDocument);
            if (psiFile2 == null) continue;
            PsiFile injectedFile = psiFile2;
            return injectedFile;
        }
        return originalFile;
    }

    private final boolean shouldInjectedLanguageBeChecked(PsiFile $this$shouldInjectedLanguageBeChecked) {
        return Intrinsics.areEqual((Object)$this$shouldInjectedLanguageBeChecked.getFileType().getDefaultExtension(), (Object)"ipynb");
    }

    private static final Language getMostAccurateLanguage$lambda$1(InlineCompletionRequest $request) {
        return PsiUtilCore.getLanguageAtOffset((PsiFile)$request.getFile(), (int)$request.getEndOffset());
    }

    static {
        Key key = Key.create((String)"ml.inline.completion.request.injected.language");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LANGUAGE_KEY = key;
    }
}

