## RabbitMQ 3.8.9

RabbitMQ `3.8.9` is a maintenance release.
It focuses on bug fixes and usability improvements.

This release [**no longer supports** Erlang 21.3](https://groups.google.com/forum/#!topic/rabbitmq-users/v3K5nZNsfwM).

### Erlang 23 Compatibility

This release is [compatible](https://groups.google.com/forum/#!topic/rabbitmq-users/wlPIWz3UYHQ) with [Erlang 23](http://blog.erlang.org/OTP-23-Highlights/).

### Erlang/OTP Compatibility Notes

This release [**requires Erlang/OTP 22.0**](https://www.rabbitmq.com/which-erlang.html) or later.
`22.3` or `23.0` releases are recommended.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `22.3.x`.


## Upgrade and Compatibility Notes

### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade and
compatibility notes first if upgrading from an earlier release series (e.g. `3.7.x`).

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Upgrading to Erlang 22.x or Later Versions

When upgrading to this release from `3.7.15` or an older version, extra care has to be taken.

Because older RabbitMQ CLI tools can be incompatible with Erlang 22+ releases,
RabbitMQ **must be upgraded at the same time as Erlang**.

Alternatively the node can be upgraded to `3.7.18` on Erlang 21.3 first,
then Erlang 22.x or 23.x, then RabbitMQ to most recent 3.8.x release.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes Worth Mentioning

### Core Server

#### Bug Fixes

 * Starting with `3.8.0`, an unintentionally introduced assertion could prevent classic mirrored queue
   mirrors from starting successfully in case the primary replica changed concurrently with their startup.

   GitHub issue: [rabbitmq/rabbitmq-server#2449](https://github.com/rabbitmq/rabbitmq-server/pull/2449)

#### Enhancements

 * Raft implementation's [failure detector](https://github.com/rabbitmq/aten) default polling interval has been increased from 1s to 5s.
   The previously used default results in too frequent leader elections in networks with high packet loss
   (say, double digit percent).

   This has no correctness or safety ramifications, however, automated tests that assert on Raft properties
   or expect a very fast leader re-election may have to set it back so that peer failures are detected quicker.

   GitHub issue: [rabbitmq/rabbitmq-server#2450](https://github.com/rabbitmq/rabbitmq-server/pull/2450)


### Management Plugin

#### Bug Fixes

 * The now deprecated intrusive health check endpoint, `GET /api/healthchecks/node`, reported failures in the response
   but always set the status to `200 OK`. It now uses the status of `500` in case of a failure.

   [RabbitMQ Monitoring guide](https://www.rabbitmq.com/monitoring.html#health-checks) explains why
   this health check is no longer recommended and what the alternatives are.

   GitHub issue: [rabbitmq/rabbitmq-management#840](https://github.com/rabbitmq/rabbitmq-management/issues/840)

#### Enhancements

 * When a client doubly encodes a request into JSON, the plugin tries to detect that and will produce a more
   helpful 400 response instead of a 500.

   GitHub issue: [rabbitmq/rabbitmq-management#839](https://github.com/rabbitmq/rabbitmq-management/issues/839)


### Federation Plugin

#### Bug Fixes

 * When a classic mirrored queue with a replica on every cluster node (this is [highly discouraged](https://www.rabbitmq.com/ha.html#replication-factor)) was federated,
   multiple links could be started by the plugin, potentially making message transfers concurrent
   and affecting ordering.

   GitHub issue: [rabbitmq/rabbitmq-federation#114](https://github.com/rabbitmq/rabbitmq-federation/issues/114)

#### Enhancements

 * It is now possible to federate exchanges in different virtual hosts in the same cluster for more than one hop.
   For example, federate messages from an exchange in virtual host B to C, while B itself is federated from
   virtual host A. Previously such messages would have been filtered by the message cycle detection algorithm
   which assumed that exchanges are only federated across clusters.

   GitHub issue: [rabbitmq/rabbitmq-federation#116](https://github.com/rabbitmq/rabbitmq-federation/issues/116)


### Kubernetes Peer Discovery Plugin

#### Bug Fixes

 * Kubernetes API events registered by this plugin mixed up reason and message fields.

   Contributed by Gabriele Santomaggio.

   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-k8s#70](https://github.com/rabbitmq/rabbitmq-peer-discovery-k8s/pull/70)


### OAuth 2 AuthN/AuthZ Plugin

#### Enhancements

 * Improved compatibility with Azure AD. This plugin can now be configured to fetch scopes from a non-standard
   field in the decoded token value (other than the standard `scopes` field).

   Contributed by @Robert-Gustafsson.

   GitHub issue: [rabbitmq/rabbitmq-auth-backend-oauth2#53](https://github.com/rabbitmq/rabbitmq-auth-backend-oauth2/pull/53)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker, not the plugins or the client libraries.
Please download the archive named `rabbitmq-server-3.8.9.tar.xz`.
