## RabbitMQ 3.8.28

RabbitMQ `3.8.28` is a maintenance release.
All users are recommended to upgrade to this release.

### Obtaining Packages

RabbitMQ releases are distributed via [GitHub](https://github.com/rabbitmq/rabbitmq-server/releases), [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/),
and [PackageCloud](https://packagecloud.io/rabbitmq).

### Erlang/OTP Compatibility Notes

This release [requires Erlang 23.2](https://www.rabbitmq.com/which-erlang.html) and [supports Erlang 24](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/).

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision modern Erlang versions.


## Upgrade and Compatibility Notes

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

If upgrading from a`3.7.x` release, see [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0)
upgrade and compatibility notes first.

If upgrading from a `3.6.x` or older [release series](https://www.rabbitmq.com/versions.html), first upgrade
to [`3.7.27`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.27) and then to this version.


## Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.8.x/release-notes).
Contributors are encouraged to update them together with their changes.  This helps with release automation and more
consistent release schedule.


### Core Server

#### Bug Fixes

 * Inter-node communication listener IP address was hardcoded in
   the output of `rabbitmq-diagnostics status` and related commands.

   Contributed by @tomyouyou.

   GitHub issue: [#3956](https://github.com/rabbitmq/rabbitmq-server/pull/3956)


### OAuth 2 AuthN/AuthZ Backend Plugin

#### Bug Fixes

 * `auth_oauth2.additional_scopes_key` in `rabbitmq.conf` was not converted correctly
   during configuration translation and thus had no effect.

   Contributed by @luos.

   GitHub issue: [#4105](https://github.com/rabbitmq/rabbitmq-server/pull/4105)


### LDAP AuthN/AuthZ Backend Plugin

#### Enhancement

 * Adapt to a breaking Erlang 24.3 LDAP client change.

   GitHub issue: [#4287](https://github.com/rabbitmq/rabbitmq-server/pull/4287)


### Shovel Plugin

#### Enhacements

 * Shovels now can be declared with `delete-after` parameter set to `0`.
   Such shovels will immediately stop instead of erroring and failing to
   start after a node restart.

   Contributed by @luos.

   GitHub issue: [#4101](https://github.com/rabbitmq/rabbitmq-server/pull/4101)


### Consul Peer Discovery Plugin

#### Enhancements

 * Support for Consul 1.1 [response code changes](https://github.com/hashicorp/consul/pull/11950)
   when an operation is attempted on a non-existent health check.

   Suggested by @maestroes.

   GitHub issue: [#4155](https://github.com/rabbitmq/rabbitmq-server/pull/4155)


## Dependency Upgrades

 None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.28.tar.xz`
instead of the source tarball produced by GitHub.

