RabbitMQ `3.11.6` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).


### Core Server

#### Enhancements

 * Lower per-queue memory footprint. This optimization saves about 1 GiB of memory for
   every 100K classic queues, so, for 3M MQTT connections the savings would add up to 30 GiB.

   GitHub issue: [#5551](https://github.com/rabbitmq/rabbitmq-server/pull/5551)

 * It is now possible to configure default operator policies for virtual hosts
   that match a naming pattern:

   ``` ini
   default_operator_policies.1.vhost_pattern = ^device
   default_operator_policies.1.queue_pattern = .*
   default_operator_policies.1.max_length_bytes = 1GB
   default_operator_policies.1.max_length = 1000000
   ```

   Contributed by @illotum (AWS).

   GitHub issues: [#6380](https://github.com/rabbitmq/rabbitmq-server/issues/6380), [#4999](https://github.com/rabbitmq/rabbitmq-server/issues/4999)

 * Preserve additional information in the log message when heartbeat frame cannot
   be sent due to a TCP timeout.

   GitHub issue: [#6708](https://github.com/rabbitmq/rabbitmq-server/pull/6708)

#### Bug Fixes

 * Nodes [under maintenance](https://rabbitmq.com/upgrade.html#maintenance-mode) will no longer considered for stream replica placement.

   GitHub issue: [#3370](https://github.com/rabbitmq/rabbitmq-server/issues/3370)

 * Feature flag operations logged incorrect module name in some cases.

   GitHub issue: [#6694](https://github.com/rabbitmq/rabbitmq-server/pull/6694)


### CLI Tools

#### Enhancements

 * `rabbitmq-upgrade await_online_quorum_plus_one` will now consider stream replicas in addition to quorum queue replicas.

   GitHub issue: [#4890](https://github.com/rabbitmq/rabbitmq-server/issues/4890)

#### Bug Fixes

 * Listing listeners (including via `rabbitmq-diagnostics status`) could fail with an exception
   if target node was shutting down.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#6719](https://github.com/rabbitmq/rabbitmq-server/pull/6719)


### Management Plugin

#### Enhancements

 * Support for Identity Provider-initiated Login (IDP).

   GitHub issues: [#6015](https://github.com/rabbitmq/rabbitmq-server/pull/6015), [#6201](https://github.com/rabbitmq/rabbitmq-server/pull/6201),
   [#6247](https://github.com/rabbitmq/rabbitmq-server/pull/6247)

#### Bug Fixes

 * Use a more modern method (browser feature) for definition file downloads.

   GitHub issue: [#6674](https://github.com/rabbitmq/rabbitmq-server/pull/6674)

 * Perform HTML escaping of a user-provided error parameter used by some UI states.

   Contributed by @dentarg (CloudAMQP).

   GitHub issue: [#6780](https://github.com/rabbitmq/rabbitmq-server/pull/6780)


## Dependency Upgrades

 * `ra` was upgraded [from `2.4.5` to `2.4.6`](https://github.com/rabbitmq/ra/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.6.tar.xz`
instead of the source tarball produced by GitHub.
