RabbitMQ `3.10.14` is a maintenance release in the `3.10.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.10.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.10.0)
if upgrading from a version prior to 3.10.0.

This release **requires Erlang 24.3** and supports Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

Erlang 23 and 24 versions older than 24.3 have reached [end of support](https://www.rabbitmq.com/which-erlang.html).

This release of RabbitMQ requires Erlang 24.3 or later versions. Nodes **will fail to start** on older Erlang releases.

Erlang 25 is recommended: it offers much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).

### Core Server

#### Enhancements

 * Dead-lettering of a large number of messages to a classic mirrored queues now has lower peak memory footprint.

   GitHub issue: [#5312](https://github.com/rabbitmq/rabbitmq-server/issues/5312)

 * Preserve additional information in the log message when heartbeat frame cannot
   be sent due to a TCP timeout.

   GitHub issue: [#6708](https://github.com/rabbitmq/rabbitmq-server/pull/6708)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl add_vhost` now coerces a single string value of `--tags` into an array.

   GitHub issue: [#6877](https://github.com/rabbitmq/rabbitmq-server/pull/6877)


### Stream Plugin

#### Bug Fixes

 * Core server did not correctly translate empty stream message bodies to AMQP 0-9-1 when a stream was
   consumed by an AMQP 0-9-1 (as opposed to RabbitMQ Stream protocol) client.

   GitHub issue: [#6835](https://github.com/rabbitmq/rabbitmq-server/pull/6835)


### Web STOMP Plugin

#### Bug Fixes

 * `ERROR` frames delivery is now correctly delivered w.r.t. TCP connection closure for clients that run into
   certain types of exceptions.

   Contributed by @csicar.

   GitHub issue: [#6789](https://github.com/rabbitmq/rabbitmq-server/pull/6789)

## Dependency Upgrades

 * `ra` was upgraded [from `2.4.5` to `2.4.6`](https://github.com/rabbitmq/ra/releases)
 * `prometheus.erl` was upgraded [from `4.9.1` to `4.10.0`](https://github.com/deadtrickster/prometheus.erl/tags)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.10.14.tar.xz`
instead of the source tarball produced by GitHub.
