#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Council
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251013.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='the-council'
GAME_NAME='The Council'

ARCHIVE_BASE_0_NAME='setup_the_council_0.9.5.6359_(33875).exe'
ARCHIVE_BASE_0_MD5='7e49e444eaf67a95698dc1929979754a'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_the_council_0.9.5.6359_(33875)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='8567d5d7bb55af6b5a13b57144d32342'
ARCHIVE_BASE_0_PART2_NAME='setup_the_council_0.9.5.6359_(33875)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='2946c8da1f85f498da17661b159bfe4f'
ARCHIVE_BASE_0_PART3_NAME='setup_the_council_0.9.5.6359_(33875)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='6d070987d39d722d3ceb1c7475f88c62'
ARCHIVE_BASE_0_SIZE='24000000'
ARCHIVE_BASE_0_VERSION='0.9.5.6359-gog33875'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_council'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
library
anttweakbar64.dll
anttweakbar.dll
nvtoolsext64_1.dll
sharpdx.direct2d1.dll
sharpdx.dll
sharpdx.dxgi.dll
crashreport.exe
the council.exe'
## TODO: Check if the GOG Galaxy library is required.
CONTENT_GAME0_BIN_FILES='
galaxy64.dll'
## TODO: Check if the Steam library is required.
CONTENT_GAME1_BIN_FILES='
steam_api64.dll'
CONTENT_GAME_DATA_EPISODES_FILES='
data/packages/episode_*'
CONTENT_GAME_DATA_SOUND_FILES='
data/sound'
CONTENT_GAME_DATA_FILES='
defaultparameter
data
packagelist'

## TODO: Check if DXVK is still required with WINE ≥ 10.0.
WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/My Games/The Council'

APP_MAIN_EXE='the council.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA_EPISODES
PKG_DATA_SOUND
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_EPISODES
PKG_DATA_SOUND'

PKG_DATA_EPISODES_ID="${PKG_DATA_ID}-episodes"
PKG_DATA_EPISODES_DESCRIPTION="$PKG_DATA_DESCRIPTION - episodes"

PKG_DATA_SOUND_ID="${PKG_DATA_ID}-sound"
PKG_DATA_SOUND_DESCRIPTION="$PKG_DATA_DESCRIPTION - sound"

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
