/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkMultiLabelSTAPLEImageFilter_h
#define sitkMultiLabelSTAPLEImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkMultiInputImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

   /**\class MultiLabelSTAPLEImageFilter

\brief This filter performs a pixelwise combination of an arbitrary number of input images, where each of them represents a segmentation of the same scene (i.e., image).

The labelings in the images are weighted relative to each other based on their "performance" as estimated by an expectation-maximization algorithm. In the process, a ground truth segmentation is estimated, and the estimated performances of the individual segmentations are relative to this estimated ground truth.

The algorithm is based on the binary STAPLE algorithm by Warfield et al. as published originally in

S. Warfield, K. Zou, W. Wells, "Validation of image segmentation and expert
quality with an expectation-maximization algorithm" in MICCAI 2002: Fifth International Conference on Medical Image Computing and Computer-Assisted Intervention, Springer-Verlag, Heidelberg, Germany, 2002, pp. 298-306

The multi-label algorithm implemented here is described in detail in

T. Rohlfing, D. B. Russakoff, and C. R. Maurer, Jr., "Performance-based
classifier combination in atlas-based image segmentation using
expectation-maximization parameter estimation," IEEE Transactions on Medical Imaging, vol. 23, pp. 983-994, Aug. 2004.

\par INPUTS
All input volumes to this filter must be segmentations of an image, that is, they must have discrete pixel values where each value represents a different segmented object.


Input volumes must all contain the same size RequestedRegions. Not all input images must contain all possible labels, but all label values must have the same meaning in all images.

The filter can optionally be provided with estimates for the a priori class probabilities through the SetPriorProbabilities function. If no estimate is provided, one is automatically generated by analyzing the relative frequencies of the labels in the input images.

\par OUTPUTS
The filter produces a single output volume. Each output pixel contains the label that has the highest probability of being the correct label, based on the performance models of the individual segmentations. If the maximum probability is not unique, i.e., if more than one label have a maximum probability, then an "undecided" label is assigned to that output pixel.


By default, the label used for undecided pixels is the maximum label value used in the input images plus one. Since it is possible for an image with 8 bit pixel values to use all 256 possible label values, it is permissible to combine 8 bit (i.e., byte) images into a 16 bit (i.e., short) output image.

In addition to the combined image, the estimated confusion matrices for each of the input segmentations can be obtained through the GetConfusionMatrix member function.

\par PARAMETERS
The label used for "undecided" labels can be set using SetLabelForUndecidedPixels. This functionality can be unset by calling UnsetLabelForUndecidedPixels.


A termination threshold for the EM iteration can be defined by calling SetTerminationUpdateThreshold. The iteration terminates once no single parameter of any confusion matrix changes by less than this threshold. Alternatively, a maximum number of iterations can be specified by calling SetMaximumNumberOfIterations. The algorithm may still terminate after a smaller number of iterations if the termination threshold criterion is satisfied.

\par EVENTS
This filter invokes IterationEvent() at each iteration of the E-M algorithm. Setting the AbortGenerateData() flag will cause the algorithm to halt after the current iteration and produce results just as if it had converged. The algorithm makes no attempt to report its progress since the number of iterations needed cannot be known in advance.


\author Torsten Rohlfing, SRI International, Neuroscience Program

\sa itk::simple::MultiLabelSTAPLE for the procedural interface
   */
    class SITKBasicFilters_EXPORT MultiLabelSTAPLEImageFilter
      : public ImageFilter
    {
    public:
      using Self = MultiLabelSTAPLEImageFilter;

      /** Destructor */
      virtual ~MultiLabelSTAPLEImageFilter();


      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      MultiLabelSTAPLEImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = UnsignedIntegerPixelIDTypeList;


\

      /**
       * Set label value for undecided pixels.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetLabelForUndecidedPixels ( uint64_t LabelForUndecidedPixels ) { this->m_LabelForUndecidedPixels = LabelForUndecidedPixels; return *this; }

      /**
       * Get label value used for undecided pixels.

After updating the filter, this function returns the actual label value used for undecided pixels in the current output. Note that this value is overwritten when SetLabelForUndecidedPixels is called and the new value only becomes effective upon the next filter update.
       */
      uint64_t GetLabelForUndecidedPixels() const { return this->m_LabelForUndecidedPixels; }\

      /**
       * Set termination threshold based on confusion matrix parameter updates.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetTerminationUpdateThreshold ( float TerminationUpdateThreshold ) { this->m_TerminationUpdateThreshold = TerminationUpdateThreshold; return *this; }

      /**
       * Set termination threshold based on confusion matrix parameter updates.
       */
      float GetTerminationUpdateThreshold() const { return this->m_TerminationUpdateThreshold; }\

      /**
       * Set maximum number of iterations.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMaximumNumberOfIterations ( unsigned int MaximumNumberOfIterations ) { this->m_MaximumNumberOfIterations = MaximumNumberOfIterations; return *this; }

      /**
       * Set maximum number of iterations.
       */
      unsigned int GetMaximumNumberOfIterations() const { return this->m_MaximumNumberOfIterations; }\

      /**
       * Set manual estimates for the a priori class probabilities. The size of the array must be greater than the value of the
largest label. The index into the array corresponds to the label
value in the segmented image for the class.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetPriorProbabilities ( std::vector<float> PriorProbabilities ) { this->m_PriorProbabilities = PriorProbabilities; return *this; }

      /**
       * Get prior class probabilities.

After updating the filter, this function returns the actual prior class probabilities. If these were not previously set by a call to SetPriorProbabilities, then they are estimated from the input segmentations and the result is available through this function.
       */
      std::vector<float> GetPriorProbabilities() const { return this->m_PriorProbabilities; }
     /**
      * Get confusion matrix for the i-th input segmentation.
      *
      * This is an active measurement. It may be accessed while the
      * filter is being executing in command call-backs and can be
      * accessed after execution.
      */
     std::vector<float> GetConfusionMatrix(unsigned int input) const { return this->m_pfGetConfusionMatrix(input); };


      /** Name of this class */
      std::string GetName() const { return std::string ("MultiLabelSTAPLEImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;

      /** Execute the filter on the input images */
      Image Execute ( const std::vector<Image> &images);
      Image Execute ( const Image& image1 );
      Image Execute ( const Image& image1, const Image& image2 );
      Image Execute ( const Image& image1, const Image& image2, const Image& image3 );
      Image Execute ( const Image& image1, const Image& image2, const Image& image3, const Image& image4 );
      Image Execute ( const Image& image1, const Image& image2, const Image& image3, const Image& image4, const Image& image5 );




    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const std::vector<Image> & );
      template <class TImageType> Image ExecuteInternal ( const std::vector<Image> &images );



      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      uint64_t  m_LabelForUndecidedPixels{std::numeric_limits<uint64_t>::max()};

      float  m_TerminationUpdateThreshold{1e-5f};

      unsigned int  m_MaximumNumberOfIterations{std::numeric_limits<unsigned int>::max()};

      std::vector<float>  m_PriorProbabilities{std::vector<float>()};


      std::function<std::vector<float>(unsigned int)> m_pfGetConfusionMatrix;

      // Holder of process object for active measurements
      itk::ProcessObject *m_Filter{nullptr};

    };


    /**
     * \brief This filter performs a pixelwise combination of an arbitrary number of input images, where each of them represents a segmentation of the same scene (i.e., image).
     *
     * This function directly calls the execute method of MultiLabelSTAPLEImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::MultiLabelSTAPLEImageFilter for the object oriented interface
     * @{
     */
     SITKBasicFilters_EXPORT Image MultiLabelSTAPLE ( const std::vector<Image> &images , uint64_t labelForUndecidedPixels = std::numeric_limits<uint64_t>::max(), float terminationUpdateThreshold = 1e-5f, unsigned int maximumNumberOfIterations = std::numeric_limits<unsigned int>::max(), std::vector<float> priorProbabilities = std::vector<float>() );

     SITKBasicFilters_EXPORT Image MultiLabelSTAPLE ( const Image& image1, uint64_t labelForUndecidedPixels = std::numeric_limits<uint64_t>::max(), float terminationUpdateThreshold = 1e-5f, unsigned int maximumNumberOfIterations = std::numeric_limits<unsigned int>::max(), std::vector<float> priorProbabilities = std::vector<float>() );
     SITKBasicFilters_EXPORT Image MultiLabelSTAPLE ( const Image& image1, const Image& image2, uint64_t labelForUndecidedPixels = std::numeric_limits<uint64_t>::max(), float terminationUpdateThreshold = 1e-5f, unsigned int maximumNumberOfIterations = std::numeric_limits<unsigned int>::max(), std::vector<float> priorProbabilities = std::vector<float>() );
     SITKBasicFilters_EXPORT Image MultiLabelSTAPLE ( const Image& image1, const Image& image2, const Image& image3, uint64_t labelForUndecidedPixels = std::numeric_limits<uint64_t>::max(), float terminationUpdateThreshold = 1e-5f, unsigned int maximumNumberOfIterations = std::numeric_limits<unsigned int>::max(), std::vector<float> priorProbabilities = std::vector<float>() );
     SITKBasicFilters_EXPORT Image MultiLabelSTAPLE ( const Image& image1, const Image& image2, const Image& image3, const Image& image4, uint64_t labelForUndecidedPixels = std::numeric_limits<uint64_t>::max(), float terminationUpdateThreshold = 1e-5f, unsigned int maximumNumberOfIterations = std::numeric_limits<unsigned int>::max(), std::vector<float> priorProbabilities = std::vector<float>() );
     SITKBasicFilters_EXPORT Image MultiLabelSTAPLE ( const Image& image1, const Image& image2, const Image& image3, const Image& image4, const Image& image5, uint64_t labelForUndecidedPixels = std::numeric_limits<uint64_t>::max(), float terminationUpdateThreshold = 1e-5f, unsigned int maximumNumberOfIterations = std::numeric_limits<unsigned int>::max(), std::vector<float> priorProbabilities = std::vector<float>() );

     /** @{ */

}
#endif
