/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.AsyncioModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.AsyncioModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.set.SetNodes;
import com.oracle.graal.python.lib.PyDictDelItem;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.lib.PyDictSetItem;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_asyncio")
public final class AsyncioModuleBuiltins
extends PythonBuiltins {
    public static final TruffleString SCHEDULED_TASKS_ATTR = PythonUtils.tsLiteral("_scheduled_tasks");
    public static final TruffleString EAGER_TASKS_ATTR = PythonUtils.tsLiteral("_eager_tasks");
    public static final TruffleString CURRENT_TASKS_ATTR = PythonUtils.tsLiteral("_current_tasks");
    private static final TruffleString WEAKREF = PythonUtils.tsLiteral("weakref");
    private static final TruffleString WEAKSET = PythonUtils.tsLiteral("WeakSet");
    public static final TruffleString T_ASYNCIO_EVENTS = PythonUtils.tsLiteral("asyncio");
    public static final TruffleString T_GET_EVENT_LOOP_POLICY = PythonUtils.tsLiteral("get_event_loop_policy");
    public static final TruffleString T_GET_EVENT_LOOP = PythonUtils.tsLiteral("get_event_loop");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AsyncioModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        PythonModule self = core.lookupBuiltinModule(BuiltinNames.T__ASYNCIO);
        PythonModule weakref = AbstractImportNode.importModule(WEAKREF);
        Object weakSetCls = PyObjectGetAttr.executeUncached(weakref, WEAKSET);
        Object weakSet = CallNode.executeUncached(weakSetCls, new Object[0]);
        self.setAttribute(CURRENT_TASKS_ATTR, PFactory.createDict(core.getLanguage()));
        self.setAttribute(SCHEDULED_TASKS_ATTR, weakSet);
        self.setAttribute(EAGER_TASKS_ATTR, PFactory.createSet(core.getLanguage()));
    }

    @Builtin(name="_swap_current_task", declaresExplicitSelf=true, minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class SwapCurrentTaskNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        public Object enterTask(VirtualFrame frame, PythonModule self, Object loop, Object task, @Bind Node inliningTarget, @Cached ObjectBuiltins.GetAttributeNode getattr, @Cached PyObjectHashNode hashNode, @Cached HashingStorageNodes.HashingStorageGetItemWithHash getItem, @Cached HashingStorageNodes.HashingStorageSetItemWithHash setItem, @Cached PyDictDelItem delItem) {
            PDict currentTasks = (PDict)getattr.execute(frame, self, CURRENT_TASKS_ATTR);
            long hash = hashNode.execute((Frame)frame, inliningTarget, loop);
            Object prevTask = getItem.execute((Frame)frame, inliningTarget, currentTasks.getDictStorage(), loop, hash);
            if (prevTask == null) {
                prevTask = PNone.NONE;
            }
            if (PGuards.isPNone(task)) {
                delItem.execute((Frame)frame, inliningTarget, currentTasks, loop);
            } else {
                setItem.execute((Frame)frame, inliningTarget, currentTasks.getDictStorage(), loop, hash, task);
            }
            return prevTask;
        }
    }

    @Builtin(name="current_task", declaresExplicitSelf=true, minNumOfPositionalArgs=1, parameterNames={"$mod", "loop"})
    @ArgumentClinic(name="loop", defaultValue="PNone.NONE")
    @GenerateNodeFactory
    public static abstract class CurrentTaskNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return AsyncioModuleBuiltinsClinicProviders.CurrentTaskNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        public Object currentTask(VirtualFrame frame, PythonModule self, Object argloop, @Bind Node inliningTarget, @Bind PythonContext context, @Cached ObjectBuiltins.GetAttributeNode getattr, @Cached PyDictGetItem get, @Cached PRaiseNode raise) {
            Object ret;
            PDict currentTasks = (PDict)getattr.execute(frame, self, CURRENT_TASKS_ATTR);
            Object loop = argloop;
            if (PGuards.isPNone(loop)) {
                loop = GetRunningLoop.getCurrentLoop(inliningTarget, context, raise);
            }
            if ((ret = get.execute((Frame)frame, inliningTarget, currentTasks, loop)) == null) {
                return PNone.NONE;
            }
            return ret;
        }
    }

    @Builtin(name="_unregister_eager_task", declaresExplicitSelf=true, minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class UnregisterEagerTask
    extends PythonBinaryBuiltinNode {
        @Specialization
        public Object unregisterEagerTask(VirtualFrame frame, PythonModule self, Object task, @Cached ObjectBuiltins.GetAttributeNode getattr, @Cached SetNodes.DiscardNode discardNode) {
            PSet set = (PSet)getattr.execute(frame, self, EAGER_TASKS_ATTR);
            discardNode.execute(frame, set, task);
            return PNone.NONE;
        }
    }

    @Builtin(name="_register_eager_task", declaresExplicitSelf=true, minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class RegisterEagerTask
    extends PythonBinaryBuiltinNode {
        @Specialization
        public Object registerEagerTask(VirtualFrame frame, PythonModule self, Object task, @Cached ObjectBuiltins.GetAttributeNode getattr, @Cached SetNodes.AddNode addNode) {
            PSet set = (PSet)getattr.execute(frame, self, EAGER_TASKS_ATTR);
            addNode.execute((Frame)frame, set, task);
            return PNone.NONE;
        }
    }

    @Builtin(name="_unregister_task", declaresExplicitSelf=true, minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class UnregisterTask
    extends PythonBinaryBuiltinNode {
        @Specialization
        public Object unregisterTask(VirtualFrame frame, PythonModule self, Object task, @Bind Node inliningTarget, @Cached ObjectBuiltins.GetAttributeNode getattr, @Cached PyObjectCallMethodObjArgs callMethod) {
            Object weakset = getattr.execute(frame, self, SCHEDULED_TASKS_ATTR);
            callMethod.execute((Frame)frame, inliningTarget, weakset, BuiltinNames.T_DISCARD, task);
            return PNone.NONE;
        }
    }

    @Builtin(name="_register_task", declaresExplicitSelf=true, minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class RegisterTask
    extends PythonBinaryBuiltinNode {
        @Specialization
        public Object registerTask(VirtualFrame frame, PythonModule self, Object task, @Bind Node inliningTarget, @Cached ObjectBuiltins.GetAttributeNode getattr, @Cached PyObjectCallMethodObjArgs callmethod) {
            Object weakset = getattr.execute(frame, self, SCHEDULED_TASKS_ATTR);
            callmethod.execute((Frame)frame, inliningTarget, weakset, BuiltinNames.T_ADD, task);
            return PNone.NONE;
        }
    }

    @Builtin(name="_leave_task", declaresExplicitSelf=true, minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class LeaveTask
    extends PythonTernaryBuiltinNode {
        @Specialization
        public Object leaveTask(VirtualFrame frame, PythonModule self, Object loop, Object task, @Bind Node inliningTarget, @Cached ObjectBuiltins.GetAttributeNode getattr, @Cached PyDictDelItem del, @Cached PyDictGetItem get, @Cached PRaiseNode raise) {
            PDict currentTasks = (PDict)getattr.execute(frame, self, CURRENT_TASKS_ATTR);
            Object item = get.execute((Frame)frame, inliningTarget, currentTasks, loop);
            if (item == null) {
                item = PNone.NONE;
            }
            if (item != task) {
                throw raise.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.TASK_NOT_ENTERED, task, item);
            }
            del.execute((Frame)frame, inliningTarget, currentTasks, loop);
            return PNone.NONE;
        }
    }

    @Builtin(name="_enter_task", declaresExplicitSelf=true, minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class EnterTask
    extends PythonTernaryBuiltinNode {
        @Specialization
        public Object enterTask(VirtualFrame frame, PythonModule self, Object loop, Object task, @Bind Node inliningTarget, @Cached ObjectBuiltins.GetAttributeNode getattr, @Cached PyDictSetItem set, @Cached PyDictGetItem get, @Cached PRaiseNode raise) {
            PDict currentTasks = (PDict)getattr.execute(frame, self, CURRENT_TASKS_ATTR);
            Object item = get.execute((Frame)frame, inliningTarget, currentTasks, loop);
            if (item != null) {
                throw raise.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.CANT_ENTER_TASK_ALREADY_RUNNING, task, item);
            }
            set.execute((Frame)frame, inliningTarget, currentTasks, loop, task);
            return PNone.NONE;
        }
    }

    @Builtin(name="_get_event_loop", parameterNames={"stacklevel"})
    @GenerateNodeFactory
    public static abstract class DeprGetEventLoop
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object getCurrentLoop(VirtualFrame frame, Object stacklevel, @Cached GetEventLoop getLoop) {
            return getLoop.execute(frame, null);
        }
    }

    @Builtin(name="get_event_loop", declaresExplicitSelf=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @ImportStatic(value={AsyncioModuleBuiltins.class})
    public static abstract class GetEventLoop
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object getCurrentLoop(VirtualFrame frame, Object ignored, @Bind Node inliningTarget, @Bind PythonContext context, @Cached CallNode callGetPolicy, @Cached CallNode callGetLoop, @Cached AbstractImportNode.ImportName importName, @Cached(parameters={"T_GET_EVENT_LOOP"}) GetAttributeNode.GetFixedAttributeNode getGetLoop, @Cached(parameters={"T_GET_EVENT_LOOP_POLICY"}) GetAttributeNode.GetFixedAttributeNode getGetLoopPolicy) {
            Object eventLoop = context.getThreadState(context.getLanguage(inliningTarget)).getRunningEventLoop();
            if (eventLoop == null) {
                Object asyncio = importName.execute((Frame)frame, context, context.getBuiltins(), T_ASYNCIO_EVENTS, PNone.NONE, PythonUtils.EMPTY_TRUFFLESTRING_ARRAY, 0);
                Object asyncioGetPolicy = getGetLoopPolicy.execute(frame, asyncio);
                Object policy = callGetPolicy.execute((Frame)frame, asyncioGetPolicy, new Object[0]);
                Object getLoop = getGetLoop.execute(frame, policy);
                return callGetLoop.execute((Frame)frame, getLoop, new Object[0]);
            }
            return eventLoop;
        }
    }

    @Builtin(name="_set_running_loop", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class InternalSetRunningLoop
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object setCurrentLoop(Object loop, @Bind Node inliningTarget, @Bind PythonContext context) {
            context.getThreadState(context.getLanguage(inliningTarget)).setRunningEventLoop(loop == PNone.NONE ? null : loop);
            return PNone.NONE;
        }
    }

    @Builtin(name="_get_running_loop")
    @GenerateNodeFactory
    public static abstract class InternalGetRunningLoop
    extends PythonBuiltinNode {
        @Specialization
        static Object getCurrentLoop(@Bind Node inliningTarget, @Bind PythonContext context) {
            Object eventLoop = context.getThreadState(context.getLanguage(inliningTarget)).getRunningEventLoop();
            return eventLoop == null ? PNone.NONE : eventLoop;
        }
    }

    @Builtin(name="get_running_loop")
    @GenerateNodeFactory
    public static abstract class GetRunningLoop
    extends PythonBuiltinNode {
        @Specialization
        static Object getCurrentLoop(@Bind Node inliningTarget, @Bind PythonContext context, @Cached PRaiseNode raise) {
            Object eventLoop = context.getThreadState(context.getLanguage(inliningTarget)).getRunningEventLoop();
            if (eventLoop == null) {
                throw raise.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.NO_RUNNING_EVENT_LOOP);
            }
            return eventLoop;
        }
    }
}

