/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SourceProducer;

final class MonoSupplier<T>
extends Mono<T>
implements Callable<T>,
Fuseable,
SourceProducer<T> {
    final Supplier<? extends @Nullable T> supplier;

    MonoSupplier(Supplier<? extends @Nullable T> supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        actual.onSubscribe(new MonoSupplierSubscription<T>(actual, this.supplier));
    }

    @Override
    public @Nullable T block(Duration m) {
        return this.supplier.get();
    }

    @Override
    public @Nullable T block() {
        return this.block(Duration.ZERO);
    }

    @Override
    public @Nullable T call() throws Exception {
        return this.supplier.get();
    }

    @Override
    public @Nullable Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return SourceProducer.super.scanUnsafe(key);
    }

    static class MonoSupplierSubscription<T>
    implements InnerProducer<T>,
    Fuseable,
    Fuseable.QueueSubscription<T> {
        final CoreSubscriber<? super T> actual;
        final Supplier<? extends @Nullable T> supplier;
        boolean done;
        volatile int requestedOnce;
        static final AtomicIntegerFieldUpdater<MonoSupplierSubscription> REQUESTED_ONCE = AtomicIntegerFieldUpdater.newUpdater(MonoSupplierSubscription.class, "requestedOnce");
        volatile boolean cancelled;

        MonoSupplierSubscription(CoreSubscriber<? super T> actual, Supplier<? extends @Nullable T> supplier) {
            this.actual = actual;
            this.supplier = supplier;
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public @Nullable T poll() {
            if (this.done) {
                return null;
            }
            this.done = true;
            return this.supplier.get();
        }

        public void request(long n) {
            T value;
            if (this.cancelled) {
                return;
            }
            if (this.requestedOnce == 1 || !REQUESTED_ONCE.compareAndSet(this, 0, 1)) {
                return;
            }
            CoreSubscriber<? super T> s = this.actual;
            try {
                value = this.supplier.get();
            }
            catch (Exception e) {
                if (this.cancelled) {
                    Operators.onErrorDropped(e, s.currentContext());
                    return;
                }
                s.onError(e);
                return;
            }
            if (this.cancelled) {
                Operators.onDiscard(value, s.currentContext());
                return;
            }
            if (value != null) {
                s.onNext(value);
            }
            s.onComplete();
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public int requestFusion(int requestedMode) {
            return requestedMode & 1;
        }

        @Override
        public int size() {
            return this.done ? 0 : 1;
        }

        @Override
        public boolean isEmpty() {
            return this.done;
        }

        @Override
        public void clear() {
            this.done = true;
        }
    }
}

