/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.stats;

import java.io.IOException;
import org.opensearch.Version;
import org.opensearch.action.admin.indices.stats.DocStatusStats;
import org.opensearch.action.admin.indices.stats.SearchResponseStatusStats;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="3.4.0")
public class StatusCounterStats
implements Writeable,
ToXContentFragment {
    @Nullable
    private DocStatusStats docStatusStats;
    @Nullable
    private SearchResponseStatusStats searchResponseStatusStats;

    public StatusCounterStats() {
        this.docStatusStats = new DocStatusStats();
        this.searchResponseStatusStats = new SearchResponseStatusStats();
    }

    public StatusCounterStats(DocStatusStats docStatusStats, SearchResponseStatusStats searchResponseStatusStats) {
        this.docStatusStats = docStatusStats;
        this.searchResponseStatusStats = searchResponseStatusStats;
    }

    public StatusCounterStats(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_3_4_0)) {
            this.docStatusStats = (DocStatusStats)in.readOptionalWriteable(DocStatusStats::new);
            this.searchResponseStatusStats = (SearchResponseStatusStats)in.readOptionalWriteable(SearchResponseStatusStats::new);
        } else {
            this.docStatusStats = null;
            this.searchResponseStatusStats = null;
        }
    }

    public DocStatusStats getDocStatusStats() {
        return this.docStatusStats;
    }

    public SearchResponseStatusStats getSearchResponseStatusStats() {
        return this.searchResponseStatusStats;
    }

    public StatusCounterStats getSnapshot() {
        StatusCounterStats stats = new StatusCounterStats();
        stats.getDocStatusStats().add(this.docStatusStats);
        stats.getSearchResponseStatusStats().add(this.searchResponseStatusStats);
        return stats;
    }

    public void add(StatusCounterStats stats) {
        if (stats == null) {
            return;
        }
        if (this.docStatusStats != null) {
            this.docStatusStats.add(stats.docStatusStats);
        }
        if (this.searchResponseStatusStats != null) {
            this.searchResponseStatusStats.add(stats.searchResponseStatusStats);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_3_4_0)) {
            out.writeOptionalWriteable((Writeable)this.docStatusStats.getSnapshot());
            out.writeOptionalWriteable((Writeable)this.searchResponseStatusStats.getSnapshot());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("status_counter");
        this.docStatusStats.getSnapshot().toXContent(builder, params);
        this.searchResponseStatusStats.getSnapshot().toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String STATUS_COUNTER = "status_counter";

        Fields() {
        }
    }
}

