/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.policy.PasswordPolicyNotMetException;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.fgap.AdminPermissions;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.storage.ExportImportManager;
import org.keycloak.utils.StreamsUtil;

@Extension(name="x-smallrye-profile-admin", value="")
public class RealmsAdminResource {
    protected static final Logger logger = Logger.getLogger(RealmsAdminResource.class);
    protected final AdminAuth auth;
    protected final TokenManager tokenManager;
    protected final KeycloakSession session;
    protected final ClientConnection clientConnection;
    public static final CacheControl noCache = new CacheControl();

    public RealmsAdminResource(KeycloakSession session, AdminAuth auth, TokenManager tokenManager) {
        this.session = session;
        this.clientConnection = session.getContext().getConnection();
        this.auth = auth;
        this.tokenManager = tokenManager;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(summary="Get accessible realms Returns a list of accessible realms. The list is filtered based on what realms the caller is allowed to view.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RealmRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<RealmRepresentation> getRealms(@DefaultValue(value="false") @QueryParam(value="briefRepresentation") boolean briefRepresentation) {
        Stream<RealmRepresentation> realms = this.session.realms().getRealmsStream().map(realm -> this.toRealmRep((RealmModel)realm, briefRepresentation)).filter(Objects::nonNull);
        return StreamsUtil.throwIfEmpty(realms, (RuntimeException)((Object)new ForbiddenException()));
    }

    protected RealmRepresentation toRealmRep(RealmModel realm, boolean briefRep) {
        if (AdminPermissions.realms(this.session, this.auth).canView(realm)) {
            return briefRep ? ModelToRepresentation.toBriefRepresentation((RealmModel)realm) : ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)realm, (boolean)false);
        }
        if (AdminPermissions.realms(this.session, this.auth).isAdmin(realm)) {
            RealmRepresentation rep = new RealmRepresentation();
            rep.setRealm(realm.getName());
            return rep;
        }
        return null;
    }

    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation(summary="Import a realm. Imports a realm from a full representation of that realm.", description="Realm name must be unique.")
    @APIResponses(value={@APIResponse(responseCode="201", description="Created"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="409", description="Conflict"), @APIResponse(responseCode="500", description="Internal Server Error")})
    public Response importRealm(InputStream requestBody) {
        AdminPermissions.realms(this.session, this.auth).requireCreateRealm();
        ExportImportManager exportImportManager = ((DatastoreProvider)this.session.getProvider(DatastoreProvider.class)).getExportImportManager();
        try {
            RealmModel realm = exportImportManager.importRealm(requestBody);
            this.grantPermissionsToRealmCreator(realm);
            URI location = AdminRoot.realmsUrl((UriInfo)this.session.getContext().getUri()).path(realm.getName()).build(new Object[0]);
            logger.debugv("imported realm success, sending back: {0}", (Object)location.toString());
            AdminEventBuilder adminEvent = new AdminEventBuilder(this.auth.getRealm(), this.auth, this.session, this.clientConnection);
            adminEvent.resource(ResourceType.REALM).realm(this.auth.getRealm()).operation(OperationType.CREATE).resourcePath(realm.getName()).representation(ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)realm, (boolean)false)).success();
            return Response.created((URI)location).build();
        }
        catch (PasswordPolicyNotMetException e) {
            logger.error((Object)("Password policy not met for user " + e.getUsername()), (Throwable)e);
            throw ErrorResponse.error("Password policy not met. See logs for details", Response.Status.BAD_REQUEST);
        }
        catch (ModelIllegalStateException mise) {
            logger.error((Object)mise.getMessage(), (Throwable)mise);
            throw ErrorResponse.error(mise.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (ModelDuplicateException mde) {
            logger.error((Object)"Conflict detected", (Throwable)mde);
            throw ErrorResponse.exists(mde.getMessage());
        }
        catch (ModelException e) {
            throw ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    private void grantPermissionsToRealmCreator(RealmModel realm) {
        if (this.auth.hasRealmRole("admin")) {
            return;
        }
        ClientModel realmAdminApp = realm.getMasterAdminClient();
        Arrays.stream(AdminRoles.ALL_REALM_ROLES).map(arg_0 -> ((ClientModel)realmAdminApp).getRole(arg_0)).forEach(arg_0 -> ((UserModel)this.auth.getUser()).grantRole(arg_0));
    }

    @Path(value="{realm}")
    public RealmAdminResource getRealmAdmin(@PathParam(value="realm") @Parameter(description="realm name (not id!)") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(name);
        if (realm == null) {
            throw new NotFoundException("Realm not found.");
        }
        if (!RealmManager.isAdministrationRealm(this.auth.getRealm()) && !this.auth.getRealm().equals((Object)realm)) {
            throw new ForbiddenException();
        }
        AdminPermissionEvaluator realmAuth = AdminPermissions.evaluator(this.session, realm, this.auth);
        this.session.getContext().setRealm(realm);
        AdminEventBuilder adminEvent = new AdminEventBuilder(realm, this.auth, this.session, this.clientConnection);
        return new RealmAdminResource(this.session, realmAuth, adminEvent);
    }

    static {
        noCache.setNoCache(true);
    }
}

