/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.telemetry.InfinispanSpanAttributes;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.commands.remote.XSiteCacheRequest;
import org.infinispan.xsite.commands.remote.XSiteRequest;

public class SingleXSiteRpcCommand
extends XSiteCacheRequest<Object> {
    private VisitableCommand command;
    private InfinispanSpanAttributes spanAttributes;

    public SingleXSiteRpcCommand(ByteString cacheName, VisitableCommand command) {
        super(cacheName);
        this.command = command;
    }

    public SingleXSiteRpcCommand() {
        this(null, null);
    }

    @Override
    protected CompletionStage<Object> invokeInLocalCache(String origin, ComponentRegistry registry) {
        return registry.getBackupReceiver().running().handleRemoteCommand(this.command);
    }

    @Override
    public byte getCommandId() {
        return 2;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.command);
        super.writeTo(output);
    }

    @Override
    public XSiteRequest<Object> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.command = (VisitableCommand)input.readObject();
        return super.readFrom(input);
    }

    @Override
    public InfinispanSpanAttributes getSpanAttributes() {
        return this.spanAttributes;
    }

    @Override
    public String getOperationName() {
        return this.command.getClass().getSimpleName();
    }

    @Override
    public void setSpanAttributes(InfinispanSpanAttributes attributes) {
        this.spanAttributes = attributes;
    }

    public String toString() {
        return "SingleXSiteRpcCommand{command=" + String.valueOf(this.command) + "}";
    }
}

