/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.internal;

import jakarta.persistence.Timeout;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;

public class TimesTenLockingSupport
implements LockingSupport,
LockingSupport.Metadata {
    public static final TimesTenLockingSupport TIMES_TEN_LOCKING_SUPPORT = new TimesTenLockingSupport();

    @Override
    public LockingSupport.Metadata getMetadata() {
        return this;
    }

    @Override
    public LockTimeoutType getLockTimeoutType(Timeout timeout) {
        return switch (timeout.milliseconds()) {
            case -2, -1 -> LockTimeoutType.NONE;
            default -> LockTimeoutType.QUERY;
        };
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.COLUMN;
    }

    @Override
    public OuterJoinLockingType getOuterJoinLockingType() {
        return OuterJoinLockingType.IDENTIFIED;
    }

    @Override
    public ConnectionLockTimeoutStrategy getConnectionLockTimeoutStrategy() {
        return ConnectionLockTimeoutStrategy.NONE;
    }
}

