/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import twitter4j.APIResourceBase;
import twitter4j.Authorization;
import twitter4j.HttpClient;
import twitter4j.HttpParameter;
import twitter4j.ObjectFactory;
import twitter4j.RateLimitStatusEvent;
import twitter4j.StringUtil;
import twitter4j.TwitterException;
import twitter4j.v1.AccountSettings;
import twitter4j.v1.IDs;
import twitter4j.v1.PagableResponseList;
import twitter4j.v1.ResponseList;
import twitter4j.v1.User;
import twitter4j.v1.UsersResources;

class UsersResourcesImpl
extends APIResourceBase
implements UsersResources {
    UsersResourcesImpl(HttpClient http, ObjectFactory factory, String restBaseURL, Authorization auth, boolean mbeanEnabled, HttpParameter[] IMPLICIT_PARAMS, String IMPLICIT_PARAMS_STR, List<Consumer<RateLimitStatusEvent>> rateLimitStatusListeners, List<Consumer<RateLimitStatusEvent>> rateLimitReachedListeners) {
        super(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
    }

    @Override
    public AccountSettings getAccountSettings() throws TwitterException {
        return this.factory.createAccountSettings(this.get(this.restBaseURL + "account/settings.json"));
    }

    @Override
    public User verifyCredentials() throws TwitterException {
        return this.factory.createUser(this.get(this.restBaseURL + "account/verify_credentials.json", new HttpParameter("include_email", "true")));
    }

    @Override
    public AccountSettings updateAccountSettings(Integer trend_locationWoeid, Boolean sleep_timeEnabled, String start_sleepTime, String end_sleepTime, String time_zone, String lang) throws TwitterException {
        ArrayList<HttpParameter> profile = new ArrayList<HttpParameter>(6);
        if (trend_locationWoeid != null) {
            profile.add(new HttpParameter("trend_location_woeid", trend_locationWoeid));
        }
        if (sleep_timeEnabled != null) {
            profile.add(new HttpParameter("sleep_time_enabled", sleep_timeEnabled.toString()));
        }
        if (start_sleepTime != null) {
            profile.add(new HttpParameter("start_sleep_time", start_sleepTime));
        }
        if (end_sleepTime != null) {
            profile.add(new HttpParameter("end_sleep_time", end_sleepTime));
        }
        if (time_zone != null) {
            profile.add(new HttpParameter("time_zone", time_zone));
        }
        if (lang != null) {
            profile.add(new HttpParameter("lang", lang));
        }
        return this.factory.createAccountSettings(this.post(this.restBaseURL + "account/settings.json", profile.toArray(new HttpParameter[0])));
    }

    @Override
    public AccountSettings updateAllowDmsFrom(String allowDmsFrom) throws TwitterException {
        return this.factory.createAccountSettings(this.post(this.restBaseURL + "account/settings.json?allow_dms_from=" + allowDmsFrom));
    }

    @Override
    public User updateProfile(String name, String url, String location, String description) throws TwitterException {
        ArrayList<HttpParameter> profile = new ArrayList<HttpParameter>(4);
        this.addParameterToList(profile, "name", name);
        this.addParameterToList(profile, "url", url);
        this.addParameterToList(profile, "location", location);
        this.addParameterToList(profile, "description", description);
        return this.factory.createUser(this.post(this.restBaseURL + "account/update_profile.json", profile.toArray(new HttpParameter[0])));
    }

    private void addParameterToList(List<HttpParameter> colors, String paramName, String color) {
        if (color != null) {
            colors.add(new HttpParameter(paramName, color));
        }
    }

    @Override
    public User updateProfileImage(File image) throws TwitterException {
        this.checkFileValidity(image);
        return this.factory.createUser(this.post(this.restBaseURL + "account/update_profile_image.json", new HttpParameter("image", image)));
    }

    @Override
    public User updateProfileImage(InputStream image) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "account/update_profile_image.json", new HttpParameter("image", "image", image)));
    }

    @Override
    public PagableResponseList<User> getBlocksList() throws TwitterException {
        return this.getBlocksList(-1L);
    }

    @Override
    public PagableResponseList<User> getBlocksList(long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.restBaseURL + "blocks/list.json?cursor=" + cursor));
    }

    @Override
    public IDs getBlocksIDs() throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "blocks/ids.json"));
    }

    @Override
    public IDs getBlocksIDs(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "blocks/ids.json?cursor=" + cursor));
    }

    @Override
    public User createBlock(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "blocks/create.json?user_id=" + userId));
    }

    @Override
    public User createBlock(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "blocks/create.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public User destroyBlock(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "blocks/destroy.json?user_id=" + userId));
    }

    @Override
    public User destroyBlock(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "blocks/destroy.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public PagableResponseList<User> getMutesList(long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.restBaseURL + "mutes/users/list.json?cursor=" + cursor));
    }

    @Override
    public IDs getMutesIDs(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "mutes/users/ids.json?cursor=" + cursor));
    }

    @Override
    public User createMute(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "mutes/users/create.json?user_id=" + userId));
    }

    @Override
    public User createMute(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "mutes/users/create.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public User destroyMute(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "mutes/users/destroy.json?user_id=" + userId));
    }

    @Override
    public User destroyMute(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.restBaseURL + "mutes/users/destroy.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public ResponseList<User> lookupUsers(long ... ids) throws TwitterException {
        return this.factory.createUserList(this.get(this.restBaseURL + "users/lookup.json", new HttpParameter("user_id", StringUtil.join(ids))));
    }

    @Override
    public ResponseList<User> lookupUsers(String ... screenNames) throws TwitterException {
        return this.factory.createUserList(this.get(this.restBaseURL + "users/lookup.json", new HttpParameter("screen_name", StringUtil.join(screenNames))));
    }

    @Override
    public User showUser(long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.restBaseURL + "users/show.json?user_id=" + userId));
    }

    @Override
    public User showUser(String screenName) throws TwitterException {
        return this.factory.createUser(this.get(this.restBaseURL + "users/show.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public ResponseList<User> searchUsers(String query, int page) throws TwitterException {
        return this.factory.createUserList(this.get(this.restBaseURL + "users/search.json", new HttpParameter("q", query), new HttpParameter("per_page", 20), new HttpParameter("page", page)));
    }

    @Override
    public ResponseList<User> getContributees(long userId) throws TwitterException {
        return this.factory.createUserList(this.get(this.restBaseURL + "users/contributees.json?user_id=" + userId));
    }

    @Override
    public ResponseList<User> getContributees(String screenName) throws TwitterException {
        return this.factory.createUserList(this.get(this.restBaseURL + "users/contributees.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public ResponseList<User> getContributors(long userId) throws TwitterException {
        return this.factory.createUserList(this.get(this.restBaseURL + "users/contributors.json?user_id=" + userId));
    }

    @Override
    public ResponseList<User> getContributors(String screenName) throws TwitterException {
        return this.factory.createUserList(this.get(this.restBaseURL + "users/contributors.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public void removeProfileBanner() throws TwitterException {
        this.post(this.restBaseURL + "account/remove_profile_banner.json");
    }

    @Override
    public void updateProfileBanner(File image) throws TwitterException {
        this.checkFileValidity(image);
        this.post(this.restBaseURL + "account/update_profile_banner.json", new HttpParameter("banner", image));
    }

    @Override
    public void updateProfileBanner(InputStream image) throws TwitterException {
        this.post(this.restBaseURL + "account/update_profile_banner.json", new HttpParameter("banner", "banner", image));
    }
}

