/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.comparators;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.comparators.NumericComparator;
import org.apache.lucene.util.NumericUtils;

public class FloatComparator
extends NumericComparator<Float> {
    private final float[] values;
    protected float topValue;
    protected float bottom;

    public FloatComparator(int numHits, String field, Float missingValue, boolean reverse, Pruning pruning) {
        super(field, Float.valueOf(missingValue != null ? missingValue.floatValue() : 0.0f), reverse, pruning, 4);
        this.values = new float[numHits];
    }

    @Override
    public int compare(int slot1, int slot2) {
        return Float.compare(this.values[slot1], this.values[slot2]);
    }

    @Override
    public void setTopValue(Float value) {
        super.setTopValue(value);
        this.topValue = value.floatValue();
    }

    @Override
    public Float value(int slot) {
        return Float.valueOf(this.values[slot]);
    }

    @Override
    protected long missingValueAsComparableLong() {
        return NumericUtils.floatToSortableInt(((Float)this.missingValue).floatValue());
    }

    @Override
    protected long sortableBytesToLong(byte[] bytes) {
        return NumericUtils.sortableBytesToInt(bytes, 0);
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new FloatLeafComparator(context);
    }

    public class FloatLeafComparator
    extends NumericComparator.NumericLeafComparator {
        public FloatLeafComparator(LeafReaderContext context) throws IOException {
            super(FloatComparator.this, context);
        }

        private float getValueForDoc(int doc) throws IOException {
            if (this.docValues.advanceExact(doc)) {
                return Float.intBitsToFloat((int)this.docValues.longValue());
            }
            return ((Float)FloatComparator.this.missingValue).floatValue();
        }

        @Override
        public void setBottom(int slot) throws IOException {
            FloatComparator.this.bottom = FloatComparator.this.values[slot];
            super.setBottom(slot);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Float.compare(FloatComparator.this.bottom, this.getValueForDoc(doc));
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return Float.compare(FloatComparator.this.topValue, this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            FloatComparator.this.values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        @Override
        protected long bottomAsComparableLong() {
            return NumericUtils.floatToSortableInt(FloatComparator.this.bottom);
        }

        @Override
        protected long topAsComparableLong() {
            return NumericUtils.floatToSortableInt(FloatComparator.this.topValue);
        }
    }
}

