/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.util.DirectoryUtils;

public class BasedirNameMapper
implements NameMapper {
    private static final String CONFIG_PROP_LOCKS_DIR = "aether.syncContext.named.basedir.locksDir";
    private final NameMapper delegate;

    public BasedirNameMapper(NameMapper delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public boolean isFileSystemFriendly() {
        return this.delegate.isFileSystemFriendly();
    }

    @Override
    public Collection<String> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        try {
            Path basedir = DirectoryUtils.resolveDirectory(session, ".locks", CONFIG_PROP_LOCKS_DIR, false);
            return this.delegate.nameLocks(session, artifacts, metadatas).stream().map(name -> basedir.resolve((String)name).toAbsolutePath().toString()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

