/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.impl.Containers;
import org.jetbrains.jps.util.Iterators;

public interface Difference {
    public boolean unchanged();

    public static <T> Specifier<T, ?> diff(final @Nullable Iterable<T> past, final @Nullable Iterable<T> now) {
        if (Iterators.isEmpty(past)) {
            if (Iterators.isEmpty(now)) {
                return new Specifier<T, Difference>(){

                    @Override
                    public boolean unchanged() {
                        return true;
                    }
                };
            }
            return new Specifier<T, Difference>(){

                @Override
                public Iterable<T> added() {
                    return now;
                }

                @Override
                public boolean unchanged() {
                    return false;
                }
            };
        }
        if (Iterators.isEmpty(now)) {
            return new Specifier<T, Difference>(){

                @Override
                public Iterable<T> removed() {
                    return past;
                }

                @Override
                public boolean unchanged() {
                    return false;
                }
            };
        }
        final Set pastSet = past instanceof Set ? (Set)past : (Set)Iterators.collect(past, new HashSet());
        final Set nowSet = now instanceof Set ? (Set)now : (Set)Iterators.collect(now, new HashSet());
        final Iterable added = Iterators.lazy(() -> Iterators.collect((Iterable)Iterators.filter((Iterable)nowSet, elem -> !pastSet.contains(elem)), new ArrayList()));
        final Iterable removed = Iterators.lazy(() -> Iterators.collect((Iterable)Iterators.filter((Iterable)pastSet, elem -> !nowSet.contains(elem)), new ArrayList()));
        return new Specifier<T, Difference>(){
            private Boolean isUnchanged;

            @Override
            public Iterable<T> added() {
                return added;
            }

            @Override
            public Iterable<T> removed() {
                return removed;
            }

            @Override
            public boolean unchanged() {
                boolean bl;
                if (this.isUnchanged != null) {
                    bl = this.isUnchanged;
                } else {
                    this.isUnchanged = pastSet.equals(nowSet);
                    bl = this.isUnchanged;
                }
                return bl;
            }
        };
    }

    public static <T, D extends Difference> Specifier<T, D> deepDiff(@Nullable Iterable<T> past, @Nullable Iterable<T> now, BiPredicate<? super T, ? super T> isSameImpl, Function<? super T, Integer> diffHashImpl, BiFunction<? super T, ? super T, ? extends D> diffImpl) {
        Iterators.Function mapper = obj -> DiffCapable.wrap(obj, isSameImpl, diffHashImpl, diffImpl);
        final Specifier<T, D> adapterDiff = Difference.deepDiff(Iterators.map(past, (Iterators.Function)mapper), Iterators.map(now, (Iterators.Function)mapper));
        return new Specifier<T, D>(){

            @Override
            public Iterable<T> added() {
                return Iterators.map(adapterDiff.added(), DiffCapable.Adapter::getValue);
            }

            @Override
            public Iterable<T> removed() {
                return Iterators.map(adapterDiff.removed(), DiffCapable.Adapter::getValue);
            }

            @Override
            public Iterable<Change<T, D>> changed() {
                return Iterators.map(adapterDiff.changed(), ch -> new Change<T, D>(){
                    final /* synthetic */ Change val$ch;
                    {
                        this.val$ch = change;
                    }

                    @Override
                    public T getPast() {
                        return ((DiffCapable.Adapter)this.val$ch.getPast()).getValue();
                    }

                    @Override
                    public T getNow() {
                        return ((DiffCapable.Adapter)this.val$ch.getNow()).getValue();
                    }

                    @Override
                    public D getDiff() {
                        return this.val$ch.getDiff();
                    }
                });
            }

            @Override
            public boolean unchanged() {
                return adapterDiff.unchanged();
            }
        };
    }

    public static <T extends DiffCapable<T, D>, D extends Difference> Specifier<T, D> deepDiff(final @Nullable Iterable<T> past, final @Nullable Iterable<T> now) {
        if (Iterators.isEmpty(past)) {
            if (Iterators.isEmpty(now)) {
                return new Specifier<T, D>(){

                    @Override
                    public boolean unchanged() {
                        return true;
                    }
                };
            }
            return new Specifier<T, D>(){

                @Override
                public Iterable<T> added() {
                    return now;
                }

                @Override
                public boolean unchanged() {
                    return false;
                }
            };
        }
        if (Iterators.isEmpty(now)) {
            return new Specifier<T, D>(){

                @Override
                public Iterable<T> removed() {
                    return past;
                }

                @Override
                public boolean unchanged() {
                    return false;
                }
            };
        }
        Set pastSet = (Set)Iterators.collect(past, Containers.createCustomPolicySet(DiffCapable::isSame, DiffCapable::diffHashCode));
        Set nowSet = (Set)Iterators.collect(now, Containers.createCustomPolicySet(DiffCapable::isSame, DiffCapable::diffHashCode));
        final Iterable added = Iterators.lazy(() -> Iterators.collect((Iterable)Iterators.filter((Iterable)nowSet, obj -> !pastSet.contains(obj)), new ArrayList()));
        final Iterable removed = Iterators.lazy(() -> Iterators.collect((Iterable)Iterators.filter((Iterable)pastSet, obj -> !nowSet.contains(obj)), new ArrayList()));
        final Iterable changed = Iterators.lazy(() -> {
            Map<DiffCapable, DiffCapable> nowMap = Containers.createCustomPolicyMap(DiffCapable::isSame, DiffCapable::diffHashCode);
            for (DiffCapable s : nowSet) {
                if (!pastSet.contains(s)) continue;
                nowMap.put(s, s);
            }
            ArrayList result = new ArrayList(0);
            for (DiffCapable before : pastSet) {
                Object diff;
                DiffCapable after = (DiffCapable)nowMap.get(before);
                if (after == null || (diff = after.difference(before)).unchanged()) continue;
                result.add(Change.create(before, after, diff));
            }
            return result;
        });
        return new Specifier<T, D>(){

            @Override
            public Iterable<T> added() {
                return added;
            }

            @Override
            public Iterable<T> removed() {
                return removed;
            }

            @Override
            public Iterable<Change<T, D>> changed() {
                return changed;
            }
        };
    }

    public static interface Specifier<T, D extends Difference> {
        default public Iterable<T> added() {
            return Collections.emptySet();
        }

        default public Iterable<T> removed() {
            return Collections.emptySet();
        }

        default public Iterable<Change<T, D>> changed() {
            return Collections.emptySet();
        }

        default public boolean unchanged() {
            return Iterators.isEmpty(this.added()) && Iterators.isEmpty(this.removed()) && Iterators.isEmpty(this.changed());
        }
    }

    public static interface Change<T, D extends Difference> {
        public T getPast();

        public T getNow();

        public D getDiff();

        public static <T, D extends Difference> Change<T, D> create(final T past, final T now, final D diff) {
            return new Change<T, D>(){

                @Override
                public T getPast() {
                    return past;
                }

                @Override
                public T getNow() {
                    return now;
                }

                @Override
                public D getDiff() {
                    return diff;
                }
            };
        }
    }
}

