/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeAbbreviation;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.types.impl.IrStarProjectionImpl;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0001*\u00020\u0001\u001a\u0014\u0010\u0003\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\f\u0010\u0000\u001a\u00020\u0007*\u00020\u0007H\u0002\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\r"}, d2={"eraseTypeParameters", "Lorg/jetbrains/kotlin/ir/types/IrType;", "eraseIfTypeParameter", "erasedType", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "isNullable", "", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "erasedUpperBound", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getErasedUpperBound", "(Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrTypeErasureUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeErasureUtils.kt\norg/jetbrains/kotlin/ir/util/IrTypeErasureUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1#2:99\n1563#3:100\n1634#3,3:101\n*S KotlinDebug\n*F\n+ 1 IrTypeErasureUtils.kt\norg/jetbrains/kotlin/ir/util/IrTypeErasureUtilsKt\n*L\n41#1:100\n41#1:101,3\n*E\n"})
public final class IrTypeErasureUtilsKt {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final IrType eraseTypeParameters(@NotNull IrType $this$eraseTypeParameters) {
        IrType irType;
        Intrinsics.checkNotNullParameter($this$eraseTypeParameters, "<this>");
        IrType irType2 = $this$eraseTypeParameters;
        if (irType2 instanceof IrSimpleType) {
            IrSymbolOwner owner = ((IrSimpleType)$this$eraseTypeParameters).getClassifier().getOwner();
            if (owner instanceof IrScript) {
                boolean bl = ((IrSimpleType)$this$eraseTypeParameters).getArguments().isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-IrTypeErasureUtilsKt$eraseTypeParameters$22 = false;
                    String $i$a$-assert-IrTypeErasureUtilsKt$eraseTypeParameters$22 = "Script can't be generic: " + RenderIrElementKt.render$default(owner, null, 1, null);
                    throw new AssertionError((Object)$i$a$-assert-IrTypeErasureUtilsKt$eraseTypeParameters$22);
                }
                irType = new IrSimpleTypeImpl(((IrSimpleType)$this$eraseTypeParameters).getClassifier(), ((IrSimpleType)$this$eraseTypeParameters).getNullability(), CollectionsKt.emptyList(), $this$eraseTypeParameters.getAnnotations(), null, 16, null);
                return irType;
            } else if (owner instanceof IrClass) {
                Collection<IrTypeArgument> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = ((IrSimpleType)$this$eraseTypeParameters).getArguments();
                SimpleTypeNullability simpleTypeNullability = ((IrSimpleType)$this$eraseTypeParameters).getNullability();
                IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$eraseTypeParameters).getClassifier();
                boolean $i$f$map = false;
                void var5_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(IrTypeErasureUtilsKt.eraseTypeParameters((IrTypeArgument)it));
                }
                collection = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n2 = 16;
                IrTypeAbbreviation irTypeAbbreviation = null;
                List<IrConstructorCall> list = $this$eraseTypeParameters.getAnnotations();
                List list2 = collection;
                SimpleTypeNullability simpleTypeNullability2 = simpleTypeNullability;
                IrClassifierSymbol irClassifierSymbol2 = irClassifierSymbol;
                irType = new IrSimpleTypeImpl(irClassifierSymbol2, simpleTypeNullability2, list2, list, irTypeAbbreviation, n2, defaultConstructorMarker);
                return irType;
            } else {
                if (!(owner instanceof IrTypeParameter)) throw new IllegalStateException(("Unknown IrSimpleType classifier kind: " + owner).toString());
                irType = IrTypeErasureUtilsKt.erasedType((IrTypeParameter)owner, IrTypeUtilsKt.isNullable($this$eraseTypeParameters));
            }
            return irType;
        } else {
            if (!(irType2 instanceof IrErrorType)) throw new IllegalStateException(("Unknown IrType kind: " + $this$eraseTypeParameters).toString());
            irType = $this$eraseTypeParameters;
        }
        return irType;
    }

    @NotNull
    public static final IrType eraseIfTypeParameter(@NotNull IrType $this$eraseIfTypeParameter) {
        Intrinsics.checkNotNullParameter($this$eraseIfTypeParameter, "<this>");
        Object object = $this$eraseIfTypeParameter instanceof IrSimpleType ? (IrSimpleType)$this$eraseIfTypeParameter : null;
        IrSymbolOwner irSymbolOwner = object != null && (object = ((IrSimpleType)object).getClassifier()) != null ? object.getOwner() : null;
        IrTypeParameter irTypeParameter = irSymbolOwner instanceof IrTypeParameter ? (IrTypeParameter)irSymbolOwner : null;
        if (irTypeParameter == null) {
            return $this$eraseIfTypeParameter;
        }
        IrTypeParameter typeParameter = irTypeParameter;
        return IrTypeErasureUtilsKt.erasedType(typeParameter, IrTypeUtilsKt.isNullable($this$eraseIfTypeParameter));
    }

    private static final IrType erasedType(IrTypeParameter $this$erasedType, boolean isNullable) {
        ArrayList<IrStarProjectionImpl> arrayList;
        IrClass upperBound = IrTypeErasureUtilsKt.getErasedUpperBound($this$erasedType);
        int n2 = upperBound.getTypeParameters().size();
        boolean bl = isNullable;
        IrClassifierSymbol irClassifierSymbol = upperBound.getSymbol();
        ArrayList<IrStarProjectionImpl> arrayList2 = new ArrayList<IrStarProjectionImpl>(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = n4 = n3++;
            arrayList = arrayList2;
            boolean bl2 = false;
            arrayList.add(IrStarProjectionImpl.INSTANCE);
        }
        arrayList = arrayList2;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n6 = 16;
        IrTypeAbbreviation irTypeAbbreviation = null;
        List<IrConstructorCall> list = $this$erasedType.getAnnotations();
        ArrayList<IrStarProjectionImpl> arrayList3 = arrayList;
        boolean bl3 = bl;
        IrClassifierSymbol irClassifierSymbol2 = irClassifierSymbol;
        return new IrSimpleTypeImpl(irClassifierSymbol2, bl3, arrayList3, list, irTypeAbbreviation, n6, defaultConstructorMarker);
    }

    private static final IrTypeArgument eraseTypeParameters(IrTypeArgument $this$eraseTypeParameters) {
        IrTypeArgument irTypeArgument;
        IrTypeArgument irTypeArgument2 = $this$eraseTypeParameters;
        if (irTypeArgument2 instanceof IrStarProjection) {
            irTypeArgument = $this$eraseTypeParameters;
        } else if (irTypeArgument2 instanceof IrTypeProjection) {
            irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(IrTypeErasureUtilsKt.eraseTypeParameters(((IrTypeProjection)$this$eraseTypeParameters).getType()), ((IrTypeProjection)$this$eraseTypeParameters).getVariance());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irTypeArgument;
    }

    @NotNull
    public static final IrClass getErasedUpperBound(@NotNull IrTypeParameter $this$erasedUpperBound) {
        Intrinsics.checkNotNullParameter($this$erasedUpperBound, "<this>");
        for (IrType type : $this$erasedUpperBound.getSuperTypes()) {
            Object irClass;
            Object object = IrTypesKt.getClassOrNull(type);
            if (object == null) continue;
            if ((object = (IrClass)object.getOwner()) == null || IrUtilsKt.isInterface((IrClass)(irClass = object)) || IrUtilsKt.isAnnotationClass((IrClass)irClass)) continue;
            return irClass;
        }
        return IrTypeErasureUtilsKt.getErasedUpperBound(CollectionsKt.first($this$erasedUpperBound.getSuperTypes()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final IrClass getErasedUpperBound(@NotNull IrType $this$erasedUpperBound) {
        Object object;
        Intrinsics.checkNotNullParameter($this$erasedUpperBound, "<this>");
        IrType irType = $this$erasedUpperBound;
        if (!(irType instanceof IrSimpleType)) {
            if (!(irType instanceof IrErrorType)) throw new IllegalStateException(RenderIrElementKt.render$default($this$erasedUpperBound, null, 1, null).toString());
            object = (IrClass)((IrErrorType)$this$erasedUpperBound).getSymbol().getOwner();
            return object;
        }
        IrSymbolOwner classifier = ((IrSimpleType)$this$erasedUpperBound).getClassifier().getOwner();
        if (classifier instanceof IrClass) {
            object = (IrClass)classifier;
            return object;
        }
        if (classifier instanceof IrTypeParameter) {
            object = IrTypeErasureUtilsKt.getErasedUpperBound((IrTypeParameter)classifier);
            return object;
        }
        if (!(classifier instanceof IrScript)) throw new IllegalStateException(RenderIrElementKt.render$default((IrSimpleType)$this$erasedUpperBound, null, 1, null).toString());
        IrClassSymbol irClassSymbol = ((IrScript)classifier).getTargetClass();
        object = irClassSymbol;
        if (irClassSymbol == null) throw new IllegalStateException(RenderIrElementKt.render$default((IrSimpleType)$this$erasedUpperBound, null, 1, null).toString());
        IrClass irClass = (IrClass)object.getOwner();
        object = irClass;
        if (irClass != null) return object;
        throw new IllegalStateException(RenderIrElementKt.render$default((IrSimpleType)$this$erasedUpperBound, null, 1, null).toString());
    }
}

